/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.dialect;

import com.google.common.base.Preconditions;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.config.NullCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.dialect.MysqlSqlDialect;
import org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.util.RelToSqlConverterUtil;

public class PrestoSqlDialect
extends SqlDialect {
    public static final SqlDialect.Context DEFAULT_CONTEXT = SqlDialect.EMPTY_CONTEXT.withDatabaseProduct(SqlDialect.DatabaseProduct.PRESTO).withIdentifierQuoteString("\"").withUnquotedCasing(Casing.UNCHANGED).withNullCollation(NullCollation.LOW);
    public static final SqlDialect DEFAULT = new PrestoSqlDialect(DEFAULT_CONTEXT);

    public PrestoSqlDialect(SqlDialect.Context context) {
        super(context);
    }

    @Override
    public boolean supportsCharSet() {
        return false;
    }

    @Override
    public boolean requiresAliasForFromItems() {
        return true;
    }

    @Override
    public void unparseOffsetFetch(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        this.unparseUsingLimit(writer, offset, fetch);
    }

    private void unparseUsingLimit(SqlWriter writer, SqlNode offset, SqlNode fetch) {
        Preconditions.checkArgument(fetch != null || offset != null);
        this.unparseOffset(writer, offset);
        this.unparseLimit(writer, fetch);
    }

    @Override
    public SqlNode emulateNullDirection(SqlNode node, boolean nullsFirst, boolean desc) {
        return this.emulateNullDirectionWithIsNull(node, nullsFirst, desc);
    }

    @Override
    public boolean supportsAggregateFunction(SqlKind kind) {
        switch (kind) {
            case AVG: 
            case COUNT: 
            case CUBE: 
            case SUM: 
            case MIN: 
            case MAX: 
            case ROLLUP: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean supportsGroupByWithCube() {
        return true;
    }

    @Override
    public boolean supportsNestedAggregations() {
        return false;
    }

    @Override
    public boolean supportsGroupByWithRollup() {
        return true;
    }

    @Override
    public SqlDialect.CalendarPolicy getCalendarPolicy() {
        return SqlDialect.CalendarPolicy.SHIFT;
    }

    @Override
    public SqlNode getCastSpec(RelDataType type) {
        return super.getCastSpec(type);
    }

    @Override
    public void unparseCall(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        if (call.getOperator() == SqlStdOperatorTable.SUBSTRING) {
            RelToSqlConverterUtil.specialOperatorByName("SUBSTR").unparse(writer, call, 0, 0);
        } else {
            PostgresqlSqlDialect.DEFAULT.unparseCall(writer, call, leftPrec, rightPrec);
        }
    }

    @Override
    public void unparseSqlIntervalQualifier(SqlWriter writer, SqlIntervalQualifier qualifier, RelDataTypeSystem typeSystem) {
        MysqlSqlDialect.DEFAULT.unparseSqlIntervalQualifier(writer, qualifier, typeSystem);
    }
}

