/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.uzaygezen.core.Assessment;
import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.Content;
import com.google.uzaygezen.core.NodeValue;
import com.google.uzaygezen.core.Pow2LengthBitSetRange;
import com.google.uzaygezen.core.RegionInspector;
import com.google.uzaygezen.core.SpatialRelation;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class MapRegionInspector<T, V extends Content<V>>
implements RegionInspector<T, V> {
    private static final Logger logger = Logger.getLogger(MapRegionInspector.class.getName());
    private final RegionInspector<T, V> delegate;
    private final Map<Pow2LengthBitSetRange, NodeValue<V>> rolledupMap;
    private final Map<BitVector, V> cacheHits;
    private Deque<StackElement<V>> stack = new ArrayDeque<StackElement<V>>();
    private final V zero;
    private final V one;

    private MapRegionInspector(Map<Pow2LengthBitSetRange, NodeValue<V>> rolledupMap, RegionInspector<T, V> delegate, boolean disguiseCacheHits, V zero, V one) {
        this.rolledupMap = Preconditions.checkNotNull(rolledupMap, "rolledupMap");
        this.delegate = Preconditions.checkNotNull(delegate, "delegate");
        this.cacheHits = disguiseCacheHits ? new HashMap() : null;
        logger.info("disguiseCacheHits=" + disguiseCacheHits);
        this.zero = zero;
        this.one = one;
    }

    public static <T, V extends Content<V>> MapRegionInspector<T, V> create(Map<Pow2LengthBitSetRange, NodeValue<V>> rolledupMap, RegionInspector<T, V> delegate, boolean disguiseCacheHits, V zero, V one) {
        return new MapRegionInspector<T, V>(rolledupMap, delegate, disguiseCacheHits, zero, one);
    }

    @Override
    public int getNumberOfDimensions() {
        return this.delegate.getNumberOfDimensions();
    }

    @Override
    public Assessment<T, V> assess(Pow2LengthBitSetRange indexRange, List<Pow2LengthBitSetRange> orthotope) {
        Assessment result;
        StackElement<V> top;
        Preconditions.checkState(!this.stack.isEmpty() || indexRange.getStart().isEmpty());
        while ((top = this.stack.peek()) != null && !((StackElement)top).range.encloses(indexRange)) {
            this.stack.pop();
        }
        NodeValue<V> value = this.rolledupMap.get(indexRange);
        if (value != null) {
            assert (this.stack.isEmpty() || ((StackElement)this.stack.peek()).range.encloses(indexRange) & !((StackElement)this.stack.peek()).leaf);
            Preconditions.checkState(!((Content)value.getValue()).isZero());
            this.stack.push(new StackElement<Content>(indexRange.clone(), (Content)value.getValue(), value.isLeaf()));
            Assessment<T, V> localResult = this.delegateAssessment(indexRange, orthotope);
            if (this.cacheHits != null && localResult.getOutcome() == SpatialRelation.COVERED && !localResult.isPotentialOverSelectivity()) {
                if (indexRange.getLevel() != 0) {
                    result = Assessment.makeOverlaps(this.zero);
                } else {
                    Content old = (Content)this.cacheHits.put(indexRange.getStart().clone(), ((Content)value.getValue()).clone());
                    Preconditions.checkState(old == null);
                    Preconditions.checkState(((Content)value.getValue()).isOne());
                    result = Assessment.makeDisjoint(value.getValue());
                }
            } else {
                result = localResult;
            }
        } else if (this.rolledupMap.isEmpty()) {
            result = Assessment.makeDisjoint(this.zero);
        } else {
            assert (((StackElement)this.stack.peek()).range.encloses(indexRange));
            result = ((StackElement)this.stack.peek()).leaf ? this.delegateAssessment(indexRange, orthotope) : Assessment.makeDisjoint(this.zero);
        }
        return result;
    }

    private Assessment<T, V> delegateAssessment(Pow2LengthBitSetRange indexRange, List<Pow2LengthBitSetRange> orthotope) {
        assert (indexRange.getLevel() <= ((StackElement)this.stack.peek()).range.getLevel());
        Assessment<T, V> delegateAssessment = this.delegate.assess(indexRange, orthotope);
        if (delegateAssessment.getOutcome() == SpatialRelation.DISJOINT && !((Content)delegateAssessment.getEstimate()).isZero() & !((Content)delegateAssessment.getEstimate()).isOne()) {
            Content quotient = (Content)((StackElement)this.stack.peek()).value.clone();
            quotient.shiftRight(((StackElement)this.stack.peek()).range.getLevel() - indexRange.getLevel());
            if (!quotient.isZero()) {
                if (((Content)delegateAssessment.getEstimate()).compareTo(quotient) > 0) {
                    return Assessment.makeDisjoint(quotient);
                }
            } else {
                return Assessment.makeDisjoint(this.one);
            }
        }
        return delegateAssessment;
    }

    public Map<BitVector, V> getDisguisedCacheHits() {
        return this.cacheHits == null ? ImmutableMap.of() : this.cacheHits;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private static class StackElement<V extends Content<V>> {
        private final Pow2LengthBitSetRange range;
        private final V value;
        private final boolean leaf;

        public StackElement(Pow2LengthBitSetRange range, V value, boolean leaf) {
            this.range = range;
            this.value = value;
            this.leaf = leaf;
        }
    }
}

