/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.BitSetComparator;
import com.google.uzaygezen.core.BitVector;
import com.google.uzaygezen.core.MathUtils;
import java.math.BigInteger;
import java.util.BitSet;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public final class LongBitVector
implements BitVector,
Cloneable {
    private static final long WORD_MASK = -1L;
    private static final int BITS_PER_WORD = 64;
    private final int size;
    private final long mask;
    private long data;

    public LongBitVector(int size) {
        this(size, 0L);
        Preconditions.checkArgument(size >= 0 && size <= 64, "Size must be positive and <= {1} size: {2}", new Object[]{64, size});
    }

    private LongBitVector(int size, long data) {
        assert (64 - Long.numberOfLeadingZeros(data) <= size);
        this.size = size;
        this.data = data;
        this.mask = size == 0 ? 0L : -1L >>> 64 - size;
    }

    private void checkSize(BitVector other) {
        if (this.size != other.size()) {
            throw new IllegalArgumentException("Sizes must be equal. " + this.size + " : " + other.size());
        }
    }

    private void checkIndex(int bitIndex) {
        if (bitIndex < 0 | bitIndex >= this.size) {
            throw new IndexOutOfBoundsException("Bit index out of range: " + bitIndex);
        }
    }

    private void checkBounds(int fromIndex, int toIndex) {
        if (fromIndex < 0 | toIndex > this.size | fromIndex > toIndex) {
            throw new IndexOutOfBoundsException("Range [" + fromIndex + ", " + toIndex + ") is invalid for this bit vector");
        }
    }

    @Override
    public void and(BitVector o) {
        this.checkSize(o);
        this.data &= o.toExactLong();
    }

    @Override
    public void andNot(BitVector o) {
        this.checkSize(o);
        this.data &= o.toExactLong() ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public int cardinality() {
        return Long.bitCount(this.data);
    }

    @Override
    public void clear() {
        this.data = 0L;
    }

    @Override
    public void clear(int bitIndex) {
        this.checkIndex(bitIndex);
        this.data &= 1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void clear(int fromIndex, int toIndex) {
        this.checkBounds(fromIndex, toIndex);
        if (fromIndex != toIndex) {
            this.unsafeClearNonEmptySection(fromIndex, toIndex);
        }
    }

    private void unsafeClearNonEmptySection(int fromIndex, int toIndex) {
        this.data &= -1L << fromIndex & -1L >>> -toIndex ^ 0xFFFFFFFFFFFFFFFFL;
    }

    @Override
    public void copyFrom(BitVector from) {
        this.checkSize(from);
        this.data = from.toExactLong();
    }

    @Override
    public void flip(int bitIndex) {
        this.checkIndex(bitIndex);
        this.data ^= 1L << bitIndex;
    }

    @Override
    public void flip(int fromIndex, int toIndex) {
        this.checkBounds(fromIndex, toIndex);
        if (fromIndex != toIndex) {
            this.data ^= -1L << fromIndex & -1L >>> -toIndex;
        }
    }

    @Override
    public boolean get(int bitIndex) {
        this.checkIndex(bitIndex);
        return this.unsafeGet(bitIndex);
    }

    private boolean unsafeGet(int bitIndex) {
        return (this.data & 1L << bitIndex) != 0L;
    }

    @Override
    public void grayCode() {
        this.data ^= this.data >>> 1;
    }

    @Override
    public void grayCodeInverse() {
        long localData = this.data;
        localData ^= localData >>> 1;
        localData ^= localData >>> 2;
        localData ^= localData >>> 4;
        localData ^= localData >>> 8;
        localData ^= localData >>> 16;
        localData ^= localData >>> 32;
        this.data = localData;
    }

    @Override
    public boolean increment() {
        if (this.data == this.mask) {
            return false;
        }
        ++this.data;
        return true;
    }

    @Override
    public boolean intersects(BitVector o) {
        this.checkSize(o);
        return (this.data & o.toExactLong()) != 0L;
    }

    @Override
    public int length() {
        return 64 - Long.numberOfLeadingZeros(this.data);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int nextClearBit(int fromIndex) {
        Preconditions.checkArgument(fromIndex >= 0);
        if (fromIndex >= this.size) {
            return -1;
        }
        long w = (this.data ^ 0xFFFFFFFFFFFFFFFFL) & -1L << fromIndex;
        int tcb = Long.numberOfTrailingZeros(w);
        return tcb == this.size ? -1 : tcb;
    }

    @Override
    public int nextSetBit(int fromIndex) {
        Preconditions.checkArgument(fromIndex >= 0);
        if (fromIndex >= this.size) {
            return -1;
        }
        long w = this.data & -1L << fromIndex;
        int tcb = Long.numberOfTrailingZeros(w);
        return tcb == 64 ? -1 : tcb;
    }

    @Override
    public void or(BitVector o) {
        this.checkSize(o);
        this.data |= o.toExactLong();
    }

    @Override
    public void rotate(int count) {
        int localSize = this.size;
        long localData = this.data;
        this.data = (count %= localSize) > 0 ? (localData >>> count | localData << localSize - count) & this.mask : (localData >>> localSize + count | localData << -count) & this.mask;
    }

    @Override
    public void set(int bitIndex) {
        this.checkIndex(bitIndex);
        this.data |= 1L << bitIndex;
    }

    @Override
    public void set(int bitIndex, boolean value) {
        if (value) {
            this.set(bitIndex);
        } else {
            this.clear(bitIndex);
        }
    }

    @Override
    public void set(int fromIndex, int toIndex) {
        this.checkBounds(fromIndex, toIndex);
        if (fromIndex != toIndex) {
            this.data |= -1L << fromIndex & -1L >>> -toIndex;
        }
    }

    @Override
    public void set(int fromIndex, int toIndex, boolean value) {
        if (value) {
            this.set(fromIndex, toIndex);
        } else {
            this.clear(fromIndex, toIndex);
        }
    }

    @Override
    public void xor(BitVector o) {
        this.checkSize(o);
        this.data ^= o.toExactLong();
    }

    @Override
    public boolean isEmpty() {
        return this.data == 0L;
    }

    @Override
    public LongBitVector clone() {
        try {
            return (LongBitVector)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("Cloning error. ");
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof BitVector) {
            BitVector other = (BitVector)obj;
            if (this.size <= 64) {
                return this.size == other.size() && this.data == other.toExactLong();
            }
            return this.size == other.size() && this.toBitSet().equals(other.toBitSet());
        }
        return false;
    }

    @Override
    public int hashCode() {
        long h2 = 0x4D2L ^ this.data;
        int bitSetHashCode = (int)(h2 >> 32 ^ h2);
        return this.size + 31 * bitSetHashCode;
    }

    public String toString() {
        return StringUtils.leftPad(Long.toBinaryString(this.data), this.size, '0');
    }

    @Override
    public BitSet toBitSet() {
        BitSet b = new BitSet(this.size);
        for (int i = 0; i < this.size; ++i) {
            if (!this.unsafeGet(i)) continue;
            b.set(i);
        }
        return b;
    }

    @Override
    public long toLong() {
        return this.data;
    }

    @Override
    public BigInteger toBigInteger() {
        BigInteger result;
        if (this.data >= 0L) {
            result = BigInteger.valueOf(this.data);
        } else {
            BigInteger missingLowestBit = BigInteger.valueOf(this.data >>> 1).shiftLeft(1);
            result = (this.data & 1L) == 1L ? missingLowestBit.setBit(0) : missingLowestBit;
        }
        return result;
    }

    @Override
    public void copyFrom(long value) {
        Preconditions.checkArgument(64 - Long.numberOfLeadingZeros(value) <= this.size, "value doesn't fit");
        this.data = value;
    }

    @Override
    public int compareTo(BitVector o) {
        int cmp;
        this.checkSize(o);
        if (o.size() <= 64) {
            long x = this.data + Long.MIN_VALUE;
            long y = o.toExactLong() + Long.MIN_VALUE;
            cmp = Long.compare(x, y);
            assert (Integer.signum(cmp) == Integer.signum(BitSetComparator.INSTANCE.compare(this.toBitSet(), o.toBitSet())));
        } else {
            cmp = BitSetComparator.INSTANCE.compare(this.toBitSet(), o.toBitSet());
        }
        return cmp;
    }

    @Override
    public void copyFrom(BitSet from) {
        int localSize = this.size;
        long value = 0L;
        int i = from.nextSetBit(0);
        while (i != -1) {
            Preconditions.checkArgument(i < localSize, "bit set too large");
            value |= 1L << i;
            i = from.nextSetBit(i + 1);
        }
        this.data = value;
    }

    @Override
    public void copyFromSection(BitVector src, int fromIndex) {
        long value;
        Preconditions.checkArgument(fromIndex >= 0, "fromIndex must be non-negative");
        int srcSize = src.size();
        int toIndex = fromIndex + this.size;
        Preconditions.checkArgument(toIndex <= srcSize, "not enough bits in src");
        if (toIndex <= 64) {
            long srcData = src.toLong();
            value = srcData >>> fromIndex & this.mask;
        } else {
            value = 0L;
            int i = src.nextSetBit(fromIndex);
            while (i < toIndex && i != -1) {
                value |= 1L << i - fromIndex;
                i = src.nextSetBit(i + 1);
            }
        }
        this.data = value;
    }

    @Override
    public long toExactLong() {
        return this.data;
    }

    @Override
    public void smallerEvenAndGrayCode() {
        long localData = this.data;
        if ((localData & 1L) == 1L) {
            assert (this.size > 0);
            this.data = localData ^ localData >>> 1 ^ 1L;
        } else if (localData != 0L) {
            long dataMinusTwo = localData - 2L;
            this.data = dataMinusTwo ^ dataMinusTwo >>> 1;
        }
    }

    @Override
    public void grayCodeRank(BitVector mu, BitVector w) {
        this.grayCodeRank(mu, w, true);
    }

    void grayCodeRank(BitVector mu, BitVector w, boolean optimiseIfPossible) {
        int theirSize = mu.size();
        Preconditions.checkArgument(theirSize == w.size(), "mu/w size mismatch");
        int muLen = mu.length();
        long pow2pos = 1L;
        long value = 0L;
        if (optimiseIfPossible & muLen <= 64) {
            long muLong = mu.toExactLong();
            long wLong = w.toLong();
            long pow2i = 1L;
            for (int i = 0; i < muLen; ++i) {
                if ((muLong & pow2i) != 0L) {
                    if ((wLong & pow2i) != 0L) {
                        value |= pow2pos;
                    }
                    pow2pos <<= 1;
                }
                pow2i <<= 1;
            }
        } else {
            int j;
            int n = j = theirSize == 0 ? -1 : mu.nextSetBit(0);
            while (j != -1) {
                if (w.get(j)) {
                    value |= pow2pos;
                }
                pow2pos <<= 1;
                j = j == theirSize - 1 ? -1 : mu.nextSetBit(j + 1);
            }
        }
        assert (pow2pos == 1L << mu.cardinality());
        Preconditions.checkArgument(1L << this.size == pow2pos, "wrong size");
        this.data = value;
    }

    @Override
    public int lowestDifferentBit() {
        long localData = this.data;
        int value = (localData & 1L) == 0L ? (localData == 0L ? 0 : Long.numberOfTrailingZeros(localData)) : (localData == this.mask ? 0 : Long.numberOfTrailingZeros(localData ^ 0xFFFFFFFFFFFFFFFFL));
        assert (value == 0 || 0 < value & value < this.size);
        return value;
    }

    @Override
    public void grayCodeRankInverse(BitVector mu, BitVector known, BitVector r) {
        int muSize = mu.size();
        Preconditions.checkArgument(this.size == muSize, "i/mu size mismatch");
        Preconditions.checkArgument(!known.intersects(mu), "known and mu must not intersect");
        long muLong = mu.toExactLong();
        long knownLong = known.toExactLong();
        int rSize = r.size();
        Preconditions.checkArgument(rSize <= muSize, "r is too large");
        long rLong = r.toExactLong();
        long value = 0L;
        int pos = 0;
        int muLength = mu.length();
        long pow2k = 1L;
        for (int k = 0; k < muLength; ++k) {
            if ((muLong & pow2k) != 0L) {
                if ((rLong >> pos & 1L) != 0L) {
                    value |= pow2k;
                }
                ++pos;
            }
            pow2k <<= 1;
        }
        assert (pos == mu.cardinality());
        Preconditions.checkArgument(pos == rSize, "r.size()/mu.cardinality() mismatch");
        int knownLength = known.length();
        int k = Math.max(muLength - 1, knownLength);
        while (--k >= 0) {
            pow2k = 1L << k;
            if ((muLong & pow2k) != 0L) continue;
            assert ((value & pow2k) == 0L);
            if ((knownLong & pow2k ^ value >> 1 & pow2k) == 0L) continue;
            value |= pow2k;
        }
        this.data = value;
    }

    @Override
    public void copySectionFrom(int offset, BitVector src) {
        int srcSize;
        int toIndex;
        if (offset < 0 | (toIndex = offset + (srcSize = src.size())) > this.size) {
            throw new IndexOutOfBoundsException("invalid range: offset=" + offset + " src.size()=" + src.size());
        }
        if (offset != toIndex) {
            this.unsafeClearNonEmptySection(offset, toIndex);
            long srcData = src.toExactLong();
            this.data |= srcData << offset;
        }
    }

    @Override
    public long[] toLongArray() {
        long[] lArray;
        if (this.size == 0) {
            lArray = ArrayUtils.EMPTY_LONG_ARRAY;
        } else {
            long[] lArray2 = new long[1];
            lArray = lArray2;
            lArray2[0] = this.data;
        }
        return lArray;
    }

    @Override
    public byte[] toBigEndianByteArray() {
        int n = MathUtils.bitCountToByteCount(this.size);
        byte[] a = new byte[n];
        long x = this.data;
        int i = 0;
        while (i < n) {
            a[n - ++i] = (byte)(x & 0xFFL);
            x >>>= 8;
        }
        assert (x == 0L);
        return a;
    }

    @Override
    public void copyFrom(long[] array) {
        if (this.size == 0) {
            Preconditions.checkArgument(array.length == 0, "Array must be empty.");
        } else {
            Preconditions.checkArgument(array.length == 1, "Array length must be 1.");
            this.copyFrom(array[0]);
        }
    }

    @Override
    public void copyFromBigEndian(byte[] array) {
        int n = MathUtils.bitCountToByteCount(this.size);
        Preconditions.checkArgument(array.length == n, "Array length must be %s.", new Object[]{n});
        long x = 0L;
        int i = 0;
        while (i < n - 1) {
            x |= (long)(array[i++] & 0xFF);
            x <<= 8;
        }
        if (n != 0) {
            x |= (long)(array[n - 1] & 0xFF);
        }
        this.copyFrom(x);
    }

    @Override
    public boolean areAllLowestBitsClear(int bitCount) {
        Preconditions.checkArgument(0 <= bitCount & bitCount <= this.size, "bitCount is out of range");
        return (this.data & (1L << bitCount ^ (long)(bitCount >> 6)) - 1L) == 0L;
    }

    @Override
    public void copyFrom(BigInteger s2) {
        Preconditions.checkArgument(s2.signum() >= 0, s2);
        Preconditions.checkArgument(s2.bitLength() <= this.size());
        this.copyFrom(s2.longValue());
    }
}

