/*
 * Decompiled with CFR 0.152.
 */
package com.google.uzaygezen.core;

import com.google.common.base.Preconditions;
import com.google.uzaygezen.core.BitVector;

public class BitVectorMath {
    private BitVectorMath() {
    }

    public static void split(BitVector bs, BitVector[] result) {
        int sum = 0;
        for (BitVector bv : result) {
            sum += bv.size();
        }
        Preconditions.checkArgument(sum == bs.size(), "size sum does not match");
        int startIndex = 0;
        int i = result.length;
        while (--i >= 0) {
            result[i].copyFromSection(bs, startIndex);
            startIndex += result[i].size();
        }
        Preconditions.checkArgument(startIndex >= bs.length(), "bit length is too high");
    }
}

