/*
 * Decompiled with CFR 0.152.
 */
package com.dask.sql.application;

import com.dask.sql.application.DaskSqlParserImplFactory;
import com.dask.sql.schema.DaskSchema;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.jdbc.CalciteConnection;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.rules.AggregateExpandDistinctAggregatesRule;
import org.apache.calcite.rel.rules.AggregateReduceFunctionsRule;
import org.apache.calcite.rel.rules.FilterAggregateTransposeRule;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.rules.FilterMergeRule;
import org.apache.calcite.rel.rules.FilterRemoveIsNotDistinctFromRule;
import org.apache.calcite.rel.rules.ProjectJoinTransposeRule;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rel.rules.ReduceExpressionsRule;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rex.RexExecutorImpl;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.dialect.PostgresqlSqlDialect;
import org.apache.calcite.sql.fun.SqlLibrary;
import org.apache.calcite.sql.fun.SqlLibraryOperatorTableFactory;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.util.SqlOperatorTables;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Frameworks;
import org.apache.calcite.tools.Planner;
import org.apache.calcite.tools.RelConversionException;
import org.apache.calcite.tools.ValidationException;

public class RelationalAlgebraGenerator {
    private Planner planner;
    private HepPlanner hepPlanner;

    public RelationalAlgebraGenerator(DaskSchema schema) throws ClassNotFoundException, SQLException {
        CalciteConnection calciteConnection = this.getCalciteConnection();
        calciteConnection.setSchema(schema.getName());
        SchemaPlus rootSchema = calciteConnection.getRootSchema();
        rootSchema.add(schema.getName(), schema);
        FrameworkConfig config = this.getConfig(rootSchema, schema.getName());
        this.planner = Frameworks.getPlanner(config);
        this.hepPlanner = this.getHepPlanner(config);
    }

    private FrameworkConfig getConfig(SchemaPlus rootSchema, String schemaName) {
        ArrayList<String> defaultSchema = new ArrayList<String>();
        defaultSchema.add(schemaName);
        Properties props = new Properties();
        props.setProperty("defaultSchema", schemaName);
        SchemaPlus schemaPlus = rootSchema.getSubSchema(schemaName);
        CalciteSchema calciteSchema = CalciteSchema.from(schemaPlus);
        CalciteCatalogReader calciteCatalogReader = new CalciteCatalogReader(calciteSchema, defaultSchema, new JavaTypeFactoryImpl(RelDataTypeSystem.DEFAULT), new CalciteConnectionConfigImpl(props));
        ArrayList<SqlOperatorTable> sqlOperatorTables = new ArrayList<SqlOperatorTable>();
        sqlOperatorTables.add(SqlStdOperatorTable.instance());
        sqlOperatorTables.add(SqlLibraryOperatorTableFactory.INSTANCE.getOperatorTable(SqlLibrary.POSTGRESQL));
        sqlOperatorTables.add(calciteCatalogReader);
        SqlParser.Config parserConfig = this.getDialect().configureParser(SqlParser.config().withParserFactory(new DaskSqlParserImplFactory()));
        SqlOperatorTable operatorTable = SqlOperatorTables.chain(sqlOperatorTables);
        return Frameworks.newConfigBuilder().defaultSchema(schemaPlus).parserConfig(parserConfig).executor(new RexExecutorImpl(null)).operatorTable(operatorTable).build();
    }

    public SqlDialect getDialect() {
        return PostgresqlSqlDialect.DEFAULT;
    }

    private CalciteConnection getCalciteConnection() throws SQLException {
        Properties info = new Properties();
        info.setProperty("lex", "JAVA");
        Connection connection = DriverManager.getConnection("jdbc:calcite:", info);
        return connection.unwrap(CalciteConnection.class);
    }

    private HepPlanner getHepPlanner(FrameworkConfig config) {
        HepProgram program = new HepProgramBuilder().addRuleInstance(AggregateExpandDistinctAggregatesRule.Config.JOIN.toRule()).addRuleInstance(FilterAggregateTransposeRule.Config.DEFAULT.toRule()).addRuleInstance(FilterJoinRule.JoinConditionPushRule.Config.DEFAULT.toRule()).addRuleInstance(FilterJoinRule.FilterIntoJoinRule.Config.DEFAULT.toRule()).addRuleInstance(ProjectMergeRule.Config.DEFAULT.toRule()).addRuleInstance(FilterMergeRule.Config.DEFAULT.toRule()).addRuleInstance(ProjectJoinTransposeRule.Config.DEFAULT.toRule()).addRuleInstance(ReduceExpressionsRule.ProjectReduceExpressionsRule.Config.DEFAULT.toRule()).addRuleInstance(FilterRemoveIsNotDistinctFromRule.Config.DEFAULT.toRule()).addRuleInstance(AggregateReduceFunctionsRule.Config.DEFAULT.toRule()).build();
        return new HepPlanner(program, config.getContext());
    }

    public SqlNode getSqlNode(String sql) throws SqlParseException {
        try {
            return this.planner.parse(sql);
        }
        catch (SqlParseException e) {
            this.planner.close();
            throw e;
        }
    }

    public SqlNode getValidatedNode(SqlNode sqlNode) throws ValidationException {
        try {
            return this.planner.validate(sqlNode);
        }
        catch (ValidationException e) {
            this.planner.close();
            throw e;
        }
    }

    public RelNode getRelationalAlgebra(SqlNode validatedSqlNode) throws RelConversionException {
        try {
            return this.planner.rel(validatedSqlNode).project(true);
        }
        catch (RelConversionException e) {
            this.planner.close();
            throw e;
        }
    }

    public RelNode getOptimizedRelationalAlgebra(RelNode nonOptimizedPlan) {
        this.hepPlanner.setRoot(nonOptimizedPlan);
        this.planner.close();
        return this.hepPlanner.findBestExp();
    }

    public String getRelationalAlgebraString(RelNode relNode) {
        return RelOptUtil.toString(relNode);
    }
}

