# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel


class AddHotlineNumberRequestOutboundRangeList(TeaModel):
    def __init__(self, department_id=None, group_id_list=None):
        self.department_id = department_id  # type: long
        self.group_id_list = group_id_list  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddHotlineNumberRequestOutboundRangeList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        return self


class AddHotlineNumberRequest(TeaModel):
    def __init__(self, description=None, enable_inbound=None, enable_inbound_evaluation=None, enable_outbound=None,
                 enable_outbound_evaluation=None, evaluation_level=None, hotline_number=None, inbound_flow_id=None, instance_id=None,
                 outbound_all_depart=None, outbound_range_list=None):
        self.description = description  # type: str
        self.enable_inbound = enable_inbound  # type: bool
        self.enable_inbound_evaluation = enable_inbound_evaluation  # type: bool
        self.enable_outbound = enable_outbound  # type: bool
        self.enable_outbound_evaluation = enable_outbound_evaluation  # type: bool
        self.evaluation_level = evaluation_level  # type: int
        self.hotline_number = hotline_number  # type: str
        self.inbound_flow_id = inbound_flow_id  # type: long
        self.instance_id = instance_id  # type: str
        self.outbound_all_depart = outbound_all_depart  # type: bool
        self.outbound_range_list = outbound_range_list  # type: list[AddHotlineNumberRequestOutboundRangeList]

    def validate(self):
        if self.outbound_range_list:
            for k in self.outbound_range_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(AddHotlineNumberRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.enable_inbound is not None:
            result['EnableInbound'] = self.enable_inbound
        if self.enable_inbound_evaluation is not None:
            result['EnableInboundEvaluation'] = self.enable_inbound_evaluation
        if self.enable_outbound is not None:
            result['EnableOutbound'] = self.enable_outbound
        if self.enable_outbound_evaluation is not None:
            result['EnableOutboundEvaluation'] = self.enable_outbound_evaluation
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.inbound_flow_id is not None:
            result['InboundFlowId'] = self.inbound_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_all_depart is not None:
            result['OutboundAllDepart'] = self.outbound_all_depart
        result['OutboundRangeList'] = []
        if self.outbound_range_list is not None:
            for k in self.outbound_range_list:
                result['OutboundRangeList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnableInbound') is not None:
            self.enable_inbound = m.get('EnableInbound')
        if m.get('EnableInboundEvaluation') is not None:
            self.enable_inbound_evaluation = m.get('EnableInboundEvaluation')
        if m.get('EnableOutbound') is not None:
            self.enable_outbound = m.get('EnableOutbound')
        if m.get('EnableOutboundEvaluation') is not None:
            self.enable_outbound_evaluation = m.get('EnableOutboundEvaluation')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InboundFlowId') is not None:
            self.inbound_flow_id = m.get('InboundFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundAllDepart') is not None:
            self.outbound_all_depart = m.get('OutboundAllDepart')
        self.outbound_range_list = []
        if m.get('OutboundRangeList') is not None:
            for k in m.get('OutboundRangeList'):
                temp_model = AddHotlineNumberRequestOutboundRangeList()
                self.outbound_range_list.append(temp_model.from_map(k))
        return self


class AddHotlineNumberShrinkRequest(TeaModel):
    def __init__(self, description=None, enable_inbound=None, enable_inbound_evaluation=None, enable_outbound=None,
                 enable_outbound_evaluation=None, evaluation_level=None, hotline_number=None, inbound_flow_id=None, instance_id=None,
                 outbound_all_depart=None, outbound_range_list_shrink=None):
        self.description = description  # type: str
        self.enable_inbound = enable_inbound  # type: bool
        self.enable_inbound_evaluation = enable_inbound_evaluation  # type: bool
        self.enable_outbound = enable_outbound  # type: bool
        self.enable_outbound_evaluation = enable_outbound_evaluation  # type: bool
        self.evaluation_level = evaluation_level  # type: int
        self.hotline_number = hotline_number  # type: str
        self.inbound_flow_id = inbound_flow_id  # type: long
        self.instance_id = instance_id  # type: str
        self.outbound_all_depart = outbound_all_depart  # type: bool
        self.outbound_range_list_shrink = outbound_range_list_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddHotlineNumberShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.enable_inbound is not None:
            result['EnableInbound'] = self.enable_inbound
        if self.enable_inbound_evaluation is not None:
            result['EnableInboundEvaluation'] = self.enable_inbound_evaluation
        if self.enable_outbound is not None:
            result['EnableOutbound'] = self.enable_outbound
        if self.enable_outbound_evaluation is not None:
            result['EnableOutboundEvaluation'] = self.enable_outbound_evaluation
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.inbound_flow_id is not None:
            result['InboundFlowId'] = self.inbound_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_all_depart is not None:
            result['OutboundAllDepart'] = self.outbound_all_depart
        if self.outbound_range_list_shrink is not None:
            result['OutboundRangeList'] = self.outbound_range_list_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnableInbound') is not None:
            self.enable_inbound = m.get('EnableInbound')
        if m.get('EnableInboundEvaluation') is not None:
            self.enable_inbound_evaluation = m.get('EnableInboundEvaluation')
        if m.get('EnableOutbound') is not None:
            self.enable_outbound = m.get('EnableOutbound')
        if m.get('EnableOutboundEvaluation') is not None:
            self.enable_outbound_evaluation = m.get('EnableOutboundEvaluation')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InboundFlowId') is not None:
            self.inbound_flow_id = m.get('InboundFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundAllDepart') is not None:
            self.outbound_all_depart = m.get('OutboundAllDepart')
        if m.get('OutboundRangeList') is not None:
            self.outbound_range_list_shrink = m.get('OutboundRangeList')
        return self


class AddHotlineNumberResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddHotlineNumberResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddHotlineNumberResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddHotlineNumberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddHotlineNumberResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddHotlineNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddOuterAccountRequest(TeaModel):
    def __init__(self, avatar=None, ext=None, outer_account_id=None, outer_account_name=None,
                 outer_account_type=None, outer_department_id=None, outer_department_type=None, outer_group_ids=None,
                 outer_group_type=None, real_name=None):
        self.avatar = avatar  # type: str
        self.ext = ext  # type: str
        self.outer_account_id = outer_account_id  # type: str
        self.outer_account_name = outer_account_name  # type: str
        self.outer_account_type = outer_account_type  # type: str
        self.outer_department_id = outer_department_id  # type: str
        self.outer_department_type = outer_department_type  # type: str
        self.outer_group_ids = outer_group_ids  # type: str
        self.outer_group_type = outer_group_type  # type: str
        self.real_name = real_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddOuterAccountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.avatar is not None:
            result['Avatar'] = self.avatar
        if self.ext is not None:
            result['Ext'] = self.ext
        if self.outer_account_id is not None:
            result['OuterAccountId'] = self.outer_account_id
        if self.outer_account_name is not None:
            result['OuterAccountName'] = self.outer_account_name
        if self.outer_account_type is not None:
            result['OuterAccountType'] = self.outer_account_type
        if self.outer_department_id is not None:
            result['OuterDepartmentId'] = self.outer_department_id
        if self.outer_department_type is not None:
            result['OuterDepartmentType'] = self.outer_department_type
        if self.outer_group_ids is not None:
            result['OuterGroupIds'] = self.outer_group_ids
        if self.outer_group_type is not None:
            result['OuterGroupType'] = self.outer_group_type
        if self.real_name is not None:
            result['RealName'] = self.real_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Avatar') is not None:
            self.avatar = m.get('Avatar')
        if m.get('Ext') is not None:
            self.ext = m.get('Ext')
        if m.get('OuterAccountId') is not None:
            self.outer_account_id = m.get('OuterAccountId')
        if m.get('OuterAccountName') is not None:
            self.outer_account_name = m.get('OuterAccountName')
        if m.get('OuterAccountType') is not None:
            self.outer_account_type = m.get('OuterAccountType')
        if m.get('OuterDepartmentId') is not None:
            self.outer_department_id = m.get('OuterDepartmentId')
        if m.get('OuterDepartmentType') is not None:
            self.outer_department_type = m.get('OuterDepartmentType')
        if m.get('OuterGroupIds') is not None:
            self.outer_group_ids = m.get('OuterGroupIds')
        if m.get('OuterGroupType') is not None:
            self.outer_group_type = m.get('OuterGroupType')
        if m.get('RealName') is not None:
            self.real_name = m.get('RealName')
        return self


class AddOuterAccountResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddOuterAccountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddOuterAccountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddOuterAccountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddOuterAccountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddOuterAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddSkillGroupRequest(TeaModel):
    def __init__(self, outer_department_id=None, outer_department_type=None, outer_group_id=None,
                 outer_group_name=None, outer_group_type=None):
        self.outer_department_id = outer_department_id  # type: str
        self.outer_department_type = outer_department_type  # type: str
        self.outer_group_id = outer_group_id  # type: str
        self.outer_group_name = outer_group_name  # type: str
        self.outer_group_type = outer_group_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outer_department_id is not None:
            result['OuterDepartmentId'] = self.outer_department_id
        if self.outer_department_type is not None:
            result['OuterDepartmentType'] = self.outer_department_type
        if self.outer_group_id is not None:
            result['OuterGroupId'] = self.outer_group_id
        if self.outer_group_name is not None:
            result['OuterGroupName'] = self.outer_group_name
        if self.outer_group_type is not None:
            result['OuterGroupType'] = self.outer_group_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OuterDepartmentId') is not None:
            self.outer_department_id = m.get('OuterDepartmentId')
        if m.get('OuterDepartmentType') is not None:
            self.outer_department_type = m.get('OuterDepartmentType')
        if m.get('OuterGroupId') is not None:
            self.outer_group_id = m.get('OuterGroupId')
        if m.get('OuterGroupName') is not None:
            self.outer_group_name = m.get('OuterGroupName')
        if m.get('OuterGroupType') is not None:
            self.outer_group_type = m.get('OuterGroupType')
        return self


class AddSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AddSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AddSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AddSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AddSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AiccsSmartCallRequest(TeaModel):
    def __init__(self, action_code_break=None, action_code_time_break=None, asr_als_am_id=None, asr_base_id=None,
                 asr_model_id=None, asr_vocabulary_id=None, background_file_code=None, background_speed=None,
                 background_volume=None, called_number=None, called_show_number=None, dynamic_id=None, early_media_asr=None,
                 enable_itn=None, mute_time=None, out_id=None, owner_id=None, pause_time=None, play_times=None, prod_code=None,
                 record_flag=None, resource_owner_account=None, resource_owner_id=None, session_timeout=None, speed=None,
                 tts_conf=None, tts_speed=None, tts_style=None, tts_volume=None, voice_code=None, voice_code_param=None,
                 volume=None):
        self.action_code_break = action_code_break  # type: bool
        self.action_code_time_break = action_code_time_break  # type: int
        self.asr_als_am_id = asr_als_am_id  # type: str
        self.asr_base_id = asr_base_id  # type: str
        self.asr_model_id = asr_model_id  # type: str
        self.asr_vocabulary_id = asr_vocabulary_id  # type: str
        self.background_file_code = background_file_code  # type: str
        self.background_speed = background_speed  # type: int
        self.background_volume = background_volume  # type: int
        self.called_number = called_number  # type: str
        self.called_show_number = called_show_number  # type: str
        self.dynamic_id = dynamic_id  # type: str
        self.early_media_asr = early_media_asr  # type: bool
        self.enable_itn = enable_itn  # type: bool
        self.mute_time = mute_time  # type: int
        self.out_id = out_id  # type: str
        self.owner_id = owner_id  # type: long
        self.pause_time = pause_time  # type: int
        self.play_times = play_times  # type: int
        self.prod_code = prod_code  # type: str
        self.record_flag = record_flag  # type: bool
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.session_timeout = session_timeout  # type: int
        self.speed = speed  # type: int
        self.tts_conf = tts_conf  # type: bool
        self.tts_speed = tts_speed  # type: int
        self.tts_style = tts_style  # type: str
        self.tts_volume = tts_volume  # type: int
        self.voice_code = voice_code  # type: str
        self.voice_code_param = voice_code_param  # type: str
        self.volume = volume  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(AiccsSmartCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_code_break is not None:
            result['ActionCodeBreak'] = self.action_code_break
        if self.action_code_time_break is not None:
            result['ActionCodeTimeBreak'] = self.action_code_time_break
        if self.asr_als_am_id is not None:
            result['AsrAlsAmId'] = self.asr_als_am_id
        if self.asr_base_id is not None:
            result['AsrBaseId'] = self.asr_base_id
        if self.asr_model_id is not None:
            result['AsrModelId'] = self.asr_model_id
        if self.asr_vocabulary_id is not None:
            result['AsrVocabularyId'] = self.asr_vocabulary_id
        if self.background_file_code is not None:
            result['BackgroundFileCode'] = self.background_file_code
        if self.background_speed is not None:
            result['BackgroundSpeed'] = self.background_speed
        if self.background_volume is not None:
            result['BackgroundVolume'] = self.background_volume
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.called_show_number is not None:
            result['CalledShowNumber'] = self.called_show_number
        if self.dynamic_id is not None:
            result['DynamicId'] = self.dynamic_id
        if self.early_media_asr is not None:
            result['EarlyMediaAsr'] = self.early_media_asr
        if self.enable_itn is not None:
            result['EnableITN'] = self.enable_itn
        if self.mute_time is not None:
            result['MuteTime'] = self.mute_time
        if self.out_id is not None:
            result['OutId'] = self.out_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pause_time is not None:
            result['PauseTime'] = self.pause_time
        if self.play_times is not None:
            result['PlayTimes'] = self.play_times
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.record_flag is not None:
            result['RecordFlag'] = self.record_flag
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.session_timeout is not None:
            result['SessionTimeout'] = self.session_timeout
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.tts_conf is not None:
            result['TtsConf'] = self.tts_conf
        if self.tts_speed is not None:
            result['TtsSpeed'] = self.tts_speed
        if self.tts_style is not None:
            result['TtsStyle'] = self.tts_style
        if self.tts_volume is not None:
            result['TtsVolume'] = self.tts_volume
        if self.voice_code is not None:
            result['VoiceCode'] = self.voice_code
        if self.voice_code_param is not None:
            result['VoiceCodeParam'] = self.voice_code_param
        if self.volume is not None:
            result['Volume'] = self.volume
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionCodeBreak') is not None:
            self.action_code_break = m.get('ActionCodeBreak')
        if m.get('ActionCodeTimeBreak') is not None:
            self.action_code_time_break = m.get('ActionCodeTimeBreak')
        if m.get('AsrAlsAmId') is not None:
            self.asr_als_am_id = m.get('AsrAlsAmId')
        if m.get('AsrBaseId') is not None:
            self.asr_base_id = m.get('AsrBaseId')
        if m.get('AsrModelId') is not None:
            self.asr_model_id = m.get('AsrModelId')
        if m.get('AsrVocabularyId') is not None:
            self.asr_vocabulary_id = m.get('AsrVocabularyId')
        if m.get('BackgroundFileCode') is not None:
            self.background_file_code = m.get('BackgroundFileCode')
        if m.get('BackgroundSpeed') is not None:
            self.background_speed = m.get('BackgroundSpeed')
        if m.get('BackgroundVolume') is not None:
            self.background_volume = m.get('BackgroundVolume')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CalledShowNumber') is not None:
            self.called_show_number = m.get('CalledShowNumber')
        if m.get('DynamicId') is not None:
            self.dynamic_id = m.get('DynamicId')
        if m.get('EarlyMediaAsr') is not None:
            self.early_media_asr = m.get('EarlyMediaAsr')
        if m.get('EnableITN') is not None:
            self.enable_itn = m.get('EnableITN')
        if m.get('MuteTime') is not None:
            self.mute_time = m.get('MuteTime')
        if m.get('OutId') is not None:
            self.out_id = m.get('OutId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PauseTime') is not None:
            self.pause_time = m.get('PauseTime')
        if m.get('PlayTimes') is not None:
            self.play_times = m.get('PlayTimes')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('RecordFlag') is not None:
            self.record_flag = m.get('RecordFlag')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SessionTimeout') is not None:
            self.session_timeout = m.get('SessionTimeout')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('TtsConf') is not None:
            self.tts_conf = m.get('TtsConf')
        if m.get('TtsSpeed') is not None:
            self.tts_speed = m.get('TtsSpeed')
        if m.get('TtsStyle') is not None:
            self.tts_style = m.get('TtsStyle')
        if m.get('TtsVolume') is not None:
            self.tts_volume = m.get('TtsVolume')
        if m.get('VoiceCode') is not None:
            self.voice_code = m.get('VoiceCode')
        if m.get('VoiceCodeParam') is not None:
            self.voice_code_param = m.get('VoiceCodeParam')
        if m.get('Volume') is not None:
            self.volume = m.get('Volume')
        return self


class AiccsSmartCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AiccsSmartCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AiccsSmartCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AiccsSmartCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AiccsSmartCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AiccsSmartCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AiccsSmartCallOperateRequest(TeaModel):
    def __init__(self, call_id=None, command=None, owner_id=None, param=None, prod_code=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.call_id = call_id  # type: str
        self.command = command  # type: str
        self.owner_id = owner_id  # type: long
        self.param = param  # type: str
        self.prod_code = prod_code  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AiccsSmartCallOperateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.command is not None:
            result['Command'] = self.command
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.param is not None:
            result['Param'] = self.param
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Param') is not None:
            self.param = m.get('Param')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class AiccsSmartCallOperateResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AiccsSmartCallOperateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AiccsSmartCallOperateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AiccsSmartCallOperateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AiccsSmartCallOperateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AiccsSmartCallOperateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AnswerCallRequest(TeaModel):
    def __init__(self, account_name=None, call_id=None, client_token=None, connection_id=None, instance_id=None,
                 job_id=None):
        self.account_name = account_name  # type: str
        self.call_id = call_id  # type: str
        self.client_token = client_token  # type: str
        self.connection_id = connection_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(AnswerCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class AnswerCallResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AnswerCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AnswerCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AnswerCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AnswerCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AnswerCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AttachTaskRequest(TeaModel):
    def __init__(self, call_string=None, owner_id=None, resource_owner_account=None, resource_owner_id=None,
                 task_id=None):
        self.call_string = call_string  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_string is not None:
            result['CallString'] = self.call_string
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallString') is not None:
            self.call_string = m.get('CallString')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class AttachTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(AttachTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class AttachTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: AttachTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(AttachTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AttachTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchCreateQualityProjectsRequest(TeaModel):
    def __init__(self, analysis_ids=None, channel_touch_type=None, check_freq_type=None, instance_list=None,
                 project_name=None, time_range_end=None, time_range_start=None):
        self.analysis_ids = analysis_ids  # type: list[long]
        self.channel_touch_type = channel_touch_type  # type: list[int]
        self.check_freq_type = check_freq_type  # type: int
        self.instance_list = instance_list  # type: list[str]
        self.project_name = project_name  # type: str
        self.time_range_end = time_range_end  # type: str
        self.time_range_start = time_range_start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCreateQualityProjectsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_ids is not None:
            result['AnalysisIds'] = self.analysis_ids
        if self.channel_touch_type is not None:
            result['ChannelTouchType'] = self.channel_touch_type
        if self.check_freq_type is not None:
            result['CheckFreqType'] = self.check_freq_type
        if self.instance_list is not None:
            result['InstanceList'] = self.instance_list
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.time_range_end is not None:
            result['TimeRangeEnd'] = self.time_range_end
        if self.time_range_start is not None:
            result['TimeRangeStart'] = self.time_range_start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnalysisIds') is not None:
            self.analysis_ids = m.get('AnalysisIds')
        if m.get('ChannelTouchType') is not None:
            self.channel_touch_type = m.get('ChannelTouchType')
        if m.get('CheckFreqType') is not None:
            self.check_freq_type = m.get('CheckFreqType')
        if m.get('InstanceList') is not None:
            self.instance_list = m.get('InstanceList')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('TimeRangeEnd') is not None:
            self.time_range_end = m.get('TimeRangeEnd')
        if m.get('TimeRangeStart') is not None:
            self.time_range_start = m.get('TimeRangeStart')
        return self


class BatchCreateQualityProjectsResponseBodyData(TeaModel):
    def __init__(self, instance_id=None, project_id=None, version=None):
        self.instance_id = instance_id  # type: str
        self.project_id = project_id  # type: long
        self.version = version  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(BatchCreateQualityProjectsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class BatchCreateQualityProjectsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[BatchCreateQualityProjectsResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(BatchCreateQualityProjectsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = BatchCreateQualityProjectsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class BatchCreateQualityProjectsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: BatchCreateQualityProjectsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(BatchCreateQualityProjectsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchCreateQualityProjectsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelTaskRequest(TeaModel):
    def __init__(self, owner_id=None, resource_owner_account=None, resource_owner_id=None, task_id=None):
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CancelTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CancelTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CancelTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CancelTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CancelTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeChatAgentStatusRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, instance_id=None, method=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str
        self.method = method  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeChatAgentStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.method is not None:
            result['Method'] = self.method
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Method') is not None:
            self.method = m.get('Method')
        return self


class ChangeChatAgentStatusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeChatAgentStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ChangeChatAgentStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ChangeChatAgentStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ChangeChatAgentStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeChatAgentStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeQualityProjectStatusRequest(TeaModel):
    def __init__(self, instance_id=None, project_id=None, status=None):
        self.instance_id = instance_id  # type: str
        self.project_id = project_id  # type: long
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeQualityProjectStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class ChangeQualityProjectStatusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ChangeQualityProjectStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ChangeQualityProjectStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ChangeQualityProjectStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ChangeQualityProjectStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeQualityProjectStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAgentRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, display_name=None, instance_id=None,
                 skill_group_id=None, skill_group_id_list=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: list[long]
        self.skill_group_id_list = skill_group_id_list  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAgentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class CreateAgentResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: long
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAgentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateAgentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateAgentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAgentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAgentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAiOutboundTaskRequestRecallRule(TeaModel):
    def __init__(self, count=None, interval=None):
        self.count = count  # type: int
        self.interval = interval  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAiOutboundTaskRequestRecallRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.interval is not None:
            result['Interval'] = self.interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        return self


class CreateAiOutboundTaskRequest(TeaModel):
    def __init__(self, concurrent_rate=None, description=None, execution_time=None, forecast_call_rate=None,
                 handler_id=None, instance_id=None, name=None, num_repeated=None, outbound_nums=None, recall_rule=None,
                 type=None):
        self.concurrent_rate = concurrent_rate  # type: int
        self.description = description  # type: str
        self.execution_time = execution_time  # type: str
        self.forecast_call_rate = forecast_call_rate  # type: float
        self.handler_id = handler_id  # type: long
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.num_repeated = num_repeated  # type: int
        self.outbound_nums = outbound_nums  # type: list[str]
        self.recall_rule = recall_rule  # type: CreateAiOutboundTaskRequestRecallRule
        self.type = type  # type: int

    def validate(self):
        if self.recall_rule:
            self.recall_rule.validate()

    def to_map(self):
        _map = super(CreateAiOutboundTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrent_rate is not None:
            result['ConcurrentRate'] = self.concurrent_rate
        if self.description is not None:
            result['Description'] = self.description
        if self.execution_time is not None:
            result['ExecutionTime'] = self.execution_time
        if self.forecast_call_rate is not None:
            result['ForecastCallRate'] = self.forecast_call_rate
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.num_repeated is not None:
            result['NumRepeated'] = self.num_repeated
        if self.outbound_nums is not None:
            result['OutboundNums'] = self.outbound_nums
        if self.recall_rule is not None:
            result['RecallRule'] = self.recall_rule.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConcurrentRate') is not None:
            self.concurrent_rate = m.get('ConcurrentRate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExecutionTime') is not None:
            self.execution_time = m.get('ExecutionTime')
        if m.get('ForecastCallRate') is not None:
            self.forecast_call_rate = m.get('ForecastCallRate')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumRepeated') is not None:
            self.num_repeated = m.get('NumRepeated')
        if m.get('OutboundNums') is not None:
            self.outbound_nums = m.get('OutboundNums')
        if m.get('RecallRule') is not None:
            temp_model = CreateAiOutboundTaskRequestRecallRule()
            self.recall_rule = temp_model.from_map(m['RecallRule'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateAiOutboundTaskShrinkRequest(TeaModel):
    def __init__(self, concurrent_rate=None, description=None, execution_time=None, forecast_call_rate=None,
                 handler_id=None, instance_id=None, name=None, num_repeated=None, outbound_nums_shrink=None,
                 recall_rule_shrink=None, type=None):
        self.concurrent_rate = concurrent_rate  # type: int
        self.description = description  # type: str
        self.execution_time = execution_time  # type: str
        self.forecast_call_rate = forecast_call_rate  # type: float
        self.handler_id = handler_id  # type: long
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.num_repeated = num_repeated  # type: int
        self.outbound_nums_shrink = outbound_nums_shrink  # type: str
        self.recall_rule_shrink = recall_rule_shrink  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAiOutboundTaskShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrent_rate is not None:
            result['ConcurrentRate'] = self.concurrent_rate
        if self.description is not None:
            result['Description'] = self.description
        if self.execution_time is not None:
            result['ExecutionTime'] = self.execution_time
        if self.forecast_call_rate is not None:
            result['ForecastCallRate'] = self.forecast_call_rate
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.num_repeated is not None:
            result['NumRepeated'] = self.num_repeated
        if self.outbound_nums_shrink is not None:
            result['OutboundNums'] = self.outbound_nums_shrink
        if self.recall_rule_shrink is not None:
            result['RecallRule'] = self.recall_rule_shrink
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConcurrentRate') is not None:
            self.concurrent_rate = m.get('ConcurrentRate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExecutionTime') is not None:
            self.execution_time = m.get('ExecutionTime')
        if m.get('ForecastCallRate') is not None:
            self.forecast_call_rate = m.get('ForecastCallRate')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumRepeated') is not None:
            self.num_repeated = m.get('NumRepeated')
        if m.get('OutboundNums') is not None:
            self.outbound_nums_shrink = m.get('OutboundNums')
        if m.get('RecallRule') is not None:
            self.recall_rule_shrink = m.get('RecallRule')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateAiOutboundTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAiOutboundTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateAiOutboundTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateAiOutboundTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAiOutboundTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAiOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAiOutboundTaskBatchRequest(TeaModel):
    def __init__(self, instance_id=None, task_id=None):
        self.instance_id = instance_id  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAiOutboundTaskBatchRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateAiOutboundTaskBatchResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateAiOutboundTaskBatchResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateAiOutboundTaskBatchResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateAiOutboundTaskBatchResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateAiOutboundTaskBatchResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAiOutboundTaskBatchResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateDepartmentRequest(TeaModel):
    def __init__(self, department_name=None, instance_id=None):
        self.department_name = department_name  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDepartmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_name is not None:
            result['DepartmentName'] = self.department_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DepartmentName') is not None:
            self.department_name = m.get('DepartmentName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class CreateDepartmentResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: long
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateDepartmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateDepartmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateDepartmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateDepartmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateDepartmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOutboundTaskRequest(TeaModel):
    def __init__(self, ani=None, call_infos=None, department_id=None, description=None, end_date=None, end_time=None,
                 ext_attrs=None, group_name=None, instance_id=None, model=None, retry_interval=None, retry_time=None,
                 skill_group=None, start_date=None, start_time=None, task_name=None, task_type=None):
        self.ani = ani  # type: str
        self.call_infos = call_infos  # type: str
        self.department_id = department_id  # type: long
        self.description = description  # type: str
        self.end_date = end_date  # type: str
        self.end_time = end_time  # type: str
        self.ext_attrs = ext_attrs  # type: str
        self.group_name = group_name  # type: str
        self.instance_id = instance_id  # type: str
        self.model = model  # type: int
        self.retry_interval = retry_interval  # type: int
        self.retry_time = retry_time  # type: int
        self.skill_group = skill_group  # type: long
        self.start_date = start_date  # type: str
        self.start_time = start_time  # type: str
        self.task_name = task_name  # type: str
        self.task_type = task_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOutboundTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ani is not None:
            result['Ani'] = self.ani
        if self.call_infos is not None:
            result['CallInfos'] = self.call_infos
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.description is not None:
            result['Description'] = self.description
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ext_attrs is not None:
            result['ExtAttrs'] = self.ext_attrs
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.model is not None:
            result['Model'] = self.model
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_time is not None:
            result['RetryTime'] = self.retry_time
        if self.skill_group is not None:
            result['SkillGroup'] = self.skill_group
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ani') is not None:
            self.ani = m.get('Ani')
        if m.get('CallInfos') is not None:
            self.call_infos = m.get('CallInfos')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExtAttrs') is not None:
            self.ext_attrs = m.get('ExtAttrs')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryTime') is not None:
            self.retry_time = m.get('RetryTime')
        if m.get('SkillGroup') is not None:
            self.skill_group = m.get('SkillGroup')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateOutboundTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateOutboundTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateOutboundTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateOutboundTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateOutboundTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityProjectRequest(TeaModel):
    def __init__(self, analysis_ids=None, channel_touch_type=None, check_freq_type=None, dep_list=None,
                 group_list=None, instance_id=None, project_name=None, scope_type=None, servicer_list=None,
                 time_range_end=None, time_range_start=None):
        self.analysis_ids = analysis_ids  # type: list[long]
        self.channel_touch_type = channel_touch_type  # type: list[int]
        self.check_freq_type = check_freq_type  # type: int
        self.dep_list = dep_list  # type: list[long]
        self.group_list = group_list  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.project_name = project_name  # type: str
        self.scope_type = scope_type  # type: int
        self.servicer_list = servicer_list  # type: list[str]
        self.time_range_end = time_range_end  # type: str
        self.time_range_start = time_range_start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateQualityProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_ids is not None:
            result['AnalysisIds'] = self.analysis_ids
        if self.channel_touch_type is not None:
            result['ChannelTouchType'] = self.channel_touch_type
        if self.check_freq_type is not None:
            result['CheckFreqType'] = self.check_freq_type
        if self.dep_list is not None:
            result['DepList'] = self.dep_list
        if self.group_list is not None:
            result['GroupList'] = self.group_list
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.scope_type is not None:
            result['ScopeType'] = self.scope_type
        if self.servicer_list is not None:
            result['ServicerList'] = self.servicer_list
        if self.time_range_end is not None:
            result['TimeRangeEnd'] = self.time_range_end
        if self.time_range_start is not None:
            result['TimeRangeStart'] = self.time_range_start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnalysisIds') is not None:
            self.analysis_ids = m.get('AnalysisIds')
        if m.get('ChannelTouchType') is not None:
            self.channel_touch_type = m.get('ChannelTouchType')
        if m.get('CheckFreqType') is not None:
            self.check_freq_type = m.get('CheckFreqType')
        if m.get('DepList') is not None:
            self.dep_list = m.get('DepList')
        if m.get('GroupList') is not None:
            self.group_list = m.get('GroupList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ScopeType') is not None:
            self.scope_type = m.get('ScopeType')
        if m.get('ServicerList') is not None:
            self.servicer_list = m.get('ServicerList')
        if m.get('TimeRangeEnd') is not None:
            self.time_range_end = m.get('TimeRangeEnd')
        if m.get('TimeRangeStart') is not None:
            self.time_range_start = m.get('TimeRangeStart')
        return self


class CreateQualityProjectResponseBodyData(TeaModel):
    def __init__(self, instance_id=None, project_id=None, version=None):
        self.instance_id = instance_id  # type: str
        self.project_id = project_id  # type: long
        self.version = version  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateQualityProjectResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class CreateQualityProjectResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: CreateQualityProjectResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(CreateQualityProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateQualityProjectResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityProjectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateQualityProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateQualityProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateQualityProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateQualityRuleRequest(TeaModel):
    def __init__(self, instance_id=None, key_words=None, match_type=None, name=None, rule_tag=None):
        self.instance_id = instance_id  # type: str
        self.key_words = key_words  # type: list[str]
        self.match_type = match_type  # type: int
        self.name = name  # type: str
        self.rule_tag = rule_tag  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateQualityRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.key_words is not None:
            result['KeyWords'] = self.key_words
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_tag is not None:
            result['RuleTag'] = self.rule_tag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('KeyWords') is not None:
            self.key_words = m.get('KeyWords')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleTag') is not None:
            self.rule_tag = m.get('RuleTag')
        return self


class CreateQualityRuleResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateQualityRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateQualityRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateQualityRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateQualityRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSkillGroupRequest(TeaModel):
    def __init__(self, channel_type=None, client_token=None, department_id=None, description=None,
                 display_name=None, instance_id=None, skill_group_name=None):
        self.channel_type = channel_type  # type: int
        self.client_token = client_token  # type: str
        self.department_id = department_id  # type: long
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.skill_group_name = skill_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        return self


class CreateSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateTaskRequest(TeaModel):
    def __init__(self, call_string=None, call_string_type=None, caller=None, owner_id=None,
                 resource_owner_account=None, resource_owner_id=None, retry_count=None, retry_flag=None, retry_interval=None,
                 retry_status_code=None, robot_id=None, seat_count=None, start_now=None, task_name=None, work_day=None,
                 work_time_list=None):
        self.call_string = call_string  # type: str
        self.call_string_type = call_string_type  # type: str
        self.caller = caller  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.retry_count = retry_count  # type: int
        self.retry_flag = retry_flag  # type: int
        self.retry_interval = retry_interval  # type: int
        self.retry_status_code = retry_status_code  # type: str
        self.robot_id = robot_id  # type: str
        self.seat_count = seat_count  # type: str
        self.start_now = start_now  # type: bool
        self.task_name = task_name  # type: str
        self.work_day = work_day  # type: str
        self.work_time_list = work_time_list  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_string is not None:
            result['CallString'] = self.call_string
        if self.call_string_type is not None:
            result['CallStringType'] = self.call_string_type
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.retry_count is not None:
            result['RetryCount'] = self.retry_count
        if self.retry_flag is not None:
            result['RetryFlag'] = self.retry_flag
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_status_code is not None:
            result['RetryStatusCode'] = self.retry_status_code
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        if self.seat_count is not None:
            result['SeatCount'] = self.seat_count
        if self.start_now is not None:
            result['StartNow'] = self.start_now
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.work_day is not None:
            result['WorkDay'] = self.work_day
        if self.work_time_list is not None:
            result['WorkTimeList'] = self.work_time_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallString') is not None:
            self.call_string = m.get('CallString')
        if m.get('CallStringType') is not None:
            self.call_string_type = m.get('CallStringType')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RetryCount') is not None:
            self.retry_count = m.get('RetryCount')
        if m.get('RetryFlag') is not None:
            self.retry_flag = m.get('RetryFlag')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryStatusCode') is not None:
            self.retry_status_code = m.get('RetryStatusCode')
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        if m.get('SeatCount') is not None:
            self.seat_count = m.get('SeatCount')
        if m.get('StartNow') is not None:
            self.start_now = m.get('StartNow')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('WorkDay') is not None:
            self.work_day = m.get('WorkDay')
        if m.get('WorkTimeList') is not None:
            self.work_time_list = m.get('WorkTimeList')
        return self


class CreateTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateThirdSsoAgentRequest(TeaModel):
    def __init__(self, account_id=None, account_name=None, client_id=None, client_token=None, display_name=None,
                 instance_id=None, role_ids=None, skill_group_ids=None):
        self.account_id = account_id  # type: str
        self.account_name = account_name  # type: str
        self.client_id = client_id  # type: str
        self.client_token = client_token  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.role_ids = role_ids  # type: list[long]
        self.skill_group_ids = skill_group_ids  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateThirdSsoAgentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.role_ids is not None:
            result['RoleIds'] = self.role_ids
        if self.skill_group_ids is not None:
            result['SkillGroupIds'] = self.skill_group_ids
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RoleIds') is not None:
            self.role_ids = m.get('RoleIds')
        if m.get('SkillGroupIds') is not None:
            self.skill_group_ids = m.get('SkillGroupIds')
        return self


class CreateThirdSsoAgentResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: long
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        # requestId
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(CreateThirdSsoAgentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateThirdSsoAgentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: CreateThirdSsoAgentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(CreateThirdSsoAgentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateThirdSsoAgentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAgentRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAgentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteAgentResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAgentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteAgentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAgentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAgentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAgentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAiOutboundTaskRequest(TeaModel):
    def __init__(self, instance_id=None, task_id=None):
        self.instance_id = instance_id  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAiOutboundTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class DeleteAiOutboundTaskResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteAiOutboundTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteAiOutboundTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteAiOutboundTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteAiOutboundTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAiOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteDepartmentRequest(TeaModel):
    def __init__(self, department_id=None, instance_id=None):
        self.department_id = department_id  # type: long
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDepartmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteDepartmentResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteDepartmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteDepartmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteDepartmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteDepartmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteDepartmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHotlineNumberRequest(TeaModel):
    def __init__(self, hotline_number=None, instance_id=None):
        self.hotline_number = hotline_number  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHotlineNumberRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteHotlineNumberResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteHotlineNumberResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHotlineNumberResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteHotlineNumberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteHotlineNumberResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHotlineNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOutboundTaskRequest(TeaModel):
    def __init__(self, instance_id=None, outbound_task_id=None):
        self.instance_id = instance_id  # type: str
        self.outbound_task_id = outbound_task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteOutboundTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_task_id is not None:
            result['OutboundTaskId'] = self.outbound_task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundTaskId') is not None:
            self.outbound_task_id = m.get('OutboundTaskId')
        return self


class DeleteOutboundTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteOutboundTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteOutboundTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteOutboundTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteOutboundTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteOuterAccountRequest(TeaModel):
    def __init__(self, outer_account_id=None, outer_account_type=None):
        self.outer_account_id = outer_account_id  # type: str
        self.outer_account_type = outer_account_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteOuterAccountRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outer_account_id is not None:
            result['OuterAccountId'] = self.outer_account_id
        if self.outer_account_type is not None:
            result['OuterAccountType'] = self.outer_account_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OuterAccountId') is not None:
            self.outer_account_id = m.get('OuterAccountId')
        if m.get('OuterAccountType') is not None:
            self.outer_account_type = m.get('OuterAccountType')
        return self


class DeleteOuterAccountResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteOuterAccountResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteOuterAccountResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteOuterAccountResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteOuterAccountResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteOuterAccountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityProjectRequest(TeaModel):
    def __init__(self, instance_id=None, project_id=None):
        self.instance_id = instance_id  # type: str
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteQualityProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class DeleteQualityProjectResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteQualityProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityProjectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteQualityProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteQualityProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteQualityProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteQualityRuleRequest(TeaModel):
    def __init__(self, id=None, instance_id=None):
        self.id = id  # type: long
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteQualityRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class DeleteQualityRuleResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteQualityRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteQualityRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteQualityRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteQualityRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSkillGroupRequest(TeaModel):
    def __init__(self, outer_group_id=None, outer_group_type=None):
        self.outer_group_id = outer_group_id  # type: str
        self.outer_group_type = outer_group_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outer_group_id is not None:
            result['OuterGroupId'] = self.outer_group_id
        if self.outer_group_type is not None:
            result['OuterGroupType'] = self.outer_group_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OuterGroupId') is not None:
            self.outer_group_id = m.get('OuterGroupId')
        if m.get('OuterGroupType') is not None:
            self.outer_group_type = m.get('OuterGroupType')
        return self


class DeleteSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(DeleteSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DeleteSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DeleteSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeRecordDataRequest(TeaModel):
    def __init__(self, account_id=None, account_type=None, acid=None, owner_id=None, prod_code=None,
                 resource_owner_account=None, resource_owner_id=None, sec_level=None):
        self.account_id = account_id  # type: str
        self.account_type = account_type  # type: str
        self.acid = acid  # type: str
        self.owner_id = owner_id  # type: long
        self.prod_code = prod_code  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.sec_level = sec_level  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRecordDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.sec_level is not None:
            result['SecLevel'] = self.sec_level
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecLevel') is not None:
            self.sec_level = m.get('SecLevel')
        return self


class DescribeRecordDataResponseBody(TeaModel):
    def __init__(self, acid=None, agent_id=None, code=None, message=None, oss_link=None, request_id=None):
        self.acid = acid  # type: str
        self.agent_id = agent_id  # type: str
        self.code = code  # type: str
        self.message = message  # type: str
        self.oss_link = oss_link  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(DescribeRecordDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.oss_link is not None:
            result['OssLink'] = self.oss_link
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('OssLink') is not None:
            self.oss_link = m.get('OssLink')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeRecordDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: DescribeRecordDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(DescribeRecordDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeRecordDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EditQualityProjectRequest(TeaModel):
    def __init__(self, analysis_ids=None, channel_touch_type=None, check_freq_type=None, dep_list=None,
                 group_list=None, instance_id=None, project_id=None, project_name=None, project_version=None, scope_type=None,
                 servicer_list=None, time_range_end=None, time_range_start=None):
        self.analysis_ids = analysis_ids  # type: list[long]
        self.channel_touch_type = channel_touch_type  # type: list[int]
        self.check_freq_type = check_freq_type  # type: int
        self.dep_list = dep_list  # type: list[long]
        self.group_list = group_list  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.project_id = project_id  # type: long
        self.project_name = project_name  # type: str
        self.project_version = project_version  # type: int
        self.scope_type = scope_type  # type: int
        self.servicer_list = servicer_list  # type: list[str]
        self.time_range_end = time_range_end  # type: str
        self.time_range_start = time_range_start  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EditQualityProjectRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.analysis_ids is not None:
            result['AnalysisIds'] = self.analysis_ids
        if self.channel_touch_type is not None:
            result['ChannelTouchType'] = self.channel_touch_type
        if self.check_freq_type is not None:
            result['CheckFreqType'] = self.check_freq_type
        if self.dep_list is not None:
            result['DepList'] = self.dep_list
        if self.group_list is not None:
            result['GroupList'] = self.group_list
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.project_version is not None:
            result['ProjectVersion'] = self.project_version
        if self.scope_type is not None:
            result['ScopeType'] = self.scope_type
        if self.servicer_list is not None:
            result['ServicerList'] = self.servicer_list
        if self.time_range_end is not None:
            result['TimeRangeEnd'] = self.time_range_end
        if self.time_range_start is not None:
            result['TimeRangeStart'] = self.time_range_start
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AnalysisIds') is not None:
            self.analysis_ids = m.get('AnalysisIds')
        if m.get('ChannelTouchType') is not None:
            self.channel_touch_type = m.get('ChannelTouchType')
        if m.get('CheckFreqType') is not None:
            self.check_freq_type = m.get('CheckFreqType')
        if m.get('DepList') is not None:
            self.dep_list = m.get('DepList')
        if m.get('GroupList') is not None:
            self.group_list = m.get('GroupList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('ProjectVersion') is not None:
            self.project_version = m.get('ProjectVersion')
        if m.get('ScopeType') is not None:
            self.scope_type = m.get('ScopeType')
        if m.get('ServicerList') is not None:
            self.servicer_list = m.get('ServicerList')
        if m.get('TimeRangeEnd') is not None:
            self.time_range_end = m.get('TimeRangeEnd')
        if m.get('TimeRangeStart') is not None:
            self.time_range_start = m.get('TimeRangeStart')
        return self


class EditQualityProjectResponseBodyData(TeaModel):
    def __init__(self, instance_id=None, project_id=None, version=None):
        self.instance_id = instance_id  # type: str
        self.project_id = project_id  # type: long
        self.version = version  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(EditQualityProjectResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class EditQualityProjectResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[EditQualityProjectResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(EditQualityProjectResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = EditQualityProjectResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EditQualityProjectResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EditQualityProjectResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EditQualityProjectResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EditQualityProjectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EditQualityRuleRequest(TeaModel):
    def __init__(self, instance_id=None, key_words=None, match_type=None, name=None, quality_rule_id=None,
                 rule_tag=None):
        self.instance_id = instance_id  # type: str
        self.key_words = key_words  # type: list[str]
        self.match_type = match_type  # type: int
        self.name = name  # type: str
        self.quality_rule_id = quality_rule_id  # type: long
        self.rule_tag = rule_tag  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(EditQualityRuleRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.key_words is not None:
            result['KeyWords'] = self.key_words
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.name is not None:
            result['Name'] = self.name
        if self.quality_rule_id is not None:
            result['QualityRuleId'] = self.quality_rule_id
        if self.rule_tag is not None:
            result['RuleTag'] = self.rule_tag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('KeyWords') is not None:
            self.key_words = m.get('KeyWords')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('QualityRuleId') is not None:
            self.quality_rule_id = m.get('QualityRuleId')
        if m.get('RuleTag') is not None:
            self.rule_tag = m.get('RuleTag')
        return self


class EditQualityRuleResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(EditQualityRuleResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EditQualityRuleResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EditQualityRuleResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EditQualityRuleResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EditQualityRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EditQualityRuleTagRequestAnalysisTypes(TeaModel):
    def __init__(self, id=None, name=None):
        self.id = id  # type: long
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EditQualityRuleTagRequestAnalysisTypes, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class EditQualityRuleTagRequest(TeaModel):
    def __init__(self, analysis_types=None, instance_id=None):
        self.analysis_types = analysis_types  # type: list[EditQualityRuleTagRequestAnalysisTypes]
        self.instance_id = instance_id  # type: str

    def validate(self):
        if self.analysis_types:
            for k in self.analysis_types:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(EditQualityRuleTagRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AnalysisTypes'] = []
        if self.analysis_types is not None:
            for k in self.analysis_types:
                result['AnalysisTypes'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.analysis_types = []
        if m.get('AnalysisTypes') is not None:
            for k in m.get('AnalysisTypes'):
                temp_model = EditQualityRuleTagRequestAnalysisTypes()
                self.analysis_types.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class EditQualityRuleTagResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(EditQualityRuleTagResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EditQualityRuleTagResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EditQualityRuleTagResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EditQualityRuleTagResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EditQualityRuleTagResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class EncryptPhoneNumRequest(TeaModel):
    def __init__(self, instance_id=None, phone_num=None):
        self.instance_id = instance_id  # type: str
        self.phone_num = phone_num  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(EncryptPhoneNumRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        return self


class EncryptPhoneNumResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(EncryptPhoneNumResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class EncryptPhoneNumResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: EncryptPhoneNumResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(EncryptPhoneNumResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = EncryptPhoneNumResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FetchCallRequest(TeaModel):
    def __init__(self, account_name=None, call_id=None, client_token=None, connection_id=None,
                 hold_connection_id=None, instance_id=None, job_id=None):
        self.account_name = account_name  # type: str
        self.call_id = call_id  # type: str
        self.client_token = client_token  # type: str
        self.connection_id = connection_id  # type: str
        self.hold_connection_id = hold_connection_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FetchCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.hold_connection_id is not None:
            result['HoldConnectionId'] = self.hold_connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('HoldConnectionId') is not None:
            self.hold_connection_id = m.get('HoldConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class FetchCallResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(FetchCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class FetchCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FetchCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FetchCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FetchCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class FinishHotlineServiceRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(FinishHotlineServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class FinishHotlineServiceResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(FinishHotlineServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class FinishHotlineServiceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: FinishHotlineServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(FinishHotlineServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = FinishHotlineServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GenerateWebSocketSignRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateWebSocketSignRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GenerateWebSocketSignResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GenerateWebSocketSignResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GenerateWebSocketSignResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GenerateWebSocketSignResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GenerateWebSocketSignResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GenerateWebSocketSignResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetAgentResponseBodyDataGroupList(TeaModel):
    def __init__(self, channel_type=None, description=None, display_name=None, name=None, skill_group_id=None):
        self.channel_type = channel_type  # type: int
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.name = name  # type: str
        self.skill_group_id = skill_group_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentResponseBodyDataGroupList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.name is not None:
            result['Name'] = self.name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class GetAgentResponseBodyData(TeaModel):
    def __init__(self, account_name=None, agent_id=None, display_name=None, group_list=None, status=None,
                 tenant_id=None):
        self.account_name = account_name  # type: str
        self.agent_id = agent_id  # type: long
        self.display_name = display_name  # type: str
        self.group_list = group_list  # type: list[GetAgentResponseBodyDataGroupList]
        self.status = status  # type: int
        self.tenant_id = tenant_id  # type: long

    def validate(self):
        if self.group_list:
            for k in self.group_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAgentResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        result['GroupList'] = []
        if self.group_list is not None:
            for k in self.group_list:
                result['GroupList'].append(k.to_map() if k else None)
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        self.group_list = []
        if m.get('GroupList') is not None:
            for k in m.get('GroupList'):
                temp_model = GetAgentResponseBodyDataGroupList()
                self.group_list.append(temp_model.from_map(k))
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class GetAgentResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetAgentResponseBodyData
        self.http_status_code = http_status_code  # type: long
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAgentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAgentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAgentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentBasisStatusRequest(TeaModel):
    def __init__(self, agent_ids=None, current_page=None, dep_ids=None, end_date=None, instance_id=None,
                 page_size=None, start_date=None):
        self.agent_ids = agent_ids  # type: list[long]
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentBasisStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetAgentBasisStatusShrinkRequest(TeaModel):
    def __init__(self, agent_ids_shrink=None, current_page=None, dep_ids_shrink=None, end_date=None,
                 instance_id=None, page_size=None, start_date=None):
        self.agent_ids_shrink = agent_ids_shrink  # type: str
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentBasisStatusShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetAgentBasisStatusResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: str
        self.total_num = total_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentBasisStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetAgentBasisStatusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetAgentBasisStatusResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAgentBasisStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentBasisStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentBasisStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAgentBasisStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAgentBasisStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentBasisStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentByIdRequest(TeaModel):
    def __init__(self, agent_id=None, instance_id=None):
        self.agent_id = agent_id  # type: long
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentByIdRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetAgentByIdResponseBodyData(TeaModel):
    def __init__(self, agent_id=None, create_user_name=None, foreign_key=None, foreign_nick=None, real_name=None,
                 servicer_type=None, show_name=None):
        self.agent_id = agent_id  # type: int
        self.create_user_name = create_user_name  # type: str
        self.foreign_key = foreign_key  # type: str
        self.foreign_nick = foreign_nick  # type: str
        self.real_name = real_name  # type: str
        self.servicer_type = servicer_type  # type: int
        self.show_name = show_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentByIdResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.create_user_name is not None:
            result['CreateUserName'] = self.create_user_name
        if self.foreign_key is not None:
            result['ForeignKey'] = self.foreign_key
        if self.foreign_nick is not None:
            result['ForeignNick'] = self.foreign_nick
        if self.real_name is not None:
            result['RealName'] = self.real_name
        if self.servicer_type is not None:
            result['ServicerType'] = self.servicer_type
        if self.show_name is not None:
            result['ShowName'] = self.show_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('CreateUserName') is not None:
            self.create_user_name = m.get('CreateUserName')
        if m.get('ForeignKey') is not None:
            self.foreign_key = m.get('ForeignKey')
        if m.get('ForeignNick') is not None:
            self.foreign_nick = m.get('ForeignNick')
        if m.get('RealName') is not None:
            self.real_name = m.get('RealName')
        if m.get('ServicerType') is not None:
            self.servicer_type = m.get('ServicerType')
        if m.get('ShowName') is not None:
            self.show_name = m.get('ShowName')
        return self


class GetAgentByIdResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetAgentByIdResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAgentByIdResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentByIdResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentByIdResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAgentByIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAgentByIdResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentByIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentDetailReportRequest(TeaModel):
    def __init__(self, agent_ids=None, current_page=None, dep_ids=None, end_date=None, exist_agent_grouping=None,
                 exist_department_grouping=None, instance_id=None, page_size=None, start_date=None, time_latitude_type=None):
        self.agent_ids = agent_ids  # type: list[long]
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentDetailReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetAgentDetailReportShrinkRequest(TeaModel):
    def __init__(self, agent_ids_shrink=None, current_page=None, dep_ids_shrink=None, end_date=None,
                 exist_agent_grouping=None, exist_department_grouping=None, instance_id=None, page_size=None, start_date=None,
                 time_latitude_type=None):
        self.agent_ids_shrink = agent_ids_shrink  # type: str
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentDetailReportShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetAgentDetailReportResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.rows = rows  # type: str
        self.total_num = total_num  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentDetailReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetAgentDetailReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetAgentDetailReportResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAgentDetailReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentDetailReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentDetailReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAgentDetailReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAgentDetailReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentDetailReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentIndexRealTimeRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids=None, group_ids=None, instance_id=None, page_size=None):
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.group_ids = group_ids  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentIndexRealTimeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetAgentIndexRealTimeResponseBodyDataColumns(TeaModel):
    def __init__(self, key=None, title=None):
        self.key = key  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentIndexRealTimeResponseBodyDataColumns, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetAgentIndexRealTimeResponseBodyData(TeaModel):
    def __init__(self, columns=None, page=None, page_size=None, rows=None, total=None):
        self.columns = columns  # type: list[GetAgentIndexRealTimeResponseBodyDataColumns]
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: list[dict[str, any]]
        self.total = total  # type: int

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAgentIndexRealTimeResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = GetAgentIndexRealTimeResponseBodyDataColumns()
                self.columns.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetAgentIndexRealTimeResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetAgentIndexRealTimeResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAgentIndexRealTimeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentIndexRealTimeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentIndexRealTimeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAgentIndexRealTimeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAgentIndexRealTimeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentIndexRealTimeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentServiceStatusRequest(TeaModel):
    def __init__(self, agent_ids=None, current_page=None, dep_ids=None, end_date=None, exist_agent_grouping=None,
                 exist_department_grouping=None, instance_id=None, page_size=None, start_date=None, time_latitude_type=None):
        self.agent_ids = agent_ids  # type: list[long]
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentServiceStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetAgentServiceStatusShrinkRequest(TeaModel):
    def __init__(self, agent_ids_shrink=None, current_page=None, dep_ids_shrink=None, end_date=None,
                 exist_agent_grouping=None, exist_department_grouping=None, instance_id=None, page_size=None, start_date=None,
                 time_latitude_type=None):
        self.agent_ids_shrink = agent_ids_shrink  # type: str
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentServiceStatusShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetAgentServiceStatusResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.rows = rows  # type: str
        self.total_num = total_num  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentServiceStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetAgentServiceStatusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetAgentServiceStatusResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAgentServiceStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentServiceStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentServiceStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAgentServiceStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAgentServiceStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentServiceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAgentStatisticsRequest(TeaModel):
    def __init__(self, agent_ids=None, current_page=None, dep_ids=None, end_date=None, exist_agent_grouping=None,
                 exist_department_grouping=None, instance_id=None, page_size=None, start_date=None, time_latitude_type=None):
        self.agent_ids = agent_ids  # type: list[long]
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetAgentStatisticsShrinkRequest(TeaModel):
    def __init__(self, agent_ids_shrink=None, current_page=None, dep_ids_shrink=None, end_date=None,
                 exist_agent_grouping=None, exist_department_grouping=None, instance_id=None, page_size=None, start_date=None,
                 time_latitude_type=None):
        self.agent_ids_shrink = agent_ids_shrink  # type: str
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentStatisticsShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetAgentStatisticsResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: str
        self.total_num = total_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAgentStatisticsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetAgentStatisticsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetAgentStatisticsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAgentStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAgentStatisticsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAgentStatisticsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAgentStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAgentStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAgentStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAiOutboundTaskBizDataRequest(TeaModel):
    def __init__(self, channel_id=None, instance_id=None):
        self.channel_id = channel_id  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAiOutboundTaskBizDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetAiOutboundTaskBizDataResponseBodyData(TeaModel):
    def __init__(self, biz_data=None, case_id=None, phone_num=None, task_id=None):
        self.biz_data = biz_data  # type: str
        self.case_id = case_id  # type: long
        self.phone_num = phone_num  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAiOutboundTaskBizDataResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_data is not None:
            result['BizData'] = self.biz_data
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizData') is not None:
            self.biz_data = m.get('BizData')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetAiOutboundTaskBizDataResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetAiOutboundTaskBizDataResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskBizDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAiOutboundTaskBizDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAiOutboundTaskBizDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAiOutboundTaskBizDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskBizDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAiOutboundTaskBizDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAiOutboundTaskDetailRequest(TeaModel):
    def __init__(self, instance_id=None, task_id=None):
        self.instance_id = instance_id  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAiOutboundTaskDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetAiOutboundTaskDetailResponseBodyDataRecallRule(TeaModel):
    def __init__(self, count=None, interval=None):
        self.count = count  # type: int
        self.interval = interval  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAiOutboundTaskDetailResponseBodyDataRecallRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.interval is not None:
            result['Interval'] = self.interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        return self


class GetAiOutboundTaskDetailResponseBodyData(TeaModel):
    def __init__(self, concurrent_rate=None, description=None, execution_time=None, forecast_call_rate=None,
                 handler_id=None, handler_name=None, name=None, num_repeated=None, outbound_nums=None, recall_rule=None,
                 status=None, status_desc=None, task_id=None, type=None):
        self.concurrent_rate = concurrent_rate  # type: int
        self.description = description  # type: str
        self.execution_time = execution_time  # type: str
        self.forecast_call_rate = forecast_call_rate  # type: float
        self.handler_id = handler_id  # type: long
        self.handler_name = handler_name  # type: str
        self.name = name  # type: str
        self.num_repeated = num_repeated  # type: int
        self.outbound_nums = outbound_nums  # type: list[str]
        self.recall_rule = recall_rule  # type: GetAiOutboundTaskDetailResponseBodyDataRecallRule
        self.status = status  # type: int
        self.status_desc = status_desc  # type: str
        self.task_id = task_id  # type: long
        self.type = type  # type: int

    def validate(self):
        if self.recall_rule:
            self.recall_rule.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrent_rate is not None:
            result['ConcurrentRate'] = self.concurrent_rate
        if self.description is not None:
            result['Description'] = self.description
        if self.execution_time is not None:
            result['ExecutionTime'] = self.execution_time
        if self.forecast_call_rate is not None:
            result['ForecastCallRate'] = self.forecast_call_rate
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.handler_name is not None:
            result['HandlerName'] = self.handler_name
        if self.name is not None:
            result['Name'] = self.name
        if self.num_repeated is not None:
            result['NumRepeated'] = self.num_repeated
        if self.outbound_nums is not None:
            result['OutboundNums'] = self.outbound_nums
        if self.recall_rule is not None:
            result['RecallRule'] = self.recall_rule.to_map()
        if self.status is not None:
            result['Status'] = self.status
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConcurrentRate') is not None:
            self.concurrent_rate = m.get('ConcurrentRate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExecutionTime') is not None:
            self.execution_time = m.get('ExecutionTime')
        if m.get('ForecastCallRate') is not None:
            self.forecast_call_rate = m.get('ForecastCallRate')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('HandlerName') is not None:
            self.handler_name = m.get('HandlerName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumRepeated') is not None:
            self.num_repeated = m.get('NumRepeated')
        if m.get('OutboundNums') is not None:
            self.outbound_nums = m.get('OutboundNums')
        if m.get('RecallRule') is not None:
            temp_model = GetAiOutboundTaskDetailResponseBodyDataRecallRule()
            self.recall_rule = temp_model.from_map(m['RecallRule'])
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetAiOutboundTaskDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetAiOutboundTaskDetailResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAiOutboundTaskDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAiOutboundTaskDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAiOutboundTaskDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAiOutboundTaskDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAiOutboundTaskExecDetailRequest(TeaModel):
    def __init__(self, batch_version=None, case_id=None, case_status=None, create_time_end=None,
                 create_time_start=None, current_page=None, instance_id=None, page_size=None, phone_num=None, task_id=None):
        self.batch_version = batch_version  # type: int
        self.case_id = case_id  # type: long
        self.case_status = case_status  # type: int
        self.create_time_end = create_time_end  # type: long
        self.create_time_start = create_time_start  # type: long
        self.current_page = current_page  # type: int
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.phone_num = phone_num  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAiOutboundTaskExecDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_version is not None:
            result['BatchVersion'] = self.batch_version
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.case_status is not None:
            result['CaseStatus'] = self.case_status
        if self.create_time_end is not None:
            result['CreateTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BatchVersion') is not None:
            self.batch_version = m.get('BatchVersion')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('CaseStatus') is not None:
            self.case_status = m.get('CaseStatus')
        if m.get('CreateTimeEnd') is not None:
            self.create_time_end = m.get('CreateTimeEnd')
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetAiOutboundTaskExecDetailResponseBodyDataList(TeaModel):
    def __init__(self, batch_version=None, biz_data=None, call_count=None, case_id=None, create_time=None,
                 last_call_result=None, phone_num=None, status=None, status_desc=None):
        self.batch_version = batch_version  # type: int
        self.biz_data = biz_data  # type: str
        self.call_count = call_count  # type: int
        self.case_id = case_id  # type: long
        self.create_time = create_time  # type: long
        self.last_call_result = last_call_result  # type: str
        self.phone_num = phone_num  # type: str
        self.status = status  # type: int
        self.status_desc = status_desc  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAiOutboundTaskExecDetailResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_version is not None:
            result['BatchVersion'] = self.batch_version
        if self.biz_data is not None:
            result['BizData'] = self.biz_data
        if self.call_count is not None:
            result['CallCount'] = self.call_count
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.last_call_result is not None:
            result['LastCallResult'] = self.last_call_result
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        if self.status is not None:
            result['Status'] = self.status
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BatchVersion') is not None:
            self.batch_version = m.get('BatchVersion')
        if m.get('BizData') is not None:
            self.biz_data = m.get('BizData')
        if m.get('CallCount') is not None:
            self.call_count = m.get('CallCount')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('LastCallResult') is not None:
            self.last_call_result = m.get('LastCallResult')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        return self


class GetAiOutboundTaskExecDetailResponseBodyData(TeaModel):
    def __init__(self, current_page=None, has_next_page=None, list=None, page_size=None, total_results=None):
        self.current_page = current_page  # type: int
        self.has_next_page = has_next_page  # type: bool
        self.list = list  # type: list[GetAiOutboundTaskExecDetailResponseBodyDataList]
        self.page_size = page_size  # type: int
        self.total_results = total_results  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskExecDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.has_next_page is not None:
            result['HasNextPage'] = self.has_next_page
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('HasNextPage') is not None:
            self.has_next_page = m.get('HasNextPage')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetAiOutboundTaskExecDetailResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class GetAiOutboundTaskExecDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetAiOutboundTaskExecDetailResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskExecDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAiOutboundTaskExecDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAiOutboundTaskExecDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAiOutboundTaskExecDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskExecDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAiOutboundTaskExecDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAiOutboundTaskListRequest(TeaModel):
    def __init__(self, create_time_end=None, create_time_start=None, current_page=None, instance_id=None,
                 page_size=None, search_key=None, status=None, type=None):
        self.create_time_end = create_time_end  # type: long
        self.create_time_start = create_time_start  # type: long
        self.current_page = current_page  # type: int
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.search_key = search_key  # type: str
        self.status = status  # type: int
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAiOutboundTaskListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_time_end is not None:
            result['CreateTimeEnd'] = self.create_time_end
        if self.create_time_start is not None:
            result['CreateTimeStart'] = self.create_time_start
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_key is not None:
            result['SearchKey'] = self.search_key
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CreateTimeEnd') is not None:
            self.create_time_end = m.get('CreateTimeEnd')
        if m.get('CreateTimeStart') is not None:
            self.create_time_start = m.get('CreateTimeStart')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchKey') is not None:
            self.search_key = m.get('SearchKey')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetAiOutboundTaskListResponseBodyDataList(TeaModel):
    def __init__(self, concurrent_rate=None, create_time=None, description=None, finish_count=None,
                 finish_rate=None, handler_id=None, handler_name=None, name=None, status=None, status_desc=None, task_id=None,
                 total_count=None):
        self.concurrent_rate = concurrent_rate  # type: int
        self.create_time = create_time  # type: long
        self.description = description  # type: str
        self.finish_count = finish_count  # type: int
        self.finish_rate = finish_rate  # type: float
        self.handler_id = handler_id  # type: long
        self.handler_name = handler_name  # type: str
        self.name = name  # type: str
        self.status = status  # type: int
        self.status_desc = status_desc  # type: str
        self.task_id = task_id  # type: long
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAiOutboundTaskListResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrent_rate is not None:
            result['ConcurrentRate'] = self.concurrent_rate
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.finish_count is not None:
            result['FinishCount'] = self.finish_count
        if self.finish_rate is not None:
            result['FinishRate'] = self.finish_rate
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.handler_name is not None:
            result['HandlerName'] = self.handler_name
        if self.name is not None:
            result['Name'] = self.name
        if self.status is not None:
            result['Status'] = self.status
        if self.status_desc is not None:
            result['StatusDesc'] = self.status_desc
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConcurrentRate') is not None:
            self.concurrent_rate = m.get('ConcurrentRate')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('FinishCount') is not None:
            self.finish_count = m.get('FinishCount')
        if m.get('FinishRate') is not None:
            self.finish_rate = m.get('FinishRate')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('HandlerName') is not None:
            self.handler_name = m.get('HandlerName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusDesc') is not None:
            self.status_desc = m.get('StatusDesc')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetAiOutboundTaskListResponseBodyData(TeaModel):
    def __init__(self, current_page=None, has_next_page=None, list=None, page_size=None, total_results=None):
        self.current_page = current_page  # type: int
        self.has_next_page = has_next_page  # type: bool
        self.list = list  # type: list[GetAiOutboundTaskListResponseBodyDataList]
        self.page_size = page_size  # type: int
        self.total_results = total_results  # type: int

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.has_next_page is not None:
            result['HasNextPage'] = self.has_next_page
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('HasNextPage') is not None:
            self.has_next_page = m.get('HasNextPage')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = GetAiOutboundTaskListResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class GetAiOutboundTaskListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetAiOutboundTaskListResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAiOutboundTaskListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAiOutboundTaskListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAiOutboundTaskListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAiOutboundTaskListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAiOutboundTaskProgressRequest(TeaModel):
    def __init__(self, batch_version=None, instance_id=None, task_id=None):
        self.batch_version = batch_version  # type: int
        self.instance_id = instance_id  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAiOutboundTaskProgressRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_version is not None:
            result['BatchVersion'] = self.batch_version
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BatchVersion') is not None:
            self.batch_version = m.get('BatchVersion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class GetAiOutboundTaskProgressResponseBodyDataCalloutProgress(TeaModel):
    def __init__(self, call_loss_count=None, call_loss_rate=None, call_out_connect_count=None,
                 call_out_connect_rate=None, call_out_count=None, call_out_servicer_pickup_count=None,
                 call_out_servicer_pickup_rate=None, call_out_user_pickup_count=None, call_out_user_pickup_rate=None):
        self.call_loss_count = call_loss_count  # type: int
        self.call_loss_rate = call_loss_rate  # type: float
        self.call_out_connect_count = call_out_connect_count  # type: int
        self.call_out_connect_rate = call_out_connect_rate  # type: float
        self.call_out_count = call_out_count  # type: int
        self.call_out_servicer_pickup_count = call_out_servicer_pickup_count  # type: int
        self.call_out_servicer_pickup_rate = call_out_servicer_pickup_rate  # type: float
        self.call_out_user_pickup_count = call_out_user_pickup_count  # type: int
        self.call_out_user_pickup_rate = call_out_user_pickup_rate  # type: float

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAiOutboundTaskProgressResponseBodyDataCalloutProgress, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_loss_count is not None:
            result['CallLossCount'] = self.call_loss_count
        if self.call_loss_rate is not None:
            result['CallLossRate'] = self.call_loss_rate
        if self.call_out_connect_count is not None:
            result['CallOutConnectCount'] = self.call_out_connect_count
        if self.call_out_connect_rate is not None:
            result['CallOutConnectRate'] = self.call_out_connect_rate
        if self.call_out_count is not None:
            result['CallOutCount'] = self.call_out_count
        if self.call_out_servicer_pickup_count is not None:
            result['CallOutServicerPickupCount'] = self.call_out_servicer_pickup_count
        if self.call_out_servicer_pickup_rate is not None:
            result['CallOutServicerPickupRate'] = self.call_out_servicer_pickup_rate
        if self.call_out_user_pickup_count is not None:
            result['CallOutUserPickupCount'] = self.call_out_user_pickup_count
        if self.call_out_user_pickup_rate is not None:
            result['CallOutUserPickupRate'] = self.call_out_user_pickup_rate
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallLossCount') is not None:
            self.call_loss_count = m.get('CallLossCount')
        if m.get('CallLossRate') is not None:
            self.call_loss_rate = m.get('CallLossRate')
        if m.get('CallOutConnectCount') is not None:
            self.call_out_connect_count = m.get('CallOutConnectCount')
        if m.get('CallOutConnectRate') is not None:
            self.call_out_connect_rate = m.get('CallOutConnectRate')
        if m.get('CallOutCount') is not None:
            self.call_out_count = m.get('CallOutCount')
        if m.get('CallOutServicerPickupCount') is not None:
            self.call_out_servicer_pickup_count = m.get('CallOutServicerPickupCount')
        if m.get('CallOutServicerPickupRate') is not None:
            self.call_out_servicer_pickup_rate = m.get('CallOutServicerPickupRate')
        if m.get('CallOutUserPickupCount') is not None:
            self.call_out_user_pickup_count = m.get('CallOutUserPickupCount')
        if m.get('CallOutUserPickupRate') is not None:
            self.call_out_user_pickup_rate = m.get('CallOutUserPickupRate')
        return self


class GetAiOutboundTaskProgressResponseBodyDataTaskProgress(TeaModel):
    def __init__(self, calling_count=None, connect_count=None, connect_rate=None, finish_count=None,
                 finish_rate=None, servicer_pickup_count=None, servicer_pickup_rate=None, terminate_count=None,
                 total_count=None, user_pickup_count=None, user_pickup_rate=None, waiting_call_count=None,
                 waiting_recall_count=None):
        self.calling_count = calling_count  # type: int
        self.connect_count = connect_count  # type: int
        self.connect_rate = connect_rate  # type: float
        self.finish_count = finish_count  # type: int
        self.finish_rate = finish_rate  # type: float
        self.servicer_pickup_count = servicer_pickup_count  # type: int
        self.servicer_pickup_rate = servicer_pickup_rate  # type: float
        self.terminate_count = terminate_count  # type: int
        self.total_count = total_count  # type: int
        self.user_pickup_count = user_pickup_count  # type: int
        self.user_pickup_rate = user_pickup_rate  # type: float
        self.waiting_call_count = waiting_call_count  # type: int
        self.waiting_recall_count = waiting_recall_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAiOutboundTaskProgressResponseBodyDataTaskProgress, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.calling_count is not None:
            result['CallingCount'] = self.calling_count
        if self.connect_count is not None:
            result['ConnectCount'] = self.connect_count
        if self.connect_rate is not None:
            result['ConnectRate'] = self.connect_rate
        if self.finish_count is not None:
            result['FinishCount'] = self.finish_count
        if self.finish_rate is not None:
            result['FinishRate'] = self.finish_rate
        if self.servicer_pickup_count is not None:
            result['ServicerPickupCount'] = self.servicer_pickup_count
        if self.servicer_pickup_rate is not None:
            result['ServicerPickupRate'] = self.servicer_pickup_rate
        if self.terminate_count is not None:
            result['TerminateCount'] = self.terminate_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.user_pickup_count is not None:
            result['UserPickupCount'] = self.user_pickup_count
        if self.user_pickup_rate is not None:
            result['UserPickupRate'] = self.user_pickup_rate
        if self.waiting_call_count is not None:
            result['WaitingCallCount'] = self.waiting_call_count
        if self.waiting_recall_count is not None:
            result['WaitingRecallCount'] = self.waiting_recall_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallingCount') is not None:
            self.calling_count = m.get('CallingCount')
        if m.get('ConnectCount') is not None:
            self.connect_count = m.get('ConnectCount')
        if m.get('ConnectRate') is not None:
            self.connect_rate = m.get('ConnectRate')
        if m.get('FinishCount') is not None:
            self.finish_count = m.get('FinishCount')
        if m.get('FinishRate') is not None:
            self.finish_rate = m.get('FinishRate')
        if m.get('ServicerPickupCount') is not None:
            self.servicer_pickup_count = m.get('ServicerPickupCount')
        if m.get('ServicerPickupRate') is not None:
            self.servicer_pickup_rate = m.get('ServicerPickupRate')
        if m.get('TerminateCount') is not None:
            self.terminate_count = m.get('TerminateCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('UserPickupCount') is not None:
            self.user_pickup_count = m.get('UserPickupCount')
        if m.get('UserPickupRate') is not None:
            self.user_pickup_rate = m.get('UserPickupRate')
        if m.get('WaitingCallCount') is not None:
            self.waiting_call_count = m.get('WaitingCallCount')
        if m.get('WaitingRecallCount') is not None:
            self.waiting_recall_count = m.get('WaitingRecallCount')
        return self


class GetAiOutboundTaskProgressResponseBodyData(TeaModel):
    def __init__(self, callout_progress=None, task_id=None, task_progress=None, type=None):
        self.callout_progress = callout_progress  # type: GetAiOutboundTaskProgressResponseBodyDataCalloutProgress
        self.task_id = task_id  # type: long
        self.task_progress = task_progress  # type: GetAiOutboundTaskProgressResponseBodyDataTaskProgress
        self.type = type  # type: int

    def validate(self):
        if self.callout_progress:
            self.callout_progress.validate()
        if self.task_progress:
            self.task_progress.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskProgressResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callout_progress is not None:
            result['CalloutProgress'] = self.callout_progress.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_progress is not None:
            result['TaskProgress'] = self.task_progress.to_map()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CalloutProgress') is not None:
            temp_model = GetAiOutboundTaskProgressResponseBodyDataCalloutProgress()
            self.callout_progress = temp_model.from_map(m['CalloutProgress'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskProgress') is not None:
            temp_model = GetAiOutboundTaskProgressResponseBodyDataTaskProgress()
            self.task_progress = temp_model.from_map(m['TaskProgress'])
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class GetAiOutboundTaskProgressResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetAiOutboundTaskProgressResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskProgressResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetAiOutboundTaskProgressResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAiOutboundTaskProgressResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAiOutboundTaskProgressResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAiOutboundTaskProgressResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAiOutboundTaskProgressResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetAllDepartmentRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAllDepartmentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetAllDepartmentResponseBodyData(TeaModel):
    def __init__(self, department_id=None, department_name=None):
        self.department_id = department_id  # type: long
        self.department_name = department_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetAllDepartmentResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.department_name is not None:
            result['DepartmentName'] = self.department_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('DepartmentName') is not None:
            self.department_name = m.get('DepartmentName')
        return self


class GetAllDepartmentResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[GetAllDepartmentResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetAllDepartmentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetAllDepartmentResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetAllDepartmentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetAllDepartmentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetAllDepartmentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetAllDepartmentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCallSoundRecordRequest(TeaModel):
    def __init__(self, call_id=None, create_time=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.call_id = call_id  # type: str
        self.create_time = create_time  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallSoundRecordRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class GetCallSoundRecordResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCallSoundRecordResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCallSoundRecordResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetCallSoundRecordResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCallSoundRecordResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCallSoundRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetConfigNumListRequest(TeaModel):
    def __init__(self, account_name=None, department_id=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.department_id = department_id  # type: long
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetConfigNumListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetConfigNumListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[str]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetConfigNumListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetConfigNumListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetConfigNumListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetConfigNumListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetConfigNumListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetCustomerInfoRequest(TeaModel):
    def __init__(self, instance_id=None, member_id=None):
        self.instance_id = instance_id  # type: str
        self.member_id = member_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCustomerInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        return self


class GetCustomerInfoResponseBodyData(TeaModel):
    def __init__(self, customize_fields=None, nick=None, outer_id=None, photo=None, real_name=None, user_id=None):
        self.customize_fields = customize_fields  # type: dict[str, any]
        self.nick = nick  # type: str
        self.outer_id = outer_id  # type: str
        self.photo = photo  # type: str
        self.real_name = real_name  # type: str
        self.user_id = user_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetCustomerInfoResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.customize_fields is not None:
            result['CustomizeFields'] = self.customize_fields
        if self.nick is not None:
            result['Nick'] = self.nick
        if self.outer_id is not None:
            result['OuterId'] = self.outer_id
        if self.photo is not None:
            result['Photo'] = self.photo
        if self.real_name is not None:
            result['RealName'] = self.real_name
        if self.user_id is not None:
            result['UserId'] = self.user_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CustomizeFields') is not None:
            self.customize_fields = m.get('CustomizeFields')
        if m.get('Nick') is not None:
            self.nick = m.get('Nick')
        if m.get('OuterId') is not None:
            self.outer_id = m.get('OuterId')
        if m.get('Photo') is not None:
            self.photo = m.get('Photo')
        if m.get('RealName') is not None:
            self.real_name = m.get('RealName')
        if m.get('UserId') is not None:
            self.user_id = m.get('UserId')
        return self


class GetCustomerInfoResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetCustomerInfoResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetCustomerInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetCustomerInfoResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetCustomerInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetCustomerInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetCustomerInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetCustomerInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDepGroupTreeDataRequest(TeaModel):
    def __init__(self, agent_id=None, instance_id=None):
        self.agent_id = agent_id  # type: long
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDepGroupTreeDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetDepGroupTreeDataResponseBodyDataGroupDTOS(TeaModel):
    def __init__(self, name=None, skill_group_id=None):
        self.name = name  # type: str
        self.skill_group_id = skill_group_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDepGroupTreeDataResponseBodyDataGroupDTOS, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class GetDepGroupTreeDataResponseBodyData(TeaModel):
    def __init__(self, dep_group_id=None, dep_group_name=None, group_dtos=None):
        self.dep_group_id = dep_group_id  # type: str
        self.dep_group_name = dep_group_name  # type: str
        self.group_dtos = group_dtos  # type: list[GetDepGroupTreeDataResponseBodyDataGroupDTOS]

    def validate(self):
        if self.group_dtos:
            for k in self.group_dtos:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDepGroupTreeDataResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dep_group_id is not None:
            result['DepGroupId'] = self.dep_group_id
        if self.dep_group_name is not None:
            result['DepGroupName'] = self.dep_group_name
        result['GroupDTOS'] = []
        if self.group_dtos is not None:
            for k in self.group_dtos:
                result['GroupDTOS'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DepGroupId') is not None:
            self.dep_group_id = m.get('DepGroupId')
        if m.get('DepGroupName') is not None:
            self.dep_group_name = m.get('DepGroupName')
        self.group_dtos = []
        if m.get('GroupDTOS') is not None:
            for k in m.get('GroupDTOS'):
                temp_model = GetDepGroupTreeDataResponseBodyDataGroupDTOS()
                self.group_dtos.append(temp_model.from_map(k))
        return self


class GetDepGroupTreeDataResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[GetDepGroupTreeDataResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetDepGroupTreeDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetDepGroupTreeDataResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDepGroupTreeDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDepGroupTreeDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDepGroupTreeDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDepGroupTreeDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetDepartmentalLatitudeAgentStatusRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids=None, end_date=None, exist_department_grouping=None,
                 instance_id=None, page_size=None, start_date=None):
        self.current_page = current_page  # type: long
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: long
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDepartmentalLatitudeAgentStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetDepartmentalLatitudeAgentStatusShrinkRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids_shrink=None, end_date=None, exist_department_grouping=None,
                 instance_id=None, page_size=None, start_date=None):
        self.current_page = current_page  # type: long
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: long
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDepartmentalLatitudeAgentStatusShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetDepartmentalLatitudeAgentStatusResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: str
        self.total_num = total_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetDepartmentalLatitudeAgentStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetDepartmentalLatitudeAgentStatusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetDepartmentalLatitudeAgentStatusResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetDepartmentalLatitudeAgentStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetDepartmentalLatitudeAgentStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetDepartmentalLatitudeAgentStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetDepartmentalLatitudeAgentStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetDepartmentalLatitudeAgentStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetDepartmentalLatitudeAgentStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineAgentDetailRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineAgentDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetHotlineAgentDetailResponseBodyData(TeaModel):
    def __init__(self, agent_id=None, agent_status=None, agent_status_code=None, assigned=None, rest_type=None,
                 tenant_id=None, token=None):
        self.agent_id = agent_id  # type: long
        self.agent_status = agent_status  # type: int
        self.agent_status_code = agent_status_code  # type: str
        self.assigned = assigned  # type: bool
        self.rest_type = rest_type  # type: int
        self.tenant_id = tenant_id  # type: long
        self.token = token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineAgentDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.agent_status is not None:
            result['AgentStatus'] = self.agent_status
        if self.agent_status_code is not None:
            result['AgentStatusCode'] = self.agent_status_code
        if self.assigned is not None:
            result['Assigned'] = self.assigned
        if self.rest_type is not None:
            result['RestType'] = self.rest_type
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('AgentStatus') is not None:
            self.agent_status = m.get('AgentStatus')
        if m.get('AgentStatusCode') is not None:
            self.agent_status_code = m.get('AgentStatusCode')
        if m.get('Assigned') is not None:
            self.assigned = m.get('Assigned')
        if m.get('RestType') is not None:
            self.rest_type = m.get('RestType')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class GetHotlineAgentDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetHotlineAgentDetailResponseBodyData
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetHotlineAgentDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHotlineAgentDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineAgentDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetHotlineAgentDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHotlineAgentDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineAgentDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineAgentDetailReportRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids=None, end_date=None, group_ids=None, instance_id=None,
                 page_size=None, start_date=None):
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.group_ids = group_ids  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineAgentDetailReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetHotlineAgentDetailReportResponseBodyDataColumns(TeaModel):
    def __init__(self, key=None, title=None):
        self.key = key  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineAgentDetailReportResponseBodyDataColumns, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetHotlineAgentDetailReportResponseBodyData(TeaModel):
    def __init__(self, columns=None, page=None, page_size=None, rows=None, total=None):
        self.columns = columns  # type: list[GetHotlineAgentDetailReportResponseBodyDataColumns]
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: list[dict[str, any]]
        self.total = total  # type: int

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetHotlineAgentDetailReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = GetHotlineAgentDetailReportResponseBodyDataColumns()
                self.columns.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetHotlineAgentDetailReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetHotlineAgentDetailReportResponseBodyData
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetHotlineAgentDetailReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHotlineAgentDetailReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineAgentDetailReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetHotlineAgentDetailReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHotlineAgentDetailReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineAgentDetailReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineAgentStatusRequest(TeaModel):
    def __init__(self, account_name=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineAgentStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetHotlineAgentStatusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineAgentStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineAgentStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetHotlineAgentStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHotlineAgentStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineAgentStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineCallActionRequest(TeaModel):
    def __init__(self, acc=None, account_name=None, act=None, biz=None, client_token=None, from_source=None,
                 instance_id=None):
        self.acc = acc  # type: str
        self.account_name = account_name  # type: str
        self.act = act  # type: int
        self.biz = biz  # type: str
        self.client_token = client_token  # type: str
        self.from_source = from_source  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineCallActionRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acc is not None:
            result['Acc'] = self.acc
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.act is not None:
            result['Act'] = self.act
        if self.biz is not None:
            result['Biz'] = self.biz
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.from_source is not None:
            result['FromSource'] = self.from_source
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Acc') is not None:
            self.acc = m.get('Acc')
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('Act') is not None:
            self.act = m.get('Act')
        if m.get('Biz') is not None:
            self.biz = m.get('Biz')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('FromSource') is not None:
            self.from_source = m.get('FromSource')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetHotlineCallActionResponseBodyData(TeaModel):
    def __init__(self, action_id=None, bu_id=None, callout_id=None, callout_name=None, case_id=None, channel_id=None,
                 channel_type=None, dep_id=None, is_transfer=None, member_id=None, member_list=None, member_name=None,
                 servicer_id=None, servicer_name=None, sub_touch_id=None, task_id=None, touch_id=None):
        self.action_id = action_id  # type: long
        self.bu_id = bu_id  # type: long
        self.callout_id = callout_id  # type: long
        self.callout_name = callout_name  # type: str
        self.case_id = case_id  # type: long
        self.channel_id = channel_id  # type: str
        self.channel_type = channel_type  # type: long
        self.dep_id = dep_id  # type: long
        self.is_transfer = is_transfer  # type: str
        self.member_id = member_id  # type: long
        self.member_list = member_list  # type: str
        self.member_name = member_name  # type: str
        self.servicer_id = servicer_id  # type: long
        self.servicer_name = servicer_name  # type: str
        self.sub_touch_id = sub_touch_id  # type: long
        self.task_id = task_id  # type: long
        self.touch_id = touch_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineCallActionResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_id is not None:
            result['ActionId'] = self.action_id
        if self.bu_id is not None:
            result['BuId'] = self.bu_id
        if self.callout_id is not None:
            result['CalloutId'] = self.callout_id
        if self.callout_name is not None:
            result['CalloutName'] = self.callout_name
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.dep_id is not None:
            result['DepId'] = self.dep_id
        if self.is_transfer is not None:
            result['IsTransfer'] = self.is_transfer
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_list is not None:
            result['MemberList'] = self.member_list
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.sub_touch_id is not None:
            result['SubTouchId'] = self.sub_touch_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.touch_id is not None:
            result['TouchId'] = self.touch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionId') is not None:
            self.action_id = m.get('ActionId')
        if m.get('BuId') is not None:
            self.bu_id = m.get('BuId')
        if m.get('CalloutId') is not None:
            self.callout_id = m.get('CalloutId')
        if m.get('CalloutName') is not None:
            self.callout_name = m.get('CalloutName')
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('DepId') is not None:
            self.dep_id = m.get('DepId')
        if m.get('IsTransfer') is not None:
            self.is_transfer = m.get('IsTransfer')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberList') is not None:
            self.member_list = m.get('MemberList')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('SubTouchId') is not None:
            self.sub_touch_id = m.get('SubTouchId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TouchId') is not None:
            self.touch_id = m.get('TouchId')
        return self


class GetHotlineCallActionResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetHotlineCallActionResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetHotlineCallActionResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHotlineCallActionResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineCallActionResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetHotlineCallActionResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHotlineCallActionResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineCallActionResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineGroupDetailReportRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids=None, end_date=None, group_ids=None, instance_id=None,
                 page_size=None, start_date=None):
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.group_ids = group_ids  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineGroupDetailReportRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetHotlineGroupDetailReportResponseBodyDataColumns(TeaModel):
    def __init__(self, key=None, title=None):
        self.key = key  # type: str
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineGroupDetailReportResponseBodyDataColumns, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class GetHotlineGroupDetailReportResponseBodyData(TeaModel):
    def __init__(self, columns=None, page=None, page_size=None, rows=None, total=None):
        self.columns = columns  # type: list[GetHotlineGroupDetailReportResponseBodyDataColumns]
        self.page = page  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: list[dict[str, any]]
        self.total = total  # type: int

    def validate(self):
        if self.columns:
            for k in self.columns:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetHotlineGroupDetailReportResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Columns'] = []
        if self.columns is not None:
            for k in self.columns:
                result['Columns'].append(k.to_map() if k else None)
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.columns = []
        if m.get('Columns') is not None:
            for k in m.get('Columns'):
                temp_model = GetHotlineGroupDetailReportResponseBodyDataColumns()
                self.columns.append(temp_model.from_map(k))
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetHotlineGroupDetailReportResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetHotlineGroupDetailReportResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetHotlineGroupDetailReportResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHotlineGroupDetailReportResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineGroupDetailReportResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetHotlineGroupDetailReportResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHotlineGroupDetailReportResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineGroupDetailReportResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineMessageLogRequest(TeaModel):
    def __init__(self, acid=None, instance_id=None):
        self.acid = acid  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineMessageLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetHotlineMessageLogResponseBodyData(TeaModel):
    def __init__(self, acid=None, content=None, end_time=None, mid=None, sender_type=None, start_time=None):
        self.acid = acid  # type: str
        self.content = content  # type: str
        self.end_time = end_time  # type: long
        self.mid = mid  # type: str
        self.sender_type = sender_type  # type: int
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineMessageLogResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.content is not None:
            result['Content'] = self.content
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.mid is not None:
            result['Mid'] = self.mid
        if self.sender_type is not None:
            result['SenderType'] = self.sender_type
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Mid') is not None:
            self.mid = m.get('Mid')
        if m.get('SenderType') is not None:
            self.sender_type = m.get('SenderType')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class GetHotlineMessageLogResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[GetHotlineMessageLogResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetHotlineMessageLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetHotlineMessageLogResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineMessageLogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetHotlineMessageLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHotlineMessageLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineMessageLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineRuntimeInfoRequest(TeaModel):
    def __init__(self, account_name=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineRuntimeInfoRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetHotlineRuntimeInfoResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: dict[str, any]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineRuntimeInfoResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineRuntimeInfoResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetHotlineRuntimeInfoResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHotlineRuntimeInfoResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineRuntimeInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineServiceStatisticsRequest(TeaModel):
    def __init__(self, agent_ids=None, current_page=None, dep_ids=None, end_date=None, exist_agent_grouping=None,
                 exist_department_grouping=None, exist_skill_group_grouping=None, group_ids=None, instance_id=None, page_size=None,
                 start_date=None, time_latitude_type=None):
        self.agent_ids = agent_ids  # type: list[long]
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids = group_ids  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineServiceStatisticsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetHotlineServiceStatisticsShrinkRequest(TeaModel):
    def __init__(self, agent_ids_shrink=None, current_page=None, dep_ids_shrink=None, end_date=None,
                 exist_agent_grouping=None, exist_department_grouping=None, exist_skill_group_grouping=None, group_ids_shrink=None,
                 instance_id=None, page_size=None, start_date=None, time_latitude_type=None):
        self.agent_ids_shrink = agent_ids_shrink  # type: str
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids_shrink = group_ids_shrink  # type: str
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineServiceStatisticsShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetHotlineServiceStatisticsResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: str
        self.total_num = total_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineServiceStatisticsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetHotlineServiceStatisticsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetHotlineServiceStatisticsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetHotlineServiceStatisticsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetHotlineServiceStatisticsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineServiceStatisticsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetHotlineServiceStatisticsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHotlineServiceStatisticsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineServiceStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetHotlineWaitingNumberRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineWaitingNumberRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetHotlineWaitingNumberResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetHotlineWaitingNumberResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetHotlineWaitingNumberResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetHotlineWaitingNumberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetHotlineWaitingNumberResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetHotlineWaitingNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetIndexCurrentValueRequest(TeaModel):
    def __init__(self, dep_ids=None, group_ids=None, instance_id=None):
        self.dep_ids = dep_ids  # type: str
        self.group_ids = group_ids  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetIndexCurrentValueRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetIndexCurrentValueResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[dict[str, any]]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetIndexCurrentValueResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetIndexCurrentValueResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetIndexCurrentValueResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetIndexCurrentValueResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetIndexCurrentValueResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetInstanceListRequest(TeaModel):
    def __init__(self, name=None, page_number=None, page_size=None):
        self.name = name  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetInstanceListResponseBodyCommodityInstances(TeaModel):
    def __init__(self, instance_id=None, name=None):
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetInstanceListResponseBodyCommodityInstances, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class GetInstanceListResponseBody(TeaModel):
    def __init__(self, code=None, commodity_instances=None, http_status_code=None, message=None, page_number=None,
                 page_size=None, request_id=None, success=None, total_count=None):
        self.code = code  # type: str
        self.commodity_instances = commodity_instances  # type: list[GetInstanceListResponseBodyCommodityInstances]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.request_id = request_id  # type: str
        self.success = success  # type: bool
        self.total_count = total_count  # type: int

    def validate(self):
        if self.commodity_instances:
            for k in self.commodity_instances:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetInstanceListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['CommodityInstances'] = []
        if self.commodity_instances is not None:
            for k in self.commodity_instances:
                result['CommodityInstances'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.commodity_instances = []
        if m.get('CommodityInstances') is not None:
            for k in m.get('CommodityInstances'):
                temp_model = GetInstanceListResponseBodyCommodityInstances()
                self.commodity_instances.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class GetInstanceListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetInstanceListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetInstanceListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetInstanceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetMcuLvsIpRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMcuLvsIpRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetMcuLvsIpResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetMcuLvsIpResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetMcuLvsIpResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetMcuLvsIpResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetMcuLvsIpResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetMcuLvsIpResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetNumLocationRequest(TeaModel):
    def __init__(self, client_token=None, instance_id=None, phone_num=None):
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str
        self.phone_num = phone_num  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNumLocationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        return self


class GetNumLocationResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetNumLocationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetNumLocationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetNumLocationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetNumLocationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetNumLocationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOnlineSeatInformationRequest(TeaModel):
    def __init__(self, agent_ids=None, current_page=None, dep_ids=None, end_date=None, instance_id=None,
                 page_size=None, start_date=None):
        self.agent_ids = agent_ids  # type: list[long]
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOnlineSeatInformationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetOnlineSeatInformationShrinkRequest(TeaModel):
    def __init__(self, agent_ids_shrink=None, current_page=None, dep_ids_shrink=None, end_date=None,
                 instance_id=None, page_size=None, start_date=None):
        self.agent_ids_shrink = agent_ids_shrink  # type: str
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOnlineSeatInformationShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetOnlineSeatInformationResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: str
        self.total_num = total_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOnlineSeatInformationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetOnlineSeatInformationResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetOnlineSeatInformationResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetOnlineSeatInformationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetOnlineSeatInformationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetOnlineSeatInformationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetOnlineSeatInformationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetOnlineSeatInformationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOnlineSeatInformationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOnlineServiceVolumeRequest(TeaModel):
    def __init__(self, agent_ids=None, current_page=None, dep_ids=None, end_date=None, exist_agent_grouping=None,
                 exist_department_grouping=None, exist_skill_group_grouping=None, group_ids=None, instance_id=None, page_size=None,
                 start_date=None, time_latitude_type=None):
        self.agent_ids = agent_ids  # type: list[long]
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids = group_ids  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOnlineServiceVolumeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetOnlineServiceVolumeShrinkRequest(TeaModel):
    def __init__(self, agent_ids_shrink=None, current_page=None, dep_ids_shrink=None, end_date=None,
                 exist_agent_grouping=None, exist_department_grouping=None, exist_skill_group_grouping=None, group_ids_shrink=None,
                 instance_id=None, page_size=None, start_date=None, time_latitude_type=None):
        self.agent_ids_shrink = agent_ids_shrink  # type: str
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids_shrink = group_ids_shrink  # type: str
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOnlineServiceVolumeShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetOnlineServiceVolumeResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: str
        self.total_num = total_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOnlineServiceVolumeResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetOnlineServiceVolumeResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetOnlineServiceVolumeResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetOnlineServiceVolumeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetOnlineServiceVolumeResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetOnlineServiceVolumeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetOnlineServiceVolumeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetOnlineServiceVolumeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOnlineServiceVolumeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetOutbounNumListRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOutbounNumListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetOutbounNumListResponseBodyDataNum(TeaModel):
    def __init__(self, description=None, type=None, value=None):
        self.description = description  # type: str
        self.type = type  # type: int
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOutbounNumListResponseBodyDataNum, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetOutbounNumListResponseBodyDataNumGroup(TeaModel):
    def __init__(self, description=None, type=None, value=None):
        self.description = description  # type: str
        self.type = type  # type: int
        self.value = value  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetOutbounNumListResponseBodyDataNumGroup, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class GetOutbounNumListResponseBodyData(TeaModel):
    def __init__(self, num=None, num_group=None):
        self.num = num  # type: list[GetOutbounNumListResponseBodyDataNum]
        self.num_group = num_group  # type: list[GetOutbounNumListResponseBodyDataNumGroup]

    def validate(self):
        if self.num:
            for k in self.num:
                if k:
                    k.validate()
        if self.num_group:
            for k in self.num_group:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetOutbounNumListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Num'] = []
        if self.num is not None:
            for k in self.num:
                result['Num'].append(k.to_map() if k else None)
        result['NumGroup'] = []
        if self.num_group is not None:
            for k in self.num_group:
                result['NumGroup'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.num = []
        if m.get('Num') is not None:
            for k in m.get('Num'):
                temp_model = GetOutbounNumListResponseBodyDataNum()
                self.num.append(temp_model.from_map(k))
        self.num_group = []
        if m.get('NumGroup') is not None:
            for k in m.get('NumGroup'):
                temp_model = GetOutbounNumListResponseBodyDataNumGroup()
                self.num_group.append(temp_model.from_map(k))
        return self


class GetOutbounNumListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetOutbounNumListResponseBodyData
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetOutbounNumListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetOutbounNumListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetOutbounNumListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetOutbounNumListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetOutbounNumListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetOutbounNumListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityProjectDetailRequest(TeaModel):
    def __init__(self, instance_id=None, project_id=None):
        self.instance_id = instance_id  # type: str
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityProjectDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetQualityProjectDetailResponseBodyData(TeaModel):
    def __init__(self, check_freq_type=None, create_time=None, dep_list=None, group_list=None, id=None,
                 modify_time=None, project_name=None, quality_rule_ids=None, quality_type=None, servicer_list=None, status=None,
                 version=None):
        self.check_freq_type = check_freq_type  # type: int
        self.create_time = create_time  # type: str
        self.dep_list = dep_list  # type: list[long]
        self.group_list = group_list  # type: list[long]
        self.id = id  # type: long
        self.modify_time = modify_time  # type: str
        self.project_name = project_name  # type: str
        self.quality_rule_ids = quality_rule_ids  # type: list[long]
        self.quality_type = quality_type  # type: int
        self.servicer_list = servicer_list  # type: list[long]
        self.status = status  # type: int
        self.version = version  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityProjectDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_freq_type is not None:
            result['CheckFreqType'] = self.check_freq_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dep_list is not None:
            result['DepList'] = self.dep_list
        if self.group_list is not None:
            result['GroupList'] = self.group_list
        if self.id is not None:
            result['Id'] = self.id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.quality_rule_ids is not None:
            result['QualityRuleIds'] = self.quality_rule_ids
        if self.quality_type is not None:
            result['QualityType'] = self.quality_type
        if self.servicer_list is not None:
            result['ServicerList'] = self.servicer_list
        if self.status is not None:
            result['Status'] = self.status
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckFreqType') is not None:
            self.check_freq_type = m.get('CheckFreqType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DepList') is not None:
            self.dep_list = m.get('DepList')
        if m.get('GroupList') is not None:
            self.group_list = m.get('GroupList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('QualityRuleIds') is not None:
            self.quality_rule_ids = m.get('QualityRuleIds')
        if m.get('QualityType') is not None:
            self.quality_type = m.get('QualityType')
        if m.get('ServicerList') is not None:
            self.servicer_list = m.get('ServicerList')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class GetQualityProjectDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetQualityProjectDetailResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetQualityProjectDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQualityProjectDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityProjectDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetQualityProjectDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetQualityProjectDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityProjectDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityProjectListRequest(TeaModel):
    def __init__(self, instance_id=None, page_no=None, page_size=None, project_id=None, project_name=None,
                 status=None, check_freq_type=None):
        self.instance_id = instance_id  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.project_id = project_id  # type: long
        self.project_name = project_name  # type: str
        self.status = status  # type: int
        self.check_freq_type = check_freq_type  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityProjectListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.status is not None:
            result['Status'] = self.status
        if self.check_freq_type is not None:
            result['checkFreqType'] = self.check_freq_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('checkFreqType') is not None:
            self.check_freq_type = m.get('checkFreqType')
        return self


class GetQualityProjectListResponseBodyDataQualityProjectList(TeaModel):
    def __init__(self, check_freq_type=None, create_time=None, dep_list=None, group_list=None, id=None,
                 modify_time=None, project_name=None, quality_rule_ids=None, quality_type=None, servicer_list=None, status=None,
                 version=None):
        self.check_freq_type = check_freq_type  # type: int
        self.create_time = create_time  # type: str
        self.dep_list = dep_list  # type: list[long]
        self.group_list = group_list  # type: list[long]
        self.id = id  # type: long
        self.modify_time = modify_time  # type: str
        self.project_name = project_name  # type: str
        self.quality_rule_ids = quality_rule_ids  # type: list[long]
        self.quality_type = quality_type  # type: int
        self.servicer_list = servicer_list  # type: list[long]
        self.status = status  # type: int
        self.version = version  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityProjectListResponseBodyDataQualityProjectList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_freq_type is not None:
            result['CheckFreqType'] = self.check_freq_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.dep_list is not None:
            result['DepList'] = self.dep_list
        if self.group_list is not None:
            result['GroupList'] = self.group_list
        if self.id is not None:
            result['Id'] = self.id
        if self.modify_time is not None:
            result['ModifyTime'] = self.modify_time
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.quality_rule_ids is not None:
            result['QualityRuleIds'] = self.quality_rule_ids
        if self.quality_type is not None:
            result['QualityType'] = self.quality_type
        if self.servicer_list is not None:
            result['ServicerList'] = self.servicer_list
        if self.status is not None:
            result['Status'] = self.status
        if self.version is not None:
            result['Version'] = self.version
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CheckFreqType') is not None:
            self.check_freq_type = m.get('CheckFreqType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DepList') is not None:
            self.dep_list = m.get('DepList')
        if m.get('GroupList') is not None:
            self.group_list = m.get('GroupList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ModifyTime') is not None:
            self.modify_time = m.get('ModifyTime')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('QualityRuleIds') is not None:
            self.quality_rule_ids = m.get('QualityRuleIds')
        if m.get('QualityType') is not None:
            self.quality_type = m.get('QualityType')
        if m.get('ServicerList') is not None:
            self.servicer_list = m.get('ServicerList')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Version') is not None:
            self.version = m.get('Version')
        return self


class GetQualityProjectListResponseBodyData(TeaModel):
    def __init__(self, page_no=None, page_size=None, quality_project_list=None, total=None):
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.quality_project_list = quality_project_list  # type: list[GetQualityProjectListResponseBodyDataQualityProjectList]
        self.total = total  # type: long

    def validate(self):
        if self.quality_project_list:
            for k in self.quality_project_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetQualityProjectListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['QualityProjectList'] = []
        if self.quality_project_list is not None:
            for k in self.quality_project_list:
                result['QualityProjectList'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.quality_project_list = []
        if m.get('QualityProjectList') is not None:
            for k in m.get('QualityProjectList'):
                temp_model = GetQualityProjectListResponseBodyDataQualityProjectList()
                self.quality_project_list.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetQualityProjectListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetQualityProjectListResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetQualityProjectListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQualityProjectListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityProjectListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetQualityProjectListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetQualityProjectListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityProjectListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityProjectLogRequest(TeaModel):
    def __init__(self, instance_id=None, project_id=None):
        self.instance_id = instance_id  # type: str
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityProjectLogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetQualityProjectLogResponseBodyData(TeaModel):
    def __init__(self, action_data=None, action_time=None, action_type=None, project_create_time=None,
                 project_id=None):
        self.action_data = action_data  # type: str
        self.action_time = action_time  # type: str
        self.action_type = action_type  # type: str
        self.project_create_time = project_create_time  # type: str
        self.project_id = project_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityProjectLogResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_data is not None:
            result['ActionData'] = self.action_data
        if self.action_time is not None:
            result['ActionTime'] = self.action_time
        if self.action_type is not None:
            result['ActionType'] = self.action_type
        if self.project_create_time is not None:
            result['ProjectCreateTime'] = self.project_create_time
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionData') is not None:
            self.action_data = m.get('ActionData')
        if m.get('ActionTime') is not None:
            self.action_time = m.get('ActionTime')
        if m.get('ActionType') is not None:
            self.action_type = m.get('ActionType')
        if m.get('ProjectCreateTime') is not None:
            self.project_create_time = m.get('ProjectCreateTime')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        return self


class GetQualityProjectLogResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[GetQualityProjectLogResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetQualityProjectLogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetQualityProjectLogResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityProjectLogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetQualityProjectLogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetQualityProjectLogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityProjectLogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityResultRequest(TeaModel):
    def __init__(self, channel_type=None, group_ids=None, hit_status=None, instance_id=None, page_no=None,
                 page_size=None, project_ids=None, quality_rule_ids=None, touch_end_time=None, touch_start_time=None):
        self.channel_type = channel_type  # type: str
        self.group_ids = group_ids  # type: list[long]
        self.hit_status = hit_status  # type: int
        self.instance_id = instance_id  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.project_ids = project_ids  # type: list[long]
        self.quality_rule_ids = quality_rule_ids  # type: list[long]
        self.touch_end_time = touch_end_time  # type: str
        self.touch_start_time = touch_start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityResultRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.hit_status is not None:
            result['HitStatus'] = self.hit_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.project_ids is not None:
            result['ProjectIds'] = self.project_ids
        if self.quality_rule_ids is not None:
            result['QualityRuleIds'] = self.quality_rule_ids
        if self.touch_end_time is not None:
            result['TouchEndTime'] = self.touch_end_time
        if self.touch_start_time is not None:
            result['TouchStartTime'] = self.touch_start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('HitStatus') is not None:
            self.hit_status = m.get('HitStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ProjectIds') is not None:
            self.project_ids = m.get('ProjectIds')
        if m.get('QualityRuleIds') is not None:
            self.quality_rule_ids = m.get('QualityRuleIds')
        if m.get('TouchEndTime') is not None:
            self.touch_end_time = m.get('TouchEndTime')
        if m.get('TouchStartTime') is not None:
            self.touch_start_time = m.get('TouchStartTime')
        return self


class GetQualityResultResponseBodyDataQualityResultResponseList(TeaModel):
    def __init__(self, channel_type=None, channel_type_name=None, group_id=None, group_name=None, hit_detail=None,
                 hit_status=None, instance_name=None, member_name=None, project_id=None, project_name=None, rule_id=None,
                 rule_name=None, servicer_id=None, servicer_name=None, touch_id=None, touch_start_time=None):
        self.channel_type = channel_type  # type: str
        self.channel_type_name = channel_type_name  # type: str
        self.group_id = group_id  # type: str
        self.group_name = group_name  # type: str
        self.hit_detail = hit_detail  # type: str
        self.hit_status = hit_status  # type: bool
        self.instance_name = instance_name  # type: str
        self.member_name = member_name  # type: str
        self.project_id = project_id  # type: str
        self.project_name = project_name  # type: str
        self.rule_id = rule_id  # type: str
        self.rule_name = rule_name  # type: str
        self.servicer_id = servicer_id  # type: str
        self.servicer_name = servicer_name  # type: str
        self.touch_id = touch_id  # type: str
        self.touch_start_time = touch_start_time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityResultResponseBodyDataQualityResultResponseList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.channel_type_name is not None:
            result['ChannelTypeName'] = self.channel_type_name
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.hit_detail is not None:
            result['HitDetail'] = self.hit_detail
        if self.hit_status is not None:
            result['HitStatus'] = self.hit_status
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.project_id is not None:
            result['ProjectId'] = self.project_id
        if self.project_name is not None:
            result['ProjectName'] = self.project_name
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.touch_id is not None:
            result['TouchId'] = self.touch_id
        if self.touch_start_time is not None:
            result['TouchStartTime'] = self.touch_start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('ChannelTypeName') is not None:
            self.channel_type_name = m.get('ChannelTypeName')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('HitDetail') is not None:
            self.hit_detail = m.get('HitDetail')
        if m.get('HitStatus') is not None:
            self.hit_status = m.get('HitStatus')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('ProjectId') is not None:
            self.project_id = m.get('ProjectId')
        if m.get('ProjectName') is not None:
            self.project_name = m.get('ProjectName')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('TouchId') is not None:
            self.touch_id = m.get('TouchId')
        if m.get('TouchStartTime') is not None:
            self.touch_start_time = m.get('TouchStartTime')
        return self


class GetQualityResultResponseBodyData(TeaModel):
    def __init__(self, page_no=None, page_size=None, quality_result_response_list=None, total_num=None):
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.quality_result_response_list = quality_result_response_list  # type: list[GetQualityResultResponseBodyDataQualityResultResponseList]
        self.total_num = total_num  # type: int

    def validate(self):
        if self.quality_result_response_list:
            for k in self.quality_result_response_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetQualityResultResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['QualityResultResponseList'] = []
        if self.quality_result_response_list is not None:
            for k in self.quality_result_response_list:
                result['QualityResultResponseList'].append(k.to_map() if k else None)
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.quality_result_response_list = []
        if m.get('QualityResultResponseList') is not None:
            for k in m.get('QualityResultResponseList'):
                temp_model = GetQualityResultResponseBodyDataQualityResultResponseList()
                self.quality_result_response_list.append(temp_model.from_map(k))
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetQualityResultResponseBody(TeaModel):
    def __init__(self, channel_type_name=None, code=None, data=None, message=None, request_id=None, success=None):
        self.channel_type_name = channel_type_name  # type: str
        self.code = code  # type: str
        self.data = data  # type: GetQualityResultResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetQualityResultResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type_name is not None:
            result['ChannelTypeName'] = self.channel_type_name
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelTypeName') is not None:
            self.channel_type_name = m.get('ChannelTypeName')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQualityResultResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityResultResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetQualityResultResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetQualityResultResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityRuleDetailRequest(TeaModel):
    def __init__(self, instance_id=None, quality_rule_id=None):
        self.instance_id = instance_id  # type: str
        self.quality_rule_id = quality_rule_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityRuleDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.quality_rule_id is not None:
            result['QualityRuleId'] = self.quality_rule_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('QualityRuleId') is not None:
            self.quality_rule_id = m.get('QualityRuleId')
        return self


class GetQualityRuleDetailResponseBodyData(TeaModel):
    def __init__(self, key_words=None, match_type=None, name=None, rule_create_time=None, rule_id=None,
                 rule_tag=None):
        self.key_words = key_words  # type: list[str]
        self.match_type = match_type  # type: int
        self.name = name  # type: str
        self.rule_create_time = rule_create_time  # type: str
        self.rule_id = rule_id  # type: long
        self.rule_tag = rule_tag  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityRuleDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_words is not None:
            result['KeyWords'] = self.key_words
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_create_time is not None:
            result['RuleCreateTime'] = self.rule_create_time
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_tag is not None:
            result['RuleTag'] = self.rule_tag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('KeyWords') is not None:
            self.key_words = m.get('KeyWords')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleCreateTime') is not None:
            self.rule_create_time = m.get('RuleCreateTime')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleTag') is not None:
            self.rule_tag = m.get('RuleTag')
        return self


class GetQualityRuleDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetQualityRuleDetailResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetQualityRuleDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQualityRuleDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityRuleDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetQualityRuleDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetQualityRuleDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityRuleDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityRuleListRequest(TeaModel):
    def __init__(self, instance_id=None, page_no=None, page_size=None):
        self.instance_id = instance_id  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityRuleListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class GetQualityRuleListResponseBodyDataQualityRuleList(TeaModel):
    def __init__(self, key_words=None, match_type=None, name=None, rule_create_time=None, rule_id=None,
                 rule_tag=None):
        self.key_words = key_words  # type: list[str]
        self.match_type = match_type  # type: int
        self.name = name  # type: str
        self.rule_create_time = rule_create_time  # type: str
        self.rule_id = rule_id  # type: long
        self.rule_tag = rule_tag  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityRuleListResponseBodyDataQualityRuleList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key_words is not None:
            result['KeyWords'] = self.key_words
        if self.match_type is not None:
            result['MatchType'] = self.match_type
        if self.name is not None:
            result['Name'] = self.name
        if self.rule_create_time is not None:
            result['RuleCreateTime'] = self.rule_create_time
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.rule_tag is not None:
            result['RuleTag'] = self.rule_tag
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('KeyWords') is not None:
            self.key_words = m.get('KeyWords')
        if m.get('MatchType') is not None:
            self.match_type = m.get('MatchType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RuleCreateTime') is not None:
            self.rule_create_time = m.get('RuleCreateTime')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('RuleTag') is not None:
            self.rule_tag = m.get('RuleTag')
        return self


class GetQualityRuleListResponseBodyData(TeaModel):
    def __init__(self, page_no=None, page_size=None, quality_rule_list=None, total=None):
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.quality_rule_list = quality_rule_list  # type: list[GetQualityRuleListResponseBodyDataQualityRuleList]
        self.total = total  # type: long

    def validate(self):
        if self.quality_rule_list:
            for k in self.quality_rule_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetQualityRuleListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['QualityRuleList'] = []
        if self.quality_rule_list is not None:
            for k in self.quality_rule_list:
                result['QualityRuleList'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.quality_rule_list = []
        if m.get('QualityRuleList') is not None:
            for k in m.get('QualityRuleList'):
                temp_model = GetQualityRuleListResponseBodyDataQualityRuleList()
                self.quality_rule_list.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class GetQualityRuleListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetQualityRuleListResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetQualityRuleListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQualityRuleListResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityRuleListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetQualityRuleListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetQualityRuleListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityRuleListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQualityRuleTagListRequest(TeaModel):
    def __init__(self, instance_id=None):
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityRuleTagListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetQualityRuleTagListResponseBodyData(TeaModel):
    def __init__(self, rule_tag_id=None, rule_tag_name=None):
        self.rule_tag_id = rule_tag_id  # type: long
        self.rule_tag_name = rule_tag_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQualityRuleTagListResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_tag_id is not None:
            result['RuleTagId'] = self.rule_tag_id
        if self.rule_tag_name is not None:
            result['RuleTagName'] = self.rule_tag_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('RuleTagId') is not None:
            self.rule_tag_id = m.get('RuleTagId')
        if m.get('RuleTagName') is not None:
            self.rule_tag_name = m.get('RuleTagName')
        return self


class GetQualityRuleTagListResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[GetQualityRuleTagListResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(GetQualityRuleTagListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = GetQualityRuleTagListResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQualityRuleTagListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetQualityRuleTagListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetQualityRuleTagListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQualityRuleTagListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetQueueInformationRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids=None, end_date=None, exist_department_grouping=None,
                 exist_skill_group_grouping=None, group_ids=None, instance_id=None, page_size=None, start_date=None):
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids = group_ids  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQueueInformationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetQueueInformationShrinkRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids_shrink=None, end_date=None, exist_department_grouping=None,
                 exist_skill_group_grouping=None, group_ids_shrink=None, instance_id=None, page_size=None, start_date=None):
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids_shrink = group_ids_shrink  # type: str
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQueueInformationShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetQueueInformationResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: str
        self.total_num = total_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetQueueInformationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetQueueInformationResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetQueueInformationResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetQueueInformationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetQueueInformationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetQueueInformationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetQueueInformationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetQueueInformationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetQueueInformationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRecordDataRequest(TeaModel):
    def __init__(self, acid=None, instance_id=None):
        self.acid = acid  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRecordDataRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetRecordDataResponseBodyData(TeaModel):
    def __init__(self, acid=None, oss_link=None):
        self.acid = acid  # type: str
        self.oss_link = oss_link  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRecordDataResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.oss_link is not None:
            result['OssLink'] = self.oss_link
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('OssLink') is not None:
            self.oss_link = m.get('OssLink')
        return self


class GetRecordDataResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetRecordDataResponseBodyData
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetRecordDataResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetRecordDataResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRecordDataResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetRecordDataResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRecordDataResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRecordDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRecordUrlRequest(TeaModel):
    def __init__(self, acid=None, instance_id=None, record_type=None):
        self.acid = acid  # type: str
        self.instance_id = instance_id  # type: str
        self.record_type = record_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRecordUrlRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.record_type is not None:
            result['RecordType'] = self.record_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RecordType') is not None:
            self.record_type = m.get('RecordType')
        return self


class GetRecordUrlResponseBodyData(TeaModel):
    def __init__(self, acid=None, oss_link=None):
        self.acid = acid  # type: str
        self.oss_link = oss_link  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRecordUrlResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.oss_link is not None:
            result['OssLink'] = self.oss_link
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('OssLink') is not None:
            self.oss_link = m.get('OssLink')
        return self


class GetRecordUrlResponseBody(TeaModel):
    def __init__(self, data=None, message=None, request_id=None, success=None):
        self.data = data  # type: GetRecordUrlResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetRecordUrlResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = GetRecordUrlResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRecordUrlResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetRecordUrlResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRecordUrlResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRecordUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetRtcTokenRequest(TeaModel):
    def __init__(self, account_name=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRtcTokenRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class GetRtcTokenResponseBodyData(TeaModel):
    def __init__(self, account_name=None, rtc_id=None, token=None):
        self.account_name = account_name  # type: str
        self.rtc_id = rtc_id  # type: str
        self.token = token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetRtcTokenResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.rtc_id is not None:
            result['RtcId'] = self.rtc_id
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('RtcId') is not None:
            self.rtc_id = m.get('RtcId')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class GetRtcTokenResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetRtcTokenResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetRtcTokenResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetRtcTokenResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetRtcTokenResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetRtcTokenResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetRtcTokenResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetRtcTokenResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSeatInformationRequest(TeaModel):
    def __init__(self, instance_id=None, current_page=None, dep_ids=None, end_date=None,
                 exist_department_grouping=None, page_size=None, start_date=None):
        self.instance_id = instance_id  # type: str
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSeatInformationRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_page is not None:
            result['currentPage'] = self.current_page
        if self.dep_ids is not None:
            result['depIds'] = self.dep_ids
        if self.end_date is not None:
            result['endDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['existDepartmentGrouping'] = self.exist_department_grouping
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.start_date is not None:
            result['startDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('currentPage') is not None:
            self.current_page = m.get('currentPage')
        if m.get('depIds') is not None:
            self.dep_ids = m.get('depIds')
        if m.get('endDate') is not None:
            self.end_date = m.get('endDate')
        if m.get('existDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('existDepartmentGrouping')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('startDate') is not None:
            self.start_date = m.get('startDate')
        return self


class GetSeatInformationShrinkRequest(TeaModel):
    def __init__(self, instance_id=None, current_page=None, dep_ids_shrink=None, end_date=None,
                 exist_department_grouping=None, page_size=None, start_date=None):
        self.instance_id = instance_id  # type: str
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSeatInformationShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.current_page is not None:
            result['currentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['depIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['endDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['existDepartmentGrouping'] = self.exist_department_grouping
        if self.page_size is not None:
            result['pageSize'] = self.page_size
        if self.start_date is not None:
            result['startDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('currentPage') is not None:
            self.current_page = m.get('currentPage')
        if m.get('depIds') is not None:
            self.dep_ids_shrink = m.get('depIds')
        if m.get('endDate') is not None:
            self.end_date = m.get('endDate')
        if m.get('existDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('existDepartmentGrouping')
        if m.get('pageSize') is not None:
            self.page_size = m.get('pageSize')
        if m.get('startDate') is not None:
            self.start_date = m.get('startDate')
        return self


class GetSeatInformationResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rowr=None, total_num=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.rowr = rowr  # type: str
        self.total_num = total_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSeatInformationResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rowr is not None:
            result['Rowr'] = self.rowr
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rowr') is not None:
            self.rowr = m.get('Rowr')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSeatInformationResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetSeatInformationResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSeatInformationResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSeatInformationResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSeatInformationResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSeatInformationResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSeatInformationResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSeatInformationResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSkillGroupAgentStatusDetailsRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids=None, end_date=None, exist_department_grouping=None,
                 exist_skill_group_grouping=None, group_ids=None, instance_id=None, page_size=None, start_date=None):
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids = group_ids  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupAgentStatusDetailsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupAgentStatusDetailsShrinkRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids_shrink=None, end_date=None, exist_department_grouping=None,
                 exist_skill_group_grouping=None, group_ids_shrink=None, instance_id=None, page_size=None, start_date=None):
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids_shrink = group_ids_shrink  # type: str
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupAgentStatusDetailsShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupAgentStatusDetailsResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.rows = rows  # type: str
        self.total_num = total_num  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupAgentStatusDetailsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSkillGroupAgentStatusDetailsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetSkillGroupAgentStatusDetailsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSkillGroupAgentStatusDetailsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSkillGroupAgentStatusDetailsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSkillGroupAgentStatusDetailsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSkillGroupAgentStatusDetailsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSkillGroupAgentStatusDetailsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSkillGroupAgentStatusDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSkillGroupAndAgentStatusSummaryRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids=None, end_date=None, exist_department_grouping=None,
                 exist_skill_group_grouping=None, group_ids=None, instance_id=None, page_size=None, start_date=None):
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids = group_ids  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupAndAgentStatusSummaryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupAndAgentStatusSummaryShrinkRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids_shrink=None, end_date=None, exist_department_grouping=None,
                 exist_skill_group_grouping=None, group_ids_shrink=None, instance_id=None, page_size=None, start_date=None):
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids_shrink = group_ids_shrink  # type: str
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupAndAgentStatusSummaryShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupAndAgentStatusSummaryResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: str
        self.total_num = total_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupAndAgentStatusSummaryResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSkillGroupAndAgentStatusSummaryResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetSkillGroupAndAgentStatusSummaryResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSkillGroupAndAgentStatusSummaryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSkillGroupAndAgentStatusSummaryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSkillGroupAndAgentStatusSummaryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSkillGroupAndAgentStatusSummaryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSkillGroupAndAgentStatusSummaryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSkillGroupAndAgentStatusSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSkillGroupLatitudeStateRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids=None, end_date=None, exist_department_grouping=None,
                 exist_skill_group_grouping=None, group_ids=None, instance_id=None, page_size=None, start_date=None):
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids = group_ids  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupLatitudeStateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupLatitudeStateShrinkRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids_shrink=None, end_date=None, exist_department_grouping=None,
                 exist_skill_group_grouping=None, group_ids_shrink=None, instance_id=None, page_size=None, start_date=None):
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids_shrink = group_ids_shrink  # type: str
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupLatitudeStateShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupLatitudeStateResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: str
        self.total_num = total_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupLatitudeStateResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSkillGroupLatitudeStateResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetSkillGroupLatitudeStateResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSkillGroupLatitudeStateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSkillGroupLatitudeStateResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSkillGroupLatitudeStateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSkillGroupLatitudeStateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSkillGroupLatitudeStateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSkillGroupLatitudeStateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSkillGroupServiceCapabilityRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids=None, end_date=None, exist_department_grouping=None,
                 exist_skill_group_grouping=None, group_ids=None, instance_id=None, page_size=None, start_date=None):
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids = group_ids  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupServiceCapabilityRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupServiceCapabilityShrinkRequest(TeaModel):
    def __init__(self, current_page=None, dep_ids_shrink=None, end_date=None, exist_department_grouping=None,
                 exist_skill_group_grouping=None, group_ids_shrink=None, instance_id=None, page_size=None, start_date=None):
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids_shrink = group_ids_shrink  # type: str
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupServiceCapabilityShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        return self


class GetSkillGroupServiceCapabilityResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: str
        self.total_num = total_num  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupServiceCapabilityResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSkillGroupServiceCapabilityResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetSkillGroupServiceCapabilityResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSkillGroupServiceCapabilityResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSkillGroupServiceCapabilityResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSkillGroupServiceCapabilityResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSkillGroupServiceCapabilityResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSkillGroupServiceCapabilityResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSkillGroupServiceCapabilityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSkillGroupServiceStatusRequest(TeaModel):
    def __init__(self, agent_ids=None, current_page=None, dep_ids=None, end_date=None, exist_agent_grouping=None,
                 exist_channel_instance_grouping=None, exist_department_grouping=None, exist_robot_instance_grouping=None,
                 exist_skill_group_grouping=None, group_ids=None, instance_id=None, page_size=None, start_date=None, time_latitude_type=None):
        self.agent_ids = agent_ids  # type: list[long]
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_channel_instance_grouping = exist_channel_instance_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_robot_instance_grouping = exist_robot_instance_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids = group_ids  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupServiceStatusRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_channel_instance_grouping is not None:
            result['ExistChannelInstanceGrouping'] = self.exist_channel_instance_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_robot_instance_grouping is not None:
            result['ExistRobotInstanceGrouping'] = self.exist_robot_instance_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistChannelInstanceGrouping') is not None:
            self.exist_channel_instance_grouping = m.get('ExistChannelInstanceGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistRobotInstanceGrouping') is not None:
            self.exist_robot_instance_grouping = m.get('ExistRobotInstanceGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetSkillGroupServiceStatusShrinkRequest(TeaModel):
    def __init__(self, agent_ids_shrink=None, current_page=None, dep_ids_shrink=None, end_date=None,
                 exist_agent_grouping=None, exist_channel_instance_grouping=None, exist_department_grouping=None,
                 exist_robot_instance_grouping=None, exist_skill_group_grouping=None, group_ids_shrink=None, instance_id=None, page_size=None,
                 start_date=None, time_latitude_type=None):
        self.agent_ids_shrink = agent_ids_shrink  # type: str
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_channel_instance_grouping = exist_channel_instance_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_robot_instance_grouping = exist_robot_instance_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids_shrink = group_ids_shrink  # type: str
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupServiceStatusShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_channel_instance_grouping is not None:
            result['ExistChannelInstanceGrouping'] = self.exist_channel_instance_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_robot_instance_grouping is not None:
            result['ExistRobotInstanceGrouping'] = self.exist_robot_instance_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistChannelInstanceGrouping') is not None:
            self.exist_channel_instance_grouping = m.get('ExistChannelInstanceGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistRobotInstanceGrouping') is not None:
            self.exist_robot_instance_grouping = m.get('ExistRobotInstanceGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetSkillGroupServiceStatusResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: int
        self.page_size = page_size  # type: int
        self.rows = rows  # type: str
        self.total_num = total_num  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupServiceStatusResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSkillGroupServiceStatusResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetSkillGroupServiceStatusResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSkillGroupServiceStatusResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSkillGroupServiceStatusResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSkillGroupServiceStatusResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSkillGroupServiceStatusResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSkillGroupServiceStatusResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSkillGroupServiceStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class GetSkillGroupStatusTotalRequest(TeaModel):
    def __init__(self, agent_ids=None, current_page=None, dep_ids=None, end_date=None, exist_agent_grouping=None,
                 exist_department_grouping=None, exist_skill_group_grouping=None, group_ids=None, instance_id=None, page_size=None,
                 start_date=None, time_latitude_type=None):
        self.agent_ids = agent_ids  # type: list[long]
        self.current_page = current_page  # type: int
        self.dep_ids = dep_ids  # type: list[long]
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids = group_ids  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupStatusTotalRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids is not None:
            result['DepIds'] = self.dep_ids
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetSkillGroupStatusTotalShrinkRequest(TeaModel):
    def __init__(self, agent_ids_shrink=None, current_page=None, dep_ids_shrink=None, end_date=None,
                 exist_agent_grouping=None, exist_department_grouping=None, exist_skill_group_grouping=None, group_ids_shrink=None,
                 instance_id=None, page_size=None, start_date=None, time_latitude_type=None):
        self.agent_ids_shrink = agent_ids_shrink  # type: str
        self.current_page = current_page  # type: int
        self.dep_ids_shrink = dep_ids_shrink  # type: str
        self.end_date = end_date  # type: long
        self.exist_agent_grouping = exist_agent_grouping  # type: bool
        self.exist_department_grouping = exist_department_grouping  # type: bool
        self.exist_skill_group_grouping = exist_skill_group_grouping  # type: bool
        self.group_ids_shrink = group_ids_shrink  # type: str
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.start_date = start_date  # type: long
        self.time_latitude_type = time_latitude_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupStatusTotalShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dep_ids_shrink is not None:
            result['DepIds'] = self.dep_ids_shrink
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.exist_agent_grouping is not None:
            result['ExistAgentGrouping'] = self.exist_agent_grouping
        if self.exist_department_grouping is not None:
            result['ExistDepartmentGrouping'] = self.exist_department_grouping
        if self.exist_skill_group_grouping is not None:
            result['ExistSkillGroupGrouping'] = self.exist_skill_group_grouping
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.time_latitude_type is not None:
            result['TimeLatitudeType'] = self.time_latitude_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepIds') is not None:
            self.dep_ids_shrink = m.get('DepIds')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('ExistAgentGrouping') is not None:
            self.exist_agent_grouping = m.get('ExistAgentGrouping')
        if m.get('ExistDepartmentGrouping') is not None:
            self.exist_department_grouping = m.get('ExistDepartmentGrouping')
        if m.get('ExistSkillGroupGrouping') is not None:
            self.exist_skill_group_grouping = m.get('ExistSkillGroupGrouping')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('TimeLatitudeType') is not None:
            self.time_latitude_type = m.get('TimeLatitudeType')
        return self


class GetSkillGroupStatusTotalResponseBodyData(TeaModel):
    def __init__(self, page_num=None, page_size=None, rows=None, total_num=None):
        self.page_num = page_num  # type: long
        self.page_size = page_size  # type: long
        self.rows = rows  # type: str
        self.total_num = total_num  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(GetSkillGroupStatusTotalResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_num is not None:
            result['PageNum'] = self.page_num
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rows is not None:
            result['Rows'] = self.rows
        if self.total_num is not None:
            result['TotalNum'] = self.total_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNum') is not None:
            self.page_num = m.get('PageNum')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Rows') is not None:
            self.rows = m.get('Rows')
        if m.get('TotalNum') is not None:
            self.total_num = m.get('TotalNum')
        return self


class GetSkillGroupStatusTotalResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: GetSkillGroupStatusTotalResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(GetSkillGroupStatusTotalResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = GetSkillGroupStatusTotalResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class GetSkillGroupStatusTotalResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: GetSkillGroupStatusTotalResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(GetSkillGroupStatusTotalResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = GetSkillGroupStatusTotalResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HangUpDoubleCallRequest(TeaModel):
    def __init__(self, acid=None, instance_id=None):
        self.acid = acid  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HangUpDoubleCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class HangUpDoubleCallResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(HangUpDoubleCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class HangUpDoubleCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: HangUpDoubleCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HangUpDoubleCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HangUpDoubleCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HangupCallRequest(TeaModel):
    def __init__(self, account_name=None, call_id=None, client_token=None, connection_id=None, instance_id=None,
                 job_id=None):
        self.account_name = account_name  # type: str
        self.call_id = call_id  # type: str
        self.client_token = client_token  # type: str
        self.connection_id = connection_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HangupCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class HangupCallResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(HangupCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class HangupCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: HangupCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HangupCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HangupCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HangupThirdCallRequest(TeaModel):
    def __init__(self, account_name=None, call_id=None, client_token=None, connection_id=None, instance_id=None,
                 job_id=None):
        self.account_name = account_name  # type: str
        self.call_id = call_id  # type: str
        self.client_token = client_token  # type: str
        self.connection_id = connection_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HangupThirdCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class HangupThirdCallResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(HangupThirdCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class HangupThirdCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: HangupThirdCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HangupThirdCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HangupThirdCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HoldCallRequest(TeaModel):
    def __init__(self, account_name=None, call_id=None, client_token=None, connection_id=None, instance_id=None,
                 job_id=None):
        self.account_name = account_name  # type: str
        self.call_id = call_id  # type: str
        self.client_token = client_token  # type: str
        self.connection_id = connection_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HoldCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class HoldCallResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(HoldCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class HoldCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: HoldCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HoldCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HoldCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class HotlineSessionQueryRequest(TeaModel):
    def __init__(self, acid=None, acid_list=None, call_result=None, call_result_list=None, call_type=None,
                 call_type_list=None, called_number=None, called_number_list=None, calling_number=None, calling_number_list=None,
                 group_id=None, group_id_list=None, group_name=None, id=None, instance_id=None, member_id=None,
                 member_id_list=None, member_name=None, page_no=None, page_size=None, params=None, query_end_time=None,
                 query_start_time=None, request_id=None, servicer_id=None, servicer_id_list=None, servicer_name=None):
        self.acid = acid  # type: str
        self.acid_list = acid_list  # type: list[str]
        self.call_result = call_result  # type: str
        self.call_result_list = call_result_list  # type: list[str]
        self.call_type = call_type  # type: int
        self.call_type_list = call_type_list  # type: list[int]
        self.called_number = called_number  # type: str
        self.called_number_list = called_number_list  # type: list[str]
        self.calling_number = calling_number  # type: str
        self.calling_number_list = calling_number_list  # type: list[str]
        self.group_id = group_id  # type: long
        self.group_id_list = group_id_list  # type: list[long]
        self.group_name = group_name  # type: str
        self.id = id  # type: str
        self.instance_id = instance_id  # type: str
        self.member_id = member_id  # type: str
        self.member_id_list = member_id_list  # type: list[str]
        self.member_name = member_name  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.params = params  # type: str
        self.query_end_time = query_end_time  # type: long
        self.query_start_time = query_start_time  # type: long
        self.request_id = request_id  # type: str
        self.servicer_id = servicer_id  # type: str
        self.servicer_id_list = servicer_id_list  # type: list[str]
        self.servicer_name = servicer_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotlineSessionQueryRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.acid_list is not None:
            result['AcidList'] = self.acid_list
        if self.call_result is not None:
            result['CallResult'] = self.call_result
        if self.call_result_list is not None:
            result['CallResultList'] = self.call_result_list
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.call_type_list is not None:
            result['CallTypeList'] = self.call_type_list
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.called_number_list is not None:
            result['CalledNumberList'] = self.called_number_list
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.calling_number_list is not None:
            result['CallingNumberList'] = self.calling_number_list
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_id_list is not None:
            result['MemberIdList'] = self.member_id_list
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.params is not None:
            result['Params'] = self.params
        if self.query_end_time is not None:
            result['QueryEndTime'] = self.query_end_time
        if self.query_start_time is not None:
            result['QueryStartTime'] = self.query_start_time
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_id_list is not None:
            result['ServicerIdList'] = self.servicer_id_list
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('AcidList') is not None:
            self.acid_list = m.get('AcidList')
        if m.get('CallResult') is not None:
            self.call_result = m.get('CallResult')
        if m.get('CallResultList') is not None:
            self.call_result_list = m.get('CallResultList')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('CallTypeList') is not None:
            self.call_type_list = m.get('CallTypeList')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CalledNumberList') is not None:
            self.called_number_list = m.get('CalledNumberList')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('CallingNumberList') is not None:
            self.calling_number_list = m.get('CallingNumberList')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberIdList') is not None:
            self.member_id_list = m.get('MemberIdList')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('QueryEndTime') is not None:
            self.query_end_time = m.get('QueryEndTime')
        if m.get('QueryStartTime') is not None:
            self.query_start_time = m.get('QueryStartTime')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerIdList') is not None:
            self.servicer_id_list = m.get('ServicerIdList')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        return self


class HotlineSessionQueryResponseBodyDataCallDetailRecord(TeaModel):
    def __init__(self, acid=None, active_transfer_id=None, call_continue_time=None, call_result=None,
                 call_type=None, called_number=None, calling_number=None, create_time=None, evaluation_level=None,
                 evaluation_score=None, group_id=None, group_name=None, hang_up_role=None, hang_up_time=None, id=None,
                 in_queue_time=None, member_id=None, member_name=None, out_queue_time=None, passive_transfer_id=None,
                 passive_transfer_id_type=None, pick_up_time=None, queue_up_continue_time=None, ring_continue_time=None, ring_end_time=None,
                 ring_start_time=None, servicer_id=None, servicer_name=None, trunk_call=None):
        self.acid = acid  # type: str
        self.active_transfer_id = active_transfer_id  # type: str
        self.call_continue_time = call_continue_time  # type: int
        self.call_result = call_result  # type: str
        self.call_type = call_type  # type: int
        self.called_number = called_number  # type: str
        self.calling_number = calling_number  # type: str
        self.create_time = create_time  # type: str
        self.evaluation_level = evaluation_level  # type: int
        self.evaluation_score = evaluation_score  # type: int
        self.group_id = group_id  # type: long
        self.group_name = group_name  # type: str
        self.hang_up_role = hang_up_role  # type: str
        self.hang_up_time = hang_up_time  # type: str
        self.id = id  # type: str
        self.in_queue_time = in_queue_time  # type: str
        self.member_id = member_id  # type: str
        self.member_name = member_name  # type: str
        self.out_queue_time = out_queue_time  # type: str
        self.passive_transfer_id = passive_transfer_id  # type: str
        self.passive_transfer_id_type = passive_transfer_id_type  # type: str
        self.pick_up_time = pick_up_time  # type: str
        self.queue_up_continue_time = queue_up_continue_time  # type: int
        self.ring_continue_time = ring_continue_time  # type: int
        self.ring_end_time = ring_end_time  # type: str
        self.ring_start_time = ring_start_time  # type: str
        self.servicer_id = servicer_id  # type: str
        self.servicer_name = servicer_name  # type: str
        self.trunk_call = trunk_call  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(HotlineSessionQueryResponseBodyDataCallDetailRecord, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        if self.active_transfer_id is not None:
            result['ActiveTransferId'] = self.active_transfer_id
        if self.call_continue_time is not None:
            result['CallContinueTime'] = self.call_continue_time
        if self.call_result is not None:
            result['CallResult'] = self.call_result
        if self.call_type is not None:
            result['CallType'] = self.call_type
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.evaluation_score is not None:
            result['EvaluationScore'] = self.evaluation_score
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.hang_up_role is not None:
            result['HangUpRole'] = self.hang_up_role
        if self.hang_up_time is not None:
            result['HangUpTime'] = self.hang_up_time
        if self.id is not None:
            result['Id'] = self.id
        if self.in_queue_time is not None:
            result['InQueueTime'] = self.in_queue_time
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.out_queue_time is not None:
            result['OutQueueTime'] = self.out_queue_time
        if self.passive_transfer_id is not None:
            result['PassiveTransferId'] = self.passive_transfer_id
        if self.passive_transfer_id_type is not None:
            result['PassiveTransferIdType'] = self.passive_transfer_id_type
        if self.pick_up_time is not None:
            result['PickUpTime'] = self.pick_up_time
        if self.queue_up_continue_time is not None:
            result['QueueUpContinueTime'] = self.queue_up_continue_time
        if self.ring_continue_time is not None:
            result['RingContinueTime'] = self.ring_continue_time
        if self.ring_end_time is not None:
            result['RingEndTime'] = self.ring_end_time
        if self.ring_start_time is not None:
            result['RingStartTime'] = self.ring_start_time
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.trunk_call is not None:
            result['TrunkCall'] = self.trunk_call
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        if m.get('ActiveTransferId') is not None:
            self.active_transfer_id = m.get('ActiveTransferId')
        if m.get('CallContinueTime') is not None:
            self.call_continue_time = m.get('CallContinueTime')
        if m.get('CallResult') is not None:
            self.call_result = m.get('CallResult')
        if m.get('CallType') is not None:
            self.call_type = m.get('CallType')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('EvaluationScore') is not None:
            self.evaluation_score = m.get('EvaluationScore')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('HangUpRole') is not None:
            self.hang_up_role = m.get('HangUpRole')
        if m.get('HangUpTime') is not None:
            self.hang_up_time = m.get('HangUpTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InQueueTime') is not None:
            self.in_queue_time = m.get('InQueueTime')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('OutQueueTime') is not None:
            self.out_queue_time = m.get('OutQueueTime')
        if m.get('PassiveTransferId') is not None:
            self.passive_transfer_id = m.get('PassiveTransferId')
        if m.get('PassiveTransferIdType') is not None:
            self.passive_transfer_id_type = m.get('PassiveTransferIdType')
        if m.get('PickUpTime') is not None:
            self.pick_up_time = m.get('PickUpTime')
        if m.get('QueueUpContinueTime') is not None:
            self.queue_up_continue_time = m.get('QueueUpContinueTime')
        if m.get('RingContinueTime') is not None:
            self.ring_continue_time = m.get('RingContinueTime')
        if m.get('RingEndTime') is not None:
            self.ring_end_time = m.get('RingEndTime')
        if m.get('RingStartTime') is not None:
            self.ring_start_time = m.get('RingStartTime')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('TrunkCall') is not None:
            self.trunk_call = m.get('TrunkCall')
        return self


class HotlineSessionQueryResponseBodyData(TeaModel):
    def __init__(self, call_detail_record=None, page_number=None, page_size=None, total_count=None):
        self.call_detail_record = call_detail_record  # type: list[HotlineSessionQueryResponseBodyDataCallDetailRecord]
        self.page_number = page_number  # type: int
        self.page_size = page_size  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.call_detail_record:
            for k in self.call_detail_record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(HotlineSessionQueryResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CallDetailRecord'] = []
        if self.call_detail_record is not None:
            for k in self.call_detail_record:
                result['CallDetailRecord'].append(k.to_map() if k else None)
        if self.page_number is not None:
            result['PageNumber'] = self.page_number
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.call_detail_record = []
        if m.get('CallDetailRecord') is not None:
            for k in m.get('CallDetailRecord'):
                temp_model = HotlineSessionQueryResponseBodyDataCallDetailRecord()
                self.call_detail_record.append(temp_model.from_map(k))
        if m.get('PageNumber') is not None:
            self.page_number = m.get('PageNumber')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class HotlineSessionQueryResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: HotlineSessionQueryResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(HotlineSessionQueryResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = HotlineSessionQueryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class HotlineSessionQueryResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: HotlineSessionQueryResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(HotlineSessionQueryResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = HotlineSessionQueryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InsertAiOutboundPhoneNumsRequestDetails(TeaModel):
    def __init__(self, biz_data=None, phone_num=None):
        self.biz_data = biz_data  # type: str
        self.phone_num = phone_num  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InsertAiOutboundPhoneNumsRequestDetails, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_data is not None:
            result['BizData'] = self.biz_data
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizData') is not None:
            self.biz_data = m.get('BizData')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        return self


class InsertAiOutboundPhoneNumsRequest(TeaModel):
    def __init__(self, batch_version=None, details=None, instance_id=None, task_id=None):
        self.batch_version = batch_version  # type: int
        self.details = details  # type: list[InsertAiOutboundPhoneNumsRequestDetails]
        self.instance_id = instance_id  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        if self.details:
            for k in self.details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(InsertAiOutboundPhoneNumsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_version is not None:
            result['BatchVersion'] = self.batch_version
        result['Details'] = []
        if self.details is not None:
            for k in self.details:
                result['Details'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BatchVersion') is not None:
            self.batch_version = m.get('BatchVersion')
        self.details = []
        if m.get('Details') is not None:
            for k in m.get('Details'):
                temp_model = InsertAiOutboundPhoneNumsRequestDetails()
                self.details.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class InsertAiOutboundPhoneNumsShrinkRequest(TeaModel):
    def __init__(self, batch_version=None, details_shrink=None, instance_id=None, task_id=None):
        self.batch_version = batch_version  # type: int
        self.details_shrink = details_shrink  # type: str
        self.instance_id = instance_id  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(InsertAiOutboundPhoneNumsShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.batch_version is not None:
            result['BatchVersion'] = self.batch_version
        if self.details_shrink is not None:
            result['Details'] = self.details_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BatchVersion') is not None:
            self.batch_version = m.get('BatchVersion')
        if m.get('Details') is not None:
            self.details_shrink = m.get('Details')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class InsertAiOutboundPhoneNumsResponseBodyDataFailInfo(TeaModel):
    def __init__(self, biz_data=None, msg=None, phone_num=None):
        self.biz_data = biz_data  # type: str
        self.msg = msg  # type: str
        self.phone_num = phone_num  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(InsertAiOutboundPhoneNumsResponseBodyDataFailInfo, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.biz_data is not None:
            result['BizData'] = self.biz_data
        if self.msg is not None:
            result['Msg'] = self.msg
        if self.phone_num is not None:
            result['PhoneNum'] = self.phone_num
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BizData') is not None:
            self.biz_data = m.get('BizData')
        if m.get('Msg') is not None:
            self.msg = m.get('Msg')
        if m.get('PhoneNum') is not None:
            self.phone_num = m.get('PhoneNum')
        return self


class InsertAiOutboundPhoneNumsResponseBodyData(TeaModel):
    def __init__(self, fail_info=None, success_count=None, total_count=None):
        self.fail_info = fail_info  # type: list[InsertAiOutboundPhoneNumsResponseBodyDataFailInfo]
        self.success_count = success_count  # type: int
        self.total_count = total_count  # type: int

    def validate(self):
        if self.fail_info:
            for k in self.fail_info:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(InsertAiOutboundPhoneNumsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FailInfo'] = []
        if self.fail_info is not None:
            for k in self.fail_info:
                result['FailInfo'].append(k.to_map() if k else None)
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.fail_info = []
        if m.get('FailInfo') is not None:
            for k in m.get('FailInfo'):
                temp_model = InsertAiOutboundPhoneNumsResponseBodyDataFailInfo()
                self.fail_info.append(temp_model.from_map(k))
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class InsertAiOutboundPhoneNumsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: InsertAiOutboundPhoneNumsResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(InsertAiOutboundPhoneNumsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = InsertAiOutboundPhoneNumsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InsertAiOutboundPhoneNumsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: InsertAiOutboundPhoneNumsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InsertAiOutboundPhoneNumsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InsertAiOutboundPhoneNumsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class InsertTaskDetailRequest(TeaModel):
    def __init__(self, call_infos=None, instance_id=None, outbound_task_id=None):
        self.call_infos = call_infos  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_task_id = outbound_task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(InsertTaskDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_infos is not None:
            result['CallInfos'] = self.call_infos
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_task_id is not None:
            result['OutboundTaskId'] = self.outbound_task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallInfos') is not None:
            self.call_infos = m.get('CallInfos')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundTaskId') is not None:
            self.outbound_task_id = m.get('OutboundTaskId')
        return self


class InsertTaskDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(InsertTaskDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class InsertTaskDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: InsertTaskDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(InsertTaskDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = InsertTaskDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class JoinThirdCallRequest(TeaModel):
    def __init__(self, account_name=None, call_id=None, client_token=None, connection_id=None,
                 hold_connection_id=None, instance_id=None, job_id=None):
        self.account_name = account_name  # type: str
        self.call_id = call_id  # type: str
        self.client_token = client_token  # type: str
        self.connection_id = connection_id  # type: str
        self.hold_connection_id = hold_connection_id  # type: str
        self.instance_id = instance_id  # type: str
        self.job_id = job_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(JoinThirdCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.hold_connection_id is not None:
            result['HoldConnectionId'] = self.hold_connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.job_id is not None:
            result['JobId'] = self.job_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('HoldConnectionId') is not None:
            self.hold_connection_id = m.get('HoldConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        return self


class JoinThirdCallResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(JoinThirdCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class JoinThirdCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: JoinThirdCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(JoinThirdCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = JoinThirdCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAgentBySkillGroupIdRequest(TeaModel):
    def __init__(self, client_token=None, instance_id=None, skill_group_id=None):
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentBySkillGroupIdRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class ListAgentBySkillGroupIdResponseBodyData(TeaModel):
    def __init__(self, account_name=None, agent_id=None, display_name=None, status=None, tenant_id=None):
        self.account_name = account_name  # type: str
        self.agent_id = agent_id  # type: long
        self.display_name = display_name  # type: str
        self.status = status  # type: int
        self.tenant_id = tenant_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAgentBySkillGroupIdResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.agent_id is not None:
            result['AgentId'] = self.agent_id
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.status is not None:
            result['Status'] = self.status
        if self.tenant_id is not None:
            result['TenantId'] = self.tenant_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AgentId') is not None:
            self.agent_id = m.get('AgentId')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TenantId') is not None:
            self.tenant_id = m.get('TenantId')
        return self


class ListAgentBySkillGroupIdResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListAgentBySkillGroupIdResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAgentBySkillGroupIdResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAgentBySkillGroupIdResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAgentBySkillGroupIdResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAgentBySkillGroupIdResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAgentBySkillGroupIdResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAgentBySkillGroupIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListAiccsRobotRequest(TeaModel):
    def __init__(self, owner_id=None, resource_owner_account=None, resource_owner_id=None, robot_name=None):
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.robot_name = robot_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAiccsRobotRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.robot_name is not None:
            result['RobotName'] = self.robot_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RobotName') is not None:
            self.robot_name = m.get('RobotName')
        return self


class ListAiccsRobotResponseBodyData(TeaModel):
    def __init__(self, at_profession=None, at_sence=None, id=None, robot_name=None, robot_type=None):
        self.at_profession = at_profession  # type: str
        self.at_sence = at_sence  # type: str
        self.id = id  # type: long
        self.robot_name = robot_name  # type: str
        self.robot_type = robot_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListAiccsRobotResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.at_profession is not None:
            result['AtProfession'] = self.at_profession
        if self.at_sence is not None:
            result['AtSence'] = self.at_sence
        if self.id is not None:
            result['Id'] = self.id
        if self.robot_name is not None:
            result['RobotName'] = self.robot_name
        if self.robot_type is not None:
            result['RobotType'] = self.robot_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AtProfession') is not None:
            self.at_profession = m.get('AtProfession')
        if m.get('AtSence') is not None:
            self.at_sence = m.get('AtSence')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RobotName') is not None:
            self.robot_name = m.get('RobotName')
        if m.get('RobotType') is not None:
            self.robot_type = m.get('RobotType')
        return self


class ListAiccsRobotResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListAiccsRobotResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListAiccsRobotResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListAiccsRobotResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListAiccsRobotResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListAiccsRobotResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListAiccsRobotResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListAiccsRobotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListChatRecordDetailRequest(TeaModel):
    def __init__(self, client_token=None, close_time_end=None, close_time_start=None, current_page=None,
                 instance_id=None, page_size=None):
        self.client_token = client_token  # type: str
        self.close_time_end = close_time_end  # type: long
        self.close_time_start = close_time_start  # type: long
        self.current_page = current_page  # type: int
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListChatRecordDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.close_time_end is not None:
            result['CloseTimeEnd'] = self.close_time_end
        if self.close_time_start is not None:
            result['CloseTimeStart'] = self.close_time_start
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CloseTimeEnd') is not None:
            self.close_time_end = m.get('CloseTimeEnd')
        if m.get('CloseTimeStart') is not None:
            self.close_time_start = m.get('CloseTimeStart')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListChatRecordDetailResponseBodyResultDataDataMessageList(TeaModel):
    def __init__(self, content=None, create_time=None, msg_type=None, sender_name=None, sender_type=None):
        self.content = content  # type: str
        self.create_time = create_time  # type: long
        self.msg_type = msg_type  # type: str
        self.sender_name = sender_name  # type: str
        self.sender_type = sender_type  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListChatRecordDetailResponseBodyResultDataDataMessageList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.msg_type is not None:
            result['MsgType'] = self.msg_type
        if self.sender_name is not None:
            result['SenderName'] = self.sender_name
        if self.sender_type is not None:
            result['SenderType'] = self.sender_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('MsgType') is not None:
            self.msg_type = m.get('MsgType')
        if m.get('SenderName') is not None:
            self.sender_name = m.get('SenderName')
        if m.get('SenderType') is not None:
            self.sender_type = m.get('SenderType')
        return self


class ListChatRecordDetailResponseBodyResultDataData(TeaModel):
    def __init__(self, end_time=None, message_list=None, servicer_name=None, start_time=None):
        self.end_time = end_time  # type: long
        self.message_list = message_list  # type: list[ListChatRecordDetailResponseBodyResultDataDataMessageList]
        self.servicer_name = servicer_name  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        if self.message_list:
            for k in self.message_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListChatRecordDetailResponseBodyResultDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        result['MessageList'] = []
        if self.message_list is not None:
            for k in self.message_list:
                result['MessageList'].append(k.to_map() if k else None)
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        self.message_list = []
        if m.get('MessageList') is not None:
            for k in m.get('MessageList'):
                temp_model = ListChatRecordDetailResponseBodyResultDataDataMessageList()
                self.message_list.append(temp_model.from_map(k))
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListChatRecordDetailResponseBodyResultData(TeaModel):
    def __init__(self, current_page=None, data=None, one_page_size=None, total_page=None, total_results=None):
        self.current_page = current_page  # type: long
        self.data = data  # type: list[ListChatRecordDetailResponseBodyResultDataData]
        self.one_page_size = one_page_size  # type: long
        self.total_page = total_page  # type: long
        self.total_results = total_results  # type: long

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListChatRecordDetailResponseBodyResultData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.one_page_size is not None:
            result['OnePageSize'] = self.one_page_size
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListChatRecordDetailResponseBodyResultDataData()
                self.data.append(temp_model.from_map(k))
        if m.get('OnePageSize') is not None:
            self.one_page_size = m.get('OnePageSize')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class ListChatRecordDetailResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, result_data=None,
                 success=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.result_data = result_data  # type: ListChatRecordDetailResponseBodyResultData
        self.success = success  # type: bool

    def validate(self):
        if self.result_data:
            self.result_data.validate()

    def to_map(self):
        _map = super(ListChatRecordDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result_data is not None:
            result['ResultData'] = self.result_data.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResultData') is not None:
            temp_model = ListChatRecordDetailResponseBodyResultData()
            self.result_data = temp_model.from_map(m['ResultData'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListChatRecordDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListChatRecordDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListChatRecordDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListChatRecordDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListDialogRequest(TeaModel):
    def __init__(self, called=None, owner_id=None, resource_owner_account=None, resource_owner_id=None,
                 task_id=None):
        self.called = called  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDialogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.called is not None:
            result['Called'] = self.called
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Called') is not None:
            self.called = m.get('Called')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ListDialogResponseBodyData(TeaModel):
    def __init__(self, content=None, node_type=None, role=None, tag=None, time=None):
        self.content = content  # type: str
        self.node_type = node_type  # type: str
        self.role = role  # type: str
        self.tag = tag  # type: str
        self.time = time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListDialogResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.role is not None:
            result['Role'] = self.role
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class ListDialogResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListDialogResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListDialogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListDialogResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListDialogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListDialogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListDialogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListDialogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHotlineRecordRequest(TeaModel):
    def __init__(self, call_id=None, client_token=None, instance_id=None):
        self.call_id = call_id  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHotlineRecordRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListHotlineRecordResponseBodyData(TeaModel):
    def __init__(self, call_id=None, connection_id=None, end_time=None, start_time=None, url=None):
        self.call_id = call_id  # type: str
        self.connection_id = connection_id  # type: str
        self.end_time = end_time  # type: long
        self.start_time = start_time  # type: long
        self.url = url  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHotlineRecordResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class ListHotlineRecordResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListHotlineRecordResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHotlineRecordResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListHotlineRecordResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListHotlineRecordResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListHotlineRecordResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListHotlineRecordResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListHotlineRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListHotlineRecordDetailRequest(TeaModel):
    def __init__(self, client_token=None, close_time_end=None, close_time_start=None, current_page=None,
                 instance_id=None, page_size=None):
        self.client_token = client_token  # type: str
        self.close_time_end = close_time_end  # type: long
        self.close_time_start = close_time_start  # type: long
        self.current_page = current_page  # type: int
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHotlineRecordDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.close_time_end is not None:
            result['CloseTimeEnd'] = self.close_time_end
        if self.close_time_start is not None:
            result['CloseTimeStart'] = self.close_time_start
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('CloseTimeEnd') is not None:
            self.close_time_end = m.get('CloseTimeEnd')
        if m.get('CloseTimeStart') is not None:
            self.close_time_start = m.get('CloseTimeStart')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class ListHotlineRecordDetailResponseBodyResultDataData(TeaModel):
    def __init__(self, end_time=None, oss_url=None, servicer_name=None, start_time=None):
        self.end_time = end_time  # type: long
        self.oss_url = oss_url  # type: str
        self.servicer_name = servicer_name  # type: str
        self.start_time = start_time  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListHotlineRecordDetailResponseBodyResultDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.oss_url is not None:
            result['OssUrl'] = self.oss_url
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('OssUrl') is not None:
            self.oss_url = m.get('OssUrl')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ListHotlineRecordDetailResponseBodyResultData(TeaModel):
    def __init__(self, current_page=None, data=None, one_page_size=None, total_page=None, total_results=None):
        self.current_page = current_page  # type: long
        self.data = data  # type: list[ListHotlineRecordDetailResponseBodyResultDataData]
        self.one_page_size = one_page_size  # type: long
        self.total_page = total_page  # type: long
        self.total_results = total_results  # type: long

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListHotlineRecordDetailResponseBodyResultData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.one_page_size is not None:
            result['OnePageSize'] = self.one_page_size
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListHotlineRecordDetailResponseBodyResultDataData()
                self.data.append(temp_model.from_map(k))
        if m.get('OnePageSize') is not None:
            self.one_page_size = m.get('OnePageSize')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class ListHotlineRecordDetailResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, result_data=None,
                 success=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.result_data = result_data  # type: ListHotlineRecordDetailResponseBodyResultData
        self.success = success  # type: bool

    def validate(self):
        if self.result_data:
            self.result_data.validate()

    def to_map(self):
        _map = super(ListHotlineRecordDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result_data is not None:
            result['ResultData'] = self.result_data.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResultData') is not None:
            temp_model = ListHotlineRecordDetailResponseBodyResultData()
            self.result_data = temp_model.from_map(m['ResultData'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListHotlineRecordDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListHotlineRecordDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListHotlineRecordDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListHotlineRecordDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOutboundPhoneNumberRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOutboundPhoneNumberRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListOutboundPhoneNumberResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[str]
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOutboundPhoneNumberResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListOutboundPhoneNumberResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListOutboundPhoneNumberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListOutboundPhoneNumberResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListOutboundPhoneNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListOuterOrderedNumbersRequest(TeaModel):
    def __init__(self, owner_id=None, prod_code=None, resource_owner_account=None, resource_owner_id=None):
        self.owner_id = owner_id  # type: long
        self.prod_code = prod_code  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOuterOrderedNumbersRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListOuterOrderedNumbersResponseBody(TeaModel):
    def __init__(self, code=None, message=None, numbers=None, request_id=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.numbers = numbers  # type: list[str]
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListOuterOrderedNumbersResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.numbers is not None:
            result['Numbers'] = self.numbers
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Numbers') is not None:
            self.numbers = m.get('Numbers')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ListOuterOrderedNumbersResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListOuterOrderedNumbersResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListOuterOrderedNumbersResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListOuterOrderedNumbersResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRobotCallDialogRequest(TeaModel):
    def __init__(self, call_id=None, create_time=None, owner_id=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.call_id = call_id  # type: str
        self.create_time = create_time  # type: str
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRobotCallDialogRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class ListRobotCallDialogResponseBodyData(TeaModel):
    def __init__(self, content=None, node_type=None, role=None, tag=None, time=None):
        self.content = content  # type: str
        self.node_type = node_type  # type: str
        self.role = role  # type: str
        self.tag = tag  # type: str
        self.time = time  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRobotCallDialogResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.content is not None:
            result['Content'] = self.content
        if self.node_type is not None:
            result['NodeType'] = self.node_type
        if self.role is not None:
            result['Role'] = self.role
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.time is not None:
            result['Time'] = self.time
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Content') is not None:
            self.content = m.get('Content')
        if m.get('NodeType') is not None:
            self.node_type = m.get('NodeType')
        if m.get('Role') is not None:
            self.role = m.get('Role')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Time') is not None:
            self.time = m.get('Time')
        return self


class ListRobotCallDialogResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListRobotCallDialogResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRobotCallDialogResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListRobotCallDialogResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListRobotCallDialogResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListRobotCallDialogResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRobotCallDialogResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRobotCallDialogResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRobotNodeRequest(TeaModel):
    def __init__(self, owner_id=None, resource_owner_account=None, resource_owner_id=None, robot_id=None):
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.robot_id = robot_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRobotNodeRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        return self


class ListRobotNodeResponseBodyData(TeaModel):
    def __init__(self, is_output=None, model_name=None, node_identifier=None, node_name=None, process_name=None):
        self.is_output = is_output  # type: int
        self.model_name = model_name  # type: str
        self.node_identifier = node_identifier  # type: str
        self.node_name = node_name  # type: str
        self.process_name = process_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRobotNodeResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_output is not None:
            result['IsOutput'] = self.is_output
        if self.model_name is not None:
            result['ModelName'] = self.model_name
        if self.node_identifier is not None:
            result['NodeIdentifier'] = self.node_identifier
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.process_name is not None:
            result['ProcessName'] = self.process_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsOutput') is not None:
            self.is_output = m.get('IsOutput')
        if m.get('ModelName') is not None:
            self.model_name = m.get('ModelName')
        if m.get('NodeIdentifier') is not None:
            self.node_identifier = m.get('NodeIdentifier')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('ProcessName') is not None:
            self.process_name = m.get('ProcessName')
        return self


class ListRobotNodeResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListRobotNodeResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRobotNodeResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListRobotNodeResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListRobotNodeResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListRobotNodeResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRobotNodeResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRobotNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRobotParamsRequest(TeaModel):
    def __init__(self, owner_id=None, resource_owner_account=None, resource_owner_id=None, robot_id=None):
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.robot_id = robot_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRobotParamsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        return self


class ListRobotParamsResponseBodyData(TeaModel):
    def __init__(self, is_empty=None, param_code=None, param_name=None):
        self.is_empty = is_empty  # type: int
        self.param_code = param_code  # type: str
        self.param_name = param_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRobotParamsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.is_empty is not None:
            result['IsEmpty'] = self.is_empty
        if self.param_code is not None:
            result['ParamCode'] = self.param_code
        if self.param_name is not None:
            result['ParamName'] = self.param_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('IsEmpty') is not None:
            self.is_empty = m.get('IsEmpty')
        if m.get('ParamCode') is not None:
            self.param_code = m.get('ParamCode')
        if m.get('ParamName') is not None:
            self.param_name = m.get('ParamName')
        return self


class ListRobotParamsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListRobotParamsResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRobotParamsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListRobotParamsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListRobotParamsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListRobotParamsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRobotParamsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRobotParamsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListRolesRequest(TeaModel):
    def __init__(self, client_token=None, instance_id=None):
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRolesRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListRolesResponseBodyData(TeaModel):
    def __init__(self, bu_id=None, code=None, create_time=None, description=None, role_group_id=None,
                 role_group_name=None, role_id=None, title=None):
        self.bu_id = bu_id  # type: long
        self.code = code  # type: str
        self.create_time = create_time  # type: str
        self.description = description  # type: str
        self.role_group_id = role_group_id  # type: long
        self.role_group_name = role_group_name  # type: str
        self.role_id = role_id  # type: long
        self.title = title  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListRolesResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bu_id is not None:
            result['BuId'] = self.bu_id
        if self.code is not None:
            result['Code'] = self.code
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.description is not None:
            result['Description'] = self.description
        if self.role_group_id is not None:
            result['RoleGroupId'] = self.role_group_id
        if self.role_group_name is not None:
            result['RoleGroupName'] = self.role_group_name
        if self.role_id is not None:
            result['RoleId'] = self.role_id
        if self.title is not None:
            result['Title'] = self.title
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BuId') is not None:
            self.bu_id = m.get('BuId')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('RoleGroupId') is not None:
            self.role_group_id = m.get('RoleGroupId')
        if m.get('RoleGroupName') is not None:
            self.role_group_name = m.get('RoleGroupName')
        if m.get('RoleId') is not None:
            self.role_id = m.get('RoleId')
        if m.get('Title') is not None:
            self.title = m.get('Title')
        return self


class ListRolesResponseBody(TeaModel):
    def __init__(self, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.data = data  # type: list[ListRolesResponseBodyData]
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListRolesResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListRolesResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListRolesResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListRolesResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListRolesResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListRolesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListSkillGroupRequest(TeaModel):
    def __init__(self, channel_type=None, client_token=None, instance_id=None):
        self.channel_type = channel_type  # type: int
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class ListSkillGroupResponseBodyData(TeaModel):
    def __init__(self, channel_type=None, description=None, display_name=None, name=None, skill_group_id=None):
        self.channel_type = channel_type  # type: int
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.name = name  # type: str
        self.skill_group_id = skill_group_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListSkillGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.name is not None:
            result['Name'] = self.name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class ListSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: list[ListSkillGroupResponseBodyData]
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = ListSkillGroupResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTaskRequest(TeaModel):
    def __init__(self, owner_id=None, page_no=None, page_size=None, resource_owner_account=None,
                 resource_owner_id=None, robot_name=None, status=None, task_id=None, task_name=None):
        self.owner_id = owner_id  # type: long
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.robot_name = robot_name  # type: str
        self.status = status  # type: str
        self.task_id = task_id  # type: long
        self.task_name = task_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.robot_name is not None:
            result['RobotName'] = self.robot_name
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RobotName') is not None:
            self.robot_name = m.get('RobotName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        return self


class ListTaskResponseBodyDataRecord(TeaModel):
    def __init__(self, complete_count=None, fire_time=None, gmt_create=None, id=None, robot_id=None, robot_name=None,
                 status=None, task_name=None, total_count=None):
        self.complete_count = complete_count  # type: int
        self.fire_time = fire_time  # type: str
        self.gmt_create = gmt_create  # type: str
        self.id = id  # type: long
        self.robot_id = robot_id  # type: long
        self.robot_name = robot_name  # type: str
        self.status = status  # type: str
        self.task_name = task_name  # type: str
        self.total_count = total_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTaskResponseBodyDataRecord, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.complete_count is not None:
            result['CompleteCount'] = self.complete_count
        if self.fire_time is not None:
            result['FireTime'] = self.fire_time
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        if self.robot_name is not None:
            result['RobotName'] = self.robot_name
        if self.status is not None:
            result['Status'] = self.status
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CompleteCount') is not None:
            self.complete_count = m.get('CompleteCount')
        if m.get('FireTime') is not None:
            self.fire_time = m.get('FireTime')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        if m.get('RobotName') is not None:
            self.robot_name = m.get('RobotName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class ListTaskResponseBodyData(TeaModel):
    def __init__(self, page_no=None, page_size=None, record=None, total=None):
        self.page_no = page_no  # type: long
        self.page_size = page_size  # type: long
        self.record = record  # type: list[ListTaskResponseBodyDataRecord]
        self.total = total  # type: long

    def validate(self):
        if self.record:
            for k in self.record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTaskResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Record'] = []
        if self.record is not None:
            for k in self.record:
                result['Record'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.record = []
        if m.get('Record') is not None:
            for k in m.get('Record'):
                temp_model = ListTaskResponseBodyDataRecord()
                self.record.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: ListTaskResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ListTaskDetailRequest(TeaModel):
    def __init__(self, called=None, id=None, owner_id=None, page_no=None, page_size=None,
                 resource_owner_account=None, resource_owner_id=None, status=None, status_code=None, task_id=None):
        self.called = called  # type: str
        self.id = id  # type: long
        self.owner_id = owner_id  # type: long
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.status = status  # type: str
        self.status_code = status_code  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTaskDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.called is not None:
            result['Called'] = self.called
        if self.id is not None:
            result['Id'] = self.id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        if self.status_code is not None:
            result['StatusCode'] = self.status_code
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Called') is not None:
            self.called = m.get('Called')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusCode') is not None:
            self.status_code = m.get('StatusCode')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class ListTaskDetailResponseBodyDataRecord(TeaModel):
    def __init__(self, called=None, caller=None, direction=None, duration=None, end_time=None, id=None,
                 retry_cur_times=None, retry_times=None, start_time=None, status=None, status_code=None, status_code_desc=None,
                 tags=None):
        self.called = called  # type: str
        self.caller = caller  # type: str
        self.direction = direction  # type: str
        self.duration = duration  # type: int
        self.end_time = end_time  # type: str
        self.id = id  # type: long
        self.retry_cur_times = retry_cur_times  # type: int
        self.retry_times = retry_times  # type: int
        self.start_time = start_time  # type: str
        self.status = status  # type: str
        self.status_code = status_code  # type: str
        self.status_code_desc = status_code_desc  # type: str
        self.tags = tags  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ListTaskDetailResponseBodyDataRecord, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.called is not None:
            result['Called'] = self.called
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.direction is not None:
            result['Direction'] = self.direction
        if self.duration is not None:
            result['Duration'] = self.duration
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.id is not None:
            result['Id'] = self.id
        if self.retry_cur_times is not None:
            result['RetryCurTimes'] = self.retry_cur_times
        if self.retry_times is not None:
            result['RetryTimes'] = self.retry_times
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.status_code is not None:
            result['StatusCode'] = self.status_code
        if self.status_code_desc is not None:
            result['StatusCodeDesc'] = self.status_code_desc
        if self.tags is not None:
            result['Tags'] = self.tags
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Called') is not None:
            self.called = m.get('Called')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('Direction') is not None:
            self.direction = m.get('Direction')
        if m.get('Duration') is not None:
            self.duration = m.get('Duration')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('RetryCurTimes') is not None:
            self.retry_cur_times = m.get('RetryCurTimes')
        if m.get('RetryTimes') is not None:
            self.retry_times = m.get('RetryTimes')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StatusCode') is not None:
            self.status_code = m.get('StatusCode')
        if m.get('StatusCodeDesc') is not None:
            self.status_code_desc = m.get('StatusCodeDesc')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        return self


class ListTaskDetailResponseBodyData(TeaModel):
    def __init__(self, page_no=None, page_size=None, record=None, total=None):
        self.page_no = page_no  # type: long
        self.page_size = page_size  # type: long
        self.record = record  # type: list[ListTaskDetailResponseBodyDataRecord]
        self.total = total  # type: long

    def validate(self):
        if self.record:
            for k in self.record:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ListTaskDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        result['Record'] = []
        if self.record is not None:
            for k in self.record:
                result['Record'].append(k.to_map() if k else None)
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        self.record = []
        if m.get('Record') is not None:
            for k in m.get('Record'):
                temp_model = ListTaskDetailResponseBodyDataRecord()
                self.record.append(temp_model.from_map(k))
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class ListTaskDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: ListTaskDetailResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(ListTaskDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = ListTaskDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ListTaskDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ListTaskDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ListTaskDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ListTaskDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MakeCallRequest(TeaModel):
    def __init__(self, called_number=None, calling_number=None, command_code=None, ext_info=None,
                 outer_account_id=None, outer_account_type=None):
        self.called_number = called_number  # type: str
        self.calling_number = calling_number  # type: str
        self.command_code = command_code  # type: str
        self.ext_info = ext_info  # type: str
        self.outer_account_id = outer_account_id  # type: str
        self.outer_account_type = outer_account_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MakeCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.command_code is not None:
            result['CommandCode'] = self.command_code
        if self.ext_info is not None:
            result['ExtInfo'] = self.ext_info
        if self.outer_account_id is not None:
            result['OuterAccountId'] = self.outer_account_id
        if self.outer_account_type is not None:
            result['OuterAccountType'] = self.outer_account_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('CommandCode') is not None:
            self.command_code = m.get('CommandCode')
        if m.get('ExtInfo') is not None:
            self.ext_info = m.get('ExtInfo')
        if m.get('OuterAccountId') is not None:
            self.outer_account_id = m.get('OuterAccountId')
        if m.get('OuterAccountType') is not None:
            self.outer_account_type = m.get('OuterAccountType')
        return self


class MakeCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(MakeCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class MakeCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: MakeCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(MakeCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = MakeCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class MakeDoubleCallRequest(TeaModel):
    def __init__(self, account_name=None, biz_data=None, instance_id=None, member_phone=None,
                 outbound_call_number=None, servicer_phone=None):
        self.account_name = account_name  # type: str
        self.biz_data = biz_data  # type: str
        self.instance_id = instance_id  # type: str
        self.member_phone = member_phone  # type: str
        self.outbound_call_number = outbound_call_number  # type: str
        self.servicer_phone = servicer_phone  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MakeDoubleCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.biz_data is not None:
            result['BizData'] = self.biz_data
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.member_phone is not None:
            result['MemberPhone'] = self.member_phone
        if self.outbound_call_number is not None:
            result['OutboundCallNumber'] = self.outbound_call_number
        if self.servicer_phone is not None:
            result['ServicerPhone'] = self.servicer_phone
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('BizData') is not None:
            self.biz_data = m.get('BizData')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MemberPhone') is not None:
            self.member_phone = m.get('MemberPhone')
        if m.get('OutboundCallNumber') is not None:
            self.outbound_call_number = m.get('OutboundCallNumber')
        if m.get('ServicerPhone') is not None:
            self.servicer_phone = m.get('ServicerPhone')
        return self


class MakeDoubleCallResponseBodyData(TeaModel):
    def __init__(self, acid=None):
        self.acid = acid  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(MakeDoubleCallResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.acid is not None:
            result['Acid'] = self.acid
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Acid') is not None:
            self.acid = m.get('Acid')
        return self


class MakeDoubleCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: MakeDoubleCallResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(MakeDoubleCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = MakeDoubleCallResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class MakeDoubleCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: MakeDoubleCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(MakeDoubleCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = MakeDoubleCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryHotlineInQueueRequest(TeaModel):
    def __init__(self, outer_group_id=None, outer_group_type=None):
        self.outer_group_id = outer_group_id  # type: str
        self.outer_group_type = outer_group_type  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryHotlineInQueueRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.outer_group_id is not None:
            result['OuterGroupId'] = self.outer_group_id
        if self.outer_group_type is not None:
            result['OuterGroupType'] = self.outer_group_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OuterGroupId') is not None:
            self.outer_group_id = m.get('OuterGroupId')
        if m.get('OuterGroupType') is not None:
            self.outer_group_type = m.get('OuterGroupType')
        return self


class QueryHotlineInQueueResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryHotlineInQueueResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryHotlineInQueueResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryHotlineInQueueResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryHotlineInQueueResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryHotlineInQueueResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryHotlineNumberRequest(TeaModel):
    def __init__(self, current_page=None, department_id=None, group_ids=None, hotline_number=None, instance_id=None,
                 page_size=None):
        self.current_page = current_page  # type: int
        self.department_id = department_id  # type: long
        self.group_ids = group_ids  # type: list[long]
        self.hotline_number = hotline_number  # type: str
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryHotlineNumberRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.group_ids is not None:
            result['GroupIds'] = self.group_ids
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('GroupIds') is not None:
            self.group_ids = m.get('GroupIds')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryHotlineNumberShrinkRequest(TeaModel):
    def __init__(self, current_page=None, department_id=None, group_ids_shrink=None, hotline_number=None,
                 instance_id=None, page_size=None):
        self.current_page = current_page  # type: int
        self.department_id = department_id  # type: long
        self.group_ids_shrink = group_ids_shrink  # type: str
        self.hotline_number = hotline_number  # type: str
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryHotlineNumberShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.group_ids_shrink is not None:
            result['GroupIds'] = self.group_ids_shrink
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('GroupIds') is not None:
            self.group_ids_shrink = m.get('GroupIds')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeListGroupDOList(TeaModel):
    def __init__(self, group_id=None, group_name=None):
        self.group_id = group_id  # type: long
        self.group_name = group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeListGroupDOList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeList(TeaModel):
    def __init__(self, department_id=None, department_name=None, group_dolist=None):
        self.department_id = department_id  # type: long
        self.department_name = department_name  # type: str
        self.group_dolist = group_dolist  # type: list[QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeListGroupDOList]

    def validate(self):
        if self.group_dolist:
            for k in self.group_dolist:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.department_name is not None:
            result['DepartmentName'] = self.department_name
        result['GroupDOList'] = []
        if self.group_dolist is not None:
            for k in self.group_dolist:
                result['GroupDOList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('DepartmentName') is not None:
            self.department_name = m.get('DepartmentName')
        self.group_dolist = []
        if m.get('GroupDOList') is not None:
            for k in m.get('GroupDOList'):
                temp_model = QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeListGroupDOList()
                self.group_dolist.append(temp_model.from_map(k))
        return self


class QueryHotlineNumberResponseBodyDataHotlineNumList(TeaModel):
    def __init__(self, callout_all_department=None, callout_range_list=None, description=None,
                 evaluation_status=None, flow_id=None, flow_name=None, hotline_number=None, in_bound_enabled=None, location=None,
                 outbound_enabled=None, sp=None):
        self.callout_all_department = callout_all_department  # type: bool
        self.callout_range_list = callout_range_list  # type: list[QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeList]
        self.description = description  # type: str
        self.evaluation_status = evaluation_status  # type: int
        self.flow_id = flow_id  # type: long
        self.flow_name = flow_name  # type: str
        self.hotline_number = hotline_number  # type: str
        self.in_bound_enabled = in_bound_enabled  # type: bool
        self.location = location  # type: str
        self.outbound_enabled = outbound_enabled  # type: bool
        self.sp = sp  # type: str

    def validate(self):
        if self.callout_range_list:
            for k in self.callout_range_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryHotlineNumberResponseBodyDataHotlineNumList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.callout_all_department is not None:
            result['CalloutAllDepartment'] = self.callout_all_department
        result['CalloutRangeList'] = []
        if self.callout_range_list is not None:
            for k in self.callout_range_list:
                result['CalloutRangeList'].append(k.to_map() if k else None)
        if self.description is not None:
            result['Description'] = self.description
        if self.evaluation_status is not None:
            result['EvaluationStatus'] = self.evaluation_status
        if self.flow_id is not None:
            result['FlowId'] = self.flow_id
        if self.flow_name is not None:
            result['FlowName'] = self.flow_name
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.in_bound_enabled is not None:
            result['InBoundEnabled'] = self.in_bound_enabled
        if self.location is not None:
            result['Location'] = self.location
        if self.outbound_enabled is not None:
            result['OutboundEnabled'] = self.outbound_enabled
        if self.sp is not None:
            result['Sp'] = self.sp
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CalloutAllDepartment') is not None:
            self.callout_all_department = m.get('CalloutAllDepartment')
        self.callout_range_list = []
        if m.get('CalloutRangeList') is not None:
            for k in m.get('CalloutRangeList'):
                temp_model = QueryHotlineNumberResponseBodyDataHotlineNumListCalloutRangeList()
                self.callout_range_list.append(temp_model.from_map(k))
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EvaluationStatus') is not None:
            self.evaluation_status = m.get('EvaluationStatus')
        if m.get('FlowId') is not None:
            self.flow_id = m.get('FlowId')
        if m.get('FlowName') is not None:
            self.flow_name = m.get('FlowName')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InBoundEnabled') is not None:
            self.in_bound_enabled = m.get('InBoundEnabled')
        if m.get('Location') is not None:
            self.location = m.get('Location')
        if m.get('OutboundEnabled') is not None:
            self.outbound_enabled = m.get('OutboundEnabled')
        if m.get('Sp') is not None:
            self.sp = m.get('Sp')
        return self


class QueryHotlineNumberResponseBodyData(TeaModel):
    def __init__(self, current_page=None, hotline_num_list=None, page_size=None, total_count=None):
        self.current_page = current_page  # type: long
        self.hotline_num_list = hotline_num_list  # type: list[QueryHotlineNumberResponseBodyDataHotlineNumList]
        self.page_size = page_size  # type: long
        self.total_count = total_count  # type: long

    def validate(self):
        if self.hotline_num_list:
            for k in self.hotline_num_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryHotlineNumberResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['HotlineNumList'] = []
        if self.hotline_num_list is not None:
            for k in self.hotline_num_list:
                result['HotlineNumList'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.hotline_num_list = []
        if m.get('HotlineNumList') is not None:
            for k in m.get('HotlineNumList'):
                temp_model = QueryHotlineNumberResponseBodyDataHotlineNumList()
                self.hotline_num_list.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class QueryHotlineNumberResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: QueryHotlineNumberResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryHotlineNumberResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryHotlineNumberResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryHotlineNumberResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryHotlineNumberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryHotlineNumberResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryHotlineNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryOutboundTaskRequest(TeaModel):
    def __init__(self, ani=None, current_page=None, department_id=None, end_date=None, end_time=None,
                 group_name=None, instance_id=None, page_size=None, skill_group=None, start_date=None, start_time=None,
                 status=None, task_id=None, task_name=None, task_type=None):
        self.ani = ani  # type: str
        self.current_page = current_page  # type: int
        self.department_id = department_id  # type: str
        self.end_date = end_date  # type: str
        self.end_time = end_time  # type: str
        self.group_name = group_name  # type: str
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.skill_group = skill_group  # type: long
        self.start_date = start_date  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: str
        self.task_id = task_id  # type: long
        self.task_name = task_name  # type: str
        self.task_type = task_type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryOutboundTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ani is not None:
            result['Ani'] = self.ani
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.skill_group is not None:
            result['SkillGroup'] = self.skill_group
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ani') is not None:
            self.ani = m.get('Ani')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SkillGroup') is not None:
            self.skill_group = m.get('SkillGroup')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class QueryOutboundTaskResponseBodyDataList(TeaModel):
    def __init__(self, bu_id=None, caller_num=None, creator=None, department_id=None, description=None,
                 end_date=None, end_time=None, ext_attrs=None, gmt_create=None, gmt_modified=None, group_name=None, id=None,
                 model=None, modifier=None, name=None, retry_interval=None, retry_time=None, skill_group=None,
                 start_date=None, start_time=None, status=None, type=None):
        self.bu_id = bu_id  # type: long
        self.caller_num = caller_num  # type: str
        self.creator = creator  # type: str
        self.department_id = department_id  # type: long
        self.description = description  # type: str
        self.end_date = end_date  # type: str
        self.end_time = end_time  # type: str
        self.ext_attrs = ext_attrs  # type: str
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.group_name = group_name  # type: str
        self.id = id  # type: long
        self.model = model  # type: int
        self.modifier = modifier  # type: str
        self.name = name  # type: str
        self.retry_interval = retry_interval  # type: int
        self.retry_time = retry_time  # type: int
        self.skill_group = skill_group  # type: long
        self.start_date = start_date  # type: str
        self.start_time = start_time  # type: str
        self.status = status  # type: int
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryOutboundTaskResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bu_id is not None:
            result['BuId'] = self.bu_id
        if self.caller_num is not None:
            result['CallerNum'] = self.caller_num
        if self.creator is not None:
            result['Creator'] = self.creator
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.description is not None:
            result['Description'] = self.description
        if self.end_date is not None:
            result['EndDate'] = self.end_date
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.ext_attrs is not None:
            result['ExtAttrs'] = self.ext_attrs
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.id is not None:
            result['Id'] = self.id
        if self.model is not None:
            result['Model'] = self.model
        if self.modifier is not None:
            result['Modifier'] = self.modifier
        if self.name is not None:
            result['Name'] = self.name
        if self.retry_interval is not None:
            result['RetryInterval'] = self.retry_interval
        if self.retry_time is not None:
            result['RetryTime'] = self.retry_time
        if self.skill_group is not None:
            result['SkillGroup'] = self.skill_group
        if self.start_date is not None:
            result['StartDate'] = self.start_date
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BuId') is not None:
            self.bu_id = m.get('BuId')
        if m.get('CallerNum') is not None:
            self.caller_num = m.get('CallerNum')
        if m.get('Creator') is not None:
            self.creator = m.get('Creator')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndDate') is not None:
            self.end_date = m.get('EndDate')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('ExtAttrs') is not None:
            self.ext_attrs = m.get('ExtAttrs')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Model') is not None:
            self.model = m.get('Model')
        if m.get('Modifier') is not None:
            self.modifier = m.get('Modifier')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('RetryInterval') is not None:
            self.retry_interval = m.get('RetryInterval')
        if m.get('RetryTime') is not None:
            self.retry_time = m.get('RetryTime')
        if m.get('SkillGroup') is not None:
            self.skill_group = m.get('SkillGroup')
        if m.get('StartDate') is not None:
            self.start_date = m.get('StartDate')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class QueryOutboundTaskResponseBodyData(TeaModel):
    def __init__(self, current_page=None, list=None, page_size=None, total_results=None):
        self.current_page = current_page  # type: str
        self.list = list  # type: list[QueryOutboundTaskResponseBodyDataList]
        self.page_size = page_size  # type: str
        self.total_results = total_results  # type: str

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryOutboundTaskResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = QueryOutboundTaskResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class QueryOutboundTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: QueryOutboundTaskResponseBodyData
        self.http_status_code = http_status_code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryOutboundTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryOutboundTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryOutboundTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryOutboundTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryOutboundTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QuerySkillGroupsRequest(TeaModel):
    def __init__(self, channel_type=None, client_token=None, department_id=None, instance_id=None, page_no=None,
                 page_size=None):
        self.channel_type = channel_type  # type: int
        self.client_token = client_token  # type: str
        self.department_id = department_id  # type: long
        self.instance_id = instance_id  # type: str
        self.page_no = page_no  # type: int
        self.page_size = page_size  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(QuerySkillGroupsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_no is not None:
            result['PageNo'] = self.page_no
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageNo') is not None:
            self.page_no = m.get('PageNo')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class QuerySkillGroupsResponseBodyData(TeaModel):
    def __init__(self, channel_type=None, description=None, display_name=None, skill_group_id=None,
                 skill_group_name=None):
        self.channel_type = channel_type  # type: int
        self.description = description  # type: str
        self.display_name = display_name  # type: str
        self.skill_group_id = skill_group_id  # type: long
        self.skill_group_name = skill_group_name  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QuerySkillGroupsResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.description is not None:
            result['Description'] = self.description
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_name is not None:
            result['SkillGroupName'] = self.skill_group_name
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupName') is not None:
            self.skill_group_name = m.get('SkillGroupName')
        return self


class QuerySkillGroupsResponseBody(TeaModel):
    def __init__(self, current_page=None, data=None, one_page_size=None, request_id=None, total_page=None,
                 total_results=None):
        self.current_page = current_page  # type: int
        self.data = data  # type: list[QuerySkillGroupsResponseBodyData]
        self.one_page_size = one_page_size  # type: int
        self.request_id = request_id  # type: str
        self.total_page = total_page  # type: int
        self.total_results = total_results  # type: int

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QuerySkillGroupsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.one_page_size is not None:
            result['OnePageSize'] = self.one_page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QuerySkillGroupsResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('OnePageSize') is not None:
            self.one_page_size = m.get('OnePageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class QuerySkillGroupsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QuerySkillGroupsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QuerySkillGroupsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QuerySkillGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryTaskDetailRequest(TeaModel):
    def __init__(self, ani=None, current_page=None, department_id_list=None, dnis=None, end_reason_list=None,
                 instance_id=None, outbound_task_id=None, page_size=None, priority_list=None, servicer_id=None,
                 servicer_name=None, sid=None, skill_group=None, status_list=None, task_id=None):
        self.ani = ani  # type: str
        self.current_page = current_page  # type: int
        self.department_id_list = department_id_list  # type: str
        self.dnis = dnis  # type: str
        self.end_reason_list = end_reason_list  # type: str
        self.instance_id = instance_id  # type: str
        self.outbound_task_id = outbound_task_id  # type: str
        self.page_size = page_size  # type: int
        self.priority_list = priority_list  # type: str
        self.servicer_id = servicer_id  # type: str
        self.servicer_name = servicer_name  # type: str
        self.sid = sid  # type: str
        self.skill_group = skill_group  # type: str
        self.status_list = status_list  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryTaskDetailRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ani is not None:
            result['Ani'] = self.ani
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.department_id_list is not None:
            result['DepartmentIdList'] = self.department_id_list
        if self.dnis is not None:
            result['Dnis'] = self.dnis
        if self.end_reason_list is not None:
            result['EndReasonList'] = self.end_reason_list
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_task_id is not None:
            result['OutboundTaskId'] = self.outbound_task_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.priority_list is not None:
            result['PriorityList'] = self.priority_list
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.sid is not None:
            result['Sid'] = self.sid
        if self.skill_group is not None:
            result['SkillGroup'] = self.skill_group
        if self.status_list is not None:
            result['StatusList'] = self.status_list
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ani') is not None:
            self.ani = m.get('Ani')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DepartmentIdList') is not None:
            self.department_id_list = m.get('DepartmentIdList')
        if m.get('Dnis') is not None:
            self.dnis = m.get('Dnis')
        if m.get('EndReasonList') is not None:
            self.end_reason_list = m.get('EndReasonList')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundTaskId') is not None:
            self.outbound_task_id = m.get('OutboundTaskId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('PriorityList') is not None:
            self.priority_list = m.get('PriorityList')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('Sid') is not None:
            self.sid = m.get('Sid')
        if m.get('SkillGroup') is not None:
            self.skill_group = m.get('SkillGroup')
        if m.get('StatusList') is not None:
            self.status_list = m.get('StatusList')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class QueryTaskDetailResponseBodyDataList(TeaModel):
    def __init__(self, ani=None, bu_id=None, department_id=None, dnis=None, end_reason=None, ext_attrs=None,
                 gmt_create=None, gmt_modified=None, id=None, member_id=None, member_name=None, outbound_num=None,
                 outbound_task_id=None, priority=None, retry_time=None, servicer_id=None, servicer_name=None, skill_group=None,
                 status=None):
        self.ani = ani  # type: str
        self.bu_id = bu_id  # type: long
        self.department_id = department_id  # type: long
        self.dnis = dnis  # type: str
        self.end_reason = end_reason  # type: int
        self.ext_attrs = ext_attrs  # type: str
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.id = id  # type: int
        self.member_id = member_id  # type: long
        self.member_name = member_name  # type: str
        self.outbound_num = outbound_num  # type: int
        self.outbound_task_id = outbound_task_id  # type: long
        self.priority = priority  # type: int
        self.retry_time = retry_time  # type: str
        self.servicer_id = servicer_id  # type: long
        self.servicer_name = servicer_name  # type: str
        self.skill_group = skill_group  # type: int
        self.status = status  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryTaskDetailResponseBodyDataList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ani is not None:
            result['Ani'] = self.ani
        if self.bu_id is not None:
            result['BuId'] = self.bu_id
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.dnis is not None:
            result['Dnis'] = self.dnis
        if self.end_reason is not None:
            result['EndReason'] = self.end_reason
        if self.ext_attrs is not None:
            result['ExtAttrs'] = self.ext_attrs
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.outbound_num is not None:
            result['OutboundNum'] = self.outbound_num
        if self.outbound_task_id is not None:
            result['OutboundTaskId'] = self.outbound_task_id
        if self.priority is not None:
            result['Priority'] = self.priority
        if self.retry_time is not None:
            result['RetryTime'] = self.retry_time
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.skill_group is not None:
            result['SkillGroup'] = self.skill_group
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ani') is not None:
            self.ani = m.get('Ani')
        if m.get('BuId') is not None:
            self.bu_id = m.get('BuId')
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('Dnis') is not None:
            self.dnis = m.get('Dnis')
        if m.get('EndReason') is not None:
            self.end_reason = m.get('EndReason')
        if m.get('ExtAttrs') is not None:
            self.ext_attrs = m.get('ExtAttrs')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('OutboundNum') is not None:
            self.outbound_num = m.get('OutboundNum')
        if m.get('OutboundTaskId') is not None:
            self.outbound_task_id = m.get('OutboundTaskId')
        if m.get('Priority') is not None:
            self.priority = m.get('Priority')
        if m.get('RetryTime') is not None:
            self.retry_time = m.get('RetryTime')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('SkillGroup') is not None:
            self.skill_group = m.get('SkillGroup')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class QueryTaskDetailResponseBodyData(TeaModel):
    def __init__(self, current_page=None, list=None, page_size=None, total_results=None):
        self.current_page = current_page  # type: str
        self.list = list  # type: list[QueryTaskDetailResponseBodyDataList]
        self.page_size = page_size  # type: str
        self.total_results = total_results  # type: str

    def validate(self):
        if self.list:
            for k in self.list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryTaskDetailResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['List'] = []
        if self.list is not None:
            for k in self.list:
                result['List'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.list = []
        if m.get('List') is not None:
            for k in m.get('List'):
                temp_model = QueryTaskDetailResponseBodyDataList()
                self.list.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class QueryTaskDetailResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: QueryTaskDetailResponseBodyData
        self.http_status_code = http_status_code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: str

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(QueryTaskDetailResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = QueryTaskDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryTaskDetailResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryTaskDetailResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryTaskDetailResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryTaskDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryTicketsRequest(TeaModel):
    def __init__(self, case_id=None, case_status=None, case_type=None, channel_id=None, channel_type=None,
                 current_page=None, deal_id=None, extra=None, instance_id=None, page_size=None, sr_type=None, task_status=None,
                 touch_id=None):
        self.case_id = case_id  # type: long
        self.case_status = case_status  # type: int
        self.case_type = case_type  # type: int
        self.channel_id = channel_id  # type: str
        self.channel_type = channel_type  # type: int
        self.current_page = current_page  # type: int
        self.deal_id = deal_id  # type: long
        self.extra = extra  # type: dict[str, any]
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.sr_type = sr_type  # type: long
        self.task_status = task_status  # type: int
        self.touch_id = touch_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryTicketsRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.case_status is not None:
            result['CaseStatus'] = self.case_status
        if self.case_type is not None:
            result['CaseType'] = self.case_type
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.deal_id is not None:
            result['DealId'] = self.deal_id
        if self.extra is not None:
            result['Extra'] = self.extra
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sr_type is not None:
            result['SrType'] = self.sr_type
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.touch_id is not None:
            result['TouchId'] = self.touch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('CaseStatus') is not None:
            self.case_status = m.get('CaseStatus')
        if m.get('CaseType') is not None:
            self.case_type = m.get('CaseType')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DealId') is not None:
            self.deal_id = m.get('DealId')
        if m.get('Extra') is not None:
            self.extra = m.get('Extra')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SrType') is not None:
            self.sr_type = m.get('SrType')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TouchId') is not None:
            self.touch_id = m.get('TouchId')
        return self


class QueryTicketsShrinkRequest(TeaModel):
    def __init__(self, case_id=None, case_status=None, case_type=None, channel_id=None, channel_type=None,
                 current_page=None, deal_id=None, extra_shrink=None, instance_id=None, page_size=None, sr_type=None,
                 task_status=None, touch_id=None):
        self.case_id = case_id  # type: long
        self.case_status = case_status  # type: int
        self.case_type = case_type  # type: int
        self.channel_id = channel_id  # type: str
        self.channel_type = channel_type  # type: int
        self.current_page = current_page  # type: int
        self.deal_id = deal_id  # type: long
        self.extra_shrink = extra_shrink  # type: str
        self.instance_id = instance_id  # type: str
        self.page_size = page_size  # type: int
        self.sr_type = sr_type  # type: long
        self.task_status = task_status  # type: int
        self.touch_id = touch_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryTicketsShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.case_id is not None:
            result['CaseId'] = self.case_id
        if self.case_status is not None:
            result['CaseStatus'] = self.case_status
        if self.case_type is not None:
            result['CaseType'] = self.case_type
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.deal_id is not None:
            result['DealId'] = self.deal_id
        if self.extra_shrink is not None:
            result['Extra'] = self.extra_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.sr_type is not None:
            result['SrType'] = self.sr_type
        if self.task_status is not None:
            result['TaskStatus'] = self.task_status
        if self.touch_id is not None:
            result['TouchId'] = self.touch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CaseId') is not None:
            self.case_id = m.get('CaseId')
        if m.get('CaseStatus') is not None:
            self.case_status = m.get('CaseStatus')
        if m.get('CaseType') is not None:
            self.case_type = m.get('CaseType')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DealId') is not None:
            self.deal_id = m.get('DealId')
        if m.get('Extra') is not None:
            self.extra_shrink = m.get('Extra')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SrType') is not None:
            self.sr_type = m.get('SrType')
        if m.get('TaskStatus') is not None:
            self.task_status = m.get('TaskStatus')
        if m.get('TouchId') is not None:
            self.touch_id = m.get('TouchId')
        return self


class QueryTicketsResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryTicketsResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryTicketsResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryTicketsResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryTicketsResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryTicketsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class QueryTouchListRequest(TeaModel):
    def __init__(self, channel_id=None, channel_type=None, close_time_end=None, close_time_start=None,
                 current_page=None, evaluation_level=None, evaluation_score=None, evaluation_status=None, first_time_end=None,
                 first_time_start=None, instance_id=None, member_id=None, member_name=None, page_size=None, queue_id=None,
                 servicer_id=None, servicer_name=None, touch_id=None, touch_type=None):
        self.channel_id = channel_id  # type: list[str]
        self.channel_type = channel_type  # type: list[int]
        self.close_time_end = close_time_end  # type: long
        self.close_time_start = close_time_start  # type: long
        self.current_page = current_page  # type: int
        self.evaluation_level = evaluation_level  # type: list[int]
        self.evaluation_score = evaluation_score  # type: list[int]
        self.evaluation_status = evaluation_status  # type: list[int]
        self.first_time_end = first_time_end  # type: long
        self.first_time_start = first_time_start  # type: long
        self.instance_id = instance_id  # type: str
        self.member_id = member_id  # type: list[long]
        self.member_name = member_name  # type: list[str]
        self.page_size = page_size  # type: int
        self.queue_id = queue_id  # type: list[long]
        self.servicer_id = servicer_id  # type: list[long]
        self.servicer_name = servicer_name  # type: list[str]
        self.touch_id = touch_id  # type: list[long]
        self.touch_type = touch_type  # type: list[int]

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryTouchListRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.close_time_end is not None:
            result['CloseTimeEnd'] = self.close_time_end
        if self.close_time_start is not None:
            result['CloseTimeStart'] = self.close_time_start
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.evaluation_score is not None:
            result['EvaluationScore'] = self.evaluation_score
        if self.evaluation_status is not None:
            result['EvaluationStatus'] = self.evaluation_status
        if self.first_time_end is not None:
            result['FirstTimeEnd'] = self.first_time_end
        if self.first_time_start is not None:
            result['FirstTimeStart'] = self.first_time_start
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.touch_id is not None:
            result['TouchId'] = self.touch_id
        if self.touch_type is not None:
            result['TouchType'] = self.touch_type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('CloseTimeEnd') is not None:
            self.close_time_end = m.get('CloseTimeEnd')
        if m.get('CloseTimeStart') is not None:
            self.close_time_start = m.get('CloseTimeStart')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('EvaluationScore') is not None:
            self.evaluation_score = m.get('EvaluationScore')
        if m.get('EvaluationStatus') is not None:
            self.evaluation_status = m.get('EvaluationStatus')
        if m.get('FirstTimeEnd') is not None:
            self.first_time_end = m.get('FirstTimeEnd')
        if m.get('FirstTimeStart') is not None:
            self.first_time_start = m.get('FirstTimeStart')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('TouchId') is not None:
            self.touch_id = m.get('TouchId')
        if m.get('TouchType') is not None:
            self.touch_type = m.get('TouchType')
        return self


class QueryTouchListResponseBodyResultDataDataExtAttrs(TeaModel):
    def __init__(self, ani=None, dnis=None, evaluation_level=None, evaluation_score=None, evaluation_solution=None,
                 evaluation_status=None, online_join_resp_interval=None, online_session_source=None, out_call_route_number=None):
        self.ani = ani  # type: str
        self.dnis = dnis  # type: str
        self.evaluation_level = evaluation_level  # type: int
        self.evaluation_score = evaluation_score  # type: int
        self.evaluation_solution = evaluation_solution  # type: int
        self.evaluation_status = evaluation_status  # type: int
        self.online_join_resp_interval = online_join_resp_interval  # type: int
        self.online_session_source = online_session_source  # type: int
        self.out_call_route_number = out_call_route_number  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(QueryTouchListResponseBodyResultDataDataExtAttrs, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ani is not None:
            result['Ani'] = self.ani
        if self.dnis is not None:
            result['Dnis'] = self.dnis
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.evaluation_score is not None:
            result['EvaluationScore'] = self.evaluation_score
        if self.evaluation_solution is not None:
            result['EvaluationSolution'] = self.evaluation_solution
        if self.evaluation_status is not None:
            result['EvaluationStatus'] = self.evaluation_status
        if self.online_join_resp_interval is not None:
            result['OnlineJoinRespInterval'] = self.online_join_resp_interval
        if self.online_session_source is not None:
            result['OnlineSessionSource'] = self.online_session_source
        if self.out_call_route_number is not None:
            result['OutCallRouteNumber'] = self.out_call_route_number
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Ani') is not None:
            self.ani = m.get('Ani')
        if m.get('Dnis') is not None:
            self.dnis = m.get('Dnis')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('EvaluationScore') is not None:
            self.evaluation_score = m.get('EvaluationScore')
        if m.get('EvaluationSolution') is not None:
            self.evaluation_solution = m.get('EvaluationSolution')
        if m.get('EvaluationStatus') is not None:
            self.evaluation_status = m.get('EvaluationStatus')
        if m.get('OnlineJoinRespInterval') is not None:
            self.online_join_resp_interval = m.get('OnlineJoinRespInterval')
        if m.get('OnlineSessionSource') is not None:
            self.online_session_source = m.get('OnlineSessionSource')
        if m.get('OutCallRouteNumber') is not None:
            self.out_call_route_number = m.get('OutCallRouteNumber')
        return self


class QueryTouchListResponseBodyResultDataData(TeaModel):
    def __init__(self, bu_id=None, channel_id=None, channel_type=None, close_time=None, common_queue_name=None,
                 dep_id=None, ext_attrs=None, ext_attrs_string=None, feedback=None, first_time=None, from_id=None,
                 gmt_create=None, gmt_modified=None, member_id=None, member_name=None, parent_touch_id=None, queue_id=None,
                 servicer_id=None, servicer_name=None, status=None, switch_user=None, to_id=None, touch_content=None,
                 touch_end_reason=None, touch_id=None, touch_time=None, touch_type=None, user_touch_id=None):
        self.bu_id = bu_id  # type: long
        self.channel_id = channel_id  # type: str
        self.channel_type = channel_type  # type: int
        self.close_time = close_time  # type: long
        self.common_queue_name = common_queue_name  # type: str
        self.dep_id = dep_id  # type: long
        self.ext_attrs = ext_attrs  # type: QueryTouchListResponseBodyResultDataDataExtAttrs
        self.ext_attrs_string = ext_attrs_string  # type: dict[str, any]
        self.feedback = feedback  # type: str
        self.first_time = first_time  # type: long
        self.from_id = from_id  # type: long
        self.gmt_create = gmt_create  # type: long
        self.gmt_modified = gmt_modified  # type: long
        self.member_id = member_id  # type: long
        self.member_name = member_name  # type: str
        self.parent_touch_id = parent_touch_id  # type: long
        self.queue_id = queue_id  # type: long
        self.servicer_id = servicer_id  # type: long
        self.servicer_name = servicer_name  # type: str
        self.status = status  # type: int
        self.switch_user = switch_user  # type: str
        self.to_id = to_id  # type: long
        self.touch_content = touch_content  # type: str
        self.touch_end_reason = touch_end_reason  # type: int
        self.touch_id = touch_id  # type: str
        self.touch_time = touch_time  # type: str
        self.touch_type = touch_type  # type: int
        self.user_touch_id = user_touch_id  # type: long

    def validate(self):
        if self.ext_attrs:
            self.ext_attrs.validate()

    def to_map(self):
        _map = super(QueryTouchListResponseBodyResultDataData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bu_id is not None:
            result['BuId'] = self.bu_id
        if self.channel_id is not None:
            result['ChannelId'] = self.channel_id
        if self.channel_type is not None:
            result['ChannelType'] = self.channel_type
        if self.close_time is not None:
            result['CloseTime'] = self.close_time
        if self.common_queue_name is not None:
            result['CommonQueueName'] = self.common_queue_name
        if self.dep_id is not None:
            result['DepId'] = self.dep_id
        if self.ext_attrs is not None:
            result['ExtAttrs'] = self.ext_attrs.to_map()
        if self.ext_attrs_string is not None:
            result['ExtAttrsString'] = self.ext_attrs_string
        if self.feedback is not None:
            result['Feedback'] = self.feedback
        if self.first_time is not None:
            result['FirstTime'] = self.first_time
        if self.from_id is not None:
            result['FromId'] = self.from_id
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.member_id is not None:
            result['MemberId'] = self.member_id
        if self.member_name is not None:
            result['MemberName'] = self.member_name
        if self.parent_touch_id is not None:
            result['ParentTouchId'] = self.parent_touch_id
        if self.queue_id is not None:
            result['QueueId'] = self.queue_id
        if self.servicer_id is not None:
            result['ServicerId'] = self.servicer_id
        if self.servicer_name is not None:
            result['ServicerName'] = self.servicer_name
        if self.status is not None:
            result['Status'] = self.status
        if self.switch_user is not None:
            result['SwitchUser'] = self.switch_user
        if self.to_id is not None:
            result['ToId'] = self.to_id
        if self.touch_content is not None:
            result['TouchContent'] = self.touch_content
        if self.touch_end_reason is not None:
            result['TouchEndReason'] = self.touch_end_reason
        if self.touch_id is not None:
            result['TouchId'] = self.touch_id
        if self.touch_time is not None:
            result['TouchTime'] = self.touch_time
        if self.touch_type is not None:
            result['TouchType'] = self.touch_type
        if self.user_touch_id is not None:
            result['UserTouchId'] = self.user_touch_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('BuId') is not None:
            self.bu_id = m.get('BuId')
        if m.get('ChannelId') is not None:
            self.channel_id = m.get('ChannelId')
        if m.get('ChannelType') is not None:
            self.channel_type = m.get('ChannelType')
        if m.get('CloseTime') is not None:
            self.close_time = m.get('CloseTime')
        if m.get('CommonQueueName') is not None:
            self.common_queue_name = m.get('CommonQueueName')
        if m.get('DepId') is not None:
            self.dep_id = m.get('DepId')
        if m.get('ExtAttrs') is not None:
            temp_model = QueryTouchListResponseBodyResultDataDataExtAttrs()
            self.ext_attrs = temp_model.from_map(m['ExtAttrs'])
        if m.get('ExtAttrsString') is not None:
            self.ext_attrs_string = m.get('ExtAttrsString')
        if m.get('Feedback') is not None:
            self.feedback = m.get('Feedback')
        if m.get('FirstTime') is not None:
            self.first_time = m.get('FirstTime')
        if m.get('FromId') is not None:
            self.from_id = m.get('FromId')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('MemberId') is not None:
            self.member_id = m.get('MemberId')
        if m.get('MemberName') is not None:
            self.member_name = m.get('MemberName')
        if m.get('ParentTouchId') is not None:
            self.parent_touch_id = m.get('ParentTouchId')
        if m.get('QueueId') is not None:
            self.queue_id = m.get('QueueId')
        if m.get('ServicerId') is not None:
            self.servicer_id = m.get('ServicerId')
        if m.get('ServicerName') is not None:
            self.servicer_name = m.get('ServicerName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('SwitchUser') is not None:
            self.switch_user = m.get('SwitchUser')
        if m.get('ToId') is not None:
            self.to_id = m.get('ToId')
        if m.get('TouchContent') is not None:
            self.touch_content = m.get('TouchContent')
        if m.get('TouchEndReason') is not None:
            self.touch_end_reason = m.get('TouchEndReason')
        if m.get('TouchId') is not None:
            self.touch_id = m.get('TouchId')
        if m.get('TouchTime') is not None:
            self.touch_time = m.get('TouchTime')
        if m.get('TouchType') is not None:
            self.touch_type = m.get('TouchType')
        if m.get('UserTouchId') is not None:
            self.user_touch_id = m.get('UserTouchId')
        return self


class QueryTouchListResponseBodyResultData(TeaModel):
    def __init__(self, current_page=None, data=None, empty=None, next_page=None, one_page_size=None,
                 previous_page=None, total_page=None, total_results=None):
        self.current_page = current_page  # type: int
        self.data = data  # type: list[QueryTouchListResponseBodyResultDataData]
        self.empty = empty  # type: bool
        self.next_page = next_page  # type: int
        self.one_page_size = one_page_size  # type: int
        self.previous_page = previous_page  # type: int
        self.total_page = total_page  # type: int
        self.total_results = total_results  # type: int

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(QueryTouchListResponseBodyResultData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.empty is not None:
            result['Empty'] = self.empty
        if self.next_page is not None:
            result['NextPage'] = self.next_page
        if self.one_page_size is not None:
            result['OnePageSize'] = self.one_page_size
        if self.previous_page is not None:
            result['PreviousPage'] = self.previous_page
        if self.total_page is not None:
            result['TotalPage'] = self.total_page
        if self.total_results is not None:
            result['TotalResults'] = self.total_results
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = QueryTouchListResponseBodyResultDataData()
                self.data.append(temp_model.from_map(k))
        if m.get('Empty') is not None:
            self.empty = m.get('Empty')
        if m.get('NextPage') is not None:
            self.next_page = m.get('NextPage')
        if m.get('OnePageSize') is not None:
            self.one_page_size = m.get('OnePageSize')
        if m.get('PreviousPage') is not None:
            self.previous_page = m.get('PreviousPage')
        if m.get('TotalPage') is not None:
            self.total_page = m.get('TotalPage')
        if m.get('TotalResults') is not None:
            self.total_results = m.get('TotalResults')
        return self


class QueryTouchListResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, result_data=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.result_data = result_data  # type: QueryTouchListResponseBodyResultData
        self.success = success  # type: bool

    def validate(self):
        if self.result_data:
            self.result_data.validate()

    def to_map(self):
        _map = super(QueryTouchListResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result_data is not None:
            result['ResultData'] = self.result_data.to_map()
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResultData') is not None:
            temp_model = QueryTouchListResponseBodyResultData()
            self.result_data = temp_model.from_map(m['ResultData'])
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class QueryTouchListResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: QueryTouchListResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(QueryTouchListResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = QueryTouchListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveAgentFromSkillGroupRequest(TeaModel):
    def __init__(self, agent_ids=None, instance_id=None, skill_group_id=None):
        self.agent_ids = agent_ids  # type: list[long]
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveAgentFromSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids is not None:
            result['AgentIds'] = self.agent_ids
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids = m.get('AgentIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class RemoveAgentFromSkillGroupShrinkRequest(TeaModel):
    def __init__(self, agent_ids_shrink=None, instance_id=None, skill_group_id=None):
        self.agent_ids_shrink = agent_ids_shrink  # type: str
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveAgentFromSkillGroupShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.agent_ids_shrink is not None:
            result['AgentIds'] = self.agent_ids_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AgentIds') is not None:
            self.agent_ids_shrink = m.get('AgentIds')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class RemoveAgentFromSkillGroupResponseBodyData(TeaModel):
    def __init__(self, success_count=None):
        self.success_count = success_count  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveAgentFromSkillGroupResponseBodyData, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.success_count is not None:
            result['SuccessCount'] = self.success_count
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('SuccessCount') is not None:
            self.success_count = m.get('SuccessCount')
        return self


class RemoveAgentFromSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: RemoveAgentFromSkillGroupResponseBodyData
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super(RemoveAgentFromSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = RemoveAgentFromSkillGroupResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveAgentFromSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: RemoveAgentFromSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveAgentFromSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RemoveAgentFromSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RemoveSkillGroupRequest(TeaModel):
    def __init__(self, client_token=None, instance_id=None, skill_group_id=None):
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        return self


class RemoveSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RemoveSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RemoveSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: RemoveSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RemoveSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RemoveSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ResetHotlineNumberRequestOutboundRangeList(TeaModel):
    def __init__(self, department_id=None, group_id_list=None):
        self.department_id = department_id  # type: long
        self.group_id_list = group_id_list  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResetHotlineNumberRequestOutboundRangeList, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.department_id is not None:
            result['DepartmentId'] = self.department_id
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('DepartmentId') is not None:
            self.department_id = m.get('DepartmentId')
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        return self


class ResetHotlineNumberRequest(TeaModel):
    def __init__(self, description=None, enable_inbound=None, enable_inbound_evaluation=None, enable_outbound=None,
                 enable_outbound_evaluation=None, evaluation_level=None, hotline_number=None, inbound_flow_id=None, instance_id=None,
                 outbound_all_depart=None, outbound_range_list=None):
        self.description = description  # type: str
        self.enable_inbound = enable_inbound  # type: bool
        self.enable_inbound_evaluation = enable_inbound_evaluation  # type: bool
        self.enable_outbound = enable_outbound  # type: bool
        self.enable_outbound_evaluation = enable_outbound_evaluation  # type: bool
        self.evaluation_level = evaluation_level  # type: int
        self.hotline_number = hotline_number  # type: str
        self.inbound_flow_id = inbound_flow_id  # type: long
        self.instance_id = instance_id  # type: str
        self.outbound_all_depart = outbound_all_depart  # type: bool
        self.outbound_range_list = outbound_range_list  # type: list[ResetHotlineNumberRequestOutboundRangeList]

    def validate(self):
        if self.outbound_range_list:
            for k in self.outbound_range_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super(ResetHotlineNumberRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.enable_inbound is not None:
            result['EnableInbound'] = self.enable_inbound
        if self.enable_inbound_evaluation is not None:
            result['EnableInboundEvaluation'] = self.enable_inbound_evaluation
        if self.enable_outbound is not None:
            result['EnableOutbound'] = self.enable_outbound
        if self.enable_outbound_evaluation is not None:
            result['EnableOutboundEvaluation'] = self.enable_outbound_evaluation
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.inbound_flow_id is not None:
            result['InboundFlowId'] = self.inbound_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_all_depart is not None:
            result['OutboundAllDepart'] = self.outbound_all_depart
        result['OutboundRangeList'] = []
        if self.outbound_range_list is not None:
            for k in self.outbound_range_list:
                result['OutboundRangeList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnableInbound') is not None:
            self.enable_inbound = m.get('EnableInbound')
        if m.get('EnableInboundEvaluation') is not None:
            self.enable_inbound_evaluation = m.get('EnableInboundEvaluation')
        if m.get('EnableOutbound') is not None:
            self.enable_outbound = m.get('EnableOutbound')
        if m.get('EnableOutboundEvaluation') is not None:
            self.enable_outbound_evaluation = m.get('EnableOutboundEvaluation')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InboundFlowId') is not None:
            self.inbound_flow_id = m.get('InboundFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundAllDepart') is not None:
            self.outbound_all_depart = m.get('OutboundAllDepart')
        self.outbound_range_list = []
        if m.get('OutboundRangeList') is not None:
            for k in m.get('OutboundRangeList'):
                temp_model = ResetHotlineNumberRequestOutboundRangeList()
                self.outbound_range_list.append(temp_model.from_map(k))
        return self


class ResetHotlineNumberShrinkRequest(TeaModel):
    def __init__(self, description=None, enable_inbound=None, enable_inbound_evaluation=None, enable_outbound=None,
                 enable_outbound_evaluation=None, evaluation_level=None, hotline_number=None, inbound_flow_id=None, instance_id=None,
                 outbound_all_depart=None, outbound_range_list_shrink=None):
        self.description = description  # type: str
        self.enable_inbound = enable_inbound  # type: bool
        self.enable_inbound_evaluation = enable_inbound_evaluation  # type: bool
        self.enable_outbound = enable_outbound  # type: bool
        self.enable_outbound_evaluation = enable_outbound_evaluation  # type: bool
        self.evaluation_level = evaluation_level  # type: int
        self.hotline_number = hotline_number  # type: str
        self.inbound_flow_id = inbound_flow_id  # type: long
        self.instance_id = instance_id  # type: str
        self.outbound_all_depart = outbound_all_depart  # type: bool
        self.outbound_range_list_shrink = outbound_range_list_shrink  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResetHotlineNumberShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.description is not None:
            result['Description'] = self.description
        if self.enable_inbound is not None:
            result['EnableInbound'] = self.enable_inbound
        if self.enable_inbound_evaluation is not None:
            result['EnableInboundEvaluation'] = self.enable_inbound_evaluation
        if self.enable_outbound is not None:
            result['EnableOutbound'] = self.enable_outbound
        if self.enable_outbound_evaluation is not None:
            result['EnableOutboundEvaluation'] = self.enable_outbound_evaluation
        if self.evaluation_level is not None:
            result['EvaluationLevel'] = self.evaluation_level
        if self.hotline_number is not None:
            result['HotlineNumber'] = self.hotline_number
        if self.inbound_flow_id is not None:
            result['InboundFlowId'] = self.inbound_flow_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_all_depart is not None:
            result['OutboundAllDepart'] = self.outbound_all_depart
        if self.outbound_range_list_shrink is not None:
            result['OutboundRangeList'] = self.outbound_range_list_shrink
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EnableInbound') is not None:
            self.enable_inbound = m.get('EnableInbound')
        if m.get('EnableInboundEvaluation') is not None:
            self.enable_inbound_evaluation = m.get('EnableInboundEvaluation')
        if m.get('EnableOutbound') is not None:
            self.enable_outbound = m.get('EnableOutbound')
        if m.get('EnableOutboundEvaluation') is not None:
            self.enable_outbound_evaluation = m.get('EnableOutboundEvaluation')
        if m.get('EvaluationLevel') is not None:
            self.evaluation_level = m.get('EvaluationLevel')
        if m.get('HotlineNumber') is not None:
            self.hotline_number = m.get('HotlineNumber')
        if m.get('InboundFlowId') is not None:
            self.inbound_flow_id = m.get('InboundFlowId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundAllDepart') is not None:
            self.outbound_all_depart = m.get('OutboundAllDepart')
        if m.get('OutboundRangeList') is not None:
            self.outbound_range_list_shrink = m.get('OutboundRangeList')
        return self


class ResetHotlineNumberResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(ResetHotlineNumberResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class ResetHotlineNumberResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: ResetHotlineNumberResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(ResetHotlineNumberResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ResetHotlineNumberResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RestartOutboundTaskRequest(TeaModel):
    def __init__(self, instance_id=None, outbound_task_id=None):
        self.instance_id = instance_id  # type: str
        self.outbound_task_id = outbound_task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(RestartOutboundTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_task_id is not None:
            result['OutboundTaskId'] = self.outbound_task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundTaskId') is not None:
            self.outbound_task_id = m.get('OutboundTaskId')
        return self


class RestartOutboundTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(RestartOutboundTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class RestartOutboundTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: RestartOutboundTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RestartOutboundTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RestartOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class RobotCallRequest(TeaModel):
    def __init__(self, called_number=None, called_show_number=None, early_media_asr=None, out_id=None,
                 owner_id=None, params=None, record_flag=None, resource_owner_account=None, resource_owner_id=None,
                 robot_id=None):
        self.called_number = called_number  # type: str
        self.called_show_number = called_show_number  # type: str
        self.early_media_asr = early_media_asr  # type: bool
        self.out_id = out_id  # type: str
        self.owner_id = owner_id  # type: long
        self.params = params  # type: str
        self.record_flag = record_flag  # type: bool
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.robot_id = robot_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(RobotCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.called_show_number is not None:
            result['CalledShowNumber'] = self.called_show_number
        if self.early_media_asr is not None:
            result['EarlyMediaAsr'] = self.early_media_asr
        if self.out_id is not None:
            result['OutId'] = self.out_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.params is not None:
            result['Params'] = self.params
        if self.record_flag is not None:
            result['RecordFlag'] = self.record_flag
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.robot_id is not None:
            result['RobotId'] = self.robot_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CalledShowNumber') is not None:
            self.called_show_number = m.get('CalledShowNumber')
        if m.get('EarlyMediaAsr') is not None:
            self.early_media_asr = m.get('EarlyMediaAsr')
        if m.get('OutId') is not None:
            self.out_id = m.get('OutId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Params') is not None:
            self.params = m.get('Params')
        if m.get('RecordFlag') is not None:
            self.record_flag = m.get('RecordFlag')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RobotId') is not None:
            self.robot_id = m.get('RobotId')
        return self


class RobotCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(RobotCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class RobotCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: RobotCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(RobotCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = RobotCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SendCcoSmartCallRequest(TeaModel):
    def __init__(self, action_code_break=None, action_code_time_break=None, asr_als_am_id=None, asr_base_id=None,
                 asr_model_id=None, asr_vocabulary_id=None, background_file_code=None, background_speed=None,
                 background_volume=None, called_number=None, called_show_number=None, dynamic_id=None, early_media_asr=None,
                 enable_itn=None, mute_time=None, out_id=None, owner_id=None, pause_time=None, play_times=None, prod_code=None,
                 record_flag=None, resource_owner_account=None, resource_owner_id=None, session_timeout=None, speed=None,
                 tts_conf=None, tts_speed=None, tts_style=None, tts_volume=None, voice_code=None, voice_code_param=None,
                 volume=None):
        self.action_code_break = action_code_break  # type: bool
        self.action_code_time_break = action_code_time_break  # type: int
        self.asr_als_am_id = asr_als_am_id  # type: str
        self.asr_base_id = asr_base_id  # type: str
        self.asr_model_id = asr_model_id  # type: str
        self.asr_vocabulary_id = asr_vocabulary_id  # type: str
        self.background_file_code = background_file_code  # type: str
        self.background_speed = background_speed  # type: int
        self.background_volume = background_volume  # type: int
        self.called_number = called_number  # type: str
        self.called_show_number = called_show_number  # type: str
        self.dynamic_id = dynamic_id  # type: str
        self.early_media_asr = early_media_asr  # type: bool
        self.enable_itn = enable_itn  # type: bool
        self.mute_time = mute_time  # type: int
        self.out_id = out_id  # type: str
        self.owner_id = owner_id  # type: long
        self.pause_time = pause_time  # type: int
        self.play_times = play_times  # type: int
        self.prod_code = prod_code  # type: str
        self.record_flag = record_flag  # type: bool
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.session_timeout = session_timeout  # type: int
        self.speed = speed  # type: int
        self.tts_conf = tts_conf  # type: bool
        self.tts_speed = tts_speed  # type: int
        self.tts_style = tts_style  # type: str
        self.tts_volume = tts_volume  # type: int
        self.voice_code = voice_code  # type: str
        self.voice_code_param = voice_code_param  # type: str
        self.volume = volume  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(SendCcoSmartCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_code_break is not None:
            result['ActionCodeBreak'] = self.action_code_break
        if self.action_code_time_break is not None:
            result['ActionCodeTimeBreak'] = self.action_code_time_break
        if self.asr_als_am_id is not None:
            result['AsrAlsAmId'] = self.asr_als_am_id
        if self.asr_base_id is not None:
            result['AsrBaseId'] = self.asr_base_id
        if self.asr_model_id is not None:
            result['AsrModelId'] = self.asr_model_id
        if self.asr_vocabulary_id is not None:
            result['AsrVocabularyId'] = self.asr_vocabulary_id
        if self.background_file_code is not None:
            result['BackgroundFileCode'] = self.background_file_code
        if self.background_speed is not None:
            result['BackgroundSpeed'] = self.background_speed
        if self.background_volume is not None:
            result['BackgroundVolume'] = self.background_volume
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.called_show_number is not None:
            result['CalledShowNumber'] = self.called_show_number
        if self.dynamic_id is not None:
            result['DynamicId'] = self.dynamic_id
        if self.early_media_asr is not None:
            result['EarlyMediaAsr'] = self.early_media_asr
        if self.enable_itn is not None:
            result['EnableITN'] = self.enable_itn
        if self.mute_time is not None:
            result['MuteTime'] = self.mute_time
        if self.out_id is not None:
            result['OutId'] = self.out_id
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.pause_time is not None:
            result['PauseTime'] = self.pause_time
        if self.play_times is not None:
            result['PlayTimes'] = self.play_times
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.record_flag is not None:
            result['RecordFlag'] = self.record_flag
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.session_timeout is not None:
            result['SessionTimeout'] = self.session_timeout
        if self.speed is not None:
            result['Speed'] = self.speed
        if self.tts_conf is not None:
            result['TtsConf'] = self.tts_conf
        if self.tts_speed is not None:
            result['TtsSpeed'] = self.tts_speed
        if self.tts_style is not None:
            result['TtsStyle'] = self.tts_style
        if self.tts_volume is not None:
            result['TtsVolume'] = self.tts_volume
        if self.voice_code is not None:
            result['VoiceCode'] = self.voice_code
        if self.voice_code_param is not None:
            result['VoiceCodeParam'] = self.voice_code_param
        if self.volume is not None:
            result['Volume'] = self.volume
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ActionCodeBreak') is not None:
            self.action_code_break = m.get('ActionCodeBreak')
        if m.get('ActionCodeTimeBreak') is not None:
            self.action_code_time_break = m.get('ActionCodeTimeBreak')
        if m.get('AsrAlsAmId') is not None:
            self.asr_als_am_id = m.get('AsrAlsAmId')
        if m.get('AsrBaseId') is not None:
            self.asr_base_id = m.get('AsrBaseId')
        if m.get('AsrModelId') is not None:
            self.asr_model_id = m.get('AsrModelId')
        if m.get('AsrVocabularyId') is not None:
            self.asr_vocabulary_id = m.get('AsrVocabularyId')
        if m.get('BackgroundFileCode') is not None:
            self.background_file_code = m.get('BackgroundFileCode')
        if m.get('BackgroundSpeed') is not None:
            self.background_speed = m.get('BackgroundSpeed')
        if m.get('BackgroundVolume') is not None:
            self.background_volume = m.get('BackgroundVolume')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CalledShowNumber') is not None:
            self.called_show_number = m.get('CalledShowNumber')
        if m.get('DynamicId') is not None:
            self.dynamic_id = m.get('DynamicId')
        if m.get('EarlyMediaAsr') is not None:
            self.early_media_asr = m.get('EarlyMediaAsr')
        if m.get('EnableITN') is not None:
            self.enable_itn = m.get('EnableITN')
        if m.get('MuteTime') is not None:
            self.mute_time = m.get('MuteTime')
        if m.get('OutId') is not None:
            self.out_id = m.get('OutId')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('PauseTime') is not None:
            self.pause_time = m.get('PauseTime')
        if m.get('PlayTimes') is not None:
            self.play_times = m.get('PlayTimes')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('RecordFlag') is not None:
            self.record_flag = m.get('RecordFlag')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SessionTimeout') is not None:
            self.session_timeout = m.get('SessionTimeout')
        if m.get('Speed') is not None:
            self.speed = m.get('Speed')
        if m.get('TtsConf') is not None:
            self.tts_conf = m.get('TtsConf')
        if m.get('TtsSpeed') is not None:
            self.tts_speed = m.get('TtsSpeed')
        if m.get('TtsStyle') is not None:
            self.tts_style = m.get('TtsStyle')
        if m.get('TtsVolume') is not None:
            self.tts_volume = m.get('TtsVolume')
        if m.get('VoiceCode') is not None:
            self.voice_code = m.get('VoiceCode')
        if m.get('VoiceCodeParam') is not None:
            self.voice_code_param = m.get('VoiceCodeParam')
        if m.get('Volume') is not None:
            self.volume = m.get('Volume')
        return self


class SendCcoSmartCallResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SendCcoSmartCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SendCcoSmartCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: SendCcoSmartCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SendCcoSmartCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SendCcoSmartCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SendCcoSmartCallOperateRequest(TeaModel):
    def __init__(self, call_id=None, command=None, owner_id=None, param=None, prod_code=None,
                 resource_owner_account=None, resource_owner_id=None):
        self.call_id = call_id  # type: str
        self.command = command  # type: str
        self.owner_id = owner_id  # type: long
        self.param = param  # type: str
        self.prod_code = prod_code  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(SendCcoSmartCallOperateRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.command is not None:
            result['Command'] = self.command
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.param is not None:
            result['Param'] = self.param
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('Command') is not None:
            self.command = m.get('Command')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('Param') is not None:
            self.param = m.get('Param')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class SendCcoSmartCallOperateResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SendCcoSmartCallOperateResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class SendCcoSmartCallOperateResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: SendCcoSmartCallOperateResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SendCcoSmartCallOperateResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SendCcoSmartCallOperateResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SendHotlineHeartBeatRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, instance_id=None, token=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str
        self.token = token  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(SendHotlineHeartBeatRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.token is not None:
            result['Token'] = self.token
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        return self


class SendHotlineHeartBeatResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SendHotlineHeartBeatResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SendHotlineHeartBeatResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: SendHotlineHeartBeatResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SendHotlineHeartBeatResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SendHotlineHeartBeatResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartAiOutboundTaskRequest(TeaModel):
    def __init__(self, instance_id=None, task_id=None):
        self.instance_id = instance_id  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartAiOutboundTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class StartAiOutboundTaskResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartAiOutboundTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartAiOutboundTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: StartAiOutboundTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StartAiOutboundTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartAiOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartCallRequest(TeaModel):
    def __init__(self, account_name=None, callee=None, caller=None, client_token=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.callee = callee  # type: str
        self.caller = caller  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartCallRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class StartCallResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartCallResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartCallResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: StartCallResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StartCallResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartCallResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartCallV2Request(TeaModel):
    def __init__(self, account_name=None, callee=None, caller=None, caller_type=None, client_token=None,
                 instance_id=None):
        self.account_name = account_name  # type: str
        self.callee = callee  # type: str
        self.caller = caller  # type: str
        self.caller_type = caller_type  # type: int
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartCallV2Request, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.callee is not None:
            result['Callee'] = self.callee
        if self.caller is not None:
            result['Caller'] = self.caller
        if self.caller_type is not None:
            result['CallerType'] = self.caller_type
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('Callee') is not None:
            self.callee = m.get('Callee')
        if m.get('Caller') is not None:
            self.caller = m.get('Caller')
        if m.get('CallerType') is not None:
            self.caller_type = m.get('CallerType')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class StartCallV2ResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartCallV2ResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartCallV2Response(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: StartCallV2ResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StartCallV2Response, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartCallV2ResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartChatWorkRequest(TeaModel):
    def __init__(self, account_name=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartChatWorkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class StartChatWorkResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: int
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartChatWorkResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartChatWorkResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: StartChatWorkResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StartChatWorkResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartChatWorkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartHotlineServiceRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, instance_id=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartHotlineServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        return self


class StartHotlineServiceResponseBody(TeaModel):
    def __init__(self, code=None, data=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartHotlineServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartHotlineServiceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: StartHotlineServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StartHotlineServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartHotlineServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartMicroOutboundRequest(TeaModel):
    def __init__(self, account_id=None, account_type=None, app_name=None, called_number=None, calling_number=None,
                 command_code=None, ext_info=None, owner_id=None, prod_code=None, resource_owner_account=None,
                 resource_owner_id=None):
        self.account_id = account_id  # type: str
        self.account_type = account_type  # type: str
        self.app_name = app_name  # type: str
        self.called_number = called_number  # type: str
        self.calling_number = calling_number  # type: str
        self.command_code = command_code  # type: str
        self.ext_info = ext_info  # type: str
        self.owner_id = owner_id  # type: long
        self.prod_code = prod_code  # type: str
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartMicroOutboundRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_id is not None:
            result['AccountId'] = self.account_id
        if self.account_type is not None:
            result['AccountType'] = self.account_type
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.called_number is not None:
            result['CalledNumber'] = self.called_number
        if self.calling_number is not None:
            result['CallingNumber'] = self.calling_number
        if self.command_code is not None:
            result['CommandCode'] = self.command_code
        if self.ext_info is not None:
            result['ExtInfo'] = self.ext_info
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.prod_code is not None:
            result['ProdCode'] = self.prod_code
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountId') is not None:
            self.account_id = m.get('AccountId')
        if m.get('AccountType') is not None:
            self.account_type = m.get('AccountType')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CalledNumber') is not None:
            self.called_number = m.get('CalledNumber')
        if m.get('CallingNumber') is not None:
            self.calling_number = m.get('CallingNumber')
        if m.get('CommandCode') is not None:
            self.command_code = m.get('CommandCode')
        if m.get('ExtInfo') is not None:
            self.ext_info = m.get('ExtInfo')
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ProdCode') is not None:
            self.prod_code = m.get('ProdCode')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class StartMicroOutboundResponseBody(TeaModel):
    def __init__(self, code=None, customer_info=None, invoke_cmd_id=None, invoke_create_time=None, message=None,
                 request_id=None):
        self.code = code  # type: str
        self.customer_info = customer_info  # type: str
        self.invoke_cmd_id = invoke_cmd_id  # type: str
        self.invoke_create_time = invoke_create_time  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartMicroOutboundResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.customer_info is not None:
            result['CustomerInfo'] = self.customer_info
        if self.invoke_cmd_id is not None:
            result['InvokeCmdId'] = self.invoke_cmd_id
        if self.invoke_create_time is not None:
            result['InvokeCreateTime'] = self.invoke_create_time
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('CustomerInfo') is not None:
            self.customer_info = m.get('CustomerInfo')
        if m.get('InvokeCmdId') is not None:
            self.invoke_cmd_id = m.get('InvokeCmdId')
        if m.get('InvokeCreateTime') is not None:
            self.invoke_create_time = m.get('InvokeCreateTime')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class StartMicroOutboundResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: StartMicroOutboundResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StartMicroOutboundResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartMicroOutboundResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StartTaskRequest(TeaModel):
    def __init__(self, owner_id=None, resource_owner_account=None, resource_owner_id=None, start_now=None,
                 task_id=None):
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.start_now = start_now  # type: bool
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.start_now is not None:
            result['StartNow'] = self.start_now
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('StartNow') is not None:
            self.start_now = m.get('StartNow')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class StartTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(StartTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StartTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: StartTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StartTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StartTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StopAiOutboundTaskRequest(TeaModel):
    def __init__(self, instance_id=None, task_id=None):
        self.instance_id = instance_id  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(StopAiOutboundTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class StopAiOutboundTaskResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(StopAiOutboundTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StopAiOutboundTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: StopAiOutboundTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StopAiOutboundTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StopAiOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class StopTaskRequest(TeaModel):
    def __init__(self, owner_id=None, resource_owner_account=None, resource_owner_id=None, task_id=None):
        self.owner_id = owner_id  # type: long
        self.resource_owner_account = resource_owner_account  # type: str
        self.resource_owner_id = resource_owner_id  # type: long
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(StopTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.owner_id is not None:
            result['OwnerId'] = self.owner_id
        if self.resource_owner_account is not None:
            result['ResourceOwnerAccount'] = self.resource_owner_account
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('OwnerId') is not None:
            self.owner_id = m.get('OwnerId')
        if m.get('ResourceOwnerAccount') is not None:
            self.resource_owner_account = m.get('ResourceOwnerAccount')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class StopTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: bool
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(StopTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class StopTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: StopTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(StopTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = StopTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SuspendHotlineServiceRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, instance_id=None, type=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.instance_id = instance_id  # type: str
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(SuspendHotlineServiceRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class SuspendHotlineServiceResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SuspendHotlineServiceResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SuspendHotlineServiceResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: SuspendHotlineServiceResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SuspendHotlineServiceResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SuspendHotlineServiceResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class SuspendOutboundTaskRequest(TeaModel):
    def __init__(self, instance_id=None, outbound_task_id=None):
        self.instance_id = instance_id  # type: str
        self.outbound_task_id = outbound_task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(SuspendOutboundTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.outbound_task_id is not None:
            result['OutboundTaskId'] = self.outbound_task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('OutboundTaskId') is not None:
            self.outbound_task_id = m.get('OutboundTaskId')
        return self


class SuspendOutboundTaskResponseBody(TeaModel):
    def __init__(self, code=None, data=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.data = data  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(SuspendOutboundTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class SuspendOutboundTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: SuspendOutboundTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(SuspendOutboundTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = SuspendOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class TerminateAiOutboundTaskRequest(TeaModel):
    def __init__(self, instance_id=None, task_id=None):
        self.instance_id = instance_id  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(TerminateAiOutboundTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class TerminateAiOutboundTaskResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(TerminateAiOutboundTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class TerminateAiOutboundTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: TerminateAiOutboundTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(TerminateAiOutboundTaskResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = TerminateAiOutboundTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class TransferCallToSkillGroupRequest(TeaModel):
    def __init__(self, account_name=None, call_id=None, client_token=None, connection_id=None,
                 hold_connection_id=None, instance_id=None, is_single_transfer=None, job_id=None, skill_group_id=None, type=None):
        self.account_name = account_name  # type: str
        self.call_id = call_id  # type: str
        self.client_token = client_token  # type: str
        self.connection_id = connection_id  # type: str
        self.hold_connection_id = hold_connection_id  # type: str
        self.instance_id = instance_id  # type: str
        self.is_single_transfer = is_single_transfer  # type: bool
        self.job_id = job_id  # type: str
        self.skill_group_id = skill_group_id  # type: long
        self.type = type  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(TransferCallToSkillGroupRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.call_id is not None:
            result['CallId'] = self.call_id
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.connection_id is not None:
            result['ConnectionId'] = self.connection_id
        if self.hold_connection_id is not None:
            result['HoldConnectionId'] = self.hold_connection_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.is_single_transfer is not None:
            result['IsSingleTransfer'] = self.is_single_transfer
        if self.job_id is not None:
            result['JobId'] = self.job_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('CallId') is not None:
            self.call_id = m.get('CallId')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('ConnectionId') is not None:
            self.connection_id = m.get('ConnectionId')
        if m.get('HoldConnectionId') is not None:
            self.hold_connection_id = m.get('HoldConnectionId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('IsSingleTransfer') is not None:
            self.is_single_transfer = m.get('IsSingleTransfer')
        if m.get('JobId') is not None:
            self.job_id = m.get('JobId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class TransferCallToSkillGroupResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(TransferCallToSkillGroupResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class TransferCallToSkillGroupResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: TransferCallToSkillGroupResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(TransferCallToSkillGroupResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = TransferCallToSkillGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateAgentRequest(TeaModel):
    def __init__(self, account_name=None, client_token=None, display_name=None, instance_id=None,
                 skill_group_id=None, skill_group_id_list=None):
        self.account_name = account_name  # type: str
        self.client_token = client_token  # type: str
        self.display_name = display_name  # type: str
        self.instance_id = instance_id  # type: str
        self.skill_group_id = skill_group_id  # type: list[long]
        self.skill_group_id_list = skill_group_id_list  # type: list[long]

    def validate(self):
        pass

    def to_map(self):
        _map = super(UpdateAgentRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.client_token is not None:
            result['ClientToken'] = self.client_token
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.skill_group_id is not None:
            result['SkillGroupId'] = self.skill_group_id
        if self.skill_group_id_list is not None:
            result['SkillGroupIdList'] = self.skill_group_id_list
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('ClientToken') is not None:
            self.client_token = m.get('ClientToken')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('SkillGroupId') is not None:
            self.skill_group_id = m.get('SkillGroupId')
        if m.get('SkillGroupIdList') is not None:
            self.skill_group_id_list = m.get('SkillGroupIdList')
        return self


class UpdateAgentResponseBody(TeaModel):
    def __init__(self, code=None, http_status_code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.http_status_code = http_status_code  # type: long
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(UpdateAgentResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class UpdateAgentResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: UpdateAgentResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super(UpdateAgentResponse, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = UpdateAgentResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class UpdateAiOutboundTaskRequestRecallRule(TeaModel):
    def __init__(self, count=None, interval=None):
        self.count = count  # type: int
        self.interval = interval  # type: int

    def validate(self):
        pass

    def to_map(self):
        _map = super(UpdateAiOutboundTaskRequestRecallRule, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.interval is not None:
            result['Interval'] = self.interval
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Interval') is not None:
            self.interval = m.get('Interval')
        return self


class UpdateAiOutboundTaskRequest(TeaModel):
    def __init__(self, concurrent_rate=None, description=None, execution_time=None, forecast_call_rate=None,
                 handler_id=None, instance_id=None, name=None, num_repeated=None, outbound_nums=None, recall_rule=None,
                 task_id=None):
        self.concurrent_rate = concurrent_rate  # type: int
        self.description = description  # type: str
        self.execution_time = execution_time  # type: str
        self.forecast_call_rate = forecast_call_rate  # type: float
        self.handler_id = handler_id  # type: long
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.num_repeated = num_repeated  # type: int
        self.outbound_nums = outbound_nums  # type: list[str]
        self.recall_rule = recall_rule  # type: UpdateAiOutboundTaskRequestRecallRule
        self.task_id = task_id  # type: long

    def validate(self):
        if self.recall_rule:
            self.recall_rule.validate()

    def to_map(self):
        _map = super(UpdateAiOutboundTaskRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrent_rate is not None:
            result['ConcurrentRate'] = self.concurrent_rate
        if self.description is not None:
            result['Description'] = self.description
        if self.execution_time is not None:
            result['ExecutionTime'] = self.execution_time
        if self.forecast_call_rate is not None:
            result['ForecastCallRate'] = self.forecast_call_rate
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.num_repeated is not None:
            result['NumRepeated'] = self.num_repeated
        if self.outbound_nums is not None:
            result['OutboundNums'] = self.outbound_nums
        if self.recall_rule is not None:
            result['RecallRule'] = self.recall_rule.to_map()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConcurrentRate') is not None:
            self.concurrent_rate = m.get('ConcurrentRate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExecutionTime') is not None:
            self.execution_time = m.get('ExecutionTime')
        if m.get('ForecastCallRate') is not None:
            self.forecast_call_rate = m.get('ForecastCallRate')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumRepeated') is not None:
            self.num_repeated = m.get('NumRepeated')
        if m.get('OutboundNums') is not None:
            self.outbound_nums = m.get('OutboundNums')
        if m.get('RecallRule') is not None:
            temp_model = UpdateAiOutboundTaskRequestRecallRule()
            self.recall_rule = temp_model.from_map(m['RecallRule'])
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class UpdateAiOutboundTaskShrinkRequest(TeaModel):
    def __init__(self, concurrent_rate=None, description=None, execution_time=None, forecast_call_rate=None,
                 handler_id=None, instance_id=None, name=None, num_repeated=None, outbound_nums_shrink=None,
                 recall_rule_shrink=None, task_id=None):
        self.concurrent_rate = concurrent_rate  # type: int
        self.description = description  # type: str
        self.execution_time = execution_time  # type: str
        self.forecast_call_rate = forecast_call_rate  # type: float
        self.handler_id = handler_id  # type: long
        self.instance_id = instance_id  # type: str
        self.name = name  # type: str
        self.num_repeated = num_repeated  # type: int
        self.outbound_nums_shrink = outbound_nums_shrink  # type: str
        self.recall_rule_shrink = recall_rule_shrink  # type: str
        self.task_id = task_id  # type: long

    def validate(self):
        pass

    def to_map(self):
        _map = super(UpdateAiOutboundTaskShrinkRequest, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concurrent_rate is not None:
            result['ConcurrentRate'] = self.concurrent_rate
        if self.description is not None:
            result['Description'] = self.description
        if self.execution_time is not None:
            result['ExecutionTime'] = self.execution_time
        if self.forecast_call_rate is not None:
            result['ForecastCallRate'] = self.forecast_call_rate
        if self.handler_id is not None:
            result['HandlerId'] = self.handler_id
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.name is not None:
            result['Name'] = self.name
        if self.num_repeated is not None:
            result['NumRepeated'] = self.num_repeated
        if self.outbound_nums_shrink is not None:
            result['OutboundNums'] = self.outbound_nums_shrink
        if self.recall_rule_shrink is not None:
            result['RecallRule'] = self.recall_rule_shrink
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('ConcurrentRate') is not None:
            self.concurrent_rate = m.get('ConcurrentRate')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('ExecutionTime') is not None:
            self.execution_time = m.get('ExecutionTime')
        if m.get('ForecastCallRate') is not None:
            self.forecast_call_rate = m.get('ForecastCallRate')
        if m.get('HandlerId') is not None:
            self.handler_id = m.get('HandlerId')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NumRepeated') is not None:
            self.num_repeated = m.get('NumRepeated')
        if m.get('OutboundNums') is not None:
            self.outbound_nums_shrink = m.get('OutboundNums')
        if m.get('RecallRule') is not None:
            self.recall_rule_shrink = m.get('RecallRule')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class UpdateAiOutboundTaskResponseBody(TeaModel):
    def __init__(self, code=None, message=None, request_id=None, success=None):
        self.code = code  # type: str
        self.message = message  # type: str
        self.request_id = request_id  # type: str
        self.success = success  # type: bool

    def validate(self):
        pass

    def to_map(self):
        _map = super(UpdateAiOutboundTaskResponseBody, self).to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m=None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class UpdateAiOutboundTaskResponse(TeaModel):
    def __init__(self, headers=None, status_code=None, body=None):
        self.headers = headers  # type: dict[str, str]
        self.status_code = status_code  # type: int
        self.body = body  # type: UpdateAiOutboundTaskResponseBody

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 