import setuptools, os

readme_path = 'README.md'

if os.path.exists(readme_path):
    with open(readme_path, "r") as f:
        long_description = f.read()
else:
    long_description = 'kcliutils'

setuptools.setup(
    name="kcliutils",
    version="0.0.8",
    author="Kristof",
    description="kcliutils",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/kkristof200/py_cli_utils",
    packages=setuptools.find_packages(),
    install_requires=[],
    classifiers=[
        "Programming Language :: Python :: 3.4",
        "Programming Language :: Python :: 3.5",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    entry_points={
        'console_scripts': [
            # Main

            'new_python_package=kcliutils.__main__:new_package',
            'npp=kcliutils.__main__:new_package',

            'upgrade_python_package=kcliutils.__main__:upgrade',
            'upp=kcliutils.__main__:upgrade',

            'publish_python_package=kcliutils.__main__:publish',
            'ppp=kcliutils.__main__:publish',

            'publish_and_push_python_package=kcliutils.__main__:publish_and_push',
            'pipush=kcliutils.__main__:publish_and_push',
            'pppp=kcliutils.__main__:publish_and_push',

            'clean_lines=kcliutils.__main__:clean_lines',
            'cl=kcliutils.__main__:clean_lines',


            # Git

            'push=kcliutils.__main__:push',
            'psh=kcliutils.__main__:push',

            'fetch=kcliutils.__main__:fetch',
            'ftch=kcliutils.__main__:fetch',

            'pull=kcliutils.__main__:pull',
            'pll=kcliutils.__main__:pull',


            # Pip

            'pip_uninstall=kcliutils.__main__:uninstall',
            'pipu=kcliutils.__main__:uninstall',

            'pip_install=kcliutils.__main__:install',
            'pipi=kcliutils.__main__:install',
            'pipiu=kcliutils.__main__:install',

            'pip_reinstall=kcliutils.__main__:reinstall',
            'pipir=kcliutils.__main__:reinstall',


            # New files

            'new_python_install_file=kcliutils.__main__:create_install_file',
            'npif=kcliutils.__main__:create_install_file',

            'new_python_api=kcliutils.__main__:create_new_api',
            'npa=kcliutils.__main__:create_new_api',

            'new_python_class=kcliutils.__main__:create_new_class',
            'npc=kcliutils.__main__:create_new_class',

            'new_python_enum=kcliutils.__main__:create_new_enum',
            'npe=kcliutils.__main__:create_new_enum',

            'new_python_file=kcliutils.__main__:create_new_file',
            'npf=kcliutils.__main__:create_new_file',

            'new_python_flow=kcliutils.__main__:create_new_flow',
            'npfl=kcliutils.__main__:create_new_flow',

            'new_python_subpackage=kcliutils.__main__:create_new_subpackage',
            'nps=kcliutils.__main__:create_new_subpackage'
        ]
    },
    python_requires='>=3.4',
)
