# --------------------------------------------------------------- Imports ---------------------------------------------------------------- #

# Local
from .core_texts import enum_
from .utils import comment_line, multi_replace

# ---------------------------------------------------------------------------------------------------------------------------------------- #



# ------------------------------------------------------------ Public methods ------------------------------------------------------------ #

def new_enum(class_name: str) -> str:
    return multi_replace(
        enum_,
        {
            '[CLASS_NAME]': class_name,
            '[CLASS_NAME_COMMENT_LINE]': comment_line('enum: {}'.format(class_name))
        }
    )


# ---------------------------------------------------------------------------------------------------------------------------------------- #
