# coding: utf-8

"""
    Xero Finance API

    The Finance API is a collection of endpoints which customers can use in the course of a loan application, which may assist lenders to gain the confidence they need to provide capital.  # noqa: E501

    Contact: api@xero.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401

from xero_python.models import BaseModel


class DataSourceResponse(BaseModel):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "direct_bank_feed": "float",
        "indirect_bank_feed": "float",
        "file_upload": "float",
        "manual": "float",
        "direct_bank_feed_pos": "float",
        "indirect_bank_feed_pos": "float",
        "file_upload_pos": "float",
        "manual_pos": "float",
        "direct_bank_feed_neg": "float",
        "indirect_bank_feed_neg": "float",
        "file_upload_neg": "float",
        "manual_neg": "float",
        "other_pos": "float",
        "other_neg": "float",
        "other": "float",
    }

    attribute_map = {
        "direct_bank_feed": "directBankFeed",
        "indirect_bank_feed": "indirectBankFeed",
        "file_upload": "fileUpload",
        "manual": "manual",
        "direct_bank_feed_pos": "directBankFeedPos",
        "indirect_bank_feed_pos": "indirectBankFeedPos",
        "file_upload_pos": "fileUploadPos",
        "manual_pos": "manualPos",
        "direct_bank_feed_neg": "directBankFeedNeg",
        "indirect_bank_feed_neg": "indirectBankFeedNeg",
        "file_upload_neg": "fileUploadNeg",
        "manual_neg": "manualNeg",
        "other_pos": "otherPos",
        "other_neg": "otherNeg",
        "other": "other",
    }

    def __init__(
        self,
        direct_bank_feed=None,
        indirect_bank_feed=None,
        file_upload=None,
        manual=None,
        direct_bank_feed_pos=None,
        indirect_bank_feed_pos=None,
        file_upload_pos=None,
        manual_pos=None,
        direct_bank_feed_neg=None,
        indirect_bank_feed_neg=None,
        file_upload_neg=None,
        manual_neg=None,
        other_pos=None,
        other_neg=None,
        other=None,
    ):  # noqa: E501
        """DataSourceResponse - a model defined in OpenAPI"""  # noqa: E501

        self._direct_bank_feed = None
        self._indirect_bank_feed = None
        self._file_upload = None
        self._manual = None
        self._direct_bank_feed_pos = None
        self._indirect_bank_feed_pos = None
        self._file_upload_pos = None
        self._manual_pos = None
        self._direct_bank_feed_neg = None
        self._indirect_bank_feed_neg = None
        self._file_upload_neg = None
        self._manual_neg = None
        self._other_pos = None
        self._other_neg = None
        self._other = None
        self.discriminator = None

        if direct_bank_feed is not None:
            self.direct_bank_feed = direct_bank_feed
        if indirect_bank_feed is not None:
            self.indirect_bank_feed = indirect_bank_feed
        if file_upload is not None:
            self.file_upload = file_upload
        if manual is not None:
            self.manual = manual
        if direct_bank_feed_pos is not None:
            self.direct_bank_feed_pos = direct_bank_feed_pos
        if indirect_bank_feed_pos is not None:
            self.indirect_bank_feed_pos = indirect_bank_feed_pos
        if file_upload_pos is not None:
            self.file_upload_pos = file_upload_pos
        if manual_pos is not None:
            self.manual_pos = manual_pos
        if direct_bank_feed_neg is not None:
            self.direct_bank_feed_neg = direct_bank_feed_neg
        if indirect_bank_feed_neg is not None:
            self.indirect_bank_feed_neg = indirect_bank_feed_neg
        if file_upload_neg is not None:
            self.file_upload_neg = file_upload_neg
        if manual_neg is not None:
            self.manual_neg = manual_neg
        if other_pos is not None:
            self.other_pos = other_pos
        if other_neg is not None:
            self.other_neg = other_neg
        if other is not None:
            self.other = other

    @property
    def direct_bank_feed(self):
        """Gets the direct_bank_feed of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was a direct bank feed in to Xero.   This gives an indication on the certainty of correctness of the data.  # noqa: E501

        :return: The direct_bank_feed of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._direct_bank_feed

    @direct_bank_feed.setter
    def direct_bank_feed(self, direct_bank_feed):
        """Sets the direct_bank_feed of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was a direct bank feed in to Xero.   This gives an indication on the certainty of correctness of the data.  # noqa: E501

        :param direct_bank_feed: The direct_bank_feed of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._direct_bank_feed = direct_bank_feed

    @property
    def indirect_bank_feed(self):
        """Gets the indirect_bank_feed of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was a indirect bank feed to Xero (usually via Yodlee).   This gives an indication on the certainty of correctness of the data.  # noqa: E501

        :return: The indirect_bank_feed of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._indirect_bank_feed

    @indirect_bank_feed.setter
    def indirect_bank_feed(self, indirect_bank_feed):
        """Sets the indirect_bank_feed of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was a indirect bank feed to Xero (usually via Yodlee).   This gives an indication on the certainty of correctness of the data.  # noqa: E501

        :param indirect_bank_feed: The indirect_bank_feed of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._indirect_bank_feed = indirect_bank_feed

    @property
    def file_upload(self):
        """Gets the file_upload of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was a CSV file upload in to Xero.   This gives an indication on the certainty of correctness of the data.  # noqa: E501

        :return: The file_upload of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._file_upload

    @file_upload.setter
    def file_upload(self, file_upload):
        """Sets the file_upload of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was a CSV file upload in to Xero.   This gives an indication on the certainty of correctness of the data.  # noqa: E501

        :param file_upload: The file_upload of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._file_upload = file_upload

    @property
    def manual(self):
        """Gets the manual of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was manually keyed in to Xero.   This gives an indication on the certainty of correctness of the data.  # noqa: E501

        :return: The manual of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._manual

    @manual.setter
    def manual(self, manual):
        """Sets the manual of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was manually keyed in to Xero.   This gives an indication on the certainty of correctness of the data.  # noqa: E501

        :param manual: The manual of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._manual = manual

    @property
    def direct_bank_feed_pos(self):
        """Gets the direct_bank_feed_pos of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was a direct bank feed in to Xero.  This gives an indication on the certainty of correctness of the data.  Only positive transactions are included.  # noqa: E501

        :return: The direct_bank_feed_pos of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._direct_bank_feed_pos

    @direct_bank_feed_pos.setter
    def direct_bank_feed_pos(self, direct_bank_feed_pos):
        """Sets the direct_bank_feed_pos of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was a direct bank feed in to Xero.  This gives an indication on the certainty of correctness of the data.  Only positive transactions are included.  # noqa: E501

        :param direct_bank_feed_pos: The direct_bank_feed_pos of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._direct_bank_feed_pos = direct_bank_feed_pos

    @property
    def indirect_bank_feed_pos(self):
        """Gets the indirect_bank_feed_pos of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was a indirect bank feed to Xero (usually via Yodlee).   This gives an indication on the certainty of correctness of the data. Only positive transactions are included.  # noqa: E501

        :return: The indirect_bank_feed_pos of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._indirect_bank_feed_pos

    @indirect_bank_feed_pos.setter
    def indirect_bank_feed_pos(self, indirect_bank_feed_pos):
        """Sets the indirect_bank_feed_pos of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was a indirect bank feed to Xero (usually via Yodlee).   This gives an indication on the certainty of correctness of the data. Only positive transactions are included.  # noqa: E501

        :param indirect_bank_feed_pos: The indirect_bank_feed_pos of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._indirect_bank_feed_pos = indirect_bank_feed_pos

    @property
    def file_upload_pos(self):
        """Gets the file_upload_pos of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was a CSV file upload in to Xero.   This gives an indication on the certainty of correctness of the data. Only positive transactions are included.  # noqa: E501

        :return: The file_upload_pos of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._file_upload_pos

    @file_upload_pos.setter
    def file_upload_pos(self, file_upload_pos):
        """Sets the file_upload_pos of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was a CSV file upload in to Xero.   This gives an indication on the certainty of correctness of the data. Only positive transactions are included.  # noqa: E501

        :param file_upload_pos: The file_upload_pos of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._file_upload_pos = file_upload_pos

    @property
    def manual_pos(self):
        """Gets the manual_pos of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was manually keyed in to Xero.   This gives an indication on the certainty of correctness of the data. Only positive transactions are included.  # noqa: E501

        :return: The manual_pos of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._manual_pos

    @manual_pos.setter
    def manual_pos(self, manual_pos):
        """Sets the manual_pos of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was manually keyed in to Xero.   This gives an indication on the certainty of correctness of the data. Only positive transactions are included.  # noqa: E501

        :param manual_pos: The manual_pos of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._manual_pos = manual_pos

    @property
    def direct_bank_feed_neg(self):
        """Gets the direct_bank_feed_neg of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was a direct bank feed in to Xero.   This gives an indication on the certainty of correctness of the data.  Only negative transactions are included.  # noqa: E501

        :return: The direct_bank_feed_neg of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._direct_bank_feed_neg

    @direct_bank_feed_neg.setter
    def direct_bank_feed_neg(self, direct_bank_feed_neg):
        """Sets the direct_bank_feed_neg of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was a direct bank feed in to Xero.   This gives an indication on the certainty of correctness of the data.  Only negative transactions are included.  # noqa: E501

        :param direct_bank_feed_neg: The direct_bank_feed_neg of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._direct_bank_feed_neg = direct_bank_feed_neg

    @property
    def indirect_bank_feed_neg(self):
        """Gets the indirect_bank_feed_neg of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was a indirect bank feed to Xero (usually via Yodlee).   This gives an indication on the certainty of correctness of the data.  Only negative transactions are included.  # noqa: E501

        :return: The indirect_bank_feed_neg of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._indirect_bank_feed_neg

    @indirect_bank_feed_neg.setter
    def indirect_bank_feed_neg(self, indirect_bank_feed_neg):
        """Sets the indirect_bank_feed_neg of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was a indirect bank feed to Xero (usually via Yodlee).   This gives an indication on the certainty of correctness of the data.  Only negative transactions are included.  # noqa: E501

        :param indirect_bank_feed_neg: The indirect_bank_feed_neg of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._indirect_bank_feed_neg = indirect_bank_feed_neg

    @property
    def file_upload_neg(self):
        """Gets the file_upload_neg of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was a CSV file upload in to Xero.   This gives an indication on the certainty of correctness of the data.  Only negative transactions are included.  # noqa: E501

        :return: The file_upload_neg of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._file_upload_neg

    @file_upload_neg.setter
    def file_upload_neg(self, file_upload_neg):
        """Sets the file_upload_neg of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was a CSV file upload in to Xero.   This gives an indication on the certainty of correctness of the data.  Only negative transactions are included.  # noqa: E501

        :param file_upload_neg: The file_upload_neg of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._file_upload_neg = file_upload_neg

    @property
    def manual_neg(self):
        """Gets the manual_neg of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was manually keyed in to Xero.   This gives an indication on the certainty of correctness of the data.  Only negative transactions are included.  # noqa: E501

        :return: The manual_neg of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._manual_neg

    @manual_neg.setter
    def manual_neg(self, manual_neg):
        """Sets the manual_neg of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was manually keyed in to Xero.   This gives an indication on the certainty of correctness of the data.  Only negative transactions are included.  # noqa: E501

        :param manual_neg: The manual_neg of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._manual_neg = manual_neg

    @property
    def other_pos(self):
        """Gets the other_pos of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was any other category.   This gives an indication on the certainty of correctness of the data.  Only positive transactions are included.  # noqa: E501

        :return: The other_pos of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._other_pos

    @other_pos.setter
    def other_pos(self, other_pos):
        """Sets the other_pos of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was any other category.   This gives an indication on the certainty of correctness of the data.  Only positive transactions are included.  # noqa: E501

        :param other_pos: The other_pos of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._other_pos = other_pos

    @property
    def other_neg(self):
        """Gets the other_neg of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was any other category.   This gives an indication on the certainty of correctness of the data.  Only negative transactions are included.  # noqa: E501

        :return: The other_neg of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._other_neg

    @other_neg.setter
    def other_neg(self, other_neg):
        """Sets the other_neg of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was any other category.   This gives an indication on the certainty of correctness of the data.  Only negative transactions are included.  # noqa: E501

        :param other_neg: The other_neg of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._other_neg = other_neg

    @property
    def other(self):
        """Gets the other of this DataSourceResponse.  # noqa: E501

        Sum of the amounts of all statement lines where the source of the data was any other category.   This gives an indication on the certainty of correctness of the data.  # noqa: E501

        :return: The other of this DataSourceResponse.  # noqa: E501
        :rtype: float
        """
        return self._other

    @other.setter
    def other(self, other):
        """Sets the other of this DataSourceResponse.

        Sum of the amounts of all statement lines where the source of the data was any other category.   This gives an indication on the certainty of correctness of the data.  # noqa: E501

        :param other: The other of this DataSourceResponse.  # noqa: E501
        :type: float
        """

        self._other = other
