/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./node/playwright-wrapper/index.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./node/playwright-wrapper/browser-control.ts":
/*!****************************************************!*\
  !*** ./node/playwright-wrapper/browser-control.ts ***!
  \****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setViewportSize = exports.setTimeout = exports.takeScreenshot = exports.goForward = exports.goBack = exports.goTo = void 0;
var playwirght_invoke_1 = __webpack_require__(/*! ./playwirght-invoke */ "./node/playwright-wrapper/playwirght-invoke.ts");
var response_util_1 = __webpack_require__(/*! ./response-util */ "./node/playwright-wrapper/response-util.ts");
function goTo(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var url;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    url = call.request.getUrl();
                    return [4 /*yield*/, playwirght_invoke_1.invokeOnPage(page, callback, 'goto', url)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog("Succesfully opened URL " + url));
                    return [2 /*return*/];
            }
        });
    });
}
exports.goTo = goTo;
function goBack(callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_invoke_1.invokeOnPage(page, callback, 'goBack')];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Did Go Back'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.goBack = goBack;
function goForward(callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_invoke_1.invokeOnPage(page, callback, 'goForward')];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Did Go Forward'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.goForward = goForward;
function takeScreenshot(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var path;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    path = call.request.getPath() + '.png';
                    return [4 /*yield*/, playwirght_invoke_1.invokeOnPage(page, callback, 'screenshot', { path: path })];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.stringResponse(path));
                    return [2 /*return*/];
            }
        });
    });
}
exports.takeScreenshot = takeScreenshot;
function setTimeout(call, callback, context) {
    playwirght_invoke_1.exists(context, callback, 'Tried to set timeout, no open browser');
    var timeout = call.request.getTimeout();
    context.setDefaultTimeout(timeout);
    callback(null, response_util_1.emptyWithLog("Set timeout to: " + timeout));
}
exports.setTimeout = setTimeout;
function setViewportSize(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var size;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    size = { width: call.request.getWidth(), height: call.request.getHeight() };
                    return [4 /*yield*/, playwirght_invoke_1.invokeOnPage(page, callback, 'setViewportSize', size)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog("Set viewport size to: " + size));
                    return [2 /*return*/];
            }
        });
    });
}
exports.setViewportSize = setViewportSize;


/***/ }),

/***/ "./node/playwright-wrapper/evaluation.ts":
/*!***********************************************!*\
  !*** ./node/playwright-wrapper/evaluation.ts ***!
  \***********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.httpRequest = exports.highlightElements = exports.addStyleTag = exports.waitForElementState = exports.getPageState = exports.executeJavascriptOnPage = exports.getElement = void 0;
var uuid_1 = __webpack_require__(/*! uuid */ "./node_modules/uuid/dist/esm-node/index.js");
var playwirght_invoke_1 = __webpack_require__(/*! ./playwirght-invoke */ "./node/playwright-wrapper/playwirght-invoke.ts");
var response_util_1 = __webpack_require__(/*! ./response-util */ "./node/playwright-wrapper/response-util.ts");
/** Resolve an elementHandle, create global UUID for it, and store the reference
 * in global state. Enables using special selector syntax `element=<uuid>` in
 * RF keywords.
 */
function getElement(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var handle, id;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_invoke_1.waitUntilElementExists(state, callback, call.request.getSelector())];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, '$', call.request.getSelector())];
                case 2:
                    handle = _a.sent();
                    id = uuid_1.v4();
                    state.addElement(id, handle);
                    callback(null, response_util_1.stringResponse(id));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getElement = getElement;
function executeJavascriptOnPage(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_invoke_1.invokeOnPage(page, callback, 'evaluate', call.request.getScript())];
                case 1:
                    result = _a.sent();
                    callback(null, response_util_1.jsResponse(result));
                    return [2 /*return*/];
            }
        });
    });
}
exports.executeJavascriptOnPage = executeJavascriptOnPage;
function getPageState(callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_invoke_1.invokeOnPage(page, callback, 'evaluate', function () { return window.__RFBROWSER__; })];
                case 1:
                    result = _a.sent();
                    callback(null, response_util_1.jsResponse(result));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getPageState = getPageState;
function waitForElementState(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, options;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    options = JSON.parse(call.request.getOptions());
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, 'waitForSelector', selector, options)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Wait for Element with selector: ' + selector));
                    return [2 /*return*/];
            }
        });
    });
}
exports.waitForElementState = waitForElementState;
function addStyleTag(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var content;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    content = call.request.getContent();
                    return [4 /*yield*/, playwirght_invoke_1.invokeOnPage(page, callback, 'addStyleTag', { content: content })];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('added Style: ' + content));
                    return [2 /*return*/];
            }
        });
    });
}
exports.addStyleTag = addStyleTag;
function highlightElements(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, duration, highlighter;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    duration = call.request.getDuration();
                    highlighter = function (elements, duration) {
                        elements.forEach(function (e) {
                            var d = document.createElement('div');
                            d.appendChild(document.createTextNode(''));
                            d.style.position = 'fixed';
                            var rect = e.getBoundingClientRect();
                            d.style.top = '' + rect.top + 'px';
                            d.style.left = '' + rect.left + 'px';
                            d.style.width = '' + rect.width + 'px';
                            d.style.height = '' + rect.height + 'px';
                            d.style.border = '1px solid red';
                            document.body.appendChild(d);
                            setTimeout(function () {
                                d.remove();
                            }, duration);
                        });
                    };
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, '$$eval', selector, highlighter, duration)];
                case 1:
                    _a.sent();
                    return [2 /*return*/];
            }
        });
    });
}
exports.highlightElements = highlightElements;
function httpRequest(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var opts, response, e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    opts = {
                        method: call.request.getMethod(),
                        url: call.request.getUrl(),
                        headers: JSON.parse(call.request.getHeaders()),
                    };
                    if (opts.method != 'GET') {
                        opts.body = call.request.getBody();
                    }
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, (page === null || page === void 0 ? void 0 : page.evaluate(function (_a) {
                            var url = _a.url, method = _a.method, body = _a.body, headers = _a.headers;
                            return fetch(url, { method: method, body: body, headers: headers }).then(function (data) {
                                return data.text().then(function (body) {
                                    var headers = {};
                                    data.headers.forEach(function (value, name) { return (headers[name] = value); });
                                    return {
                                        status: data.status,
                                        body: body,
                                        headers: JSON.stringify(headers),
                                        type: data.type,
                                        statusText: data.statusText,
                                        url: data.url,
                                        ok: data.ok,
                                        redirected: data.redirected,
                                    };
                                });
                            });
                        }, opts))];
                case 2:
                    response = _a.sent();
                    callback(null, response_util_1.stringResponse(JSON.stringify(response)));
                    return [3 /*break*/, 4];
                case 3:
                    e_1 = _a.sent();
                    callback(e_1, null);
                    return [3 /*break*/, 4];
                case 4: return [2 /*return*/];
            }
        });
    });
}
exports.httpRequest = httpRequest;


/***/ }),

/***/ "./node/playwright-wrapper/generated/playwright_grpc_pb.js":
/*!*****************************************************************!*\
  !*** ./node/playwright-wrapper/generated/playwright_grpc_pb.js ***!
  \*****************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";
// GENERATED CODE -- DO NOT EDIT!


var grpc = __webpack_require__(/*! grpc */ "grpc");
var playwright_pb = __webpack_require__(/*! ./playwright_pb.js */ "./node/playwright-wrapper/generated/playwright_pb.js");

function serialize_Request_Browser(arg) {
  if (!(arg instanceof playwright_pb.Request.Browser)) {
    throw new Error('Expected argument of type Request.Browser');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_Browser(buffer_arg) {
  return playwright_pb.Request.Browser.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_ClearText(arg) {
  if (!(arg instanceof playwright_pb.Request.ClearText)) {
    throw new Error('Expected argument of type Request.ClearText');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_ClearText(buffer_arg) {
  return playwright_pb.Request.ClearText.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_Context(arg) {
  if (!(arg instanceof playwright_pb.Request.Context)) {
    throw new Error('Expected argument of type Request.Context');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_Context(buffer_arg) {
  return playwright_pb.Request.Context.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_ElementProperty(arg) {
  if (!(arg instanceof playwright_pb.Request.ElementProperty)) {
    throw new Error('Expected argument of type Request.ElementProperty');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_ElementProperty(buffer_arg) {
  return playwright_pb.Request.ElementProperty.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_ElementSelector(arg) {
  if (!(arg instanceof playwright_pb.Request.ElementSelector)) {
    throw new Error('Expected argument of type Request.ElementSelector');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_ElementSelector(buffer_arg) {
  return playwright_pb.Request.ElementSelector.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_ElementSelectorWithDuration(arg) {
  if (!(arg instanceof playwright_pb.Request.ElementSelectorWithDuration)) {
    throw new Error('Expected argument of type Request.ElementSelectorWithDuration');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_ElementSelectorWithDuration(buffer_arg) {
  return playwright_pb.Request.ElementSelectorWithDuration.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_ElementSelectorWithOptions(arg) {
  if (!(arg instanceof playwright_pb.Request.ElementSelectorWithOptions)) {
    throw new Error('Expected argument of type Request.ElementSelectorWithOptions');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_ElementSelectorWithOptions(buffer_arg) {
  return playwright_pb.Request.ElementSelectorWithOptions.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_Empty(arg) {
  if (!(arg instanceof playwright_pb.Request.Empty)) {
    throw new Error('Expected argument of type Request.Empty');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_Empty(buffer_arg) {
  return playwright_pb.Request.Empty.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_FillText(arg) {
  if (!(arg instanceof playwright_pb.Request.FillText)) {
    throw new Error('Expected argument of type Request.FillText');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_FillText(buffer_arg) {
  return playwright_pb.Request.FillText.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_HttpRequest(arg) {
  if (!(arg instanceof playwright_pb.Request.HttpRequest)) {
    throw new Error('Expected argument of type Request.HttpRequest');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_HttpRequest(buffer_arg) {
  return playwright_pb.Request.HttpRequest.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_Index(arg) {
  if (!(arg instanceof playwright_pb.Request.Index)) {
    throw new Error('Expected argument of type Request.Index');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_Index(buffer_arg) {
  return playwright_pb.Request.Index.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_JavascriptCode(arg) {
  if (!(arg instanceof playwright_pb.Request.JavascriptCode)) {
    throw new Error('Expected argument of type Request.JavascriptCode');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_JavascriptCode(buffer_arg) {
  return playwright_pb.Request.JavascriptCode.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_PressKeys(arg) {
  if (!(arg instanceof playwright_pb.Request.PressKeys)) {
    throw new Error('Expected argument of type Request.PressKeys');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_PressKeys(buffer_arg) {
  return playwright_pb.Request.PressKeys.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_ScreenshotPath(arg) {
  if (!(arg instanceof playwright_pb.Request.ScreenshotPath)) {
    throw new Error('Expected argument of type Request.ScreenshotPath');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_ScreenshotPath(buffer_arg) {
  return playwright_pb.Request.ScreenshotPath.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_SelectElementSelector(arg) {
  if (!(arg instanceof playwright_pb.Request.SelectElementSelector)) {
    throw new Error('Expected argument of type Request.SelectElementSelector');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_SelectElementSelector(buffer_arg) {
  return playwright_pb.Request.SelectElementSelector.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_StyleTag(arg) {
  if (!(arg instanceof playwright_pb.Request.StyleTag)) {
    throw new Error('Expected argument of type Request.StyleTag');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_StyleTag(buffer_arg) {
  return playwright_pb.Request.StyleTag.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_TextInput(arg) {
  if (!(arg instanceof playwright_pb.Request.TextInput)) {
    throw new Error('Expected argument of type Request.TextInput');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_TextInput(buffer_arg) {
  return playwright_pb.Request.TextInput.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_Timeout(arg) {
  if (!(arg instanceof playwright_pb.Request.Timeout)) {
    throw new Error('Expected argument of type Request.Timeout');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_Timeout(buffer_arg) {
  return playwright_pb.Request.Timeout.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_TypeText(arg) {
  if (!(arg instanceof playwright_pb.Request.TypeText)) {
    throw new Error('Expected argument of type Request.TypeText');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_TypeText(buffer_arg) {
  return playwright_pb.Request.TypeText.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_Url(arg) {
  if (!(arg instanceof playwright_pb.Request.Url)) {
    throw new Error('Expected argument of type Request.Url');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_Url(buffer_arg) {
  return playwright_pb.Request.Url.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Request_Viewport(arg) {
  if (!(arg instanceof playwright_pb.Request.Viewport)) {
    throw new Error('Expected argument of type Request.Viewport');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Request_Viewport(buffer_arg) {
  return playwright_pb.Request.Viewport.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Response_Bool(arg) {
  if (!(arg instanceof playwright_pb.Response.Bool)) {
    throw new Error('Expected argument of type Response.Bool');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Response_Bool(buffer_arg) {
  return playwright_pb.Response.Bool.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Response_Empty(arg) {
  if (!(arg instanceof playwright_pb.Response.Empty)) {
    throw new Error('Expected argument of type Response.Empty');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Response_Empty(buffer_arg) {
  return playwright_pb.Response.Empty.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Response_Int(arg) {
  if (!(arg instanceof playwright_pb.Response.Int)) {
    throw new Error('Expected argument of type Response.Int');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Response_Int(buffer_arg) {
  return playwright_pb.Response.Int.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Response_JavascriptExecutionResult(arg) {
  if (!(arg instanceof playwright_pb.Response.JavascriptExecutionResult)) {
    throw new Error('Expected argument of type Response.JavascriptExecutionResult');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Response_JavascriptExecutionResult(buffer_arg) {
  return playwright_pb.Response.JavascriptExecutionResult.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Response_Select(arg) {
  if (!(arg instanceof playwright_pb.Response.Select)) {
    throw new Error('Expected argument of type Response.Select');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Response_Select(buffer_arg) {
  return playwright_pb.Response.Select.deserializeBinary(new Uint8Array(buffer_arg));
}

function serialize_Response_String(arg) {
  if (!(arg instanceof playwright_pb.Response.String)) {
    throw new Error('Expected argument of type Response.String');
  }
  return Buffer.from(arg.serializeBinary());
}

function deserialize_Response_String(buffer_arg) {
  return playwright_pb.Response.String.deserializeBinary(new Uint8Array(buffer_arg));
}


var PlaywrightService = exports.PlaywrightService = {
  takeScreenshot: {
    path: '/Playwright/TakeScreenshot',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ScreenshotPath,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_ScreenshotPath,
    requestDeserialize: deserialize_Request_ScreenshotPath,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // Opens the url in currently open Playwright page 
goTo: {
    path: '/Playwright/GoTo',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Url,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Url,
    requestDeserialize: deserialize_Request_Url,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Navigate to the next page in history 
goBack: {
    path: '/Playwright/GoBack',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Url,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Url,
    requestDeserialize: deserialize_Request_Url,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Navigate to the previous page in history. 
goForward: {
    path: '/Playwright/GoForward',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Url,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Url,
    requestDeserialize: deserialize_Request_Url,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Gets title of currently open Playwright page 
getTitle: {
    path: '/Playwright/GetTitle',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // Returns the count of elements found with selector 
getElementCount: {
    path: '/Playwright/GetElementCount',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Int,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Int,
    responseDeserialize: deserialize_Response_Int,
  },
  // Wraps playwrights page.fill to input text into input specified with selector 
inputText: {
    path: '/Playwright/InputText',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.TextInput,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_TextInput,
    requestDeserialize: deserialize_Request_TextInput,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Wraps playwrights page.type to type text into input specified with selector 
typeText: {
    path: '/Playwright/TypeText',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.TypeText,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_TypeText,
    requestDeserialize: deserialize_Request_TypeText,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Wraps playwrights page.fill to fill text of input specified with selector 
fillText: {
    path: '/Playwright/FillText',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.FillText,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_FillText,
    requestDeserialize: deserialize_Request_FillText,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Wraps playwrights page.fill with empty text to clear input specified with selector 
clearText: {
    path: '/Playwright/ClearText',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ClearText,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ClearText,
    requestDeserialize: deserialize_Request_ClearText,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Gets the DOM property 'property' of selector specified element 
getDomProperty: {
    path: '/Playwright/GetDomProperty',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementProperty,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_ElementProperty,
    requestDeserialize: deserialize_Request_ElementProperty,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // Gets the boolean DOM property 'property' of selector specified element 
getBoolProperty: {
    path: '/Playwright/GetBoolProperty',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementProperty,
    responseType: playwright_pb.Response.Bool,
    requestSerialize: serialize_Request_ElementProperty,
    requestDeserialize: deserialize_Request_ElementProperty,
    responseSerialize: serialize_Response_Bool,
    responseDeserialize: deserialize_Response_Bool,
  },
  // Wraps playwrights page.textContent, returns textcontent of element by selector 
getViewportSize: {
    path: '/Playwright/GetViewportSize',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // *Returns current playwright page url
getUrl: {
    path: '/Playwright/GetUrl',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // Clicks element specified by selector 
click: {
    path: '/Playwright/Click',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Inputs a list of keypresses to element specified by selector 
press: {
    path: '/Playwright/Press',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.PressKeys,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_PressKeys,
    requestDeserialize: deserialize_Request_PressKeys,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Gets the Select element specified by selector and returns the contents 
getSelectContent: {
    path: '/Playwright/GetSelectContent',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Select,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Select,
    responseDeserialize: deserialize_Response_Select,
  },
  // Selects option matching matcher in Select element matching selector 
selectOption: {
    path: '/Playwright/SelectOption',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.SelectElementSelector,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_SelectElementSelector,
    requestDeserialize: deserialize_Request_SelectElementSelector,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Deselects options in Select element matching selector 
deselectOption: {
    path: '/Playwright/DeselectOption',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Checks checkbox specified by selector 
checkCheckbox: {
    path: '/Playwright/CheckCheckbox',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Unchecks checkbox specified by selector 
uncheckCheckbox: {
    path: '/Playwright/UncheckCheckbox',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Health check endpoint for the service 
health: {
    path: '/Playwright/Health',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // Returns a reference to a Playwirght element handle.
getElement: {
    path: '/Playwright/GetElement',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // Set's  playwright timeout 
setTimeout: {
    path: '/Playwright/SetTimeout',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Timeout,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Timeout,
    requestDeserialize: deserialize_Request_Timeout,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Adds a <style> to head of site. 
addStyleTag: {
    path: '/Playwright/AddStyleTag',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.StyleTag,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_StyleTag,
    requestDeserialize: deserialize_Request_StyleTag,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Highlights elements matching selector for duration 
highlightElements: {
    path: '/Playwright/HighlightElements',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelectorWithDuration,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelectorWithDuration,
    requestDeserialize: deserialize_Request_ElementSelectorWithDuration,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Clicks element specified by selector and options 
clickWithOptions: {
    path: '/Playwright/ClickWithOptions',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelectorWithOptions,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelectorWithOptions,
    requestDeserialize: deserialize_Request_ElementSelectorWithOptions,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Focuses element specified by selector 
focus: {
    path: '/Playwright/Focus',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Waits for element be in a specific state
waitForElementsState: {
    path: '/Playwright/WaitForElementsState',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelectorWithOptions,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_ElementSelectorWithOptions,
    requestDeserialize: deserialize_Request_ElementSelectorWithOptions,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Executes javascript on the active page 
executeJavascriptOnPage: {
    path: '/Playwright/ExecuteJavascriptOnPage',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.JavascriptCode,
    responseType: playwright_pb.Response.JavascriptExecutionResult,
    requestSerialize: serialize_Request_JavascriptCode,
    requestDeserialize: deserialize_Request_JavascriptCode,
    responseSerialize: serialize_Response_JavascriptExecutionResult,
    responseDeserialize: deserialize_Response_JavascriptExecutionResult,
  },
  // Get Page State JSON 
getPageState: {
    path: '/Playwright/GetPageState',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.JavascriptExecutionResult,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_JavascriptExecutionResult,
    responseDeserialize: deserialize_Response_JavascriptExecutionResult,
  },
  setViewportSize: {
    path: '/Playwright/SetViewportSize',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Viewport,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Viewport,
    requestDeserialize: deserialize_Request_Viewport,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  // Gets an elements computed style 
getStyle: {
    path: '/Playwright/GetStyle',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.ElementSelector,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_ElementSelector,
    requestDeserialize: deserialize_Request_ElementSelector,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // Makes a `fetch` request in the browser 
httpRequest: {
    path: '/Playwright/HttpRequest',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.HttpRequest,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_HttpRequest,
    requestDeserialize: deserialize_Request_HttpRequest,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
  // Playwright State handling keywords 
autoActivatePages: {
    path: '/Playwright/AutoActivatePages',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  switchPage: {
    path: '/Playwright/SwitchPage',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Index,
    responseType: playwright_pb.Response.Int,
    requestSerialize: serialize_Request_Index,
    requestDeserialize: deserialize_Request_Index,
    responseSerialize: serialize_Response_Int,
    responseDeserialize: deserialize_Response_Int,
  },
  switchContext: {
    path: '/Playwright/SwitchContext',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Index,
    responseType: playwright_pb.Response.Int,
    requestSerialize: serialize_Request_Index,
    requestDeserialize: deserialize_Request_Index,
    responseSerialize: serialize_Response_Int,
    responseDeserialize: deserialize_Response_Int,
  },
  switchBrowser: {
    path: '/Playwright/SwitchBrowser',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Index,
    responseType: playwright_pb.Response.Int,
    requestSerialize: serialize_Request_Index,
    requestDeserialize: deserialize_Request_Index,
    responseSerialize: serialize_Response_Int,
    responseDeserialize: deserialize_Response_Int,
  },
  newPage: {
    path: '/Playwright/NewPage',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Url,
    responseType: playwright_pb.Response.Int,
    requestSerialize: serialize_Request_Url,
    requestDeserialize: deserialize_Request_Url,
    responseSerialize: serialize_Response_Int,
    responseDeserialize: deserialize_Response_Int,
  },
  newContext: {
    path: '/Playwright/NewContext',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Context,
    responseType: playwright_pb.Response.Int,
    requestSerialize: serialize_Request_Context,
    requestDeserialize: deserialize_Request_Context,
    responseSerialize: serialize_Response_Int,
    responseDeserialize: deserialize_Response_Int,
  },
  newBrowser: {
    path: '/Playwright/NewBrowser',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Browser,
    responseType: playwright_pb.Response.Int,
    requestSerialize: serialize_Request_Browser,
    requestDeserialize: deserialize_Request_Browser,
    responseSerialize: serialize_Response_Int,
    responseDeserialize: deserialize_Response_Int,
  },
  closeBrowser: {
    path: '/Playwright/CloseBrowser',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  closeAllBrowsers: {
    path: '/Playwright/CloseAllBrowsers',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  closeContext: {
    path: '/Playwright/CloseContext',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  closePage: {
    path: '/Playwright/ClosePage',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.Empty,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_Empty,
    responseDeserialize: deserialize_Response_Empty,
  },
  getBrowserCatalog: {
    path: '/Playwright/GetBrowserCatalog',
    requestStream: false,
    responseStream: false,
    requestType: playwright_pb.Request.Empty,
    responseType: playwright_pb.Response.String,
    requestSerialize: serialize_Request_Empty,
    requestDeserialize: deserialize_Request_Empty,
    responseSerialize: serialize_Response_String,
    responseDeserialize: deserialize_Response_String,
  },
};

exports.PlaywrightClient = grpc.makeGenericClientConstructor(PlaywrightService);


/***/ }),

/***/ "./node/playwright-wrapper/generated/playwright_pb.js":
/*!************************************************************!*\
  !*** ./node/playwright-wrapper/generated/playwright_pb.js ***!
  \************************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

// source: playwright.proto
/**
 * @fileoverview
 * @enhanceable
 * @suppress {messageConventions} JS Compiler reports an error if a variable or
 *     field starts with 'MSG_' and isn't a translatable message.
 * @public
 */
// GENERATED CODE -- DO NOT EDIT!

var jspb = __webpack_require__(/*! google-protobuf */ "./node_modules/google-protobuf/google-protobuf.js");
var goog = jspb;
var global = Function('return this')();

goog.exportSymbol('proto.Request', null, global);
goog.exportSymbol('proto.Request.Browser', null, global);
goog.exportSymbol('proto.Request.ClearText', null, global);
goog.exportSymbol('proto.Request.Context', null, global);
goog.exportSymbol('proto.Request.ElementProperty', null, global);
goog.exportSymbol('proto.Request.ElementSelector', null, global);
goog.exportSymbol('proto.Request.ElementSelectorWithDuration', null, global);
goog.exportSymbol('proto.Request.ElementSelectorWithOptions', null, global);
goog.exportSymbol('proto.Request.Empty', null, global);
goog.exportSymbol('proto.Request.FillText', null, global);
goog.exportSymbol('proto.Request.HttpRequest', null, global);
goog.exportSymbol('proto.Request.Index', null, global);
goog.exportSymbol('proto.Request.JavascriptCode', null, global);
goog.exportSymbol('proto.Request.PlaywrightObject', null, global);
goog.exportSymbol('proto.Request.PressKeys', null, global);
goog.exportSymbol('proto.Request.ScreenshotPath', null, global);
goog.exportSymbol('proto.Request.SelectElementSelector', null, global);
goog.exportSymbol('proto.Request.StyleTag', null, global);
goog.exportSymbol('proto.Request.TextInput', null, global);
goog.exportSymbol('proto.Request.Timeout', null, global);
goog.exportSymbol('proto.Request.TypeText', null, global);
goog.exportSymbol('proto.Request.Url', null, global);
goog.exportSymbol('proto.Request.Viewport', null, global);
goog.exportSymbol('proto.Response', null, global);
goog.exportSymbol('proto.Response.Bool', null, global);
goog.exportSymbol('proto.Response.Empty', null, global);
goog.exportSymbol('proto.Response.Int', null, global);
goog.exportSymbol('proto.Response.JavascriptExecutionResult', null, global);
goog.exportSymbol('proto.Response.Select', null, global);
goog.exportSymbol('proto.Response.String', null, global);
goog.exportSymbol('proto.Types', null, global);
goog.exportSymbol('proto.Types.RawJson', null, global);
goog.exportSymbol('proto.Types.SelectEntry', null, global);
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.displayName = 'proto.Request';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.Empty = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.Empty, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.Empty.displayName = 'proto.Request.Empty';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.ScreenshotPath = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.ScreenshotPath, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.ScreenshotPath.displayName = 'proto.Request.ScreenshotPath';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.Browser = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.Browser, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.Browser.displayName = 'proto.Request.Browser';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.Context = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.Context, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.Context.displayName = 'proto.Request.Context';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.Url = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.Url, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.Url.displayName = 'proto.Request.Url';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.TextInput = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.TextInput, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.TextInput.displayName = 'proto.Request.TextInput';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.ElementProperty = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.ElementProperty, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.ElementProperty.displayName = 'proto.Request.ElementProperty';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.TypeText = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.TypeText, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.TypeText.displayName = 'proto.Request.TypeText';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.FillText = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.FillText, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.FillText.displayName = 'proto.Request.FillText';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.ClearText = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.ClearText, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.ClearText.displayName = 'proto.Request.ClearText';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.PressKeys = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.Request.PressKeys.repeatedFields_, null);
};
goog.inherits(proto.Request.PressKeys, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.PressKeys.displayName = 'proto.Request.PressKeys';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.ElementSelector = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.ElementSelector, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.ElementSelector.displayName = 'proto.Request.ElementSelector';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.Timeout = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.Timeout, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.Timeout.displayName = 'proto.Request.Timeout';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.Index = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.Index, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.Index.displayName = 'proto.Request.Index';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.StyleTag = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.StyleTag, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.StyleTag.displayName = 'proto.Request.StyleTag';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.ElementSelectorWithOptions = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.ElementSelectorWithOptions, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.ElementSelectorWithOptions.displayName = 'proto.Request.ElementSelectorWithOptions';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.ElementSelectorWithDuration = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.ElementSelectorWithDuration, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.ElementSelectorWithDuration.displayName = 'proto.Request.ElementSelectorWithDuration';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.SelectElementSelector = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.SelectElementSelector, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.SelectElementSelector.displayName = 'proto.Request.SelectElementSelector';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.JavascriptCode = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.JavascriptCode, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.JavascriptCode.displayName = 'proto.Request.JavascriptCode';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.PlaywrightObject = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.PlaywrightObject, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.PlaywrightObject.displayName = 'proto.Request.PlaywrightObject';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.Viewport = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.Viewport, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.Viewport.displayName = 'proto.Request.Viewport';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Request.HttpRequest = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Request.HttpRequest, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Request.HttpRequest.displayName = 'proto.Request.HttpRequest';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Types = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Types, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Types.displayName = 'proto.Types';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Types.SelectEntry = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Types.SelectEntry, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Types.SelectEntry.displayName = 'proto.Types.SelectEntry';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Types.RawJson = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Types.RawJson, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Types.RawJson.displayName = 'proto.Types.RawJson';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Response, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.displayName = 'proto.Response';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response.Empty = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Response.Empty, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.Empty.displayName = 'proto.Response.Empty';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response.String = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Response.String, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.String.displayName = 'proto.Response.String';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response.Bool = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Response.Bool, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.Bool.displayName = 'proto.Response.Bool';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response.Int = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Response.Int, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.Int.displayName = 'proto.Response.Int';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response.Select = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, proto.Response.Select.repeatedFields_, null);
};
goog.inherits(proto.Response.Select, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.Select.displayName = 'proto.Response.Select';
}
/**
 * Generated by JsPbCodeGenerator.
 * @param {Array=} opt_data Optional initial data array, typically from a
 * server response, or constructed directly in Javascript. The array is used
 * in place and becomes part of the constructed object. It is not cloned.
 * If no data is provided, the constructed object will be empty, but still
 * valid.
 * @extends {jspb.Message}
 * @constructor
 */
proto.Response.JavascriptExecutionResult = function(opt_data) {
  jspb.Message.initialize(this, opt_data, 0, -1, null, null);
};
goog.inherits(proto.Response.JavascriptExecutionResult, jspb.Message);
if (goog.DEBUG && !COMPILED) {
  /**
   * @public
   * @override
   */
  proto.Response.JavascriptExecutionResult.displayName = 'proto.Response.JavascriptExecutionResult';
}



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request}
 */
proto.Request.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request;
  return proto.Request.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request}
 */
proto.Request.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.Empty.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.Empty.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.Empty} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Empty.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.Empty}
 */
proto.Request.Empty.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.Empty;
  return proto.Request.Empty.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.Empty} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.Empty}
 */
proto.Request.Empty.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.Empty.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.Empty.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.Empty} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Empty.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.ScreenshotPath.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.ScreenshotPath.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.ScreenshotPath} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ScreenshotPath.toObject = function(includeInstance, msg) {
  var f, obj = {
    path: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.ScreenshotPath}
 */
proto.Request.ScreenshotPath.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.ScreenshotPath;
  return proto.Request.ScreenshotPath.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.ScreenshotPath} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.ScreenshotPath}
 */
proto.Request.ScreenshotPath.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setPath(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.ScreenshotPath.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.ScreenshotPath.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.ScreenshotPath} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ScreenshotPath.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getPath();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string path = 1;
 * @return {string}
 */
proto.Request.ScreenshotPath.prototype.getPath = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ScreenshotPath} returns this
 */
proto.Request.ScreenshotPath.prototype.setPath = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.Browser.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.Browser.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.Browser} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Browser.toObject = function(includeInstance, msg) {
  var f, obj = {
    browser: jspb.Message.getFieldWithDefault(msg, 1, ""),
    headless: jspb.Message.getBooleanFieldWithDefault(msg, 2, false),
    rawoptions: jspb.Message.getFieldWithDefault(msg, 3, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.Browser}
 */
proto.Request.Browser.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.Browser;
  return proto.Request.Browser.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.Browser} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.Browser}
 */
proto.Request.Browser.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setBrowser(value);
      break;
    case 2:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setHeadless(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setRawoptions(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.Browser.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.Browser.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.Browser} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Browser.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getBrowser();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getHeadless();
  if (f) {
    writer.writeBool(
      2,
      f
    );
  }
  f = message.getRawoptions();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
};


/**
 * optional string browser = 1;
 * @return {string}
 */
proto.Request.Browser.prototype.getBrowser = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.Browser} returns this
 */
proto.Request.Browser.prototype.setBrowser = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional bool headless = 2;
 * @return {boolean}
 */
proto.Request.Browser.prototype.getHeadless = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 2, false));
};


/**
 * @param {boolean} value
 * @return {!proto.Request.Browser} returns this
 */
proto.Request.Browser.prototype.setHeadless = function(value) {
  return jspb.Message.setProto3BooleanField(this, 2, value);
};


/**
 * optional string rawOptions = 3;
 * @return {string}
 */
proto.Request.Browser.prototype.getRawoptions = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.Browser} returns this
 */
proto.Request.Browser.prototype.setRawoptions = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.Context.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.Context.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.Context} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Context.toObject = function(includeInstance, msg) {
  var f, obj = {
    hiderfbrowser: jspb.Message.getBooleanFieldWithDefault(msg, 1, false),
    rawoptions: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.Context}
 */
proto.Request.Context.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.Context;
  return proto.Request.Context.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.Context} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.Context}
 */
proto.Request.Context.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setHiderfbrowser(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setRawoptions(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.Context.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.Context.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.Context} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Context.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getHiderfbrowser();
  if (f) {
    writer.writeBool(
      1,
      f
    );
  }
  f = message.getRawoptions();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional bool hideRfBrowser = 1;
 * @return {boolean}
 */
proto.Request.Context.prototype.getHiderfbrowser = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 1, false));
};


/**
 * @param {boolean} value
 * @return {!proto.Request.Context} returns this
 */
proto.Request.Context.prototype.setHiderfbrowser = function(value) {
  return jspb.Message.setProto3BooleanField(this, 1, value);
};


/**
 * optional string rawOptions = 2;
 * @return {string}
 */
proto.Request.Context.prototype.getRawoptions = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.Context} returns this
 */
proto.Request.Context.prototype.setRawoptions = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.Url.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.Url.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.Url} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Url.toObject = function(includeInstance, msg) {
  var f, obj = {
    url: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.Url}
 */
proto.Request.Url.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.Url;
  return proto.Request.Url.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.Url} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.Url}
 */
proto.Request.Url.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setUrl(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.Url.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.Url.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.Url} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Url.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getUrl();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string url = 1;
 * @return {string}
 */
proto.Request.Url.prototype.getUrl = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.Url} returns this
 */
proto.Request.Url.prototype.setUrl = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.TextInput.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.TextInput.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.TextInput} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.TextInput.toObject = function(includeInstance, msg) {
  var f, obj = {
    input: jspb.Message.getFieldWithDefault(msg, 1, ""),
    selector: jspb.Message.getFieldWithDefault(msg, 2, ""),
    type: jspb.Message.getBooleanFieldWithDefault(msg, 3, false)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.TextInput}
 */
proto.Request.TextInput.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.TextInput;
  return proto.Request.TextInput.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.TextInput} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.TextInput}
 */
proto.Request.TextInput.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setInput(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 3:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setType(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.TextInput.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.TextInput.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.TextInput} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.TextInput.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getInput();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getType();
  if (f) {
    writer.writeBool(
      3,
      f
    );
  }
};


/**
 * optional string input = 1;
 * @return {string}
 */
proto.Request.TextInput.prototype.getInput = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.TextInput} returns this
 */
proto.Request.TextInput.prototype.setInput = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string selector = 2;
 * @return {string}
 */
proto.Request.TextInput.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.TextInput} returns this
 */
proto.Request.TextInput.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional bool type = 3;
 * @return {boolean}
 */
proto.Request.TextInput.prototype.getType = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 3, false));
};


/**
 * @param {boolean} value
 * @return {!proto.Request.TextInput} returns this
 */
proto.Request.TextInput.prototype.setType = function(value) {
  return jspb.Message.setProto3BooleanField(this, 3, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.ElementProperty.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.ElementProperty.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.ElementProperty} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementProperty.toObject = function(includeInstance, msg) {
  var f, obj = {
    property: jspb.Message.getFieldWithDefault(msg, 1, ""),
    selector: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.ElementProperty}
 */
proto.Request.ElementProperty.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.ElementProperty;
  return proto.Request.ElementProperty.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.ElementProperty} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.ElementProperty}
 */
proto.Request.ElementProperty.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setProperty(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.ElementProperty.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.ElementProperty.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.ElementProperty} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementProperty.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getProperty();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string property = 1;
 * @return {string}
 */
proto.Request.ElementProperty.prototype.getProperty = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ElementProperty} returns this
 */
proto.Request.ElementProperty.prototype.setProperty = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string selector = 2;
 * @return {string}
 */
proto.Request.ElementProperty.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ElementProperty} returns this
 */
proto.Request.ElementProperty.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.TypeText.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.TypeText.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.TypeText} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.TypeText.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, ""),
    text: jspb.Message.getFieldWithDefault(msg, 2, ""),
    delay: jspb.Message.getFieldWithDefault(msg, 3, 0),
    clear: jspb.Message.getBooleanFieldWithDefault(msg, 4, false)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.TypeText}
 */
proto.Request.TypeText.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.TypeText;
  return proto.Request.TypeText.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.TypeText} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.TypeText}
 */
proto.Request.TypeText.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setText(value);
      break;
    case 3:
      var value = /** @type {number} */ (reader.readInt32());
      msg.setDelay(value);
      break;
    case 4:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setClear(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.TypeText.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.TypeText.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.TypeText} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.TypeText.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getText();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getDelay();
  if (f !== 0) {
    writer.writeInt32(
      3,
      f
    );
  }
  f = message.getClear();
  if (f) {
    writer.writeBool(
      4,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.TypeText.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.TypeText} returns this
 */
proto.Request.TypeText.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string text = 2;
 * @return {string}
 */
proto.Request.TypeText.prototype.getText = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.TypeText} returns this
 */
proto.Request.TypeText.prototype.setText = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional int32 delay = 3;
 * @return {number}
 */
proto.Request.TypeText.prototype.getDelay = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 3, 0));
};


/**
 * @param {number} value
 * @return {!proto.Request.TypeText} returns this
 */
proto.Request.TypeText.prototype.setDelay = function(value) {
  return jspb.Message.setProto3IntField(this, 3, value);
};


/**
 * optional bool clear = 4;
 * @return {boolean}
 */
proto.Request.TypeText.prototype.getClear = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 4, false));
};


/**
 * @param {boolean} value
 * @return {!proto.Request.TypeText} returns this
 */
proto.Request.TypeText.prototype.setClear = function(value) {
  return jspb.Message.setProto3BooleanField(this, 4, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.FillText.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.FillText.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.FillText} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.FillText.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, ""),
    text: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.FillText}
 */
proto.Request.FillText.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.FillText;
  return proto.Request.FillText.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.FillText} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.FillText}
 */
proto.Request.FillText.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setText(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.FillText.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.FillText.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.FillText} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.FillText.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getText();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.FillText.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.FillText} returns this
 */
proto.Request.FillText.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string text = 2;
 * @return {string}
 */
proto.Request.FillText.prototype.getText = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.FillText} returns this
 */
proto.Request.FillText.prototype.setText = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.ClearText.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.ClearText.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.ClearText} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ClearText.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.ClearText}
 */
proto.Request.ClearText.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.ClearText;
  return proto.Request.ClearText.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.ClearText} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.ClearText}
 */
proto.Request.ClearText.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.ClearText.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.ClearText.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.ClearText} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ClearText.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.ClearText.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ClearText} returns this
 */
proto.Request.ClearText.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.Request.PressKeys.repeatedFields_ = [2];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.PressKeys.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.PressKeys.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.PressKeys} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.PressKeys.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, ""),
    keyList: (f = jspb.Message.getRepeatedField(msg, 2)) == null ? undefined : f
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.PressKeys}
 */
proto.Request.PressKeys.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.PressKeys;
  return proto.Request.PressKeys.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.PressKeys} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.PressKeys}
 */
proto.Request.PressKeys.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.addKey(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.PressKeys.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.PressKeys.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.PressKeys} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.PressKeys.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getKeyList();
  if (f.length > 0) {
    writer.writeRepeatedString(
      2,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.PressKeys.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.PressKeys} returns this
 */
proto.Request.PressKeys.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * repeated string key = 2;
 * @return {!Array<string>}
 */
proto.Request.PressKeys.prototype.getKeyList = function() {
  return /** @type {!Array<string>} */ (jspb.Message.getRepeatedField(this, 2));
};


/**
 * @param {!Array<string>} value
 * @return {!proto.Request.PressKeys} returns this
 */
proto.Request.PressKeys.prototype.setKeyList = function(value) {
  return jspb.Message.setField(this, 2, value || []);
};


/**
 * @param {string} value
 * @param {number=} opt_index
 * @return {!proto.Request.PressKeys} returns this
 */
proto.Request.PressKeys.prototype.addKey = function(value, opt_index) {
  return jspb.Message.addToRepeatedField(this, 2, value, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.Request.PressKeys} returns this
 */
proto.Request.PressKeys.prototype.clearKeyList = function() {
  return this.setKeyList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.ElementSelector.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.ElementSelector.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.ElementSelector} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementSelector.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.ElementSelector}
 */
proto.Request.ElementSelector.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.ElementSelector;
  return proto.Request.ElementSelector.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.ElementSelector} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.ElementSelector}
 */
proto.Request.ElementSelector.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.ElementSelector.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.ElementSelector.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.ElementSelector} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementSelector.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.ElementSelector.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ElementSelector} returns this
 */
proto.Request.ElementSelector.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.Timeout.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.Timeout.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.Timeout} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Timeout.toObject = function(includeInstance, msg) {
  var f, obj = {
    timeout: jspb.Message.getFloatingPointFieldWithDefault(msg, 1, 0.0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.Timeout}
 */
proto.Request.Timeout.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.Timeout;
  return proto.Request.Timeout.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.Timeout} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.Timeout}
 */
proto.Request.Timeout.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readFloat());
      msg.setTimeout(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.Timeout.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.Timeout.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.Timeout} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Timeout.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getTimeout();
  if (f !== 0.0) {
    writer.writeFloat(
      1,
      f
    );
  }
};


/**
 * optional float timeout = 1;
 * @return {number}
 */
proto.Request.Timeout.prototype.getTimeout = function() {
  return /** @type {number} */ (jspb.Message.getFloatingPointFieldWithDefault(this, 1, 0.0));
};


/**
 * @param {number} value
 * @return {!proto.Request.Timeout} returns this
 */
proto.Request.Timeout.prototype.setTimeout = function(value) {
  return jspb.Message.setProto3FloatField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.Index.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.Index.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.Index} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Index.toObject = function(includeInstance, msg) {
  var f, obj = {
    index: jspb.Message.getFieldWithDefault(msg, 1, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.Index}
 */
proto.Request.Index.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.Index;
  return proto.Request.Index.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.Index} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.Index}
 */
proto.Request.Index.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt32());
      msg.setIndex(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.Index.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.Index.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.Index} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Index.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getIndex();
  if (f !== 0) {
    writer.writeInt32(
      1,
      f
    );
  }
};


/**
 * optional int32 index = 1;
 * @return {number}
 */
proto.Request.Index.prototype.getIndex = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.Request.Index} returns this
 */
proto.Request.Index.prototype.setIndex = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.StyleTag.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.StyleTag.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.StyleTag} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.StyleTag.toObject = function(includeInstance, msg) {
  var f, obj = {
    content: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.StyleTag}
 */
proto.Request.StyleTag.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.StyleTag;
  return proto.Request.StyleTag.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.StyleTag} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.StyleTag}
 */
proto.Request.StyleTag.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setContent(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.StyleTag.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.StyleTag.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.StyleTag} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.StyleTag.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getContent();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string content = 1;
 * @return {string}
 */
proto.Request.StyleTag.prototype.getContent = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.StyleTag} returns this
 */
proto.Request.StyleTag.prototype.setContent = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.ElementSelectorWithOptions.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.ElementSelectorWithOptions.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.ElementSelectorWithOptions} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementSelectorWithOptions.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, ""),
    options: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.ElementSelectorWithOptions}
 */
proto.Request.ElementSelectorWithOptions.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.ElementSelectorWithOptions;
  return proto.Request.ElementSelectorWithOptions.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.ElementSelectorWithOptions} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.ElementSelectorWithOptions}
 */
proto.Request.ElementSelectorWithOptions.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setOptions(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.ElementSelectorWithOptions.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.ElementSelectorWithOptions.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.ElementSelectorWithOptions} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementSelectorWithOptions.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getOptions();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.ElementSelectorWithOptions.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ElementSelectorWithOptions} returns this
 */
proto.Request.ElementSelectorWithOptions.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string options = 2;
 * @return {string}
 */
proto.Request.ElementSelectorWithOptions.prototype.getOptions = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ElementSelectorWithOptions} returns this
 */
proto.Request.ElementSelectorWithOptions.prototype.setOptions = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.ElementSelectorWithDuration.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.ElementSelectorWithDuration.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.ElementSelectorWithDuration} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementSelectorWithDuration.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, ""),
    duration: jspb.Message.getFieldWithDefault(msg, 2, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.ElementSelectorWithDuration}
 */
proto.Request.ElementSelectorWithDuration.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.ElementSelectorWithDuration;
  return proto.Request.ElementSelectorWithDuration.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.ElementSelectorWithDuration} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.ElementSelectorWithDuration}
 */
proto.Request.ElementSelectorWithDuration.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 2:
      var value = /** @type {number} */ (reader.readInt32());
      msg.setDuration(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.ElementSelectorWithDuration.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.ElementSelectorWithDuration.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.ElementSelectorWithDuration} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.ElementSelectorWithDuration.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getDuration();
  if (f !== 0) {
    writer.writeInt32(
      2,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.ElementSelectorWithDuration.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.ElementSelectorWithDuration} returns this
 */
proto.Request.ElementSelectorWithDuration.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional int32 duration = 2;
 * @return {number}
 */
proto.Request.ElementSelectorWithDuration.prototype.getDuration = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.Request.ElementSelectorWithDuration} returns this
 */
proto.Request.ElementSelectorWithDuration.prototype.setDuration = function(value) {
  return jspb.Message.setProto3IntField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.SelectElementSelector.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.SelectElementSelector.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.SelectElementSelector} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.SelectElementSelector.toObject = function(includeInstance, msg) {
  var f, obj = {
    selector: jspb.Message.getFieldWithDefault(msg, 1, ""),
    matcherjson: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.SelectElementSelector}
 */
proto.Request.SelectElementSelector.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.SelectElementSelector;
  return proto.Request.SelectElementSelector.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.SelectElementSelector} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.SelectElementSelector}
 */
proto.Request.SelectElementSelector.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setSelector(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setMatcherjson(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.SelectElementSelector.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.SelectElementSelector.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.SelectElementSelector} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.SelectElementSelector.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getSelector();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getMatcherjson();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string selector = 1;
 * @return {string}
 */
proto.Request.SelectElementSelector.prototype.getSelector = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.SelectElementSelector} returns this
 */
proto.Request.SelectElementSelector.prototype.setSelector = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string matcherJson = 2;
 * @return {string}
 */
proto.Request.SelectElementSelector.prototype.getMatcherjson = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.SelectElementSelector} returns this
 */
proto.Request.SelectElementSelector.prototype.setMatcherjson = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.JavascriptCode.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.JavascriptCode.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.JavascriptCode} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.JavascriptCode.toObject = function(includeInstance, msg) {
  var f, obj = {
    script: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.JavascriptCode}
 */
proto.Request.JavascriptCode.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.JavascriptCode;
  return proto.Request.JavascriptCode.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.JavascriptCode} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.JavascriptCode}
 */
proto.Request.JavascriptCode.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setScript(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.JavascriptCode.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.JavascriptCode.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.JavascriptCode} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.JavascriptCode.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getScript();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string script = 1;
 * @return {string}
 */
proto.Request.JavascriptCode.prototype.getScript = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.JavascriptCode} returns this
 */
proto.Request.JavascriptCode.prototype.setScript = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.PlaywrightObject.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.PlaywrightObject.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.PlaywrightObject} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.PlaywrightObject.toObject = function(includeInstance, msg) {
  var f, obj = {
    info: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.PlaywrightObject}
 */
proto.Request.PlaywrightObject.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.PlaywrightObject;
  return proto.Request.PlaywrightObject.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.PlaywrightObject} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.PlaywrightObject}
 */
proto.Request.PlaywrightObject.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setInfo(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.PlaywrightObject.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.PlaywrightObject.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.PlaywrightObject} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.PlaywrightObject.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getInfo();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string info = 1;
 * @return {string}
 */
proto.Request.PlaywrightObject.prototype.getInfo = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.PlaywrightObject} returns this
 */
proto.Request.PlaywrightObject.prototype.setInfo = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.Viewport.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.Viewport.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.Viewport} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Viewport.toObject = function(includeInstance, msg) {
  var f, obj = {
    width: jspb.Message.getFieldWithDefault(msg, 1, 0),
    height: jspb.Message.getFieldWithDefault(msg, 2, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.Viewport}
 */
proto.Request.Viewport.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.Viewport;
  return proto.Request.Viewport.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.Viewport} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.Viewport}
 */
proto.Request.Viewport.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {number} */ (reader.readInt32());
      msg.setWidth(value);
      break;
    case 2:
      var value = /** @type {number} */ (reader.readInt32());
      msg.setHeight(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.Viewport.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.Viewport.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.Viewport} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.Viewport.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getWidth();
  if (f !== 0) {
    writer.writeInt32(
      1,
      f
    );
  }
  f = message.getHeight();
  if (f !== 0) {
    writer.writeInt32(
      2,
      f
    );
  }
};


/**
 * optional int32 width = 1;
 * @return {number}
 */
proto.Request.Viewport.prototype.getWidth = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 1, 0));
};


/**
 * @param {number} value
 * @return {!proto.Request.Viewport} returns this
 */
proto.Request.Viewport.prototype.setWidth = function(value) {
  return jspb.Message.setProto3IntField(this, 1, value);
};


/**
 * optional int32 height = 2;
 * @return {number}
 */
proto.Request.Viewport.prototype.getHeight = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.Request.Viewport} returns this
 */
proto.Request.Viewport.prototype.setHeight = function(value) {
  return jspb.Message.setProto3IntField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Request.HttpRequest.prototype.toObject = function(opt_includeInstance) {
  return proto.Request.HttpRequest.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Request.HttpRequest} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.HttpRequest.toObject = function(includeInstance, msg) {
  var f, obj = {
    url: jspb.Message.getFieldWithDefault(msg, 1, ""),
    method: jspb.Message.getFieldWithDefault(msg, 2, ""),
    body: jspb.Message.getFieldWithDefault(msg, 3, ""),
    headers: jspb.Message.getFieldWithDefault(msg, 4, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Request.HttpRequest}
 */
proto.Request.HttpRequest.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Request.HttpRequest;
  return proto.Request.HttpRequest.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Request.HttpRequest} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Request.HttpRequest}
 */
proto.Request.HttpRequest.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setUrl(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setMethod(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setBody(value);
      break;
    case 4:
      var value = /** @type {string} */ (reader.readString());
      msg.setHeaders(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Request.HttpRequest.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Request.HttpRequest.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Request.HttpRequest} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Request.HttpRequest.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getUrl();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getMethod();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getBody();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getHeaders();
  if (f.length > 0) {
    writer.writeString(
      4,
      f
    );
  }
};


/**
 * optional string url = 1;
 * @return {string}
 */
proto.Request.HttpRequest.prototype.getUrl = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.HttpRequest} returns this
 */
proto.Request.HttpRequest.prototype.setUrl = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string method = 2;
 * @return {string}
 */
proto.Request.HttpRequest.prototype.getMethod = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.HttpRequest} returns this
 */
proto.Request.HttpRequest.prototype.setMethod = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string body = 3;
 * @return {string}
 */
proto.Request.HttpRequest.prototype.getBody = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.HttpRequest} returns this
 */
proto.Request.HttpRequest.prototype.setBody = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional string headers = 4;
 * @return {string}
 */
proto.Request.HttpRequest.prototype.getHeaders = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 4, ""));
};


/**
 * @param {string} value
 * @return {!proto.Request.HttpRequest} returns this
 */
proto.Request.HttpRequest.prototype.setHeaders = function(value) {
  return jspb.Message.setProto3StringField(this, 4, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Types.prototype.toObject = function(opt_includeInstance) {
  return proto.Types.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Types} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Types.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Types}
 */
proto.Types.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Types;
  return proto.Types.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Types} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Types}
 */
proto.Types.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Types.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Types.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Types} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Types.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Types.SelectEntry.prototype.toObject = function(opt_includeInstance) {
  return proto.Types.SelectEntry.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Types.SelectEntry} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Types.SelectEntry.toObject = function(includeInstance, msg) {
  var f, obj = {
    value: jspb.Message.getFieldWithDefault(msg, 2, ""),
    label: jspb.Message.getFieldWithDefault(msg, 3, ""),
    selected: jspb.Message.getBooleanFieldWithDefault(msg, 4, false)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Types.SelectEntry}
 */
proto.Types.SelectEntry.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Types.SelectEntry;
  return proto.Types.SelectEntry.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Types.SelectEntry} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Types.SelectEntry}
 */
proto.Types.SelectEntry.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setValue(value);
      break;
    case 3:
      var value = /** @type {string} */ (reader.readString());
      msg.setLabel(value);
      break;
    case 4:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setSelected(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Types.SelectEntry.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Types.SelectEntry.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Types.SelectEntry} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Types.SelectEntry.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getValue();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
  f = message.getLabel();
  if (f.length > 0) {
    writer.writeString(
      3,
      f
    );
  }
  f = message.getSelected();
  if (f) {
    writer.writeBool(
      4,
      f
    );
  }
};


/**
 * optional string value = 2;
 * @return {string}
 */
proto.Types.SelectEntry.prototype.getValue = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Types.SelectEntry} returns this
 */
proto.Types.SelectEntry.prototype.setValue = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


/**
 * optional string label = 3;
 * @return {string}
 */
proto.Types.SelectEntry.prototype.getLabel = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 3, ""));
};


/**
 * @param {string} value
 * @return {!proto.Types.SelectEntry} returns this
 */
proto.Types.SelectEntry.prototype.setLabel = function(value) {
  return jspb.Message.setProto3StringField(this, 3, value);
};


/**
 * optional bool selected = 4;
 * @return {boolean}
 */
proto.Types.SelectEntry.prototype.getSelected = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 4, false));
};


/**
 * @param {boolean} value
 * @return {!proto.Types.SelectEntry} returns this
 */
proto.Types.SelectEntry.prototype.setSelected = function(value) {
  return jspb.Message.setProto3BooleanField(this, 4, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Types.RawJson.prototype.toObject = function(opt_includeInstance) {
  return proto.Types.RawJson.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Types.RawJson} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Types.RawJson.toObject = function(includeInstance, msg) {
  var f, obj = {
    log: jspb.Message.getFieldWithDefault(msg, 1, ""),
    body: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Types.RawJson}
 */
proto.Types.RawJson.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Types.RawJson;
  return proto.Types.RawJson.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Types.RawJson} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Types.RawJson}
 */
proto.Types.RawJson.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setLog(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setBody(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Types.RawJson.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Types.RawJson.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Types.RawJson} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Types.RawJson.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLog();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getBody();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string log = 1;
 * @return {string}
 */
proto.Types.RawJson.prototype.getLog = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Types.RawJson} returns this
 */
proto.Types.RawJson.prototype.setLog = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string body = 2;
 * @return {string}
 */
proto.Types.RawJson.prototype.getBody = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Types.RawJson} returns this
 */
proto.Types.RawJson.prototype.setBody = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.toObject = function(includeInstance, msg) {
  var f, obj = {

  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response}
 */
proto.Response.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response;
  return proto.Response.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response}
 */
proto.Response.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.Empty.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.Empty.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response.Empty} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Empty.toObject = function(includeInstance, msg) {
  var f, obj = {
    log: jspb.Message.getFieldWithDefault(msg, 1, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response.Empty}
 */
proto.Response.Empty.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response.Empty;
  return proto.Response.Empty.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response.Empty} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response.Empty}
 */
proto.Response.Empty.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setLog(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.Empty.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.Empty.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response.Empty} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Empty.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLog();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
};


/**
 * optional string log = 1;
 * @return {string}
 */
proto.Response.Empty.prototype.getLog = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.Empty} returns this
 */
proto.Response.Empty.prototype.setLog = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.String.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.String.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response.String} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.String.toObject = function(includeInstance, msg) {
  var f, obj = {
    log: jspb.Message.getFieldWithDefault(msg, 1, ""),
    body: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response.String}
 */
proto.Response.String.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response.String;
  return proto.Response.String.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response.String} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response.String}
 */
proto.Response.String.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setLog(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setBody(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.String.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.String.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response.String} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.String.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLog();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getBody();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string log = 1;
 * @return {string}
 */
proto.Response.String.prototype.getLog = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.String} returns this
 */
proto.Response.String.prototype.setLog = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string body = 2;
 * @return {string}
 */
proto.Response.String.prototype.getBody = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.String} returns this
 */
proto.Response.String.prototype.setBody = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.Bool.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.Bool.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response.Bool} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Bool.toObject = function(includeInstance, msg) {
  var f, obj = {
    log: jspb.Message.getFieldWithDefault(msg, 1, ""),
    body: jspb.Message.getBooleanFieldWithDefault(msg, 2, false)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response.Bool}
 */
proto.Response.Bool.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response.Bool;
  return proto.Response.Bool.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response.Bool} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response.Bool}
 */
proto.Response.Bool.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setLog(value);
      break;
    case 2:
      var value = /** @type {boolean} */ (reader.readBool());
      msg.setBody(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.Bool.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.Bool.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response.Bool} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Bool.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLog();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getBody();
  if (f) {
    writer.writeBool(
      2,
      f
    );
  }
};


/**
 * optional string log = 1;
 * @return {string}
 */
proto.Response.Bool.prototype.getLog = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.Bool} returns this
 */
proto.Response.Bool.prototype.setLog = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional bool body = 2;
 * @return {boolean}
 */
proto.Response.Bool.prototype.getBody = function() {
  return /** @type {boolean} */ (jspb.Message.getBooleanFieldWithDefault(this, 2, false));
};


/**
 * @param {boolean} value
 * @return {!proto.Response.Bool} returns this
 */
proto.Response.Bool.prototype.setBody = function(value) {
  return jspb.Message.setProto3BooleanField(this, 2, value);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.Int.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.Int.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response.Int} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Int.toObject = function(includeInstance, msg) {
  var f, obj = {
    log: jspb.Message.getFieldWithDefault(msg, 1, ""),
    body: jspb.Message.getFieldWithDefault(msg, 2, 0)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response.Int}
 */
proto.Response.Int.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response.Int;
  return proto.Response.Int.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response.Int} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response.Int}
 */
proto.Response.Int.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setLog(value);
      break;
    case 2:
      var value = /** @type {number} */ (reader.readInt32());
      msg.setBody(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.Int.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.Int.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response.Int} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Int.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLog();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getBody();
  if (f !== 0) {
    writer.writeInt32(
      2,
      f
    );
  }
};


/**
 * optional string log = 1;
 * @return {string}
 */
proto.Response.Int.prototype.getLog = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.Int} returns this
 */
proto.Response.Int.prototype.setLog = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional int32 body = 2;
 * @return {number}
 */
proto.Response.Int.prototype.getBody = function() {
  return /** @type {number} */ (jspb.Message.getFieldWithDefault(this, 2, 0));
};


/**
 * @param {number} value
 * @return {!proto.Response.Int} returns this
 */
proto.Response.Int.prototype.setBody = function(value) {
  return jspb.Message.setProto3IntField(this, 2, value);
};



/**
 * List of repeated fields within this message type.
 * @private {!Array<number>}
 * @const
 */
proto.Response.Select.repeatedFields_ = [1];



if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.Select.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.Select.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response.Select} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Select.toObject = function(includeInstance, msg) {
  var f, obj = {
    entryList: jspb.Message.toObjectList(msg.getEntryList(),
    proto.Types.SelectEntry.toObject, includeInstance)
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response.Select}
 */
proto.Response.Select.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response.Select;
  return proto.Response.Select.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response.Select} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response.Select}
 */
proto.Response.Select.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = new proto.Types.SelectEntry;
      reader.readMessage(value,proto.Types.SelectEntry.deserializeBinaryFromReader);
      msg.addEntry(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.Select.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.Select.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response.Select} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.Select.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getEntryList();
  if (f.length > 0) {
    writer.writeRepeatedMessage(
      1,
      f,
      proto.Types.SelectEntry.serializeBinaryToWriter
    );
  }
};


/**
 * repeated Types.SelectEntry entry = 1;
 * @return {!Array<!proto.Types.SelectEntry>}
 */
proto.Response.Select.prototype.getEntryList = function() {
  return /** @type{!Array<!proto.Types.SelectEntry>} */ (
    jspb.Message.getRepeatedWrapperField(this, proto.Types.SelectEntry, 1));
};


/**
 * @param {!Array<!proto.Types.SelectEntry>} value
 * @return {!proto.Response.Select} returns this
*/
proto.Response.Select.prototype.setEntryList = function(value) {
  return jspb.Message.setRepeatedWrapperField(this, 1, value);
};


/**
 * @param {!proto.Types.SelectEntry=} opt_value
 * @param {number=} opt_index
 * @return {!proto.Types.SelectEntry}
 */
proto.Response.Select.prototype.addEntry = function(opt_value, opt_index) {
  return jspb.Message.addToRepeatedWrapperField(this, 1, opt_value, proto.Types.SelectEntry, opt_index);
};


/**
 * Clears the list making it empty but non-null.
 * @return {!proto.Response.Select} returns this
 */
proto.Response.Select.prototype.clearEntryList = function() {
  return this.setEntryList([]);
};





if (jspb.Message.GENERATE_TO_OBJECT) {
/**
 * Creates an object representation of this proto.
 * Field names that are reserved in JavaScript and will be renamed to pb_name.
 * Optional fields that are not set will be set to undefined.
 * To access a reserved field use, foo.pb_<name>, eg, foo.pb_default.
 * For the list of reserved names please see:
 *     net/proto2/compiler/js/internal/generator.cc#kKeyword.
 * @param {boolean=} opt_includeInstance Deprecated. whether to include the
 *     JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @return {!Object}
 */
proto.Response.JavascriptExecutionResult.prototype.toObject = function(opt_includeInstance) {
  return proto.Response.JavascriptExecutionResult.toObject(opt_includeInstance, this);
};


/**
 * Static version of the {@see toObject} method.
 * @param {boolean|undefined} includeInstance Deprecated. Whether to include
 *     the JSPB instance for transitional soy proto support:
 *     http://goto/soy-param-migration
 * @param {!proto.Response.JavascriptExecutionResult} msg The msg instance to transform.
 * @return {!Object}
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.JavascriptExecutionResult.toObject = function(includeInstance, msg) {
  var f, obj = {
    log: jspb.Message.getFieldWithDefault(msg, 1, ""),
    result: jspb.Message.getFieldWithDefault(msg, 2, "")
  };

  if (includeInstance) {
    obj.$jspbMessageInstance = msg;
  }
  return obj;
};
}


/**
 * Deserializes binary data (in protobuf wire format).
 * @param {jspb.ByteSource} bytes The bytes to deserialize.
 * @return {!proto.Response.JavascriptExecutionResult}
 */
proto.Response.JavascriptExecutionResult.deserializeBinary = function(bytes) {
  var reader = new jspb.BinaryReader(bytes);
  var msg = new proto.Response.JavascriptExecutionResult;
  return proto.Response.JavascriptExecutionResult.deserializeBinaryFromReader(msg, reader);
};


/**
 * Deserializes binary data (in protobuf wire format) from the
 * given reader into the given message object.
 * @param {!proto.Response.JavascriptExecutionResult} msg The message object to deserialize into.
 * @param {!jspb.BinaryReader} reader The BinaryReader to use.
 * @return {!proto.Response.JavascriptExecutionResult}
 */
proto.Response.JavascriptExecutionResult.deserializeBinaryFromReader = function(msg, reader) {
  while (reader.nextField()) {
    if (reader.isEndGroup()) {
      break;
    }
    var field = reader.getFieldNumber();
    switch (field) {
    case 1:
      var value = /** @type {string} */ (reader.readString());
      msg.setLog(value);
      break;
    case 2:
      var value = /** @type {string} */ (reader.readString());
      msg.setResult(value);
      break;
    default:
      reader.skipField();
      break;
    }
  }
  return msg;
};


/**
 * Serializes the message to binary data (in protobuf wire format).
 * @return {!Uint8Array}
 */
proto.Response.JavascriptExecutionResult.prototype.serializeBinary = function() {
  var writer = new jspb.BinaryWriter();
  proto.Response.JavascriptExecutionResult.serializeBinaryToWriter(this, writer);
  return writer.getResultBuffer();
};


/**
 * Serializes the given message to binary data (in protobuf wire
 * format), writing to the given BinaryWriter.
 * @param {!proto.Response.JavascriptExecutionResult} message
 * @param {!jspb.BinaryWriter} writer
 * @suppress {unusedLocalVariables} f is only used for nested messages
 */
proto.Response.JavascriptExecutionResult.serializeBinaryToWriter = function(message, writer) {
  var f = undefined;
  f = message.getLog();
  if (f.length > 0) {
    writer.writeString(
      1,
      f
    );
  }
  f = message.getResult();
  if (f.length > 0) {
    writer.writeString(
      2,
      f
    );
  }
};


/**
 * optional string log = 1;
 * @return {string}
 */
proto.Response.JavascriptExecutionResult.prototype.getLog = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 1, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.JavascriptExecutionResult} returns this
 */
proto.Response.JavascriptExecutionResult.prototype.setLog = function(value) {
  return jspb.Message.setProto3StringField(this, 1, value);
};


/**
 * optional string result = 2;
 * @return {string}
 */
proto.Response.JavascriptExecutionResult.prototype.getResult = function() {
  return /** @type {string} */ (jspb.Message.getFieldWithDefault(this, 2, ""));
};


/**
 * @param {string} value
 * @return {!proto.Response.JavascriptExecutionResult} returns this
 */
proto.Response.JavascriptExecutionResult.prototype.setResult = function(value) {
  return jspb.Message.setProto3StringField(this, 2, value);
};


goog.object.extend(exports, proto);


/***/ }),

/***/ "./node/playwright-wrapper/getters.ts":
/*!********************************************!*\
  !*** ./node/playwright-wrapper/getters.ts ***!
  \********************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getViewportSize = exports.getStyle = exports.getBoolProperty = exports.getDomProperty = exports.getSelectContent = exports.getElementCount = exports.getUrl = exports.getTitle = void 0;
var playwright_pb_1 = __webpack_require__(/*! ./generated/playwright_pb */ "./node/playwright-wrapper/generated/playwright_pb.js");
var playwirght_invoke_1 = __webpack_require__(/*! ./playwirght-invoke */ "./node/playwright-wrapper/playwirght-invoke.ts");
var response_util_1 = __webpack_require__(/*! ./response-util */ "./node/playwright-wrapper/response-util.ts");
function getTitle(callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var title;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_invoke_1.invokeOnPage(page, callback, 'title')];
                case 1:
                    title = _a.sent();
                    callback(null, response_util_1.stringResponse(title));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getTitle = getTitle;
function getUrl(callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var url;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_invoke_1.invokeOnPage(page, callback, 'url')];
                case 1:
                    url = _a.sent();
                    callback(null, response_util_1.stringResponse(url));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getUrl = getUrl;
function getElementCount(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, '$$', selector)];
                case 1:
                    response = _a.sent();
                    callback(null, response_util_1.intResponse(response.length));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getElementCount = getElementCount;
function getSelectContent(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, content, response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_invoke_1.waitUntilElementExists(state, callback, selector)];
                case 1:
                    _a.sent();
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, '$$eval', selector + ' option', function (elements) { return elements.map(function (elem) { return [elem.label, elem.value, elem.selected]; }); })];
                case 2:
                    content = _a.sent();
                    response = new playwright_pb_1.Response.Select();
                    content.forEach(function (option) {
                        var _a = [option[0], option[1], option[2]], label = _a[0], value = _a[1], selected = _a[2];
                        var entry = new playwright_pb_1.Types.SelectEntry();
                        entry.setLabel(label);
                        entry.setValue(value);
                        entry.setSelected(selected);
                        response.addEntry(entry);
                    });
                    callback(null, response);
                    return [2 /*return*/];
            }
        });
    });
}
exports.getSelectContent = getSelectContent;
function getDomProperty(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var content;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, getProperty(call, callback, state)];
                case 1:
                    content = _a.sent();
                    callback(null, response_util_1.stringResponse(content));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getDomProperty = getDomProperty;
function getBoolProperty(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var content;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, getProperty(call, callback, state)];
                case 1:
                    content = _a.sent();
                    callback(null, response_util_1.boolResponse(content || false));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getBoolProperty = getBoolProperty;
function getProperty(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, element, propertyName, property, content, e_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_invoke_1.waitUntilElementExists(state, callback, selector)];
                case 1:
                    element = _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, 5, , 6]);
                    propertyName = call.request.getProperty();
                    return [4 /*yield*/, element.getProperty(propertyName)];
                case 3:
                    property = _a.sent();
                    return [4 /*yield*/, property.jsonValue()];
                case 4:
                    content = _a.sent();
                    console.log("Retrieved dom property for element " + selector + " containing " + content);
                    return [2 /*return*/, content];
                case 5:
                    e_1 = _a.sent();
                    console.log(e_1);
                    callback(e_1, null);
                    return [3 /*break*/, 6];
                case 6: return [2 /*return*/];
            }
        });
    });
}
function getStyle(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, result, response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    console.log('Getting css of element on page');
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, '$eval', selector, function (element) {
                            var rawStyle = window.getComputedStyle(element);
                            var mapped = {};
                            // This is necessary because JSON.stringify doesn't handle CSSStyleDeclarations correctly
                            for (var i = 0; i < rawStyle.length; i++) {
                                var name_1 = rawStyle[i];
                                mapped[name_1] = rawStyle.getPropertyValue(name_1);
                            }
                            return JSON.stringify(mapped);
                        })];
                case 1:
                    result = _a.sent();
                    response = response_util_1.stringResponse(result);
                    callback(null, response);
                    return [2 /*return*/];
            }
        });
    });
}
exports.getStyle = getStyle;
function getViewportSize(call, callback, page) {
    return __awaiter(this, void 0, void 0, function () {
        var result;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, playwirght_invoke_1.invokeOnPage(page, callback, 'viewportSize')];
                case 1:
                    result = _a.sent();
                    callback(null, response_util_1.stringResponse(JSON.stringify(result)));
                    return [2 /*return*/];
            }
        });
    });
}
exports.getViewportSize = getViewportSize;


/***/ }),

/***/ "./node/playwright-wrapper/grpc-service.ts":
/*!*************************************************!*\
  !*** ./node/playwright-wrapper/grpc-service.ts ***!
  \*************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlaywrightServer = void 0;
var playwright_pb_1 = __webpack_require__(/*! ./generated/playwright_pb */ "./node/playwright-wrapper/generated/playwright_pb.js");
var browserControl = __importStar(__webpack_require__(/*! ./browser-control */ "./node/playwright-wrapper/browser-control.ts"));
var evaluation = __importStar(__webpack_require__(/*! ./evaluation */ "./node/playwright-wrapper/evaluation.ts"));
var getters = __importStar(__webpack_require__(/*! ./getters */ "./node/playwright-wrapper/getters.ts"));
var interaction = __importStar(__webpack_require__(/*! ./interaction */ "./node/playwright-wrapper/interaction.ts"));
var playwrightState = __importStar(__webpack_require__(/*! ./playwright-state */ "./node/playwright-wrapper/playwright-state.ts"));
var playwright_state_1 = __webpack_require__(/*! ./playwright-state */ "./node/playwright-wrapper/playwright-state.ts");
var PlaywrightServer = /** @class */ (function () {
    function PlaywrightServer() {
        var _this = this;
        this.getActiveBrowser = function (callback) { return _this.state.getActiveBrowser(callback); };
        this.getActivePage = function () { return _this.state.getActivePage(); };
        this.state = new playwright_state_1.PlaywrightState();
    }
    PlaywrightServer.prototype.closeBrowser = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                playwrightState.closeBrowser(callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.closeAllBrowsers = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                playwrightState.closeAllBrowsers(callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.closeContext = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                playwrightState.closeContext(callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.closePage = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                playwrightState.closePage(callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getBrowserCatalog = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                playwrightState.getBrowserCatalog(callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.autoActivatePages = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                playwrightState.autoActivatePages(call, callback, this.getActiveBrowser(callback));
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.switchPage = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                playwrightState.switchPage(call, callback, this.state.getActiveBrowser(callback));
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.switchContext = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                playwrightState.switchContext(call, callback, this.state.getActiveBrowser(callback));
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.switchBrowser = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                playwrightState.switchBrowser(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.newPage = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                playwrightState.newPage(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.newContext = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                playwrightState.newContext(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.newBrowser = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                playwrightState.newBrowser(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.goTo = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                browserControl.goTo(call, callback, this.getActivePage());
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.goBack = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                browserControl.goBack(callback, this.getActivePage());
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.goForward = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                browserControl.goForward(callback, this.getActivePage());
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.takeScreenshot = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                browserControl.takeScreenshot(call, callback, this.getActivePage());
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.setTimeout = function (call, callback) {
        var _a, _b;
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_c) {
                browserControl.setTimeout(call, callback, (_b = (_a = this.getActiveBrowser(callback)) === null || _a === void 0 ? void 0 : _a.context) === null || _b === void 0 ? void 0 : _b.c);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getTitle = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                getters.getTitle(callback, this.getActivePage());
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getUrl = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                getters.getUrl(callback, this.getActivePage());
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getElementCount = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                getters.getElementCount(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getSelectContent = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                getters.getSelectContent(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getDomProperty = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                getters.getDomProperty(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getBoolProperty = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                getters.getBoolProperty(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getStyle = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                getters.getStyle(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getViewportSize = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                getters.getViewportSize(call, callback, this.getActivePage());
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.selectOption = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                interaction.selectOption(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.deselectOption = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                interaction.deSelectOption(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.inputText = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                interaction.inputText(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.typeText = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                interaction.typeText(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.fillText = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                interaction.fillText(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.clearText = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                interaction.clearText(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.press = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                interaction.press(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.click = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                interaction.click(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.clickWithOptions = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                interaction.clickWithOptions(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.focus = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                interaction.focus(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.checkCheckbox = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                interaction.checkCheckbox(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.uncheckCheckbox = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                interaction.uncheckCheckbox(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getElement = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                evaluation.getElement(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.addStyleTag = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                evaluation.addStyleTag(call, callback, this.getActivePage());
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.waitForElementsState = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                evaluation.waitForElementState(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.executeJavascriptOnPage = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                evaluation.executeJavascriptOnPage(call, callback, this.getActivePage());
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.getPageState = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                evaluation.getPageState(callback, this.getActivePage());
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.health = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            var response;
            return __generator(this, function (_a) {
                response = new playwright_pb_1.Response.String();
                response.setBody('OK');
                callback(null, response);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.highlightElements = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                evaluation.highlightElements(call, callback, this.state);
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.setViewportSize = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                browserControl.setViewportSize(call, callback, this.getActivePage());
                return [2 /*return*/];
            });
        });
    };
    PlaywrightServer.prototype.httpRequest = function (call, callback) {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                evaluation.httpRequest(call, callback, this.getActivePage());
                return [2 /*return*/];
            });
        });
    };
    return PlaywrightServer;
}());
exports.PlaywrightServer = PlaywrightServer;


/***/ }),

/***/ "./node/playwright-wrapper/index.ts":
/*!******************************************!*\
  !*** ./node/playwright-wrapper/index.ts ***!
  \******************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
var grpc_1 = __webpack_require__(/*! grpc */ "grpc");
var playwright_grpc_pb_1 = __webpack_require__(/*! ./generated/playwright_grpc_pb */ "./node/playwright-wrapper/generated/playwright_grpc_pb.js");
var grpc_service_1 = __webpack_require__(/*! ./grpc-service */ "./node/playwright-wrapper/grpc-service.ts");
var server = new grpc_1.Server();
server.addService(playwright_grpc_pb_1.PlaywrightService, new grpc_service_1.PlaywrightServer());
var port = process.env.PORT || '0';
server.bind("localhost:" + port, grpc_1.ServerCredentials.createInsecure());
console.log("Listening on " + port);
server.start();


/***/ }),

/***/ "./node/playwright-wrapper/interaction.ts":
/*!************************************************!*\
  !*** ./node/playwright-wrapper/interaction.ts ***!
  \************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.uncheckCheckbox = exports.checkCheckbox = exports.focus = exports.clickWithOptions = exports.click = exports.press = exports.clearText = exports.fillText = exports.typeText = exports.inputText = exports.deSelectOption = exports.selectOption = void 0;
var playwirght_invoke_1 = __webpack_require__(/*! ./playwirght-invoke */ "./node/playwright-wrapper/playwirght-invoke.ts");
var response_util_1 = __webpack_require__(/*! ./response-util */ "./node/playwright-wrapper/response-util.ts");
function selectOption(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, matcher, result, error, response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    matcher = JSON.parse(call.request.getMatcherjson());
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, 'selectOption', selector, matcher)];
                case 1:
                    result = _a.sent();
                    if (result.length == 0) {
                        console.log("Couldn't select any options");
                        error = new Error("No options matched " + matcher);
                        callback(error, null);
                    }
                    response = response_util_1.emptyWithLog("Selected options " + result + " in element " + selector);
                    callback(null, response);
                    return [2 /*return*/];
            }
        });
    });
}
exports.selectOption = selectOption;
function deSelectOption(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, 'selectOption', selector, [])];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog("Deselected options in element " + selector));
                    return [2 /*return*/];
            }
        });
    });
}
exports.deSelectOption = deSelectOption;
function inputText(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var inputText, selector, type, methodName;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    inputText = call.request.getInput();
                    selector = call.request.getSelector();
                    type = call.request.getType();
                    methodName = type ? 'type' : 'fill';
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, methodName, selector, inputText)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Input text: ' + inputText));
                    return [2 /*return*/];
            }
        });
    });
}
exports.inputText = inputText;
function typeText(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, text, delay, clear;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    text = call.request.getText();
                    delay = call.request.getDelay();
                    clear = call.request.getClear();
                    if (!clear) return [3 /*break*/, 2];
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, 'fill', selector, '')];
                case 1:
                    _a.sent();
                    _a.label = 2;
                case 2: return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, 'type', selector, text, { delay: delay })];
                case 3:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Typed text: ' + text));
                    return [2 /*return*/];
            }
        });
    });
}
exports.typeText = typeText;
function fillText(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, text;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    text = call.request.getText();
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, 'fill', selector, text)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Fill text: ' + text));
                    return [2 /*return*/];
            }
        });
    });
}
exports.fillText = fillText;
function clearText(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, 'fill', selector, '')];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Text field cleared.'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.clearText = clearText;
function press(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, keyList, _i, keyList_1, i;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    keyList = call.request.getKeyList();
                    _i = 0, keyList_1 = keyList;
                    _a.label = 1;
                case 1:
                    if (!(_i < keyList_1.length)) return [3 /*break*/, 4];
                    i = keyList_1[_i];
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, 'press', selector, i)];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    _i++;
                    return [3 /*break*/, 1];
                case 4:
                    callback(null, response_util_1.emptyWithLog('Pressed keys: ' + keyList));
                    return [2 /*return*/];
            }
        });
    });
}
exports.press = press;
function click(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, 'click', selector)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Clicked element: ' + selector));
                    return [2 /*return*/];
            }
        });
    });
}
exports.click = click;
function clickWithOptions(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector, options;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    options = call.request.getOptions();
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, 'click', selector, JSON.parse(options))];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Clicked element: ' + selector + ' \nWith options: ' + options));
                    return [2 /*return*/];
            }
        });
    });
}
exports.clickWithOptions = clickWithOptions;
function focus(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, 'focus', selector)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Focused element: ' + selector));
                    return [2 /*return*/];
            }
        });
    });
}
exports.focus = focus;
function checkCheckbox(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, 'check', selector)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Checked checkbox: ' + selector));
                    return [2 /*return*/];
            }
        });
    });
}
exports.checkCheckbox = checkCheckbox;
function uncheckCheckbox(call, callback, state) {
    return __awaiter(this, void 0, void 0, function () {
        var selector;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    selector = call.request.getSelector();
                    return [4 /*yield*/, playwirght_invoke_1.invokePlaywirghtMethod(state, callback, 'uncheck', selector)];
                case 1:
                    _a.sent();
                    callback(null, response_util_1.emptyWithLog('Unchecked checkbox: ' + selector));
                    return [2 /*return*/];
            }
        });
    });
}
exports.uncheckCheckbox = uncheckCheckbox;


/***/ }),

/***/ "./node/playwright-wrapper/playwirght-invoke.ts":
/*!******************************************************!*\
  !*** ./node/playwright-wrapper/playwirght-invoke.ts ***!
  \******************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.exists = exports.invokePlaywirghtMethod = exports.invokeOnPage = exports.waitUntilElementExists = void 0;
var grpc_1 = __webpack_require__(/*! grpc */ "grpc");
var playwright_1 = __webpack_require__(/*! playwright */ "playwright");
function waitUntilElementExists(state, callback, selector) {
    return __awaiter(this, void 0, void 0, function () {
        var _a, elementSelector, context, e_1, element;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0: return [4 /*yield*/, determineFunctionAndSelector(state, selector, callback)];
                case 1:
                    _a = _b.sent(), elementSelector = _a.elementSelector, context = _a.context;
                    exists(context, callback, '');
                    if (!('waitForSelector' in context)) return [3 /*break*/, 5];
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, 4, , 5]);
                    return [4 /*yield*/, context.waitForSelector(elementSelector, { state: 'attached' })];
                case 3:
                    _b.sent();
                    return [3 /*break*/, 5];
                case 4:
                    e_1 = _b.sent();
                    callback(getErrorDetails(e_1, selector, 'waitForSelector'), null);
                    return [3 /*break*/, 5];
                case 5: return [4 /*yield*/, context.$(elementSelector)];
                case 6:
                    element = _b.sent();
                    exists(element, callback, "Could not find element with selector `" + elementSelector + "` within timeout.");
                    return [2 /*return*/, element];
            }
        });
    });
}
exports.waitUntilElementExists = waitUntilElementExists;
function invokeOnPage(page, callback, methodName) {
    var args = [];
    for (var _i = 3; _i < arguments.length; _i++) {
        args[_i - 3] = arguments[_i];
    }
    return __awaiter(this, void 0, void 0, function () {
        var fn, e_2;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    exists(page, callback, "Tried to do playwright action '" + methodName + "', but no open page.");
                    fn = page[methodName].bind(page);
                    _a.label = 1;
                case 1:
                    _a.trys.push([1, 3, , 4]);
                    return [4 /*yield*/, fn.apply(void 0, args)];
                case 2: return [2 /*return*/, _a.sent()];
                case 3:
                    e_2 = _a.sent();
                    console.log("Error invoking Playwright action '" + methodName + "': " + e_2);
                    callback(e_2, null);
                    return [3 /*break*/, 4];
                case 4: return [2 /*return*/];
            }
        });
    });
}
exports.invokeOnPage = invokeOnPage;
/**
 * Resolve the playwright method on page, frame or elementHandle and invoke it.
 * With a normal selector, invokes the `methodName` on the given `page`.
 * If the selector is a frame piercing selector, first find the corresponding
 * frame on the `page`, and then invoke the `methodName` on the resolved frame.
 * If the selector is an elementHandle selector, first resolve the corresponding e
 * elementHandle, and invoke the method on it.
 *
 * @param state A reference to current PlaywrightState object.
 * @param callback GRPC callback to make response.
 * @param methodName Which Playwright method to invoke.
 * @param selector Selector of the element to operate on,
 *  or a frame piercing selector in format `<frame selector> >>> <element selector>
 * @param args Additional args to the Playwirght method.
 */
function invokePlaywirghtMethod(state, callback, methodName, selector) {
    var args = [];
    for (var _i = 4; _i < arguments.length; _i++) {
        args[_i - 4] = arguments[_i];
    }
    return __awaiter(this, void 0, void 0, function () {
        var _a, elementSelector, context, fn, e_3;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0: return [4 /*yield*/, determineFunctionAndSelector(state, selector, callback)];
                case 1:
                    _a = _b.sent(), elementSelector = _a.elementSelector, context = _a.context;
                    _b.label = 2;
                case 2:
                    _b.trys.push([2, 4, , 5]);
                    fn = context[methodName].bind(context);
                    return [4 /*yield*/, fn.apply(void 0, __spreadArrays([elementSelector], args))];
                case 3: return [2 /*return*/, _b.sent()];
                case 4:
                    e_3 = _b.sent();
                    callback(getErrorDetails(e_3, selector, methodName), null);
                    return [3 /*break*/, 5];
                case 5: return [2 /*return*/];
            }
        });
    });
}
exports.invokePlaywirghtMethod = invokePlaywirghtMethod;
function determineFunctionAndSelector(state, selector, callback) {
    return __awaiter(this, void 0, void 0, function () {
        var page, _a, frameSelector, elementSelector, frame, _b, elementHandleId, elementSelector;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    page = state.getActivePage();
                    exists(page, callback, "Tried to do playwright action, but no open browser.");
                    if (!isFramePiercingSelector(selector)) return [3 /*break*/, 2];
                    _a = splitFrameAndElementSelector(selector), frameSelector = _a.frameSelector, elementSelector = _a.elementSelector;
                    return [4 /*yield*/, findFrame(page, frameSelector, callback)];
                case 1:
                    frame = _c.sent();
                    return [2 /*return*/, { elementSelector: elementSelector, context: frame }];
                case 2:
                    if (isElementHandleSelector(selector)) {
                        _b = splitElementHandleAndElementSelector(selector, callback), elementHandleId = _b.elementHandleId, elementSelector = _b.elementSelector;
                        try {
                            return [2 /*return*/, { elementSelector: elementSelector, context: state.getElement(elementHandleId) }];
                        }
                        catch (e) {
                            callback(e, null);
                        }
                        // This is purely to appease Typescript compiler, code is never executed since the
                        // `callback` breaks the execution.
                        return [2 /*return*/, {
                                elementSelector: '',
                                context: null,
                            }];
                    }
                    else {
                        return [2 /*return*/, { elementSelector: selector, context: page }];
                    }
                    _c.label = 3;
                case 3: return [2 /*return*/];
            }
        });
    });
}
function isFramePiercingSelector(selector) {
    return selector.match('>>>');
}
function isElementHandleSelector(selector) {
    return selector.startsWith('element=');
}
function splitFrameAndElementSelector(selector) {
    var parts = selector.split('>>>');
    return {
        frameSelector: parts[0].trim(),
        elementSelector: parts[1].trim(),
    };
}
function splitElementHandleAndElementSelector(selector, callback) {
    var splitter = /element=([\w-]+)\s*>>\s*(.*)/;
    var parts = selector.split(splitter);
    if (parts.length == 4) {
        var splitted = {
            elementHandleId: parts[1],
            elementSelector: parts[2],
        };
        console.log("Split element= selector into parts: " + JSON.stringify(splitted));
        return splitted;
    }
    callback(new Error("Invalid element selector `" + selector + "`."), null);
    // This is purely to appease Typescript compiler, code is never executed since the
    // `callback` breaks the execution.
    return {
        elementHandleId: '',
        elementSelector: '',
    };
}
function findFrame(page, frameSelector, callback) {
    return __awaiter(this, void 0, void 0, function () {
        var frameHandle;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, page.$(frameSelector)];
                case 1:
                    frameHandle = _a.sent();
                    exists(frameHandle, callback, "Could not find frame with selector " + frameSelector);
                    return [4 /*yield*/, frameHandle.contentFrame()];
                case 2: return [2 /*return*/, _a.sent()];
            }
        });
    });
}
// This is necessary for improved typescript inference
/*
 * If obj is not trueish call callback with new Error containing message
 */
function exists(obj, callback, message) {
    if (!obj) {
        callback(new Error(message), null);
    }
}
exports.exists = exists;
function getErrorDetails(e, selector, methodName) {
    var errorMetadata = new grpc_1.Metadata();
    if (e instanceof playwright_1.errors.TimeoutError) {
        errorMetadata.add('reason', "Could not find element with selector `" + selector + "` within timeout.");
    }
    if (e.message.match(/DOMException: .* is not a valid selector/)) {
        errorMetadata.add('reason', "Invalid selector `" + selector + "`.");
    }
    return {
        code: grpc_1.status.INVALID_ARGUMENT,
        name: e.name,
        message: '',
        details: "Error invoking Playwright action " + methodName + ":\n" + e.toString(),
        metadata: errorMetadata,
    };
}


/***/ }),

/***/ "./node/playwright-wrapper/playwright-state.ts":
/*!*****************************************************!*\
  !*** ./node/playwright-wrapper/playwright-state.ts ***!
  \*****************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBrowserCatalog = exports.switchBrowser = exports.switchContext = exports.switchPage = exports.autoActivatePages = exports.newBrowser = exports.newContext = exports.newPage = exports.closePage = exports.closeContext = exports.closeAllBrowsers = exports.closeBrowser = exports.BrowserState = exports.PlaywrightState = void 0;
var playwright_1 = __webpack_require__(/*! playwright */ "playwright");
var playwright_pb_1 = __webpack_require__(/*! ./generated/playwright_pb */ "./node/playwright-wrapper/generated/playwright_pb.js");
var playwirght_invoke_1 = __webpack_require__(/*! ./playwirght-invoke */ "./node/playwright-wrapper/playwirght-invoke.ts");
var response_util_1 = __webpack_require__(/*! ./response-util */ "./node/playwright-wrapper/response-util.ts");
function _newBrowser(browserType, headless, options) {
    return __awaiter(this, void 0, void 0, function () {
        var browser;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    browserType = browserType || 'chromium';
                    headless = headless || true;
                    if (!(browserType === 'firefox')) return [3 /*break*/, 2];
                    return [4 /*yield*/, playwright_1.firefox.launch(__assign({ headless: headless }, options))];
                case 1:
                    browser = _a.sent();
                    return [3 /*break*/, 7];
                case 2:
                    if (!(browserType === 'chromium')) return [3 /*break*/, 4];
                    return [4 /*yield*/, playwright_1.chromium.launch(__assign({ headless: headless }, options))];
                case 3:
                    browser = _a.sent();
                    return [3 /*break*/, 7];
                case 4:
                    if (!(browserType === 'webkit')) return [3 /*break*/, 6];
                    return [4 /*yield*/, playwright_1.webkit.launch(__assign({ headless: headless }, options))];
                case 5:
                    browser = _a.sent();
                    return [3 /*break*/, 7];
                case 6: throw new Error('unsupported browser');
                case 7: return [2 /*return*/, [browser, browserType]];
            }
        });
    });
}
function _newBrowserContext(browser, options, hideRfBrowser) {
    return __awaiter(this, void 0, void 0, function () {
        var context, index;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, browser.newContext(options)];
                case 1:
                    context = _a.sent();
                    if (!!hideRfBrowser) return [3 /*break*/, 3];
                    return [4 /*yield*/, context.addInitScript(function () {
                            window.__SET_RFBROWSER_STATE__ = function (state) {
                                window.__RFBROWSER__ = state;
                                return state;
                            };
                        })];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    context.setDefaultTimeout(parseFloat(process.env.TIMEOUT || '10000'));
                    index = browser.contexts().length - 1;
                    return [2 /*return*/, { index: index, c: context }];
            }
        });
    });
}
function _newPage(context) {
    return __awaiter(this, void 0, void 0, function () {
        var index, newPage;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    index = context.pages().length;
                    return [4 /*yield*/, context.newPage()];
                case 1:
                    newPage = _a.sent();
                    return [2 /*return*/, { index: index, p: newPage }];
            }
        });
    });
}
var PlaywrightState = /** @class */ (function () {
    function PlaywrightState() {
        var _this = this;
        this.getActiveBrowser = function (callback) {
            var currentBrowser = _this.browsers[_this.activeBrowser];
            if (currentBrowser === 'CLOSED') {
                var error = new Error('Browser has been closed.');
                callback(error, null);
                throw error;
            }
            else if (currentBrowser === undefined) {
                var mapped = _this.browsers.map(function (browserState) {
                    if (typeof browserState === 'string')
                        return browserState;
                    else
                        return browserState === null || browserState === void 0 ? void 0 : browserState.name;
                });
                var message = "No browser for index " + _this.activeBrowser + ". Open browsers: " + mapped;
                var error = new Error(message);
                callback(error, null);
                throw error;
            }
            else {
                return currentBrowser;
            }
        };
        this.getActiveContext = function () {
            var _a;
            var currentBrowser = _this.browsers[_this.activeBrowser];
            if (currentBrowser === 'CLOSED')
                return undefined;
            return (_a = currentBrowser === null || currentBrowser === void 0 ? void 0 : currentBrowser.context) === null || _a === void 0 ? void 0 : _a.c;
        };
        this.getActivePage = function () {
            var _a;
            var currentBrowser = _this.browsers[_this.activeBrowser];
            if (currentBrowser === 'CLOSED')
                return undefined;
            return (_a = currentBrowser === null || currentBrowser === void 0 ? void 0 : currentBrowser.page) === null || _a === void 0 ? void 0 : _a.p;
        };
        this.activeBrowser = 0;
        this.browsers = [];
        this.elementHandles = new Map();
    }
    PlaywrightState.prototype.getOrCreateActiveBrowser = function () {
        return __awaiter(this, void 0, void 0, function () {
            var currentBrowser, _a, newBrowser_1, name_1, newState;
            return __generator(this, function (_b) {
                switch (_b.label) {
                    case 0:
                        currentBrowser = this.browsers[this.activeBrowser];
                        if (!(currentBrowser == 'CLOSED' || !currentBrowser)) return [3 /*break*/, 2];
                        return [4 /*yield*/, _newBrowser()];
                    case 1:
                        _a = _b.sent(), newBrowser_1 = _a[0], name_1 = _a[1];
                        newState = new BrowserState(name_1, newBrowser_1);
                        this.browsers[this.activeBrowser] = newState;
                        return [2 /*return*/, newState];
                    case 2: return [2 /*return*/, currentBrowser];
                }
            });
        });
    };
    PlaywrightState.prototype.addElement = function (id, handle) {
        this.elementHandles.set(id, handle);
    };
    PlaywrightState.prototype.getElement = function (id) {
        if (this.elementHandles.has(id)) {
            return this.elementHandles.get(id);
        }
        throw new Error("No element handle found with id `" + id + "`.");
    };
    return PlaywrightState;
}());
exports.PlaywrightState = PlaywrightState;
var BrowserState = /** @class */ (function () {
    function BrowserState(name, browser, context, page) {
        this.name = name;
        this.browser = browser;
        this.context = context ? { c: context, index: 0 } : undefined;
        this.page = page ? { p: page, index: 0 } : undefined;
    }
    BrowserState.prototype.close = function () {
        return __awaiter(this, void 0, void 0, function () {
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        this.context = undefined;
                        this.page = undefined;
                        return [4 /*yield*/, this.browser.close()];
                    case 1:
                        _a.sent();
                        return [2 /*return*/];
                }
            });
        });
    };
    BrowserState.prototype.getOrCreateActiveContext = function () {
        return __awaiter(this, void 0, void 0, function () {
            var browser, context;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!this.context) return [3 /*break*/, 1];
                        return [2 /*return*/, this.context];
                    case 1:
                        browser = this.browser;
                        return [4 /*yield*/, _newBrowserContext(browser)];
                    case 2:
                        context = _a.sent();
                        this.context = context;
                        return [2 /*return*/, context];
                }
            });
        });
    };
    Object.defineProperty(BrowserState.prototype, "context", {
        get: function () {
            return this._context;
        },
        set: function (newContext) {
            this._context = newContext;
            if (!newContext)
                console.log('Set active context to undefined');
            else
                console.log('Changed active context');
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BrowserState.prototype, "page", {
        get: function () {
            return this._page;
        },
        set: function (newPage) {
            this._page = newPage;
            if (!newPage)
                console.log('Set active page to undefined');
            else
                console.log('Changed active page');
        },
        enumerable: false,
        configurable: true
    });
    return BrowserState;
}());
exports.BrowserState = BrowserState;
function closeBrowser(callback, openBrowsers) {
    return __awaiter(this, void 0, void 0, function () {
        var index, currentBrowser, newIndex, activeBrowser;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    index = openBrowsers.activeBrowser;
                    currentBrowser = openBrowsers.browsers[index];
                    if (currentBrowser === 'CLOSED') {
                        callback(new Error("Tried to close Browser " + index + ", was already closed."), null);
                        return [2 /*return*/];
                    }
                    return [4 /*yield*/, currentBrowser.close()];
                case 1:
                    _a.sent();
                    openBrowsers.browsers[index] = 'CLOSED';
                    newIndex = openBrowsers.browsers.findIndex(function (element) { return element !== 'CLOSED'; });
                    openBrowsers.activeBrowser = newIndex;
                    activeBrowser = openBrowsers.browsers[newIndex];
                    if (!(activeBrowser && activeBrowser !== 'CLOSED')) return [3 /*break*/, 4];
                    return [4 /*yield*/, _switchContext(0, activeBrowser).catch(function (_) {
                            return console.log("Couldn't change active Context after closing browser");
                        })];
                case 2:
                    _a.sent();
                    return [4 /*yield*/, _switchPage(0, activeBrowser).catch(function (_) {
                            return console.log("Couldn't change active Page after closing browser");
                        })];
                case 3:
                    _a.sent();
                    _a.label = 4;
                case 4:
                    callback(null, response_util_1.emptyWithLog('Closed browser'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.closeBrowser = closeBrowser;
function closeAllBrowsers(callback, openBrowsers) {
    return __awaiter(this, void 0, void 0, function () {
        var browsers, i, b;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    browsers = openBrowsers.browsers;
                    i = 0;
                    _a.label = 1;
                case 1:
                    if (!(i < browsers.length)) return [3 /*break*/, 5];
                    b = browsers[i];
                    if (!(b !== 'CLOSED')) return [3 /*break*/, 3];
                    return [4 /*yield*/, b.close()];
                case 2:
                    _a.sent();
                    _a.label = 3;
                case 3:
                    openBrowsers.browsers[i] = 'CLOSED';
                    _a.label = 4;
                case 4:
                    i++;
                    return [3 /*break*/, 1];
                case 5:
                    openBrowsers.activeBrowser = 0;
                    callback(null, response_util_1.emptyWithLog('Closed all browsers'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.closeAllBrowsers = closeAllBrowsers;
function closeContext(callback, openBrowsers) {
    var _a;
    return __awaiter(this, void 0, void 0, function () {
        var activeBrowser;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    activeBrowser = openBrowsers.getActiveBrowser(callback);
                    return [4 /*yield*/, ((_a = openBrowsers.getActiveContext()) === null || _a === void 0 ? void 0 : _a.close())];
                case 1:
                    _b.sent();
                    return [4 /*yield*/, _switchContext(0, activeBrowser).catch(function (_) { return console.log("Couldn't change active Context after closing"); })];
                case 2:
                    _b.sent();
                    return [4 /*yield*/, _switchPage(0, activeBrowser).catch(function (_) { return console.log("Couldn't change active Page after closing Context"); })];
                case 3:
                    _b.sent();
                    callback(null, response_util_1.emptyWithLog('Succesfully closed Context'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.closeContext = closeContext;
function closePage(callback, openBrowsers) {
    var _a;
    return __awaiter(this, void 0, void 0, function () {
        var activeBrowser;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    activeBrowser = openBrowsers.getActiveBrowser(callback);
                    return [4 /*yield*/, ((_a = openBrowsers.getActivePage()) === null || _a === void 0 ? void 0 : _a.close())];
                case 1:
                    _b.sent();
                    return [4 /*yield*/, _switchPage(0, activeBrowser).catch(function (_) { return console.log("Couldn't change active Page after closing Page"); })];
                case 2:
                    _b.sent();
                    callback(null, response_util_1.emptyWithLog('Succesfully closed Page'));
                    return [2 /*return*/];
            }
        });
    });
}
exports.closePage = closePage;
function newPage(call, callback, openBrowsers) {
    return __awaiter(this, void 0, void 0, function () {
        var browserState, context, page, url, response;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0: return [4 /*yield*/, openBrowsers.getOrCreateActiveBrowser()];
                case 1:
                    browserState = _a.sent();
                    return [4 /*yield*/, browserState.getOrCreateActiveContext()];
                case 2:
                    context = _a.sent();
                    return [4 /*yield*/, _newPage(context.c)];
                case 3:
                    page = _a.sent();
                    browserState.page = page;
                    url = call.request.getUrl() || 'about:blank';
                    return [4 /*yield*/, playwirght_invoke_1.invokeOnPage(page.p, callback, 'goto', url, { timeout: 10000 })];
                case 4:
                    _a.sent();
                    response = response_util_1.intResponse(page.index);
                    response.setLog('Succesfully initialized new page object and opened url');
                    callback(null, response);
                    return [2 /*return*/];
            }
        });
    });
}
exports.newPage = newPage;
function newContext(call, callback, openBrowsers) {
    return __awaiter(this, void 0, void 0, function () {
        var hideRfBrowser, browserState, options, context, response, error_1;
        return __generator(this, function (_a) {
            switch (_a.label) {
                case 0:
                    hideRfBrowser = call.request.getHiderfbrowser();
                    return [4 /*yield*/, openBrowsers.getOrCreateActiveBrowser()];
                case 1:
                    browserState = _a.sent();
                    _a.label = 2;
                case 2:
                    _a.trys.push([2, 4, , 5]);
                    options = JSON.parse(call.request.getRawoptions());
                    return [4 /*yield*/, _newBrowserContext(browserState.browser, options, hideRfBrowser)];
                case 3:
                    context = _a.sent();
                    browserState.context = context;
                    response = response_util_1.intResponse(context.index);
                    response.setLog("Succesfully created context with options " + options);
                    callback(null, response);
                    return [3 /*break*/, 5];
                case 4:
                    error_1 = _a.sent();
                    callback(error_1, null);
                    return [2 /*return*/];
                case 5: return [2 /*return*/];
            }
        });
    });
}
exports.newContext = newContext;
function newBrowser(call, callback, openBrowsers) {
    return __awaiter(this, void 0, void 0, function () {
        var browserType, headless, options, _a, browser, name_2, browserState, newIndex, response, error_2;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    browserType = call.request.getBrowser();
                    headless = call.request.getHeadless();
                    _b.label = 1;
                case 1:
                    _b.trys.push([1, 3, , 4]);
                    options = JSON.parse(call.request.getRawoptions());
                    return [4 /*yield*/, _newBrowser(browserType, headless, options)];
                case 2:
                    _a = _b.sent(), browser = _a[0], name_2 = _a[1];
                    browserState = new BrowserState(name_2, browser);
                    newIndex = openBrowsers.browsers.push(browserState) - 1;
                    openBrowsers.activeBrowser = newIndex;
                    response = response_util_1.intResponse(newIndex);
                    response.setLog('Succesfully created browser with options ${options}');
                    callback(null, response);
                    return [3 /*break*/, 4];
                case 3:
                    error_2 = _b.sent();
                    callback(error_2, null);
                    return [3 /*break*/, 4];
                case 4: return [2 /*return*/];
            }
        });
    });
}
exports.newBrowser = newBrowser;
function autoActivatePages(call, callback, browserState) {
    var _a;
    return __awaiter(this, void 0, void 0, function () {
        return __generator(this, function (_b) {
            playwirght_invoke_1.exists((_a = browserState === null || browserState === void 0 ? void 0 : browserState.context) === null || _a === void 0 ? void 0 : _a.c, callback, 'Tried to focus next opened page, no context was open in current Browser');
            browserState.context.c.on('page', function (page) {
                var _a, _b;
                var pageIndex = (_b = (_a = browserState === null || browserState === void 0 ? void 0 : browserState.context) === null || _a === void 0 ? void 0 : _a.c) === null || _b === void 0 ? void 0 : _b.pages().length;
                browserState.page = { index: pageIndex || 0, p: page };
                console.log('Changed active page');
            });
            callback(null, response_util_1.emptyWithLog('Will focus future ``pages`` in this context'));
            return [2 /*return*/];
        });
    });
}
exports.autoActivatePages = autoActivatePages;
function _switchPage(index, browserState) {
    var _a;
    return __awaiter(this, void 0, void 0, function () {
        var context, pages, page, pwError_1, mapped, message, error;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    context = (_a = browserState.context) === null || _a === void 0 ? void 0 : _a.c;
                    if (!context)
                        throw new Error('Tried to switch page, no open context');
                    pages = context.pages();
                    if (!pages[index]) return [3 /*break*/, 1];
                    browserState.page = { index: index, p: pages[index] };
                    return [2 /*return*/];
                case 1:
                    _b.trys.push([1, 3, , 4]);
                    console.log('Started waiting for a page to pop up');
                    return [4 /*yield*/, context.waitForEvent('page')];
                case 2:
                    page = _b.sent();
                    browserState.page = { index: index, p: page };
                    return [2 /*return*/];
                case 3:
                    pwError_1 = _b.sent();
                    console.log('Wait was not fulfilled');
                    console.log(pwError_1);
                    mapped = pages === null || pages === void 0 ? void 0 : pages.map(function (p) { return p.url(); }).join(',');
                    message = "No page for index " + index + ". Open pages: " + mapped;
                    error = new Error(message);
                    throw error;
                case 4: return [2 /*return*/];
            }
        });
    });
}
function _switchContext(index, browserState) {
    return __awaiter(this, void 0, void 0, function () {
        var contexts, mapped, message, error;
        return __generator(this, function (_a) {
            contexts = browserState.browser.contexts();
            if (contexts && contexts[index]) {
                browserState.context = { index: index, c: contexts[index] };
                return [2 /*return*/];
            }
            else {
                mapped = contexts === null || contexts === void 0 ? void 0 : contexts.map(function (c) { return c.pages(); }).reduce(function (acc, val) { return acc.concat(val); }, []).map(function (p) { return p.url(); });
                message = "No context for index " + index + ". Open contexts: " + mapped;
                error = new Error(message);
                throw error;
            }
            return [2 /*return*/];
        });
    });
}
function switchPage(call, callback, browserState) {
    var _a;
    return __awaiter(this, void 0, void 0, function () {
        var index, previous, response;
        return __generator(this, function (_b) {
            switch (_b.label) {
                case 0:
                    playwirght_invoke_1.exists(browserState, callback, "Tried to switch Page but browser wasn't open");
                    console.log('Changing current active page');
                    index = call.request.getIndex();
                    previous = ((_a = browserState.page) === null || _a === void 0 ? void 0 : _a.index) || 0;
                    return [4 /*yield*/, _switchPage(index, browserState).catch(function (error) { return callback(error, null); })];
                case 1:
                    _b.sent();
                    response = response_util_1.intResponse(previous);
                    response.setLog('Succesfully changed active page');
                    callback(null, response);
                    return [2 /*return*/];
            }
        });
    });
}
exports.switchPage = switchPage;
function switchContext(call, callback, browserState) {
    var _a, _b;
    return __awaiter(this, void 0, void 0, function () {
        var index, previous, response;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    index = call.request.getIndex();
                    previous = ((_a = browserState.context) === null || _a === void 0 ? void 0 : _a.index) || 0;
                    return [4 /*yield*/, _switchContext(index, browserState).catch(function (error) { return callback(error, null); })];
                case 1:
                    _c.sent();
                    return [4 /*yield*/, _switchPage(((_b = browserState.page) === null || _b === void 0 ? void 0 : _b.index) || 0, browserState).catch(console.log)];
                case 2:
                    _c.sent();
                    response = response_util_1.intResponse(previous);
                    response.setLog('Succesfully changed active context');
                    callback(null, response);
                    return [2 /*return*/];
            }
        });
    });
}
exports.switchContext = switchContext;
function switchBrowser(call, callback, openBrowsers) {
    var _a, _b;
    return __awaiter(this, void 0, void 0, function () {
        var index, previous, switchedBrowser, pwError_2, response;
        return __generator(this, function (_c) {
            switch (_c.label) {
                case 0:
                    index = call.request.getIndex();
                    previous = openBrowsers.activeBrowser;
                    openBrowsers.activeBrowser = index;
                    switchedBrowser = openBrowsers.getActiveBrowser(callback);
                    _c.label = 1;
                case 1:
                    _c.trys.push([1, 4, , 5]);
                    // Try to switch to page and context in target browser
                    return [4 /*yield*/, _switchContext(((_a = switchedBrowser.context) === null || _a === void 0 ? void 0 : _a.index) || 0, switchedBrowser)];
                case 2:
                    // Try to switch to page and context in target browser
                    _c.sent();
                    return [4 /*yield*/, _switchPage(((_b = switchedBrowser.page) === null || _b === void 0 ? void 0 : _b.index) || 0, switchedBrowser)];
                case 3:
                    _c.sent();
                    return [3 /*break*/, 5];
                case 4:
                    pwError_2 = _c.sent();
                    console.log(pwError_2);
                    return [3 /*break*/, 5];
                case 5:
                    response = response_util_1.intResponse(previous);
                    response.setLog('Succesfully changed active browser');
                    callback(null, response);
                    return [2 /*return*/];
            }
        });
    });
}
exports.switchBrowser = switchBrowser;
function getBrowserCatalog(callback, openBrowsers) {
    return __awaiter(this, void 0, void 0, function () {
        var response, mappedBrowsers, _i, mappedBrowsers_1, b, contextList, _a, contextList_1, c, _b, _c, _d, i, page, t, url;
        return __generator(this, function (_e) {
            switch (_e.label) {
                case 0:
                    response = new playwright_pb_1.Response.String();
                    mappedBrowsers = openBrowsers.browsers.map(function (browser, index) {
                        var _a, _b;
                        if (browser !== 'CLOSED') {
                            var contexts = browser.browser.contexts().map(function (context, i) {
                                return {
                                    type: 'context',
                                    id: i,
                                    pages: context.pages(),
                                };
                            });
                            return {
                                type: browser.name,
                                id: index,
                                contexts: contexts,
                                activePage: (_a = browser.page) === null || _a === void 0 ? void 0 : _a.index,
                                activeContext: (_b = browser.context) === null || _b === void 0 ? void 0 : _b.index,
                                activeBrowser: openBrowsers.activeBrowser === index,
                            };
                        }
                        else {
                            return {
                                type: 'browser',
                                id: index,
                                state: 'CLOSED',
                            };
                        }
                    });
                    _i = 0, mappedBrowsers_1 = mappedBrowsers;
                    _e.label = 1;
                case 1:
                    if (!(_i < mappedBrowsers_1.length)) return [3 /*break*/, 8];
                    b = mappedBrowsers_1[_i];
                    contextList = b.contexts;
                    if (!contextList) return [3 /*break*/, 7];
                    _a = 0, contextList_1 = contextList;
                    _e.label = 2;
                case 2:
                    if (!(_a < contextList_1.length)) return [3 /*break*/, 7];
                    c = contextList_1[_a];
                    _b = [];
                    for (_c in c.pages)
                        _b.push(_c);
                    _d = 0;
                    _e.label = 3;
                case 3:
                    if (!(_d < _b.length)) return [3 /*break*/, 6];
                    i = _b[_d];
                    page = c.pages[i];
                    return [4 /*yield*/, page.title()];
                case 4:
                    t = _e.sent();
                    url = page.url();
                    c.pages[i] = {
                        type: 'page',
                        title: t,
                        url: url,
                        id: i,
                    };
                    _e.label = 5;
                case 5:
                    _d++;
                    return [3 /*break*/, 3];
                case 6:
                    _a++;
                    return [3 /*break*/, 2];
                case 7:
                    _i++;
                    return [3 /*break*/, 1];
                case 8:
                    response.setBody(JSON.stringify(mappedBrowsers));
                    callback(null, response);
                    return [2 /*return*/];
            }
        });
    });
}
exports.getBrowserCatalog = getBrowserCatalog;


/***/ }),

/***/ "./node/playwright-wrapper/response-util.ts":
/*!**************************************************!*\
  !*** ./node/playwright-wrapper/response-util.ts ***!
  \**************************************************/
/*! no static exports found */
/***/ (function(module, exports, __webpack_require__) {

"use strict";

Object.defineProperty(exports, "__esModule", { value: true });
exports.jsResponse = exports.boolResponse = exports.intResponse = exports.stringResponse = exports.emptyWithLog = void 0;
var playwright_pb_1 = __webpack_require__(/*! ./generated/playwright_pb */ "./node/playwright-wrapper/generated/playwright_pb.js");
function emptyWithLog(text) {
    var response = new playwright_pb_1.Response.Empty();
    response.setLog(text);
    return response;
}
exports.emptyWithLog = emptyWithLog;
function stringResponse(body) {
    var response = new playwright_pb_1.Response.String();
    response.setBody(body);
    return response;
}
exports.stringResponse = stringResponse;
function intResponse(body) {
    var response = new playwright_pb_1.Response.Int();
    response.setBody(body);
    return response;
}
exports.intResponse = intResponse;
function boolResponse(value) {
    var response = new playwright_pb_1.Response.Bool();
    response.setBody(value);
    return response;
}
exports.boolResponse = boolResponse;
function jsResponse(result) {
    var response = new playwright_pb_1.Response.JavascriptExecutionResult();
    response.setResult(JSON.stringify(result));
    return response;
}
exports.jsResponse = jsResponse;


/***/ }),

/***/ "./node_modules/google-protobuf/google-protobuf.js":
/*!*********************************************************!*\
  !*** ./node_modules/google-protobuf/google-protobuf.js ***!
  \*********************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

var $jscomp=$jscomp||{};$jscomp.scope={};$jscomp.findInternal=function(a,b,c){a instanceof String&&(a=String(a));for(var d=a.length,e=0;e<d;e++){var f=a[e];if(b.call(c,f,e,a))return{i:e,v:f}}return{i:-1,v:void 0}};$jscomp.ASSUME_ES5=!1;$jscomp.ASSUME_NO_NATIVE_MAP=!1;$jscomp.ASSUME_NO_NATIVE_SET=!1;$jscomp.SIMPLE_FROUND_POLYFILL=!1;
$jscomp.defineProperty=$jscomp.ASSUME_ES5||"function"==typeof Object.defineProperties?Object.defineProperty:function(a,b,c){a!=Array.prototype&&a!=Object.prototype&&(a[b]=c.value)};$jscomp.getGlobal=function(a){return"undefined"!=typeof window&&window===a?a:"undefined"!=typeof global&&null!=global?global:a};$jscomp.global=$jscomp.getGlobal(this);
$jscomp.polyfill=function(a,b,c,d){if(b){c=$jscomp.global;a=a.split(".");for(d=0;d<a.length-1;d++){var e=a[d];e in c||(c[e]={});c=c[e]}a=a[a.length-1];d=c[a];b=b(d);b!=d&&null!=b&&$jscomp.defineProperty(c,a,{configurable:!0,writable:!0,value:b})}};$jscomp.polyfill("Array.prototype.findIndex",function(a){return a?a:function(a,c){return $jscomp.findInternal(this,a,c).i}},"es6","es3");
$jscomp.checkStringArgs=function(a,b,c){if(null==a)throw new TypeError("The 'this' value for String.prototype."+c+" must not be null or undefined");if(b instanceof RegExp)throw new TypeError("First argument to String.prototype."+c+" must not be a regular expression");return a+""};
$jscomp.polyfill("String.prototype.startsWith",function(a){return a?a:function(a,c){var b=$jscomp.checkStringArgs(this,a,"startsWith");a+="";var e=b.length,f=a.length;c=Math.max(0,Math.min(c|0,b.length));for(var g=0;g<f&&c<e;)if(b[c++]!=a[g++])return!1;return g>=f}},"es6","es3");
$jscomp.polyfill("String.prototype.endsWith",function(a){return a?a:function(a,c){var b=$jscomp.checkStringArgs(this,a,"endsWith");a+="";void 0===c&&(c=b.length);c=Math.max(0,Math.min(c|0,b.length));for(var e=a.length;0<e&&0<c;)if(b[--c]!=a[--e])return!1;return 0>=e}},"es6","es3");
$jscomp.polyfill("String.prototype.repeat",function(a){return a?a:function(a){var b=$jscomp.checkStringArgs(this,null,"repeat");if(0>a||1342177279<a)throw new RangeError("Invalid count value");a|=0;for(var d="";a;)if(a&1&&(d+=b),a>>>=1)b+=b;return d}},"es6","es3");$jscomp.polyfill("Array.prototype.find",function(a){return a?a:function(a,c){return $jscomp.findInternal(this,a,c).v}},"es6","es3");var COMPILED=!0,goog=goog||{};goog.global=this;goog.isDef=function(a){return void 0!==a};
goog.isString=function(a){return"string"==typeof a};goog.isBoolean=function(a){return"boolean"==typeof a};goog.isNumber=function(a){return"number"==typeof a};goog.exportPath_=function(a,b,c){a=a.split(".");c=c||goog.global;a[0]in c||"undefined"==typeof c.execScript||c.execScript("var "+a[0]);for(var d;a.length&&(d=a.shift());)!a.length&&goog.isDef(b)?c[d]=b:c=c[d]&&c[d]!==Object.prototype[d]?c[d]:c[d]={}};
goog.define=function(a,b){if(!COMPILED){var c=goog.global.CLOSURE_UNCOMPILED_DEFINES,d=goog.global.CLOSURE_DEFINES;c&&void 0===c.nodeType&&Object.prototype.hasOwnProperty.call(c,a)?b=c[a]:d&&void 0===d.nodeType&&Object.prototype.hasOwnProperty.call(d,a)&&(b=d[a])}goog.exportPath_(a,b);return b};goog.DEBUG=!0;goog.LOCALE="en";goog.TRUSTED_SITE=!0;goog.STRICT_MODE_COMPATIBLE=!1;goog.DISALLOW_TEST_ONLY_CODE=COMPILED&&!goog.DEBUG;goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING=!1;
goog.provide=function(a){if(goog.isInModuleLoader_())throw Error("goog.provide cannot be used within a module.");if(!COMPILED&&goog.isProvided_(a))throw Error('Namespace "'+a+'" already declared.');goog.constructNamespace_(a)};goog.constructNamespace_=function(a,b){if(!COMPILED){delete goog.implicitNamespaces_[a];for(var c=a;(c=c.substring(0,c.lastIndexOf(".")))&&!goog.getObjectByName(c);)goog.implicitNamespaces_[c]=!0}goog.exportPath_(a,b)};
goog.getScriptNonce=function(a){if(a&&a!=goog.global)return goog.getScriptNonce_(a.document);null===goog.cspNonce_&&(goog.cspNonce_=goog.getScriptNonce_(goog.global.document));return goog.cspNonce_};goog.NONCE_PATTERN_=/^[\w+/_-]+[=]{0,2}$/;goog.cspNonce_=null;goog.getScriptNonce_=function(a){return(a=a.querySelector&&a.querySelector("script[nonce]"))&&(a=a.nonce||a.getAttribute("nonce"))&&goog.NONCE_PATTERN_.test(a)?a:""};goog.VALID_MODULE_RE_=/^[a-zA-Z_$][a-zA-Z0-9._$]*$/;
goog.module=function(a){if(!goog.isString(a)||!a||-1==a.search(goog.VALID_MODULE_RE_))throw Error("Invalid module identifier");if(!goog.isInGoogModuleLoader_())throw Error("Module "+a+" has been loaded incorrectly. Note, modules cannot be loaded as normal scripts. They require some kind of pre-processing step. You're likely trying to load a module via a script tag or as a part of a concatenated bundle without rewriting the module. For more info see: https://github.com/google/closure-library/wiki/goog.module:-an-ES6-module-like-alternative-to-goog.provide.");
if(goog.moduleLoaderState_.moduleName)throw Error("goog.module may only be called once per module.");goog.moduleLoaderState_.moduleName=a;if(!COMPILED){if(goog.isProvided_(a))throw Error('Namespace "'+a+'" already declared.');delete goog.implicitNamespaces_[a]}};goog.module.get=function(a){return goog.module.getInternal_(a)};
goog.module.getInternal_=function(a){if(!COMPILED){if(a in goog.loadedModules_)return goog.loadedModules_[a].exports;if(!goog.implicitNamespaces_[a])return a=goog.getObjectByName(a),null!=a?a:null}return null};goog.ModuleType={ES6:"es6",GOOG:"goog"};goog.moduleLoaderState_=null;goog.isInModuleLoader_=function(){return goog.isInGoogModuleLoader_()||goog.isInEs6ModuleLoader_()};goog.isInGoogModuleLoader_=function(){return!!goog.moduleLoaderState_&&goog.moduleLoaderState_.type==goog.ModuleType.GOOG};
goog.isInEs6ModuleLoader_=function(){if(goog.moduleLoaderState_&&goog.moduleLoaderState_.type==goog.ModuleType.ES6)return!0;var a=goog.global.$jscomp;return a?"function"!=typeof a.getCurrentModulePath?!1:!!a.getCurrentModulePath():!1};
goog.module.declareLegacyNamespace=function(){if(!COMPILED&&!goog.isInGoogModuleLoader_())throw Error("goog.module.declareLegacyNamespace must be called from within a goog.module");if(!COMPILED&&!goog.moduleLoaderState_.moduleName)throw Error("goog.module must be called prior to goog.module.declareLegacyNamespace.");goog.moduleLoaderState_.declareLegacyNamespace=!0};
goog.declareModuleId=function(a){if(!COMPILED){if(!goog.isInEs6ModuleLoader_())throw Error("goog.declareModuleId may only be called from within an ES6 module");if(goog.moduleLoaderState_&&goog.moduleLoaderState_.moduleName)throw Error("goog.declareModuleId may only be called once per module.");if(a in goog.loadedModules_)throw Error('Module with namespace "'+a+'" already exists.');}if(goog.moduleLoaderState_)goog.moduleLoaderState_.moduleName=a;else{var b=goog.global.$jscomp;if(!b||"function"!=typeof b.getCurrentModulePath)throw Error('Module with namespace "'+
a+'" has been loaded incorrectly.');b=b.require(b.getCurrentModulePath());goog.loadedModules_[a]={exports:b,type:goog.ModuleType.ES6,moduleId:a}}};goog.module.declareNamespace=goog.declareModuleId;goog.setTestOnly=function(a){if(goog.DISALLOW_TEST_ONLY_CODE)throw a=a||"",Error("Importing test-only code into non-debug environment"+(a?": "+a:"."));};goog.forwardDeclare=function(a){};
COMPILED||(goog.isProvided_=function(a){return a in goog.loadedModules_||!goog.implicitNamespaces_[a]&&goog.isDefAndNotNull(goog.getObjectByName(a))},goog.implicitNamespaces_={"goog.module":!0});goog.getObjectByName=function(a,b){a=a.split(".");b=b||goog.global;for(var c=0;c<a.length;c++)if(b=b[a[c]],!goog.isDefAndNotNull(b))return null;return b};goog.globalize=function(a,b){b=b||goog.global;for(var c in a)b[c]=a[c]};
goog.addDependency=function(a,b,c,d){!COMPILED&&goog.DEPENDENCIES_ENABLED&&goog.debugLoader_.addDependency(a,b,c,d)};goog.ENABLE_DEBUG_LOADER=!0;goog.logToConsole_=function(a){goog.global.console&&goog.global.console.error(a)};
goog.require=function(a){if(!COMPILED){goog.ENABLE_DEBUG_LOADER&&goog.debugLoader_.requested(a);if(goog.isProvided_(a)){if(goog.isInModuleLoader_())return goog.module.getInternal_(a)}else if(goog.ENABLE_DEBUG_LOADER){var b=goog.moduleLoaderState_;goog.moduleLoaderState_=null;try{goog.debugLoader_.load_(a)}finally{goog.moduleLoaderState_=b}}return null}};goog.requireType=function(a){return{}};goog.basePath="";goog.nullFunction=function(){};
goog.abstractMethod=function(){throw Error("unimplemented abstract method");};goog.addSingletonGetter=function(a){a.instance_=void 0;a.getInstance=function(){if(a.instance_)return a.instance_;goog.DEBUG&&(goog.instantiatedSingletons_[goog.instantiatedSingletons_.length]=a);return a.instance_=new a}};goog.instantiatedSingletons_=[];goog.LOAD_MODULE_USING_EVAL=!0;goog.SEAL_MODULE_EXPORTS=goog.DEBUG;goog.loadedModules_={};goog.DEPENDENCIES_ENABLED=!COMPILED&&goog.ENABLE_DEBUG_LOADER;goog.TRANSPILE="detect";
goog.ASSUME_ES_MODULES_TRANSPILED=!1;goog.TRANSPILE_TO_LANGUAGE="";goog.TRANSPILER="transpile.js";goog.hasBadLetScoping=null;goog.useSafari10Workaround=function(){if(null==goog.hasBadLetScoping){try{var a=!eval('"use strict";let x = 1; function f() { return typeof x; };f() == "number";')}catch(b){a=!1}goog.hasBadLetScoping=a}return goog.hasBadLetScoping};goog.workaroundSafari10EvalBug=function(a){return"(function(){"+a+"\n;})();\n"};
goog.loadModule=function(a){var b=goog.moduleLoaderState_;try{goog.moduleLoaderState_={moduleName:"",declareLegacyNamespace:!1,type:goog.ModuleType.GOOG};if(goog.isFunction(a))var c=a.call(void 0,{});else if(goog.isString(a))goog.useSafari10Workaround()&&(a=goog.workaroundSafari10EvalBug(a)),c=goog.loadModuleFromSource_.call(void 0,a);else throw Error("Invalid module definition");var d=goog.moduleLoaderState_.moduleName;if(goog.isString(d)&&d)goog.moduleLoaderState_.declareLegacyNamespace?goog.constructNamespace_(d,
c):goog.SEAL_MODULE_EXPORTS&&Object.seal&&"object"==typeof c&&null!=c&&Object.seal(c),goog.loadedModules_[d]={exports:c,type:goog.ModuleType.GOOG,moduleId:goog.moduleLoaderState_.moduleName};else throw Error('Invalid module name "'+d+'"');}finally{goog.moduleLoaderState_=b}};goog.loadModuleFromSource_=function(a){eval(a);return{}};goog.normalizePath_=function(a){a=a.split("/");for(var b=0;b<a.length;)"."==a[b]?a.splice(b,1):b&&".."==a[b]&&a[b-1]&&".."!=a[b-1]?a.splice(--b,2):b++;return a.join("/")};
goog.loadFileSync_=function(a){if(goog.global.CLOSURE_LOAD_FILE_SYNC)return goog.global.CLOSURE_LOAD_FILE_SYNC(a);try{var b=new goog.global.XMLHttpRequest;b.open("get",a,!1);b.send();return 0==b.status||200==b.status?b.responseText:null}catch(c){return null}};
goog.transpile_=function(a,b,c){var d=goog.global.$jscomp;d||(goog.global.$jscomp=d={});var e=d.transpile;if(!e){var f=goog.basePath+goog.TRANSPILER,g=goog.loadFileSync_(f);if(g){(function(){eval(g+"\n//# sourceURL="+f)}).call(goog.global);if(goog.global.$gwtExport&&goog.global.$gwtExport.$jscomp&&!goog.global.$gwtExport.$jscomp.transpile)throw Error('The transpiler did not properly export the "transpile" method. $gwtExport: '+JSON.stringify(goog.global.$gwtExport));goog.global.$jscomp.transpile=
goog.global.$gwtExport.$jscomp.transpile;d=goog.global.$jscomp;e=d.transpile}}e||(e=d.transpile=function(a,b){goog.logToConsole_(b+" requires transpilation but no transpiler was found.");return a});return e(a,b,c)};
goog.typeOf=function(a){var b=typeof a;if("object"==b)if(a){if(a instanceof Array)return"array";if(a instanceof Object)return b;var c=Object.prototype.toString.call(a);if("[object Window]"==c)return"object";if("[object Array]"==c||"number"==typeof a.length&&"undefined"!=typeof a.splice&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("splice"))return"array";if("[object Function]"==c||"undefined"!=typeof a.call&&"undefined"!=typeof a.propertyIsEnumerable&&!a.propertyIsEnumerable("call"))return"function"}else return"null";
else if("function"==b&&"undefined"==typeof a.call)return"object";return b};goog.isNull=function(a){return null===a};goog.isDefAndNotNull=function(a){return null!=a};goog.isArray=function(a){return"array"==goog.typeOf(a)};goog.isArrayLike=function(a){var b=goog.typeOf(a);return"array"==b||"object"==b&&"number"==typeof a.length};goog.isDateLike=function(a){return goog.isObject(a)&&"function"==typeof a.getFullYear};goog.isFunction=function(a){return"function"==goog.typeOf(a)};
goog.isObject=function(a){var b=typeof a;return"object"==b&&null!=a||"function"==b};goog.getUid=function(a){return a[goog.UID_PROPERTY_]||(a[goog.UID_PROPERTY_]=++goog.uidCounter_)};goog.hasUid=function(a){return!!a[goog.UID_PROPERTY_]};goog.removeUid=function(a){null!==a&&"removeAttribute"in a&&a.removeAttribute(goog.UID_PROPERTY_);try{delete a[goog.UID_PROPERTY_]}catch(b){}};goog.UID_PROPERTY_="closure_uid_"+(1E9*Math.random()>>>0);goog.uidCounter_=0;goog.getHashCode=goog.getUid;
goog.removeHashCode=goog.removeUid;goog.cloneObject=function(a){var b=goog.typeOf(a);if("object"==b||"array"==b){if("function"===typeof a.clone)return a.clone();b="array"==b?[]:{};for(var c in a)b[c]=goog.cloneObject(a[c]);return b}return a};goog.bindNative_=function(a,b,c){return a.call.apply(a.bind,arguments)};
goog.bindJs_=function(a,b,c){if(!a)throw Error();if(2<arguments.length){var d=Array.prototype.slice.call(arguments,2);return function(){var c=Array.prototype.slice.call(arguments);Array.prototype.unshift.apply(c,d);return a.apply(b,c)}}return function(){return a.apply(b,arguments)}};goog.bind=function(a,b,c){Function.prototype.bind&&-1!=Function.prototype.bind.toString().indexOf("native code")?goog.bind=goog.bindNative_:goog.bind=goog.bindJs_;return goog.bind.apply(null,arguments)};
goog.partial=function(a,b){var c=Array.prototype.slice.call(arguments,1);return function(){var b=c.slice();b.push.apply(b,arguments);return a.apply(this,b)}};goog.mixin=function(a,b){for(var c in b)a[c]=b[c]};goog.now=goog.TRUSTED_SITE&&Date.now||function(){return+new Date};
goog.globalEval=function(a){if(goog.global.execScript)goog.global.execScript(a,"JavaScript");else if(goog.global.eval){if(null==goog.evalWorksForGlobals_){try{goog.global.eval("var _evalTest_ = 1;")}catch(d){}if("undefined"!=typeof goog.global._evalTest_){try{delete goog.global._evalTest_}catch(d){}goog.evalWorksForGlobals_=!0}else goog.evalWorksForGlobals_=!1}if(goog.evalWorksForGlobals_)goog.global.eval(a);else{var b=goog.global.document,c=b.createElement("SCRIPT");c.type="text/javascript";c.defer=
!1;c.appendChild(b.createTextNode(a));b.head.appendChild(c);b.head.removeChild(c)}}else throw Error("goog.globalEval not available");};goog.evalWorksForGlobals_=null;
goog.getCssName=function(a,b){if("."==String(a).charAt(0))throw Error('className passed in goog.getCssName must not start with ".". You passed: '+a);var c=function(a){return goog.cssNameMapping_[a]||a},d=function(a){a=a.split("-");for(var b=[],d=0;d<a.length;d++)b.push(c(a[d]));return b.join("-")};d=goog.cssNameMapping_?"BY_WHOLE"==goog.cssNameMappingStyle_?c:d:function(a){return a};a=b?a+"-"+d(b):d(a);return goog.global.CLOSURE_CSS_NAME_MAP_FN?goog.global.CLOSURE_CSS_NAME_MAP_FN(a):a};
goog.setCssNameMapping=function(a,b){goog.cssNameMapping_=a;goog.cssNameMappingStyle_=b};!COMPILED&&goog.global.CLOSURE_CSS_NAME_MAPPING&&(goog.cssNameMapping_=goog.global.CLOSURE_CSS_NAME_MAPPING);goog.getMsg=function(a,b){b&&(a=a.replace(/\{\$([^}]+)}/g,function(a,d){return null!=b&&d in b?b[d]:a}));return a};goog.getMsgWithFallback=function(a,b){return a};goog.exportSymbol=function(a,b,c){goog.exportPath_(a,b,c)};goog.exportProperty=function(a,b,c){a[b]=c};
goog.inherits=function(a,b){function c(){}c.prototype=b.prototype;a.superClass_=b.prototype;a.prototype=new c;a.prototype.constructor=a;a.base=function(a,c,f){for(var d=Array(arguments.length-2),e=2;e<arguments.length;e++)d[e-2]=arguments[e];return b.prototype[c].apply(a,d)}};
goog.base=function(a,b,c){var d=arguments.callee.caller;if(goog.STRICT_MODE_COMPATIBLE||goog.DEBUG&&!d)throw Error("arguments.caller not defined.  goog.base() cannot be used with strict mode code. See http://www.ecma-international.org/ecma-262/5.1/#sec-C");if("undefined"!==typeof d.superClass_){for(var e=Array(arguments.length-1),f=1;f<arguments.length;f++)e[f-1]=arguments[f];return d.superClass_.constructor.apply(a,e)}if("string"!=typeof b&&"symbol"!=typeof b)throw Error("method names provided to goog.base must be a string or a symbol");
e=Array(arguments.length-2);for(f=2;f<arguments.length;f++)e[f-2]=arguments[f];f=!1;for(var g=a.constructor;g;g=g.superClass_&&g.superClass_.constructor)if(g.prototype[b]===d)f=!0;else if(f)return g.prototype[b].apply(a,e);if(a[b]===d)return a.constructor.prototype[b].apply(a,e);throw Error("goog.base called from a method of one name to a method of a different name");};goog.scope=function(a){if(goog.isInModuleLoader_())throw Error("goog.scope is not supported within a module.");a.call(goog.global)};
COMPILED||(goog.global.COMPILED=COMPILED);goog.defineClass=function(a,b){var c=b.constructor,d=b.statics;c&&c!=Object.prototype.constructor||(c=function(){throw Error("cannot instantiate an interface (no constructor defined).");});c=goog.defineClass.createSealingConstructor_(c,a);a&&goog.inherits(c,a);delete b.constructor;delete b.statics;goog.defineClass.applyProperties_(c.prototype,b);null!=d&&(d instanceof Function?d(c):goog.defineClass.applyProperties_(c,d));return c};
goog.defineClass.SEAL_CLASS_INSTANCES=goog.DEBUG;goog.defineClass.createSealingConstructor_=function(a,b){if(!goog.defineClass.SEAL_CLASS_INSTANCES)return a;var c=!goog.defineClass.isUnsealable_(b),d=function(){var b=a.apply(this,arguments)||this;b[goog.UID_PROPERTY_]=b[goog.UID_PROPERTY_];this.constructor===d&&c&&Object.seal instanceof Function&&Object.seal(b);return b};return d};goog.defineClass.isUnsealable_=function(a){return a&&a.prototype&&a.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]};
goog.defineClass.OBJECT_PROTOTYPE_FIELDS_="constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" ");goog.defineClass.applyProperties_=function(a,b){for(var c in b)Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c]);for(var d=0;d<goog.defineClass.OBJECT_PROTOTYPE_FIELDS_.length;d++)c=goog.defineClass.OBJECT_PROTOTYPE_FIELDS_[d],Object.prototype.hasOwnProperty.call(b,c)&&(a[c]=b[c])};
goog.tagUnsealableClass=function(a){!COMPILED&&goog.defineClass.SEAL_CLASS_INSTANCES&&(a.prototype[goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_]=!0)};goog.UNSEALABLE_CONSTRUCTOR_PROPERTY_="goog_defineClass_legacy_unsealable";
!COMPILED&&goog.DEPENDENCIES_ENABLED&&(goog.inHtmlDocument_=function(){var a=goog.global.document;return null!=a&&"write"in a},goog.isDocumentLoading_=function(){var a=goog.global.document;return a.attachEvent?"complete"!=a.readyState:"loading"==a.readyState},goog.findBasePath_=function(){if(goog.isDef(goog.global.CLOSURE_BASE_PATH)&&goog.isString(goog.global.CLOSURE_BASE_PATH))goog.basePath=goog.global.CLOSURE_BASE_PATH;else if(goog.inHtmlDocument_()){var a=goog.global.document,b=a.currentScript;
a=b?[b]:a.getElementsByTagName("SCRIPT");for(b=a.length-1;0<=b;--b){var c=a[b].src,d=c.lastIndexOf("?");d=-1==d?c.length:d;if("base.js"==c.substr(d-7,7)){goog.basePath=c.substr(0,d-7);break}}}},goog.findBasePath_(),goog.Transpiler=function(){this.requiresTranspilation_=null;this.transpilationTarget_=goog.TRANSPILE_TO_LANGUAGE},goog.Transpiler.prototype.createRequiresTranspilation_=function(){function a(a,b){e?d[a]=!0:b()?(c=a,d[a]=!1):e=d[a]=!0}function b(a){try{return!!eval(a)}catch(h){return!1}}
var c="es3",d={es3:!1},e=!1,f=goog.global.navigator&&goog.global.navigator.userAgent?goog.global.navigator.userAgent:"";a("es5",function(){return b("[1,].length==1")});a("es6",function(){return f.match(/Edge\/(\d+)(\.\d)*/i)?!1:b('(()=>{"use strict";class X{constructor(){if(new.target!=String)throw 1;this.x=42}}let q=Reflect.construct(X,[],String);if(q.x!=42||!(q instanceof String))throw 1;for(const a of[2,3]){if(a==2)continue;function f(z={a}){let a=0;return z.a}{function f(){return 0;}}return f()==3}})()')});
a("es6-impl",function(){return!0});a("es7",function(){return b("2 ** 2 == 4")});a("es8",function(){return b("async () => 1, true")});a("es9",function(){return b("({...rest} = {}), true")});a("es_next",function(){return!1});return{target:c,map:d}},goog.Transpiler.prototype.needsTranspile=function(a,b){if("always"==goog.TRANSPILE)return!0;if("never"==goog.TRANSPILE)return!1;if(!this.requiresTranspilation_){var c=this.createRequiresTranspilation_();this.requiresTranspilation_=c.map;this.transpilationTarget_=
this.transpilationTarget_||c.target}if(a in this.requiresTranspilation_)return this.requiresTranspilation_[a]?!0:!goog.inHtmlDocument_()||"es6"!=b||"noModule"in goog.global.document.createElement("script")?!1:!0;throw Error("Unknown language mode: "+a);},goog.Transpiler.prototype.transpile=function(a,b){return goog.transpile_(a,b,this.transpilationTarget_)},goog.transpiler_=new goog.Transpiler,goog.protectScriptTag_=function(a){return a.replace(/<\/(SCRIPT)/ig,"\\x3c/$1")},goog.DebugLoader_=function(){this.dependencies_=
{};this.idToPath_={};this.written_={};this.loadingDeps_=[];this.depsToLoad_=[];this.paused_=!1;this.factory_=new goog.DependencyFactory(goog.transpiler_);this.deferredCallbacks_={};this.deferredQueue_=[]},goog.DebugLoader_.prototype.bootstrap=function(a,b){function c(){d&&(goog.global.setTimeout(d,0),d=null)}var d=b;if(a.length){b=[];for(var e=0;e<a.length;e++){var f=this.getPathFromDeps_(a[e]);if(!f)throw Error("Unregonized namespace: "+a[e]);b.push(this.dependencies_[f])}f=goog.require;var g=0;
for(e=0;e<a.length;e++)f(a[e]),b[e].onLoad(function(){++g==a.length&&c()})}else c()},goog.DebugLoader_.prototype.loadClosureDeps=function(){this.depsToLoad_.push(this.factory_.createDependency(goog.normalizePath_(goog.basePath+"deps.js"),"deps.js",[],[],{},!1));this.loadDeps_()},goog.DebugLoader_.prototype.requested=function(a,b){(a=this.getPathFromDeps_(a))&&(b||this.areDepsLoaded_(this.dependencies_[a].requires))&&(b=this.deferredCallbacks_[a])&&(delete this.deferredCallbacks_[a],b())},goog.DebugLoader_.prototype.setDependencyFactory=
function(a){this.factory_=a},goog.DebugLoader_.prototype.load_=function(a){if(this.getPathFromDeps_(a)){var b=this,c=[],d=function(a){var e=b.getPathFromDeps_(a);if(!e)throw Error("Bad dependency path or symbol: "+a);if(!b.written_[e]){b.written_[e]=!0;a=b.dependencies_[e];for(e=0;e<a.requires.length;e++)goog.isProvided_(a.requires[e])||d(a.requires[e]);c.push(a)}};d(a);a=!!this.depsToLoad_.length;this.depsToLoad_=this.depsToLoad_.concat(c);this.paused_||a||this.loadDeps_()}else throw a="goog.require could not find: "+
a,goog.logToConsole_(a),Error(a);},goog.DebugLoader_.prototype.loadDeps_=function(){for(var a=this,b=this.paused_;this.depsToLoad_.length&&!b;)(function(){var c=!1,d=a.depsToLoad_.shift(),e=!1;a.loading_(d);var f={pause:function(){if(c)throw Error("Cannot call pause after the call to load.");b=!0},resume:function(){c?a.resume_():b=!1},loaded:function(){if(e)throw Error("Double call to loaded.");e=!0;a.loaded_(d)},pending:function(){for(var b=[],c=0;c<a.loadingDeps_.length;c++)b.push(a.loadingDeps_[c]);
return b},setModuleState:function(a){goog.moduleLoaderState_={type:a,moduleName:"",declareLegacyNamespace:!1}},registerEs6ModuleExports:function(a,b,c){c&&(goog.loadedModules_[c]={exports:b,type:goog.ModuleType.ES6,moduleId:c||""})},registerGoogModuleExports:function(a,b){goog.loadedModules_[a]={exports:b,type:goog.ModuleType.GOOG,moduleId:a}},clearModuleState:function(){goog.moduleLoaderState_=null},defer:function(b){if(c)throw Error("Cannot register with defer after the call to load.");a.defer_(d,
b)},areDepsLoaded:function(){return a.areDepsLoaded_(d.requires)}};try{d.load(f)}finally{c=!0}})();b&&this.pause_()},goog.DebugLoader_.prototype.pause_=function(){this.paused_=!0},goog.DebugLoader_.prototype.resume_=function(){this.paused_&&(this.paused_=!1,this.loadDeps_())},goog.DebugLoader_.prototype.loading_=function(a){this.loadingDeps_.push(a)},goog.DebugLoader_.prototype.loaded_=function(a){for(var b=0;b<this.loadingDeps_.length;b++)if(this.loadingDeps_[b]==a){this.loadingDeps_.splice(b,1);
break}for(b=0;b<this.deferredQueue_.length;b++)if(this.deferredQueue_[b]==a.path){this.deferredQueue_.splice(b,1);break}if(this.loadingDeps_.length==this.deferredQueue_.length&&!this.depsToLoad_.length)for(;this.deferredQueue_.length;)this.requested(this.deferredQueue_.shift(),!0);a.loaded()},goog.DebugLoader_.prototype.areDepsLoaded_=function(a){for(var b=0;b<a.length;b++){var c=this.getPathFromDeps_(a[b]);if(!c||!(c in this.deferredCallbacks_||goog.isProvided_(a[b])))return!1}return!0},goog.DebugLoader_.prototype.getPathFromDeps_=
function(a){return a in this.idToPath_?this.idToPath_[a]:a in this.dependencies_?a:null},goog.DebugLoader_.prototype.defer_=function(a,b){this.deferredCallbacks_[a.path]=b;this.deferredQueue_.push(a.path)},goog.LoadController=function(){},goog.LoadController.prototype.pause=function(){},goog.LoadController.prototype.resume=function(){},goog.LoadController.prototype.loaded=function(){},goog.LoadController.prototype.pending=function(){},goog.LoadController.prototype.registerEs6ModuleExports=function(a,
b,c){},goog.LoadController.prototype.setModuleState=function(a){},goog.LoadController.prototype.clearModuleState=function(){},goog.LoadController.prototype.defer=function(a){},goog.LoadController.prototype.areDepsLoaded=function(){},goog.Dependency=function(a,b,c,d,e){this.path=a;this.relativePath=b;this.provides=c;this.requires=d;this.loadFlags=e;this.loaded_=!1;this.loadCallbacks_=[]},goog.Dependency.prototype.getPathName=function(){var a=this.path,b=a.indexOf("://");0<=b&&(a=a.substring(b+3),b=
a.indexOf("/"),0<=b&&(a=a.substring(b+1)));return a},goog.Dependency.prototype.onLoad=function(a){this.loaded_?a():this.loadCallbacks_.push(a)},goog.Dependency.prototype.loaded=function(){this.loaded_=!0;var a=this.loadCallbacks_;this.loadCallbacks_=[];for(var b=0;b<a.length;b++)a[b]()},goog.Dependency.defer_=!1,goog.Dependency.callbackMap_={},goog.Dependency.registerCallback_=function(a){var b=Math.random().toString(32);goog.Dependency.callbackMap_[b]=a;return b},goog.Dependency.unregisterCallback_=
function(a){delete goog.Dependency.callbackMap_[a]},goog.Dependency.callback_=function(a,b){if(a in goog.Dependency.callbackMap_){for(var c=goog.Dependency.callbackMap_[a],d=[],e=1;e<arguments.length;e++)d.push(arguments[e]);c.apply(void 0,d)}else throw Error("Callback key "+a+" does not exist (was base.js loaded more than once?).");},goog.Dependency.prototype.load=function(a){if(goog.global.CLOSURE_IMPORT_SCRIPT)goog.global.CLOSURE_IMPORT_SCRIPT(this.path)?a.loaded():a.pause();else if(goog.inHtmlDocument_()){var b=
goog.global.document;if("complete"==b.readyState&&!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING){if(/\bdeps.js$/.test(this.path)){a.loaded();return}throw Error('Cannot write "'+this.path+'" after document load');}if(!goog.ENABLE_CHROME_APP_SAFE_SCRIPT_LOADING&&goog.isDocumentLoading_()){var c=goog.Dependency.registerCallback_(function(b){goog.DebugLoader_.IS_OLD_IE_&&"complete"!=b.readyState||(goog.Dependency.unregisterCallback_(c),a.loaded())}),d=!goog.DebugLoader_.IS_OLD_IE_&&goog.getScriptNonce()?
' nonce="'+goog.getScriptNonce()+'"':"";b.write('<script src="'+this.path+'" '+(goog.DebugLoader_.IS_OLD_IE_?"onreadystatechange":"onload")+"=\"goog.Dependency.callback_('"+c+'\', this)" type="text/javascript" '+(goog.Dependency.defer_?"defer":"")+d+">\x3c/script>")}else{var e=b.createElement("script");e.defer=goog.Dependency.defer_;e.async=!1;e.type="text/javascript";(d=goog.getScriptNonce())&&e.setAttribute("nonce",d);goog.DebugLoader_.IS_OLD_IE_?(a.pause(),e.onreadystatechange=function(){if("loaded"==
e.readyState||"complete"==e.readyState)a.loaded(),a.resume()}):e.onload=function(){e.onload=null;a.loaded()};e.src=this.path;b.head.appendChild(e)}}else goog.logToConsole_("Cannot use default debug loader outside of HTML documents."),"deps.js"==this.relativePath?(goog.logToConsole_("Consider setting CLOSURE_IMPORT_SCRIPT before loading base.js, or setting CLOSURE_NO_DEPS to true."),a.loaded()):a.pause()},goog.Es6ModuleDependency=function(a,b,c,d,e){goog.Dependency.call(this,a,b,c,d,e)},goog.inherits(goog.Es6ModuleDependency,
goog.Dependency),goog.Es6ModuleDependency.prototype.load=function(a){function b(a,b){b?d.write('<script type="module" crossorigin>'+b+"\x3c/script>"):d.write('<script type="module" crossorigin src="'+a+'">\x3c/script>')}function c(a,b){var c=d.createElement("script");c.defer=!0;c.async=!1;c.type="module";c.setAttribute("crossorigin",!0);var e=goog.getScriptNonce();e&&c.setAttribute("nonce",e);b?c.textContent=b:c.src=a;d.head.appendChild(c)}if(goog.global.CLOSURE_IMPORT_SCRIPT)goog.global.CLOSURE_IMPORT_SCRIPT(this.path)?
a.loaded():a.pause();else if(goog.inHtmlDocument_()){var d=goog.global.document,e=this;if(goog.isDocumentLoading_()){var f=b;goog.Dependency.defer_=!0}else f=c;var g=goog.Dependency.registerCallback_(function(){goog.Dependency.unregisterCallback_(g);a.setModuleState(goog.ModuleType.ES6)});f(void 0,'goog.Dependency.callback_("'+g+'")');f(this.path,void 0);var h=goog.Dependency.registerCallback_(function(b){goog.Dependency.unregisterCallback_(h);a.registerEs6ModuleExports(e.path,b,goog.moduleLoaderState_.moduleName)});
f(void 0,'import * as m from "'+this.path+'"; goog.Dependency.callback_("'+h+'", m)');var k=goog.Dependency.registerCallback_(function(){goog.Dependency.unregisterCallback_(k);a.clearModuleState();a.loaded()});f(void 0,'goog.Dependency.callback_("'+k+'")')}else goog.logToConsole_("Cannot use default debug loader outside of HTML documents."),a.pause()},goog.TransformedDependency=function(a,b,c,d,e){goog.Dependency.call(this,a,b,c,d,e);this.contents_=null;this.lazyFetch_=!goog.inHtmlDocument_()||!("noModule"in
goog.global.document.createElement("script"))},goog.inherits(goog.TransformedDependency,goog.Dependency),goog.TransformedDependency.prototype.load=function(a){function b(){e.contents_=goog.loadFileSync_(e.path);e.contents_&&(e.contents_=e.transform(e.contents_),e.contents_&&(e.contents_+="\n//# sourceURL="+e.path))}function c(){e.lazyFetch_&&b();if(e.contents_){f&&a.setModuleState(goog.ModuleType.ES6);try{var c=e.contents_;e.contents_=null;goog.globalEval(c);if(f)var d=goog.moduleLoaderState_.moduleName}finally{f&&
a.clearModuleState()}f&&goog.global.$jscomp.require.ensure([e.getPathName()],function(){a.registerEs6ModuleExports(e.path,goog.global.$jscomp.require(e.getPathName()),d)});a.loaded()}}function d(){var a=goog.global.document,b=goog.Dependency.registerCallback_(function(){goog.Dependency.unregisterCallback_(b);c()});a.write('<script type="text/javascript">'+goog.protectScriptTag_('goog.Dependency.callback_("'+b+'");')+"\x3c/script>")}var e=this;if(goog.global.CLOSURE_IMPORT_SCRIPT)b(),this.contents_&&
goog.global.CLOSURE_IMPORT_SCRIPT("",this.contents_)?(this.contents_=null,a.loaded()):a.pause();else{var f=this.loadFlags.module==goog.ModuleType.ES6;this.lazyFetch_||b();var g=1<a.pending().length,h=g&&goog.DebugLoader_.IS_OLD_IE_;g=goog.Dependency.defer_&&(g||goog.isDocumentLoading_());if(h||g)a.defer(function(){c()});else{var k=goog.global.document;h=goog.inHtmlDocument_()&&"ActiveXObject"in goog.global;if(f&&goog.inHtmlDocument_()&&goog.isDocumentLoading_()&&!h){goog.Dependency.defer_=!0;a.pause();
var l=k.onreadystatechange;k.onreadystatechange=function(){"interactive"==k.readyState&&(k.onreadystatechange=l,c(),a.resume());goog.isFunction(l)&&l.apply(void 0,arguments)}}else!goog.DebugLoader_.IS_OLD_IE_&&goog.inHtmlDocument_()&&goog.isDocumentLoading_()?d():c()}}},goog.TransformedDependency.prototype.transform=function(a){},goog.TranspiledDependency=function(a,b,c,d,e,f){goog.TransformedDependency.call(this,a,b,c,d,e);this.transpiler=f},goog.inherits(goog.TranspiledDependency,goog.TransformedDependency),
goog.TranspiledDependency.prototype.transform=function(a){return this.transpiler.transpile(a,this.getPathName())},goog.PreTranspiledEs6ModuleDependency=function(a,b,c,d,e){goog.TransformedDependency.call(this,a,b,c,d,e)},goog.inherits(goog.PreTranspiledEs6ModuleDependency,goog.TransformedDependency),goog.PreTranspiledEs6ModuleDependency.prototype.transform=function(a){return a},goog.GoogModuleDependency=function(a,b,c,d,e,f,g){goog.TransformedDependency.call(this,a,b,c,d,e);this.needsTranspile_=f;
this.transpiler_=g},goog.inherits(goog.GoogModuleDependency,goog.TransformedDependency),goog.GoogModuleDependency.prototype.transform=function(a){this.needsTranspile_&&(a=this.transpiler_.transpile(a,this.getPathName()));return goog.LOAD_MODULE_USING_EVAL&&goog.isDef(goog.global.JSON)?"goog.loadModule("+goog.global.JSON.stringify(a+"\n//# sourceURL="+this.path+"\n")+");":'goog.loadModule(function(exports) {"use strict";'+a+"\n;return exports});\n//# sourceURL="+this.path+"\n"},goog.DebugLoader_.IS_OLD_IE_=
!(goog.global.atob||!goog.global.document||!goog.global.document.all),goog.DebugLoader_.prototype.addDependency=function(a,b,c,d){b=b||[];a=a.replace(/\\/g,"/");var e=goog.normalizePath_(goog.basePath+a);d&&"boolean"!==typeof d||(d=d?{module:goog.ModuleType.GOOG}:{});c=this.factory_.createDependency(e,a,b,c,d,goog.transpiler_.needsTranspile(d.lang||"es3",d.module));this.dependencies_[e]=c;for(c=0;c<b.length;c++)this.idToPath_[b[c]]=e;this.idToPath_[a]=e},goog.DependencyFactory=function(a){this.transpiler=
a},goog.DependencyFactory.prototype.createDependency=function(a,b,c,d,e,f){return e.module==goog.ModuleType.GOOG?new goog.GoogModuleDependency(a,b,c,d,e,f,this.transpiler):f?new goog.TranspiledDependency(a,b,c,d,e,this.transpiler):e.module==goog.ModuleType.ES6?"never"==goog.TRANSPILE&&goog.ASSUME_ES_MODULES_TRANSPILED?new goog.PreTranspiledEs6ModuleDependency(a,b,c,d,e):new goog.Es6ModuleDependency(a,b,c,d,e):new goog.Dependency(a,b,c,d,e)},goog.debugLoader_=new goog.DebugLoader_,goog.loadClosureDeps=
function(){goog.debugLoader_.loadClosureDeps()},goog.setDependencyFactory=function(a){goog.debugLoader_.setDependencyFactory(a)},goog.global.CLOSURE_NO_DEPS||goog.debugLoader_.loadClosureDeps(),goog.bootstrap=function(a,b){goog.debugLoader_.bootstrap(a,b)});var jspb={BinaryConstants:{},ConstBinaryMessage:function(){},BinaryMessage:function(){}};jspb.BinaryConstants.FieldType={INVALID:-1,DOUBLE:1,FLOAT:2,INT64:3,UINT64:4,INT32:5,FIXED64:6,FIXED32:7,BOOL:8,STRING:9,GROUP:10,MESSAGE:11,BYTES:12,UINT32:13,ENUM:14,SFIXED32:15,SFIXED64:16,SINT32:17,SINT64:18,FHASH64:30,VHASH64:31};jspb.BinaryConstants.WireType={INVALID:-1,VARINT:0,FIXED64:1,DELIMITED:2,START_GROUP:3,END_GROUP:4,FIXED32:5};
jspb.BinaryConstants.FieldTypeToWireType=function(a){var b=jspb.BinaryConstants.FieldType,c=jspb.BinaryConstants.WireType;switch(a){case b.INT32:case b.INT64:case b.UINT32:case b.UINT64:case b.SINT32:case b.SINT64:case b.BOOL:case b.ENUM:case b.VHASH64:return c.VARINT;case b.DOUBLE:case b.FIXED64:case b.SFIXED64:case b.FHASH64:return c.FIXED64;case b.STRING:case b.MESSAGE:case b.BYTES:return c.DELIMITED;case b.FLOAT:case b.FIXED32:case b.SFIXED32:return c.FIXED32;default:return c.INVALID}};
jspb.BinaryConstants.INVALID_FIELD_NUMBER=-1;jspb.BinaryConstants.FLOAT32_EPS=1.401298464324817E-45;jspb.BinaryConstants.FLOAT32_MIN=1.1754943508222875E-38;jspb.BinaryConstants.FLOAT32_MAX=3.4028234663852886E38;jspb.BinaryConstants.FLOAT64_EPS=4.9E-324;jspb.BinaryConstants.FLOAT64_MIN=2.2250738585072014E-308;jspb.BinaryConstants.FLOAT64_MAX=1.7976931348623157E308;jspb.BinaryConstants.TWO_TO_20=1048576;jspb.BinaryConstants.TWO_TO_23=8388608;jspb.BinaryConstants.TWO_TO_31=2147483648;
jspb.BinaryConstants.TWO_TO_32=4294967296;jspb.BinaryConstants.TWO_TO_52=4503599627370496;jspb.BinaryConstants.TWO_TO_63=0x7fffffffffffffff;jspb.BinaryConstants.TWO_TO_64=1.8446744073709552E19;jspb.BinaryConstants.ZERO_HASH="\x00\x00\x00\x00\x00\x00\x00\x00";goog.dom={};goog.dom.NodeType={ELEMENT:1,ATTRIBUTE:2,TEXT:3,CDATA_SECTION:4,ENTITY_REFERENCE:5,ENTITY:6,PROCESSING_INSTRUCTION:7,COMMENT:8,DOCUMENT:9,DOCUMENT_TYPE:10,DOCUMENT_FRAGMENT:11,NOTATION:12};goog.debug={};goog.debug.Error=function(a){if(Error.captureStackTrace)Error.captureStackTrace(this,goog.debug.Error);else{var b=Error().stack;b&&(this.stack=b)}a&&(this.message=String(a));this.reportErrorToServer=!0};goog.inherits(goog.debug.Error,Error);goog.debug.Error.prototype.name="CustomError";goog.asserts={};goog.asserts.ENABLE_ASSERTS=goog.DEBUG;goog.asserts.AssertionError=function(a,b){goog.debug.Error.call(this,goog.asserts.subs_(a,b));this.messagePattern=a};goog.inherits(goog.asserts.AssertionError,goog.debug.Error);goog.asserts.AssertionError.prototype.name="AssertionError";goog.asserts.DEFAULT_ERROR_HANDLER=function(a){throw a;};goog.asserts.errorHandler_=goog.asserts.DEFAULT_ERROR_HANDLER;
goog.asserts.subs_=function(a,b){a=a.split("%s");for(var c="",d=a.length-1,e=0;e<d;e++)c+=a[e]+(e<b.length?b[e]:"%s");return c+a[d]};goog.asserts.doAssertFailure_=function(a,b,c,d){var e="Assertion failed";if(c){e+=": "+c;var f=d}else a&&(e+=": "+a,f=b);a=new goog.asserts.AssertionError(""+e,f||[]);goog.asserts.errorHandler_(a)};goog.asserts.setErrorHandler=function(a){goog.asserts.ENABLE_ASSERTS&&(goog.asserts.errorHandler_=a)};
goog.asserts.assert=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!a&&goog.asserts.doAssertFailure_("",null,b,Array.prototype.slice.call(arguments,2));return a};goog.asserts.fail=function(a,b){goog.asserts.ENABLE_ASSERTS&&goog.asserts.errorHandler_(new goog.asserts.AssertionError("Failure"+(a?": "+a:""),Array.prototype.slice.call(arguments,1)))};
goog.asserts.assertNumber=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!goog.isNumber(a)&&goog.asserts.doAssertFailure_("Expected number but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};goog.asserts.assertString=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!goog.isString(a)&&goog.asserts.doAssertFailure_("Expected string but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};
goog.asserts.assertFunction=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!goog.isFunction(a)&&goog.asserts.doAssertFailure_("Expected function but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};goog.asserts.assertObject=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!goog.isObject(a)&&goog.asserts.doAssertFailure_("Expected object but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};
goog.asserts.assertArray=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!goog.isArray(a)&&goog.asserts.doAssertFailure_("Expected array but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};goog.asserts.assertBoolean=function(a,b,c){goog.asserts.ENABLE_ASSERTS&&!goog.isBoolean(a)&&goog.asserts.doAssertFailure_("Expected boolean but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};
goog.asserts.assertElement=function(a,b,c){!goog.asserts.ENABLE_ASSERTS||goog.isObject(a)&&a.nodeType==goog.dom.NodeType.ELEMENT||goog.asserts.doAssertFailure_("Expected Element but got %s: %s.",[goog.typeOf(a),a],b,Array.prototype.slice.call(arguments,2));return a};
goog.asserts.assertInstanceof=function(a,b,c,d){!goog.asserts.ENABLE_ASSERTS||a instanceof b||goog.asserts.doAssertFailure_("Expected instanceof %s but got %s.",[goog.asserts.getType_(b),goog.asserts.getType_(a)],c,Array.prototype.slice.call(arguments,3));return a};goog.asserts.assertFinite=function(a,b,c){!goog.asserts.ENABLE_ASSERTS||"number"==typeof a&&isFinite(a)||goog.asserts.doAssertFailure_("Expected %s to be a finite number but it is not.",[a],b,Array.prototype.slice.call(arguments,2));return a};
goog.asserts.assertObjectPrototypeIsIntact=function(){for(var a in Object.prototype)goog.asserts.fail(a+" should not be enumerable in Object.prototype.")};goog.asserts.getType_=function(a){return a instanceof Function?a.displayName||a.name||"unknown type name":a instanceof Object?a.constructor.displayName||a.constructor.name||Object.prototype.toString.call(a):null===a?"null":typeof a};goog.array={};goog.NATIVE_ARRAY_PROTOTYPES=goog.TRUSTED_SITE;goog.array.ASSUME_NATIVE_FUNCTIONS=!1;goog.array.peek=function(a){return a[a.length-1]};goog.array.last=goog.array.peek;
goog.array.indexOf=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.indexOf)?function(a,b,c){goog.asserts.assert(null!=a.length);return Array.prototype.indexOf.call(a,b,c)}:function(a,b,c){c=null==c?0:0>c?Math.max(0,a.length+c):c;if(goog.isString(a))return goog.isString(b)&&1==b.length?a.indexOf(b,c):-1;for(;c<a.length;c++)if(c in a&&a[c]===b)return c;return-1};
goog.array.lastIndexOf=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.lastIndexOf)?function(a,b,c){goog.asserts.assert(null!=a.length);return Array.prototype.lastIndexOf.call(a,b,null==c?a.length-1:c)}:function(a,b,c){c=null==c?a.length-1:c;0>c&&(c=Math.max(0,a.length+c));if(goog.isString(a))return goog.isString(b)&&1==b.length?a.lastIndexOf(b,c):-1;for(;0<=c;c--)if(c in a&&a[c]===b)return c;return-1};
goog.array.forEach=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.forEach)?function(a,b,c){goog.asserts.assert(null!=a.length);Array.prototype.forEach.call(a,b,c)}:function(a,b,c){for(var d=a.length,e=goog.isString(a)?a.split(""):a,f=0;f<d;f++)f in e&&b.call(c,e[f],f,a)};goog.array.forEachRight=function(a,b,c){var d=a.length,e=goog.isString(a)?a.split(""):a;for(--d;0<=d;--d)d in e&&b.call(c,e[d],d,a)};
goog.array.filter=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.filter)?function(a,b,c){goog.asserts.assert(null!=a.length);return Array.prototype.filter.call(a,b,c)}:function(a,b,c){for(var d=a.length,e=[],f=0,g=goog.isString(a)?a.split(""):a,h=0;h<d;h++)if(h in g){var k=g[h];b.call(c,k,h,a)&&(e[f++]=k)}return e};
goog.array.map=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.map)?function(a,b,c){goog.asserts.assert(null!=a.length);return Array.prototype.map.call(a,b,c)}:function(a,b,c){for(var d=a.length,e=Array(d),f=goog.isString(a)?a.split(""):a,g=0;g<d;g++)g in f&&(e[g]=b.call(c,f[g],g,a));return e};
goog.array.reduce=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.reduce)?function(a,b,c,d){goog.asserts.assert(null!=a.length);d&&(b=goog.bind(b,d));return Array.prototype.reduce.call(a,b,c)}:function(a,b,c,d){var e=c;goog.array.forEach(a,function(c,g){e=b.call(d,e,c,g,a)});return e};
goog.array.reduceRight=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.reduceRight)?function(a,b,c,d){goog.asserts.assert(null!=a.length);goog.asserts.assert(null!=b);d&&(b=goog.bind(b,d));return Array.prototype.reduceRight.call(a,b,c)}:function(a,b,c,d){var e=c;goog.array.forEachRight(a,function(c,g){e=b.call(d,e,c,g,a)});return e};
goog.array.some=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.some)?function(a,b,c){goog.asserts.assert(null!=a.length);return Array.prototype.some.call(a,b,c)}:function(a,b,c){for(var d=a.length,e=goog.isString(a)?a.split(""):a,f=0;f<d;f++)if(f in e&&b.call(c,e[f],f,a))return!0;return!1};
goog.array.every=goog.NATIVE_ARRAY_PROTOTYPES&&(goog.array.ASSUME_NATIVE_FUNCTIONS||Array.prototype.every)?function(a,b,c){goog.asserts.assert(null!=a.length);return Array.prototype.every.call(a,b,c)}:function(a,b,c){for(var d=a.length,e=goog.isString(a)?a.split(""):a,f=0;f<d;f++)if(f in e&&!b.call(c,e[f],f,a))return!1;return!0};goog.array.count=function(a,b,c){var d=0;goog.array.forEach(a,function(a,f,g){b.call(c,a,f,g)&&++d},c);return d};
goog.array.find=function(a,b,c){b=goog.array.findIndex(a,b,c);return 0>b?null:goog.isString(a)?a.charAt(b):a[b]};goog.array.findIndex=function(a,b,c){for(var d=a.length,e=goog.isString(a)?a.split(""):a,f=0;f<d;f++)if(f in e&&b.call(c,e[f],f,a))return f;return-1};goog.array.findRight=function(a,b,c){b=goog.array.findIndexRight(a,b,c);return 0>b?null:goog.isString(a)?a.charAt(b):a[b]};
goog.array.findIndexRight=function(a,b,c){var d=a.length,e=goog.isString(a)?a.split(""):a;for(--d;0<=d;d--)if(d in e&&b.call(c,e[d],d,a))return d;return-1};goog.array.contains=function(a,b){return 0<=goog.array.indexOf(a,b)};goog.array.isEmpty=function(a){return 0==a.length};goog.array.clear=function(a){if(!goog.isArray(a))for(var b=a.length-1;0<=b;b--)delete a[b];a.length=0};goog.array.insert=function(a,b){goog.array.contains(a,b)||a.push(b)};
goog.array.insertAt=function(a,b,c){goog.array.splice(a,c,0,b)};goog.array.insertArrayAt=function(a,b,c){goog.partial(goog.array.splice,a,c,0).apply(null,b)};goog.array.insertBefore=function(a,b,c){var d;2==arguments.length||0>(d=goog.array.indexOf(a,c))?a.push(b):goog.array.insertAt(a,b,d)};goog.array.remove=function(a,b){b=goog.array.indexOf(a,b);var c;(c=0<=b)&&goog.array.removeAt(a,b);return c};
goog.array.removeLast=function(a,b){b=goog.array.lastIndexOf(a,b);return 0<=b?(goog.array.removeAt(a,b),!0):!1};goog.array.removeAt=function(a,b){goog.asserts.assert(null!=a.length);return 1==Array.prototype.splice.call(a,b,1).length};goog.array.removeIf=function(a,b,c){b=goog.array.findIndex(a,b,c);return 0<=b?(goog.array.removeAt(a,b),!0):!1};goog.array.removeAllIf=function(a,b,c){var d=0;goog.array.forEachRight(a,function(e,f){b.call(c,e,f,a)&&goog.array.removeAt(a,f)&&d++});return d};
goog.array.concat=function(a){return Array.prototype.concat.apply([],arguments)};goog.array.join=function(a){return Array.prototype.concat.apply([],arguments)};goog.array.toArray=function(a){var b=a.length;if(0<b){for(var c=Array(b),d=0;d<b;d++)c[d]=a[d];return c}return[]};goog.array.clone=goog.array.toArray;goog.array.extend=function(a,b){for(var c=1;c<arguments.length;c++){var d=arguments[c];if(goog.isArrayLike(d)){var e=a.length||0,f=d.length||0;a.length=e+f;for(var g=0;g<f;g++)a[e+g]=d[g]}else a.push(d)}};
goog.array.splice=function(a,b,c,d){goog.asserts.assert(null!=a.length);return Array.prototype.splice.apply(a,goog.array.slice(arguments,1))};goog.array.slice=function(a,b,c){goog.asserts.assert(null!=a.length);return 2>=arguments.length?Array.prototype.slice.call(a,b):Array.prototype.slice.call(a,b,c)};
goog.array.removeDuplicates=function(a,b,c){b=b||a;var d=function(a){return goog.isObject(a)?"o"+goog.getUid(a):(typeof a).charAt(0)+a};c=c||d;d={};for(var e=0,f=0;f<a.length;){var g=a[f++],h=c(g);Object.prototype.hasOwnProperty.call(d,h)||(d[h]=!0,b[e++]=g)}b.length=e};goog.array.binarySearch=function(a,b,c){return goog.array.binarySearch_(a,c||goog.array.defaultCompare,!1,b)};goog.array.binarySelect=function(a,b,c){return goog.array.binarySearch_(a,b,!0,void 0,c)};
goog.array.binarySearch_=function(a,b,c,d,e){for(var f=0,g=a.length,h;f<g;){var k=f+g>>1;var l=c?b.call(e,a[k],k,a):b(d,a[k]);0<l?f=k+1:(g=k,h=!l)}return h?f:~f};goog.array.sort=function(a,b){a.sort(b||goog.array.defaultCompare)};goog.array.stableSort=function(a,b){for(var c=Array(a.length),d=0;d<a.length;d++)c[d]={index:d,value:a[d]};var e=b||goog.array.defaultCompare;goog.array.sort(c,function(a,b){return e(a.value,b.value)||a.index-b.index});for(d=0;d<a.length;d++)a[d]=c[d].value};
goog.array.sortByKey=function(a,b,c){var d=c||goog.array.defaultCompare;goog.array.sort(a,function(a,c){return d(b(a),b(c))})};goog.array.sortObjectsByKey=function(a,b,c){goog.array.sortByKey(a,function(a){return a[b]},c)};goog.array.isSorted=function(a,b,c){b=b||goog.array.defaultCompare;for(var d=1;d<a.length;d++){var e=b(a[d-1],a[d]);if(0<e||0==e&&c)return!1}return!0};
goog.array.equals=function(a,b,c){if(!goog.isArrayLike(a)||!goog.isArrayLike(b)||a.length!=b.length)return!1;var d=a.length;c=c||goog.array.defaultCompareEquality;for(var e=0;e<d;e++)if(!c(a[e],b[e]))return!1;return!0};goog.array.compare3=function(a,b,c){c=c||goog.array.defaultCompare;for(var d=Math.min(a.length,b.length),e=0;e<d;e++){var f=c(a[e],b[e]);if(0!=f)return f}return goog.array.defaultCompare(a.length,b.length)};goog.array.defaultCompare=function(a,b){return a>b?1:a<b?-1:0};
goog.array.inverseDefaultCompare=function(a,b){return-goog.array.defaultCompare(a,b)};goog.array.defaultCompareEquality=function(a,b){return a===b};goog.array.binaryInsert=function(a,b,c){c=goog.array.binarySearch(a,b,c);return 0>c?(goog.array.insertAt(a,b,-(c+1)),!0):!1};goog.array.binaryRemove=function(a,b,c){b=goog.array.binarySearch(a,b,c);return 0<=b?goog.array.removeAt(a,b):!1};
goog.array.bucket=function(a,b,c){for(var d={},e=0;e<a.length;e++){var f=a[e],g=b.call(c,f,e,a);goog.isDef(g)&&(d[g]||(d[g]=[])).push(f)}return d};goog.array.toObject=function(a,b,c){var d={};goog.array.forEach(a,function(e,f){d[b.call(c,e,f,a)]=e});return d};goog.array.range=function(a,b,c){var d=[],e=0,f=a;c=c||1;void 0!==b&&(e=a,f=b);if(0>c*(f-e))return[];if(0<c)for(a=e;a<f;a+=c)d.push(a);else for(a=e;a>f;a+=c)d.push(a);return d};
goog.array.repeat=function(a,b){for(var c=[],d=0;d<b;d++)c[d]=a;return c};goog.array.flatten=function(a){for(var b=[],c=0;c<arguments.length;c++){var d=arguments[c];if(goog.isArray(d))for(var e=0;e<d.length;e+=8192){var f=goog.array.slice(d,e,e+8192);f=goog.array.flatten.apply(null,f);for(var g=0;g<f.length;g++)b.push(f[g])}else b.push(d)}return b};
goog.array.rotate=function(a,b){goog.asserts.assert(null!=a.length);a.length&&(b%=a.length,0<b?Array.prototype.unshift.apply(a,a.splice(-b,b)):0>b&&Array.prototype.push.apply(a,a.splice(0,-b)));return a};goog.array.moveItem=function(a,b,c){goog.asserts.assert(0<=b&&b<a.length);goog.asserts.assert(0<=c&&c<a.length);b=Array.prototype.splice.call(a,b,1);Array.prototype.splice.call(a,c,0,b[0])};
goog.array.zip=function(a){if(!arguments.length)return[];for(var b=[],c=arguments[0].length,d=1;d<arguments.length;d++)arguments[d].length<c&&(c=arguments[d].length);for(d=0;d<c;d++){for(var e=[],f=0;f<arguments.length;f++)e.push(arguments[f][d]);b.push(e)}return b};goog.array.shuffle=function(a,b){b=b||Math.random;for(var c=a.length-1;0<c;c--){var d=Math.floor(b()*(c+1)),e=a[c];a[c]=a[d];a[d]=e}};goog.array.copyByIndex=function(a,b){var c=[];goog.array.forEach(b,function(b){c.push(a[b])});return c};
goog.array.concatMap=function(a,b,c){return goog.array.concat.apply([],goog.array.map(a,b,c))};goog.crypt={};goog.crypt.stringToByteArray=function(a){for(var b=[],c=0,d=0;d<a.length;d++){var e=a.charCodeAt(d);255<e&&(b[c++]=e&255,e>>=8);b[c++]=e}return b};goog.crypt.byteArrayToString=function(a){if(8192>=a.length)return String.fromCharCode.apply(null,a);for(var b="",c=0;c<a.length;c+=8192){var d=goog.array.slice(a,c,c+8192);b+=String.fromCharCode.apply(null,d)}return b};
goog.crypt.byteArrayToHex=function(a,b){return goog.array.map(a,function(a){a=a.toString(16);return 1<a.length?a:"0"+a}).join(b||"")};goog.crypt.hexToByteArray=function(a){goog.asserts.assert(0==a.length%2,"Key string length must be multiple of 2");for(var b=[],c=0;c<a.length;c+=2)b.push(parseInt(a.substring(c,c+2),16));return b};
goog.crypt.stringToUtf8ByteArray=function(a){for(var b=[],c=0,d=0;d<a.length;d++){var e=a.charCodeAt(d);128>e?b[c++]=e:(2048>e?b[c++]=e>>6|192:(55296==(e&64512)&&d+1<a.length&&56320==(a.charCodeAt(d+1)&64512)?(e=65536+((e&1023)<<10)+(a.charCodeAt(++d)&1023),b[c++]=e>>18|240,b[c++]=e>>12&63|128):b[c++]=e>>12|224,b[c++]=e>>6&63|128),b[c++]=e&63|128)}return b};
goog.crypt.utf8ByteArrayToString=function(a){for(var b=[],c=0,d=0;c<a.length;){var e=a[c++];if(128>e)b[d++]=String.fromCharCode(e);else if(191<e&&224>e){var f=a[c++];b[d++]=String.fromCharCode((e&31)<<6|f&63)}else if(239<e&&365>e){f=a[c++];var g=a[c++],h=a[c++];e=((e&7)<<18|(f&63)<<12|(g&63)<<6|h&63)-65536;b[d++]=String.fromCharCode(55296+(e>>10));b[d++]=String.fromCharCode(56320+(e&1023))}else f=a[c++],g=a[c++],b[d++]=String.fromCharCode((e&15)<<12|(f&63)<<6|g&63)}return b.join("")};
goog.crypt.xorByteArray=function(a,b){goog.asserts.assert(a.length==b.length,"XOR array lengths must match");for(var c=[],d=0;d<a.length;d++)c.push(a[d]^b[d]);return c};goog.string={};goog.string.internal={};goog.string.internal.startsWith=function(a,b){return 0==a.lastIndexOf(b,0)};goog.string.internal.endsWith=function(a,b){var c=a.length-b.length;return 0<=c&&a.indexOf(b,c)==c};goog.string.internal.caseInsensitiveStartsWith=function(a,b){return 0==goog.string.internal.caseInsensitiveCompare(b,a.substr(0,b.length))};goog.string.internal.caseInsensitiveEndsWith=function(a,b){return 0==goog.string.internal.caseInsensitiveCompare(b,a.substr(a.length-b.length,b.length))};
goog.string.internal.caseInsensitiveEquals=function(a,b){return a.toLowerCase()==b.toLowerCase()};goog.string.internal.isEmptyOrWhitespace=function(a){return/^[\s\xa0]*$/.test(a)};goog.string.internal.trim=goog.TRUSTED_SITE&&String.prototype.trim?function(a){return a.trim()}:function(a){return/^[\s\xa0]*([\s\S]*?)[\s\xa0]*$/.exec(a)[1]};goog.string.internal.caseInsensitiveCompare=function(a,b){a=String(a).toLowerCase();b=String(b).toLowerCase();return a<b?-1:a==b?0:1};
goog.string.internal.newLineToBr=function(a,b){return a.replace(/(\r\n|\r|\n)/g,b?"<br />":"<br>")};
goog.string.internal.htmlEscape=function(a,b){if(b)a=a.replace(goog.string.internal.AMP_RE_,"&amp;").replace(goog.string.internal.LT_RE_,"&lt;").replace(goog.string.internal.GT_RE_,"&gt;").replace(goog.string.internal.QUOT_RE_,"&quot;").replace(goog.string.internal.SINGLE_QUOTE_RE_,"&#39;").replace(goog.string.internal.NULL_RE_,"&#0;");else{if(!goog.string.internal.ALL_RE_.test(a))return a;-1!=a.indexOf("&")&&(a=a.replace(goog.string.internal.AMP_RE_,"&amp;"));-1!=a.indexOf("<")&&(a=a.replace(goog.string.internal.LT_RE_,
"&lt;"));-1!=a.indexOf(">")&&(a=a.replace(goog.string.internal.GT_RE_,"&gt;"));-1!=a.indexOf('"')&&(a=a.replace(goog.string.internal.QUOT_RE_,"&quot;"));-1!=a.indexOf("'")&&(a=a.replace(goog.string.internal.SINGLE_QUOTE_RE_,"&#39;"));-1!=a.indexOf("\x00")&&(a=a.replace(goog.string.internal.NULL_RE_,"&#0;"))}return a};goog.string.internal.AMP_RE_=/&/g;goog.string.internal.LT_RE_=/</g;goog.string.internal.GT_RE_=/>/g;goog.string.internal.QUOT_RE_=/"/g;goog.string.internal.SINGLE_QUOTE_RE_=/'/g;
goog.string.internal.NULL_RE_=/\x00/g;goog.string.internal.ALL_RE_=/[\x00&<>"']/;goog.string.internal.whitespaceEscape=function(a,b){return goog.string.internal.newLineToBr(a.replace(/  /g," &#160;"),b)};goog.string.internal.contains=function(a,b){return-1!=a.indexOf(b)};goog.string.internal.caseInsensitiveContains=function(a,b){return goog.string.internal.contains(a.toLowerCase(),b.toLowerCase())};
goog.string.internal.compareVersions=function(a,b){var c=0;a=goog.string.internal.trim(String(a)).split(".");b=goog.string.internal.trim(String(b)).split(".");for(var d=Math.max(a.length,b.length),e=0;0==c&&e<d;e++){var f=a[e]||"",g=b[e]||"";do{f=/(\d*)(\D*)(.*)/.exec(f)||["","","",""];g=/(\d*)(\D*)(.*)/.exec(g)||["","","",""];if(0==f[0].length&&0==g[0].length)break;c=0==f[1].length?0:parseInt(f[1],10);var h=0==g[1].length?0:parseInt(g[1],10);c=goog.string.internal.compareElements_(c,h)||goog.string.internal.compareElements_(0==
f[2].length,0==g[2].length)||goog.string.internal.compareElements_(f[2],g[2]);f=f[3];g=g[3]}while(0==c)}return c};goog.string.internal.compareElements_=function(a,b){return a<b?-1:a>b?1:0};goog.string.DETECT_DOUBLE_ESCAPING=!1;goog.string.FORCE_NON_DOM_HTML_UNESCAPING=!1;goog.string.Unicode={NBSP:"\u00a0"};goog.string.startsWith=goog.string.internal.startsWith;goog.string.endsWith=goog.string.internal.endsWith;goog.string.caseInsensitiveStartsWith=goog.string.internal.caseInsensitiveStartsWith;goog.string.caseInsensitiveEndsWith=goog.string.internal.caseInsensitiveEndsWith;goog.string.caseInsensitiveEquals=goog.string.internal.caseInsensitiveEquals;
goog.string.subs=function(a,b){for(var c=a.split("%s"),d="",e=Array.prototype.slice.call(arguments,1);e.length&&1<c.length;)d+=c.shift()+e.shift();return d+c.join("%s")};goog.string.collapseWhitespace=function(a){return a.replace(/[\s\xa0]+/g," ").replace(/^\s+|\s+$/g,"")};goog.string.isEmptyOrWhitespace=goog.string.internal.isEmptyOrWhitespace;goog.string.isEmptyString=function(a){return 0==a.length};goog.string.isEmpty=goog.string.isEmptyOrWhitespace;goog.string.isEmptyOrWhitespaceSafe=function(a){return goog.string.isEmptyOrWhitespace(goog.string.makeSafe(a))};
goog.string.isEmptySafe=goog.string.isEmptyOrWhitespaceSafe;goog.string.isBreakingWhitespace=function(a){return!/[^\t\n\r ]/.test(a)};goog.string.isAlpha=function(a){return!/[^a-zA-Z]/.test(a)};goog.string.isNumeric=function(a){return!/[^0-9]/.test(a)};goog.string.isAlphaNumeric=function(a){return!/[^a-zA-Z0-9]/.test(a)};goog.string.isSpace=function(a){return" "==a};goog.string.isUnicodeChar=function(a){return 1==a.length&&" "<=a&&"~">=a||"\u0080"<=a&&"\ufffd">=a};
goog.string.stripNewlines=function(a){return a.replace(/(\r\n|\r|\n)+/g," ")};goog.string.canonicalizeNewlines=function(a){return a.replace(/(\r\n|\r|\n)/g,"\n")};goog.string.normalizeWhitespace=function(a){return a.replace(/\xa0|\s/g," ")};goog.string.normalizeSpaces=function(a){return a.replace(/\xa0|[ \t]+/g," ")};goog.string.collapseBreakingSpaces=function(a){return a.replace(/[\t\r\n ]+/g," ").replace(/^[\t\r\n ]+|[\t\r\n ]+$/g,"")};goog.string.trim=goog.string.internal.trim;
goog.string.trimLeft=function(a){return a.replace(/^[\s\xa0]+/,"")};goog.string.trimRight=function(a){return a.replace(/[\s\xa0]+$/,"")};goog.string.caseInsensitiveCompare=goog.string.internal.caseInsensitiveCompare;
goog.string.numberAwareCompare_=function(a,b,c){if(a==b)return 0;if(!a)return-1;if(!b)return 1;for(var d=a.toLowerCase().match(c),e=b.toLowerCase().match(c),f=Math.min(d.length,e.length),g=0;g<f;g++){c=d[g];var h=e[g];if(c!=h)return a=parseInt(c,10),!isNaN(a)&&(b=parseInt(h,10),!isNaN(b)&&a-b)?a-b:c<h?-1:1}return d.length!=e.length?d.length-e.length:a<b?-1:1};goog.string.intAwareCompare=function(a,b){return goog.string.numberAwareCompare_(a,b,/\d+|\D+/g)};
goog.string.floatAwareCompare=function(a,b){return goog.string.numberAwareCompare_(a,b,/\d+|\.\d+|\D+/g)};goog.string.numerateCompare=goog.string.floatAwareCompare;goog.string.urlEncode=function(a){return encodeURIComponent(String(a))};goog.string.urlDecode=function(a){return decodeURIComponent(a.replace(/\+/g," "))};goog.string.newLineToBr=goog.string.internal.newLineToBr;
goog.string.htmlEscape=function(a,b){a=goog.string.internal.htmlEscape(a,b);goog.string.DETECT_DOUBLE_ESCAPING&&(a=a.replace(goog.string.E_RE_,"&#101;"));return a};goog.string.E_RE_=/e/g;goog.string.unescapeEntities=function(a){return goog.string.contains(a,"&")?!goog.string.FORCE_NON_DOM_HTML_UNESCAPING&&"document"in goog.global?goog.string.unescapeEntitiesUsingDom_(a):goog.string.unescapePureXmlEntities_(a):a};
goog.string.unescapeEntitiesWithDocument=function(a,b){return goog.string.contains(a,"&")?goog.string.unescapeEntitiesUsingDom_(a,b):a};
goog.string.unescapeEntitiesUsingDom_=function(a,b){var c={"&amp;":"&","&lt;":"<","&gt;":">","&quot;":'"'};var d=b?b.createElement("div"):goog.global.document.createElement("div");return a.replace(goog.string.HTML_ENTITY_PATTERN_,function(a,b){var e=c[a];if(e)return e;"#"==b.charAt(0)&&(b=Number("0"+b.substr(1)),isNaN(b)||(e=String.fromCharCode(b)));e||(d.innerHTML=a+" ",e=d.firstChild.nodeValue.slice(0,-1));return c[a]=e})};
goog.string.unescapePureXmlEntities_=function(a){return a.replace(/&([^;]+);/g,function(a,c){switch(c){case "amp":return"&";case "lt":return"<";case "gt":return">";case "quot":return'"';default:return"#"!=c.charAt(0)||(c=Number("0"+c.substr(1)),isNaN(c))?a:String.fromCharCode(c)}})};goog.string.HTML_ENTITY_PATTERN_=/&([^;\s<&]+);?/g;goog.string.whitespaceEscape=function(a,b){return goog.string.newLineToBr(a.replace(/  /g," &#160;"),b)};
goog.string.preserveSpaces=function(a){return a.replace(/(^|[\n ]) /g,"$1"+goog.string.Unicode.NBSP)};goog.string.stripQuotes=function(a,b){for(var c=b.length,d=0;d<c;d++){var e=1==c?b:b.charAt(d);if(a.charAt(0)==e&&a.charAt(a.length-1)==e)return a.substring(1,a.length-1)}return a};goog.string.truncate=function(a,b,c){c&&(a=goog.string.unescapeEntities(a));a.length>b&&(a=a.substring(0,b-3)+"...");c&&(a=goog.string.htmlEscape(a));return a};
goog.string.truncateMiddle=function(a,b,c,d){c&&(a=goog.string.unescapeEntities(a));if(d&&a.length>b){d>b&&(d=b);var e=a.length-d;a=a.substring(0,b-d)+"..."+a.substring(e)}else a.length>b&&(d=Math.floor(b/2),e=a.length-d,a=a.substring(0,d+b%2)+"..."+a.substring(e));c&&(a=goog.string.htmlEscape(a));return a};goog.string.specialEscapeChars_={"\x00":"\\0","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t","\x0B":"\\x0B",'"':'\\"',"\\":"\\\\","<":"<"};goog.string.jsEscapeCache_={"'":"\\'"};
goog.string.quote=function(a){a=String(a);for(var b=['"'],c=0;c<a.length;c++){var d=a.charAt(c),e=d.charCodeAt(0);b[c+1]=goog.string.specialEscapeChars_[d]||(31<e&&127>e?d:goog.string.escapeChar(d))}b.push('"');return b.join("")};goog.string.escapeString=function(a){for(var b=[],c=0;c<a.length;c++)b[c]=goog.string.escapeChar(a.charAt(c));return b.join("")};
goog.string.escapeChar=function(a){if(a in goog.string.jsEscapeCache_)return goog.string.jsEscapeCache_[a];if(a in goog.string.specialEscapeChars_)return goog.string.jsEscapeCache_[a]=goog.string.specialEscapeChars_[a];var b=a.charCodeAt(0);if(31<b&&127>b)var c=a;else{if(256>b){if(c="\\x",16>b||256<b)c+="0"}else c="\\u",4096>b&&(c+="0");c+=b.toString(16).toUpperCase()}return goog.string.jsEscapeCache_[a]=c};goog.string.contains=goog.string.internal.contains;goog.string.caseInsensitiveContains=goog.string.internal.caseInsensitiveContains;
goog.string.countOf=function(a,b){return a&&b?a.split(b).length-1:0};goog.string.removeAt=function(a,b,c){var d=a;0<=b&&b<a.length&&0<c&&(d=a.substr(0,b)+a.substr(b+c,a.length-b-c));return d};goog.string.remove=function(a,b){return a.replace(b,"")};goog.string.removeAll=function(a,b){b=new RegExp(goog.string.regExpEscape(b),"g");return a.replace(b,"")};goog.string.replaceAll=function(a,b,c){b=new RegExp(goog.string.regExpEscape(b),"g");return a.replace(b,c.replace(/\$/g,"$$$$"))};
goog.string.regExpEscape=function(a){return String(a).replace(/([-()\[\]{}+?*.$\^|,:#<!\\])/g,"\\$1").replace(/\x08/g,"\\x08")};goog.string.repeat=String.prototype.repeat?function(a,b){return a.repeat(b)}:function(a,b){return Array(b+1).join(a)};goog.string.padNumber=function(a,b,c){a=goog.isDef(c)?a.toFixed(c):String(a);c=a.indexOf(".");-1==c&&(c=a.length);return goog.string.repeat("0",Math.max(0,b-c))+a};goog.string.makeSafe=function(a){return null==a?"":String(a)};
goog.string.buildString=function(a){return Array.prototype.join.call(arguments,"")};goog.string.getRandomString=function(){return Math.floor(2147483648*Math.random()).toString(36)+Math.abs(Math.floor(2147483648*Math.random())^goog.now()).toString(36)};goog.string.compareVersions=goog.string.internal.compareVersions;goog.string.hashCode=function(a){for(var b=0,c=0;c<a.length;++c)b=31*b+a.charCodeAt(c)>>>0;return b};goog.string.uniqueStringCounter_=2147483648*Math.random()|0;
goog.string.createUniqueString=function(){return"goog_"+goog.string.uniqueStringCounter_++};goog.string.toNumber=function(a){var b=Number(a);return 0==b&&goog.string.isEmptyOrWhitespace(a)?NaN:b};goog.string.isLowerCamelCase=function(a){return/^[a-z]+([A-Z][a-z]*)*$/.test(a)};goog.string.isUpperCamelCase=function(a){return/^([A-Z][a-z]*)+$/.test(a)};goog.string.toCamelCase=function(a){return String(a).replace(/\-([a-z])/g,function(a,c){return c.toUpperCase()})};
goog.string.toSelectorCase=function(a){return String(a).replace(/([A-Z])/g,"-$1").toLowerCase()};goog.string.toTitleCase=function(a,b){b=goog.isString(b)?goog.string.regExpEscape(b):"\\s";return a.replace(new RegExp("(^"+(b?"|["+b+"]+":"")+")([a-z])","g"),function(a,b,e){return b+e.toUpperCase()})};goog.string.capitalize=function(a){return String(a.charAt(0)).toUpperCase()+String(a.substr(1)).toLowerCase()};
goog.string.parseInt=function(a){isFinite(a)&&(a=String(a));return goog.isString(a)?/^\s*-?0x/i.test(a)?parseInt(a,16):parseInt(a,10):NaN};goog.string.splitLimit=function(a,b,c){a=a.split(b);for(var d=[];0<c&&a.length;)d.push(a.shift()),c--;a.length&&d.push(a.join(b));return d};goog.string.lastComponent=function(a,b){if(b)"string"==typeof b&&(b=[b]);else return a;for(var c=-1,d=0;d<b.length;d++)if(""!=b[d]){var e=a.lastIndexOf(b[d]);e>c&&(c=e)}return-1==c?a:a.slice(c+1)};
goog.string.editDistance=function(a,b){var c=[],d=[];if(a==b)return 0;if(!a.length||!b.length)return Math.max(a.length,b.length);for(var e=0;e<b.length+1;e++)c[e]=e;for(e=0;e<a.length;e++){d[0]=e+1;for(var f=0;f<b.length;f++)d[f+1]=Math.min(d[f]+1,c[f+1]+1,c[f]+Number(a[e]!=b[f]));for(f=0;f<c.length;f++)c[f]=d[f]}return d[b.length]};goog.labs={};goog.labs.userAgent={};goog.labs.userAgent.util={};goog.labs.userAgent.util.getNativeUserAgentString_=function(){var a=goog.labs.userAgent.util.getNavigator_();return a&&(a=a.userAgent)?a:""};goog.labs.userAgent.util.getNavigator_=function(){return goog.global.navigator};goog.labs.userAgent.util.userAgent_=goog.labs.userAgent.util.getNativeUserAgentString_();goog.labs.userAgent.util.setUserAgent=function(a){goog.labs.userAgent.util.userAgent_=a||goog.labs.userAgent.util.getNativeUserAgentString_()};
goog.labs.userAgent.util.getUserAgent=function(){return goog.labs.userAgent.util.userAgent_};goog.labs.userAgent.util.matchUserAgent=function(a){var b=goog.labs.userAgent.util.getUserAgent();return goog.string.internal.contains(b,a)};goog.labs.userAgent.util.matchUserAgentIgnoreCase=function(a){var b=goog.labs.userAgent.util.getUserAgent();return goog.string.internal.caseInsensitiveContains(b,a)};
goog.labs.userAgent.util.extractVersionTuples=function(a){for(var b=/(\w[\w ]+)\/([^\s]+)\s*(?:\((.*?)\))?/g,c=[],d;d=b.exec(a);)c.push([d[1],d[2],d[3]||void 0]);return c};goog.labs.userAgent.platform={};goog.labs.userAgent.platform.isAndroid=function(){return goog.labs.userAgent.util.matchUserAgent("Android")};goog.labs.userAgent.platform.isIpod=function(){return goog.labs.userAgent.util.matchUserAgent("iPod")};goog.labs.userAgent.platform.isIphone=function(){return goog.labs.userAgent.util.matchUserAgent("iPhone")&&!goog.labs.userAgent.util.matchUserAgent("iPod")&&!goog.labs.userAgent.util.matchUserAgent("iPad")};goog.labs.userAgent.platform.isIpad=function(){return goog.labs.userAgent.util.matchUserAgent("iPad")};
goog.labs.userAgent.platform.isIos=function(){return goog.labs.userAgent.platform.isIphone()||goog.labs.userAgent.platform.isIpad()||goog.labs.userAgent.platform.isIpod()};goog.labs.userAgent.platform.isMacintosh=function(){return goog.labs.userAgent.util.matchUserAgent("Macintosh")};goog.labs.userAgent.platform.isLinux=function(){return goog.labs.userAgent.util.matchUserAgent("Linux")};goog.labs.userAgent.platform.isWindows=function(){return goog.labs.userAgent.util.matchUserAgent("Windows")};
goog.labs.userAgent.platform.isChromeOS=function(){return goog.labs.userAgent.util.matchUserAgent("CrOS")};goog.labs.userAgent.platform.isChromecast=function(){return goog.labs.userAgent.util.matchUserAgent("CrKey")};goog.labs.userAgent.platform.isKaiOS=function(){return goog.labs.userAgent.util.matchUserAgentIgnoreCase("KaiOS")};goog.labs.userAgent.platform.isGo2Phone=function(){return goog.labs.userAgent.util.matchUserAgentIgnoreCase("GAFP")};
goog.labs.userAgent.platform.getVersion=function(){var a=goog.labs.userAgent.util.getUserAgent(),b="";goog.labs.userAgent.platform.isWindows()?(b=/Windows (?:NT|Phone) ([0-9.]+)/,b=(a=b.exec(a))?a[1]:"0.0"):goog.labs.userAgent.platform.isIos()?(b=/(?:iPhone|iPod|iPad|CPU)\s+OS\s+(\S+)/,b=(a=b.exec(a))&&a[1].replace(/_/g,".")):goog.labs.userAgent.platform.isMacintosh()?(b=/Mac OS X ([0-9_.]+)/,b=(a=b.exec(a))?a[1].replace(/_/g,"."):"10"):goog.labs.userAgent.platform.isAndroid()?(b=/Android\s+([^\);]+)(\)|;)/,
b=(a=b.exec(a))&&a[1]):goog.labs.userAgent.platform.isChromeOS()&&(b=/(?:CrOS\s+(?:i686|x86_64)\s+([0-9.]+))/,b=(a=b.exec(a))&&a[1]);return b||""};goog.labs.userAgent.platform.isVersionOrHigher=function(a){return 0<=goog.string.compareVersions(goog.labs.userAgent.platform.getVersion(),a)};goog.object={};goog.object.is=function(a,b){return a===b?0!==a||1/a===1/b:a!==a&&b!==b};goog.object.forEach=function(a,b,c){for(var d in a)b.call(c,a[d],d,a)};goog.object.filter=function(a,b,c){var d={},e;for(e in a)b.call(c,a[e],e,a)&&(d[e]=a[e]);return d};goog.object.map=function(a,b,c){var d={},e;for(e in a)d[e]=b.call(c,a[e],e,a);return d};goog.object.some=function(a,b,c){for(var d in a)if(b.call(c,a[d],d,a))return!0;return!1};
goog.object.every=function(a,b,c){for(var d in a)if(!b.call(c,a[d],d,a))return!1;return!0};goog.object.getCount=function(a){var b=0,c;for(c in a)b++;return b};goog.object.getAnyKey=function(a){for(var b in a)return b};goog.object.getAnyValue=function(a){for(var b in a)return a[b]};goog.object.contains=function(a,b){return goog.object.containsValue(a,b)};goog.object.getValues=function(a){var b=[],c=0,d;for(d in a)b[c++]=a[d];return b};
goog.object.getKeys=function(a){var b=[],c=0,d;for(d in a)b[c++]=d;return b};goog.object.getValueByKeys=function(a,b){var c=goog.isArrayLike(b),d=c?b:arguments;for(c=c?0:1;c<d.length;c++){if(null==a)return;a=a[d[c]]}return a};goog.object.containsKey=function(a,b){return null!==a&&b in a};goog.object.containsValue=function(a,b){for(var c in a)if(a[c]==b)return!0;return!1};goog.object.findKey=function(a,b,c){for(var d in a)if(b.call(c,a[d],d,a))return d};
goog.object.findValue=function(a,b,c){return(b=goog.object.findKey(a,b,c))&&a[b]};goog.object.isEmpty=function(a){for(var b in a)return!1;return!0};goog.object.clear=function(a){for(var b in a)delete a[b]};goog.object.remove=function(a,b){var c;(c=b in a)&&delete a[b];return c};goog.object.add=function(a,b,c){if(null!==a&&b in a)throw Error('The object already contains the key "'+b+'"');goog.object.set(a,b,c)};goog.object.get=function(a,b,c){return null!==a&&b in a?a[b]:c};
goog.object.set=function(a,b,c){a[b]=c};goog.object.setIfUndefined=function(a,b,c){return b in a?a[b]:a[b]=c};goog.object.setWithReturnValueIfNotSet=function(a,b,c){if(b in a)return a[b];c=c();return a[b]=c};goog.object.equals=function(a,b){for(var c in a)if(!(c in b)||a[c]!==b[c])return!1;for(c in b)if(!(c in a))return!1;return!0};goog.object.clone=function(a){var b={},c;for(c in a)b[c]=a[c];return b};
goog.object.unsafeClone=function(a){var b=goog.typeOf(a);if("object"==b||"array"==b){if(goog.isFunction(a.clone))return a.clone();b="array"==b?[]:{};for(var c in a)b[c]=goog.object.unsafeClone(a[c]);return b}return a};goog.object.transpose=function(a){var b={},c;for(c in a)b[a[c]]=c;return b};goog.object.PROTOTYPE_FIELDS_="constructor hasOwnProperty isPrototypeOf propertyIsEnumerable toLocaleString toString valueOf".split(" ");
goog.object.extend=function(a,b){for(var c,d,e=1;e<arguments.length;e++){d=arguments[e];for(c in d)a[c]=d[c];for(var f=0;f<goog.object.PROTOTYPE_FIELDS_.length;f++)c=goog.object.PROTOTYPE_FIELDS_[f],Object.prototype.hasOwnProperty.call(d,c)&&(a[c]=d[c])}};
goog.object.create=function(a){var b=arguments.length;if(1==b&&goog.isArray(arguments[0]))return goog.object.create.apply(null,arguments[0]);if(b%2)throw Error("Uneven number of arguments");for(var c={},d=0;d<b;d+=2)c[arguments[d]]=arguments[d+1];return c};goog.object.createSet=function(a){var b=arguments.length;if(1==b&&goog.isArray(arguments[0]))return goog.object.createSet.apply(null,arguments[0]);for(var c={},d=0;d<b;d++)c[arguments[d]]=!0;return c};
goog.object.createImmutableView=function(a){var b=a;Object.isFrozen&&!Object.isFrozen(a)&&(b=Object.create(a),Object.freeze(b));return b};goog.object.isImmutableView=function(a){return!!Object.isFrozen&&Object.isFrozen(a)};
goog.object.getAllPropertyNames=function(a,b,c){if(!a)return[];if(!Object.getOwnPropertyNames||!Object.getPrototypeOf)return goog.object.getKeys(a);for(var d={};a&&(a!==Object.prototype||b)&&(a!==Function.prototype||c);){for(var e=Object.getOwnPropertyNames(a),f=0;f<e.length;f++)d[e[f]]=!0;a=Object.getPrototypeOf(a)}return goog.object.getKeys(d)};goog.labs.userAgent.browser={};goog.labs.userAgent.browser.matchOpera_=function(){return goog.labs.userAgent.util.matchUserAgent("Opera")};goog.labs.userAgent.browser.matchIE_=function(){return goog.labs.userAgent.util.matchUserAgent("Trident")||goog.labs.userAgent.util.matchUserAgent("MSIE")};goog.labs.userAgent.browser.matchEdge_=function(){return goog.labs.userAgent.util.matchUserAgent("Edge")};
goog.labs.userAgent.browser.matchFirefox_=function(){return goog.labs.userAgent.util.matchUserAgent("Firefox")||goog.labs.userAgent.util.matchUserAgent("FxiOS")};
goog.labs.userAgent.browser.matchSafari_=function(){return goog.labs.userAgent.util.matchUserAgent("Safari")&&!(goog.labs.userAgent.browser.matchChrome_()||goog.labs.userAgent.browser.matchCoast_()||goog.labs.userAgent.browser.matchOpera_()||goog.labs.userAgent.browser.matchEdge_()||goog.labs.userAgent.browser.matchFirefox_()||goog.labs.userAgent.browser.isSilk()||goog.labs.userAgent.util.matchUserAgent("Android"))};goog.labs.userAgent.browser.matchCoast_=function(){return goog.labs.userAgent.util.matchUserAgent("Coast")};
goog.labs.userAgent.browser.matchIosWebview_=function(){return(goog.labs.userAgent.util.matchUserAgent("iPad")||goog.labs.userAgent.util.matchUserAgent("iPhone"))&&!goog.labs.userAgent.browser.matchSafari_()&&!goog.labs.userAgent.browser.matchChrome_()&&!goog.labs.userAgent.browser.matchCoast_()&&!goog.labs.userAgent.browser.matchFirefox_()&&goog.labs.userAgent.util.matchUserAgent("AppleWebKit")};
goog.labs.userAgent.browser.matchChrome_=function(){return(goog.labs.userAgent.util.matchUserAgent("Chrome")||goog.labs.userAgent.util.matchUserAgent("CriOS"))&&!goog.labs.userAgent.browser.matchEdge_()};goog.labs.userAgent.browser.matchAndroidBrowser_=function(){return goog.labs.userAgent.util.matchUserAgent("Android")&&!(goog.labs.userAgent.browser.isChrome()||goog.labs.userAgent.browser.isFirefox()||goog.labs.userAgent.browser.isOpera()||goog.labs.userAgent.browser.isSilk())};
goog.labs.userAgent.browser.isOpera=goog.labs.userAgent.browser.matchOpera_;goog.labs.userAgent.browser.isIE=goog.labs.userAgent.browser.matchIE_;goog.labs.userAgent.browser.isEdge=goog.labs.userAgent.browser.matchEdge_;goog.labs.userAgent.browser.isFirefox=goog.labs.userAgent.browser.matchFirefox_;goog.labs.userAgent.browser.isSafari=goog.labs.userAgent.browser.matchSafari_;goog.labs.userAgent.browser.isCoast=goog.labs.userAgent.browser.matchCoast_;goog.labs.userAgent.browser.isIosWebview=goog.labs.userAgent.browser.matchIosWebview_;
goog.labs.userAgent.browser.isChrome=goog.labs.userAgent.browser.matchChrome_;goog.labs.userAgent.browser.isAndroidBrowser=goog.labs.userAgent.browser.matchAndroidBrowser_;goog.labs.userAgent.browser.isSilk=function(){return goog.labs.userAgent.util.matchUserAgent("Silk")};
goog.labs.userAgent.browser.getVersion=function(){function a(a){a=goog.array.find(a,d);return c[a]||""}var b=goog.labs.userAgent.util.getUserAgent();if(goog.labs.userAgent.browser.isIE())return goog.labs.userAgent.browser.getIEVersion_(b);b=goog.labs.userAgent.util.extractVersionTuples(b);var c={};goog.array.forEach(b,function(a){c[a[0]]=a[1]});var d=goog.partial(goog.object.containsKey,c);return goog.labs.userAgent.browser.isOpera()?a(["Version","Opera"]):goog.labs.userAgent.browser.isEdge()?a(["Edge"]):
goog.labs.userAgent.browser.isChrome()?a(["Chrome","CriOS"]):(b=b[2])&&b[1]||""};goog.labs.userAgent.browser.isVersionOrHigher=function(a){return 0<=goog.string.internal.compareVersions(goog.labs.userAgent.browser.getVersion(),a)};
goog.labs.userAgent.browser.getIEVersion_=function(a){var b=/rv: *([\d\.]*)/.exec(a);if(b&&b[1])return b[1];b="";var c=/MSIE +([\d\.]+)/.exec(a);if(c&&c[1])if(a=/Trident\/(\d.\d)/.exec(a),"7.0"==c[1])if(a&&a[1])switch(a[1]){case "4.0":b="8.0";break;case "5.0":b="9.0";break;case "6.0":b="10.0";break;case "7.0":b="11.0"}else b="7.0";else b=c[1];return b};goog.reflect={};goog.reflect.object=function(a,b){return b};goog.reflect.objectProperty=function(a,b){return a};goog.reflect.sinkValue=function(a){goog.reflect.sinkValue[" "](a);return a};goog.reflect.sinkValue[" "]=goog.nullFunction;goog.reflect.canAccessProperty=function(a,b){try{return goog.reflect.sinkValue(a[b]),!0}catch(c){}return!1};goog.reflect.cache=function(a,b,c,d){d=d?d(b):b;return Object.prototype.hasOwnProperty.call(a,d)?a[d]:a[d]=c(b)};goog.labs.userAgent.engine={};goog.labs.userAgent.engine.isPresto=function(){return goog.labs.userAgent.util.matchUserAgent("Presto")};goog.labs.userAgent.engine.isTrident=function(){return goog.labs.userAgent.util.matchUserAgent("Trident")||goog.labs.userAgent.util.matchUserAgent("MSIE")};goog.labs.userAgent.engine.isEdge=function(){return goog.labs.userAgent.util.matchUserAgent("Edge")};
goog.labs.userAgent.engine.isWebKit=function(){return goog.labs.userAgent.util.matchUserAgentIgnoreCase("WebKit")&&!goog.labs.userAgent.engine.isEdge()};goog.labs.userAgent.engine.isGecko=function(){return goog.labs.userAgent.util.matchUserAgent("Gecko")&&!goog.labs.userAgent.engine.isWebKit()&&!goog.labs.userAgent.engine.isTrident()&&!goog.labs.userAgent.engine.isEdge()};
goog.labs.userAgent.engine.getVersion=function(){var a=goog.labs.userAgent.util.getUserAgent();if(a){a=goog.labs.userAgent.util.extractVersionTuples(a);var b=goog.labs.userAgent.engine.getEngineTuple_(a);if(b)return"Gecko"==b[0]?goog.labs.userAgent.engine.getVersionForKey_(a,"Firefox"):b[1];a=a[0];var c;if(a&&(c=a[2])&&(c=/Trident\/([^\s;]+)/.exec(c)))return c[1]}return""};
goog.labs.userAgent.engine.getEngineTuple_=function(a){if(!goog.labs.userAgent.engine.isEdge())return a[1];for(var b=0;b<a.length;b++){var c=a[b];if("Edge"==c[0])return c}};goog.labs.userAgent.engine.isVersionOrHigher=function(a){return 0<=goog.string.compareVersions(goog.labs.userAgent.engine.getVersion(),a)};goog.labs.userAgent.engine.getVersionForKey_=function(a,b){return(a=goog.array.find(a,function(a){return b==a[0]}))&&a[1]||""};goog.userAgent={};goog.userAgent.ASSUME_IE=!1;goog.userAgent.ASSUME_EDGE=!1;goog.userAgent.ASSUME_GECKO=!1;goog.userAgent.ASSUME_WEBKIT=!1;goog.userAgent.ASSUME_MOBILE_WEBKIT=!1;goog.userAgent.ASSUME_OPERA=!1;goog.userAgent.ASSUME_ANY_VERSION=!1;goog.userAgent.BROWSER_KNOWN_=goog.userAgent.ASSUME_IE||goog.userAgent.ASSUME_EDGE||goog.userAgent.ASSUME_GECKO||goog.userAgent.ASSUME_MOBILE_WEBKIT||goog.userAgent.ASSUME_WEBKIT||goog.userAgent.ASSUME_OPERA;goog.userAgent.getUserAgentString=function(){return goog.labs.userAgent.util.getUserAgent()};
goog.userAgent.getNavigatorTyped=function(){return goog.global.navigator||null};goog.userAgent.getNavigator=function(){return goog.userAgent.getNavigatorTyped()};goog.userAgent.OPERA=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_OPERA:goog.labs.userAgent.browser.isOpera();goog.userAgent.IE=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_IE:goog.labs.userAgent.browser.isIE();goog.userAgent.EDGE=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_EDGE:goog.labs.userAgent.engine.isEdge();
goog.userAgent.EDGE_OR_IE=goog.userAgent.EDGE||goog.userAgent.IE;goog.userAgent.GECKO=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_GECKO:goog.labs.userAgent.engine.isGecko();goog.userAgent.WEBKIT=goog.userAgent.BROWSER_KNOWN_?goog.userAgent.ASSUME_WEBKIT||goog.userAgent.ASSUME_MOBILE_WEBKIT:goog.labs.userAgent.engine.isWebKit();goog.userAgent.isMobile_=function(){return goog.userAgent.WEBKIT&&goog.labs.userAgent.util.matchUserAgent("Mobile")};
goog.userAgent.MOBILE=goog.userAgent.ASSUME_MOBILE_WEBKIT||goog.userAgent.isMobile_();goog.userAgent.SAFARI=goog.userAgent.WEBKIT;goog.userAgent.determinePlatform_=function(){var a=goog.userAgent.getNavigatorTyped();return a&&a.platform||""};goog.userAgent.PLATFORM=goog.userAgent.determinePlatform_();goog.userAgent.ASSUME_MAC=!1;goog.userAgent.ASSUME_WINDOWS=!1;goog.userAgent.ASSUME_LINUX=!1;goog.userAgent.ASSUME_X11=!1;goog.userAgent.ASSUME_ANDROID=!1;goog.userAgent.ASSUME_IPHONE=!1;
goog.userAgent.ASSUME_IPAD=!1;goog.userAgent.ASSUME_IPOD=!1;goog.userAgent.ASSUME_KAIOS=!1;goog.userAgent.ASSUME_GO2PHONE=!1;goog.userAgent.PLATFORM_KNOWN_=goog.userAgent.ASSUME_MAC||goog.userAgent.ASSUME_WINDOWS||goog.userAgent.ASSUME_LINUX||goog.userAgent.ASSUME_X11||goog.userAgent.ASSUME_ANDROID||goog.userAgent.ASSUME_IPHONE||goog.userAgent.ASSUME_IPAD||goog.userAgent.ASSUME_IPOD;goog.userAgent.MAC=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_MAC:goog.labs.userAgent.platform.isMacintosh();
goog.userAgent.WINDOWS=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_WINDOWS:goog.labs.userAgent.platform.isWindows();goog.userAgent.isLegacyLinux_=function(){return goog.labs.userAgent.platform.isLinux()||goog.labs.userAgent.platform.isChromeOS()};goog.userAgent.LINUX=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_LINUX:goog.userAgent.isLegacyLinux_();goog.userAgent.isX11_=function(){var a=goog.userAgent.getNavigatorTyped();return!!a&&goog.string.contains(a.appVersion||"","X11")};
goog.userAgent.X11=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_X11:goog.userAgent.isX11_();goog.userAgent.ANDROID=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_ANDROID:goog.labs.userAgent.platform.isAndroid();goog.userAgent.IPHONE=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_IPHONE:goog.labs.userAgent.platform.isIphone();goog.userAgent.IPAD=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_IPAD:goog.labs.userAgent.platform.isIpad();
goog.userAgent.IPOD=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_IPOD:goog.labs.userAgent.platform.isIpod();goog.userAgent.IOS=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_IPHONE||goog.userAgent.ASSUME_IPAD||goog.userAgent.ASSUME_IPOD:goog.labs.userAgent.platform.isIos();goog.userAgent.KAIOS=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_KAIOS:goog.labs.userAgent.platform.isKaiOS();goog.userAgent.GO2PHONE=goog.userAgent.PLATFORM_KNOWN_?goog.userAgent.ASSUME_GO2PHONE:goog.labs.userAgent.platform.isGo2Phone();
goog.userAgent.determineVersion_=function(){var a="",b=goog.userAgent.getVersionRegexResult_();b&&(a=b?b[1]:"");return goog.userAgent.IE&&(b=goog.userAgent.getDocumentMode_(),null!=b&&b>parseFloat(a))?String(b):a};
goog.userAgent.getVersionRegexResult_=function(){var a=goog.userAgent.getUserAgentString();if(goog.userAgent.GECKO)return/rv:([^\);]+)(\)|;)/.exec(a);if(goog.userAgent.EDGE)return/Edge\/([\d\.]+)/.exec(a);if(goog.userAgent.IE)return/\b(?:MSIE|rv)[: ]([^\);]+)(\)|;)/.exec(a);if(goog.userAgent.WEBKIT)return/WebKit\/(\S+)/.exec(a);if(goog.userAgent.OPERA)return/(?:Version)[ \/]?(\S+)/.exec(a)};goog.userAgent.getDocumentMode_=function(){var a=goog.global.document;return a?a.documentMode:void 0};
goog.userAgent.VERSION=goog.userAgent.determineVersion_();goog.userAgent.compare=function(a,b){return goog.string.compareVersions(a,b)};goog.userAgent.isVersionOrHigherCache_={};goog.userAgent.isVersionOrHigher=function(a){return goog.userAgent.ASSUME_ANY_VERSION||goog.reflect.cache(goog.userAgent.isVersionOrHigherCache_,a,function(){return 0<=goog.string.compareVersions(goog.userAgent.VERSION,a)})};goog.userAgent.isVersion=goog.userAgent.isVersionOrHigher;
goog.userAgent.isDocumentModeOrHigher=function(a){return Number(goog.userAgent.DOCUMENT_MODE)>=a};goog.userAgent.isDocumentMode=goog.userAgent.isDocumentModeOrHigher;goog.userAgent.DOCUMENT_MODE=function(){var a=goog.global.document,b=goog.userAgent.getDocumentMode_();if(a&&goog.userAgent.IE)return b||("CSS1Compat"==a.compatMode?parseInt(goog.userAgent.VERSION,10):5)}();goog.userAgent.product={};goog.userAgent.product.ASSUME_FIREFOX=!1;goog.userAgent.product.ASSUME_IPHONE=!1;goog.userAgent.product.ASSUME_IPAD=!1;goog.userAgent.product.ASSUME_ANDROID=!1;goog.userAgent.product.ASSUME_CHROME=!1;goog.userAgent.product.ASSUME_SAFARI=!1;
goog.userAgent.product.PRODUCT_KNOWN_=goog.userAgent.ASSUME_IE||goog.userAgent.ASSUME_EDGE||goog.userAgent.ASSUME_OPERA||goog.userAgent.product.ASSUME_FIREFOX||goog.userAgent.product.ASSUME_IPHONE||goog.userAgent.product.ASSUME_IPAD||goog.userAgent.product.ASSUME_ANDROID||goog.userAgent.product.ASSUME_CHROME||goog.userAgent.product.ASSUME_SAFARI;goog.userAgent.product.OPERA=goog.userAgent.OPERA;goog.userAgent.product.IE=goog.userAgent.IE;goog.userAgent.product.EDGE=goog.userAgent.EDGE;
goog.userAgent.product.FIREFOX=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_FIREFOX:goog.labs.userAgent.browser.isFirefox();goog.userAgent.product.isIphoneOrIpod_=function(){return goog.labs.userAgent.platform.isIphone()||goog.labs.userAgent.platform.isIpod()};goog.userAgent.product.IPHONE=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_IPHONE:goog.userAgent.product.isIphoneOrIpod_();
goog.userAgent.product.IPAD=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_IPAD:goog.labs.userAgent.platform.isIpad();goog.userAgent.product.ANDROID=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_ANDROID:goog.labs.userAgent.browser.isAndroidBrowser();goog.userAgent.product.CHROME=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_CHROME:goog.labs.userAgent.browser.isChrome();
goog.userAgent.product.isSafariDesktop_=function(){return goog.labs.userAgent.browser.isSafari()&&!goog.labs.userAgent.platform.isIos()};goog.userAgent.product.SAFARI=goog.userAgent.product.PRODUCT_KNOWN_?goog.userAgent.product.ASSUME_SAFARI:goog.userAgent.product.isSafariDesktop_();goog.crypt.base64={};goog.crypt.base64.byteToCharMap_=null;goog.crypt.base64.charToByteMap_=null;goog.crypt.base64.byteToCharMapWebSafe_=null;goog.crypt.base64.ENCODED_VALS_BASE="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";goog.crypt.base64.ENCODED_VALS=goog.crypt.base64.ENCODED_VALS_BASE+"+/=";goog.crypt.base64.ENCODED_VALS_WEBSAFE=goog.crypt.base64.ENCODED_VALS_BASE+"-_.";
goog.crypt.base64.ASSUME_NATIVE_SUPPORT_=goog.userAgent.GECKO||goog.userAgent.WEBKIT&&!goog.userAgent.product.SAFARI||goog.userAgent.OPERA;goog.crypt.base64.HAS_NATIVE_ENCODE_=goog.crypt.base64.ASSUME_NATIVE_SUPPORT_||"function"==typeof goog.global.btoa;goog.crypt.base64.HAS_NATIVE_DECODE_=goog.crypt.base64.ASSUME_NATIVE_SUPPORT_||!goog.userAgent.product.SAFARI&&!goog.userAgent.IE&&"function"==typeof goog.global.atob;
goog.crypt.base64.encodeByteArray=function(a,b){goog.asserts.assert(goog.isArrayLike(a),"encodeByteArray takes an array as a parameter");goog.crypt.base64.init_();b=b?goog.crypt.base64.byteToCharMapWebSafe_:goog.crypt.base64.byteToCharMap_;for(var c=[],d=0;d<a.length;d+=3){var e=a[d],f=d+1<a.length,g=f?a[d+1]:0,h=d+2<a.length,k=h?a[d+2]:0,l=e>>2;e=(e&3)<<4|g>>4;g=(g&15)<<2|k>>6;k&=63;h||(k=64,f||(g=64));c.push(b[l],b[e],b[g],b[k])}return c.join("")};
goog.crypt.base64.encodeString=function(a,b){return goog.crypt.base64.HAS_NATIVE_ENCODE_&&!b?goog.global.btoa(a):goog.crypt.base64.encodeByteArray(goog.crypt.stringToByteArray(a),b)};goog.crypt.base64.decodeString=function(a,b){if(goog.crypt.base64.HAS_NATIVE_DECODE_&&!b)return goog.global.atob(a);var c="";goog.crypt.base64.decodeStringInternal_(a,function(a){c+=String.fromCharCode(a)});return c};
goog.crypt.base64.decodeStringToByteArray=function(a,b){var c=[];goog.crypt.base64.decodeStringInternal_(a,function(a){c.push(a)});return c};
goog.crypt.base64.decodeStringToUint8Array=function(a){goog.asserts.assert(!goog.userAgent.IE||goog.userAgent.isVersionOrHigher("10"),"Browser does not support typed arrays");var b=a.length,c=0;"="===a[b-2]?c=2:"="===a[b-1]&&(c=1);var d=new Uint8Array(Math.ceil(3*b/4)-c),e=0;goog.crypt.base64.decodeStringInternal_(a,function(a){d[e++]=a});return d.subarray(0,e)};
goog.crypt.base64.decodeStringInternal_=function(a,b){function c(b){for(;d<a.length;){var c=a.charAt(d++),e=goog.crypt.base64.charToByteMap_[c];if(null!=e)return e;if(!goog.string.isEmptyOrWhitespace(c))throw Error("Unknown base64 encoding at char: "+c);}return b}goog.crypt.base64.init_();for(var d=0;;){var e=c(-1),f=c(0),g=c(64),h=c(64);if(64===h&&-1===e)break;b(e<<2|f>>4);64!=g&&(b(f<<4&240|g>>2),64!=h&&b(g<<6&192|h))}};
goog.crypt.base64.init_=function(){if(!goog.crypt.base64.byteToCharMap_){goog.crypt.base64.byteToCharMap_={};goog.crypt.base64.charToByteMap_={};goog.crypt.base64.byteToCharMapWebSafe_={};for(var a=0;a<goog.crypt.base64.ENCODED_VALS.length;a++)goog.crypt.base64.byteToCharMap_[a]=goog.crypt.base64.ENCODED_VALS.charAt(a),goog.crypt.base64.charToByteMap_[goog.crypt.base64.byteToCharMap_[a]]=a,goog.crypt.base64.byteToCharMapWebSafe_[a]=goog.crypt.base64.ENCODED_VALS_WEBSAFE.charAt(a),a>=goog.crypt.base64.ENCODED_VALS_BASE.length&&
(goog.crypt.base64.charToByteMap_[goog.crypt.base64.ENCODED_VALS_WEBSAFE.charAt(a)]=a)}};jspb.utils={};jspb.utils.split64Low=0;jspb.utils.split64High=0;jspb.utils.splitUint64=function(a){var b=a>>>0;a=Math.floor((a-b)/jspb.BinaryConstants.TWO_TO_32)>>>0;jspb.utils.split64Low=b;jspb.utils.split64High=a};jspb.utils.splitInt64=function(a){var b=0>a;a=Math.abs(a);var c=a>>>0;a=Math.floor((a-c)/jspb.BinaryConstants.TWO_TO_32);a>>>=0;b&&(a=~a>>>0,c=(~c>>>0)+1,4294967295<c&&(c=0,a++,4294967295<a&&(a=0)));jspb.utils.split64Low=c;jspb.utils.split64High=a};
jspb.utils.splitZigzag64=function(a){var b=0>a;a=2*Math.abs(a);jspb.utils.splitUint64(a);a=jspb.utils.split64Low;var c=jspb.utils.split64High;b&&(0==a?0==c?c=a=4294967295:(c--,a=4294967295):a--);jspb.utils.split64Low=a;jspb.utils.split64High=c};
jspb.utils.splitFloat32=function(a){var b=0>a?1:0;a=b?-a:a;if(0===a)0<1/a?(jspb.utils.split64High=0,jspb.utils.split64Low=0):(jspb.utils.split64High=0,jspb.utils.split64Low=2147483648);else if(isNaN(a))jspb.utils.split64High=0,jspb.utils.split64Low=2147483647;else if(a>jspb.BinaryConstants.FLOAT32_MAX)jspb.utils.split64High=0,jspb.utils.split64Low=(b<<31|2139095040)>>>0;else if(a<jspb.BinaryConstants.FLOAT32_MIN)a=Math.round(a/Math.pow(2,-149)),jspb.utils.split64High=0,jspb.utils.split64Low=(b<<31|
a)>>>0;else{var c=Math.floor(Math.log(a)/Math.LN2);a*=Math.pow(2,-c);a=Math.round(a*jspb.BinaryConstants.TWO_TO_23)&8388607;jspb.utils.split64High=0;jspb.utils.split64Low=(b<<31|c+127<<23|a)>>>0}};
jspb.utils.splitFloat64=function(a){var b=0>a?1:0;a=b?-a:a;if(0===a)jspb.utils.split64High=0<1/a?0:2147483648,jspb.utils.split64Low=0;else if(isNaN(a))jspb.utils.split64High=2147483647,jspb.utils.split64Low=4294967295;else if(a>jspb.BinaryConstants.FLOAT64_MAX)jspb.utils.split64High=(b<<31|2146435072)>>>0,jspb.utils.split64Low=0;else if(a<jspb.BinaryConstants.FLOAT64_MIN){var c=a/Math.pow(2,-1074);a=c/jspb.BinaryConstants.TWO_TO_32;jspb.utils.split64High=(b<<31|a)>>>0;jspb.utils.split64Low=c>>>0}else{var d=
Math.floor(Math.log(a)/Math.LN2);1024==d&&(d=1023);c=a*Math.pow(2,-d);a=c*jspb.BinaryConstants.TWO_TO_20&1048575;c=c*jspb.BinaryConstants.TWO_TO_52>>>0;jspb.utils.split64High=(b<<31|d+1023<<20|a)>>>0;jspb.utils.split64Low=c}};
jspb.utils.splitHash64=function(a){var b=a.charCodeAt(0),c=a.charCodeAt(1),d=a.charCodeAt(2),e=a.charCodeAt(3),f=a.charCodeAt(4),g=a.charCodeAt(5),h=a.charCodeAt(6);a=a.charCodeAt(7);jspb.utils.split64Low=b+(c<<8)+(d<<16)+(e<<24)>>>0;jspb.utils.split64High=f+(g<<8)+(h<<16)+(a<<24)>>>0};jspb.utils.joinUint64=function(a,b){return b*jspb.BinaryConstants.TWO_TO_32+a};
jspb.utils.joinInt64=function(a,b){var c=b&2147483648;c&&(a=~a+1>>>0,b=~b>>>0,0==a&&(b=b+1>>>0));a=jspb.utils.joinUint64(a,b);return c?-a:a};jspb.utils.joinZigzag64=function(a,b){var c=a&1;a=(a>>>1|b<<31)>>>0;b>>>=1;c&&(a=a+1>>>0,0==a&&(b=b+1>>>0));a=jspb.utils.joinUint64(a,b);return c?-a:a};jspb.utils.joinFloat32=function(a,b){b=2*(a>>31)+1;var c=a>>>23&255;a&=8388607;return 255==c?a?NaN:Infinity*b:0==c?b*Math.pow(2,-149)*a:b*Math.pow(2,c-150)*(a+Math.pow(2,23))};
jspb.utils.joinFloat64=function(a,b){var c=2*(b>>31)+1,d=b>>>20&2047;a=jspb.BinaryConstants.TWO_TO_32*(b&1048575)+a;return 2047==d?a?NaN:Infinity*c:0==d?c*Math.pow(2,-1074)*a:c*Math.pow(2,d-1075)*(a+jspb.BinaryConstants.TWO_TO_52)};jspb.utils.joinHash64=function(a,b){return String.fromCharCode(a>>>0&255,a>>>8&255,a>>>16&255,a>>>24&255,b>>>0&255,b>>>8&255,b>>>16&255,b>>>24&255)};jspb.utils.DIGITS="0123456789abcdef".split("");
jspb.utils.joinUnsignedDecimalString=function(a,b){function c(a){for(var b=1E7,c=0;7>c;c++){b/=10;var d=a/b%10>>>0;if(0!=d||f)f=!0,g+=e[d]}}if(2097151>=b)return""+(jspb.BinaryConstants.TWO_TO_32*b+a);var d=(a>>>24|b<<8)>>>0&16777215;b=b>>16&65535;a=(a&16777215)+6777216*d+6710656*b;d+=8147497*b;b*=2;1E7<=a&&(d+=Math.floor(a/1E7),a%=1E7);1E7<=d&&(b+=Math.floor(d/1E7),d%=1E7);var e=jspb.utils.DIGITS,f=!1,g="";(b||f)&&c(b);(d||f)&&c(d);(a||f)&&c(a);return g};
jspb.utils.joinSignedDecimalString=function(a,b){var c=b&2147483648;c&&(a=~a+1>>>0,b=~b+(0==a?1:0)>>>0);a=jspb.utils.joinUnsignedDecimalString(a,b);return c?"-"+a:a};jspb.utils.hash64ToDecimalString=function(a,b){jspb.utils.splitHash64(a);a=jspb.utils.split64Low;var c=jspb.utils.split64High;return b?jspb.utils.joinSignedDecimalString(a,c):jspb.utils.joinUnsignedDecimalString(a,c)};
jspb.utils.hash64ArrayToDecimalStrings=function(a,b){for(var c=Array(a.length),d=0;d<a.length;d++)c[d]=jspb.utils.hash64ToDecimalString(a[d],b);return c};jspb.utils.decimalStringToHash64=function(a){function b(a,b){for(var c=0;8>c&&(1!==a||0<b);c++)b=a*e[c]+b,e[c]=b&255,b>>>=8}function c(){for(var a=0;8>a;a++)e[a]=~e[a]&255}goog.asserts.assert(0<a.length);var d=!1;"-"===a[0]&&(d=!0,a=a.slice(1));for(var e=[0,0,0,0,0,0,0,0],f=0;f<a.length;f++)b(10,jspb.utils.DIGITS.indexOf(a[f]));d&&(c(),b(1,1));return goog.crypt.byteArrayToString(e)};
jspb.utils.splitDecimalString=function(a){jspb.utils.splitHash64(jspb.utils.decimalStringToHash64(a))};jspb.utils.hash64ToHexString=function(a){var b=Array(18);b[0]="0";b[1]="x";for(var c=0;8>c;c++){var d=a.charCodeAt(7-c);b[2*c+2]=jspb.utils.DIGITS[d>>4];b[2*c+3]=jspb.utils.DIGITS[d&15]}return b.join("")};
jspb.utils.hexStringToHash64=function(a){a=a.toLowerCase();goog.asserts.assert(18==a.length);goog.asserts.assert("0"==a[0]);goog.asserts.assert("x"==a[1]);for(var b="",c=0;8>c;c++){var d=jspb.utils.DIGITS.indexOf(a[2*c+2]),e=jspb.utils.DIGITS.indexOf(a[2*c+3]);b=String.fromCharCode(16*d+e)+b}return b};jspb.utils.hash64ToNumber=function(a,b){jspb.utils.splitHash64(a);a=jspb.utils.split64Low;var c=jspb.utils.split64High;return b?jspb.utils.joinInt64(a,c):jspb.utils.joinUint64(a,c)};
jspb.utils.numberToHash64=function(a){jspb.utils.splitInt64(a);return jspb.utils.joinHash64(jspb.utils.split64Low,jspb.utils.split64High)};jspb.utils.countVarints=function(a,b,c){for(var d=0,e=b;e<c;e++)d+=a[e]>>7;return c-b-d};
jspb.utils.countVarintFields=function(a,b,c,d){var e=0;d=8*d+jspb.BinaryConstants.WireType.VARINT;if(128>d)for(;b<c&&a[b++]==d;)for(e++;;){var f=a[b++];if(0==(f&128))break}else for(;b<c;){for(f=d;128<f;){if(a[b]!=(f&127|128))return e;b++;f>>=7}if(a[b++]!=f)break;for(e++;f=a[b++],0!=(f&128););}return e};jspb.utils.countFixedFields_=function(a,b,c,d,e){var f=0;if(128>d)for(;b<c&&a[b++]==d;)f++,b+=e;else for(;b<c;){for(var g=d;128<g;){if(a[b++]!=(g&127|128))return f;g>>=7}if(a[b++]!=g)break;f++;b+=e}return f};
jspb.utils.countFixed32Fields=function(a,b,c,d){return jspb.utils.countFixedFields_(a,b,c,8*d+jspb.BinaryConstants.WireType.FIXED32,4)};jspb.utils.countFixed64Fields=function(a,b,c,d){return jspb.utils.countFixedFields_(a,b,c,8*d+jspb.BinaryConstants.WireType.FIXED64,8)};
jspb.utils.countDelimitedFields=function(a,b,c,d){var e=0;for(d=8*d+jspb.BinaryConstants.WireType.DELIMITED;b<c;){for(var f=d;128<f;){if(a[b++]!=(f&127|128))return e;f>>=7}if(a[b++]!=f)break;e++;for(var g=0,h=1;f=a[b++],g+=(f&127)*h,h*=128,0!=(f&128););b+=g}return e};jspb.utils.debugBytesToTextFormat=function(a){var b='"';if(a){a=jspb.utils.byteSourceToUint8Array(a);for(var c=0;c<a.length;c++)b+="\\x",16>a[c]&&(b+="0"),b+=a[c].toString(16)}return b+'"'};
jspb.utils.debugScalarToTextFormat=function(a){return goog.isString(a)?goog.string.quote(a):a.toString()};jspb.utils.stringToByteArray=function(a){for(var b=new Uint8Array(a.length),c=0;c<a.length;c++){var d=a.charCodeAt(c);if(255<d)throw Error("Conversion error: string contains codepoint outside of byte range");b[c]=d}return b};
jspb.utils.byteSourceToUint8Array=function(a){if(a.constructor===Uint8Array)return a;if(a.constructor===ArrayBuffer||"undefined"!=typeof Buffer&&a.constructor===Buffer||a.constructor===Array)return new Uint8Array(a);if(a.constructor===String)return goog.crypt.base64.decodeStringToUint8Array(a);goog.asserts.fail("Type not convertible to Uint8Array.");return new Uint8Array(0)};jspb.BinaryIterator=function(a,b,c){this.elements_=this.nextMethod_=this.decoder_=null;this.cursor_=0;this.nextValue_=null;this.atEnd_=!0;this.init_(a,b,c)};jspb.BinaryIterator.prototype.init_=function(a,b,c){a&&b&&(this.decoder_=a,this.nextMethod_=b);this.elements_=c||null;this.cursor_=0;this.nextValue_=null;this.atEnd_=!this.decoder_&&!this.elements_;this.next()};jspb.BinaryIterator.instanceCache_=[];
jspb.BinaryIterator.alloc=function(a,b,c){if(jspb.BinaryIterator.instanceCache_.length){var d=jspb.BinaryIterator.instanceCache_.pop();d.init_(a,b,c);return d}return new jspb.BinaryIterator(a,b,c)};jspb.BinaryIterator.prototype.free=function(){this.clear();100>jspb.BinaryIterator.instanceCache_.length&&jspb.BinaryIterator.instanceCache_.push(this)};
jspb.BinaryIterator.prototype.clear=function(){this.decoder_&&this.decoder_.free();this.elements_=this.nextMethod_=this.decoder_=null;this.cursor_=0;this.nextValue_=null;this.atEnd_=!0};jspb.BinaryIterator.prototype.get=function(){return this.nextValue_};jspb.BinaryIterator.prototype.atEnd=function(){return this.atEnd_};
jspb.BinaryIterator.prototype.next=function(){var a=this.nextValue_;this.decoder_?this.decoder_.atEnd()?(this.nextValue_=null,this.atEnd_=!0):this.nextValue_=this.nextMethod_.call(this.decoder_):this.elements_&&(this.cursor_==this.elements_.length?(this.nextValue_=null,this.atEnd_=!0):this.nextValue_=this.elements_[this.cursor_++]);return a};jspb.BinaryDecoder=function(a,b,c){this.bytes_=null;this.tempHigh_=this.tempLow_=this.cursor_=this.end_=this.start_=0;this.error_=!1;a&&this.setBlock(a,b,c)};
jspb.BinaryDecoder.instanceCache_=[];jspb.BinaryDecoder.alloc=function(a,b,c){if(jspb.BinaryDecoder.instanceCache_.length){var d=jspb.BinaryDecoder.instanceCache_.pop();a&&d.setBlock(a,b,c);return d}return new jspb.BinaryDecoder(a,b,c)};jspb.BinaryDecoder.prototype.free=function(){this.clear();100>jspb.BinaryDecoder.instanceCache_.length&&jspb.BinaryDecoder.instanceCache_.push(this)};jspb.BinaryDecoder.prototype.clone=function(){return jspb.BinaryDecoder.alloc(this.bytes_,this.start_,this.end_-this.start_)};
jspb.BinaryDecoder.prototype.clear=function(){this.bytes_=null;this.cursor_=this.end_=this.start_=0;this.error_=!1};jspb.BinaryDecoder.prototype.getBuffer=function(){return this.bytes_};jspb.BinaryDecoder.prototype.setBlock=function(a,b,c){this.bytes_=jspb.utils.byteSourceToUint8Array(a);this.start_=goog.isDef(b)?b:0;this.end_=goog.isDef(c)?this.start_+c:this.bytes_.length;this.cursor_=this.start_};jspb.BinaryDecoder.prototype.getEnd=function(){return this.end_};
jspb.BinaryDecoder.prototype.setEnd=function(a){this.end_=a};jspb.BinaryDecoder.prototype.reset=function(){this.cursor_=this.start_};jspb.BinaryDecoder.prototype.getCursor=function(){return this.cursor_};jspb.BinaryDecoder.prototype.setCursor=function(a){this.cursor_=a};jspb.BinaryDecoder.prototype.advance=function(a){this.cursor_+=a;goog.asserts.assert(this.cursor_<=this.end_)};jspb.BinaryDecoder.prototype.atEnd=function(){return this.cursor_==this.end_};
jspb.BinaryDecoder.prototype.pastEnd=function(){return this.cursor_>this.end_};jspb.BinaryDecoder.prototype.getError=function(){return this.error_||0>this.cursor_||this.cursor_>this.end_};
jspb.BinaryDecoder.prototype.readSplitVarint64_=function(){for(var a,b=0,c,d=0;4>d;d++)if(a=this.bytes_[this.cursor_++],b|=(a&127)<<7*d,128>a){this.tempLow_=b>>>0;this.tempHigh_=0;return}a=this.bytes_[this.cursor_++];b|=(a&127)<<28;c=0|(a&127)>>4;if(128>a)this.tempLow_=b>>>0,this.tempHigh_=c>>>0;else{for(d=0;5>d;d++)if(a=this.bytes_[this.cursor_++],c|=(a&127)<<7*d+3,128>a){this.tempLow_=b>>>0;this.tempHigh_=c>>>0;return}goog.asserts.fail("Failed to read varint, encoding is invalid.");this.error_=
!0}};jspb.BinaryDecoder.prototype.skipVarint=function(){for(;this.bytes_[this.cursor_]&128;)this.cursor_++;this.cursor_++};jspb.BinaryDecoder.prototype.unskipVarint=function(a){for(;128<a;)this.cursor_--,a>>>=7;this.cursor_--};
jspb.BinaryDecoder.prototype.readUnsignedVarint32=function(){var a=this.bytes_;var b=a[this.cursor_+0];var c=b&127;if(128>b)return this.cursor_+=1,goog.asserts.assert(this.cursor_<=this.end_),c;b=a[this.cursor_+1];c|=(b&127)<<7;if(128>b)return this.cursor_+=2,goog.asserts.assert(this.cursor_<=this.end_),c;b=a[this.cursor_+2];c|=(b&127)<<14;if(128>b)return this.cursor_+=3,goog.asserts.assert(this.cursor_<=this.end_),c;b=a[this.cursor_+3];c|=(b&127)<<21;if(128>b)return this.cursor_+=4,goog.asserts.assert(this.cursor_<=
this.end_),c;b=a[this.cursor_+4];c|=(b&15)<<28;if(128>b)return this.cursor_+=5,goog.asserts.assert(this.cursor_<=this.end_),c>>>0;this.cursor_+=5;128<=a[this.cursor_++]&&128<=a[this.cursor_++]&&128<=a[this.cursor_++]&&128<=a[this.cursor_++]&&128<=a[this.cursor_++]&&goog.asserts.assert(!1);goog.asserts.assert(this.cursor_<=this.end_);return c};jspb.BinaryDecoder.prototype.readSignedVarint32=jspb.BinaryDecoder.prototype.readUnsignedVarint32;jspb.BinaryDecoder.prototype.readUnsignedVarint32String=function(){return this.readUnsignedVarint32().toString()};
jspb.BinaryDecoder.prototype.readSignedVarint32String=function(){return this.readSignedVarint32().toString()};jspb.BinaryDecoder.prototype.readZigzagVarint32=function(){var a=this.readUnsignedVarint32();return a>>>1^-(a&1)};jspb.BinaryDecoder.prototype.readUnsignedVarint64=function(){this.readSplitVarint64_();return jspb.utils.joinUint64(this.tempLow_,this.tempHigh_)};
jspb.BinaryDecoder.prototype.readUnsignedVarint64String=function(){this.readSplitVarint64_();return jspb.utils.joinUnsignedDecimalString(this.tempLow_,this.tempHigh_)};jspb.BinaryDecoder.prototype.readSignedVarint64=function(){this.readSplitVarint64_();return jspb.utils.joinInt64(this.tempLow_,this.tempHigh_)};jspb.BinaryDecoder.prototype.readSignedVarint64String=function(){this.readSplitVarint64_();return jspb.utils.joinSignedDecimalString(this.tempLow_,this.tempHigh_)};
jspb.BinaryDecoder.prototype.readZigzagVarint64=function(){this.readSplitVarint64_();return jspb.utils.joinZigzag64(this.tempLow_,this.tempHigh_)};jspb.BinaryDecoder.prototype.readZigzagVarint64String=function(){return this.readZigzagVarint64().toString()};jspb.BinaryDecoder.prototype.readUint8=function(){var a=this.bytes_[this.cursor_+0];this.cursor_+=1;goog.asserts.assert(this.cursor_<=this.end_);return a};
jspb.BinaryDecoder.prototype.readUint16=function(){var a=this.bytes_[this.cursor_+0],b=this.bytes_[this.cursor_+1];this.cursor_+=2;goog.asserts.assert(this.cursor_<=this.end_);return a<<0|b<<8};jspb.BinaryDecoder.prototype.readUint32=function(){var a=this.bytes_[this.cursor_+0],b=this.bytes_[this.cursor_+1],c=this.bytes_[this.cursor_+2],d=this.bytes_[this.cursor_+3];this.cursor_+=4;goog.asserts.assert(this.cursor_<=this.end_);return(a<<0|b<<8|c<<16|d<<24)>>>0};
jspb.BinaryDecoder.prototype.readUint64=function(){var a=this.readUint32(),b=this.readUint32();return jspb.utils.joinUint64(a,b)};jspb.BinaryDecoder.prototype.readUint64String=function(){var a=this.readUint32(),b=this.readUint32();return jspb.utils.joinUnsignedDecimalString(a,b)};jspb.BinaryDecoder.prototype.readInt8=function(){var a=this.bytes_[this.cursor_+0];this.cursor_+=1;goog.asserts.assert(this.cursor_<=this.end_);return a<<24>>24};
jspb.BinaryDecoder.prototype.readInt16=function(){var a=this.bytes_[this.cursor_+0],b=this.bytes_[this.cursor_+1];this.cursor_+=2;goog.asserts.assert(this.cursor_<=this.end_);return(a<<0|b<<8)<<16>>16};jspb.BinaryDecoder.prototype.readInt32=function(){var a=this.bytes_[this.cursor_+0],b=this.bytes_[this.cursor_+1],c=this.bytes_[this.cursor_+2],d=this.bytes_[this.cursor_+3];this.cursor_+=4;goog.asserts.assert(this.cursor_<=this.end_);return a<<0|b<<8|c<<16|d<<24};
jspb.BinaryDecoder.prototype.readInt64=function(){var a=this.readUint32(),b=this.readUint32();return jspb.utils.joinInt64(a,b)};jspb.BinaryDecoder.prototype.readInt64String=function(){var a=this.readUint32(),b=this.readUint32();return jspb.utils.joinSignedDecimalString(a,b)};jspb.BinaryDecoder.prototype.readFloat=function(){var a=this.readUint32();return jspb.utils.joinFloat32(a,0)};
jspb.BinaryDecoder.prototype.readDouble=function(){var a=this.readUint32(),b=this.readUint32();return jspb.utils.joinFloat64(a,b)};jspb.BinaryDecoder.prototype.readBool=function(){return!!this.bytes_[this.cursor_++]};jspb.BinaryDecoder.prototype.readEnum=function(){return this.readSignedVarint32()};
jspb.BinaryDecoder.prototype.readString=function(a){var b=this.bytes_,c=this.cursor_;a=c+a;for(var d=[],e="";c<a;){var f=b[c++];if(128>f)d.push(f);else if(192>f)continue;else if(224>f){var g=b[c++];d.push((f&31)<<6|g&63)}else if(240>f){g=b[c++];var h=b[c++];d.push((f&15)<<12|(g&63)<<6|h&63)}else if(248>f){g=b[c++];h=b[c++];var k=b[c++];f=(f&7)<<18|(g&63)<<12|(h&63)<<6|k&63;f-=65536;d.push((f>>10&1023)+55296,(f&1023)+56320)}8192<=d.length&&(e+=String.fromCharCode.apply(null,d),d.length=0)}e+=goog.crypt.byteArrayToString(d);
this.cursor_=c;return e};jspb.BinaryDecoder.prototype.readStringWithLength=function(){var a=this.readUnsignedVarint32();return this.readString(a)};jspb.BinaryDecoder.prototype.readBytes=function(a){if(0>a||this.cursor_+a>this.bytes_.length)return this.error_=!0,goog.asserts.fail("Invalid byte length!"),new Uint8Array(0);var b=this.bytes_.subarray(this.cursor_,this.cursor_+a);this.cursor_+=a;goog.asserts.assert(this.cursor_<=this.end_);return b};
jspb.BinaryDecoder.prototype.readVarintHash64=function(){this.readSplitVarint64_();return jspb.utils.joinHash64(this.tempLow_,this.tempHigh_)};jspb.BinaryDecoder.prototype.readFixedHash64=function(){var a=this.bytes_,b=this.cursor_,c=a[b+0],d=a[b+1],e=a[b+2],f=a[b+3],g=a[b+4],h=a[b+5],k=a[b+6];a=a[b+7];this.cursor_+=8;return String.fromCharCode(c,d,e,f,g,h,k,a)};jspb.BinaryReader=function(a,b,c){this.decoder_=jspb.BinaryDecoder.alloc(a,b,c);this.fieldCursor_=this.decoder_.getCursor();this.nextField_=jspb.BinaryConstants.INVALID_FIELD_NUMBER;this.nextWireType_=jspb.BinaryConstants.WireType.INVALID;this.error_=!1;this.readCallbacks_=null};jspb.BinaryReader.instanceCache_=[];
jspb.BinaryReader.alloc=function(a,b,c){if(jspb.BinaryReader.instanceCache_.length){var d=jspb.BinaryReader.instanceCache_.pop();a&&d.decoder_.setBlock(a,b,c);return d}return new jspb.BinaryReader(a,b,c)};jspb.BinaryReader.prototype.alloc=jspb.BinaryReader.alloc;
jspb.BinaryReader.prototype.free=function(){this.decoder_.clear();this.nextField_=jspb.BinaryConstants.INVALID_FIELD_NUMBER;this.nextWireType_=jspb.BinaryConstants.WireType.INVALID;this.error_=!1;this.readCallbacks_=null;100>jspb.BinaryReader.instanceCache_.length&&jspb.BinaryReader.instanceCache_.push(this)};jspb.BinaryReader.prototype.getFieldCursor=function(){return this.fieldCursor_};jspb.BinaryReader.prototype.getCursor=function(){return this.decoder_.getCursor()};
jspb.BinaryReader.prototype.getBuffer=function(){return this.decoder_.getBuffer()};jspb.BinaryReader.prototype.getFieldNumber=function(){return this.nextField_};jspb.BinaryReader.prototype.getWireType=function(){return this.nextWireType_};jspb.BinaryReader.prototype.isEndGroup=function(){return this.nextWireType_==jspb.BinaryConstants.WireType.END_GROUP};jspb.BinaryReader.prototype.getError=function(){return this.error_||this.decoder_.getError()};
jspb.BinaryReader.prototype.setBlock=function(a,b,c){this.decoder_.setBlock(a,b,c);this.nextField_=jspb.BinaryConstants.INVALID_FIELD_NUMBER;this.nextWireType_=jspb.BinaryConstants.WireType.INVALID};jspb.BinaryReader.prototype.reset=function(){this.decoder_.reset();this.nextField_=jspb.BinaryConstants.INVALID_FIELD_NUMBER;this.nextWireType_=jspb.BinaryConstants.WireType.INVALID};jspb.BinaryReader.prototype.advance=function(a){this.decoder_.advance(a)};
jspb.BinaryReader.prototype.nextField=function(){if(this.decoder_.atEnd())return!1;if(this.getError())return goog.asserts.fail("Decoder hit an error"),!1;this.fieldCursor_=this.decoder_.getCursor();var a=this.decoder_.readUnsignedVarint32(),b=a>>>3;a&=7;if(a!=jspb.BinaryConstants.WireType.VARINT&&a!=jspb.BinaryConstants.WireType.FIXED32&&a!=jspb.BinaryConstants.WireType.FIXED64&&a!=jspb.BinaryConstants.WireType.DELIMITED&&a!=jspb.BinaryConstants.WireType.START_GROUP&&a!=jspb.BinaryConstants.WireType.END_GROUP)return goog.asserts.fail("Invalid wire type: %s (at position %s)",
a,this.fieldCursor_),this.error_=!0,!1;this.nextField_=b;this.nextWireType_=a;return!0};jspb.BinaryReader.prototype.unskipHeader=function(){this.decoder_.unskipVarint(this.nextField_<<3|this.nextWireType_)};jspb.BinaryReader.prototype.skipMatchingFields=function(){var a=this.nextField_;for(this.unskipHeader();this.nextField()&&this.getFieldNumber()==a;)this.skipField();this.decoder_.atEnd()||this.unskipHeader()};
jspb.BinaryReader.prototype.skipVarintField=function(){this.nextWireType_!=jspb.BinaryConstants.WireType.VARINT?(goog.asserts.fail("Invalid wire type for skipVarintField"),this.skipField()):this.decoder_.skipVarint()};jspb.BinaryReader.prototype.skipDelimitedField=function(){if(this.nextWireType_!=jspb.BinaryConstants.WireType.DELIMITED)goog.asserts.fail("Invalid wire type for skipDelimitedField"),this.skipField();else{var a=this.decoder_.readUnsignedVarint32();this.decoder_.advance(a)}};
jspb.BinaryReader.prototype.skipFixed32Field=function(){this.nextWireType_!=jspb.BinaryConstants.WireType.FIXED32?(goog.asserts.fail("Invalid wire type for skipFixed32Field"),this.skipField()):this.decoder_.advance(4)};jspb.BinaryReader.prototype.skipFixed64Field=function(){this.nextWireType_!=jspb.BinaryConstants.WireType.FIXED64?(goog.asserts.fail("Invalid wire type for skipFixed64Field"),this.skipField()):this.decoder_.advance(8)};
jspb.BinaryReader.prototype.skipGroup=function(){var a=this.nextField_;do{if(!this.nextField()){goog.asserts.fail("Unmatched start-group tag: stream EOF");this.error_=!0;break}if(this.nextWireType_==jspb.BinaryConstants.WireType.END_GROUP){this.nextField_!=a&&(goog.asserts.fail("Unmatched end-group tag"),this.error_=!0);break}this.skipField()}while(1)};
jspb.BinaryReader.prototype.skipField=function(){switch(this.nextWireType_){case jspb.BinaryConstants.WireType.VARINT:this.skipVarintField();break;case jspb.BinaryConstants.WireType.FIXED64:this.skipFixed64Field();break;case jspb.BinaryConstants.WireType.DELIMITED:this.skipDelimitedField();break;case jspb.BinaryConstants.WireType.FIXED32:this.skipFixed32Field();break;case jspb.BinaryConstants.WireType.START_GROUP:this.skipGroup();break;default:goog.asserts.fail("Invalid wire encoding for field.")}};
jspb.BinaryReader.prototype.registerReadCallback=function(a,b){goog.isNull(this.readCallbacks_)&&(this.readCallbacks_={});goog.asserts.assert(!this.readCallbacks_[a]);this.readCallbacks_[a]=b};jspb.BinaryReader.prototype.runReadCallback=function(a){goog.asserts.assert(!goog.isNull(this.readCallbacks_));a=this.readCallbacks_[a];goog.asserts.assert(a);return a(this)};
jspb.BinaryReader.prototype.readAny=function(a){this.nextWireType_=jspb.BinaryConstants.FieldTypeToWireType(a);var b=jspb.BinaryConstants.FieldType;switch(a){case b.DOUBLE:return this.readDouble();case b.FLOAT:return this.readFloat();case b.INT64:return this.readInt64();case b.UINT64:return this.readUint64();case b.INT32:return this.readInt32();case b.FIXED64:return this.readFixed64();case b.FIXED32:return this.readFixed32();case b.BOOL:return this.readBool();case b.STRING:return this.readString();
case b.GROUP:goog.asserts.fail("Group field type not supported in readAny()");case b.MESSAGE:goog.asserts.fail("Message field type not supported in readAny()");case b.BYTES:return this.readBytes();case b.UINT32:return this.readUint32();case b.ENUM:return this.readEnum();case b.SFIXED32:return this.readSfixed32();case b.SFIXED64:return this.readSfixed64();case b.SINT32:return this.readSint32();case b.SINT64:return this.readSint64();case b.FHASH64:return this.readFixedHash64();case b.VHASH64:return this.readVarintHash64();
default:goog.asserts.fail("Invalid field type in readAny()")}return 0};jspb.BinaryReader.prototype.readMessage=function(a,b){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var c=this.decoder_.getEnd(),d=this.decoder_.readUnsignedVarint32();d=this.decoder_.getCursor()+d;this.decoder_.setEnd(d);b(a,this);this.decoder_.setCursor(d);this.decoder_.setEnd(c)};
jspb.BinaryReader.prototype.readGroup=function(a,b,c){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.START_GROUP);goog.asserts.assert(this.nextField_==a);c(b,this);this.error_||this.nextWireType_==jspb.BinaryConstants.WireType.END_GROUP||(goog.asserts.fail("Group submessage did not end with an END_GROUP tag"),this.error_=!0)};
jspb.BinaryReader.prototype.getFieldDecoder=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var a=this.decoder_.readUnsignedVarint32(),b=this.decoder_.getCursor(),c=b+a;a=jspb.BinaryDecoder.alloc(this.decoder_.getBuffer(),b,a);this.decoder_.setCursor(c);return a};jspb.BinaryReader.prototype.readInt32=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readSignedVarint32()};
jspb.BinaryReader.prototype.readInt32String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readSignedVarint32String()};jspb.BinaryReader.prototype.readInt64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readSignedVarint64()};jspb.BinaryReader.prototype.readInt64String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readSignedVarint64String()};
jspb.BinaryReader.prototype.readUint32=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readUnsignedVarint32()};jspb.BinaryReader.prototype.readUint32String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readUnsignedVarint32String()};jspb.BinaryReader.prototype.readUint64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readUnsignedVarint64()};
jspb.BinaryReader.prototype.readUint64String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readUnsignedVarint64String()};jspb.BinaryReader.prototype.readSint32=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readZigzagVarint32()};jspb.BinaryReader.prototype.readSint64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readZigzagVarint64()};
jspb.BinaryReader.prototype.readSint64String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readZigzagVarint64String()};jspb.BinaryReader.prototype.readFixed32=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED32);return this.decoder_.readUint32()};jspb.BinaryReader.prototype.readFixed64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64);return this.decoder_.readUint64()};
jspb.BinaryReader.prototype.readFixed64String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64);return this.decoder_.readUint64String()};jspb.BinaryReader.prototype.readSfixed32=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED32);return this.decoder_.readInt32()};jspb.BinaryReader.prototype.readSfixed32String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED32);return this.decoder_.readInt32().toString()};
jspb.BinaryReader.prototype.readSfixed64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64);return this.decoder_.readInt64()};jspb.BinaryReader.prototype.readSfixed64String=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64);return this.decoder_.readInt64String()};jspb.BinaryReader.prototype.readFloat=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED32);return this.decoder_.readFloat()};
jspb.BinaryReader.prototype.readDouble=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64);return this.decoder_.readDouble()};jspb.BinaryReader.prototype.readBool=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return!!this.decoder_.readUnsignedVarint32()};jspb.BinaryReader.prototype.readEnum=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readSignedVarint64()};
jspb.BinaryReader.prototype.readString=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var a=this.decoder_.readUnsignedVarint32();return this.decoder_.readString(a)};jspb.BinaryReader.prototype.readBytes=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var a=this.decoder_.readUnsignedVarint32();return this.decoder_.readBytes(a)};
jspb.BinaryReader.prototype.readVarintHash64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.VARINT);return this.decoder_.readVarintHash64()};jspb.BinaryReader.prototype.readFixedHash64=function(){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.FIXED64);return this.decoder_.readFixedHash64()};
jspb.BinaryReader.prototype.readPackedField_=function(a){goog.asserts.assert(this.nextWireType_==jspb.BinaryConstants.WireType.DELIMITED);var b=this.decoder_.readUnsignedVarint32();b=this.decoder_.getCursor()+b;for(var c=[];this.decoder_.getCursor()<b;)c.push(a.call(this.decoder_));return c};jspb.BinaryReader.prototype.readPackedInt32=function(){return this.readPackedField_(this.decoder_.readSignedVarint32)};jspb.BinaryReader.prototype.readPackedInt32String=function(){return this.readPackedField_(this.decoder_.readSignedVarint32String)};
jspb.BinaryReader.prototype.readPackedInt64=function(){return this.readPackedField_(this.decoder_.readSignedVarint64)};jspb.BinaryReader.prototype.readPackedInt64String=function(){return this.readPackedField_(this.decoder_.readSignedVarint64String)};jspb.BinaryReader.prototype.readPackedUint32=function(){return this.readPackedField_(this.decoder_.readUnsignedVarint32)};jspb.BinaryReader.prototype.readPackedUint32String=function(){return this.readPackedField_(this.decoder_.readUnsignedVarint32String)};
jspb.BinaryReader.prototype.readPackedUint64=function(){return this.readPackedField_(this.decoder_.readUnsignedVarint64)};jspb.BinaryReader.prototype.readPackedUint64String=function(){return this.readPackedField_(this.decoder_.readUnsignedVarint64String)};jspb.BinaryReader.prototype.readPackedSint32=function(){return this.readPackedField_(this.decoder_.readZigzagVarint32)};jspb.BinaryReader.prototype.readPackedSint64=function(){return this.readPackedField_(this.decoder_.readZigzagVarint64)};
jspb.BinaryReader.prototype.readPackedSint64String=function(){return this.readPackedField_(this.decoder_.readZigzagVarint64String)};jspb.BinaryReader.prototype.readPackedFixed32=function(){return this.readPackedField_(this.decoder_.readUint32)};jspb.BinaryReader.prototype.readPackedFixed64=function(){return this.readPackedField_(this.decoder_.readUint64)};jspb.BinaryReader.prototype.readPackedFixed64String=function(){return this.readPackedField_(this.decoder_.readUint64String)};
jspb.BinaryReader.prototype.readPackedSfixed32=function(){return this.readPackedField_(this.decoder_.readInt32)};jspb.BinaryReader.prototype.readPackedSfixed64=function(){return this.readPackedField_(this.decoder_.readInt64)};jspb.BinaryReader.prototype.readPackedSfixed64String=function(){return this.readPackedField_(this.decoder_.readInt64String)};jspb.BinaryReader.prototype.readPackedFloat=function(){return this.readPackedField_(this.decoder_.readFloat)};
jspb.BinaryReader.prototype.readPackedDouble=function(){return this.readPackedField_(this.decoder_.readDouble)};jspb.BinaryReader.prototype.readPackedBool=function(){return this.readPackedField_(this.decoder_.readBool)};jspb.BinaryReader.prototype.readPackedEnum=function(){return this.readPackedField_(this.decoder_.readEnum)};jspb.BinaryReader.prototype.readPackedVarintHash64=function(){return this.readPackedField_(this.decoder_.readVarintHash64)};
jspb.BinaryReader.prototype.readPackedFixedHash64=function(){return this.readPackedField_(this.decoder_.readFixedHash64)};jspb.Map=function(a,b){this.arr_=a;this.valueCtor_=b;this.map_={};this.arrClean=!0;0<this.arr_.length&&this.loadFromArray_()};jspb.Map.prototype.loadFromArray_=function(){for(var a=0;a<this.arr_.length;a++){var b=this.arr_[a],c=b[0];this.map_[c.toString()]=new jspb.Map.Entry_(c,b[1])}this.arrClean=!0};
jspb.Map.prototype.toArray=function(){if(this.arrClean){if(this.valueCtor_){var a=this.map_,b;for(b in a)if(Object.prototype.hasOwnProperty.call(a,b)){var c=a[b].valueWrapper;c&&c.toArray()}}}else{this.arr_.length=0;a=this.stringKeys_();a.sort();for(b=0;b<a.length;b++){var d=this.map_[a[b]];(c=d.valueWrapper)&&c.toArray();this.arr_.push([d.key,d.value])}this.arrClean=!0}return this.arr_};
jspb.Map.prototype.toObject=function(a,b){for(var c=this.toArray(),d=[],e=0;e<c.length;e++){var f=this.map_[c[e][0].toString()];this.wrapEntry_(f);var g=f.valueWrapper;g?(goog.asserts.assert(b),d.push([f.key,b(a,g)])):d.push([f.key,f.value])}return d};jspb.Map.fromObject=function(a,b,c){b=new jspb.Map([],b);for(var d=0;d<a.length;d++){var e=a[d][0],f=c(a[d][1]);b.set(e,f)}return b};jspb.Map.ArrayIteratorIterable_=function(a){this.idx_=0;this.arr_=a};
jspb.Map.ArrayIteratorIterable_.prototype.next=function(){return this.idx_<this.arr_.length?{done:!1,value:this.arr_[this.idx_++]}:{done:!0,value:void 0}};"undefined"!=typeof Symbol&&(jspb.Map.ArrayIteratorIterable_.prototype[Symbol.iterator]=function(){return this});jspb.Map.prototype.getLength=function(){return this.stringKeys_().length};jspb.Map.prototype.clear=function(){this.map_={};this.arrClean=!1};
jspb.Map.prototype.del=function(a){a=a.toString();var b=this.map_.hasOwnProperty(a);delete this.map_[a];this.arrClean=!1;return b};jspb.Map.prototype.getEntryList=function(){var a=[],b=this.stringKeys_();b.sort();for(var c=0;c<b.length;c++){var d=this.map_[b[c]];a.push([d.key,d.value])}return a};jspb.Map.prototype.entries=function(){var a=[],b=this.stringKeys_();b.sort();for(var c=0;c<b.length;c++){var d=this.map_[b[c]];a.push([d.key,this.wrapEntry_(d)])}return new jspb.Map.ArrayIteratorIterable_(a)};
jspb.Map.prototype.keys=function(){var a=[],b=this.stringKeys_();b.sort();for(var c=0;c<b.length;c++)a.push(this.map_[b[c]].key);return new jspb.Map.ArrayIteratorIterable_(a)};jspb.Map.prototype.values=function(){var a=[],b=this.stringKeys_();b.sort();for(var c=0;c<b.length;c++)a.push(this.wrapEntry_(this.map_[b[c]]));return new jspb.Map.ArrayIteratorIterable_(a)};
jspb.Map.prototype.forEach=function(a,b){var c=this.stringKeys_();c.sort();for(var d=0;d<c.length;d++){var e=this.map_[c[d]];a.call(b,this.wrapEntry_(e),e.key,this)}};jspb.Map.prototype.set=function(a,b){var c=new jspb.Map.Entry_(a);this.valueCtor_?(c.valueWrapper=b,c.value=b.toArray()):c.value=b;this.map_[a.toString()]=c;this.arrClean=!1;return this};jspb.Map.prototype.wrapEntry_=function(a){return this.valueCtor_?(a.valueWrapper||(a.valueWrapper=new this.valueCtor_(a.value)),a.valueWrapper):a.value};
jspb.Map.prototype.get=function(a){if(a=this.map_[a.toString()])return this.wrapEntry_(a)};jspb.Map.prototype.has=function(a){return a.toString()in this.map_};jspb.Map.prototype.serializeBinary=function(a,b,c,d,e){var f=this.stringKeys_();f.sort();for(var g=0;g<f.length;g++){var h=this.map_[f[g]];b.beginSubMessage(a);c.call(b,1,h.key);this.valueCtor_?d.call(b,2,this.wrapEntry_(h),e):d.call(b,2,h.value);b.endSubMessage()}};
jspb.Map.deserializeBinary=function(a,b,c,d,e,f){for(var g=void 0;b.nextField()&&!b.isEndGroup();){var h=b.getFieldNumber();1==h?f=c.call(b):2==h&&(a.valueCtor_?(goog.asserts.assert(e),g=new a.valueCtor_,d.call(b,g,e)):g=d.call(b))}goog.asserts.assert(void 0!=f);goog.asserts.assert(void 0!=g);a.set(f,g)};jspb.Map.prototype.stringKeys_=function(){var a=this.map_,b=[],c;for(c in a)Object.prototype.hasOwnProperty.call(a,c)&&b.push(c);return b};
jspb.Map.Entry_=function(a,b){this.key=a;this.value=b;this.valueWrapper=void 0};jspb.ExtensionFieldInfo=function(a,b,c,d,e){this.fieldIndex=a;this.fieldName=b;this.ctor=c;this.toObjectFn=d;this.isRepeated=e};jspb.ExtensionFieldBinaryInfo=function(a,b,c,d,e,f){this.fieldInfo=a;this.binaryReaderFn=b;this.binaryWriterFn=c;this.binaryMessageSerializeFn=d;this.binaryMessageDeserializeFn=e;this.isPacked=f};jspb.ExtensionFieldInfo.prototype.isMessageType=function(){return!!this.ctor};jspb.Message=function(){};jspb.Message.GENERATE_TO_OBJECT=!0;jspb.Message.GENERATE_FROM_OBJECT=!goog.DISALLOW_TEST_ONLY_CODE;
jspb.Message.GENERATE_TO_STRING=!0;jspb.Message.ASSUME_LOCAL_ARRAYS=!1;jspb.Message.SERIALIZE_EMPTY_TRAILING_FIELDS=!0;jspb.Message.SUPPORTS_UINT8ARRAY_="function"==typeof Uint8Array;jspb.Message.prototype.getJsPbMessageId=function(){return this.messageId_};jspb.Message.getIndex_=function(a,b){return b+a.arrayIndexOffset_};jspb.Message.hiddenES6Property_=function(){};jspb.Message.getFieldNumber_=function(a,b){return b-a.arrayIndexOffset_};
jspb.Message.initialize=function(a,b,c,d,e,f){a.wrappers_=null;b||(b=c?[c]:[]);a.messageId_=c?String(c):void 0;a.arrayIndexOffset_=0===c?-1:0;a.array=b;jspb.Message.initPivotAndExtensionObject_(a,d);a.convertedPrimitiveFields_={};jspb.Message.SERIALIZE_EMPTY_TRAILING_FIELDS||(a.repeatedFields=e);if(e)for(b=0;b<e.length;b++)c=e[b],c<a.pivot_?(c=jspb.Message.getIndex_(a,c),a.array[c]=a.array[c]||jspb.Message.EMPTY_LIST_SENTINEL_):(jspb.Message.maybeInitEmptyExtensionObject_(a),a.extensionObject_[c]=
a.extensionObject_[c]||jspb.Message.EMPTY_LIST_SENTINEL_);if(f&&f.length)for(b=0;b<f.length;b++)jspb.Message.computeOneofCase(a,f[b])};jspb.Message.EMPTY_LIST_SENTINEL_=goog.DEBUG&&Object.freeze?Object.freeze([]):[];jspb.Message.isArray_=function(a){return jspb.Message.ASSUME_LOCAL_ARRAYS?a instanceof Array:goog.isArray(a)};jspb.Message.isExtensionObject_=function(a){return null!==a&&"object"==typeof a&&!jspb.Message.isArray_(a)&&!(jspb.Message.SUPPORTS_UINT8ARRAY_&&a instanceof Uint8Array)};
jspb.Message.initPivotAndExtensionObject_=function(a,b){var c=a.array.length,d=-1;if(c&&(d=c-1,c=a.array[d],jspb.Message.isExtensionObject_(c))){a.pivot_=jspb.Message.getFieldNumber_(a,d);a.extensionObject_=c;return}-1<b?(a.pivot_=Math.max(b,jspb.Message.getFieldNumber_(a,d+1)),a.extensionObject_=null):a.pivot_=Number.MAX_VALUE};jspb.Message.maybeInitEmptyExtensionObject_=function(a){var b=jspb.Message.getIndex_(a,a.pivot_);a.array[b]||(a.extensionObject_=a.array[b]={})};
jspb.Message.toObjectList=function(a,b,c){for(var d=[],e=0;e<a.length;e++)d[e]=b.call(a[e],c,a[e]);return d};jspb.Message.toObjectExtension=function(a,b,c,d,e){for(var f in c){var g=c[f],h=d.call(a,g);if(null!=h){for(var k in g.fieldName)if(g.fieldName.hasOwnProperty(k))break;b[k]=g.toObjectFn?g.isRepeated?jspb.Message.toObjectList(h,g.toObjectFn,e):g.toObjectFn(e,h):h}}};
jspb.Message.serializeBinaryExtensions=function(a,b,c,d){for(var e in c){var f=c[e],g=f.fieldInfo;if(!f.binaryWriterFn)throw Error("Message extension present that was generated without binary serialization support");var h=d.call(a,g);if(null!=h)if(g.isMessageType())if(f.binaryMessageSerializeFn)f.binaryWriterFn.call(b,g.fieldIndex,h,f.binaryMessageSerializeFn);else throw Error("Message extension present holding submessage without binary support enabled, and message is being serialized to binary format");
else f.binaryWriterFn.call(b,g.fieldIndex,h)}};jspb.Message.readBinaryExtension=function(a,b,c,d,e){var f=c[b.getFieldNumber()];if(f){c=f.fieldInfo;if(!f.binaryReaderFn)throw Error("Deserializing extension whose generated code does not support binary format");if(c.isMessageType()){var g=new c.ctor;f.binaryReaderFn.call(b,g,f.binaryMessageDeserializeFn)}else g=f.binaryReaderFn.call(b);c.isRepeated&&!f.isPacked?(b=d.call(a,c))?b.push(g):e.call(a,c,[g]):e.call(a,c,g)}else b.skipField()};
jspb.Message.getField=function(a,b){if(b<a.pivot_){b=jspb.Message.getIndex_(a,b);var c=a.array[b];return c===jspb.Message.EMPTY_LIST_SENTINEL_?a.array[b]=[]:c}if(a.extensionObject_)return c=a.extensionObject_[b],c===jspb.Message.EMPTY_LIST_SENTINEL_?a.extensionObject_[b]=[]:c};jspb.Message.getRepeatedField=function(a,b){return jspb.Message.getField(a,b)};jspb.Message.getOptionalFloatingPointField=function(a,b){a=jspb.Message.getField(a,b);return null==a?a:+a};
jspb.Message.getBooleanField=function(a,b){a=jspb.Message.getField(a,b);return null==a?a:!!a};jspb.Message.getRepeatedFloatingPointField=function(a,b){var c=jspb.Message.getRepeatedField(a,b);a.convertedPrimitiveFields_||(a.convertedPrimitiveFields_={});if(!a.convertedPrimitiveFields_[b]){for(var d=0;d<c.length;d++)c[d]=+c[d];a.convertedPrimitiveFields_[b]=!0}return c};
jspb.Message.getRepeatedBooleanField=function(a,b){var c=jspb.Message.getRepeatedField(a,b);a.convertedPrimitiveFields_||(a.convertedPrimitiveFields_={});if(!a.convertedPrimitiveFields_[b]){for(var d=0;d<c.length;d++)c[d]=!!c[d];a.convertedPrimitiveFields_[b]=!0}return c};
jspb.Message.bytesAsB64=function(a){if(null==a||goog.isString(a))return a;if(jspb.Message.SUPPORTS_UINT8ARRAY_&&a instanceof Uint8Array)return goog.crypt.base64.encodeByteArray(a);goog.asserts.fail("Cannot coerce to b64 string: "+goog.typeOf(a));return null};jspb.Message.bytesAsU8=function(a){if(null==a||a instanceof Uint8Array)return a;if(goog.isString(a))return goog.crypt.base64.decodeStringToUint8Array(a);goog.asserts.fail("Cannot coerce to Uint8Array: "+goog.typeOf(a));return null};
jspb.Message.bytesListAsB64=function(a){jspb.Message.assertConsistentTypes_(a);return!a.length||goog.isString(a[0])?a:goog.array.map(a,jspb.Message.bytesAsB64)};jspb.Message.bytesListAsU8=function(a){jspb.Message.assertConsistentTypes_(a);return!a.length||a[0]instanceof Uint8Array?a:goog.array.map(a,jspb.Message.bytesAsU8)};
jspb.Message.assertConsistentTypes_=function(a){if(goog.DEBUG&&a&&1<a.length){var b=goog.typeOf(a[0]);goog.array.forEach(a,function(a){goog.typeOf(a)!=b&&goog.asserts.fail("Inconsistent type in JSPB repeated field array. Got "+goog.typeOf(a)+" expected "+b)})}};jspb.Message.getFieldWithDefault=function(a,b,c){a=jspb.Message.getField(a,b);return null==a?c:a};jspb.Message.getBooleanFieldWithDefault=function(a,b,c){a=jspb.Message.getBooleanField(a,b);return null==a?c:a};
jspb.Message.getFloatingPointFieldWithDefault=function(a,b,c){a=jspb.Message.getOptionalFloatingPointField(a,b);return null==a?c:a};jspb.Message.getFieldProto3=jspb.Message.getFieldWithDefault;jspb.Message.getMapField=function(a,b,c,d){a.wrappers_||(a.wrappers_={});if(b in a.wrappers_)return a.wrappers_[b];var e=jspb.Message.getField(a,b);if(!e){if(c)return;e=[];jspb.Message.setField(a,b,e)}return a.wrappers_[b]=new jspb.Map(e,d)};
jspb.Message.setField=function(a,b,c){b<a.pivot_?a.array[jspb.Message.getIndex_(a,b)]=c:(jspb.Message.maybeInitEmptyExtensionObject_(a),a.extensionObject_[b]=c)};jspb.Message.setProto3IntField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,0)};jspb.Message.setProto3FloatField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,0)};jspb.Message.setProto3BooleanField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,!1)};
jspb.Message.setProto3StringField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,"")};jspb.Message.setProto3BytesField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,"")};jspb.Message.setProto3EnumField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,0)};jspb.Message.setProto3StringIntField=function(a,b,c){jspb.Message.setFieldIgnoringDefault_(a,b,c,"0")};
jspb.Message.setFieldIgnoringDefault_=function(a,b,c,d){c!==d?jspb.Message.setField(a,b,c):a.array[jspb.Message.getIndex_(a,b)]=null};jspb.Message.addToRepeatedField=function(a,b,c,d){a=jspb.Message.getRepeatedField(a,b);void 0!=d?a.splice(d,0,c):a.push(c)};jspb.Message.setOneofField=function(a,b,c,d){(c=jspb.Message.computeOneofCase(a,c))&&c!==b&&void 0!==d&&(a.wrappers_&&c in a.wrappers_&&(a.wrappers_[c]=void 0),jspb.Message.setField(a,c,void 0));jspb.Message.setField(a,b,d)};
jspb.Message.computeOneofCase=function(a,b){for(var c,d,e=0;e<b.length;e++){var f=b[e],g=jspb.Message.getField(a,f);null!=g&&(c=f,d=g,jspb.Message.setField(a,f,void 0))}return c?(jspb.Message.setField(a,c,d),c):0};jspb.Message.getWrapperField=function(a,b,c,d){a.wrappers_||(a.wrappers_={});if(!a.wrappers_[c]){var e=jspb.Message.getField(a,c);if(d||e)a.wrappers_[c]=new b(e)}return a.wrappers_[c]};
jspb.Message.getRepeatedWrapperField=function(a,b,c){jspb.Message.wrapRepeatedField_(a,b,c);b=a.wrappers_[c];b==jspb.Message.EMPTY_LIST_SENTINEL_&&(b=a.wrappers_[c]=[]);return b};jspb.Message.wrapRepeatedField_=function(a,b,c){a.wrappers_||(a.wrappers_={});if(!a.wrappers_[c]){for(var d=jspb.Message.getRepeatedField(a,c),e=[],f=0;f<d.length;f++)e[f]=new b(d[f]);a.wrappers_[c]=e}};
jspb.Message.setWrapperField=function(a,b,c){a.wrappers_||(a.wrappers_={});var d=c?c.toArray():c;a.wrappers_[b]=c;jspb.Message.setField(a,b,d)};jspb.Message.setOneofWrapperField=function(a,b,c,d){a.wrappers_||(a.wrappers_={});var e=d?d.toArray():d;a.wrappers_[b]=d;jspb.Message.setOneofField(a,b,c,e)};jspb.Message.setRepeatedWrapperField=function(a,b,c){a.wrappers_||(a.wrappers_={});c=c||[];for(var d=[],e=0;e<c.length;e++)d[e]=c[e].toArray();a.wrappers_[b]=c;jspb.Message.setField(a,b,d)};
jspb.Message.addToRepeatedWrapperField=function(a,b,c,d,e){jspb.Message.wrapRepeatedField_(a,d,b);var f=a.wrappers_[b];f||(f=a.wrappers_[b]=[]);c=c?c:new d;a=jspb.Message.getRepeatedField(a,b);void 0!=e?(f.splice(e,0,c),a.splice(e,0,c.toArray())):(f.push(c),a.push(c.toArray()));return c};jspb.Message.toMap=function(a,b,c,d){for(var e={},f=0;f<a.length;f++)e[b.call(a[f])]=c?c.call(a[f],d,a[f]):a[f];return e};
jspb.Message.prototype.syncMapFields_=function(){if(this.wrappers_)for(var a in this.wrappers_){var b=this.wrappers_[a];if(goog.isArray(b))for(var c=0;c<b.length;c++)b[c]&&b[c].toArray();else b&&b.toArray()}};jspb.Message.prototype.toArray=function(){this.syncMapFields_();return this.array};jspb.Message.GENERATE_TO_STRING&&(jspb.Message.prototype.toString=function(){this.syncMapFields_();return this.array.toString()});
jspb.Message.prototype.getExtension=function(a){if(this.extensionObject_){this.wrappers_||(this.wrappers_={});var b=a.fieldIndex;if(a.isRepeated){if(a.isMessageType())return this.wrappers_[b]||(this.wrappers_[b]=goog.array.map(this.extensionObject_[b]||[],function(b){return new a.ctor(b)})),this.wrappers_[b]}else if(a.isMessageType())return!this.wrappers_[b]&&this.extensionObject_[b]&&(this.wrappers_[b]=new a.ctor(this.extensionObject_[b])),this.wrappers_[b];return this.extensionObject_[b]}};
jspb.Message.prototype.setExtension=function(a,b){this.wrappers_||(this.wrappers_={});jspb.Message.maybeInitEmptyExtensionObject_(this);var c=a.fieldIndex;a.isRepeated?(b=b||[],a.isMessageType()?(this.wrappers_[c]=b,this.extensionObject_[c]=goog.array.map(b,function(a){return a.toArray()})):this.extensionObject_[c]=b):a.isMessageType()?(this.wrappers_[c]=b,this.extensionObject_[c]=b?b.toArray():b):this.extensionObject_[c]=b;return this};
jspb.Message.difference=function(a,b){if(!(a instanceof b.constructor))throw Error("Messages have different types.");var c=a.toArray();b=b.toArray();var d=[],e=0,f=c.length>b.length?c.length:b.length;a.getJsPbMessageId()&&(d[0]=a.getJsPbMessageId(),e=1);for(;e<f;e++)jspb.Message.compareFields(c[e],b[e])||(d[e]=b[e]);return new a.constructor(d)};jspb.Message.equals=function(a,b){return a==b||!(!a||!b)&&a instanceof b.constructor&&jspb.Message.compareFields(a.toArray(),b.toArray())};
jspb.Message.compareExtensions=function(a,b){a=a||{};b=b||{};var c={},d;for(d in a)c[d]=0;for(d in b)c[d]=0;for(d in c)if(!jspb.Message.compareFields(a[d],b[d]))return!1;return!0};
jspb.Message.compareFields=function(a,b){if(a==b)return!0;if(!goog.isObject(a)||!goog.isObject(b))return goog.isNumber(a)&&isNaN(a)||goog.isNumber(b)&&isNaN(b)?String(a)==String(b):!1;if(a.constructor!=b.constructor)return!1;if(jspb.Message.SUPPORTS_UINT8ARRAY_&&a.constructor===Uint8Array){if(a.length!=b.length)return!1;for(var c=0;c<a.length;c++)if(a[c]!=b[c])return!1;return!0}if(a.constructor===Array){var d=void 0,e=void 0,f=Math.max(a.length,b.length);for(c=0;c<f;c++){var g=a[c],h=b[c];g&&g.constructor==
Object&&(goog.asserts.assert(void 0===d),goog.asserts.assert(c===a.length-1),d=g,g=void 0);h&&h.constructor==Object&&(goog.asserts.assert(void 0===e),goog.asserts.assert(c===b.length-1),e=h,h=void 0);if(!jspb.Message.compareFields(g,h))return!1}return d||e?(d=d||{},e=e||{},jspb.Message.compareExtensions(d,e)):!0}if(a.constructor===Object)return jspb.Message.compareExtensions(a,b);throw Error("Invalid type in JSPB array");};jspb.Message.prototype.cloneMessage=function(){return jspb.Message.cloneMessage(this)};
jspb.Message.prototype.clone=function(){return jspb.Message.cloneMessage(this)};jspb.Message.clone=function(a){return jspb.Message.cloneMessage(a)};jspb.Message.cloneMessage=function(a){return new a.constructor(jspb.Message.clone_(a.toArray()))};
jspb.Message.copyInto=function(a,b){goog.asserts.assertInstanceof(a,jspb.Message);goog.asserts.assertInstanceof(b,jspb.Message);goog.asserts.assert(a.constructor==b.constructor,"Copy source and target message should have the same type.");a=jspb.Message.clone(a);for(var c=b.toArray(),d=a.toArray(),e=c.length=0;e<d.length;e++)c[e]=d[e];b.wrappers_=a.wrappers_;b.extensionObject_=a.extensionObject_};
jspb.Message.clone_=function(a){if(goog.isArray(a)){for(var b=Array(a.length),c=0;c<a.length;c++){var d=a[c];null!=d&&(b[c]="object"==typeof d?jspb.Message.clone_(goog.asserts.assert(d)):d)}return b}if(jspb.Message.SUPPORTS_UINT8ARRAY_&&a instanceof Uint8Array)return new Uint8Array(a);b={};for(c in a)d=a[c],null!=d&&(b[c]="object"==typeof d?jspb.Message.clone_(goog.asserts.assert(d)):d);return b};jspb.Message.registerMessageType=function(a,b){jspb.Message.registry_[a]=b;b.messageId=a};
jspb.Message.registry_={};jspb.Message.messageSetExtensions={};jspb.Message.messageSetExtensionsBinary={};jspb.arith={};jspb.arith.UInt64=function(a,b){this.lo=a;this.hi=b};jspb.arith.UInt64.prototype.cmp=function(a){return this.hi<a.hi||this.hi==a.hi&&this.lo<a.lo?-1:this.hi==a.hi&&this.lo==a.lo?0:1};jspb.arith.UInt64.prototype.rightShift=function(){return new jspb.arith.UInt64((this.lo>>>1|(this.hi&1)<<31)>>>0,this.hi>>>1>>>0)};jspb.arith.UInt64.prototype.leftShift=function(){return new jspb.arith.UInt64(this.lo<<1>>>0,(this.hi<<1|this.lo>>>31)>>>0)};
jspb.arith.UInt64.prototype.msb=function(){return!!(this.hi&2147483648)};jspb.arith.UInt64.prototype.lsb=function(){return!!(this.lo&1)};jspb.arith.UInt64.prototype.zero=function(){return 0==this.lo&&0==this.hi};jspb.arith.UInt64.prototype.add=function(a){return new jspb.arith.UInt64((this.lo+a.lo&4294967295)>>>0>>>0,((this.hi+a.hi&4294967295)>>>0)+(4294967296<=this.lo+a.lo?1:0)>>>0)};
jspb.arith.UInt64.prototype.sub=function(a){return new jspb.arith.UInt64((this.lo-a.lo&4294967295)>>>0>>>0,((this.hi-a.hi&4294967295)>>>0)-(0>this.lo-a.lo?1:0)>>>0)};jspb.arith.UInt64.mul32x32=function(a,b){var c=a&65535;a>>>=16;var d=b&65535,e=b>>>16;b=c*d+65536*(c*e&65535)+65536*(a*d&65535);for(c=a*e+(c*e>>>16)+(a*d>>>16);4294967296<=b;)b-=4294967296,c+=1;return new jspb.arith.UInt64(b>>>0,c>>>0)};
jspb.arith.UInt64.prototype.mul=function(a){var b=jspb.arith.UInt64.mul32x32(this.lo,a);a=jspb.arith.UInt64.mul32x32(this.hi,a);a.hi=a.lo;a.lo=0;return b.add(a)};
jspb.arith.UInt64.prototype.div=function(a){if(0==a)return[];var b=new jspb.arith.UInt64(0,0),c=new jspb.arith.UInt64(this.lo,this.hi);a=new jspb.arith.UInt64(a,0);for(var d=new jspb.arith.UInt64(1,0);!a.msb();)a=a.leftShift(),d=d.leftShift();for(;!d.zero();)0>=a.cmp(c)&&(b=b.add(d),c=c.sub(a)),a=a.rightShift(),d=d.rightShift();return[b,c]};jspb.arith.UInt64.prototype.toString=function(){for(var a="",b=this;!b.zero();){b=b.div(10);var c=b[0];a=b[1].lo+a;b=c}""==a&&(a="0");return a};
jspb.arith.UInt64.fromString=function(a){for(var b=new jspb.arith.UInt64(0,0),c=new jspb.arith.UInt64(0,0),d=0;d<a.length;d++){if("0">a[d]||"9"<a[d])return null;var e=parseInt(a[d],10);c.lo=e;b=b.mul(10).add(c)}return b};jspb.arith.UInt64.prototype.clone=function(){return new jspb.arith.UInt64(this.lo,this.hi)};jspb.arith.Int64=function(a,b){this.lo=a;this.hi=b};
jspb.arith.Int64.prototype.add=function(a){return new jspb.arith.Int64((this.lo+a.lo&4294967295)>>>0>>>0,((this.hi+a.hi&4294967295)>>>0)+(4294967296<=this.lo+a.lo?1:0)>>>0)};jspb.arith.Int64.prototype.sub=function(a){return new jspb.arith.Int64((this.lo-a.lo&4294967295)>>>0>>>0,((this.hi-a.hi&4294967295)>>>0)-(0>this.lo-a.lo?1:0)>>>0)};jspb.arith.Int64.prototype.clone=function(){return new jspb.arith.Int64(this.lo,this.hi)};
jspb.arith.Int64.prototype.toString=function(){var a=0!=(this.hi&2147483648),b=new jspb.arith.UInt64(this.lo,this.hi);a&&(b=(new jspb.arith.UInt64(0,0)).sub(b));return(a?"-":"")+b.toString()};jspb.arith.Int64.fromString=function(a){var b=0<a.length&&"-"==a[0];b&&(a=a.substring(1));a=jspb.arith.UInt64.fromString(a);if(null===a)return null;b&&(a=(new jspb.arith.UInt64(0,0)).sub(a));return new jspb.arith.Int64(a.lo,a.hi)};jspb.BinaryEncoder=function(){this.buffer_=[]};jspb.BinaryEncoder.prototype.length=function(){return this.buffer_.length};jspb.BinaryEncoder.prototype.end=function(){var a=this.buffer_;this.buffer_=[];return a};
jspb.BinaryEncoder.prototype.writeSplitVarint64=function(a,b){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(b==Math.floor(b));goog.asserts.assert(0<=a&&a<jspb.BinaryConstants.TWO_TO_32);for(goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_32);0<b||127<a;)this.buffer_.push(a&127|128),a=(a>>>7|b<<25)>>>0,b>>>=7;this.buffer_.push(a)};
jspb.BinaryEncoder.prototype.writeSplitFixed64=function(a,b){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(b==Math.floor(b));goog.asserts.assert(0<=a&&a<jspb.BinaryConstants.TWO_TO_32);goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_32);this.writeUint32(a);this.writeUint32(b)};
jspb.BinaryEncoder.prototype.writeUnsignedVarint32=function(a){goog.asserts.assert(a==Math.floor(a));for(goog.asserts.assert(0<=a&&a<jspb.BinaryConstants.TWO_TO_32);127<a;)this.buffer_.push(a&127|128),a>>>=7;this.buffer_.push(a)};
jspb.BinaryEncoder.prototype.writeSignedVarint32=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_31&&a<jspb.BinaryConstants.TWO_TO_31);if(0<=a)this.writeUnsignedVarint32(a);else{for(var b=0;9>b;b++)this.buffer_.push(a&127|128),a>>=7;this.buffer_.push(1)}};
jspb.BinaryEncoder.prototype.writeUnsignedVarint64=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(0<=a&&a<jspb.BinaryConstants.TWO_TO_64);jspb.utils.splitInt64(a);this.writeSplitVarint64(jspb.utils.split64Low,jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeSignedVarint64=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_63&&a<jspb.BinaryConstants.TWO_TO_63);jspb.utils.splitInt64(a);this.writeSplitVarint64(jspb.utils.split64Low,jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeZigzagVarint32=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_31&&a<jspb.BinaryConstants.TWO_TO_31);this.writeUnsignedVarint32((a<<1^a>>31)>>>0)};jspb.BinaryEncoder.prototype.writeZigzagVarint64=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_63&&a<jspb.BinaryConstants.TWO_TO_63);jspb.utils.splitZigzag64(a);this.writeSplitVarint64(jspb.utils.split64Low,jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeZigzagVarint64String=function(a){this.writeZigzagVarint64(parseInt(a,10))};jspb.BinaryEncoder.prototype.writeUint8=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(0<=a&&256>a);this.buffer_.push(a>>>0&255)};jspb.BinaryEncoder.prototype.writeUint16=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(0<=a&&65536>a);this.buffer_.push(a>>>0&255);this.buffer_.push(a>>>8&255)};
jspb.BinaryEncoder.prototype.writeUint32=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(0<=a&&a<jspb.BinaryConstants.TWO_TO_32);this.buffer_.push(a>>>0&255);this.buffer_.push(a>>>8&255);this.buffer_.push(a>>>16&255);this.buffer_.push(a>>>24&255)};jspb.BinaryEncoder.prototype.writeUint64=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(0<=a&&a<jspb.BinaryConstants.TWO_TO_64);jspb.utils.splitUint64(a);this.writeUint32(jspb.utils.split64Low);this.writeUint32(jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeInt8=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(-128<=a&&128>a);this.buffer_.push(a>>>0&255)};jspb.BinaryEncoder.prototype.writeInt16=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(-32768<=a&&32768>a);this.buffer_.push(a>>>0&255);this.buffer_.push(a>>>8&255)};
jspb.BinaryEncoder.prototype.writeInt32=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_31&&a<jspb.BinaryConstants.TWO_TO_31);this.buffer_.push(a>>>0&255);this.buffer_.push(a>>>8&255);this.buffer_.push(a>>>16&255);this.buffer_.push(a>>>24&255)};
jspb.BinaryEncoder.prototype.writeInt64=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_63&&a<jspb.BinaryConstants.TWO_TO_63);jspb.utils.splitInt64(a);this.writeSplitFixed64(jspb.utils.split64Low,jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeInt64String=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(+a>=-jspb.BinaryConstants.TWO_TO_63&&+a<jspb.BinaryConstants.TWO_TO_63);jspb.utils.splitHash64(jspb.utils.decimalStringToHash64(a));this.writeSplitFixed64(jspb.utils.split64Low,jspb.utils.split64High)};jspb.BinaryEncoder.prototype.writeFloat=function(a){goog.asserts.assert(a>=-jspb.BinaryConstants.FLOAT32_MAX&&a<=jspb.BinaryConstants.FLOAT32_MAX);jspb.utils.splitFloat32(a);this.writeUint32(jspb.utils.split64Low)};
jspb.BinaryEncoder.prototype.writeDouble=function(a){goog.asserts.assert(a>=-jspb.BinaryConstants.FLOAT64_MAX&&a<=jspb.BinaryConstants.FLOAT64_MAX);jspb.utils.splitFloat64(a);this.writeUint32(jspb.utils.split64Low);this.writeUint32(jspb.utils.split64High)};jspb.BinaryEncoder.prototype.writeBool=function(a){goog.asserts.assert(goog.isBoolean(a)||goog.isNumber(a));this.buffer_.push(a?1:0)};
jspb.BinaryEncoder.prototype.writeEnum=function(a){goog.asserts.assert(a==Math.floor(a));goog.asserts.assert(a>=-jspb.BinaryConstants.TWO_TO_31&&a<jspb.BinaryConstants.TWO_TO_31);this.writeSignedVarint32(a)};jspb.BinaryEncoder.prototype.writeBytes=function(a){this.buffer_.push.apply(this.buffer_,a)};jspb.BinaryEncoder.prototype.writeVarintHash64=function(a){jspb.utils.splitHash64(a);this.writeSplitVarint64(jspb.utils.split64Low,jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeFixedHash64=function(a){jspb.utils.splitHash64(a);this.writeUint32(jspb.utils.split64Low);this.writeUint32(jspb.utils.split64High)};
jspb.BinaryEncoder.prototype.writeString=function(a){for(var b=this.buffer_.length,c=0;c<a.length;c++){var d=a.charCodeAt(c);if(128>d)this.buffer_.push(d);else if(2048>d)this.buffer_.push(d>>6|192),this.buffer_.push(d&63|128);else if(65536>d)if(55296<=d&&56319>=d&&c+1<a.length){var e=a.charCodeAt(c+1);56320<=e&&57343>=e&&(d=1024*(d-55296)+e-56320+65536,this.buffer_.push(d>>18|240),this.buffer_.push(d>>12&63|128),this.buffer_.push(d>>6&63|128),this.buffer_.push(d&63|128),c++)}else this.buffer_.push(d>>
12|224),this.buffer_.push(d>>6&63|128),this.buffer_.push(d&63|128)}return this.buffer_.length-b};jspb.BinaryWriter=function(){this.blocks_=[];this.totalLength_=0;this.encoder_=new jspb.BinaryEncoder;this.bookmarks_=[]};jspb.BinaryWriter.prototype.appendUint8Array_=function(a){var b=this.encoder_.end();this.blocks_.push(b);this.blocks_.push(a);this.totalLength_+=b.length+a.length};
jspb.BinaryWriter.prototype.beginDelimited_=function(a){this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED);a=this.encoder_.end();this.blocks_.push(a);this.totalLength_+=a.length;a.push(this.totalLength_);return a};jspb.BinaryWriter.prototype.endDelimited_=function(a){var b=a.pop();b=this.totalLength_+this.encoder_.length()-b;for(goog.asserts.assert(0<=b);127<b;)a.push(b&127|128),b>>>=7,this.totalLength_++;a.push(b);this.totalLength_++};
jspb.BinaryWriter.prototype.writeSerializedMessage=function(a,b,c){this.appendUint8Array_(a.subarray(b,c))};jspb.BinaryWriter.prototype.maybeWriteSerializedMessage=function(a,b,c){null!=a&&null!=b&&null!=c&&this.writeSerializedMessage(a,b,c)};jspb.BinaryWriter.prototype.reset=function(){this.blocks_=[];this.encoder_.end();this.totalLength_=0;this.bookmarks_=[]};
jspb.BinaryWriter.prototype.getResultBuffer=function(){goog.asserts.assert(0==this.bookmarks_.length);for(var a=new Uint8Array(this.totalLength_+this.encoder_.length()),b=this.blocks_,c=b.length,d=0,e=0;e<c;e++){var f=b[e];a.set(f,d);d+=f.length}b=this.encoder_.end();a.set(b,d);d+=b.length;goog.asserts.assert(d==a.length);this.blocks_=[a];return a};jspb.BinaryWriter.prototype.getResultBase64String=function(a){return goog.crypt.base64.encodeByteArray(this.getResultBuffer(),a)};
jspb.BinaryWriter.prototype.beginSubMessage=function(a){this.bookmarks_.push(this.beginDelimited_(a))};jspb.BinaryWriter.prototype.endSubMessage=function(){goog.asserts.assert(0<=this.bookmarks_.length);this.endDelimited_(this.bookmarks_.pop())};jspb.BinaryWriter.prototype.writeFieldHeader_=function(a,b){goog.asserts.assert(1<=a&&a==Math.floor(a));this.encoder_.writeUnsignedVarint32(8*a+b)};
jspb.BinaryWriter.prototype.writeAny=function(a,b,c){var d=jspb.BinaryConstants.FieldType;switch(a){case d.DOUBLE:this.writeDouble(b,c);break;case d.FLOAT:this.writeFloat(b,c);break;case d.INT64:this.writeInt64(b,c);break;case d.UINT64:this.writeUint64(b,c);break;case d.INT32:this.writeInt32(b,c);break;case d.FIXED64:this.writeFixed64(b,c);break;case d.FIXED32:this.writeFixed32(b,c);break;case d.BOOL:this.writeBool(b,c);break;case d.STRING:this.writeString(b,c);break;case d.GROUP:goog.asserts.fail("Group field type not supported in writeAny()");
break;case d.MESSAGE:goog.asserts.fail("Message field type not supported in writeAny()");break;case d.BYTES:this.writeBytes(b,c);break;case d.UINT32:this.writeUint32(b,c);break;case d.ENUM:this.writeEnum(b,c);break;case d.SFIXED32:this.writeSfixed32(b,c);break;case d.SFIXED64:this.writeSfixed64(b,c);break;case d.SINT32:this.writeSint32(b,c);break;case d.SINT64:this.writeSint64(b,c);break;case d.FHASH64:this.writeFixedHash64(b,c);break;case d.VHASH64:this.writeVarintHash64(b,c);break;default:goog.asserts.fail("Invalid field type in writeAny()")}};
jspb.BinaryWriter.prototype.writeUnsignedVarint32_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeUnsignedVarint32(b))};jspb.BinaryWriter.prototype.writeSignedVarint32_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSignedVarint32(b))};jspb.BinaryWriter.prototype.writeUnsignedVarint64_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeUnsignedVarint64(b))};
jspb.BinaryWriter.prototype.writeSignedVarint64_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSignedVarint64(b))};jspb.BinaryWriter.prototype.writeZigzagVarint32_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeZigzagVarint32(b))};jspb.BinaryWriter.prototype.writeZigzagVarint64_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeZigzagVarint64(b))};
jspb.BinaryWriter.prototype.writeZigzagVarint64String_=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeZigzagVarint64String(b))};jspb.BinaryWriter.prototype.writeInt32=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_31&&b<jspb.BinaryConstants.TWO_TO_31),this.writeSignedVarint32_(a,b))};
jspb.BinaryWriter.prototype.writeInt32String=function(a,b){null!=b&&(b=parseInt(b,10),goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_31&&b<jspb.BinaryConstants.TWO_TO_31),this.writeSignedVarint32_(a,b))};jspb.BinaryWriter.prototype.writeInt64=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_63&&b<jspb.BinaryConstants.TWO_TO_63),this.writeSignedVarint64_(a,b))};
jspb.BinaryWriter.prototype.writeInt64String=function(a,b){null!=b&&(b=jspb.arith.Int64.fromString(b),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSplitVarint64(b.lo,b.hi))};jspb.BinaryWriter.prototype.writeUint32=function(a,b){null!=b&&(goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_32),this.writeUnsignedVarint32_(a,b))};
jspb.BinaryWriter.prototype.writeUint32String=function(a,b){null!=b&&(b=parseInt(b,10),goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_32),this.writeUnsignedVarint32_(a,b))};jspb.BinaryWriter.prototype.writeUint64=function(a,b){null!=b&&(goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_64),this.writeUnsignedVarint64_(a,b))};
jspb.BinaryWriter.prototype.writeUint64String=function(a,b){null!=b&&(b=jspb.arith.UInt64.fromString(b),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSplitVarint64(b.lo,b.hi))};jspb.BinaryWriter.prototype.writeSint32=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_31&&b<jspb.BinaryConstants.TWO_TO_31),this.writeZigzagVarint32_(a,b))};
jspb.BinaryWriter.prototype.writeSint64=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_63&&b<jspb.BinaryConstants.TWO_TO_63),this.writeZigzagVarint64_(a,b))};jspb.BinaryWriter.prototype.writeSint64String=function(a,b){null!=b&&(goog.asserts.assert(+b>=-jspb.BinaryConstants.TWO_TO_63&&+b<jspb.BinaryConstants.TWO_TO_63),this.writeZigzagVarint64String_(a,b))};
jspb.BinaryWriter.prototype.writeFixed32=function(a,b){null!=b&&(goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_32),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED32),this.encoder_.writeUint32(b))};jspb.BinaryWriter.prototype.writeFixed64=function(a,b){null!=b&&(goog.asserts.assert(0<=b&&b<jspb.BinaryConstants.TWO_TO_64),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeUint64(b))};
jspb.BinaryWriter.prototype.writeFixed64String=function(a,b){null!=b&&(b=jspb.arith.UInt64.fromString(b),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeSplitFixed64(b.lo,b.hi))};jspb.BinaryWriter.prototype.writeSfixed32=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_31&&b<jspb.BinaryConstants.TWO_TO_31),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED32),this.encoder_.writeInt32(b))};
jspb.BinaryWriter.prototype.writeSfixed64=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_63&&b<jspb.BinaryConstants.TWO_TO_63),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeInt64(b))};jspb.BinaryWriter.prototype.writeSfixed64String=function(a,b){null!=b&&(b=jspb.arith.Int64.fromString(b),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeSplitFixed64(b.lo,b.hi))};
jspb.BinaryWriter.prototype.writeFloat=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED32),this.encoder_.writeFloat(b))};jspb.BinaryWriter.prototype.writeDouble=function(a,b){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeDouble(b))};jspb.BinaryWriter.prototype.writeBool=function(a,b){null!=b&&(goog.asserts.assert(goog.isBoolean(b)||goog.isNumber(b)),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeBool(b))};
jspb.BinaryWriter.prototype.writeEnum=function(a,b){null!=b&&(goog.asserts.assert(b>=-jspb.BinaryConstants.TWO_TO_31&&b<jspb.BinaryConstants.TWO_TO_31),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSignedVarint32(b))};jspb.BinaryWriter.prototype.writeString=function(a,b){null!=b&&(a=this.beginDelimited_(a),this.encoder_.writeString(b),this.endDelimited_(a))};
jspb.BinaryWriter.prototype.writeBytes=function(a,b){null!=b&&(b=jspb.utils.byteSourceToUint8Array(b),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(b.length),this.appendUint8Array_(b))};jspb.BinaryWriter.prototype.writeMessage=function(a,b,c){null!=b&&(a=this.beginDelimited_(a),c(b,this),this.endDelimited_(a))};
jspb.BinaryWriter.prototype.writeMessageSet=function(a,b,c){null!=b&&(this.writeFieldHeader_(1,jspb.BinaryConstants.WireType.START_GROUP),this.writeFieldHeader_(2,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeSignedVarint32(a),a=this.beginDelimited_(3),c(b,this),this.endDelimited_(a),this.writeFieldHeader_(1,jspb.BinaryConstants.WireType.END_GROUP))};
jspb.BinaryWriter.prototype.writeGroup=function(a,b,c){null!=b&&(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.START_GROUP),c(b,this),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.END_GROUP))};jspb.BinaryWriter.prototype.writeFixedHash64=function(a,b){null!=b&&(goog.asserts.assert(8==b.length),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.FIXED64),this.encoder_.writeFixedHash64(b))};
jspb.BinaryWriter.prototype.writeVarintHash64=function(a,b){null!=b&&(goog.asserts.assert(8==b.length),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.VARINT),this.encoder_.writeVarintHash64(b))};jspb.BinaryWriter.prototype.writeRepeatedInt32=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeSignedVarint32_(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedInt32String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeInt32String(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedInt64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeSignedVarint64_(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedInt64String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeInt64String(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedUint32=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeUnsignedVarint32_(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedUint32String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeUint32String(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedUint64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeUnsignedVarint64_(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedUint64String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeUint64String(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedSint32=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeZigzagVarint32_(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedSint64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeZigzagVarint64_(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedSint64String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeZigzagVarint64String_(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedFixed32=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeFixed32(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedFixed64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeFixed64(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedFixed64String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeFixed64String(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedSfixed32=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeSfixed32(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedSfixed64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeSfixed64(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedSfixed64String=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeSfixed64String(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedFloat=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeFloat(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedDouble=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeDouble(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedBool=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeBool(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedEnum=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeEnum(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedString=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeString(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedBytes=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeBytes(a,b[c])};jspb.BinaryWriter.prototype.writeRepeatedMessage=function(a,b,c){if(null!=b)for(var d=0;d<b.length;d++){var e=this.beginDelimited_(a);c(b[d],this);this.endDelimited_(e)}};
jspb.BinaryWriter.prototype.writeRepeatedGroup=function(a,b,c){if(null!=b)for(var d=0;d<b.length;d++)this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.START_GROUP),c(b[d],this),this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.END_GROUP)};jspb.BinaryWriter.prototype.writeRepeatedFixedHash64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeFixedHash64(a,b[c])};
jspb.BinaryWriter.prototype.writeRepeatedVarintHash64=function(a,b){if(null!=b)for(var c=0;c<b.length;c++)this.writeVarintHash64(a,b[c])};jspb.BinaryWriter.prototype.writePackedInt32=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeSignedVarint32(b[c]);this.endDelimited_(a)}};
jspb.BinaryWriter.prototype.writePackedInt32String=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeSignedVarint32(parseInt(b[c],10));this.endDelimited_(a)}};jspb.BinaryWriter.prototype.writePackedInt64=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeSignedVarint64(b[c]);this.endDelimited_(a)}};
jspb.BinaryWriter.prototype.writePackedInt64String=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++){var d=jspb.arith.Int64.fromString(b[c]);this.encoder_.writeSplitVarint64(d.lo,d.hi)}this.endDelimited_(a)}};jspb.BinaryWriter.prototype.writePackedUint32=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeUnsignedVarint32(b[c]);this.endDelimited_(a)}};
jspb.BinaryWriter.prototype.writePackedUint32String=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeUnsignedVarint32(parseInt(b[c],10));this.endDelimited_(a)}};jspb.BinaryWriter.prototype.writePackedUint64=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeUnsignedVarint64(b[c]);this.endDelimited_(a)}};
jspb.BinaryWriter.prototype.writePackedUint64String=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++){var d=jspb.arith.UInt64.fromString(b[c]);this.encoder_.writeSplitVarint64(d.lo,d.hi)}this.endDelimited_(a)}};jspb.BinaryWriter.prototype.writePackedSint32=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeZigzagVarint32(b[c]);this.endDelimited_(a)}};
jspb.BinaryWriter.prototype.writePackedSint64=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeZigzagVarint64(b[c]);this.endDelimited_(a)}};jspb.BinaryWriter.prototype.writePackedSint64String=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeZigzagVarint64(parseInt(b[c],10));this.endDelimited_(a)}};
jspb.BinaryWriter.prototype.writePackedFixed32=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(4*b.length),a=0;a<b.length;a++)this.encoder_.writeUint32(b[a])};jspb.BinaryWriter.prototype.writePackedFixed64=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*b.length),a=0;a<b.length;a++)this.encoder_.writeUint64(b[a])};
jspb.BinaryWriter.prototype.writePackedFixed64String=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*b.length),a=0;a<b.length;a++){var c=jspb.arith.UInt64.fromString(b[a]);this.encoder_.writeSplitFixed64(c.lo,c.hi)}};
jspb.BinaryWriter.prototype.writePackedSfixed32=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(4*b.length),a=0;a<b.length;a++)this.encoder_.writeInt32(b[a])};jspb.BinaryWriter.prototype.writePackedSfixed64=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*b.length),a=0;a<b.length;a++)this.encoder_.writeInt64(b[a])};
jspb.BinaryWriter.prototype.writePackedSfixed64String=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*b.length),a=0;a<b.length;a++)this.encoder_.writeInt64String(b[a])};jspb.BinaryWriter.prototype.writePackedFloat=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(4*b.length),a=0;a<b.length;a++)this.encoder_.writeFloat(b[a])};
jspb.BinaryWriter.prototype.writePackedDouble=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*b.length),a=0;a<b.length;a++)this.encoder_.writeDouble(b[a])};jspb.BinaryWriter.prototype.writePackedBool=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(b.length),a=0;a<b.length;a++)this.encoder_.writeBool(b[a])};
jspb.BinaryWriter.prototype.writePackedEnum=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeEnum(b[c]);this.endDelimited_(a)}};jspb.BinaryWriter.prototype.writePackedFixedHash64=function(a,b){if(null!=b&&b.length)for(this.writeFieldHeader_(a,jspb.BinaryConstants.WireType.DELIMITED),this.encoder_.writeUnsignedVarint32(8*b.length),a=0;a<b.length;a++)this.encoder_.writeFixedHash64(b[a])};
jspb.BinaryWriter.prototype.writePackedVarintHash64=function(a,b){if(null!=b&&b.length){a=this.beginDelimited_(a);for(var c=0;c<b.length;c++)this.encoder_.writeVarintHash64(b[c]);this.endDelimited_(a)}};jspb.Export={};exports.Map=jspb.Map;exports.Message=jspb.Message;exports.BinaryReader=jspb.BinaryReader;exports.BinaryWriter=jspb.BinaryWriter;exports.ExtensionFieldInfo=jspb.ExtensionFieldInfo;exports.ExtensionFieldBinaryInfo=jspb.ExtensionFieldBinaryInfo;exports.exportSymbol=goog.exportSymbol;exports.inherits=goog.inherits;exports.object={extend:goog.object.extend};exports.typeOf=goog.typeOf;


/***/ }),

/***/ "./node_modules/uuid/dist/esm-node/bytesToUuid.js":
/*!********************************************************!*\
  !*** ./node_modules/uuid/dist/esm-node/bytesToUuid.js ***!
  \********************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/**
 * Convert array of 16 byte values to UUID string format of the form:
 * XXXXXXXX-XXXX-XXXX-XXXX-XXXXXXXXXXXX
 */
const byteToHex = [];

for (let i = 0; i < 256; ++i) {
  byteToHex.push((i + 0x100).toString(16).substr(1));
}

function bytesToUuid(buf, offset_) {
  const offset = offset_ || 0; // Note: Be careful editing this code!  It's been tuned for performance
  // and works in ways you may not expect. See https://github.com/uuidjs/uuid/pull/434

  return (byteToHex[buf[offset + 0]] + byteToHex[buf[offset + 1]] + byteToHex[buf[offset + 2]] + byteToHex[buf[offset + 3]] + '-' + byteToHex[buf[offset + 4]] + byteToHex[buf[offset + 5]] + '-' + byteToHex[buf[offset + 6]] + byteToHex[buf[offset + 7]] + '-' + byteToHex[buf[offset + 8]] + byteToHex[buf[offset + 9]] + '-' + byteToHex[buf[offset + 10]] + byteToHex[buf[offset + 11]] + byteToHex[buf[offset + 12]] + byteToHex[buf[offset + 13]] + byteToHex[buf[offset + 14]] + byteToHex[buf[offset + 15]]).toLowerCase();
}

/* harmony default export */ __webpack_exports__["default"] = (bytesToUuid);

/***/ }),

/***/ "./node_modules/uuid/dist/esm-node/index.js":
/*!**************************************************!*\
  !*** ./node_modules/uuid/dist/esm-node/index.js ***!
  \**************************************************/
/*! exports provided: v1, v3, v4, v5 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _v1_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./v1.js */ "./node_modules/uuid/dist/esm-node/v1.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "v1", function() { return _v1_js__WEBPACK_IMPORTED_MODULE_0__["default"]; });

/* harmony import */ var _v3_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./v3.js */ "./node_modules/uuid/dist/esm-node/v3.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "v3", function() { return _v3_js__WEBPACK_IMPORTED_MODULE_1__["default"]; });

/* harmony import */ var _v4_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./v4.js */ "./node_modules/uuid/dist/esm-node/v4.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "v4", function() { return _v4_js__WEBPACK_IMPORTED_MODULE_2__["default"]; });

/* harmony import */ var _v5_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./v5.js */ "./node_modules/uuid/dist/esm-node/v5.js");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "v5", function() { return _v5_js__WEBPACK_IMPORTED_MODULE_3__["default"]; });






/***/ }),

/***/ "./node_modules/uuid/dist/esm-node/md5.js":
/*!************************************************!*\
  !*** ./node_modules/uuid/dist/esm-node/md5.js ***!
  \************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var crypto__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! crypto */ "crypto");
/* harmony import */ var crypto__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(crypto__WEBPACK_IMPORTED_MODULE_0__);


function md5(bytes) {
  if (Array.isArray(bytes)) {
    bytes = Buffer.from(bytes);
  } else if (typeof bytes === 'string') {
    bytes = Buffer.from(bytes, 'utf8');
  }

  return crypto__WEBPACK_IMPORTED_MODULE_0___default.a.createHash('md5').update(bytes).digest();
}

/* harmony default export */ __webpack_exports__["default"] = (md5);

/***/ }),

/***/ "./node_modules/uuid/dist/esm-node/rng.js":
/*!************************************************!*\
  !*** ./node_modules/uuid/dist/esm-node/rng.js ***!
  \************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "default", function() { return rng; });
/* harmony import */ var crypto__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! crypto */ "crypto");
/* harmony import */ var crypto__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(crypto__WEBPACK_IMPORTED_MODULE_0__);

const rnds8 = new Uint8Array(16);
function rng() {
  return crypto__WEBPACK_IMPORTED_MODULE_0___default.a.randomFillSync(rnds8);
}

/***/ }),

/***/ "./node_modules/uuid/dist/esm-node/sha1.js":
/*!*************************************************!*\
  !*** ./node_modules/uuid/dist/esm-node/sha1.js ***!
  \*************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var crypto__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! crypto */ "crypto");
/* harmony import */ var crypto__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(crypto__WEBPACK_IMPORTED_MODULE_0__);


function sha1(bytes) {
  if (Array.isArray(bytes)) {
    bytes = Buffer.from(bytes);
  } else if (typeof bytes === 'string') {
    bytes = Buffer.from(bytes, 'utf8');
  }

  return crypto__WEBPACK_IMPORTED_MODULE_0___default.a.createHash('sha1').update(bytes).digest();
}

/* harmony default export */ __webpack_exports__["default"] = (sha1);

/***/ }),

/***/ "./node_modules/uuid/dist/esm-node/v1.js":
/*!***********************************************!*\
  !*** ./node_modules/uuid/dist/esm-node/v1.js ***!
  \***********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _rng_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rng.js */ "./node_modules/uuid/dist/esm-node/rng.js");
/* harmony import */ var _bytesToUuid_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bytesToUuid.js */ "./node_modules/uuid/dist/esm-node/bytesToUuid.js");

 // **`v1()` - Generate time-based UUID**
//
// Inspired by https://github.com/LiosK/UUID.js
// and http://docs.python.org/library/uuid.html

let _nodeId;

let _clockseq; // Previous uuid creation time


let _lastMSecs = 0;
let _lastNSecs = 0; // See https://github.com/uuidjs/uuid for API details

function v1(options, buf, offset) {
  let i = buf && offset || 0;
  const b = buf || new Array(16);
  options = options || {};
  let node = options.node || _nodeId;
  let clockseq = options.clockseq !== undefined ? options.clockseq : _clockseq; // node and clockseq need to be initialized to random values if they're not
  // specified.  We do this lazily to minimize issues related to insufficient
  // system entropy.  See #189

  if (node == null || clockseq == null) {
    const seedBytes = options.random || (options.rng || _rng_js__WEBPACK_IMPORTED_MODULE_0__["default"])();

    if (node == null) {
      // Per 4.5, create and 48-bit node id, (47 random bits + multicast bit = 1)
      node = _nodeId = [seedBytes[0] | 0x01, seedBytes[1], seedBytes[2], seedBytes[3], seedBytes[4], seedBytes[5]];
    }

    if (clockseq == null) {
      // Per 4.2.2, randomize (14 bit) clockseq
      clockseq = _clockseq = (seedBytes[6] << 8 | seedBytes[7]) & 0x3fff;
    }
  } // UUID timestamps are 100 nano-second units since the Gregorian epoch,
  // (1582-10-15 00:00).  JSNumbers aren't precise enough for this, so
  // time is handled internally as 'msecs' (integer milliseconds) and 'nsecs'
  // (100-nanoseconds offset from msecs) since unix epoch, 1970-01-01 00:00.


  let msecs = options.msecs !== undefined ? options.msecs : Date.now(); // Per 4.2.1.2, use count of uuid's generated during the current clock
  // cycle to simulate higher resolution clock

  let nsecs = options.nsecs !== undefined ? options.nsecs : _lastNSecs + 1; // Time since last uuid creation (in msecs)

  const dt = msecs - _lastMSecs + (nsecs - _lastNSecs) / 10000; // Per 4.2.1.2, Bump clockseq on clock regression

  if (dt < 0 && options.clockseq === undefined) {
    clockseq = clockseq + 1 & 0x3fff;
  } // Reset nsecs if clock regresses (new clockseq) or we've moved onto a new
  // time interval


  if ((dt < 0 || msecs > _lastMSecs) && options.nsecs === undefined) {
    nsecs = 0;
  } // Per 4.2.1.2 Throw error if too many uuids are requested


  if (nsecs >= 10000) {
    throw new Error("uuid.v1(): Can't create more than 10M uuids/sec");
  }

  _lastMSecs = msecs;
  _lastNSecs = nsecs;
  _clockseq = clockseq; // Per 4.1.4 - Convert from unix epoch to Gregorian epoch

  msecs += 12219292800000; // `time_low`

  const tl = ((msecs & 0xfffffff) * 10000 + nsecs) % 0x100000000;
  b[i++] = tl >>> 24 & 0xff;
  b[i++] = tl >>> 16 & 0xff;
  b[i++] = tl >>> 8 & 0xff;
  b[i++] = tl & 0xff; // `time_mid`

  const tmh = msecs / 0x100000000 * 10000 & 0xfffffff;
  b[i++] = tmh >>> 8 & 0xff;
  b[i++] = tmh & 0xff; // `time_high_and_version`

  b[i++] = tmh >>> 24 & 0xf | 0x10; // include version

  b[i++] = tmh >>> 16 & 0xff; // `clock_seq_hi_and_reserved` (Per 4.2.2 - include variant)

  b[i++] = clockseq >>> 8 | 0x80; // `clock_seq_low`

  b[i++] = clockseq & 0xff; // `node`

  for (let n = 0; n < 6; ++n) {
    b[i + n] = node[n];
  }

  return buf || Object(_bytesToUuid_js__WEBPACK_IMPORTED_MODULE_1__["default"])(b);
}

/* harmony default export */ __webpack_exports__["default"] = (v1);

/***/ }),

/***/ "./node_modules/uuid/dist/esm-node/v3.js":
/*!***********************************************!*\
  !*** ./node_modules/uuid/dist/esm-node/v3.js ***!
  \***********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _v35_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./v35.js */ "./node_modules/uuid/dist/esm-node/v35.js");
/* harmony import */ var _md5_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./md5.js */ "./node_modules/uuid/dist/esm-node/md5.js");


const v3 = Object(_v35_js__WEBPACK_IMPORTED_MODULE_0__["default"])('v3', 0x30, _md5_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ __webpack_exports__["default"] = (v3);

/***/ }),

/***/ "./node_modules/uuid/dist/esm-node/v35.js":
/*!************************************************!*\
  !*** ./node_modules/uuid/dist/esm-node/v35.js ***!
  \************************************************/
/*! exports provided: DNS, URL, default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DNS", function() { return DNS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "URL", function() { return URL; });
/* harmony import */ var _bytesToUuid_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bytesToUuid.js */ "./node_modules/uuid/dist/esm-node/bytesToUuid.js");


function uuidToBytes(uuid) {
  // Note: We assume we're being passed a valid uuid string
  const bytes = [];
  uuid.replace(/[a-fA-F0-9]{2}/g, function (hex) {
    bytes.push(parseInt(hex, 16));
  });
  return bytes;
}

function stringToBytes(str) {
  str = unescape(encodeURIComponent(str)); // UTF8 escape

  const bytes = [];

  for (let i = 0; i < str.length; ++i) {
    bytes.push(str.charCodeAt(i));
  }

  return bytes;
}

const DNS = '6ba7b810-9dad-11d1-80b4-00c04fd430c8';
const URL = '6ba7b811-9dad-11d1-80b4-00c04fd430c8';
/* harmony default export */ __webpack_exports__["default"] = (function (name, version, hashfunc) {
  function generateUUID(value, namespace, buf, offset) {
    if (typeof value === 'string') {
      value = stringToBytes(value);
    }

    if (typeof namespace === 'string') {
      namespace = uuidToBytes(namespace);
    }

    if (!Array.isArray(value)) {
      throw TypeError('value must be an array of bytes');
    }

    if (!Array.isArray(namespace) || namespace.length !== 16) {
      throw TypeError('namespace must be uuid string or an Array of 16 byte values');
    } // Per 4.3


    const bytes = hashfunc(namespace.concat(value));
    bytes[6] = bytes[6] & 0x0f | version;
    bytes[8] = bytes[8] & 0x3f | 0x80;

    if (buf) {
      offset = offset || 0;

      for (let i = 0; i < 16; ++i) {
        buf[offset + i] = bytes[i];
      }

      return buf;
    }

    return Object(_bytesToUuid_js__WEBPACK_IMPORTED_MODULE_0__["default"])(bytes);
  } // Function#name is not settable on some platforms (#270)


  try {
    generateUUID.name = name; // eslint-disable-next-line no-empty
  } catch (err) {} // For CommonJS default export support


  generateUUID.DNS = DNS;
  generateUUID.URL = URL;
  return generateUUID;
});

/***/ }),

/***/ "./node_modules/uuid/dist/esm-node/v4.js":
/*!***********************************************!*\
  !*** ./node_modules/uuid/dist/esm-node/v4.js ***!
  \***********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _rng_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rng.js */ "./node_modules/uuid/dist/esm-node/rng.js");
/* harmony import */ var _bytesToUuid_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./bytesToUuid.js */ "./node_modules/uuid/dist/esm-node/bytesToUuid.js");



function v4(options, buf, offset) {
  options = options || {};
  const rnds = options.random || (options.rng || _rng_js__WEBPACK_IMPORTED_MODULE_0__["default"])(); // Per 4.4, set bits for version and `clock_seq_hi_and_reserved`

  rnds[6] = rnds[6] & 0x0f | 0x40;
  rnds[8] = rnds[8] & 0x3f | 0x80; // Copy bytes to buffer, if provided

  if (buf) {
    offset = offset || 0;

    for (let i = 0; i < 16; ++i) {
      buf[offset + i] = rnds[i];
    }

    return buf;
  }

  return Object(_bytesToUuid_js__WEBPACK_IMPORTED_MODULE_1__["default"])(rnds);
}

/* harmony default export */ __webpack_exports__["default"] = (v4);

/***/ }),

/***/ "./node_modules/uuid/dist/esm-node/v5.js":
/*!***********************************************!*\
  !*** ./node_modules/uuid/dist/esm-node/v5.js ***!
  \***********************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _v35_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./v35.js */ "./node_modules/uuid/dist/esm-node/v35.js");
/* harmony import */ var _sha1_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./sha1.js */ "./node_modules/uuid/dist/esm-node/sha1.js");


const v5 = Object(_v35_js__WEBPACK_IMPORTED_MODULE_0__["default"])('v5', 0x50, _sha1_js__WEBPACK_IMPORTED_MODULE_1__["default"]);
/* harmony default export */ __webpack_exports__["default"] = (v5);

/***/ }),

/***/ "crypto":
/*!*************************!*\
  !*** external "crypto" ***!
  \*************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("crypto");

/***/ }),

/***/ "grpc":
/*!***********************!*\
  !*** external "grpc" ***!
  \***********************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("grpc");

/***/ }),

/***/ "playwright":
/*!*****************************!*\
  !*** external "playwright" ***!
  \*****************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = require("playwright");

/***/ })

/******/ });
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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