# Generated by Django 3.0.7 on 2020-08-25 08:02

from django.db import migrations, models
import django.db.models.deletion
import image.model_fields
import image.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Image',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('upload_time', models.DateTimeField(auto_now_add=True, verbose_name='Datetime of upload')),
                ('src', image.model_fields.ImageFileField(bytesize_field='bytesize', form_limit_filepath_length=True, height_field='height', max_size=2097152, unique=True, upload_to=image.models.get_image_upload_to, verbose_name='image_file', width_field='width')),
                ('width', models.PositiveIntegerField(editable=False, verbose_name='width')),
                ('height', models.PositiveIntegerField(editable=False, verbose_name='height')),
                ('bytesize', models.PositiveIntegerField(editable=False, null=True)),
            ],
            options={
                'verbose_name': 'image',
                'verbose_name_plural': 'images',
            },
        ),
        migrations.CreateModel(
            name='Reform',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('src', image.model_fields.ReformFileField(max_length=100, unique=True, upload_to=image.models.get_reform_upload_to)),
                ('filter_id', models.CharField(db_index=True, max_length=255)),
                ('image', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='+', to='image.Image')),
            ],
            options={
                'verbose_name': 'reform',
                'verbose_name_plural': 'reforms',
            },
        ),
        migrations.AddIndex(
            model_name='image',
            index=models.Index(fields=['upload_time'], name='image_image_upload__79d268_idx'),
        ),
    ]
