#!/usr/bin/env python3
# Copyright 2004-present Facebook. All Rights Reserved.

from enum import IntEnum

import zmq


class ZMQEvent(IntEnum):
    """
    Convenience enum that allows us to map zmq events (which are just ints) to their
    human-readable labels.
    """

    EVENT_CONNECTED = zmq.EVENT_CONNECTED
    EVENT_CONNECT_DELAYED = zmq.EVENT_CONNECT_DELAYED
    EVENT_CONNECT_RETRIED = zmq.EVENT_CONNECT_RETRIED
    EVENT_LISTENING = zmq.EVENT_LISTENING
    EVENT_BIND_FAILED = zmq.EVENT_BIND_FAILED
    EVENT_ACCEPTED = zmq.EVENT_ACCEPTED
    EVENT_ACCEPT_FAILED = zmq.EVENT_ACCEPT_FAILED
    EVENT_CLOSED = zmq.EVENT_CLOSED
    EVENT_CLOSE_FAILED = zmq.EVENT_CLOSE_FAILED
    EVENT_DISCONNECTED = zmq.EVENT_DISCONNECTED
    EVENT_MONITOR_STOPPED = zmq.EVENT_MONITOR_STOPPED
    EVENT_ALL = zmq.EVENT_ALL
    EVENT_HANDSHAKE_FAILED_NO_DETAIL = zmq.EVENT_HANDSHAKE_FAILED_NO_DETAIL
    EVENT_HANDSHAKE_SUCCEEDED = zmq.EVENT_HANDSHAKE_SUCCEEDED
    EVENT_HANDSHAKE_FAILED_PROTOCOL = zmq.EVENT_HANDSHAKE_FAILED_PROTOCOL
    EVENT_HANDSHAKE_FAILED_AUTH = zmq.EVENT_HANDSHAKE_FAILED_AUTH
