# mypy-boto3-serverlessrepo

[![PyPI - mypy-boto3-serverlessrepo](https://img.shields.io/pypi/v/mypy-boto3-serverlessrepo.svg?color=blue)](https://pypi.org/project/mypy-boto3-serverlessrepo)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-serverlessrepo.svg?color=blue)](https://pypi.org/project/mypy-boto3-serverlessrepo)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.ServerlessApplicationRepository 1.16.4](https://boto3.amazonaws.com/v1/documentation/api/1.16.4/reference/services/serverlessrepo.html#ServerlessApplicationRepository) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.2.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-serverlessrepo](#mypy-boto3-serverlessrepo)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `ServerlessApplicationRepository` service.

```bash
python -m pip install boto3-stubs[serverlessrepo]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[serverlessrepo]` in your environment: `python -m pip install 'boto3-stubs[serverlessrepo]'`

Both type checking and auto-complete should work for `ServerlessApplicationRepository` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[serverlessrepo]` in your environment: `python -m pip install 'boto3-stubs[serverlessrepo]'`

Both type checking and auto-complete should work for `ServerlessApplicationRepository` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[serverlessrepo]` in your environment: `python -m pip install 'boto3-stubs[serverlessrepo]'`
- Run `mypy` as usual

Type checking should work for `ServerlessApplicationRepository` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[serverlessrepo]` in your environment: `python -m pip install 'boto3-stubs[serverlessrepo]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ServerlessApplicationRepository` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ServerlessApplicationRepositoryClient` provides annotations for `boto3.client("serverlessrepo")`.

```python
import boto3

from mypy_boto3_serverlessrepo import ServerlessApplicationRepositoryClient

client: ServerlessApplicationRepositoryClient = boto3.client("serverlessrepo")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ServerlessApplicationRepositoryClient = session.client("serverlessrepo")
```

### Paginators annotations

`mypy_boto3_serverlessrepo.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_serverlessrepo import ServerlessApplicationRepositoryClient
from mypy_boto3_serverlessrepo.paginator import (
    ListApplicationDependenciesPaginator,
    ListApplicationsPaginator,
    ListApplicationVersionsPaginator,
)

client: ServerlessApplicationRepositoryClient = boto3.client("serverlessrepo")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_application_dependencies_paginator: ListApplicationDependenciesPaginator = client.get_paginator("list_application_dependencies")
list_application_versions_paginator: ListApplicationVersionsPaginator = client.get_paginator("list_application_versions")
list_applications_paginator: ListApplicationsPaginator = client.get_paginator("list_applications")
```







### Typed dictionations

`mypy_boto3_serverlessrepo.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_serverlessrepo.type_defs import (
    ApplicationDependencySummaryTypeDef,
    ApplicationPolicyStatementTypeDef,
    ApplicationSummaryTypeDef,
    CreateApplicationResponseTypeDef,
    CreateApplicationVersionResponseTypeDef,
    CreateCloudFormationChangeSetResponseTypeDef,
    CreateCloudFormationTemplateResponseTypeDef,
    GetApplicationPolicyResponseTypeDef,
    GetApplicationResponseTypeDef,
    GetCloudFormationTemplateResponseTypeDef,
    ListApplicationDependenciesResponseTypeDef,
    ListApplicationsResponseTypeDef,
    ListApplicationVersionsResponseTypeDef,
    PaginatorConfigTypeDef,
    ParameterDefinitionTypeDef,
    ParameterValueTypeDef,
    PutApplicationPolicyResponseTypeDef,
    RollbackConfigurationTypeDef,
    RollbackTriggerTypeDef,
    TagTypeDef,
    UpdateApplicationResponseTypeDef,
    VersionSummaryTypeDef,
    VersionTypeDef,
)

def get_structure() -> ApplicationDependencySummaryTypeDef:
    return {
      ...
    }
```
