import * as React from 'react';
import { IDiffProps } from './Diff';
export interface IPlainTextDiffState {
    errorMessage: string;
}
export interface IPlainTextDiffProps extends IDiffProps {
}
/**
 * A React component to render the diff of a plain text file
 *
 * 1. It calls the `/git/diffcontent` API on the server to get the previous and current content
 * 2. Renders the content using CodeMirror merge addon
 */
export declare class PlainTextDiff extends React.Component<IPlainTextDiffProps, IPlainTextDiffState> {
    constructor(props: IPlainTextDiffProps);
    componentDidMount(): void;
    render(): JSX.Element;
    /**
     * Based on the Diff Context , calls the server API with the relevant parameters
     * to
     * @param diffContext the context in which to perform the diff
     */
    private _performDiff;
    /**
     * Creates and adds a diff viewer to the DOM with given content
     *
     * @param prevContent the raw value of the previous content
     * @param currContent the raw value of the current content
     */
    private _addDiffViewer;
    private _mergeViewRef;
}
/**
 * Checks if a given path is supported language
 *
 * @param path the path of the file
 */
export declare function isText(path: string): boolean;
