import * as React from 'react';
import { IGitExtension } from '../tokens';
/**
 * Interface describing component properties.
 */
export interface IToolbarProps {
    /**
     * Git extension data model.
     */
    model: IGitExtension;
    /**
     * Boolean indicating whether branching is disabled.
     */
    branching: boolean;
    /**
     * Callback to invoke in order to refresh a repository.
     *
     * @returns promise which refreshes a repository
     */
    refresh: () => Promise<void>;
}
/**
 * Interface describing component state.
 */
export interface IToolbarState {
    /**
     * Boolean indicating whether a branch menu is shown.
     */
    branchMenu: boolean;
    /**
     * Boolean indicating whether a repository menu is shown.
     */
    repoMenu: boolean;
    /**
     * Current repository.
     */
    repository: string;
    /**
     * Current branch name.
     */
    branch: string;
}
/**
 * React component for rendering a panel toolbar.
 */
export declare class Toolbar extends React.Component<IToolbarProps, IToolbarState> {
    /**
     * Returns a React component for rendering a panel toolbar.
     *
     * @param props - component properties
     * @returns React component
     */
    constructor(props: IToolbarProps);
    /**
     * Callback invoked immediately after mounting a component (i.e., inserting into a tree).
     */
    componentDidMount(): void;
    /**
     * Callback invoked when a component will no longer be mounted.
     */
    componentWillUnmount(): void;
    /**
     * Renders the component.
     *
     * @returns React element
     */
    render(): React.ReactElement;
    /**
     * Renders the top navigation.
     *
     * @returns React element
     */
    private _renderTopNav;
    /**
     * Renders a repository menu.
     *
     * @returns React element
     */
    private _renderRepoMenu;
    /**
     * Renders a branch menu.
     *
     * @returns React element
     */
    private _renderBranchMenu;
    /**
     * Adds model listeners.
     */
    private _addListeners;
    /**
     * Removes model listeners.
     */
    private _removeListeners;
    /**
     * Syncs the component state with the underlying model.
     */
    private _syncState;
    /**
     * Callback invoked upon clicking a button to pull the latest changes.
     *
     * @param event - event object
     */
    private _onPullClick;
    /**
     * Callback invoked upon clicking a button to push the latest changes.
     *
     * @param event - event object
     */
    private _onPushClick;
    /**
     * Callback invoked upon clicking a button to change the current repository.
     *
     * @param event - event object
     */
    private _onRepositoryClick;
    /**
     * Callback invoked upon clicking a button to change the current branch.
     *
     * @param event - event object
     */
    private _onBranchClick;
    /**
     * Callback invoked upon clicking a button to refresh a repository.
     *
     * @param event - event object
     */
    private _onRefreshClick;
}
