import * as React from 'react';
import { Git, IGitExtension } from '../tokens';
/**
 * Interface describing component properties.
 */
export interface IBranchMenuProps {
    /**
     * Git extension data model.
     */
    model: IGitExtension;
    /**
     * Boolean indicating whether branching is disabled.
     */
    branching: boolean;
}
/**
 * Interface describing component state.
 */
export interface IBranchMenuState {
    /**
     * Menu filter.
     */
    filter: string;
    /**
     * Boolean indicating whether to show a dialog to create a new branch.
     */
    branchDialog: boolean;
    /**
     * Current branch name.
     */
    current: string;
    /**
     * Current list of branches.
     */
    branches: Git.IBranch[];
}
/**
 * React component for rendering a branch menu.
 */
export declare class BranchMenu extends React.Component<IBranchMenuProps, IBranchMenuState> {
    /**
     * Returns a React component for rendering a branch menu.
     *
     * @param props - component properties
     * @returns React component
     */
    constructor(props: IBranchMenuProps);
    /**
     * Callback invoked immediately after mounting a component (i.e., inserting into a tree).
     */
    componentDidMount(): void;
    /**
     * Callback invoked when a component will no longer be mounted.
     */
    componentWillUnmount(): void;
    /**
     * Renders the component.
     *
     * @returns React element
     */
    render(): React.ReactElement;
    /**
     * Renders menu items.
     *
     * @returns array of React elements
     */
    private _renderItems;
    /**
     * Renders a menu item.
     *
     * @param branch - branch
     * @param idx - item index
     * @returns React element
     */
    private _renderItem;
    /**
     * Adds model listeners.
     */
    private _addListeners;
    /**
     * Removes model listeners.
     */
    private _removeListeners;
    /**
     * Syncs the component state with the underlying model.
     */
    private _syncState;
    /**
     * Callback invoked upon a change to the menu filter.
     *
     * @param event - event object
     */
    private _onFilterChange;
    /**
     * Callback invoked to reset the menu filter.
     */
    private _resetFilter;
    /**
     * Callback invoked upon clicking a button to create a new branch.
     *
     * @param event - event object
     */
    private _onNewBranchClick;
    /**
     * Callback invoked upon closing a dialog to create a new branch.
     */
    private _onNewBranchDialogClose;
    /**
     * Returns a callback which is invoked upon clicking a branch name.
     *
     * @param branch - branch name
     * @returns callback
     */
    private _onBranchClickFactory;
}
