import * as React from 'react';
import { DefaultIconReact } from '@jupyterlab/ui-components';
import { classes } from 'typestyle';
import { actionButtonStyle } from '../style/ActionButtonStyle';
/**
 * Action button component
 *
 * @param props Component properties
 */
export const ActionButton = (props) => {
    return (React.createElement("button", { disabled: props.disabled, className: classes(actionButtonStyle, props.className), title: props.title, onClick: props.onClick },
        React.createElement(DefaultIconReact, { tag: "span", name: props.iconName })));
};
//# sourceMappingURL=ActionButton.js.map