# SPDX-FileCopyrightText: 2017 Scott Shawcroft, written for Adafruit Industries
# SPDX-FileCopyrightText: Copyright (c) 2021 Neradoc
#
# SPDX-License-Identifier: MIT
"""
`consumer_control_extended`
================================================================================

A big list of all HID consumer controls


* Author(s): Neradoc

Implementation Notes
--------------------

**Software and Dependencies:**

* Adafruit CircuitPython firmware for the supported boards:
  https://github.com/adafruit/circuitpython/releases
"""

# imports

__version__ = "1.0.0"
__repo__ = "https://github.com/Neradoc/CircuitPython_consumer_control_extended.git"

UNASSIGNED = 0x00
"""UNASSIGNED"""
CONSUMER_CONTROL = 0x01
"""CONSUMER_CONTROL"""
NUMERIC_KEY_PAD = 0x02
"""NUMERIC_KEY_PAD"""
PROGRAMMABLE_BUTTONS = 0x03
"""PROGRAMMABLE_BUTTONS"""
PLUS10 = 0x20
"""PLUS10"""
PLUS100 = 0x21
"""PLUS100"""
AM_PM = 0x22  # AM/PM
"""AM_PM"""
AM = AM_PM
"""AM"""
PM = AM_PM
"""PM"""
POWER = 0x30
"""POWER"""
RESET = 0x31
"""RESET"""
SLEEP = 0x32
"""SLEEP"""
SLEEP_AFTER = 0x33
"""SLEEP_AFTER"""
SLEEP_MODE = 0x34
"""SLEEP_MODE"""
ILLUMINATION = 0x35
"""ILLUMINATION"""
FUNCTION_BUTTONS = 0x36
"""FUNCTION_BUTTONS"""
MENU = 0x40
"""MENU"""
MENU_PICK = 0x41
"""MENU_PICK"""
MENU_UP = 0x42
"""MENU_UP"""
MENU_DOWN = 0x43
"""MENU_DOWN"""
MENU_LEFT = 0x44
"""MENU_LEFT"""
MENU_RIGHT = 0x45
"""MENU_RIGHT"""
MENU_ESCAPE = 0x46
"""MENU_ESCAPE"""
MENU_VALUE_INCREASE = 0x47
"""MENU_VALUE_INCREASE"""
MENU_VALUE_DECREASE = 0x48
"""MENU_VALUE_DECREASE"""
DATA_ON_SCREEN = 0x60
"""DATA_ON_SCREEN"""
CLOSED_CAPTION = 0x61
"""CLOSED_CAPTION"""
CLOSED_CAPTION_SELECT = 0x62
"""CLOSED_CAPTION_SELECT"""
VCR_TV = 0x63  # VCR/TV
"""VCR_TV"""
# VCR = VCR_TV
# TV = VCR_TV
BROADCAST_MODE = 0x64
"""BROADCAST_MODE"""
SNAPSHOT = 0x65
"""SNAPSHOT"""
STILL = 0x66
"""STILL"""
SELECTION = 0x80
"""SELECTION"""
ASSIGN_SELECTION = 0x81
"""ASSIGN_SELECTION"""
MODE_STEP = 0x82
"""MODE_STEP"""
RECALL_LAST = 0x83
"""RECALL_LAST"""
ENTER_CHANNEL = 0x84
"""ENTER_CHANNEL"""
ORDER_MOVIE = 0x85
"""ORDER_MOVIE"""
CHANNEL = 0x86
"""CHANNEL"""
MEDIA_SELECTION = 0x87
"""MEDIA_SELECTION"""
MEDIA_SELECT_COMPUTER = 0x88
"""MEDIA_SELECT_COMPUTER"""
MEDIA_SELECT_TV = 0x89
"""MEDIA_SELECT_TV"""
MEDIA_SELECT_WWW = 0x8A
"""MEDIA_SELECT_WWW"""
MEDIA_SELECT_DVD = 0x8B
"""MEDIA_SELECT_DVD"""
MEDIA_SELECT_TELEPHONE = 0x8C
"""MEDIA_SELECT_TELEPHONE"""
MEDIA_SELECT_PROGRAM_GUIDE = 0x8D
"""MEDIA_SELECT_PROGRAM_GUIDE"""
MEDIA_SELECT_VIDEO_PHONE = 0x8E
"""MEDIA_SELECT_VIDEO_PHONE"""
MEDIA_SELECT_GAMES = 0x8F
"""MEDIA_SELECT_GAMES"""
MEDIA_SELECT_MESSAGES = 0x90
"""MEDIA_SELECT_MESSAGES"""
MEDIA_SELECT_CD = 0x91
"""MEDIA_SELECT_CD"""
MEDIA_SELECT_VCR = 0x92
"""MEDIA_SELECT_VCR"""
MEDIA_SELECT_TUNER = 0x93
"""MEDIA_SELECT_TUNER"""
QUIT = 0x94
"""QUIT"""
HELP = 0x95
"""HELP"""
MEDIA_SELECT_TAPE = 0x96
"""MEDIA_SELECT_TAPE"""
MEDIA_SELECT_CABLE = 0x97
"""MEDIA_SELECT_CABLE"""
MEDIA_SELECT_SATELLITE = 0x98
"""MEDIA_SELECT_SATELLITE"""
MEDIA_SELECT_SECURITY = 0x99
"""MEDIA_SELECT_SECURITY"""
MEDIA_SELECT_HOME = 0x9A
"""MEDIA_SELECT_HOME"""
MEDIA_SELECT_CALL = 0x9B
"""MEDIA_SELECT_CALL"""
CHANNEL_INCREMENT = 0x9C
"""CHANNEL_INCREMENT"""
CHANNEL_DECREMENT = 0x9D
"""CHANNEL_DECREMENT"""
MEDIA_SELECT_SAP = 0x9E
"""MEDIA_SELECT_SAP"""
VCR_PLUS = 0xA0
"""VCR_PLUS"""
ONCE = 0xA1
"""ONCE"""
DAILY = 0xA2
"""DAILY"""
WEEKLY = 0xA3
"""WEEKLY"""
MONTHLY = 0xA4
"""MONTHLY"""
PLAY = 0xB0
"""PLAY"""
PAUSE = 0xB1
"""PAUSE"""
RECORD = 0xB2
"""RECORD"""
FAST_FORWARD = 0xB3
"""FAST_FORWARD"""
REWIND = 0xB4
"""REWIND"""
SCAN_NEXT_TRACK = 0xB5
"""SCAN_NEXT_TRACK"""
SCAN_PREVIOUS_TRACK = 0xB6
"""SCAN_PREVIOUS_TRACK"""
STOP = 0xB7
"""STOP"""
EJECT = 0xB8
"""EJECT"""
RANDOM_PLAY = 0xB9
"""RANDOM_PLAY"""
SELECT_DISC = 0xBA
"""SELECT_DISC"""
ENTER_DISC = 0xBB
"""ENTER_DISC"""
REPEAT = 0xBC
"""REPEAT"""
TRACKING = 0xBD
"""TRACKING"""
TRACK_NORMAL = 0xBE
"""TRACK_NORMAL"""
SLOW_TRACKING = 0xBF
"""SLOW_TRACKING"""
FRAME_FORWARD = 0xC0
"""FRAME_FORWARD"""
FRAME_BACK = 0xC1
"""FRAME_BACK"""
MARK = 0xC2
"""MARK"""
CLEAR_MARK = 0xC3
"""CLEAR_MARK"""
REPEAT_FROM_MARK = 0xC4
"""REPEAT_FROM_MARK"""
RETURN_TO_MARK = 0xC5
"""RETURN_TO_MARK"""
SEARCH_MARK_FORWARD = 0xC6
"""SEARCH_MARK_FORWARD"""
SEARCH_MARK_BACKWARDS = 0xC7
"""SEARCH_MARK_BACKWARDS"""
COUNTER_RESET = 0xC8
"""COUNTER_RESET"""
SHOW_COUNTER = 0xC9
"""SHOW_COUNTER"""
TRACKING_INCREMENT = 0xCA
"""TRACKING_INCREMENT"""
TRACKING_DECREMENT = 0xCB
"""TRACKING_DECREMENT"""
VOLUME = 0xE0
"""VOLUME"""
BALANCE = 0xE1
"""BALANCE"""
MUTE = 0xE2
"""MUTE"""
BASS = 0xE3
"""BASS"""
TREBLE = 0xE4
"""TREBLE"""
BASS_BOOST = 0xE5
"""BASS_BOOST"""
SURROUND_MODE = 0xE6
"""SURROUND_MODE"""
LOUDNESS = 0xE7
"""LOUDNESS"""
MPX = 0xE8
"""MPX"""
VOLUME_UP = 0xE9
"""VOLUME_UP"""
VOLUME_DOWN = 0xEA
"""VOLUME_DOWN"""
SPEED_SELECT = 0xF0
"""SPEED_SELECT"""
PLAYBACK_SPEED = 0xF1
"""PLAYBACK_SPEED"""
STANDARD_PLAY = 0xF2
"""STANDARD_PLAY"""
LONG_PLAY = 0xF3
"""LONG_PLAY"""
EXTENDED_PLAY = 0xF4
"""EXTENDED_PLAY"""
SLOW = 0xF5
"""SLOW"""
FAN_ENABLE = 0x100
"""FAN_ENABLE"""
FAN_SPEED = 0x101
"""FAN_SPEED"""
LIGHT = 0x102
"""LIGHT"""
LIGHT_ILLUMINATION_LEVEL = 0x103
"""LIGHT_ILLUMINATION_LEVEL"""
CLIMATE_CONTROL_ENABLE = 0x104
"""CLIMATE_CONTROL_ENABLE"""
ROOM_TEMPERATURE = 0x105
"""ROOM_TEMPERATURE"""
SECURITY_ENABLE = 0x106
"""SECURITY_ENABLE"""
FIRE_ALARM = 0x107
"""FIRE_ALARM"""
POLICE_ALARM = 0x108
"""POLICE_ALARM"""
BALANCE_RIGHT = 0x150
"""BALANCE_RIGHT"""
BALANCE_LEFT = 0x151
"""BALANCE_LEFT"""
BASS_INCREMENT = 0x152
"""BASS_INCREMENT"""
BASS_DECREMENT = 0x153
"""BASS_DECREMENT"""
TREBLE_INCREMENT = 0x154
"""TREBLE_INCREMENT"""
TREBLE_DECREMENT = 0x155
"""TREBLE_DECREMENT"""
SPEAKER_SYSTEM = 0x160
"""SPEAKER_SYSTEM"""
CHANNEL_LEFT = 0x161
"""CHANNEL_LEFT"""
CHANNEL_RIGHT = 0x162
"""CHANNEL_RIGHT"""
CHANNEL_CENTER = 0x163
"""CHANNEL_CENTER"""
CHANNEL_FRONT = 0x164
"""CHANNEL_FRONT"""
CHANNEL_CENTER_FRONT = 0x165
"""CHANNEL_CENTER_FRONT"""
CHANNEL_SIDE = 0x166
"""CHANNEL_SIDE"""
CHANNEL_SURROUND = 0x167
"""CHANNEL_SURROUND"""
CHANNEL_LOW_FREQUENCY_ENHANCEMENT = 0x168
"""CHANNEL_LOW_FREQUENCY_ENHANCEMENT"""
CHANNEL_TOP = 0x169
"""CHANNEL_TOP"""
CHANNEL_UNKNOWN = 0x16A
"""CHANNEL_UNKNOWN"""
SUB_CHANNEL = 0x170
"""SUB_CHANNEL"""
SUB_CHANNEL_INCREMENT = 0x171
"""SUB_CHANNEL_INCREMENT"""
SUB_CHANNEL_DECREMENT = 0x172
"""SUB_CHANNEL_DECREMENT"""
ALTERNATE_AUDIO_INCREMENT = 0x173
"""ALTERNATE_AUDIO_INCREMENT"""
ALTERNATE_AUDIO_DECREMENT = 0x174
"""ALTERNATE_AUDIO_DECREMENT"""
APPLICATION_LAUNCH_BUTTONS = 0x180
"""APPLICATION_LAUNCH_BUTTONS"""
AL_LAUNCH_BUTTON_CONFIGURATION_TOOL = 0x181
"""AL_LAUNCH_BUTTON_CONFIGURATION_TOOL"""
AL_PROGRAMMABLE_BUTTON_CONFIGURATION = 0x182
"""AL_PROGRAMMABLE_BUTTON_CONFIGURATION"""
AL_CONSUMER_CONTROL_CONFIGURATION = 0x183
"""AL_CONSUMER_CONTROL_CONFIGURATION"""
AL_WORD_PROCESSOR = 0x184
"""AL_WORD_PROCESSOR"""
AL_TEXT_EDITOR = 0x185
"""AL_TEXT_EDITOR"""
AL_SPREADSHEET = 0x186
"""AL_SPREADSHEET"""
AL_GRAPHICS_EDITOR = 0x187
"""AL_GRAPHICS_EDITOR"""
AL_PRESENTATION_APP = 0x188
"""AL_PRESENTATION_APP"""
AL_DATABASE_APP = 0x189
"""AL_DATABASE_APP"""
AL_EMAIL_READER = 0x18A
"""AL_EMAIL_READER"""
AL_NEWSREADER = 0x18B
"""AL_NEWSREADER"""
AL_VOICEMAIL = 0x18C
"""AL_VOICEMAIL"""
AL_CONTACTS = 0x18D  # AL_CONTACTS/ADDRESS_BOOK
"""AL_CONTACTS"""
AL_ADDRESS_BOOK = AL_CONTACTS
"""AL_ADDRESS_BOOK"""
AL_CALENDAR = 0x18E  # AL_CALENDAR/SCHEDULE
"""AL_CALENDAR"""
AL_SCHEDULE = AL_CALENDAR
"""AL_SCHEDULE"""
AL_PROJECT_MANAGER = 0x18F  # AL_TASK/PROJECT_MANAGER
"""AL_PROJECT_MANAGER"""
# AL_TASK_MANAGER = AL_PROJECT_MANAGER
AL_LOG = 0x193  # AL_LOG/JOURNAL/TIMECARD
"""AL_LOG"""
AL_JOURNAL = AL_LOG
"""AL_JOURNAL"""
AL_TIMECARD = AL_LOG
"""AL_TIMECARD"""
AL_CHECKBOOK = 0x191  # AL_CHECKBOOK/FINANCE
"""AL_CHECKBOOK"""
AL_FINANCE = AL_CHECKBOOK
"""AL_FINANCE"""
AL_CALCULATOR = 0x192
"""AL_CALCULATOR"""
AL_AV_CAPTURE_PLAYBACK = 0x193  # AL_A/V_CAPTURE/PLAYBACK
"""AL_AV_CAPTURE_PLAYBACK"""
AL_LOCAL_MACHINE_BROWSER = 0x194
"""AL_LOCAL_MACHINE_BROWSER"""
AL_LAN_BROWSER = 0x195  # AL_LAN/WAN_BROWSER
"""AL_LAN_BROWSER"""
AL_WAN_BROWSER = AL_LAN_BROWSER
"""AL_WAN_BROWSER"""
AL_INTERNET_BROWSER = 0x196
"""AL_INTERNET_BROWSER"""
AL_REMOTE_NETWORKING = 0x197  # AL_REMOTE_NETWORKING/ISP_CONNECT
"""AL_REMOTE_NETWORKING"""
AL_ISP_CONNECT = AL_REMOTE_NETWORKING
"""AL_ISP_CONNECT"""
AL_NETWORK_CONFERENCE = 0x198
"""AL_NETWORK_CONFERENCE"""
AL_NETWORK_CHAT = 0x199
"""AL_NETWORK_CHAT"""
AL_TELEPHONY = 0x19A  # AL_TELEPHONY/DIALER
"""AL_TELEPHONY"""
AL_DIALER = AL_TELEPHONY
"""AL_DIALER"""
AL_LOGON = 0x19B
"""AL_LOGON"""
AL_LOGOFF = 0x19C
"""AL_LOGOFF"""
AL_LOGON_LOGOFF = 0x19D  # AL_LOGON/LOGOFF
"""AL_LOGON_LOGOFF"""
AL_TERMINAL_LOCK = 0x19E  # AL_TERMINAL_LOCK/SCREENSAVER
"""AL_TERMINAL_LOCK"""
AL_SCREENSAVER = AL_TERMINAL_LOCK
"""AL_SCREENSAVER"""
AL_CONTROL_PANEL = 0x19F
"""AL_CONTROL_PANEL"""
AL_COMMAND_LINE_PROCESSOR = 0x1A0  # AL_COMMAND_LINE_PROCESSOR/RUN
"""AL_COMMAND_LINE_PROCESSOR"""
AL_RUN = AL_COMMAND_LINE_PROCESSOR
"""AL_RUN"""
AL_PROCESS_MANAGER = 0x1A1  # AL_PROCESS/TASK_MANAGER
"""AL_PROCESS_MANAGER"""
AL_TASK_MANAGER = AL_PROCESS_MANAGER
"""AL_TASK_MANAGER"""
AL_SELECT_TASK = 0x1A2  # AL_SELECT_TASK/APPLICATION
"""AL_SELECT_TASK"""
AL_SELECT_APPLICATION = AL_SELECT_TASK
"""AL_SELECT_APPLICATION"""
AL_NEXT_TASK = 0x1A3  # AL_NEXT_TASK/APPLICATION
"""AL_NEXT_TASK"""
AL_NEXT_APPLICATION = AL_NEXT_TASK
"""AL_NEXT_APPLICATION"""
AL_PREVIOUS_TASK = 0x1A4  # AL_PREVIOUS_TASK/APPLICATION
"""AL_PREVIOUS_TASK"""
AL_PREVIOUS_APPLICATION = AL_PREVIOUS_TASK
"""AL_PREVIOUS_APPLICATION"""
AL_PREEMPTIVE_HALT_TASK = 0x1A5  # AL_PREEMPTIVE_HALT_TASK/APPLICATION
"""AL_PREEMPTIVE_HALT_TASK"""
AL_PREEMPTIVE_HALT_APPLICATION = AL_PREEMPTIVE_HALT_TASK
"""AL_PREEMPTIVE_HALT_APPLICATION"""
GENERIC_GUI_APPLICATION_CONTROLS = 0x200
"""GENERIC_GUI_APPLICATION_CONTROLS"""
AC_NEW = 0x201
"""AC_NEW"""
AC_OPEN = 0x202
"""AC_OPEN"""
AC_CLOSE = 0x203
"""AC_CLOSE"""
AC_EXIT = 0x204
"""AC_EXIT"""
AC_MAXIMIZE = 0x205
"""AC_MAXIMIZE"""
AC_MINIMIZE = 0x206
"""AC_MINIMIZE"""
AC_SAVE = 0x207
"""AC_SAVE"""
AC_PRINT = 0x208
"""AC_PRINT"""
AC_PROPERTIES = 0x209
"""AC_PROPERTIES"""
AC_UNDO = 0x21A
"""AC_UNDO"""
AC_COPY = 0x21B
"""AC_COPY"""
AC_CUT = 0x21C
"""AC_CUT"""
AC_PASTE = 0x21D
"""AC_PASTE"""
AC_SELECT_ALL = 0x21E
"""AC_SELECT_ALL"""
AC_FIND = 0x21F
"""AC_FIND"""
AC_FIND_AND_REPLACE = 0x220
"""AC_FIND_AND_REPLACE"""
AC_SEARCH = 0x221
"""AC_SEARCH"""
AC_GO_TO = 0x222
"""AC_GO_TO"""
AC_HOME = 0x223
"""AC_HOME"""
AC_BACK = 0x224
"""AC_BACK"""
AC_FORWARD = 0x225
"""AC_FORWARD"""
AC_STOP = 0x226
"""AC_STOP"""
AC_REFRESH = 0x227
"""AC_REFRESH"""
AC_PREVIOUS_LINK = 0x228
"""AC_PREVIOUS_LINK"""
AC_NEXT_LINK = 0x229
"""AC_NEXT_LINK"""
AC_BOOKMARKS = 0x22A
"""AC_BOOKMARKS"""
AC_HISTORY = 0x22B
"""AC_HISTORY"""
AC_SUBSCRIPTIONS = 0x22C
"""AC_SUBSCRIPTIONS"""
AC_ZOOM_IN = 0x22D
"""AC_ZOOM_IN"""
AC_ZOOM_OUT = 0x22E
"""AC_ZOOM_OUT"""
AC_ZOOM = 0x22F
"""AC_ZOOM"""
AC_FULL_SCREEN_VIEW = 0x230
"""AC_FULL_SCREEN_VIEW"""
AC_NORMAL_VIEW = 0x231
"""AC_NORMAL_VIEW"""
AC_VIEW_TOGGLE = 0x232
"""AC_VIEW_TOGGLE"""
AC_SCROLL_UP = 0x233
"""AC_SCROLL_UP"""
AC_SCROLL_DOWN = 0x234
"""AC_SCROLL_DOWN"""
AC_SCROLL = 0x235
"""AC_SCROLL"""
AC_PAN_LEFT = 0x236
"""AC_PAN_LEFT"""
AC_PAN_RIGHT = 0x237
"""AC_PAN_RIGHT"""
AC_PAN = 0x238
"""AC_PAN"""
AC_NEW_WINDOW = 0x239
"""AC_NEW_WINDOW"""
AC_TILE_HORIZONTALLY = 0x23A
"""AC_TILE_HORIZONTALLY"""
AC_TILE_VERTICALLY = 0x23B
"""AC_TILE_VERTICALLY"""
AC_FORMAT = 0x23C
"""AC_FORMAT"""
