"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NORMALIZED_SERVICE_VARIANTS = void 0;
/** Mapping of service variants to asset key service name */
exports.NORMALIZED_SERVICE_VARIANTS = {
    alexa_for_business: ["ask"],
    api_gateway: ["apigateway", "apigatewayv2"],
    application_discovery_service: ["appintegrations", "servicediscovery"],
    aps: ["managed_service_for_prometheus"],
    certificate_manager: ["acmpca"],
    cloudwatch: ["applicationinsights", "evidently", "logs", "rum", "synthetics"],
    console_mobile_application: ["mobile_hub"],
    connect: ["customerprofiles", "voiceid", "wisdom"],
    cost_and_usage_report: ["cur"],
    cost_explorer: ["ce"],
    data_exchange: ["dax"],
    database_migration_service: ["dms"],
    documentdb: ["docdb"],
    ec2: ["imagebuilder"],
    efs: ["elastic_file_system"],
    ebs: ["elastic_block_store", "dlm"],
    ecr: ["elastic_container_registry"],
    ecs: ["elastic_container_service", "ecs_service"],
    eks: ["elastic_kubernetes_service"],
    eventbridge: ["eventschemas", "events"],
    express_workflows: ["express_workflow"],
    fault_injection_simulator: ["fis"],
    firewall_manager: ["fms"],
    glue_databrew: ["databrew", "gluedatabrewinteractivesessions"],
    iam_identity_center: ["sso", "single_sign_on"],
    iam: [
        "identity_and_access_management",
        "identity_access_management",
        "rolesanywhere",
        "accessanalyzer",
    ],
    inspector: ["inspectorv2"],
    interactive_video_service: ["ivs"],
    iot_core: ["iot", "iotwireless"],
    iot_device_management: ["iotfleethub"],
    iot_greengrass: ["greengrass", "greengrassv2"],
    key_management_service: ["kms"],
    keyspaces: ["cassandra", "managed_apache_cassandra_service"],
    kinesis_data_analytics: ["kinesisanalytics", "kinesisanalyticsv2"],
    kinesis_data_streams: ["kinesis"],
    kinesis_firehose: ["firehose"],
    kinesis_video_streams: ["kinesisvideo"],
    location_service: ["location"],
    mainframe_modernization: ["m2"],
    managed_blockchain: ["qldb"],
    managed_grafana: ["managed_service_for_grafana"],
    memorydb_for_redis: ["memorydb"],
    migration_hub: ["refactorspaces"],
    msk: [
        "managed_streaming_for_apache_kafka",
        "managed_streaming_for_kafka",
        "kafkaconnect",
        "kafka",
    ],
    mwaa: [
        "managed_workflows_for_apache_airflow",
        "managed_workflows_for_airflow",
        "airflow",
    ],
    opensearch: [
        "opensearch_service",
        "opensearch",
        "elasticsearch",
        "elasticsearch_service",
    ],
    outposts_rack: ["outposts_1u_and_2u_servers"],
    quantum_ledger_database: ["qldb"],
    pinpoint: ["pinpointemail"],
    resource_access_manager: ["ram"],
    s3_glacier: ["simple_storage_service_glacier", "glacier"],
    s3: ["simple_storage_service"],
    serverless_application_repository: ["serverless", "serverlessdiscovery"],
    ses: ["simple_email_service"],
    sns: ["simple_notification_service"],
    sqs: ["simple_queue_service"],
    ssm: ["systems_manager", "resourcegroups"],
    transfer_family: ["transfer"],
    vpc: ["virtual_private_cloud", "networkmanager"],
    well_architected_tool: ["well_architect_tool"],
    network_firewall: ["fms", "networkfirewall"],
};
//# sourceMappingURL=data:application/json;base64,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