/*! 
* DevExtreme (Vector Map)
* Version: 14.1.7
* Build date: Sep 22, 2014
*
* Copyright (c) 2012 - 2014 Developer Express Inc. ALL RIGHTS RESERVED
* EULA: https://www.devexpress.com/Support/EULAs/DevExtreme.xml
*/
"use strict";if(!DevExpress.MOD_VIZ_VECTORMAP){if(!DevExpress.MOD_VIZ_CORE)throw Error("Required module is not referenced: viz-core");(function(n,t,i){function l(){var t=this._projection,i,n;t.snapCenter().snapZoom().setCenter(null).setZoom(null),i=t.isCenterChanged(),n=t.isZoomChanged(),(i||n)&&this._applyTransform(n,!0),i&&this._raiseCenterChanged(),n&&this._raiseZoomFactorChanged()}function a(){this._projection.snapCenter()}function v(){this._projection.isCenterChanged()&&this._raiseCenterChanged()}function y(n,t){this._projection.moveCenter(n,t),this._applyTranslate()}function p(n,t,r){var f=this,o=t!==i&&r!==i,s,e;o&&(e=u(f._renderer),e=[t-e.left,r-e.top],s=f._projection.fromScreenPoint(e[0],e[1])),f._projection.snapZoom().setScaledZoom(n),f._projection.isZoomChanged()&&(o&&f._projection.snapCenter().setCenterByPoint(s,e),f._applyTransform(!0,!0),f._raiseZoomFactorChanged(),o&&f._projection.isCenterChanged()&&f._raiseCenterChanged())}var e,o;n.viz.map={};var r=window.Number,f=n.utils.isFunction,u=n.utils.getRootOffset,s=800,h=400,c=n.viz.map.__DATA_KEY="vectormap-data";n.viz.map.Map=n.viz.core.BaseWidget.inherit({_init:function(){var n=this;n.callBase.apply(n,arguments),n.renderer=n._renderer=n._factory.createRenderer({width:1,height:1,pathModified:n.option("pathModified"),rtl:n.option("rtlEnabled")}),n.renderer.draw(n._element().get(0)),n._root=n._renderer.getRoot(),n._root.applySettings({"class":"dxm",stroke:"none",strokeWidth:0,fill:"none",align:"center",cursor:"default",style:{overflow:"hidden"}}),n._themeManager=n._factory.createThemeManager(),n._projection=n._factory.createProjection(),n._tracker=n._factory.createTracker({root:n._root}),n._background=n._renderer.createRect(0,0,0,0,0,{"class":"dxm-background"}).data(c,{type:"background"}),n._areasManager=n._factory.createAreasManager({container:n._root,renderer:n._renderer,projection:n._projection,themeManager:n._themeManager,tracker:n._tracker,ready:function(){n.hideLoadingIndicator()}}),n._areasManager.setData(n.option("mapData")),n._markersManager=n._factory.createMarkersManager({container:n._root,renderer:n._renderer,projection:n._projection,themeManager:n._themeManager,tracker:n._tracker}),n._markersManager.setData(n.option("markers")),n._controlBar=n._factory.createControlBar({container:n._root,renderer:n._renderer,context:n,resetCallback:l,beginMoveCallback:a,endMoveCallback:v,moveCallback:y,zoomCallback:p}),n._legend=n._factory.createLegend({container:n._root,renderer:n._renderer,themeManager:n._themeManager}),n._tooltip=n._factory.createTooltip({container:n._root,renderer:n._renderer,tracker:n._tracker}),n._projection.setBounds(n.option("bounds")).setMaxZoom(n.option("maxZoomFactor")).setZoom(n.option("zoomFactor")).setCenter(n.option("center")),n._themeManager.setTheme(n.option("theme")),n._themeManager.patchRtlSettings(n.option("rtlEnabled")),n._setClickCallback(n.option("click")),n._setCenterChangedCallback(n.option("centerChanged")),n._setZoomFactorChangedCallback(n.option("zoomFactorChanged")),n._setTrackerCallbacks()},_dispose:function(){var n=this;n.callBase.apply(n,arguments),n._resetTrackerCallbacks(),n._themeManager.dispose(),n._tracker.dispose(),n._areasManager.dispose(),n._markersManager.dispose(),n._controlBar.dispose(),n._legend.dispose(),n._tooltip.dispose(),n._renderer.dispose(),n._disposeLoadIndicator(),n._renderer=n._themeManager=n._projection=n._tracker=n._root=n._background=n._areasManager=n._markersManager=n._controlBar=n._legend=n._tooltip=n._centerChangedCallback=n._zoomFactorChangedCallback=null},_setTrackerCallbacks:function(){var n=this,e=n._renderer,t={area:n._areasManager,marker:n._markersManager},o=n._projection,r=n._controlBar,i=n._tooltip,s,h,f=!1;n._tracker.setCallbacks({click:function(i){var f=u(e),r;i.$event.x=i.x-f.left,i.$event.y=i.y-f.top,r=t[i.data.type],r&&r.raiseClick(i.data.index,i.$event),(r||i.data.type==="background")&&n._raiseClick(i.$event)},start:function(n){f=n.data.type==="control-bar",f?(n.data=n.data.index,r.processStart(n)):(s=n.x,h=n.y,o.snapCenter())},move:function(t){f?(t.data=t.data.index,r.processMove(t)):(o.moveCenter(s-t.x,h-t.y),s=t.x,h=t.y,n._applyTranslate())},end:function(t){f?(t.data=t.data.index,r.processEnd(t)):o.isCenterChanged()&&n._raiseCenterChanged(),f=!1},zoom:function(n){r.processZoom(n)},"hover-on":function(n){var i=t[n.data.type];i&&i.hoverItem(n.data.index,!0)},"hover-off":function(n){var i=t[n.data.type];i&&i.hoverItem(n.data.index,!1)},"focus-on":function(n,r){var s=!1,f,o;i.enabled()&&(f=t[n.data.type]?t[n.data.type].getProxyItem(n.data.index):null,!!f&&i.prepare(f,{offset:12})&&(o=u(e),i.show().move(n.x-o.left,n.y-o.top),s=!0)),r(s)},"focus-move":function(n){var t=u(e);i.move(n.x-t.left,n.y-t.top)},"focus-off":function(){i.hide()}}),n._resetTrackerCallbacks=function(){n._resetTrackerCallbacks=n=e=t=o=r=i=null}},_adjustSize:function(n){var t=this,e=t.option("size")||{},u=e.width>=0?r(e.width):t._element().width(),f=e.height>=0?r(e.height):t._element().height(),o=!1,c;return(u===0&&(r(e.width)===0?o=!0:u=s),f===0&&(r(e.height)===0?o=!0:f=h),o||!t._element().is(":visible"))?(t._incidentOccured("W2001",[t.NAME]),t._width=t._height=0,!1):(c=t._width!==u||t._height!==f||n,c&&(t._width=u,t._height=f,t._renderer.resize(u,f),t._projection.setSize(u,f),t._legend.applyLayout(u,f),t._tooltip.setSize(u,f),t._background.applySettings({x:0,y:0,width:u,height:f}),t._applyTranslate(),t._updateLoadIndicator(i,u,f)),c)},_clean:function(){var n=this;n._tracker.clean(),n._background.detach(),n._areasManager.clean(),n._markersManager.clean(),n._controlBar.clean(),n._legend.clean(),n._tooltip.clean()},_render:function(){var n=this;n._adjustSize(!0)&&(n._tooltip.update(n._themeManager.getTooltipSettings(n.option("tooltip"))),n._tracker.setOptions(n.option("interaction")||{}),n._controlBar.setZoomPartition(n._projection.getZoomScalePartition()).setZoom(n._projection.getScaledZoom()).setOptions(n._themeManager.getControlBarSettings(n.option("controlBar")),n.option("interaction")),n._background.applySettings(n._themeManager.getBackgroundSettings(n.option("background"))),n._background.append(n._root),n._areasManager.render(n.option("areaSettings")),n._markersManager.render(n.option("markerSettings")),n._controlBar.render(),n._legend.render(n._themeManager.getLegendSettings(n.option("legend"))),n._tooltip.render(),n._tracker.render(),n._drawn())},_optionChanged:function(n,t){var i=this;switch(n){case"theme":i._themeManager.setTheme(t),i._themeManager.patchRtlSettings(i.option("rtlEnabled")),i._invalidate();break;case"click":i._setClickCallback(t);break;case"centerChanged":i._setCenterChangedCallback(t);break;case"zoomFactorChanged":i._setZoomFactorChangedCallback(t);break;case"mapData":i._areasManager.setData(t);break;case"markers":i._markersManager.setData(t);break;case"bounds":i._projection.setBounds(t),i._invalidate();break;case"maxZoomFactor":i._projection.setMaxZoom(t),i._invalidate();break;case"zoomFactor":i._updateZoomFactor(t);break;case"center":i._updateCenter(t);break;default:i.callBase.apply(i,arguments)}},_getLoadIndicatorOption:function(){return this._themeManager.getLoadIndicatorSettings(this.option("loadingIndicator"))},_setClickCallback:function(n){this._clickCallback=f(n)?n:null},_setCenterChangedCallback:function(n){var t=this;t._centerChangedCallback=f(n)?function(){t._centerChangedCallback&&n.call(t,t._projection.getCenter())}:null},_setZoomFactorChangedCallback:function(n){var t=this;t._zoomFactorChangedCallback=f(n)?function(){t._zoomFactorChangedCallback&&n.call(t,t._projection.getZoom())}:null},_raiseClick:function(n){var t=this;t._clickCallback&&setTimeout(function(){t._clickCallback&&t._clickCallback.call(t,n)},0)},_raiseCenterChanged:function(){this._centerChangedCallback&&setTimeout(this._centerChangedCallback,0)},_raiseZoomFactorChanged:function(){this._zoomFactorChangedCallback&&setTimeout(this._zoomFactorChangedCallback,0)},_updateCenter:function(n,t){this._projection.snapCenter().setCenter(n),this._projection.isCenterChanged()&&(this._applyTransform(),t||this._raiseCenterChanged())},_updateZoomFactor:function(n,t){var i=this;i._projection.snapZoom().setZoom(n),i._projection.isZoomChanged()&&(i._controlBar.setZoom(i._projection.getScaledZoom()),i._applyTransform(!0),t||i._raiseZoomFactorChanged())},_updateViewport:function(n,t){var i=this;i._projection.snapCenter().snapZoom().setViewport(n),i._applyTransform(i._projection.isZoomChanged()),i._projection.isCenterChanged()&&(t||i._raiseCenterChanged()),i._projection.isZoomChanged()&&(i._controlBar.setZoom(i._projection.getScaledZoom()),t||i._raiseZoomFactorChanged())},_resize:function(){this._adjustSize()&&this._applyTransform(!0)},_applyTranslate:function(){var n=this._projection.getTransform();this._areasManager.transform(n),this._markersManager.transform(n)},_applyTransform:function(n,t){t||this._tracker.reset(),this._applyTranslate(),n&&(this._areasManager.redraw(),this._markersManager.redraw())},_refresh:function(){var n=this,t=n.callBase;n._endLoading(function(){t.call(n)})},render:function(){var n=this;return n._width===0&&n._height===0?n._refresh():n._resize(),n},getAreas:function(){return this._areasManager.getProxyItems()},getMarkers:function(){return this._markersManager.getProxyItems()},clearAreaSelection:function(n){return this._areasManager.clearSelection(n),this},clearMarkerSelection:function(n){return this._markersManager.clearSelection(n),this},clearSelection:function(n){return this.clearAreaSelection(n).clearMarkerSelection(n)},center:function(n,t){return n===i?this._projection.getCenter():(this._updateCenter(n,t),this)},zoomFactor:function(n,t){return n===i?this._projection.getZoom():(this._updateZoomFactor(n,t),this)},viewport:function(n,t){return n===i?this._projection.getViewport():(this._updateViewport(n,t),this)},convertCoordinates:function(n,t){return this._projection.fromScreenPointStrict(n,t)},showLoadingIndicator:function(){this._showLoadIndicator(this._themeManager.getLoadIndicatorSettings(this.option("loadingIndicator")),{width:this._width,height:this._height})},_factory:{createRenderer:function(t){return new n.viz.renderers.Renderer(t)},createTooltip:function(n){return new e(n)},createLegend:function(n){return new o(n)}}}),e=n.viz.core.Tooltip.inherit({ctor:function(n){var t=this;t._container=n.container,t._root=n.renderer.createGroup({"class":"dxm-tooltip"}),t.callBase(null,t._root,n.renderer),t._tracker=n.tracker,t._enabled=!1},dispose:function(){var n=this;return n._container=n._root=n._tracker=null,n.callBase.apply(n,arguments)},clean:function(){return this._root.detach(),this},render:function(){return this._root.append(this._container),this}}),o=n.viz.core.Legend.inherit({ctor:function(n){var t=this;t._container=n.container,t._root=n.renderer.createGroup({"class":"dxm-legend"}),t._themeManager=n.themeManager,t.callBase(null,null,n.renderer,t._root)},dispose:function(){var n=this;return n._container=n._root=n._themeManager=null,n.callBase.apply(n,arguments)},clean:function(){return this._root.detach(),this},render:function(n){for(var t=this,r=[],i=0,u=n.items?n.items.length:0;i<u;++i)r.push(t._themeManager.getLegendItemSettings(n.items[i]||{}));return t.update(r,n),t._root.append(t._container),t.applyLayout(t._size.width,t._size.height)},applyLayout:function(n,t){var r=this,i,u,f;return r.setSize({width:n,height:t}),r.draw(),i=r.getLayoutOptions(),i&&(u=i.horizontalAlignment==="left"?0:i.horizontalAlignment==="center"?n/2-i.width/2:n-i.width,f=i.verticalAlignment==="top"?0:t-i.height,r.shift(u,f)),r}}),n.registerComponent("dxVectorMap",n.viz.map.Map),n.viz.map._internal={},n.viz.map.sources={}})(DevExpress,jQuery),function(n){function ct(n,t,i){var f=(n[0]+t[0])/2-i/2,e=(n[1]+t[1])/2-i/2,u=2/i;return{project:function(n){var t=r.project(n);return[-1+(t[0]-f)*u,-1+(t[1]-e)*u]},unproject:function(n){var t=[f+(n[0]+1)/u,e+(n[1]+1)/u];return r.unproject(t)}}}function v(n,t){return l(n-t)<1e-8}function u(n,t,i,r){var u=p(n);return u<t?u=t:u>i?u=i:t<=u&&u<=i||(u=r),u}function it(n,t,i){return{lt:[u(n[0],t[0],i[0],t[0]),u(n[1],t[1],i[1],t[1])],rb:[u(n[2],t[0],i[0],i[0]),u(n[3],t[1],i[1],i[1])]}}function lt(n){var i=r.unproject([-1,-1]),u=r.unproject([1,1]),o=[f(i[0],u[0]),f(i[1],u[1])],s=[e(i[0],u[0]),e(i[1],u[1])],t=n;return t&&t.minLon&&(t=[t.minLon,t.minLat,t.maxLon,t.maxLat]),t&&(t=it(t,o,s)),{minBase:o,maxBase:s,min:t?[f(t.lt[0],t.rb[0]),f(t.lt[1],t.rb[1])]:o,max:t?[e(t.lt[0],t.rb[0]),e(t.lt[1],t.rb[1])]:s}}function rt(n,t,i,r){var u;return u=n>-1&&t>=1?i:n<=-1&&t<1?r:(i+r)/2}function y(){this.setBounds(null)}var p=Number,at=isFinite,f=Math.min,e=Math.max,l=Math.abs,ut=Math.tan,ft=Math.atan,et=Math.exp,o=Math.round,s=Math.log,ot=Math.pow,h=n.utils.isArray,st=n.viz.renderers.buildPath,c=Math.PI,w=c/4,b=c/360,ht=2/Math.LN2,a=1,k=256,d=-180,g=180,nt=-85.0511,tt=85.0511,r={aspectRatio:1,project:function(n){var t=n[0],i=n[1];return[t<=d?-1:t>=g?1:t/180,i<=nt?1:i>=tt?-1:-s(ut(w+i*b))/c]},unproject:function(n){var t=n[0],i=n[1];return[t<=-1?d:t>=1?g:180*t,i<=-1?tt:i>=1?nt:(ft(et(-c*n[1]))-w)/b]}};y.prototype={constructor:y,_minZoom:a,_maxZoom:k,_zoom:a,setSize:function(n,t){var i=this;return i._x0=n/2,i._y0=t/2,n/t<=r.aspectRatio?(i._xradius=n/2,i._yradius=n/2/r.aspectRatio):(i._xradius=t/2*r.aspectRatio,i._yradius=t/2),i},setBounds:function(n){var t=this,i=lt(n),o,s;t._minBase=i.minBase,t._maxBase=i.maxBase,t._minBound=i.min,t._maxBound=i.max;var h=r.project(i.min),c=r.project(i.max),a=f(u(l(c[0]-h[0]),.1,2,2),u(l(c[1]-h[1]),.1,2,2)),v=a<2?ct(h,c,a):r;return t._project=v.project,t._unproject=v.unproject,o=t._project(i.minBase),s=t._project(i.maxBase),t._minv=[f(o[0],s[0]),f(o[1],s[1])],t._maxv=[e(o[0],s[0]),e(o[1],s[1])],t._defaultCenter=t._unproject([0,0]),t.setCenter(t._defaultCenter)},_toScreen:function(n){return[this._x0+this._xradius*n[0],this._y0+this._yradius*n[1]]},_fromScreen:function(n){return[(n[0]-this._x0)/this._xradius,(n[1]-this._y0)/this._yradius]},_toTransformed:function(n){return[n[0]*this._zoom+this._dxcenter,n[1]*this._zoom+this._dycenter,]},_toTransformedFast:function(n){return[n[0]*this._zoom,n[1]*this._zoom]},_fromTransformed:function(n){return[(n[0]-this._dxcenter)/this._zoom,(n[1]-this._dycenter)/this._zoom]},_adjustCenter:function(){var n=this,t=n._project(n._center);n._dxcenter=-t[0]*n._zoom,n._dycenter=-t[1]*n._zoom},projectArea:function(n){for(var r=0,o=h(n)?n.length:0,t,i,f,u,e=[];r<o;++r){for(t=n[r],u=[],i=0,f=h(t)?t.length:0;i<f;++i)u.push(this._project(t[i]));e.push(u)}return e},projectPoint:function(n){return n?this._project(n):[]},getAreaCoordinates:function(n){for(var i=0,s=n.length,r,t,e,o=[],u,f;i<s;++i){for(r=n[i],u=[],t=0,e=r.length;t<e;++t)f=this._toScreen(this._toTransformedFast(r[t])),u.push(f[0],f[1]);o.push(st(u))}return o.join(" ")},getPointCoordinates:function(n){var t=this._toScreen(this._toTransformedFast(n));return{x:o(t[0]),y:o(t[1])}},getZoom:function(){return this._zoom},setZoom:function(n){var t=this;return t._zoom=u(n,t._minZoom,t._maxZoom,t._minZoom),t._adjustCenter(),t},getScaledZoom:function(){return o((this._scale.length-1)*s(this._zoom)/s(this._maxZoom))},setScaledZoom:function(n){return this.setZoom(this._scale[o(n)])},getZoomScalePartition:function(){return this._scale.length-1},_setupScaling:function(){var n=this,t=o(ht*s(n._maxZoom));t=t>4?t:4;var u=ot(n._maxZoom,1/t),i=n._minZoom,r=1;for(n._scale=[i];r<=t;++r)n._scale.push(i*=u)},setMaxZoom:function(n){var t=this;return t._minZoom=a,t._maxZoom=u(n,t._minZoom,p.MAX_VALUE,k),t._setupScaling(),t._zoom>t._maxZoom&&t.setZoom(t._maxZoom),t},getMinZoom:function(){return this._minZoom},getMaxZoom:function(){return this._maxZoom},getCenter:function(){return[this._center[0],this._center[1]]},setCenter:function(n){var i=h(n)?n:null,t;return i=i||n&&(n.lon||n.lat)&&[n.lon,n.lat]||[],t=this,t._center=[u(i[0],t._minBound[0],t._maxBound[0],t._defaultCenter[0]),u(i[1],t._minBound[1],t._maxBound[1],t._defaultCenter[1])],t._adjustCenter(),t},setCenterByPoint:function(n,t){var i=this,r=i._project(n),u=i._fromScreen(t);return i.setCenter(i._unproject([-u[0]/i._zoom+r[0],-u[1]/i._zoom+r[1]]))},moveCenter:function(n,t){var i=this,r=i._toScreen(i._toTransformed(i._project(i._center))),u=i._unproject(i._fromTransformed(i._fromScreen([r[0]+n,r[1]+t])));return i.setCenter(u)},getViewport:function(){var n=this._unproject(this._fromTransformed([-1,-1])),t=this._unproject(this._fromTransformed([1,1]));return[n[0],n[1],t[0],t[1]]},setViewport:function(n){var t=this;if(!h(n))return t.setZoom(t._minZoom).setCenter(t._defaultCenter);var a=it(n,t._minBase,t._maxBase),r=t._project(a.lt),u=t._project(a.rb),o=f(r[0],u[0]),s=f(r[1],u[1]),c=e(r[0],u[0]),l=e(r[1],u[1]),i=2/e(c-o,l-s),v=rt(o,c,-1-i*o,1-i*c),y=rt(s,l,-1-i*s,1-i*l);return t.setZoom(i).setCenter(t._unproject([-v/i,-y/i]))},getTransform:function(){return{translateX:this._dxcenter*this._xradius,translateY:this._dycenter*this._yradius}},fromScreenPoint:function(n,t){return this._unproject(this._fromTransformed(this._fromScreen([n,t])))},fromScreenPointStrict:function(n,t){var i=this,r=i._fromTransformed(i._fromScreen([n,t])),u=i._unproject(r);return[r[0]>=i._minv[0]&&r[0]<=i._maxv[0]?u[0]:NaN,r[1]>=i._minv[1]&&r[1]<=i._maxv[1]?u[1]:NaN]},snapCenter:function(){return this._snappedCenter=this.getCenter(),this},isCenterChanged:function(){var n=this.getCenter();return!v(this._snappedCenter[0],n[0])||!v(this._snappedCenter[1],n[1])},snapZoom:function(){return this._snappedZoom=this.getZoom(),this},isZoomChanged:function(){return!v(this._snappedZoom,this.getZoom())}},n.viz.map.Map.prototype._factory.createProjection=function(){return new y}}(DevExpress,jQuery),function(n,t){function f(n){delete n._owner,n.update=function(){},n.finish=function(){}}function v(n,t){this._owner=n,this._command=t.data}function y(n,t){function u(){n._move(i,r),f=b(u,e)}this._command=t.data;var f=null,e=100,i=0,r=0;switch(this._command){case s:r=-10;break;case h:i=10;break;case c:r=10;break;case l:i=-10}this._stop=function(){return k(f),n._endMove(),this._stop=n=u=null,this},t=null,n._beginMove(),u()}function p(n,t){function i(){n._adjustZoom(n._zoomFactor+f),r=b(i,u)}this._owner=n,this._command=t.data;var r=null,u=150,f=this._command===a?1:-1;this._stop=function(){return k(r),this._stop=n=i=null,this},t=null,i()}function w(n,t){this._owner=n,this._zoomFactor=n._zoomFactor,this._pos=t.y}var e=n.viz.renderers.buildPath,b=setTimeout,k=clearTimeout,o=Math.round,it=Math.pow,rt=Math.log,ut=Math.LN2,d="command-reset",s="command-move-up",h="command-move-right",c="command-move-down",l="command-move-left",a="command-zoom-in",g="command-zoom-out",nt="command-zoom-drag",r=n.viz.map.__DATA_KEY,u="control-bar",i={},tt;i[d]=v,i[s]=i[h]=i[c]=i[l]=y,i[a]=i[g]=p,i[nt]=w,tt=n.Class.inherit({ctor:function(n){var t=this;t._container=n.container,t._createElements(n.renderer);var i=n.context,r=n.resetCallback,e=n.beginMoveCallback,o=n.endMoveCallback,u=n.moveCallback,f=n.zoomCallback;n=null,t._reset=function(){r.call(i)},t._beginMove=function(){e.call(i)},t._endMove=function(){o.call(i)},t._move=function(n,t){u.call(i,n,t)},t._zoom=function(n,t,r){f.call(i,n,t,r)},t._dispose=function(){this._reset=this._move=this._zoom=this._dispose=i=r=u=f=null}},_createElements:function(n){var t=this,i;t._root=n.createGroup({"class":"dxm-control-bar"}),t._buttonsGroup=n.createGroup({"class":"dxm-control-buttons"}).append(t._root),t._trackersGroup=n.createGroup({stroke:"none",strokeWidth:0,fill:"#000000",opacity:.0001,cursor:"pointer"}).append(t._root),i={bigCircleSize:58,smallCircleSize:28,buttonSize:10,arrowButtonOffset:20,incdecButtonSize:11,incButtonOffset:66,decButtonOffset:227,sliderLineStartOffset:88.5,sliderLineEndOffset:205.5,sliderLength:20,sliderWidth:8,trackerGap:4},t._createButtons(n,i),t._createTrackers(n,i),t._root.applySettings({translateX:50.5,translateY:50.5})},_createButtons:function(n,t){var i=this._buttonsGroup,r=t.buttonSize/2,u=t.arrowButtonOffset-r,o=t.arrowButtonOffset,f=t.incdecButtonSize/2;n.createCircle(0,0,t.bigCircleSize/2).append(i),n.createCircle(0,0,r).append(i),n.createPath([-r,-u,0,-o,r,-u]).append(i),n.createPath([u,-r,o,0,u,r]).append(i),n.createPath([r,u,0,o,-r,u]).append(i),n.createPath([-u,r,-o,0,-u,-r]).append(i),n.createCircle(0,t.incButtonOffset,t.smallCircleSize/2).append(i),n.createSimplePath({d:e([-f,t.incButtonOffset,f,t.incButtonOffset])+" "+e([0,t.incButtonOffset-f,0,t.incButtonOffset+f])}).append(i),n.createCircle(0,t.decButtonOffset,t.smallCircleSize/2).append(i),n.createSimplePath({d:e([-f,t.decButtonOffset,f,t.decButtonOffset])}).append(i),n.createSimplePath({d:e([0,t.sliderLineStartOffset,0,t.sliderLineEndOffset])}).append(i),this._zoomDrag=n.createRect(-t.sliderLength/2,t.sliderLineEndOffset-t.sliderWidth/2,t.sliderLength,t.sliderWidth).append(i),this._sliderLineLength=t.sliderLineEndOffset-t.sliderLineStartOffset},_createTrackers:function(n,t){var f=this._trackersGroup,i=o((t.arrowButtonOffset-t.trackerGap)/2),v=t.arrowButtonOffset-i,y=o(it(t.bigCircleSize*t.bigCircleSize/4-i*i,.5)),e=y-v,p;n.createRect(-i,-i,i*2,i*2).append(f).data(r,{index:d,type:u}),n.createRect(-i,-y,i*2,e).append(f).data(r,{index:s,type:u}),n.createRect(v,-i,e,i*2).append(f).data(r,{index:h,type:u}),n.createRect(-i,v,i*2,e).append(f).data(r,{index:c,type:u}),n.createRect(-y,-i,e,i*2).append(f).data(r,{index:l,type:u}),n.createCircle(0,t.incButtonOffset,t.smallCircleSize/2).append(f).data(r,{index:a,type:u}),n.createCircle(0,t.decButtonOffset,t.smallCircleSize/2).append(f).data(r,{index:g,type:u}),this._zoomDragCover=n.createRect(-t.sliderLength/2,t.sliderLineEndOffset-t.sliderWidth/2,t.sliderLength,t.sliderWidth).append(f).data(r,{index:nt,type:u})},dispose:function(){var n=this;return delete n._container,n._dispose(),n._root.clear(),delete n._root,delete n._buttonsGroup,delete n._zoomDrag,delete n._zoomDragCover,n},setZoomPartition:function(n){return this._zoomPartition=n,this._sliderUnitLength=this._sliderLineLength/n,this},setZoom:function(n){return this._adjustZoom(n),this},setOptions:function(n,i){return n=n||{},i=i||{},this._dragAndZoomEnabled=i.dragAndZoomEnabled!==t?!!i.dragAndZoomEnabled:!0,this._enabled=this._dragAndZoomEnabled&&(n.enabled!==t?!!n.enabled:!0),this._buttonsGroup.applySettings(n.shape),this},clean:function(){return this._enabled&&this._root.detach(),this},render:function(){return this._enabled&&this._root.append(this._container),this},_adjustZoom:function(n){var t=this,i;t._zoomFactor=o(n),t._zoomFactor>=0||(t._zoomFactor=0),t._zoomFactor<=t._zoomPartition||(t._zoomFactor=t._zoomPartition),i={translateY:-t._zoomFactor*t._sliderUnitLength},t._zoomDrag.applySettings(i),t._zoomDragCover.applySettings(i)},_applyZoom:function(n,t){this._zoom(this._zoomFactor,n,t)},processStart:function(n){if(this._dragAndZoomEnabled){var t=i[n.data];this._command=new t(this,n)}return this},processMove:function(n){return this._dragAndZoomEnabled&&this._command.update(n),this},processEnd:function(n){return this._dragAndZoomEnabled&&this._command.finish(n),this},processZoom:function(n){var t=this,i;return t._dragAndZoomEnabled&&(n.delta?i=n.delta:n.ratio&&(i=rt(n.ratio)/ut),t._adjustZoom(t._zoomFactor+i),t._applyZoom(n.x,n.y)),t}}),v.prototype.update=function(n){n.data!==this._command&&f(this)},v.prototype.finish=function(){this._owner._reset(),this._owner._adjustZoom(0),f(this)},y.prototype.update=function(n){this._command!==n.data&&this.finish()},y.prototype.finish=function(){f(this._stop())},p.prototype.update=function(n){this._command!==n.data&&this.finish()},p.prototype.finish=function(){this._owner._applyZoom(),f(this._stop())},w.prototype.update=function(n){var t=this._owner;t._adjustZoom(this._zoomFactor+t._zoomPartition*(this._pos-n.y)/t._sliderLineLength)},w.prototype.finish=function(){this._owner._applyZoom(),f(this)},n.viz.map.Map.prototype._factory.createControlBar=function(n){return new tt(n)}}(DevExpress),function(n,t,i){function it(n){this._root=n.root,this._callbacks={},this._createEventHandlers(),this._focus=new rt(this._callbacks)}function rt(n){this._callbacks=n,this.disabled=!0}function ut(n,t,i,r){return et((n-i)*(n-i)+(t-r)*(t-r))}function u(n){var t=n.originalEvent.type,i=n.originalEvent.pointerType;return/^touch/.test(t)||/^MSPointer/.test(t)&&i!==4||/^pointer/.test(t)&&i!=="mouse"}function s(n,t){for(var i=0,u=n.length,r;i<u;++i)if(n[i]){r=t[i];break}return h(r||t[i],c)}function ni(){var n=[navigator.pointerEnabled,navigator.msPointerEnabled,"ontouchstart"in window];r={start:s(n,["pointerdown","MSPointerDown","touchstart mousedown","mousedown"]),move:s(n,["pointermove","MSPointerMove","touchmove mousemove","mousemove"]),end:s(n,["pointerup","MSPointerUp","touchend mouseup","mouseup"]),over:s(n,["pointerover","MSPointerOver","mouseover","mouseover"]),out:s(n,["pointerout","MSPointerOut","mouseout","mouseout"]),wheel:s([],["mousewheel DOMMouseScroll"])}}function e(n){var t=n.originalEvent,i=t.touches&&t.touches[0]||{};return{x:i.pageX||t.pageX||n.pageX,y:i.pageY||t.pageY||n.pageY}}function ft(n){return n.originalEvent.pointerId}function l(n,t){var r=n.originalEvent;return r=r.pointerId!==i?r.pointerId===t?r:null:r.touches[t],r?{x:r.pageX||n.pageX,y:r.pageY||n.pageY}:null}var h=n.ui.events.addNamespace,o=Math.abs,et=Math.sqrt,p=Math.round,ot=Math.max,st=Math.min,w=t.now,a=t.extend,c=n.viz.map.Map.prototype.NAME,f=n.viz.map.__DATA_KEY,b=t(document),r={};ni();var ht="start",ct="move",lt="end",k="zoom",at="hover-on",vt="hover-off",yt="click",pt="focus-on",wt="focus-move",d="focus-off",bt=500,g=5,kt=5,dt=10,v=300,nt=300,gt=300,y=400,tt=5;a(it.prototype,{dispose:function(){var n=this;return n._focus.dispose(),n._root=n._callbacks=n._focus=n._rootClickEvents=n._$docClickEvents=n._rootZoomEvents=n._$docZoomEvents=n._rootHoverEvents=n._$docHoverEvents=n._rootFocusEvents=n._$docFocusEvents=null,n},_createEventHandlers:function(){var n=this;n._rootClickEvents={},n._rootClickEvents[r.start]=function(t){var r=u(t),i;(!r||n._isTouchEnabled)&&(t.preventDefault(),i=e(t),n._clickState={x:i.x,y:i.y,time:w()})},n._$docClickEvents={},n._$docClickEvents[r.end]=function(i){var s=n._clickState,h,r;s&&(h=u(i),!h||n._isTouchEnabled)&&(w()-s.time<=bt&&(r=e(i),o(r.x-s.x)<=g&&o(r.y-s.y)<=g&&n._callbacks[yt]({data:t(i.target).data(f)||{},x:r.x,y:r.y,$event:i})),n._clickState=null)},n._rootDragEvents={},n._rootDragEvents[r.start]=function(i){var o=u(i),r;(!o||n._isTouchEnabled)&&(r=e(i),n._dragState={x:r.x,y:r.y,data:t(i.target).data(f)||{}},n._isDragEnabled&&n._callbacks[ht]({data:n._dragState.data,x:r.x,y:r.y}))},n._$docDragEvents={},n._$docDragEvents[r.move]=function(i){var r=n._dragState,h,s,c;r&&(h=u(i),!h||n._isTouchEnabled)&&(s=e(i),c=h?dt:kt,(r.active||o(s.x-r.x)>c||o(s.y-r.y)>c)&&(r.x=s.x,r.y=s.y,r.active=!0,r.data=t(i.target).data(f)||{},n._isDragEnabled&&n._callbacks[ct]({data:r.data,x:s.x,y:s.y})))},n._$docDragEvents[r.end]=function(t){var r=n._dragState,i;r&&(i=u(t),!i||n._isTouchEnabled)&&n._endDragging()},n._rootZoomEvents={},n._rootZoomEvents[r.wheel]=function(t){var i,r;n._isWheelEnabled&&((t.preventDefault(),n._zoomState)||(i=t.originalEvent.wheelDelta/120||t.originalEvent.detail/-3||0,i!==0)&&(i=i>0?st(p(i)||1,4):ot(p(i)||-1,-4),r=e(t),n._isZoomEnabled&&n._callbacks[k]({delta:i,x:r.x,y:r.y}),n._zoomState=setTimeout(function(){n._zoomState=null},50)))},n._rootZoomEvents[r.start]=function(t){var o=u(t),r,f,e;o&&n._isTouchEnabled&&((r=n._zoomState=n._zoomState||{},r.pointer1&&r.pointer2)||(r.pointer1===i&&(r.pointer1=ft(t)||0,f=l(t,r.pointer1),r.x1=r.x1_0=f.x,r.y1=r.y1_0=f.y),r.pointer2===i&&(e=ft(t)||1,e!==r.pointer1&&(f=l(t,e),f&&(r.x2=r.x2_0=f.x,r.y2=r.y2_0=f.y,r.pointer2=e,r.ready=!0,n._endDragging())))))},n._$docZoomEvents={},n._$docZoomEvents[r.move]=function(t){var r=n._zoomState,e,f;r&&(e=u(t),e&&n._isTouchEnabled)&&(r.pointer1!==i&&(f=l(t,r.pointer1),f&&(r.x1=f.x,r.y1=f.y)),r.pointer2!==i&&(f=l(t,r.pointer2),f&&(r.x2=f.x,r.y2=f.y)))},n._$docZoomEvents[r.end]=function(t){var i=n._zoomState,r,f,e;i&&(r=u(t),r&&n._isTouchEnabled)&&(i.ready&&(f=ut(i.x1_0,i.y1_0,i.x2_0,i.y2_0),e=ut(i.x1,i.y1,i.x2,i.y2),n._isZoomEnabled&&n._callbacks[k]({ratio:e/f,x:(i.x1_0+i.x2_0)/2,y:(i.y1_0+i.y2_0)/2})),n._zoomState=null)},n._rootHoverEvents={},n._rootHoverEvents[r.over]=function(i){var e,r;n._hoverTarget!==i.target&&((e=u(i),e)||(r=t(i.target).data(f),r)&&(n._hoverTarget&&n._endHovering(),n._hoverTarget=i.target,n._hoverState={data:r},n._callbacks[at]({data:r})))},n._$docHoverEvents={},n._$docHoverEvents[r.out]=function(i){var o=n._hoverState,r,e;o&&((r=u(i),r)||(e=t(i.target).data(f),e)&&n._endHovering())},n._rootFocusEvents={},n._rootFocusEvents[r.start]=function(i){var o=u(i),r;o&&n._isTouchEnabled&&(r=t(i.target).data(f),r)&&(n._focus.turnOff(y),n._focus.turnOn(i.target,r,e(i),gt),n._skip$docEvent=!0)},n._rootFocusEvents[r.over]=function(i){var s,r,o;n._focusTarget!==i.target&&((n._focusTarget=i.target,s=u(i),s)||(r=t(i.target).data(f),r)&&(n._focusTarget&&n._focus.turnOff(nt),o=e(i),n._focus.active?n._focus.move(i.target,r,o):n._focus.turnOn(i.target,r,o,v)))},n._$docFocusEvents={},n._$docFocusEvents[r.start]=function(t){n._focusTarget=t.target;var i=u(t);i&&n._isTouchEnabled&&(n._skip$docEvent||n._focus.turnOff(y),n._skip$docEvent=null)},n._$docFocusEvents[r.move]=function(i){var h,s,r;n._focus.disabled||n._focusTarget===i.target&&(h=u(i),!h||n._isTouchEnabled)&&(s=t(i.target).data(f),s)&&(r=e(i),h?(n._dragState&&n._dragState.active||n._zoomState&&n._zoomState.ready)&&n._focus.cancel():n._focus.active?n._dragState&&n._dragState.active?(n._focus.cancel(),n._focus.turnOn(i.target,s,r,v*4)):n._focus.move(i.target,s,r):(o(r.x-n._focus.x)>tt||o(r.y-n._focus.y)>tt)&&n._focus.turnOn(i.target,s,r,v))},n._$docFocusEvents[r.end]=function(t){if(!n._focus.disabled){var i=u(t);i&&n._isTouchEnabled&&(n._focusTarget=null,n._focus.active?n._focus.changing&&n._focus.cancel():n._focus.turnOff(y))}},n._$docFocusEvents[r.out]=function(i){var r,e;n._focus.disabled||(r=u(i),r)||(n._focusTarget=null,e=t(i.target).data(f),e)&&n._focus.turnOff(nt)}},_endDragging:function(){var n=this,t=n._dragState;n._dragState=null,t&&n._isDragEnabled&&n._callbacks[lt]({data:t.data,x:t.x,y:t.y})},_endHovering:function(){var n=this,t=n._hoverState;n._hoverState=n._hoverTarget=null,t&&n._callbacks[vt]({data:t.data})},reset:function(){var n=this;return n._clickState=null,n._endDragging(),n._endHovering(),n._focus.cancel(),n._focusTarget=null,n},setCallbacks:function(n){return a(this._callbacks,n),this},setOptions:function(n){return this._isTouchEnabled=n.touchEnabled===i||!!n.touchEnabled,this._isWheelEnabled=n.wheelEnabled===i||!!n.wheelEnabled,this._isDragEnabled=n.dragAndZoomEnabled===i||!!n.dragAndZoomEnabled,this._isZoomEnabled=n.dragAndZoomEnabled===i||!!n.dragAndZoomEnabled,this},clean:function(){var n=this;return n._isTouchEnabled&&(n._root.applySettings({style:{"touch-action":"","-ms-touch-action":"","-webkit-user-select":""}}),n._root.off(h("MSHoldVisual",c)).off(h("contextmenu",c))),n._detachEventHandlers(),n.reset(),n},render:function(){var n=this;if(n._isTouchEnabled){n._root.applySettings({style:{"touch-action":"none","-ms-touch-action":"none","-webkit-user-select":"none"}});n._root.on(h("MSHoldVisual",c),function(n){n.preventDefault()}).on(h("contextmenu",c),function(n){u(n)&&n.preventDefault()})}return n._attachEventHandlers(),n},_attachEventHandlers:function(){var n=this;n._root.on(n._rootClickEvents).on(n._rootDragEvents).on(n._rootZoomEvents).on(n._rootHoverEvents).on(n._rootFocusEvents);b.on(n._$docClickEvents).on(n._$docDragEvents).on(n._$docZoomEvents).on(n._$docHoverEvents).on(n._$docFocusEvents)},_detachEventHandlers:function(){var n=this;n._root.off(n._rootClickEvents).off(n._rootDragEvents).off(n._rootZoomEvents).off(n._rootHoverEvents).off(n._rootFocusEvents),b.off(n._$docClickEvents).off(n._$docDragEvents).off(n._$docZoomEvents).off(n._$docHoverEvents).off(n._$docFocusEvents)}}),a(rt.prototype,{dispose:function(){var n=this;clearTimeout(n._onTimer),clearTimeout(n._offTimer),n._callbacks=n._onTimer=n._offTimer=n.active=n._data=null},_createCallback:function(n,t,i){function u(i){r.changing=null,r.disabled=!i,i&&(r._data=t,r.active=n,clearTimeout(r._offTimer),r._offTimer=null)}var r=this;return function(){r.active===n?(r._callbacks[wt]({data:r._data,x:i.x,y:i.y}),u(!0)):r._callbacks[pt]({data:t,x:i.x,y:i.y},u)}},turnOn:function(n,t,i,r){var u=this;u.disabled=!1,u.x=i.x,u.y=i.y,clearTimeout(u._onTimer),u.changing=!0,u._onTimer=setTimeout(u._createCallback(n,t,i),r)},move:function(n,t,i){this.x=i.x,this.y=i.y,this._createCallback(n,t,i)()},turnOff:function(n){var t=this;t.active?t._offTimer=t._offTimer||setTimeout(function(){t._offTimer=null,t._callbacks[d]({data:t._data}),t._data=t.active=null,t.disabled=!0},n):(clearTimeout(t._onTimer),t._onTimer=null,t.disabled=!0)},cancel:function(){var n=this;n.active&&n._callbacks[d]({data:n._data}),clearTimeout(n._onTimer),clearTimeout(n._offTimer),n._data=n.active=n._onTimer=n._offTimer=null,n.disabled=!0}}),n.viz.map.Map.prototype._factory.createTracker=function(n){return new it(n)}}(DevExpress,jQuery),function(n,t,i){var u=Number,r=t.extend,f=t.each,e=n.viz.core.BaseThemeManager.inherit({_themeSection:"map",_initializeTheme:function(){var n=this;n._initializeFont(n._theme.marker.font),n._initializeFont(n._theme.tooltip.font),n._initializeFont(n._theme.legend.font),n._initializeFont(n._theme.loadingIndicator.font)},dispose:function(){var n=this;return n.callBase.apply(n,arguments),n._areasPalette=n._markersPalette=null,n},getBackgroundSettings:function(n){var i=this._theme.background,t=r({},i,n);return{strokeWidth:t.borderWidth,stroke:t.borderColor,fill:t.color}},getCommonAreaSettings:function(t){var i=r({},this._theme.area,t);return this._areasPalette=new n.viz.core.GradientPalette(i.palette,i.paletteSize),i},getAreaSettings:function(n,t){t=t||{};var f=r({},n,t);return f.borderWidth=u(f.borderWidth)||0,f.borderColor=f.borderColor||null,t.color===i&&t.paletteIndex>=0&&(f.color=this._areasPalette.getColor(t.paletteIndex)),f.color=f.color||null,f.hoveredBorderWidth=u(f.hoveredBorderWidth)||f.borderWidth,f.hoveredBorderColor=f.hoveredBorderColor||f.borderColor,f.hoveredColor=f.hoveredColor||f.color,f.selectedBorderWidth=u(f.selectedBorderWidth)||f.borderWidth,f.selectedBorderColor=f.selectedBorderColor||f.borderColor,f.selectedColor=f.selectedColor||f.color,f},getCommonMarkerSettings:function(t){t=t||{};var i=this._theme.marker,u={};return f(i,function(n){if(n[0]==="_"){var f=i[n]||{},e=t[n]||{},o=r({},i,f,t,e);o.font=r({},i.font,f.font,t.font,e.font),u[n.substr(1)]=o}}),this._markersPalette=new n.viz.core.Palette(t.palette||i.palette,{stepHighlight:50,theme:this.themeName()}),u},getMarkerSettings:function(n,t,i){t=t||{};var e=n[i],f=r({},e,t);return f.font=r({},e.font,t.font),f.borderWidth=u(f.borderWidth)||0,f.borderColor=f.borderColor||null,f.color=f.color||null,f.opacity=f.opacity||null,f.hoveredBorderWidth=u(f.hoveredBorderWidth)||f.borderWidth,f.hoveredBorderColor=f.hoveredBorderColor||f.borderColor,f.hoveredColor=f.hoveredColor||f.color,f.hoveredOpacity=f.hoveredOpacity||f.opacity,f.selectedBorderWidth=u(f.selectedBorderWidth)||f.borderWidth,f.selectedBorderColor=f.selectedBorderColor||f.borderColor,f.selectedColor=f.selectedColor||f.color,f.selectedOpacity=f.selectedOpacity||f.opacity,f},getMarkerColors:function(n){for(var t=0,i=[];t<n;++t)i.push(this._markersPalette.getNextColor());return this._markersPalette.reset(),i},getControlBarSettings:function(n){var i=this._theme.controlBar,t=r({},i,n);return r({},n,{shape:{strokeWidth:t.borderWidth,stroke:t.borderColor,fill:t.color}})},getLoadIndicatorSettings:function(n){var t=this._theme.loadingIndicator;return r(!0,{},t,n)},getTooltipSettings:function(n){var i=this._theme.tooltip,t=r({},i,n),u=r({},i.border,n&&n.border,n&&!n.border&&{color:n.borderColor});return r({},n,{color:t.color,border:u,text:{strokeWidth:0,stroke:"none",fill:"none",font:r({},i.font,t.font),"class":"dxm-tooltip-text"},arrowLength:t.arrowLength,paddingLeftRight:t.paddingLeftRight,paddingTopBottom:t.paddingTopBottom,opacity:t.opacity,shadow:r({},i.shadow,t.shadow)})},getLegendSettings:function(n){return r(!0,{},this._theme.legend,n)},getLegendItemSettings:function(n){var t=n.color;return t===i&&n.paletteIndex>=0&&(t=this._areasPalette.getColor(n.paletteIndex)),{text:n.text,color:t}},patchRtlSettings:function(n){var i=this._theme;(n||i.rtlEnabled&&n!==!1)&&t.extend(!0,i,i._rtl)}});n.viz.map.Map.prototype._factory.createThemeManager=function(){return new e}}(DevExpress,jQuery),function(n,t,i){function p(n,t,r){return t=t||{},{attribute:function(n){return n!==i?t[n]:a({},t)},selected:function(t,u){return t!==i?(n.selected!==!!t&&r(n._data.index,!!t,u),this):n.selected}}}function s(n){r(n,function(t){n[t]=null})}var h=String,c=n.utils.isString,l=n.utils.isArray,e=n.utils.isFunction,a=t.extend,r=t.each,v=t.map,f="none",u="single",o="multiple",y=n.Class.inherit({_rootClass:null,ctor:function(n){var t=this;t._container=n.container,t._renderer=n.renderer,t._projection=n.projection,t._themeManager=n.themeManager,t._tracker=n.tracker,t._ready=n.ready,t._root=t._renderer.createGroup({"class":t._rootClass}),t._items=[],t._context={renderer:t._renderer,root:t._root,projection:t._projection,selectItem:function(n,i,r){t.selectItem(n,i,r)}}},dispose:function(){var n=this;return n._container=n._renderer=n._projection=n._themeManager=n._tracker=n._ready=n._root=n._source=n._context=null,n},clean:function(){var n=this;return n._rendered=!1,n._root.detach(),n._customizeCallback=n._clickCallback=n._selectionChangedCallback=null,n._destroyItems(),n},render:function(n){var t,i;return n=n||{},t=this,t._rendered=!0,t._customizeCallback=e(n.customize)?n.customize:null,t._clickCallback=e(n.click)?n.click:null,t._selectionChangedCallback=e(n.selectionChanged)?n.selectionChanged:null,t._hoverEnabled="hoverEnabled"in n?!!n.hoverEnabled:!0,i=h(n.selectionMode).toLowerCase(),t._selectionMode=i===f||i===u||i===o?i:u,t._root.append(t._container),t._source!==null&&t._createItems(),t},_destroyItems:function(){var n=this;n._root.clear(),r(n._items,function(n,t){t.clean().dispose()}),n._items=[],n._selectedItems=null},_getItemSettings:null,_createItem:null,_isItemSelected:null,_arrangeItems:null,_createItems:function(){var n=this,t;n._selectedItems=n._selectionMode===o?{}:null,t=[],r(l(n._source)?n._source:[],function(i,r){var u,f,e;r=r||{},u=n._customizeCallback&&n._customizeCallback.call(r,r)||{},f={item:r,coords:n._getItemCoordinates(r),attrs:n._getItemAttributes(r)},u=n._getItemSettings(f,u),e=n._createItem(u),e.init(n._context,f,i).render(u).locate(),n._items.push(e),n._isItemSelected(f,u)&&t.push(i)}),n._selectionMode!==f&&t.length>0&&(n._selectionMode===u&&(t=[t[t.length-1]]),r(t,function(t,i){n.selectItem(i,!0,!0)})),n._arrangeItems(),n._ready&&n._ready()},_processSource:null,setData:function(n){function r(n){i._source=i._processSource(n)||0,i._rendered&&(i._tracker.reset(),i._destroyItems(),i._createItems())}var i=this;return i._source=null,c(n)?t.getJSON(n).done(r).fail(function(){r(null)}):r(n),i},transform:function(n){return this._root.applySettings(n),this},redraw:function(){return r(this._items,function(n,t){t.locate()}),this},hoverItem:function(n,t){return this._hoverEnabled&&this._items[n].setHovered(!!t),this},_raiseSelectionChanged:function(n){var t=this;t._selectionChangedCallback&&setTimeout(function(){t._selectionChangedCallback&&t._selectionChangedCallback.call(n.proxy,n.proxy)},0)},selectItem:function(n,t,i){var r=this,e,o;return r._selectionMode===f?r:(e=r._items[n],o=e.selected,e.setSelected(!!t),e.selected===o)?r:(i||r._raiseSelectionChanged(e),e.selected&&r._selectionMode===u&&r._selectedItems&&(r._selectedItems.setSelected(!1),i||r._raiseSelectionChanged(r._selectedItems),r._selectedItems=null),r._selectionMode===u?r._selectedItems=e.selected?e:null:e.selected?r._selectedItems[n]=e:delete r._selectedItems[n],r)},clearSelection:function(){var n=this;return n._selectionMode===f?n:(n._selectionMode===u?n._selectedItems&&(n._selectedItems.setSelected(!1),n._raiseSelectionChanged(n._selectedItems),n._selectedItems=null):r(n._selectedItems,function(t,i){i.setSelected(!1),n._raiseSelectionChanged(i),delete n._selectedItems[t]}),n)},raiseClick:function(n,t){var i=this,r=i._items[n];return i._clickCallback&&setTimeout(function(){i._clickCallback&&i._clickCallback.call(r.proxy,r.proxy,t)},0),i},getProxyItems:function(){return v(this._items,function(n){return n.proxy})},getProxyItem:function(n){return this._items[n].proxy}});n.viz.map._internal.mapItemBehavior={init:function(n,t,i){var r=this;return r._ctx=n,r._src=t,r._coords=r._project(n.projection,t.coords),r._data={index:i,type:r._type},r.hovered=r.selected=!1,r.proxy=p(r,t.attrs,n.selectItem),r.proxy.type=r._type,r._init(),r},dispose:function(){return s(this.proxy),s(this),this},locate:function(){var n=this;return n._locate(n._transform(n._ctx.projection,n._coords)),n},clean:function(){return this._root.detach(),this},render:function(n){var t=this;return t._root=t._createRoot().append(t._ctx.root),t._render(n),t},setHovered:function(n){var t=this;return t.hovered=!!n,t._onHover(),t.selected||(t.hovered?t._setHoveredState():t._setDefaultState()),t},setSelected:function(n){var t=this;return t.selected=!!n,t.selected?t._setSelectedState():t.setHovered(t.hovered),t}},n.viz.map.Map.prototype._factory.MapItemsManager=y}(DevExpress,jQuery),function(n,t,i){function e(n){return n.coordinates}function o(n){var t,r;return n.geometry&&(r=n.geometry.type,t=n.geometry.coordinates,t&&(r==="Polygon"||r==="MultiPolygon")?r==="MultiPolygon"&&(t=[].concat.apply([],t)):t=i),t}function s(n){return n.attributes}function h(n){return n.properties}function r(){}var u=n.viz.map.__DATA_KEY,f=n.viz.map.Map.prototype._factory.MapItemsManager.inherit({_rootClass:"dxm-areas",_processSource:function(n){var t=n&&n.type==="FeatureCollection";return this._getItemCoordinates=t?o:e,this._getItemAttributes=t?h:s,t?n.features:n},clean:function(){return this._commonSettings=null,this.callBase.apply(this,arguments)},render:function(n){return this._commonSettings=this._themeManager.getCommonAreaSettings(n||{}),this.callBase.apply(this,arguments)},_getItemSettings:function(n,t){return this._themeManager.getAreaSettings(this._commonSettings,t)},_createItem:function(){return new r},_isItemSelected:function(n,t){return n.attrs.isSelected||t.isSelected},_arrangeItems:t.noop});t.extend(r.prototype,n.viz.map._internal.mapItemBehavior,{_type:"area",_project:function(n,t){return n.projectArea(t)},_init:t.noop,_createRoot:function(){return this._ctx.renderer.createSimplePath()},_render:function(n){var t=this;return t._styles={normal:{"class":"dxm-area",stroke:n.borderColor,strokeWidth:n.borderWidth,fill:n.color},hovered:{"class":"dxm-area dxm-area-hovered",stroke:n.hoveredBorderColor,strokeWidth:n.hoveredBorderWidth,fill:n.hoveredColor},selected:{"class":"dxm-area dxm-area-selected",stroke:n.selectedBorderColor,strokeWidth:n.selectedBorderWidth,fill:n.selectedColor}},t._root.applySettings(t._styles.normal).data(u,t._data),t},_transform:function(n,t){return n.getAreaCoordinates(t)},_locate:function(n){this._root.applySettings({d:n})},_onHover:t.noop,_setDefaultState:function(){this._root.applySettings(this._styles.normal).toBackground()},_setHoveredState:function(){this._root.applySettings(this._styles.hovered).toForeground()},_setSelectedState:function(){this._root.applySettings(this._styles.selected).toForeground()}}),n.viz.map.Map.prototype._factory.createAreasManager=function(n){return new f(n)}}(DevExpress,jQuery),function(n,t){function ut(n){return function(){return[r(n[0]),r(n[1])]}}function v(){}function y(){}function p(){}function w(){}function b(n,t){return e[n]&&n||t||it}var r=Number,ft=String,h=isFinite,c=Math.round,k=Math.max,d=Math.min,u=t.extend,g=n.utils.isArray,s=n.viz.renderers.processCircleSettings,l="dxm-marker",nt="dxm-marker dxm-marker-hovered",tt="dxm-marker dxm-marker-selected",a={stroke:"none",strokeWidth:0,fill:"#000000",opacity:.0001},f=n.viz.map.__DATA_KEY,it="dot",e={},rt=n.viz.map.Map.prototype._factory.MapItemsManager.inherit({_rootClass:"dxm-markers",ctor:function(){var n=this;n.callBase.apply(n,arguments),n._context.getColors=function(t){return n._themeManager.getMarkerColors(t)},n._filter=n._renderer.createFilter("shadow").applySettings({x:"-40%",y:"-40%",width:"180%",height:"200%",color:"#000000",opacity:.2,dx:0,dy:1,blur:1}).append()},dispose:function(){return this._filter.dispose(),this._filter=null,this.callBase.apply(this,arguments)},_getItemCoordinates:function(n){return n.coordinates},_getItemAttributes:function(n){return n.attributes},_processSource:function(n){return n},clean:function(){var n=this;return n._commonSettings=null,n.callBase.apply(n,arguments)},render:function(n){var t=this;return t._commonSettings=t._themeManager.getCommonMarkerSettings(n),t._commonSettings._filter=t._filter.ref,t._commonType=b(n&&n.type),t.callBase.apply(t,arguments)},_arrangeBubbles:function(){for(var f=this._items,i=[],r=f.length,n,u=[],t=0;t<r;++t)n=f[t],n.type==="bubble"&&(i.push(n),n.value!==null&&u.push(n.value));var e=d.apply(null,u),o=k.apply(null,u),s=o-e||1;for(t=0,r=i.length;t<r;++t)n=i[t],n.setSize(n.value!==null?(n.value-e)/s:0)},_getItemSettings:function(n,t){var r=b(n.item.type,this._commonType),i=u(n.item.style,t);return i=this._themeManager.getMarkerSettings(this._commonSettings,i,r),u(n.item,{text:n.item.text||i.text}),i._type=r,i},_createItem:function(n){return new e[n._type]},_isItemSelected:function(n,t){return n.item.isSelected||t.isSelected},_arrangeItems:function(){this._arrangeBubbles()},addMarker:function(n){var t=this,i=t._items.length,r=t._createItem(n,i);return t._items.push(r),r._selected&&t.selectItem(i,!0,!0),t._arrangeItems(),t}}),o=u({},n.viz.map._internal.mapItemBehavior,{_type:"marker",_project:function(n,t){return n.projectPoint(t)},_init:function(){this.proxy.coordinates=ut(this._src.coords),this.proxy.text=this._src.item.text},_createRoot:function(){return this._ctx.renderer.createGroup()},_render:function(n){var t=this;return t._root.applySettings({"class":l}),t._create(n,t._ctx.renderer,t._root),t._createText(n,t._ctx.renderer,t._root),t},_createText:function(n,t,i){var u=this;if(u._src.item.text){var h=u._root.getBBox(),e=t.createText(u._src.item.text,0,0,{align:"center",font:n.font}).append(i),r=e.getBBox(),o=c(-r.x+h.width/2)+2,s=c(-r.y-r.height/2)-1;e.applySettings({x:o,y:s}),t.createRect(o+r.x-1,s+r.y-1,r.width+2,r.height+2,0,a).data(f,u._data).append(i)}},_transform:function(n,t){return n.getPointCoordinates(t)},_locate:function(n){this._root.applySettings({translateX:n.x,translateY:n.y})},_onHover:function(){this.hovered&&this._root.toForeground()},_setDefaultState:function(){this._root.applySettings({"class":l}).toBackground(),this._applyDefault()},_setHoveredState:function(){this._root.applySettings({"class":nt}),this._applyHovered()},_setSelectedState:function(){this._root.applySettings({"class":tt}).toForeground(),this._applySelected()}});u(v.prototype,o,{type:"dot",_create:function(n,t,i){var e=this,o=n.size>0?r(n.size):0,h=o,c=o+(n.selectedStep>0?r(n.selectedStep):0),l=h+(n.backStep>0?r(n.backStep):0),a=c+(n.backStep>0?r(n.backStep):0),u=s(0,0,o,n.borderWidth);e._dotDefault={cx:u.cx,cy:u.cy,r:u.r,stroke:n.borderColor,strokeWidth:n.borderWidth,fill:n.color,filter:n.shadow?n._filter:null},e._dotHovered={cx:u.cx,cy:u.cy,r:h/2,stroke:n.hoveredBorderColor,strokeWidth:n.hoveredBorderWidth,fill:n.hoveredColor},e._dotSelected={cx:u.cx,cy:u.cy,r:c/2,stroke:n.selectedBorderColor,strokeWidth:n.selectedBorderWidth,fill:n.selectedColor},e._backDefault={cx:u.cx,cy:u.cy,r:u.r,stroke:"none",strokeWidth:0,fill:n.backColor,opacity:n.backOpacity},e._backHovered={cx:u.cx,cy:u.cy,r:l/2,stroke:"none",strokeWidth:0,fill:n.backColor,opacity:n.backOpacity},e._backSelected={cx:u.cx,cy:u.cy,r:a/2,stroke:"none",strokeWidth:0,fill:n.backColor,opacity:n.backOpacity},e._back=t.createCircle().applySettings(e._backDefault).data(f,e._data).append(i),e._dot=t.createCircle().applySettings(e._dotDefault).data(f,e._data).append(i)},_destroy:function(){this._back=this._dot=null},_applyDefault:function(){this._back.applySettings(this._backDefault),this._dot.applySettings(this._dotDefault)},_applyHovered:function(){this._back.applySettings(this._backHovered),this._dot.applySettings(this._dotHovered)},_applySelected:function(){this._back.applySettings(this._backSelected),this._dot.applySettings(this._dotSelected)}}),u(y.prototype,o,{type:"bubble",_create:function(n,t,i){var u=this;u._minSize=n.minSize>0?r(n.minSize):0,u._maxSize=n.maxSize>u._minSize?r(n.maxSize):u._minSize,u.value=h(u._src.item.value)?r(u._src.item.value):null,u._default={stroke:n.borderColor,strokeWidth:n.borderWidth,fill:n.color,opacity:n.opacity},u._hovered={stroke:n.hoveredBorderColor,strokeWidth:n.hoveredBorderWidth,fill:n.hoveredColor,opacity:n.hoveredOpacity},u._selected={stroke:n.selectedBorderColor,strokeWidth:n.selectedBorderWidth,fill:n.selectedColor,opacity:n.selectedOpacity},u._bubble=t.createCircle(0,0,n.maxSize/2).applySettings(u._default).data(f,u._data).append(i)},_destroy:function(){this._bubble=null},_applyDefault:function(){this._bubble.applySettings(this._default)},_applyHovered:function(){this._bubble.applySettings(this._hovered)},_applySelected:function(){this._bubble.applySettings(this._selected)},setSize:function(n){var t=this,i=s(0,0,t._minSize+n*(t._maxSize-t._minSize),t._default.strokeWidth);return t._default.cx=t._hovered.cx=t._selected.cx=i.cx,t._default.cy=t._hovered.cy=t._selected.cy=i.cy,t._default.r=t._hovered.r=t._selected.r=i.r,t._bubble.applySettings(i),t}}),u(p.prototype,o,{type:"pie",_create:function(t,i,u){var e=this,l=s(0,0,t.size>0?r(t.size):0,t.borderWidth);e._pieDefault={opacity:t.opacity},e._pieHovered={opacity:t.hoveredOpacity},e._pieSelected={opacity:t.selectedOpacity},e._borderDefault={stroke:t.borderColor,strokeWidth:t.borderWidth},e._borderHovered={stroke:t.hoveredBorderColor,strokeWidth:t.hoveredBorderWidth},e._borderSelected={stroke:t.selectedBorderColor,strokeWidth:t.selectedBorderWidth};for(var v=e._src.item.values,o=0,y=g(v)?v.length:0,a=[],c,w=0;o<y;++o)c=r(v[o]),h(c)&&(a.push(c),w+=c);e._pie=i.createGroup(e._pieDefault);var b=new n.viz.core.Translator1D(0,w,90,450),k=b.translate(0),p,d=e._ctx.getColors(a.length);for(c=0,o=0,y=a.length;o<y;++o)c+=a[o],p=b.translate(c),i.createArc(l.cx,l.cy,l.r,0,k,p,{fill:d[o]}).data(f,e._data).append(e._pie),k=p;e._pie.append(u),e._border=i.createCircle(l.cx,l.cy,l.r,e._borderDefault).data(f,e._data).append(u)},_destroy:function(){this._pie=this._border=null},_applyDefault:function(){this._pie.applySettings(this._pieDefault),this._border.applySettings(this._borderDefault)},_applyHovered:function(){this._pie.applySettings(this._pieHovered),this._border.applySettings(this._borderHovered)},_applySelected:function(){this._pie.applySettings(this._pieSelected),this._border.applySettings(this._borderSelected)}}),u(w.prototype,o,{type:"image",_create:function(n,t,i){var u=this,e=n.size>0?r(n.size):0,o=e+(n.hoveredStep>0?r(n.hoveredStep):0),s=e+(n.selectedStep>0?r(n.selectedStep):0);u._default={x:-e/2,y:-e/2,width:e,height:e},u._hovered={x:-o/2,y:-o/2,width:o,height:o},u._selected={x:-s/2,y:-s/2,width:s,height:s},u._image=t.createImage().applySettings(u._default).applySettings({href:u._src.item.url,location:"center"}).append(i),u._tracker=t.createRect().applySettings(u._default).applySettings(a).data(f,u._data).append(i)},_destroy:function(){this._image=this._tracker=null},_applyDefault:function(){this._image.applySettings(this._default),this._tracker.applySettings(this._default)},_applyHovered:function(){this._image.applySettings(this._hovered),this._tracker.applySettings(this._hovered)},_applySelected:function(){this._image.applySettings(this._selected),this._tracker.applySettings(this._selected)}}),e.dot=v,e.bubble=y,e.pie=p,e.image=w,n.viz.map.Map.prototype._factory.createMarkersManager=function(n){return new rt(n)}}(DevExpress,jQuery),DevExpress.MOD_VIZ_VECTORMAP=!0}