import { IAutoScalingGroup } from '@aws-cdk/aws-autoscaling';
import { IVpc, SubnetSelection, ISecurityGroup } from '@aws-cdk/aws-ec2';
import { IRole } from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/core';
/**
 * @experimental
 */
export interface GitlabRunnerAutoscalingProps {
    /**
     * (experimental) Gitlab token.
     *
     * @experimental
     * @example
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN' });
     */
    readonly gitlabToken: string;
    /**
     * (experimental) Runner default EC2 instance type.
     *
     * @default - t3.micro
     * @experimental
     * @example
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', instanceType: 't3.small' });
     */
    readonly instanceType?: string;
    /**
     * (experimental) VPC for the Gitlab Runner .
     *
     * @default - A new VPC will be created.
     * @experimental
     * @example
     *
     * const newVpc = new Vpc(stack, 'NewVPC', {
     *   cidr: '10.1.0.0/16',
     *   maxAzs: 2,
     *   subnetConfiguration: [{
     *     cidrMask: 26,
     *     name: 'RunnerVPC',
     *     subnetType: SubnetType.PUBLIC,
     *   }],
     *   natGateways: 0,
     * });
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', vpc: newVpc });
     */
    readonly vpc?: IVpc;
    /**
     * (experimental) IAM role for the Gitlab Runner Instance .
     *
     * @default - new Role for Gitlab Runner Instance , attach AmazonSSMManagedInstanceCore Policy .
     * @experimental
     * @example
     *
     * const role = new Role(stack, 'runner-role', {
     *   assumedBy: new ServicePrincipal('ec2.amazonaws.com'),
     *   description: 'For Gitlab Runner Test Role',
     *   roleName: 'Runner-Role',
     * });
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', instanceRole: role });
     */
    readonly instanceRole?: IRole;
    /**
     * (experimental) The maximum hourly price (in USD) to be paid for any Spot Instance launched to fulfill the request.
     *
     * Spot Instances are launched when the price you specify exceeds the current Spot market price.
     *
     * @default - undefined
     * @experimental
     * @example
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', spotPrice: 1.23 });
     */
    readonly spotPrice?: string;
    /**
     * (experimental) Minimum capacity limit for autoscaling group.
     *
     * @default - minCapacity: 1
     * @experimental
     * @example
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', minCapacity: 2 });
     */
    readonly minCapacity?: number;
    /**
     * (experimental) Maximum capacity limit for autoscaling group.
     *
     * @default - desiredCapacity
     * @experimental
     * @example
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', maxCapacity: 4 });
     */
    readonly maxCapacity?: number;
    /**
     * (experimental) Desired capacity limit for autoscaling group.
     *
     * @default - minCapacity, and leave unchanged during deployment
     * @experimental
     * @example
     *
     * new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', desiredCapacity: 2 });
     */
    readonly desiredCapacity?: number;
    /**
     * (experimental) tags for the runner.
     *
     * @default - ['runner', 'gitlab', 'awscdk']
     * @experimental
     */
    readonly tags?: string[];
    /**
     * (experimental) Gitlab Runner register url .
     *
     * @default - https://gitlab.com/ , The trailing slash is mandatory.
     * @experimental
     * @example
     *
     * const runner = new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN',gitlabUrl: 'https://gitlab.com/'});
     */
    readonly gitlabUrl?: string;
    /**
     * (experimental) Gitlab Runner instance EBS size .
     *
     * @default - ebsSize=60
     * @experimental
     * @example
     *
     * const runner = new GitlabRunnerAutoscaling(stack, 'runner', { gitlabToken: 'GITLAB_TOKEN', ebsSize: 100});
     */
    readonly ebsSize?: number;
    /**
     * (experimental) VPC subnet.
     *
     * @default - private subnet
     * @experimental
     * @example
     *
     * const vpc = new Vpc(stack, 'nat', {
     * natGateways: 1,
     * maxAzs: 2,
     * });
     * const runner = new GitlabRunnerAutoscaling(stack, 'testing', {
     *   gitlabToken: 'GITLAB_TOKEN',
     *   instanceType: 't3.large',
     *   instanceRole: role,
     *   ebsSize: 100,
     *   vpc: vpc,
     *   vpcSubnet: {
     *     subnetType: SubnetType.PUBLIC,
     *   },
     * });
     */
    readonly vpcSubnet?: SubnetSelection;
}
/**
 * @experimental
 */
export declare class GitlabRunnerAutoscaling extends Construct {
    /**
     * (experimental) The IAM role assumed by the Runner instance.
     *
     * @experimental
     */
    readonly instanceRole: IRole;
    /**
     * (experimental) This represents a Runner Auto Scaling Group.
     *
     * @experimental
     */
    readonly autoscalingGroup: IAutoScalingGroup;
    /**
     * (experimental) The EC2 runner's VPC.
     *
     * @experimental
     */
    readonly vpc: IVpc;
    /**
     * (experimental) The EC2 runner's default SecurityGroup.
     *
     * @experimental
     */
    readonly securityGroup: ISecurityGroup;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: GitlabRunnerAutoscalingProps);
}
