# AUTOGENERATED, DO NOT EDIT!
# This file was generated by /tools/generate_central_schema.sh
# Visit https://gitlab.memri.io/memri/schema to learn more

from datetime import datetime
from typing import Any, Optional, Union

from pymemri.data.itembase import EdgeList, Item


class Account(Item):
    description = """An account or subscription, for instance for some online service, or a bank account or wallet."""
    properties = Item.properties + [
        "avatarUrl",
        "authEmail",
        "code",
        "displayName",
        "externalId",
        "handle",
        "identifier",
        "isMe",
        "itemType",
        "secret",
        "service",
        "accessToken",
        "refreshToken",
    ]
    edges = Item.edges + [
        "changelog",
        "cryptoTransaction",
        "location",
        "network",
        "ownCurrency",
        "owner",
        "trust",
        "profilePicture",
    ]

    def __init__(
        self,
        avatarUrl: str = None,
        authEmail: str = None,
        code: str = None,
        displayName: str = None,
        externalId: str = None,
        handle: str = None,
        identifier: str = None,
        isMe: bool = None,
        itemType: str = None,
        secret: str = None,
        service: str = None,
        accessToken: str = None,
        refreshToken: str = None,
        changelog: EdgeList["AuditItem"] = None,
        cryptoTransaction: EdgeList["CryptoTransaction"] = None,
        location: EdgeList["Location"] = None,
        network: EdgeList["Network"] = None,
        ownCurrency: EdgeList["CryptoCurrency"] = None,
        owner: EdgeList["Person"] = None,
        trust: EdgeList["Account"] = None,
        profilePicture: EdgeList["Photo"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.avatarUrl: Optional[str] = avatarUrl
        self.authEmail: Optional[str] = authEmail
        self.code: Optional[str] = code
        self.displayName: Optional[str] = displayName
        self.externalId: Optional[str] = externalId
        self.handle: Optional[str] = handle
        self.identifier: Optional[str] = identifier
        self.isMe: Optional[bool] = isMe
        self.itemType: Optional[str] = itemType
        self.secret: Optional[str] = secret
        self.service: Optional[str] = service
        self.accessToken: Optional[str] = accessToken
        self.refreshToken: Optional[str] = refreshToken

        # Edges
        self.changelog: EdgeList["AuditItem"] = EdgeList("changelog", "AuditItem", changelog)
        self.cryptoTransaction: EdgeList["CryptoTransaction"] = EdgeList(
            "cryptoTransaction", "CryptoTransaction", cryptoTransaction
        )
        self.location: EdgeList["Location"] = EdgeList("location", "Location", location)
        self.network: EdgeList["Network"] = EdgeList("network", "Network", network)
        self.ownCurrency: EdgeList["CryptoCurrency"] = EdgeList(
            "ownCurrency", "CryptoCurrency", ownCurrency
        )
        self.owner: EdgeList["Person"] = EdgeList("owner", "Person", owner)
        self.trust: EdgeList["Account"] = EdgeList("trust", "Account", trust)
        self.profilePicture: EdgeList["Photo"] = EdgeList("profilePicture", "Photo", profilePicture)


class AuditItem(Item):
    description = """TBD"""
    properties = Item.properties + ["actionname", "content", "date"]
    edges = Item.edges + []

    def __init__(
        self, actionname: str = None, content: str = None, date: datetime = None, **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.actionname: Optional[str] = actionname
        self.content: Optional[str] = content
        self.date: Optional[datetime] = date


class CVUStoredDefinition(Item):
    description = """TBD"""
    properties = Item.properties + [
        "definition",
        "domain",
        "itemType",
        "name",
        "queryStr",
        "renderer",
        "selector",
        "definitionType",
    ]
    edges = Item.edges + []

    def __init__(
        self,
        definition: str = None,
        domain: str = None,
        itemType: str = None,
        name: str = None,
        queryStr: str = None,
        renderer: str = None,
        selector: str = None,
        definitionType: str = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.definition: Optional[str] = definition
        self.domain: Optional[str] = domain
        self.itemType: Optional[str] = itemType
        self.name: Optional[str] = name
        self.queryStr: Optional[str] = queryStr
        self.renderer: Optional[str] = renderer
        self.selector: Optional[str] = selector
        self.definitionType: Optional[str] = definitionType


class CategoricalPrediction(Item):
    description = """"""
    properties = Item.properties + ["source", "value", "probs"]
    edges = Item.edges + ["model"]

    def __init__(
        self,
        source: str = None,
        value: str = None,
        probs: str = None,
        model: EdgeList["Model"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.source: Optional[str] = source
        self.value: Optional[str] = value
        self.probs: Optional[str] = probs

        # Edges
        self.model: EdgeList["Model"] = EdgeList("model", "Model", model)


class CreativeWork(Item):
    description = """The most generic kind of creative work, including books, movies, photographs, software programs, etc."""
    properties = Item.properties + [
        "abstract",
        "content",
        "datePublished",
        "itemType",
        "keyword",
        "textContent",
        "title",
        "transcript",
    ]
    edges = Item.edges + ["contentLocation", "file", "locationCreated", "writtenBy"]

    def __init__(
        self,
        abstract: str = None,
        content: str = None,
        datePublished: datetime = None,
        itemType: str = None,
        keyword: str = None,
        textContent: str = None,
        title: str = None,
        transcript: str = None,
        contentLocation: EdgeList["Location"] = None,
        file: EdgeList["File"] = None,
        locationCreated: EdgeList["Location"] = None,
        writtenBy: EdgeList["Person"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.abstract: Optional[str] = abstract
        self.content: Optional[str] = content
        self.datePublished: Optional[datetime] = datePublished
        self.itemType: Optional[str] = itemType
        self.keyword: Optional[str] = keyword
        self.textContent: Optional[str] = textContent
        self.title: Optional[str] = title
        self.transcript: Optional[str] = transcript

        # Edges
        self.contentLocation: EdgeList["Location"] = EdgeList(
            "contentLocation", "Location", contentLocation
        )
        self.file: EdgeList["File"] = EdgeList("file", "File", file)
        self.locationCreated: EdgeList["Location"] = EdgeList(
            "locationCreated", "Location", locationCreated
        )
        self.writtenBy: EdgeList["Person"] = EdgeList("writtenBy", "Person", writtenBy)


class CryptoCurrency(Item):
    description = """"""
    properties = Item.properties + ["myToken", "name", "topic"]
    edges = Item.edges + ["currencySetting", "picture"]

    def __init__(
        self,
        myToken: float = None,
        name: str = None,
        topic: str = None,
        currencySetting: EdgeList["CurrencySetting"] = None,
        picture: EdgeList["Photo"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.myToken: Optional[float] = myToken
        self.name: Optional[str] = name
        self.topic: Optional[str] = topic

        # Edges
        self.currencySetting: EdgeList["CurrencySetting"] = EdgeList(
            "currencySetting", "CurrencySetting", currencySetting
        )
        self.picture: EdgeList["Photo"] = EdgeList("picture", "Photo", picture)


class CryptoKey(Item):
    description = """A key used in an cryptography protocol."""
    properties = Item.properties + [
        "active",
        "itemType",
        "keystr",
        "name",
        "role",
        "starred",
    ]
    edges = Item.edges + ["owner"]

    def __init__(
        self,
        active: bool = None,
        itemType: str = None,
        keystr: str = None,
        name: str = None,
        role: str = None,
        starred: bool = None,
        owner: EdgeList["Person"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.active: Optional[bool] = active
        self.itemType: Optional[str] = itemType
        self.keystr: Optional[str] = keystr
        self.name: Optional[str] = name
        self.role: Optional[str] = role
        self.starred: Optional[bool] = starred

        # Edges
        self.owner: EdgeList["Person"] = EdgeList("owner", "Person", owner)


class CryptoTransaction(Item):
    description = """"""
    properties = Item.properties + ["outward", "quantity"]
    edges = Item.edges + ["cryptoCurrency", "relateToOther", "relateToOwner"]

    def __init__(
        self,
        outward: bool = None,
        quantity: float = None,
        cryptoCurrency: EdgeList["CryptoCurrency"] = None,
        relateToOther: EdgeList["Account"] = None,
        relateToOwner: EdgeList["Account"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.outward: Optional[bool] = outward
        self.quantity: Optional[float] = quantity

        # Edges
        self.cryptoCurrency: EdgeList["CryptoCurrency"] = EdgeList(
            "cryptoCurrency", "CryptoCurrency", cryptoCurrency
        )
        self.relateToOther: EdgeList["Account"] = EdgeList(
            "relateToOther", "Account", relateToOther
        )
        self.relateToOwner: EdgeList["Account"] = EdgeList(
            "relateToOwner", "Account", relateToOwner
        )


class CurrencySetting(Item):
    description = """"""
    properties = Item.properties + [
        "deviceAddress",
        "profileAddress",
        "seedPhrase",
        "tokenAddress",
    ]
    edges = Item.edges + ["wallet"]

    def __init__(
        self,
        deviceAddress: str = None,
        profileAddress: str = None,
        seedPhrase: str = None,
        tokenAddress: str = None,
        wallet: EdgeList["Wallet"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.deviceAddress: Optional[str] = deviceAddress
        self.profileAddress: Optional[str] = profileAddress
        self.seedPhrase: Optional[str] = seedPhrase
        self.tokenAddress: Optional[str] = tokenAddress

        # Edges
        self.wallet: EdgeList["Wallet"] = EdgeList("wallet", "Wallet", wallet)


class Dataset(Item):
    description = """A Dataset of items."""
    properties = Item.properties + ["name", "queryStr"]
    edges = Item.edges + ["entry", "feature", "labellingTask", "datasetType"]

    def __init__(
        self,
        name: str = None,
        queryStr: str = None,
        entry: EdgeList["DatasetEntry"] = None,
        feature: EdgeList["ItemPropertySchema"] = None,
        labellingTask: EdgeList["LabellingTask"] = None,
        datasetType: EdgeList["DatasetType"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.name: Optional[str] = name
        self.queryStr: Optional[str] = queryStr

        # Edges
        self.entry: EdgeList["DatasetEntry"] = EdgeList("entry", "DatasetEntry", entry)
        self.feature: EdgeList["ItemPropertySchema"] = EdgeList(
            "feature", "ItemPropertySchema", feature
        )
        self.labellingTask: EdgeList["LabellingTask"] = EdgeList(
            "labellingTask", "LabellingTask", labellingTask
        )
        self.datasetType: EdgeList["DatasetType"] = EdgeList(
            "datasetType", "DatasetType", datasetType
        )


class DatasetEntry(Item):
    description = """Entry item of dataset."""
    properties = Item.properties + ["skippedByLabeller"]
    edges = Item.edges + ["data", "annotation"]

    def __init__(
        self,
        skippedByLabeller: bool = None,
        data: EdgeList[Union["Message", "Tweet", "EmailMessage"]] = None,
        annotation: EdgeList["CategoricalLabel"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.skippedByLabeller: Optional[bool] = skippedByLabeller

        # Edges
        self.data: EdgeList[Union["Message", "Tweet", "EmailMessage"]] = EdgeList(
            "data", Union["Message", "Tweet", "EmailMessage"], data
        )
        self.annotation: EdgeList["CategoricalLabel"] = EdgeList(
            "annotation", "CategoricalLabel", annotation
        )


class DatasetType(Item):
    description = """Fixed dictionary for datasets."""
    properties = Item.properties + ["name", "queryStr"]
    edges = Item.edges + ["datasetPlugin"]

    def __init__(
        self,
        name: str = None,
        queryStr: str = None,
        datasetPlugin: EdgeList["Plugin"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.name: Optional[str] = name
        self.queryStr: Optional[str] = queryStr

        # Edges
        self.datasetPlugin: EdgeList["Plugin"] = EdgeList("datasetPlugin", "Plugin", datasetPlugin)


class Diet(Item):
    description = """A strategy of regulating the intake of food to achieve or maintain a specific health-related goal."""
    properties = Item.properties + [
        "abstract",
        "content",
        "datePublished",
        "duration",
        "itemType",
        "keyword",
        "name",
        "textContent",
        "title",
        "transcript",
    ]
    edges = Item.edges + ["contentLocation", "file", "locationCreated", "writtenBy"]

    def __init__(
        self,
        abstract: str = None,
        content: str = None,
        datePublished: datetime = None,
        duration: int = None,
        itemType: str = None,
        keyword: str = None,
        name: str = None,
        textContent: str = None,
        title: str = None,
        transcript: str = None,
        contentLocation: EdgeList["Location"] = None,
        file: EdgeList["File"] = None,
        locationCreated: EdgeList["Location"] = None,
        writtenBy: EdgeList["Person"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.abstract: Optional[str] = abstract
        self.content: Optional[str] = content
        self.datePublished: Optional[datetime] = datePublished
        self.duration: Optional[int] = duration
        self.itemType: Optional[str] = itemType
        self.keyword: Optional[str] = keyword
        self.name: Optional[str] = name
        self.textContent: Optional[str] = textContent
        self.title: Optional[str] = title
        self.transcript: Optional[str] = transcript

        # Edges
        self.contentLocation: EdgeList["Location"] = EdgeList(
            "contentLocation", "Location", contentLocation
        )
        self.file: EdgeList["File"] = EdgeList("file", "File", file)
        self.locationCreated: EdgeList["Location"] = EdgeList(
            "locationCreated", "Location", locationCreated
        )
        self.writtenBy: EdgeList["Person"] = EdgeList("writtenBy", "Person", writtenBy)


class File(Item):
    description = """Any file that can be stored on disk."""
    properties = Item.properties + ["filename", "keystr", "nonce", "sha256", "starred"]
    edges = Item.edges + []

    def __init__(
        self,
        filename: str = None,
        keystr: str = None,
        nonce: str = None,
        sha256: str = None,
        starred: bool = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.filename: Optional[str] = filename
        self.keystr: Optional[str] = keystr
        self.nonce: Optional[str] = nonce
        self.sha256: Optional[str] = sha256
        self.starred: Optional[bool] = starred


class Integrator(Item):
    description = """An integrator operates on your database enhances your personal data by inferring facts over existing data and adding those to the database."""
    properties = Item.properties + ["name", "repository"]
    edges = Item.edges + []

    def __init__(self, name: str = None, repository: str = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.name: Optional[str] = name
        self.repository: Optional[str] = repository


class ItemEdgeSchema(Item):
    description = """"""
    properties = Item.properties + ["edgeName", "sourceType", "targetType"]
    edges = Item.edges + []

    def __init__(
        self, edgeName: str = None, sourceType: str = None, targetType: str = None, **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.edgeName: Optional[str] = edgeName
        self.sourceType: Optional[str] = sourceType
        self.targetType: Optional[str] = targetType


class ItemPropertySchema(Item):
    description = """"""
    properties = Item.properties + ["itemType", "propertyName", "valueType"]
    edges = Item.edges + []

    def __init__(
        self, itemType: str = None, propertyName: str = None, valueType: str = None, **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.itemType: Optional[str] = itemType
        self.propertyName: Optional[str] = propertyName
        self.valueType: Optional[str] = valueType


class Label(Item):
    description = """Attached to an Item, to mark it to be something."""
    properties = Item.properties + ["color", "name"]
    edges = Item.edges + []

    def __init__(self, color: str = None, name: str = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.color: Optional[str] = color
        self.name: Optional[str] = name


class LabelAnnotation(Item):
    description = """"""
    properties = Item.properties + ["allowSharing", "isSubmitted"]
    edges = Item.edges + []

    def __init__(self, allowSharing: bool = None, isSubmitted: bool = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.allowSharing: Optional[bool] = allowSharing
        self.isSubmitted: Optional[bool] = isSubmitted


class LabelOption(Item):
    description = """Attached to an Item, to mark it to be something."""
    properties = Item.properties + ["color", "name"]
    edges = Item.edges + []

    def __init__(self, color: str = None, name: str = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.color: Optional[str] = color
        self.name: Optional[str] = name


class LabellingDataType(Item):
    description = """A labelling data type definition."""
    properties = Item.properties + ["name", "labelType"]
    edges = Item.edges + []

    def __init__(self, name: str = None, labelType: str = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.name: Optional[str] = name
        self.labelType: Optional[str] = labelType


class LabellingTask(Item):
    description = """A labelling task definition."""
    properties = Item.properties + ["name", "currentLabelOption"]
    edges = Item.edges + ["taskType", "labelOption", "view"]

    def __init__(
        self,
        name: str = None,
        currentLabelOption: str = None,
        taskType: EdgeList["TextClassification"] = None,
        labelOption: EdgeList["LabelOption"] = None,
        view: EdgeList["CVUStoredDefinition"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.name: Optional[str] = name
        self.currentLabelOption: Optional[str] = currentLabelOption

        # Edges
        self.taskType: EdgeList["TextClassification"] = EdgeList(
            "taskType", "TextClassification", taskType
        )
        self.labelOption: EdgeList["LabelOption"] = EdgeList(
            "labelOption", "LabelOption", labelOption
        )
        self.view: EdgeList["CVUStoredDefinition"] = EdgeList("view", "CVUStoredDefinition", view)


class Location(Item):
    description = """The location of something."""
    properties = Item.properties + ["latitude", "longitude"]
    edges = Item.edges + []

    def __init__(self, latitude: float = None, longitude: float = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.latitude: Optional[float] = latitude
        self.longitude: Optional[float] = longitude


class MediaObject(Item):
    description = """A media object, such as an image, video, or audio object embedded in a web page or a downloadable dataset i.e. DataDownload. Note that a creative work may have many media objects associated with it on the same web page. For example, a page about a single song (MusicRecording) may have a music video (VideoObject), and a high and low bandwidth audio stream (2 AudioObject's)."""
    properties = Item.properties + [
        "bitrate",
        "duration",
        "endTime",
        "fileLocation",
        "startTime",
    ]
    edges = Item.edges + ["file", "includes"]

    def __init__(
        self,
        bitrate: int = None,
        duration: int = None,
        endTime: datetime = None,
        fileLocation: str = None,
        startTime: datetime = None,
        file: EdgeList["File"] = None,
        includes: EdgeList["Person"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.bitrate: Optional[int] = bitrate
        self.duration: Optional[int] = duration
        self.endTime: Optional[datetime] = endTime
        self.fileLocation: Optional[str] = fileLocation
        self.startTime: Optional[datetime] = startTime

        # Edges
        self.file: EdgeList["File"] = EdgeList("file", "File", file)
        self.includes: EdgeList["Person"] = EdgeList("includes", "Person", includes)


class MedicalCondition(Item):
    description = """Any condition of the human body that affects the normal functioning of a person, whether physically or mentally. Includes diseases, injuries, disabilities, disorders, syndromes, etc."""
    properties = Item.properties + ["conditiontype", "itemType", "name"]
    edges = Item.edges + []

    def __init__(self, conditiontype: str = None, itemType: str = None, name: str = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.conditiontype: Optional[str] = conditiontype
        self.itemType: Optional[str] = itemType
        self.name: Optional[str] = name


class MessageChannel(Item):
    description = """A chat is a collection of messages."""
    properties = Item.properties + ["encrypted", "externalId", "name", "topic"]
    edges = Item.edges + ["photo", "receiver"]

    def __init__(
        self,
        encrypted: bool = None,
        externalId: str = None,
        name: str = None,
        topic: str = None,
        photo: EdgeList["Photo"] = None,
        receiver: EdgeList["Account"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.encrypted: Optional[bool] = encrypted
        self.externalId: Optional[str] = externalId
        self.name: Optional[str] = name
        self.topic: Optional[str] = topic

        # Edges
        self.photo: EdgeList["Photo"] = EdgeList("photo", "Photo", photo)
        self.receiver: EdgeList["Account"] = EdgeList("receiver", "Account", receiver)


class Model(Item):
    description = """A Machine learning model"""
    properties = Item.properties + ["name", "version"]
    edges = Item.edges + []

    def __init__(self, name: str = None, version: str = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.name: Optional[str] = name
        self.version: Optional[str] = version


class NavigationItem(Item):
    description = """TBD"""
    properties = Item.properties + [
        "icon",
        "itemType",
        "sequence",
        "sessionName",
        "title",
    ]
    edges = Item.edges + []

    def __init__(
        self,
        icon: str = None,
        itemType: str = None,
        sequence: int = None,
        sessionName: str = None,
        title: str = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.icon: Optional[str] = icon
        self.itemType: Optional[str] = itemType
        self.sequence: Optional[int] = sequence
        self.sessionName: Optional[str] = sessionName
        self.title: Optional[str] = title


class Network(Item):
    description = (
        """A group or system of interconnected people or things, for instance a social network."""
    )
    properties = Item.properties + ["name"]
    edges = Item.edges + ["website"]

    def __init__(self, name: str = None, website: EdgeList["Website"] = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.name: Optional[str] = name

        # Edges
        self.website: EdgeList["Website"] = EdgeList("website", "Website", website)


class OauthFlow(Item):
    description = """"""
    properties = Item.properties + [
        "accessToken",
        "accessTokenSecret",
        "refreshToken",
        "service",
    ]
    edges = Item.edges + []

    def __init__(
        self,
        accessToken: str = None,
        accessTokenSecret: str = None,
        refreshToken: str = None,
        service: str = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.accessToken: Optional[str] = accessToken
        self.accessTokenSecret: Optional[str] = accessTokenSecret
        self.refreshToken: Optional[str] = refreshToken
        self.service: Optional[str] = service


class Person(Item):
    description = """A person (alive, dead, undead, or fictional)."""
    properties = Item.properties + [
        "addressBookId",
        "birthDate",
        "deathDate",
        "displayName",
        "email",
        "firstName",
        "gender",
        "lastName",
        "role",
        "sexualOrientation",
        "starred",
    ]
    edges = Item.edges + [
        "account",
        "address",
        "birthPlace",
        "cryptoKey",
        "deathPlace",
        "diet",
        "hasPhoneNumber",
        "label",
        "me",
        "medicalCondition",
        "mergedFrom",
        "profilePicture",
        "relationship",
        "website",
    ]

    def __init__(
        self,
        addressBookId: str = None,
        birthDate: datetime = None,
        deathDate: datetime = None,
        displayName: str = None,
        email: str = None,
        firstName: str = None,
        gender: str = None,
        lastName: str = None,
        role: str = None,
        sexualOrientation: str = None,
        starred: bool = None,
        account: EdgeList["Account"] = None,
        address: EdgeList["Address"] = None,
        birthPlace: EdgeList["Location"] = None,
        cryptoKey: EdgeList["CryptoKey"] = None,
        deathPlace: EdgeList["Location"] = None,
        diet: EdgeList["Diet"] = None,
        hasPhoneNumber: EdgeList["PhoneNumber"] = None,
        label: EdgeList["Label"] = None,
        me: EdgeList["Person"] = None,
        medicalCondition: EdgeList["MedicalCondition"] = None,
        mergedFrom: EdgeList["Person"] = None,
        profilePicture: EdgeList["Photo"] = None,
        relationship: EdgeList["Relationship"] = None,
        website: EdgeList["Website"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.addressBookId: Optional[str] = addressBookId
        self.birthDate: Optional[datetime] = birthDate
        self.deathDate: Optional[datetime] = deathDate
        self.displayName: Optional[str] = displayName
        self.email: Optional[str] = email
        self.firstName: Optional[str] = firstName
        self.gender: Optional[str] = gender
        self.lastName: Optional[str] = lastName
        self.role: Optional[str] = role
        self.sexualOrientation: Optional[str] = sexualOrientation
        self.starred: Optional[bool] = starred

        # Edges
        self.account: EdgeList["Account"] = EdgeList("account", "Account", account)
        self.address: EdgeList["Address"] = EdgeList("address", "Address", address)
        self.birthPlace: EdgeList["Location"] = EdgeList("birthPlace", "Location", birthPlace)
        self.cryptoKey: EdgeList["CryptoKey"] = EdgeList("cryptoKey", "CryptoKey", cryptoKey)
        self.deathPlace: EdgeList["Location"] = EdgeList("deathPlace", "Location", deathPlace)
        self.diet: EdgeList["Diet"] = EdgeList("diet", "Diet", diet)
        self.hasPhoneNumber: EdgeList["PhoneNumber"] = EdgeList(
            "hasPhoneNumber", "PhoneNumber", hasPhoneNumber
        )
        self.label: EdgeList["Label"] = EdgeList("label", "Label", label)
        self.me: EdgeList["Person"] = EdgeList("me", "Person", me)
        self.medicalCondition: EdgeList["MedicalCondition"] = EdgeList(
            "medicalCondition", "MedicalCondition", medicalCondition
        )
        self.mergedFrom: EdgeList["Person"] = EdgeList("mergedFrom", "Person", mergedFrom)
        self.profilePicture: EdgeList["Photo"] = EdgeList("profilePicture", "Photo", profilePicture)
        self.relationship: EdgeList["Relationship"] = EdgeList(
            "relationship", "Relationship", relationship
        )
        self.website: EdgeList["Website"] = EdgeList("website", "Website", website)


class PhoneNumber(Item):
    description = """A telephone number, SIP Address."""
    properties = Item.properties + ["phoneNumber"]
    edges = Item.edges + []

    def __init__(self, phoneNumber: str = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.phoneNumber: Optional[str] = phoneNumber


class Plugin(Item):
    description = """Information about a Plugin"""
    properties = Item.properties + [
        "bundleImage",
        "containerImage",
        "configJson",
        "config",
        "dataType",
        "icon",
        "pluginDescription",
        "name",
        "pluginModule",
        "pluginName",
        "pluginType",
        "gitProjectId",
    ]
    edges = Item.edges + ["view"]

    def __init__(
        self,
        bundleImage: str = None,
        containerImage: str = None,
        configJson: str = None,
        config: str = None,
        dataType: str = None,
        icon: str = None,
        pluginDescription: str = None,
        name: str = None,
        pluginModule: str = None,
        pluginName: str = None,
        pluginType: str = None,
        gitProjectId: int = None,
        view: EdgeList["CVUStoredDefinition"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.bundleImage: Optional[str] = bundleImage
        self.containerImage: Optional[str] = containerImage
        self.configJson: Optional[str] = configJson
        self.config: Optional[str] = config
        self.dataType: Optional[str] = dataType
        self.icon: Optional[str] = icon
        self.pluginDescription: Optional[str] = pluginDescription
        self.name: Optional[str] = name
        self.pluginModule: Optional[str] = pluginModule
        self.pluginName: Optional[str] = pluginName
        self.pluginType: Optional[str] = pluginType
        self.gitProjectId: Optional[int] = gitProjectId

        # Edges
        self.view: EdgeList["CVUStoredDefinition"] = EdgeList("view", "CVUStoredDefinition", view)


class Post(Item):
    description = """Post from social media"""
    properties = Item.properties + [
        "externalId",
        "message",
        "postDate",
        "postType",
        "isMock",
    ]
    edges = Item.edges + ["author", "comment", "parent", "photo"]

    def __init__(
        self,
        externalId: str = None,
        message: str = None,
        postDate: datetime = None,
        postType: str = None,
        isMock: bool = None,
        author: EdgeList["Account"] = None,
        comment: EdgeList["Post"] = None,
        parent: EdgeList["Post"] = None,
        photo: EdgeList["Photo"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.externalId: Optional[str] = externalId
        self.message: Optional[str] = message
        self.postDate: Optional[datetime] = postDate
        self.postType: Optional[str] = postType
        self.isMock: Optional[bool] = isMock

        # Edges
        self.author: EdgeList["Account"] = EdgeList("author", "Account", author)
        self.comment: EdgeList["Post"] = EdgeList("comment", "Post", comment)
        self.parent: EdgeList["Post"] = EdgeList("parent", "Post", parent)
        self.photo: EdgeList["Photo"] = EdgeList("photo", "Photo", photo)


class Project(Item):
    description = """Labelling project"""
    properties = Item.properties + ["name", "gitlabUrl"]
    edges = Item.edges + ["dataset", "labellingPlugin"]

    def __init__(
        self,
        name: str = None,
        gitlabUrl: str = None,
        dataset: EdgeList["Dataset"] = None,
        labellingPlugin: EdgeList["Plugin"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.name: Optional[str] = name
        self.gitlabUrl: Optional[str] = gitlabUrl

        # Edges
        self.dataset: EdgeList["Dataset"] = EdgeList("dataset", "Dataset", dataset)
        self.labellingPlugin: EdgeList["Plugin"] = EdgeList(
            "labellingPlugin", "Plugin", labellingPlugin
        )


class Receipt(Item):
    description = """A bill that describes money owed for some Transaction."""
    properties = Item.properties + ["category", "store", "totalCost"]
    edges = Item.edges + ["file", "photo"]

    def __init__(
        self,
        category: str = None,
        store: str = None,
        totalCost: float = None,
        file: EdgeList["File"] = None,
        photo: EdgeList["Photo"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.category: Optional[str] = category
        self.store: Optional[str] = store
        self.totalCost: Optional[float] = totalCost

        # Edges
        self.file: EdgeList["File"] = EdgeList("file", "File", file)
        self.photo: EdgeList["Photo"] = EdgeList("photo", "Photo", photo)


class Relationship(Item):
    description = """Relation of people, that indicates type of relationship and its value"""
    properties = Item.properties + ["label", "proximityValue"]
    edges = Item.edges + ["relationship"]

    def __init__(
        self,
        label: str = None,
        proximityValue: int = None,
        relationship: EdgeList["Person"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.label: Optional[str] = label
        self.proximityValue: Optional[int] = proximityValue

        # Edges
        self.relationship: EdgeList["Person"] = EdgeList("relationship", "Person", relationship)


class Setting(Item):
    description = """A setting, named by a key, specifications in JSON format."""
    properties = Item.properties + ["json", "keystr"]
    edges = Item.edges + []

    def __init__(self, json: str = None, keystr: str = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.json: Optional[str] = json
        self.keystr: Optional[str] = keystr


class SuggestedMerge(Item):
    description = """Describes a suggestion to merge two or more items"""
    properties = Item.properties + ["score", "task"]
    edges = Item.edges + ["mergeFrom"]

    def __init__(
        self, score: float = None, task: str = None, mergeFrom: EdgeList["Person"] = None, **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.score: Optional[float] = score
        self.task: Optional[str] = task

        # Edges
        self.mergeFrom: EdgeList["Person"] = EdgeList("mergeFrom", "Person", mergeFrom)


class VoteAction(Item):
    description = """The act casting a vote."""
    properties = Item.properties + ["dateExecuted"]
    edges = Item.edges + []

    def __init__(self, dateExecuted: datetime = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.dateExecuted: Optional[datetime] = dateExecuted


class Wallet(Item):
    description = """"""
    properties = Item.properties + ["name"]
    edges = Item.edges + ["picture"]

    def __init__(self, name: str = None, picture: EdgeList["Photo"] = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.name: Optional[str] = name

        # Edges
        self.picture: EdgeList["Photo"] = EdgeList("picture", "Photo", picture)


class Website(Item):
    description = """A Website is a set of related web pages and other items typically served from a single web domain and accessible via URLs."""
    properties = Item.properties + ["itemType", "url"]
    edges = Item.edges + []

    def __init__(self, itemType: str = None, url: str = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.itemType: Optional[str] = itemType
        self.url: Optional[str] = url


class WrittenWork(CreativeWork):
    description = (
        """A written work, for instance a book, article or note. Doesn't have to be published."""
    )
    properties = CreativeWork.properties + []
    edges = CreativeWork.edges + []

    def __init__(self, **kwargs):
        super().__init__(**kwargs)


class Indexer(Integrator):
    description = """An indexer enhances your personal data by inferring facts over existing data and adding those to the database."""
    properties = Integrator.properties + [
        "bundleImage",
        "icon",
        "indexerClass",
        "itemDescription",
        "queryStr",
        "runDestination",
    ]
    edges = Integrator.edges + ["indexerRun"]

    def __init__(
        self,
        bundleImage: str = None,
        icon: str = None,
        indexerClass: str = None,
        itemDescription: str = None,
        queryStr: str = None,
        runDestination: str = None,
        indexerRun: EdgeList["IndexerRun"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.bundleImage: Optional[str] = bundleImage
        self.icon: Optional[str] = icon
        self.indexerClass: Optional[str] = indexerClass
        self.itemDescription: Optional[str] = itemDescription
        self.queryStr: Optional[str] = queryStr
        self.runDestination: Optional[str] = runDestination

        # Edges
        self.indexerRun: EdgeList["IndexerRun"] = EdgeList("indexerRun", "IndexerRun", indexerRun)


class IndexerRun(Integrator):
    description = """A run of a certain Indexer."""
    properties = Integrator.properties + [
        "errorMessage",
        "progress",
        "progressMessage",
        "queryStr",
        "runStatus",
        "targetDataType",
    ]
    edges = Integrator.edges + ["indexer"]

    def __init__(
        self,
        errorMessage: str = None,
        progress: float = None,
        progressMessage: str = None,
        queryStr: str = None,
        runStatus: str = None,
        targetDataType: str = None,
        indexer: EdgeList["Indexer"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.errorMessage: Optional[str] = errorMessage
        self.progress: Optional[float] = progress
        self.progressMessage: Optional[str] = progressMessage
        self.queryStr: Optional[str] = queryStr
        self.runStatus: Optional[str] = runStatus
        self.targetDataType: Optional[str] = targetDataType

        # Edges
        self.indexer: EdgeList["Indexer"] = EdgeList("indexer", "Indexer", indexer)


class CategoricalLabel(LabelAnnotation):
    description = """"""
    properties = LabelAnnotation.properties + ["labelValue"]
    edges = LabelAnnotation.edges + []

    def __init__(self, labelValue: str = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.labelValue: Optional[str] = labelValue


class TextClassification(LabellingDataType):
    description = """Text classification option"""
    properties = LabellingDataType.properties + []
    edges = LabellingDataType.edges + []

    def __init__(self, **kwargs):
        super().__init__(**kwargs)


class Address(Location):
    description = """A postal address."""
    properties = Location.properties + [
        "city",
        "itemType",
        "locationAutoLookupHash",
        "postalCode",
        "state",
        "street",
    ]
    edges = Location.edges + ["changelog", "country", "location"]

    def __init__(
        self,
        city: str = None,
        itemType: str = None,
        locationAutoLookupHash: str = None,
        postalCode: str = None,
        state: str = None,
        street: str = None,
        changelog: EdgeList["AuditItem"] = None,
        country: EdgeList["Country"] = None,
        location: EdgeList["Location"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.city: Optional[str] = city
        self.itemType: Optional[str] = itemType
        self.locationAutoLookupHash: Optional[str] = locationAutoLookupHash
        self.postalCode: Optional[str] = postalCode
        self.state: Optional[str] = state
        self.street: Optional[str] = street

        # Edges
        self.changelog: EdgeList["AuditItem"] = EdgeList("changelog", "AuditItem", changelog)
        self.country: EdgeList["Country"] = EdgeList("country", "Country", country)
        self.location: EdgeList["Location"] = EdgeList("location", "Location", location)


class Country(Location):
    description = """A country."""
    properties = Location.properties + ["name"]
    edges = Location.edges + ["flag", "location"]

    def __init__(
        self,
        name: str = None,
        flag: EdgeList["Photo"] = None,
        location: EdgeList["Location"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.name: Optional[str] = name

        # Edges
        self.flag: EdgeList["Photo"] = EdgeList("flag", "Photo", flag)
        self.location: EdgeList["Location"] = EdgeList("location", "Location", location)


class Photo(MediaObject):
    description = """An image file."""
    properties = MediaObject.properties + ["caption", "exifData", "name"]
    edges = MediaObject.edges + ["changelog", "label", "thumbnail"]

    def __init__(
        self,
        caption: str = None,
        exifData: str = None,
        name: str = None,
        changelog: EdgeList["AuditItem"] = None,
        label: EdgeList["Label"] = None,
        thumbnail: EdgeList["File"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.caption: Optional[str] = caption
        self.exifData: Optional[str] = exifData
        self.name: Optional[str] = name

        # Edges
        self.changelog: EdgeList["AuditItem"] = EdgeList("changelog", "AuditItem", changelog)
        self.label: EdgeList["Label"] = EdgeList("label", "Label", label)
        self.thumbnail: EdgeList["File"] = EdgeList("thumbnail", "File", thumbnail)


class Tweet(Post):
    description = """A Twitter Tweet"""
    properties = Post.properties + ["service"]
    edges = Post.edges + ["mention"]

    def __init__(self, service: str = None, mention: EdgeList["Account"] = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.service: Optional[str] = service

        # Edges
        self.mention: EdgeList["Account"] = EdgeList("mention", "Account", mention)


class Message(WrittenWork):
    description = """A single message."""
    properties = WrittenWork.properties + [
        "dateReceived",
        "dateSent",
        "externalId",
        "service",
        "subject",
        "sourceProject",
        "isMock",
    ]
    edges = WrittenWork.edges + [
        "message",
        "messageChannel",
        "photo",
        "receiver",
        "sender",
        "label",
    ]

    def __init__(
        self,
        dateReceived: datetime = None,
        dateSent: datetime = None,
        externalId: str = None,
        service: str = None,
        subject: str = None,
        sourceProject: str = None,
        isMock: bool = None,
        message: EdgeList["Message"] = None,
        messageChannel: EdgeList["MessageChannel"] = None,
        photo: EdgeList["Photo"] = None,
        receiver: EdgeList["Account"] = None,
        sender: EdgeList["Account"] = None,
        label: EdgeList["CategoricalPrediction"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.dateReceived: Optional[datetime] = dateReceived
        self.dateSent: Optional[datetime] = dateSent
        self.externalId: Optional[str] = externalId
        self.service: Optional[str] = service
        self.subject: Optional[str] = subject
        self.sourceProject: Optional[str] = sourceProject
        self.isMock: Optional[bool] = isMock

        # Edges
        self.message: EdgeList["Message"] = EdgeList("message", "Message", message)
        self.messageChannel: EdgeList["MessageChannel"] = EdgeList(
            "messageChannel", "MessageChannel", messageChannel
        )
        self.photo: EdgeList["Photo"] = EdgeList("photo", "Photo", photo)
        self.receiver: EdgeList["Account"] = EdgeList("receiver", "Account", receiver)
        self.sender: EdgeList["Account"] = EdgeList("sender", "Account", sender)
        self.label: EdgeList["CategoricalPrediction"] = EdgeList(
            "label", "CategoricalPrediction", label
        )


class Note(WrittenWork):
    description = """A file containing a note."""
    properties = WrittenWork.properties + ["starred"]
    edges = WrittenWork.edges + ["label"]

    def __init__(self, starred: bool = None, label: EdgeList["Label"] = None, **kwargs):
        super().__init__(**kwargs)

        # Properties
        self.starred: Optional[bool] = starred

        # Edges
        self.label: EdgeList["Label"] = EdgeList("label", "Label", label)


class EmailMessage(Message):
    description = """A single email message."""
    properties = Message.properties + ["starred"]
    edges = Message.edges + ["bcc", "cc", "message", "replyTo"]

    def __init__(
        self,
        starred: bool = None,
        bcc: EdgeList["Account"] = None,
        cc: EdgeList["Account"] = None,
        message: EdgeList["EmailMessage"] = None,
        replyTo: EdgeList["Account"] = None,
        **kwargs
    ):
        super().__init__(**kwargs)

        # Properties
        self.starred: Optional[bool] = starred

        # Edges
        self.bcc: EdgeList["Account"] = EdgeList("bcc", "Account", bcc)
        self.cc: EdgeList["Account"] = EdgeList("cc", "Account", cc)
        self.message: EdgeList["EmailMessage"] = EdgeList("message", "EmailMessage", message)
        self.replyTo: EdgeList["Account"] = EdgeList("replyTo", "Account", replyTo)
