from clodsa.techniques.techniqueFactory import createTechnique

techniques={
    "avgBlur": (createTechnique("average_blurring", {"kernel" : 5}), createTechnique("none", {})),
    "bilaBlur": (createTechnique("average_blurring", {"diameter" : 11, "sigmaColor": 21, "sigmaSpace":7}), createTechnique("none", {})),
    "blur": (createTechnique("blurring", {"ksize" : 5}), createTechnique("none", {})),
    "chanHsv": (createTechnique("change_to_hsv",{}), createTechnique("none", {})),
    "chanLab": (createTechnique("blurring", {"ksize" : 5}), createTechnique("none", {})),
    "crop": (createTechnique("crop",{"percentage":0.8,"startFrom": "TOPLEFT"}), createTechnique("none", {})),
    "dropOut": (createTechnique("dropout",{"percentage":0.05}), createTechnique("none", {})),
    "elastic": (createTechnique("elastic",{"alpha":5,"sigma":0.05}), createTechnique("none", {})),
    "histo": (createTechnique("equalize_histogram",{}), createTechnique("none", {})),
    "vflip": (createTechnique("flip", {"flip": 0}), createTechnique("flip", {"flip": 0})),
    "hflip": (createTechnique("flip", {"flip": 1}), createTechnique("flip", {"flip": 1})),
    "hvflip": (createTechnique("flip", {"flip": -1}), createTechnique("flip", {"flip": -1})),
    "gamma": (createTechnique("gamma",{"gamma":1.5}), createTechnique("none", {})),
    "blurGau": (createTechnique("gaussian_blur", {"kernel" : 5}), createTechnique("none", {})),
    "avgNoise": (createTechnique("gaussian_noise", {"mean":0, "sigma":10}), createTechnique("none", {})),
    "invert": (createTechnique("invert",{}), createTechnique("none", {})),
    "medianblur": (createTechnique("median_blur", {"kernel" : 5}), createTechnique("none", {})),
    "none": (createTechnique("none", {}), createTechnique("none", {})),
    "raiseBlue": (createTechnique("raise_blue", {"power" : 0.9}), createTechnique("none", {})),
    "raiseGreen": (createTechnique("raise_green", {"power" : 0.9}), createTechnique("none", {})),
    "raiseHue": (createTechnique("raise_hue", {"power" : 0.9}), createTechnique("none", {})),
    "raiseRed": (createTechnique("raise_red", {"power" : 0.9}), createTechnique("none", {})),
    "raiseSatu": (createTechnique("raise_saturation", {"power" : 0.9}), createTechnique("none", {})),
    "raiseValue": (createTechnique("raise_value", {"power" : 0.9}), createTechnique("none", {})),
    "resize": (createTechnique("resize", {"percentage" : 0.9,"method":"INTER_NEAREST"}), createTechnique("none", {})),
    "rotation10": (createTechnique("rotate", {"angle": 10}), createTechnique("rotate", {"angle": -10})),
    "rotation90": (createTechnique("rotate", {"angle": 90}), createTechnique("rotate", {"angle": -90})),
    "rotation180": (createTechnique("rotate", {"angle": 180}), createTechnique("rotate", {"angle": -180})),
    "rotation270": (createTechnique("rotate", {"angle": 270}), createTechnique("rotate", {"angle": -270})),
    "saltPeper": (createTechnique("salt_and_pepper", {"low" : 0,"up":25}), createTechnique("none", {})),
    "sharpen": (createTechnique("sharpen", {}), createTechnique("none", {})),
    "shiftChannel": (createTechnique("shift_channel", {"shift":0.2}), createTechnique("none", {})),
    "shearing": (createTechnique("shearing", {"a":0.5}), createTechnique("none", {})),
    "translation": (createTechnique("translation", {"x":10,"y":10}), createTechnique("none", {}))
}