"""
Definition of the :class:`Modality` class.
"""
from dicom_parser.utils.choice_enum import ChoiceEnum


class Modality(ChoiceEnum):
    """
    Represents the Modality_ attribute.

    .. _Modality:
       https://dicom.innolitics.com/ciods/mr-image/general-series/00080060

    """

    AR = "Autorefraction"
    ASMT = "Content Assessment Results"
    AU = "Audio"
    BDUS = "Bone Densitometry (ultrasound)"
    BMD = "Bone Densitometry (X-Ray)"
    BI = "Biomagnetic imaging"
    CR = "Computed Radiography"
    CT = "Computed Tomography"
    CTPROTOCOL = "CT Protocol (Performed)"
    DG = "Diaphanography"
    DOC = "Document"
    DX = "Digital Radiography"
    ECG = "Electrocardiography"
    EPS = "Cardiac Electrophysiology"
    EDS = "Endoscopy"
    FID = "Fiducials"
    GM = "General Microscopy"
    HC = "Hard Copy"
    HD = "Hemodynamic Waveform"
    IO = "Intra-Oral Radiography"
    IOL = "Intraocular Lens Data"
    IVOCT = "Intravascular Optical Coherence Tomography"
    IVUS = "Intravascular Ultrasound"
    KER = "Keratometry"
    KO = "Key Object Selection"
    LEN = "Lensometry"
    LS = "Laser surface scan"
    MG = "Mammography"
    MR = "Magnetic Resonance"
    M3D = "Model for 3D Manufacturing"
    NM = "Nuclear Medicine"
    OAM = "Ophthalmic Axial Measurements"
    OCT = "Optical Coherence Tomography (non-Ophthalmic)"
    OP = "Ophthalmic Photography"
    OPM = "Ophthalmic Mapping"
    OPT = "Ophthalmic Tomography"
    OPTBSV = "Ophthalmic Tomography B-scan Volume Analysis"
    OPTENF = "Ophthalmic Tomography En Face"
    OPV = "Ophthalmic Visual Field"
    OSS = "Optical Surface Scan"
    OT = "Other"
    PLAN = "Plan"
    PR = "Presentation State"
    PT = "Positron emission tomography (PET)"
    PX = "Panoramic X-Ray"
    REG = "Registration"
    RESP = "Respiratory Waveform"
    RF = "Radio Fluoroscopy"
    RG = "Radiographic imaging (conventional film/screen)"
    RTDOSE = "Radiotherapy Dose"
    RTIMAGE = "Radiotherapy Image"
    RTPLAN = "Radiotherapy Plan"
    RTRECORD = "RT Treatment Record"
    RTSTRUCT = "Radiotherapy Structure Set"
    RWV = "Real World Value Map"
    SEG = "Segmentation"
    SM = "Slide Microscopy"
    SMR = "Stereometric Relationship"
    SR = "SR Document"
    SRF = "Subjective Refraction"
    STAIN = "Automated Slide Stainer"
    TG = "Thermography"
    US = "Ultrasound"
    VA = "Visual Acuity"
    XA = "X-Ray Angiography"
    XC = "External-camera Photography"
