# Generated by Django 2.2.5 on 2020-04-28 15:03

import django.core.files.storage
from django.db import migrations, models
import django.db.models.deletion
import jsoneditor.fields.django_extensions_jsonfield


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('contenttypes', '0002_remove_content_type_name'),
    ]

    operations = [
        migrations.CreateModel(
            name='ImportJob',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('options', jsoneditor.fields.django_extensions_jsonfield.JSONField(blank=True, default=dict, help_text='Detailed instructions for import if necessary', verbose_name='Options')),
                ('upload_file', models.FileField(storage=django.core.files.storage.FileSystemStorage(location=''), upload_to='uploads', verbose_name='Upload File')),
                ('model', models.ForeignKey(help_text='Specify a model to be imported', on_delete=django.db.models.deletion.CASCADE, related_name='imports', to='contenttypes.ContentType', verbose_name='Model')),
            ],
            options={
                'verbose_name': 'Import Job',
                'verbose_name_plural': 'Import Jobs',
            },
        ),
        migrations.CreateModel(
            name='ImportLog',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('imported_at', models.DateTimeField(auto_now=True, help_text='Timestamp when the import happens', verbose_name='Imported At')),
                ('import_log', models.TextField(default='', editable=False, help_text='Detailed log of the importing process', verbose_name='Import Log')),
                ('is_finished', models.BooleanField(default=False, editable=False, verbose_name='Is Finished')),
                ('job', models.ForeignKey(help_text='Job to which the log is related', on_delete=django.db.models.deletion.CASCADE, related_name='logs', to='django_import.ImportJob', verbose_name='Job')),
            ],
            options={
                'verbose_name': 'Import Log',
                'verbose_name_plural': 'Import Logs',
            },
        ),
    ]
