"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !exports.hasOwnProperty(p)) __createBinding(exports, m, p);
};
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipeline = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const pdk_nag_1 = require("@aws-prototyping-sdk/pdk-nag");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_codecommit_1 = require("aws-cdk-lib/aws-codecommit");
const aws_codepipeline_1 = require("aws-cdk-lib/aws-codepipeline");
const aws_kms_1 = require("aws-cdk-lib/aws-kms");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const pipelines_1 = require("aws-cdk-lib/pipelines");
const cdk_nag_1 = require("cdk-nag");
const sonar_code_scanner_1 = require("./code_scanner/sonar-code-scanner");
__exportStar(require("./code_scanner/sonar-code-scanner"), exports);
const DEFAULT_BRANCH_NAME = "mainline";
/**
 * An extension to CodePipeline which configures sane defaults for a NX Monorepo
 * codebase. In addition to this, it also creates a CodeCommit repository with
 * automated PR builds and approvals.
 */
class PDKPipeline extends pipelines_1.CodePipeline {
    constructor(scope, id, props) {
        const codeRepository = new aws_codecommit_1.Repository(scope, "CodeRepository", {
            repositoryName: props.repositoryName,
        });
        codeRepository.applyRemovalPolicy(props.codeCommitRemovalPolicy ?? aws_cdk_lib_1.RemovalPolicy.RETAIN);
        const artifactBucket = new aws_s3_1.Bucket(scope, "ArtifactsBucket", {
            enforceSSL: true,
            autoDeleteObjects: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            encryption: props.crossAccountKeys
                ? aws_s3_1.BucketEncryption.KMS
                : aws_s3_1.BucketEncryption.S3_MANAGED,
            encryptionKey: props.crossAccountKeys
                ? new aws_kms_1.Key(scope, "ArtifactKey", {
                    enableKeyRotation: true,
                    removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
                })
                : undefined,
            publicReadAccess: false,
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            serverAccessLogsPrefix: "access-logs",
        });
        const codePipeline = new aws_codepipeline_1.Pipeline(scope, "CodePipeline", {
            enableKeyRotation: props.crossAccountKeys,
            restartExecutionOnUpdate: true,
            crossAccountKeys: props.crossAccountKeys,
            artifactBucket,
        });
        // ignore input and primaryOutputDirectory
        const { input, primaryOutputDirectory, commands, ...synthShellStepPartialProps } = props.synthShellStepPartialProps || {};
        const synthShellStep = new pipelines_1.ShellStep("Synth", {
            input: pipelines_1.CodePipelineSource.codeCommit(codeRepository, props.defaultBranchName || DEFAULT_BRANCH_NAME),
            installCommands: [
                "npm install -g aws-cdk",
                "yarn install --frozen-lockfile || npx projen && yarn install --frozen-lockfile",
            ],
            commands: commands && commands.length > 0
                ? commands
                : ["npx nx run-many --target=build --all"],
            primaryOutputDirectory: props.primarySynthDirectory,
            ...(synthShellStepPartialProps || {}),
        });
        synthShellStep.addOutputDirectory(".");
        const codePipelineProps = {
            codePipeline,
            ...props,
            crossAccountKeys: undefined,
            synth: synthShellStep,
        };
        super(scope, id, codePipelineProps);
        this.id = id;
        this.codeRepository = codeRepository;
        this.sonarCodeScannerConfig = props.sonarCodeScannerConfig
            ? {
                cdkOutDir: props.primarySynthDirectory,
                ...props.sonarCodeScannerConfig,
            }
            : undefined;
        new aws_cdk_lib_1.CfnOutput(scope, "CodeRepositoryGRCUrl", {
            exportName: "CodeRepositoryGRCUrl",
            value: this.codeRepository.repositoryCloneUrlGrc,
        });
    }
    /**
     * @inheritDoc
     */
    addStage(stage, options) {
        // Add any root Aspects to the stage level as currently this doesn't happen automatically
        aws_cdk_lib_1.Aspects.of(stage.node.root).all.forEach((aspect) => aws_cdk_lib_1.Aspects.of(stage).add(aspect));
        return super.addStage(stage, options);
    }
    buildPipeline() {
        super.buildPipeline();
        this.sonarCodeScannerConfig &&
            new sonar_code_scanner_1.SonarCodeScanner(this, "SonarCodeScanner", {
                artifactBucketArn: this.pipeline.artifactBucket.bucketArn,
                artifactBucketKeyArn: this.pipeline.artifactBucket.encryptionKey?.keyArn,
                synthBuildArn: this.synthProject.projectArn,
                ...this.sonarCodeScannerConfig,
            });
        this.suppressCDKViolations();
    }
    suppressCDKViolations() {
        const stack = aws_cdk_lib_1.Stack.of(this);
        pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}CodePipeline/Role/DefaultPolicy/Resource`, [
            {
                id: "AwsSolutions-IAM5",
                reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                appliesTo: [
                    {
                        regex: "/^Action::s3:.*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                appliesTo: [
                    {
                        regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                    },
                    {
                        regex: "/^Action::kms:ReEncrypt\\*$/g",
                    },
                    {
                        regex: "/^Action::kms:GenerateDataKey\\*$/g",
                    },
                ],
            },
        ]);
        pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}CodePipeline/Role/DefaultPolicy/Resource`, [
            {
                id: "AwsSolutions-IAM5",
                reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                appliesTo: [
                    {
                        regex: "/^Action::s3:.*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                appliesTo: [
                    {
                        regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                    },
                ],
            },
        ]);
        pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}CodePipeline/Source/CodeCommit/CodePipelineActionRole/DefaultPolicy/Resource`, [
            {
                id: "AwsSolutions-IAM5",
                reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                appliesTo: [
                    {
                        regex: "/^Action::s3:.*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                appliesTo: [
                    {
                        regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                    },
                    {
                        regex: "/^Action::kms:ReEncrypt\\*$/g",
                    },
                    {
                        regex: "/^Action::kms:GenerateDataKey\\*$/g",
                    },
                ],
            },
        ]);
        pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}CodePipeline/Build/Synth/CdkBuildProject/Role/DefaultPolicy/Resource`, [
            {
                id: "AwsSolutions-IAM5",
                reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                appliesTo: [
                    {
                        regex: "/^Action::s3:.*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                appliesTo: [
                    {
                        regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                    },
                    {
                        regex: "/^Action::kms:ReEncrypt\\*$/g",
                    },
                    {
                        regex: "/^Action::kms:GenerateDataKey\\*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to manage logs and streams whose names are dynamically determined.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:logs:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:log-group:/aws/codebuild/<CodePipelineBuildSynthCdkBuildProject.*>:\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to create report groups that are dynamically determined.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:codebuild:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:report-group/<CodePipelineBuildSynthCdkBuildProject.*>-\\*$/g`,
                    },
                ],
            },
        ]);
        pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${this.id}/UpdatePipeline/SelfMutation/Role/DefaultPolicy/Resource`, [
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to manage logs and streams whose names are dynamically determined.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:logs:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:log-group:/aws/codebuild/<${this.id}UpdatePipelineSelfMutation.*>:\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to create report groups that are dynamically determined.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:codebuild:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:report-group/<${this.id}UpdatePipelineSelfMutation.*>-\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to assume a role from within the current account in order to deploy.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:\\*:iam::${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:role/\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                appliesTo: [
                    {
                        regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to list all buckets and stacks.",
                appliesTo: [
                    {
                        regex: "/^Resource::\\*$/g",
                    },
                ],
            },
        ]);
        pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${this.id}/UpdatePipeline/SelfMutation/Role/DefaultPolicy/Resource`, [
            {
                id: "AwsSolutions-IAM5",
                reason: "Actions contain wildcards which are valid for CodePipeline as all of these operations are required.",
                appliesTo: [
                    {
                        regex: "/^Action::s3:.*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to manage logs and streams whose names are dynamically determined.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:logs:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:(<AWS::AccountId>|${stack.account}):log-group:/aws/codebuild/<${this.id}UpdatePipelineSelfMutation.*>:\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to create report groups that are dynamically determined.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:${pdk_nag_1.PDKNag.getStackPartitionRegex(stack)}:codebuild:${pdk_nag_1.PDKNag.getStackRegionRegex(stack)}:${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:report-group/<${this.id}UpdatePipelineSelfMutation.*>-\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to assume a role from within the current account in order to deploy.",
                appliesTo: [
                    {
                        regex: `/^Resource::arn:\\*:iam::${pdk_nag_1.PDKNag.getStackAccountRegex(stack)}:role/\\*$/g`,
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to any and all artifacts in the ArtifactsBucket.",
                appliesTo: [
                    {
                        regex: "/^Resource::<ArtifactsBucket.*.Arn>/\\*$/g",
                    },
                    {
                        regex: "/^Action::kms:ReEncrypt\\*$/g",
                    },
                    {
                        regex: "/^Action::kms:GenerateDataKey\\*$/g",
                    },
                ],
            },
            {
                id: "AwsSolutions-IAM5",
                reason: "CodePipeline requires access to list all buckets and stacks.",
                appliesTo: [
                    {
                        regex: "/^Resource::\\*$/g",
                    },
                ],
            },
        ]);
        pdk_nag_1.PDKNag.addResourceSuppressionsByPathNoThrow(stack, `${pdk_nag_1.PDKNag.getStackPrefix(stack)}${this.id}/Assets/FileRole/DefaultPolicy/Resource`, [
            {
                id: "AwsSolutions-IAM5",
                reason: "Asset role requires access to the Artifacts Bucket",
            },
        ]);
        cdk_nag_1.NagSuppressions.addStackSuppressions(stack, [
            {
                id: "AwsSolutions-CB4",
                reason: "Encryption of Codebuild is not required.",
            },
        ]);
    }
}
exports.PDKPipeline = PDKPipeline;
_a = JSII_RTTI_SYMBOL_1;
PDKPipeline[_a] = { fqn: "@aws-prototyping-sdk/pipeline.PDKPipeline", version: "0.12.9" };
//# sourceMappingURL=data:application/json;base64,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