"""
Lemon: Server
By Sasen Perera 2022
"""
from parse import parse
from webob import Request, Response
from waitress import serve

class Server:
    """Server Methods"""
    def __init__(self):
        "Init Function"
        self.routes = {}

    def __call__(self, environ, start_response):
        "On Function Calls"
        request = Request(environ)

        response = self.handle_request(request)

        return response(environ, start_response)

    def route(self, path):
        "route decorator: @server.route('/path')"
        def wrapper(handler):
            self.routes[path] = handler
            return handler

        return wrapper

    def default_response(self, response):
        "Default Response"
        response.status_code = 404
        response.text = "<!DOCTYPE html><html><body style='text-align:center;margin:10px;'><h1>404 Not Found</h1><br><p>generated by Lemon</p></body></html>"

    def find_handler(self, request_path):
        "Find Handler"
        for path, handler in self.routes.items():
            parse_result = parse(path, request_path)
            if parse_result is not None:
                return handler, parse_result.named

        return None, None

    def handle_request(self, request):
        "Handle Request"
        response = Response()

        handler, kwargs = self.find_handler(request_path=request.path)

        if handler is not None:
            handler(request, response, **kwargs)
        else:
            self.default_response(response)

        return response

    def run(self, host="127.0.0.1", port=8000):
        "Runs app with waitress"
        print(f"Running on http://{host}:{port}")
        serve(self, host=host, port=port)
        print(f"Server Ended")
