# django-app-requires

A simple tools auto add app extra requires.

## Install

```
pip install django-app-requires
```

## Usage

**pro/settings**

```

INSTALLED_APPS = [
    ...
    'django_app_requires',
    ...
]

from django_app_requires import add_requires
INSTALLED_APPS = add_requires(INSTALLED_APPS)

```

1. If your django application requires extra application, then add `app_requires = ["your", "required", "apps"]` in the `app/__init__.py` file.
2. In project using your application, add belowe code to the `pro/settings.py` after `INSTALLED_APPS`.
    ```
    from django_app_requires import add_requires
    INSTALLED_APPS = add_requires(INSTALLED_APPS)
    ```


## Releases


| Version | Released Time | Content                                                    | Notice |
| ------ | ---------- | ---------------------------------------------------------------- | ---- |
| v0.1.0 | 2020/09/23 | 1. First release. | |
| v0.1.1 | 2020/09/25 | 2. Add fastutils & magic-import in requirements.txt.<br />3. Fix problems of recursive required. | |
| v0.2.0 | 2020/10/25 | 4. Add collect_requirements function. | **Removed** |
| v0.2.1 | 2020/10/26 | 5. Don't scan all app, exclude third-part apps.<br />6. Suggest to use collect_requirements command before doing project package. | |
| v0.2.2 | 2020/10/26 | 7. Output sorting. | |
| v0.2.3 | 2021/04/12 | 8. Remove collect_requirements command.<br />9. Test with Django 3.2. | |
