"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lib_1 = require("./lib");
const have_output_1 = require("./lib/assertions/have-output");
const have_resource_1 = require("./lib/assertions/have-resource");
const match_template_1 = require("./lib/assertions/match-template");
const expect_1 = require("./lib/expect");
expect.extend({
    toMatchTemplate(actual, template, matchStyle) {
        const assertion = match_template_1.matchTemplate(template, matchStyle);
        const inspector = expect_1.expect(actual);
        const pass = assertion.assertUsing(inspector);
        if (pass) {
            return {
                pass,
                message: () => 'Not ' + assertion.description,
            };
        }
        else {
            return {
                pass,
                message: () => assertion.description,
            };
        }
    },
    toHaveResource(actual, resourceType, properties, comparison) {
        const assertion = new have_resource_1.HaveResourceAssertion(resourceType, properties, comparison, false);
        return applyAssertion(assertion, actual);
    },
    toHaveResourceLike(actual, resourceType, properties, comparison) {
        const assertion = new have_resource_1.HaveResourceAssertion(resourceType, properties, comparison, true);
        return applyAssertion(assertion, actual);
    },
    toHaveOutput(actual, props) {
        return applyAssertion(have_output_1.haveOutput(props), actual);
    },
    toCountResources(actual, resourceType, count = 1) {
        return applyAssertion(lib_1.countResources(resourceType, count), actual);
    },
});
function applyAssertion(assertion, actual) {
    const inspector = expect_1.expect(actual);
    const pass = assertion.assertUsing(inspector);
    if (pass) {
        return {
            pass,
            message: () => 'Not ' + assertion.generateErrorMessage(),
        };
    }
    else {
        return {
            pass,
            message: () => assertion.generateErrorMessage(),
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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