# mypy-boto3-sagemaker

[![PyPI - mypy-boto3-sagemaker](https://img.shields.io/pypi/v/mypy-boto3-sagemaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-sagemaker)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-sagemaker.svg?color=blue)](https://pypi.org/project/mypy-boto3-sagemaker)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.SageMaker 1.14.0](https://boto3.amazonaws.com/v1/documentation/api/1.14.0/reference/services/sagemaker.html#SageMaker) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `SageMaker` service.

```bash
python -m pip install boto3-stubs[sagemaker]
```

## How to use

### Client annotations

`SageMakerClient` provides annotations for `boto3.client("sagemaker")`.

```python
import boto3

from mypy_boto3_sagemaker import SageMakerClient

client: SageMakerClient = boto3.client("sagemaker")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SageMakerClient = session.client("sagemaker")
```

### Paginators annotations

`mypy_boto3_sagemaker.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_sagemaker import SageMakerClient
from mypy_boto3_sagemaker.paginator import (
    ListAlgorithmsPaginator,
    ListAppsPaginator,
    ListAutoMLJobsPaginator,
    ListCandidatesForAutoMLJobPaginator,
    ListCodeRepositoriesPaginator,
    ListCompilationJobsPaginator,
    ListDomainsPaginator,
    ListEndpointConfigsPaginator,
    ListEndpointsPaginator,
    ListExperimentsPaginator,
    ListFlowDefinitionsPaginator,
    ListHumanTaskUisPaginator,
    ListHyperParameterTuningJobsPaginator,
    ListLabelingJobsPaginator,
    ListLabelingJobsForWorkteamPaginator,
    ListModelPackagesPaginator,
    ListModelsPaginator,
    ListMonitoringExecutionsPaginator,
    ListMonitoringSchedulesPaginator,
    ListNotebookInstanceLifecycleConfigsPaginator,
    ListNotebookInstancesPaginator,
    ListProcessingJobsPaginator,
    ListSubscribedWorkteamsPaginator,
    ListTagsPaginator,
    ListTrainingJobsPaginator,
    ListTrainingJobsForHyperParameterTuningJobPaginator,
    ListTransformJobsPaginator,
    ListTrialComponentsPaginator,
    ListTrialsPaginator,
    ListUserProfilesPaginator,
    ListWorkteamsPaginator,
    SearchPaginator,
)

client: SageMakerClient = boto3.client("sagemaker")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_algorithms_paginator: ListAlgorithmsPaginator = client.get_paginator("list_algorithms")
list_apps_paginator: ListAppsPaginator = client.get_paginator("list_apps")
list_auto_ml_jobs_paginator: ListAutoMLJobsPaginator = client.get_paginator("list_auto_ml_jobs")
list_candidates_for_auto_ml_job_paginator: ListCandidatesForAutoMLJobPaginator = client.get_paginator("list_candidates_for_auto_ml_job")
list_code_repositories_paginator: ListCodeRepositoriesPaginator = client.get_paginator("list_code_repositories")
list_compilation_jobs_paginator: ListCompilationJobsPaginator = client.get_paginator("list_compilation_jobs")
list_domains_paginator: ListDomainsPaginator = client.get_paginator("list_domains")
list_endpoint_configs_paginator: ListEndpointConfigsPaginator = client.get_paginator("list_endpoint_configs")
list_endpoints_paginator: ListEndpointsPaginator = client.get_paginator("list_endpoints")
list_experiments_paginator: ListExperimentsPaginator = client.get_paginator("list_experiments")
list_flow_definitions_paginator: ListFlowDefinitionsPaginator = client.get_paginator("list_flow_definitions")
list_human_task_uis_paginator: ListHumanTaskUisPaginator = client.get_paginator("list_human_task_uis")
list_hyper_parameter_tuning_jobs_paginator: ListHyperParameterTuningJobsPaginator = client.get_paginator("list_hyper_parameter_tuning_jobs")
list_labeling_jobs_paginator: ListLabelingJobsPaginator = client.get_paginator("list_labeling_jobs")
list_labeling_jobs_for_workteam_paginator: ListLabelingJobsForWorkteamPaginator = client.get_paginator("list_labeling_jobs_for_workteam")
list_model_packages_paginator: ListModelPackagesPaginator = client.get_paginator("list_model_packages")
list_models_paginator: ListModelsPaginator = client.get_paginator("list_models")
list_monitoring_executions_paginator: ListMonitoringExecutionsPaginator = client.get_paginator("list_monitoring_executions")
list_monitoring_schedules_paginator: ListMonitoringSchedulesPaginator = client.get_paginator("list_monitoring_schedules")
list_notebook_instance_lifecycle_configs_paginator: ListNotebookInstanceLifecycleConfigsPaginator = client.get_paginator("list_notebook_instance_lifecycle_configs")
list_notebook_instances_paginator: ListNotebookInstancesPaginator = client.get_paginator("list_notebook_instances")
list_processing_jobs_paginator: ListProcessingJobsPaginator = client.get_paginator("list_processing_jobs")
list_subscribed_workteams_paginator: ListSubscribedWorkteamsPaginator = client.get_paginator("list_subscribed_workteams")
list_tags_paginator: ListTagsPaginator = client.get_paginator("list_tags")
list_training_jobs_paginator: ListTrainingJobsPaginator = client.get_paginator("list_training_jobs")
list_training_jobs_for_hyper_parameter_tuning_job_paginator: ListTrainingJobsForHyperParameterTuningJobPaginator = client.get_paginator("list_training_jobs_for_hyper_parameter_tuning_job")
list_transform_jobs_paginator: ListTransformJobsPaginator = client.get_paginator("list_transform_jobs")
list_trial_components_paginator: ListTrialComponentsPaginator = client.get_paginator("list_trial_components")
list_trials_paginator: ListTrialsPaginator = client.get_paginator("list_trials")
list_user_profiles_paginator: ListUserProfilesPaginator = client.get_paginator("list_user_profiles")
list_workteams_paginator: ListWorkteamsPaginator = client.get_paginator("list_workteams")
search_paginator: SearchPaginator = client.get_paginator("search")
```


### Waiters annotations

`mypy_boto3_sagemaker.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_sagemaker import SageMakerClient
from mypy_boto3_sagemaker.waiter import (
    EndpointDeletedWaiter,
    EndpointInServiceWaiter,
    NotebookInstanceDeletedWaiter,
    NotebookInstanceInServiceWaiter,
    NotebookInstanceStoppedWaiter,
    ProcessingJobCompletedOrStoppedWaiter,
    TrainingJobCompletedOrStoppedWaiter,
    TransformJobCompletedOrStoppedWaiter,
)

client: SageMakerClient = boto3.client("sagemaker")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
endpoint_deleted_waiter: EndpointDeletedWaiter = client.get_waiter("endpoint_deleted")
endpoint_in_service_waiter: EndpointInServiceWaiter = client.get_waiter("endpoint_in_service")
notebook_instance_deleted_waiter: NotebookInstanceDeletedWaiter = client.get_waiter("notebook_instance_deleted")
notebook_instance_in_service_waiter: NotebookInstanceInServiceWaiter = client.get_waiter("notebook_instance_in_service")
notebook_instance_stopped_waiter: NotebookInstanceStoppedWaiter = client.get_waiter("notebook_instance_stopped")
processing_job_completed_or_stopped_waiter: ProcessingJobCompletedOrStoppedWaiter = client.get_waiter("processing_job_completed_or_stopped")
training_job_completed_or_stopped_waiter: TrainingJobCompletedOrStoppedWaiter = client.get_waiter("training_job_completed_or_stopped")
transform_job_completed_or_stopped_waiter: TransformJobCompletedOrStoppedWaiter = client.get_waiter("transform_job_completed_or_stopped")
```





### Typed dictionations

`mypy_boto3_sagemaker.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_sagemaker.type_defs import AlgorithmSpecificationTypeDef, ...

def get_structure() -> AlgorithmSpecificationTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_sagemaker` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python
import boto3

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("sagemaker")

session_client = boto3.Session().client("sagemaker")
```