# -*- coding: utf-8 -*-
"""
fixtures_multiple_methods.py

This file contains json from NWIS requests that return multiple methods for a
single parameter. This might occur when there are two sensors of the same type
mounted at different elevations.

This fixture was set up to solve Issue #77.

multi_meth: hf.NWIS(site = '444306122144600', service = 'iv', parameterCd = '63680', start_date = '2020-04-18', end_date = '2020-04-18')
    This request is for a site that collects turbidity data (param #63680) using
    two different methods: 1 meter deep, and a variable profile.
"""

multi_meth = {
 'name': 'ns1:timeSeriesResponseType',
 'declaredType': 'org.cuahsi.waterml.TimeSeriesResponseType',
 'scope': 'javax.xml.bind.JAXBElement$GlobalScope',
 'value': {'queryInfo': {'queryURL': 'http://nwis.waterservices.usgs.gov/nwis/iv/format=json%2C1.1&sites=444306122144600&parameterCd=63680&startDT=2020-04-18&endDT=2020-04-18',
   'criteria': {'locationParam': '[ALL:444306122144600]',
    'variableParam': '[63680]',
    'timeParam': {'beginDateTime': '2020-04-18T00:00:00.000',
     'endDateTime': '2020-04-18T23:59:59.000'},
    'parameter': []},
   'note': [{'value': '[ALL:444306122144600]', 'title': 'filter:sites'},
    {'value': '[mode=RANGE, modifiedSince=null] interval={INTERVAL[2020-04-18T00:00:00.000-04:00/2020-04-18T23:59:59.000Z]}',
     'title': 'filter:timeRange'},
    {'value': 'methodIds=[ALL]', 'title': 'filter:methodId'},
    {'value': '2020-11-18T01:54:47.014Z', 'title': 'requestDT'},
    {'value': '09460950-2941-11eb-9560-4cd98f8df011', 'title': 'requestId'},
    {'value': 'Provisional data are subject to revision. Go to http://waterdata.usgs.gov/nwis/help/?provisional for more information.',
     'title': 'disclaimer'},
    {'value': 'nadww01', 'title': 'server'}]},
  'timeSeries': [{'sourceInfo': {'siteName': 'DETROIT LAKE AT LOG BOOM BEHIND DETROIT DAM, OR',
     'siteCode': [{'value': '444306122144600',
       'network': 'NWIS',
       'agencyCode': 'USGS'}],
     'timeZoneInfo': {'defaultTimeZone': {'zoneOffset': '-08:00',
       'zoneAbbreviation': 'PST'},
      'daylightSavingsTimeZone': {'zoneOffset': '-07:00',
       'zoneAbbreviation': 'PDT'},
      'siteUsesDaylightSavingsTime': True},
     'geoLocation': {'geogLocation': {'srs': 'EPSG:4326',
       'latitude': 44.7183194,
       'longitude': -122.2461389},
      'localSiteXY': []},
     'note': [],
     'siteType': [],
     'siteProperty': [{'value': 'LK', 'name': 'siteTypeCd'},
      {'value': '17090005', 'name': 'hucCd'},
      {'value': '41', 'name': 'stateCd'},
      {'value': '41047', 'name': 'countyCd'}]},
    'variable': {'variableCode': [{'value': '63680',
       'network': 'NWIS',
       'vocabulary': 'NWIS:UnitValues',
       'variableID': 51443524,
       'default': True}],
     'variableName': 'Turbidity, water, unfiltered, monochrome near infra-red LED light, 780-900 nm, detection angle 90 &#177;2.5&#176;, formazin nephelometric units (FNU)',
     'variableDescription': 'Turbidity, water, unfiltered, monochrome near infra-red LED light, 780-900 nm, detection angle 90 +-2.5 degrees, formazin nephelometric units (FNU)',
     'valueType': 'Derived Value',
     'unit': {'unitCode': 'FNU'},
     'options': {'option': [{'name': 'Statistic', 'optionCode': '00000'}]},
     'note': [],
     'noDataValue': -999999.0,
     'variableProperty': [],
     'oid': '51443524'},
    'values': [{'value': [{'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T00:26:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T00:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T02:26:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T02:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T03:26:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T03:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T05:26:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T05:56:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T06:26:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T06:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T08:26:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T08:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T10:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T12:26:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T12:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T14:26:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T14:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T15:26:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T15:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T17:26:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T17:56:00.000-07:00'},
       {'value': '1.3',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T18:26:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T18:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T20:26:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T20:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T21:26:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T21:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:56:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T23:26:00.000-07:00'},
       {'value': '1.3',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T23:56:00.000-07:00'}],
      'qualifier': [{'qualifierCode': 'P',
        'qualifierDescription': 'Provisional data subject to revision.',
        'qualifierID': 0,
        'network': 'NWIS',
        'vocabulary': 'uv_rmk_cd'}],
      'qualityControlLevel': [],
      'method': [{'methodDescription': '[1 Meter Below The Surface]',
        'methodID': 254051}],
      'source': [],
      'offset': [],
      'sample': [],
      'censorCode': []},
     {'value': [{'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:01:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:03:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:04:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:06:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:07:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:09:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:11:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:12:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:14:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:15:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:17:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:19:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:22:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:24:00.000-07:00'},
       {'value': '1.6',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:26:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:28:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:30:00.000-07:00'},
       {'value': '2.1',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:32:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:34:00.000-07:00'},
       {'value': '1.6',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:36:00.000-07:00'},
       {'value': '1.6',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:39:00.000-07:00'},
       {'value': '1.6',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:41:00.000-07:00'},
       {'value': '2.0',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T01:44:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:01:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:03:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:04:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:06:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:07:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:09:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:11:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:12:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:14:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:15:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:17:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:20:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:22:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:24:00.000-07:00'},
       {'value': '1.6',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:26:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:28:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:30:00.000-07:00'},
       {'value': '1.6',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:32:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:34:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:37:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:39:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:41:00.000-07:00'},
       {'value': '1.6',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T04:44:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:01:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:03:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:04:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:06:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:07:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:09:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:10:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:12:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:14:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:15:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:17:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:19:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:21:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:24:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:26:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:28:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:30:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:32:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T07:35:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:01:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:03:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:04:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:06:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:07:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:09:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:10:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:12:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:14:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:15:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:17:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:19:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:21:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:23:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:25:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:27:00.000-07:00'},
       {'value': '1.6',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:30:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T13:32:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:01:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:03:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:04:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:06:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:07:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:09:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:10:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:12:00.000-07:00'},
       {'value': '1.9',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:14:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:15:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:17:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:19:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:21:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:23:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:25:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:27:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:29:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T16:32:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:01:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:03:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:04:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:06:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:07:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:09:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:10:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:12:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:14:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:15:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:17:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:19:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:21:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:23:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:26:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:28:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:30:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:32:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T19:34:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:01:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:03:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:04:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:06:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:07:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:09:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:11:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:12:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:14:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:15:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:17:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:19:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:22:00.000-07:00'},
       {'value': '1.4',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:24:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:26:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:28:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:30:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:32:00.000-07:00'},
       {'value': '1.5',
        'qualifiers': ['P'],
        'dateTime': '2020-04-18T22:35:00.000-07:00'}],
      'qualifier': [{'qualifierCode': 'P',
        'qualifierDescription': 'Provisional data subject to revision.',
        'qualifierID': 0,
        'network': 'NWIS',
        'vocabulary': 'uv_rmk_cd'}],
      'qualityControlLevel': [],
      'method': [{'methodDescription': 'Variable Depth Profile Data',
        'methodID': 254060}],
      'source': [],
      'offset': [],
      'sample': [],
      'censorCode': []}],
    'name': 'USGS:444306122144600:63680:00000'}]},
 'nil': False,
 'globalScope': True,
 'typeSubstituted': False
    }