# -*- coding: utf-8 -*-
# snapshottest: v1 - https://goo.gl/zC4yUc
from __future__ import unicode_literals

from snapshottest import Snapshot

snapshots = Snapshot()

snapshots["test_query_html config"] = {
    "allModelFields": {
        "auth.Group": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
            },
            "sortedFields": ["id", "admin", "name"],
        },
        "auth.User": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "date_joined": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "datetime",
                    "prettyName": "Date joined",
                    "type": "datetime",
                },
                "email": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Email address",
                    "type": "string",
                },
                "first_name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "First name",
                    "type": "string",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "is_active": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "boolean",
                    "prettyName": "Active",
                    "type": "boolean",
                },
                "is_staff": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "boolean",
                    "prettyName": "Staff status",
                    "type": "boolean",
                },
                "is_superuser": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "boolean",
                    "prettyName": "Superuser status",
                    "type": "boolean",
                },
                "last_login": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "datetime",
                    "prettyName": "Last login",
                    "type": "datetime",
                },
                "last_name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Last name",
                    "type": "string",
                },
                "password": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Password",
                    "type": "string",
                },
                "username": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Username",
                    "type": "string",
                },
            },
            "sortedFields": [
                "id",
                "admin",
                "date_joined",
                "email",
                "first_name",
                "is_active",
                "is_staff",
                "is_superuser",
                "last_login",
                "last_name",
                "password",
                "username",
            ],
        },
        "boolean": {
            "defaultFilters": [],
            "fields": {
                "average": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "average",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "sum": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "sum",
                    "type": "number",
                },
            },
            "sortedFields": ["average", "is_null", "sum"],
        },
        "core.Address": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "andrew": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Andrew",
                    "type": "string",
                },
                "bob": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Bob",
                    "type": "html",
                },
                "city": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "City",
                    "type": "string",
                },
                "fred": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Fred",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "producer": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.Producer",
                    "prettyName": "Producer",
                    "type": None,
                },
                "tom": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Tom",
                    "type": "html",
                },
            },
            "sortedFields": [
                "id",
                "admin",
                "andrew",
                "bob",
                "city",
                "fred",
                "producer",
                "tom",
            ],
        },
        "core.InAdmin": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
            },
            "sortedFields": ["id", "admin", "name"],
        },
        "core.InlineAdmin": {
            "defaultFilters": [],
            "fields": {
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "in_admin": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.InAdmin",
                    "prettyName": "In admin",
                    "type": None,
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
            },
            "sortedFields": ["id", "in_admin", "name"],
        },
        "core.Normal": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "in_admin": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.InAdmin",
                    "prettyName": "In admin",
                    "type": None,
                },
                "inline_admin": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.InlineAdmin",
                    "prettyName": "Inline admin",
                    "type": None,
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
            },
            "sortedFields": ["id", "admin", "in_admin", "inline_admin", "name"],
        },
        "core.Producer": {
            "defaultFilters": [],
            "fields": {
                "address": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.Address",
                    "prettyName": "Address",
                    "type": None,
                },
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "frank": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Frank",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
            },
            "sortedFields": ["id", "admin", "address", "frank", "name"],
        },
        "core.Product": {
            "defaultFilters": [
                {"lookup": "not_equals", "pathStr": "name", "value": "not a thing"}
            ],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "annotated": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Annotated",
                    "type": "string",
                },
                "boat": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "Boat",
                    "type": "number",
                },
                "calculated_boolean": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Calculated boolean",
                    "type": "boolean",
                },
                "created_time": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "datetime",
                    "prettyName": "Created time",
                    "type": "datetime",
                },
                "date": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "date",
                    "prettyName": "Date",
                    "type": "date",
                },
                "default_sku": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.SKU",
                    "prettyName": "Default sku",
                    "type": None,
                },
                "duration": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "duration",
                    "prettyName": "Duration",
                    "type": "duration",
                },
                "extra_inline": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Extra inline",
                    "type": "string",
                },
                "extra_model": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Extra model",
                    "type": "string",
                },
                "fake": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "unknown",
                    "prettyName": "Fake",
                    "type": "unknown",
                },
                "funky": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Funky",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "image": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "html",
                    "prettyName": "Image",
                    "type": "html",
                },
                "is_onsale": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Is onsale",
                    "type": "html",
                },
                "lambda": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Lambda",
                    "type": "html",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
                "number_choice": {
                    "canPivot": True,
                    "choices": ["A", "B"],
                    "concrete": True,
                    "model": "numberchoice",
                    "prettyName": "Number choice",
                    "type": "numberchoice",
                },
                "only_in_list_view": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Only in list view",
                    "type": "string",
                },
                "onsale": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "boolean",
                    "prettyName": "Onsale",
                    "type": "boolean",
                },
                "producer": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.Producer",
                    "prettyName": "Producer",
                    "type": None,
                },
                "size": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "Size",
                    "type": "number",
                },
                "size_unit": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Size unit",
                    "type": "string",
                },
                "stealth_annotation": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Stealth annotation",
                    "type": "string",
                },
                "string_choice": {
                    "canPivot": True,
                    "choices": ["A", "B"],
                    "concrete": True,
                    "model": "stringchoice",
                    "prettyName": "String choice",
                    "type": "stringchoice",
                },
            },
            "sortedFields": [
                "id",
                "admin",
                "annotated",
                "boat",
                "calculated_boolean",
                "created_time",
                "date",
                "default_sku",
                "duration",
                "extra_inline",
                "extra_model",
                "fake",
                "funky",
                "image",
                "is_onsale",
                "lambda",
                "name",
                "number_choice",
                "only_in_list_view",
                "onsale",
                "producer",
                "size",
                "size_unit",
                "stealth_annotation",
                "string_choice",
            ],
        },
        "core.SKU": {
            "defaultFilters": [],
            "fields": {
                "bob": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Bob",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
                "product": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.Product",
                    "prettyName": "Product",
                    "type": None,
                },
            },
            "sortedFields": ["id", "bob", "name", "product"],
        },
        "core.Tag": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
            },
            "sortedFields": ["id", "admin", "name"],
        },
        "data_browser.View": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "created_time": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "datetime",
                    "prettyName": "Created time",
                    "type": "datetime",
                },
                "description": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Description",
                    "type": "string",
                },
                "fields": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Fields",
                    "type": "string",
                },
                "google_sheets_formula": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Google sheets formula",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Id",
                    "type": "string",
                },
                "limit": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "Limit",
                    "type": "number",
                },
                "model_name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Model name",
                    "type": "string",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
                "open_view": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Open view",
                    "type": "html",
                },
                "owner": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "auth.User",
                    "prettyName": "Owner",
                    "type": None,
                },
                "public": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "boolean",
                    "prettyName": "Public",
                    "type": "boolean",
                },
                "public_link": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Public link",
                    "type": "html",
                },
                "public_slug": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Public slug",
                    "type": "string",
                },
                "query": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Query",
                    "type": "string",
                },
            },
            "sortedFields": [
                "id",
                "admin",
                "created_time",
                "description",
                "fields",
                "google_sheets_formula",
                "limit",
                "model_name",
                "name",
                "open_view",
                "owner",
                "public",
                "public_link",
                "public_slug",
                "query",
            ],
        },
        "date": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "day": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "day",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "iso_week": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "iso week",
                    "type": "number",
                },
                "iso_year": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "iso year",
                    "type": "year",
                },
                "max": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "max",
                    "type": "date",
                },
                "min": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "min",
                    "type": "date",
                },
                "month": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "month",
                    "type": "month",
                },
                "month_start": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "month start",
                    "type": "date",
                },
                "quarter": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "quarter",
                    "type": "number",
                },
                "week_day": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "week day",
                    "type": "weekday",
                },
                "week_start": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "week start",
                    "type": "date",
                },
                "year": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "year",
                    "type": "year",
                },
            },
            "sortedFields": [
                "count",
                "day",
                "is_null",
                "iso_week",
                "iso_year",
                "max",
                "min",
                "month",
                "month_start",
                "quarter",
                "week_day",
                "week_start",
                "year",
            ],
        },
        "datetime": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "date": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "date",
                    "type": "date",
                },
                "day": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "day",
                    "type": "number",
                },
                "hour": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "hour",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "iso_week": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "iso week",
                    "type": "number",
                },
                "iso_year": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "iso year",
                    "type": "year",
                },
                "max": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "max",
                    "type": "datetime",
                },
                "min": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "min",
                    "type": "datetime",
                },
                "minute": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "minute",
                    "type": "number",
                },
                "month": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "month",
                    "type": "month",
                },
                "month_start": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "month start",
                    "type": "date",
                },
                "quarter": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "quarter",
                    "type": "number",
                },
                "second": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "second",
                    "type": "number",
                },
                "week_day": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "week day",
                    "type": "weekday",
                },
                "week_start": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "week start",
                    "type": "date",
                },
                "year": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "year",
                    "type": "year",
                },
            },
            "sortedFields": [
                "count",
                "date",
                "day",
                "hour",
                "is_null",
                "iso_week",
                "iso_year",
                "max",
                "min",
                "minute",
                "month",
                "month_start",
                "quarter",
                "second",
                "week_day",
                "week_start",
                "year",
            ],
        },
        "duration": {
            "defaultFilters": [],
            "fields": {
                "average": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "average",
                    "type": "duration",
                },
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "max": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "max",
                    "type": "duration",
                },
                "min": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "min",
                    "type": "duration",
                },
                "sum": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "sum",
                    "type": "duration",
                },
            },
            "sortedFields": ["average", "count", "is_null", "max", "min", "sum"],
        },
        "html": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "isnull": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "json": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "jsonfield": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "month": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "number": {
            "defaultFilters": [],
            "fields": {
                "average": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "average",
                    "type": "number",
                },
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "max": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "max",
                    "type": "number",
                },
                "min": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "min",
                    "type": "number",
                },
                "std_dev": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "std dev",
                    "type": "number",
                },
                "sum": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "sum",
                    "type": "number",
                },
                "variance": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "variance",
                    "type": "number",
                },
            },
            "sortedFields": [
                "average",
                "count",
                "is_null",
                "max",
                "min",
                "std_dev",
                "sum",
                "variance",
            ],
        },
        "numberarray": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "numberchoice": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "raw": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "raw",
                    "type": "number",
                },
            },
            "sortedFields": ["count", "is_null", "raw"],
        },
        "numberchoicearray": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "raw": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "numberarray",
                    "prettyName": "raw",
                    "type": "numberarray",
                },
            },
            "sortedFields": ["count", "is_null", "raw"],
        },
        "regex": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "string": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "stringarray": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "stringchoice": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "raw": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "raw",
                    "type": "string",
                },
            },
            "sortedFields": ["count", "is_null", "raw"],
        },
        "stringchoicearray": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "raw": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "stringarray",
                    "prettyName": "raw",
                    "type": "stringarray",
                },
            },
            "sortedFields": ["count", "is_null", "raw"],
        },
        "unknown": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "weekday": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "year": {
            "defaultFilters": [],
            "fields": {
                "average": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "average",
                    "type": "number",
                },
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["average", "count", "is_null"],
        },
    },
    "baseUrl": "/data_browser/",
    "canMakePublic": True,
    "defaultRowLimit": 1000,
    "sentryDsn": None,
    "sortedModels": [
        "auth.Group",
        "auth.User",
        "core.Address",
        "core.InAdmin",
        "core.InlineAdmin",
        "core.Normal",
        "core.Producer",
        "core.Product",
        "core.SKU",
        "core.Tag",
        "data_browser.View",
    ],
    "types": {
        "boolean": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": True,
            "lookups": {
                "equals": {"type": "boolean"},
                "is_null": {"type": "isnull"},
                "not_equals": {"type": "boolean"},
            },
            "sortedLookups": ["equals", "not_equals", "is_null"],
        },
        "date": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": "today",
            "lookups": {
                "equals": {"type": "date"},
                "gt": {"type": "date"},
                "gte": {"type": "date"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "date"},
                "lte": {"type": "date"},
                "not_equals": {"type": "date"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
        "datetime": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": "now",
            "lookups": {
                "equals": {"type": "datetime"},
                "gt": {"type": "datetime"},
                "gte": {"type": "datetime"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "datetime"},
                "lte": {"type": "datetime"},
                "not_equals": {"type": "datetime"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
        "duration": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": "",
            "lookups": {
                "equals": {"type": "duration"},
                "gt": {"type": "duration"},
                "gte": {"type": "duration"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "duration"},
                "lte": {"type": "duration"},
                "not_equals": {"type": "duration"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
        "html": {
            "choices": [],
            "defaultLookup": None,
            "defaultSort": None,
            "defaultValue": "",
            "lookups": {},
            "sortedLookups": [],
        },
        "isnull": {
            "choices": ["IsNull", "NotNull"],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": "IsNull",
            "lookups": {"equals": {"type": "isnull"}},
            "sortedLookups": ["equals"],
        },
        "json": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "equals": {"type": "json"},
                "field_equals": {"type": "jsonfield"},
                "has_key": {"type": "string"},
                "is_null": {"type": "isnull"},
                "not_equals": {"type": "json"},
                "not_field_equals": {"type": "jsonfield"},
                "not_has_key": {"type": "string"},
            },
            "sortedLookups": [
                "equals",
                "has_key",
                "field_equals",
                "not_equals",
                "not_has_key",
                "not_field_equals",
                "is_null",
            ],
        },
        "jsonfield": {
            "choices": [],
            "defaultLookup": None,
            "defaultSort": None,
            "defaultValue": "|",
            "lookups": {},
            "sortedLookups": [],
        },
        "month": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": "January",
            "lookups": {"equals": {"type": "month"}, "not_equals": {"type": "month"}},
            "sortedLookups": ["equals", "not_equals"],
        },
        "number": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": 0,
            "lookups": {
                "equals": {"type": "number"},
                "gt": {"type": "number"},
                "gte": {"type": "number"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "number"},
                "lte": {"type": "number"},
                "not_equals": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
        "numberarray": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "contains": {"type": "number"},
                "equals": {"type": "numberarray"},
                "is_null": {"type": "isnull"},
                "length": {"type": "number"},
                "not_contains": {"type": "number"},
                "not_equals": {"type": "numberarray"},
                "not_length": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "length",
                "not_equals",
                "not_contains",
                "not_length",
                "is_null",
            ],
        },
        "numberchoice": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "equals": {"type": "numberchoice"},
                "is_null": {"type": "isnull"},
                "not_equals": {"type": "numberchoice"},
            },
            "sortedLookups": ["equals", "not_equals", "is_null"],
        },
        "numberchoicearray": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "contains": {"type": "numberchoice"},
                "equals": {"type": "numberchoicearray"},
                "is_null": {"type": "isnull"},
                "length": {"type": "number"},
                "not_contains": {"type": "numberchoice"},
                "not_equals": {"type": "numberchoicearray"},
                "not_length": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "length",
                "not_equals",
                "not_contains",
                "not_length",
                "is_null",
            ],
        },
        "regex": {
            "choices": [],
            "defaultLookup": None,
            "defaultSort": None,
            "defaultValue": ".*",
            "lookups": {},
            "sortedLookups": [],
        },
        "string": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": "",
            "lookups": {
                "contains": {"type": "string"},
                "ends_with": {"type": "string"},
                "equals": {"type": "string"},
                "is_null": {"type": "isnull"},
                "not_contains": {"type": "string"},
                "not_ends_with": {"type": "string"},
                "not_equals": {"type": "string"},
                "not_regex": {"type": "regex"},
                "not_starts_with": {"type": "string"},
                "regex": {"type": "regex"},
                "starts_with": {"type": "string"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "starts_with",
                "ends_with",
                "regex",
                "not_equals",
                "not_contains",
                "not_starts_with",
                "not_ends_with",
                "not_regex",
                "is_null",
            ],
        },
        "stringarray": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "contains": {"type": "string"},
                "equals": {"type": "stringarray"},
                "is_null": {"type": "isnull"},
                "length": {"type": "number"},
                "not_contains": {"type": "string"},
                "not_equals": {"type": "stringarray"},
                "not_length": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "length",
                "not_equals",
                "not_contains",
                "not_length",
                "is_null",
            ],
        },
        "stringchoice": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "equals": {"type": "stringchoice"},
                "is_null": {"type": "isnull"},
                "not_equals": {"type": "stringchoice"},
            },
            "sortedLookups": ["equals", "not_equals", "is_null"],
        },
        "stringchoicearray": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "contains": {"type": "stringchoice"},
                "equals": {"type": "stringchoicearray"},
                "is_null": {"type": "isnull"},
                "length": {"type": "number"},
                "not_contains": {"type": "stringchoice"},
                "not_equals": {"type": "stringchoicearray"},
                "not_length": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "length",
                "not_equals",
                "not_contains",
                "not_length",
                "is_null",
            ],
        },
        "unknown": {
            "choices": [],
            "defaultLookup": "is_null",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {"is_null": {"type": "isnull"}},
            "sortedLookups": ["is_null"],
        },
        "weekday": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": "Monday",
            "lookups": {
                "equals": {"type": "weekday"},
                "not_equals": {"type": "weekday"},
            },
            "sortedLookups": ["equals", "not_equals"],
        },
        "year": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": 2020,
            "lookups": {
                "equals": {"type": "year"},
                "gt": {"type": "year"},
                "gte": {"type": "year"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "year"},
                "lte": {"type": "year"},
                "not_equals": {"type": "year"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
    },
}

snapshots["test_query_query query"] = {
    "fields": [
        {"pathStr": "size", "pivoted": False, "priority": 0, "sort": "dsc"},
        {"pathStr": "name", "pivoted": False, "priority": 1, "sort": "asc"},
        {"pathStr": "size_unit", "pivoted": False, "priority": None, "sort": None},
    ],
    "filterErrors": [None, None],
    "filters": [
        {"lookup": "lt", "pathStr": "size", "value": "2"},
        {"lookup": "gt", "pathStr": "id", "value": "0"},
    ],
    "limit": 1000,
    "model": "core.Product",
}

snapshots["test_query_html_no_perms config"] = {
    "allModelFields": {
        "boolean": {
            "defaultFilters": [],
            "fields": {
                "average": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "average",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "sum": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "sum",
                    "type": "number",
                },
            },
            "sortedFields": ["average", "is_null", "sum"],
        },
        "date": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "day": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "day",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "iso_week": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "iso week",
                    "type": "number",
                },
                "iso_year": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "iso year",
                    "type": "year",
                },
                "max": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "max",
                    "type": "date",
                },
                "min": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "min",
                    "type": "date",
                },
                "month": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "month",
                    "type": "month",
                },
                "month_start": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "month start",
                    "type": "date",
                },
                "quarter": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "quarter",
                    "type": "number",
                },
                "week_day": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "week day",
                    "type": "weekday",
                },
                "week_start": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "week start",
                    "type": "date",
                },
                "year": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "year",
                    "type": "year",
                },
            },
            "sortedFields": [
                "count",
                "day",
                "is_null",
                "iso_week",
                "iso_year",
                "max",
                "min",
                "month",
                "month_start",
                "quarter",
                "week_day",
                "week_start",
                "year",
            ],
        },
        "datetime": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "date": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "date",
                    "type": "date",
                },
                "day": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "day",
                    "type": "number",
                },
                "hour": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "hour",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "iso_week": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "iso week",
                    "type": "number",
                },
                "iso_year": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "iso year",
                    "type": "year",
                },
                "max": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "max",
                    "type": "datetime",
                },
                "min": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "min",
                    "type": "datetime",
                },
                "minute": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "minute",
                    "type": "number",
                },
                "month": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "month",
                    "type": "month",
                },
                "month_start": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "month start",
                    "type": "date",
                },
                "quarter": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "quarter",
                    "type": "number",
                },
                "second": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "second",
                    "type": "number",
                },
                "week_day": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "week day",
                    "type": "weekday",
                },
                "week_start": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "week start",
                    "type": "date",
                },
                "year": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "year",
                    "type": "year",
                },
            },
            "sortedFields": [
                "count",
                "date",
                "day",
                "hour",
                "is_null",
                "iso_week",
                "iso_year",
                "max",
                "min",
                "minute",
                "month",
                "month_start",
                "quarter",
                "second",
                "week_day",
                "week_start",
                "year",
            ],
        },
        "duration": {
            "defaultFilters": [],
            "fields": {
                "average": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "average",
                    "type": "duration",
                },
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "max": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "max",
                    "type": "duration",
                },
                "min": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "min",
                    "type": "duration",
                },
                "sum": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "sum",
                    "type": "duration",
                },
            },
            "sortedFields": ["average", "count", "is_null", "max", "min", "sum"],
        },
        "html": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "isnull": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "json": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "jsonfield": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "month": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "number": {
            "defaultFilters": [],
            "fields": {
                "average": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "average",
                    "type": "number",
                },
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "max": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "max",
                    "type": "number",
                },
                "min": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "min",
                    "type": "number",
                },
                "std_dev": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "std dev",
                    "type": "number",
                },
                "sum": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "sum",
                    "type": "number",
                },
                "variance": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "variance",
                    "type": "number",
                },
            },
            "sortedFields": [
                "average",
                "count",
                "is_null",
                "max",
                "min",
                "std_dev",
                "sum",
                "variance",
            ],
        },
        "numberarray": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "numberchoice": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "raw": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "raw",
                    "type": "number",
                },
            },
            "sortedFields": ["count", "is_null", "raw"],
        },
        "numberchoicearray": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "raw": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "numberarray",
                    "prettyName": "raw",
                    "type": "numberarray",
                },
            },
            "sortedFields": ["count", "is_null", "raw"],
        },
        "regex": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "string": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "stringarray": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "stringchoice": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "raw": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "raw",
                    "type": "string",
                },
            },
            "sortedFields": ["count", "is_null", "raw"],
        },
        "stringchoicearray": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "raw": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "stringarray",
                    "prettyName": "raw",
                    "type": "stringarray",
                },
            },
            "sortedFields": ["count", "is_null", "raw"],
        },
        "unknown": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "weekday": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "year": {
            "defaultFilters": [],
            "fields": {
                "average": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "average",
                    "type": "number",
                },
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["average", "count", "is_null"],
        },
    },
    "baseUrl": "/data_browser/",
    "canMakePublic": False,
    "defaultRowLimit": 1000,
    "sentryDsn": None,
    "sortedModels": [],
    "types": {
        "boolean": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": True,
            "lookups": {
                "equals": {"type": "boolean"},
                "is_null": {"type": "isnull"},
                "not_equals": {"type": "boolean"},
            },
            "sortedLookups": ["equals", "not_equals", "is_null"],
        },
        "date": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": "today",
            "lookups": {
                "equals": {"type": "date"},
                "gt": {"type": "date"},
                "gte": {"type": "date"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "date"},
                "lte": {"type": "date"},
                "not_equals": {"type": "date"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
        "datetime": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": "now",
            "lookups": {
                "equals": {"type": "datetime"},
                "gt": {"type": "datetime"},
                "gte": {"type": "datetime"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "datetime"},
                "lte": {"type": "datetime"},
                "not_equals": {"type": "datetime"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
        "duration": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": "",
            "lookups": {
                "equals": {"type": "duration"},
                "gt": {"type": "duration"},
                "gte": {"type": "duration"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "duration"},
                "lte": {"type": "duration"},
                "not_equals": {"type": "duration"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
        "html": {
            "choices": [],
            "defaultLookup": None,
            "defaultSort": None,
            "defaultValue": "",
            "lookups": {},
            "sortedLookups": [],
        },
        "isnull": {
            "choices": ["IsNull", "NotNull"],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": "IsNull",
            "lookups": {"equals": {"type": "isnull"}},
            "sortedLookups": ["equals"],
        },
        "json": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "equals": {"type": "json"},
                "field_equals": {"type": "jsonfield"},
                "has_key": {"type": "string"},
                "is_null": {"type": "isnull"},
                "not_equals": {"type": "json"},
                "not_field_equals": {"type": "jsonfield"},
                "not_has_key": {"type": "string"},
            },
            "sortedLookups": [
                "equals",
                "has_key",
                "field_equals",
                "not_equals",
                "not_has_key",
                "not_field_equals",
                "is_null",
            ],
        },
        "jsonfield": {
            "choices": [],
            "defaultLookup": None,
            "defaultSort": None,
            "defaultValue": "|",
            "lookups": {},
            "sortedLookups": [],
        },
        "month": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": "January",
            "lookups": {"equals": {"type": "month"}, "not_equals": {"type": "month"}},
            "sortedLookups": ["equals", "not_equals"],
        },
        "number": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": 0,
            "lookups": {
                "equals": {"type": "number"},
                "gt": {"type": "number"},
                "gte": {"type": "number"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "number"},
                "lte": {"type": "number"},
                "not_equals": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
        "numberarray": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "contains": {"type": "number"},
                "equals": {"type": "numberarray"},
                "is_null": {"type": "isnull"},
                "length": {"type": "number"},
                "not_contains": {"type": "number"},
                "not_equals": {"type": "numberarray"},
                "not_length": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "length",
                "not_equals",
                "not_contains",
                "not_length",
                "is_null",
            ],
        },
        "numberchoice": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "equals": {"type": "numberchoice"},
                "is_null": {"type": "isnull"},
                "not_equals": {"type": "numberchoice"},
            },
            "sortedLookups": ["equals", "not_equals", "is_null"],
        },
        "numberchoicearray": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "contains": {"type": "numberchoice"},
                "equals": {"type": "numberchoicearray"},
                "is_null": {"type": "isnull"},
                "length": {"type": "number"},
                "not_contains": {"type": "numberchoice"},
                "not_equals": {"type": "numberchoicearray"},
                "not_length": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "length",
                "not_equals",
                "not_contains",
                "not_length",
                "is_null",
            ],
        },
        "regex": {
            "choices": [],
            "defaultLookup": None,
            "defaultSort": None,
            "defaultValue": ".*",
            "lookups": {},
            "sortedLookups": [],
        },
        "string": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": "",
            "lookups": {
                "contains": {"type": "string"},
                "ends_with": {"type": "string"},
                "equals": {"type": "string"},
                "is_null": {"type": "isnull"},
                "not_contains": {"type": "string"},
                "not_ends_with": {"type": "string"},
                "not_equals": {"type": "string"},
                "not_regex": {"type": "regex"},
                "not_starts_with": {"type": "string"},
                "regex": {"type": "regex"},
                "starts_with": {"type": "string"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "starts_with",
                "ends_with",
                "regex",
                "not_equals",
                "not_contains",
                "not_starts_with",
                "not_ends_with",
                "not_regex",
                "is_null",
            ],
        },
        "stringarray": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "contains": {"type": "string"},
                "equals": {"type": "stringarray"},
                "is_null": {"type": "isnull"},
                "length": {"type": "number"},
                "not_contains": {"type": "string"},
                "not_equals": {"type": "stringarray"},
                "not_length": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "length",
                "not_equals",
                "not_contains",
                "not_length",
                "is_null",
            ],
        },
        "stringchoice": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "equals": {"type": "stringchoice"},
                "is_null": {"type": "isnull"},
                "not_equals": {"type": "stringchoice"},
            },
            "sortedLookups": ["equals", "not_equals", "is_null"],
        },
        "stringchoicearray": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "contains": {"type": "stringchoice"},
                "equals": {"type": "stringchoicearray"},
                "is_null": {"type": "isnull"},
                "length": {"type": "number"},
                "not_contains": {"type": "stringchoice"},
                "not_equals": {"type": "stringchoicearray"},
                "not_length": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "length",
                "not_equals",
                "not_contains",
                "not_length",
                "is_null",
            ],
        },
        "unknown": {
            "choices": [],
            "defaultLookup": "is_null",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {"is_null": {"type": "isnull"}},
            "sortedLookups": ["is_null"],
        },
        "weekday": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": "Monday",
            "lookups": {
                "equals": {"type": "weekday"},
                "not_equals": {"type": "weekday"},
            },
            "sortedLookups": ["equals", "not_equals"],
        },
        "year": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": 2020,
            "lookups": {
                "equals": {"type": "year"},
                "gt": {"type": "year"},
                "gte": {"type": "year"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "year"},
                "lte": {"type": "year"},
                "not_equals": {"type": "year"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
    },
}

snapshots["test_query_ctx config"] = {
    "allModelFields": {
        "auth.Group": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
            },
            "sortedFields": ["id", "admin", "name"],
        },
        "auth.User": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "date_joined": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "datetime",
                    "prettyName": "Date joined",
                    "type": "datetime",
                },
                "email": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Email address",
                    "type": "string",
                },
                "first_name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "First name",
                    "type": "string",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "is_active": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "boolean",
                    "prettyName": "Active",
                    "type": "boolean",
                },
                "is_staff": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "boolean",
                    "prettyName": "Staff status",
                    "type": "boolean",
                },
                "is_superuser": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "boolean",
                    "prettyName": "Superuser status",
                    "type": "boolean",
                },
                "last_login": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "datetime",
                    "prettyName": "Last login",
                    "type": "datetime",
                },
                "last_name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Last name",
                    "type": "string",
                },
                "password": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Password",
                    "type": "string",
                },
                "username": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Username",
                    "type": "string",
                },
            },
            "sortedFields": [
                "id",
                "admin",
                "date_joined",
                "email",
                "first_name",
                "is_active",
                "is_staff",
                "is_superuser",
                "last_login",
                "last_name",
                "password",
                "username",
            ],
        },
        "boolean": {
            "defaultFilters": [],
            "fields": {
                "average": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "average",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "sum": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "sum",
                    "type": "number",
                },
            },
            "sortedFields": ["average", "is_null", "sum"],
        },
        "core.Address": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "andrew": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Andrew",
                    "type": "string",
                },
                "bob": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Bob",
                    "type": "html",
                },
                "city": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "City",
                    "type": "string",
                },
                "fred": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Fred",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "producer": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.Producer",
                    "prettyName": "Producer",
                    "type": None,
                },
                "tom": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Tom",
                    "type": "html",
                },
            },
            "sortedFields": [
                "id",
                "admin",
                "andrew",
                "bob",
                "city",
                "fred",
                "producer",
                "tom",
            ],
        },
        "core.InAdmin": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
            },
            "sortedFields": ["id", "admin", "name"],
        },
        "core.InlineAdmin": {
            "defaultFilters": [],
            "fields": {
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "in_admin": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.InAdmin",
                    "prettyName": "In admin",
                    "type": None,
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
            },
            "sortedFields": ["id", "in_admin", "name"],
        },
        "core.Normal": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "in_admin": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.InAdmin",
                    "prettyName": "In admin",
                    "type": None,
                },
                "inline_admin": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.InlineAdmin",
                    "prettyName": "Inline admin",
                    "type": None,
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
            },
            "sortedFields": ["id", "admin", "in_admin", "inline_admin", "name"],
        },
        "core.Producer": {
            "defaultFilters": [],
            "fields": {
                "address": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.Address",
                    "prettyName": "Address",
                    "type": None,
                },
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "frank": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Frank",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
            },
            "sortedFields": ["id", "admin", "address", "frank", "name"],
        },
        "core.Product": {
            "defaultFilters": [
                {"lookup": "not_equals", "pathStr": "name", "value": "not a thing"}
            ],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "annotated": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Annotated",
                    "type": "string",
                },
                "boat": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "Boat",
                    "type": "number",
                },
                "calculated_boolean": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Calculated boolean",
                    "type": "boolean",
                },
                "created_time": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "datetime",
                    "prettyName": "Created time",
                    "type": "datetime",
                },
                "date": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "date",
                    "prettyName": "Date",
                    "type": "date",
                },
                "default_sku": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.SKU",
                    "prettyName": "Default sku",
                    "type": None,
                },
                "duration": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "duration",
                    "prettyName": "Duration",
                    "type": "duration",
                },
                "extra_inline": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Extra inline",
                    "type": "string",
                },
                "extra_model": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Extra model",
                    "type": "string",
                },
                "fake": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "unknown",
                    "prettyName": "Fake",
                    "type": "unknown",
                },
                "funky": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Funky",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "image": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "html",
                    "prettyName": "Image",
                    "type": "html",
                },
                "is_onsale": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Is onsale",
                    "type": "html",
                },
                "lambda": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Lambda",
                    "type": "html",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
                "number_choice": {
                    "canPivot": True,
                    "choices": ["A", "B"],
                    "concrete": True,
                    "model": "numberchoice",
                    "prettyName": "Number choice",
                    "type": "numberchoice",
                },
                "only_in_list_view": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Only in list view",
                    "type": "string",
                },
                "onsale": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "boolean",
                    "prettyName": "Onsale",
                    "type": "boolean",
                },
                "producer": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.Producer",
                    "prettyName": "Producer",
                    "type": None,
                },
                "size": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "Size",
                    "type": "number",
                },
                "size_unit": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Size unit",
                    "type": "string",
                },
                "stealth_annotation": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Stealth annotation",
                    "type": "string",
                },
                "string_choice": {
                    "canPivot": True,
                    "choices": ["A", "B"],
                    "concrete": True,
                    "model": "stringchoice",
                    "prettyName": "String choice",
                    "type": "stringchoice",
                },
            },
            "sortedFields": [
                "id",
                "admin",
                "annotated",
                "boat",
                "calculated_boolean",
                "created_time",
                "date",
                "default_sku",
                "duration",
                "extra_inline",
                "extra_model",
                "fake",
                "funky",
                "image",
                "is_onsale",
                "lambda",
                "name",
                "number_choice",
                "only_in_list_view",
                "onsale",
                "producer",
                "size",
                "size_unit",
                "stealth_annotation",
                "string_choice",
            ],
        },
        "core.SKU": {
            "defaultFilters": [],
            "fields": {
                "bob": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Bob",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
                "product": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "core.Product",
                    "prettyName": "Product",
                    "type": None,
                },
            },
            "sortedFields": ["id", "bob", "name", "product"],
        },
        "core.Tag": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "ID",
                    "type": "number",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
            },
            "sortedFields": ["id", "admin", "name"],
        },
        "data_browser.View": {
            "defaultFilters": [],
            "fields": {
                "admin": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Admin",
                    "type": "html",
                },
                "created_time": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "datetime",
                    "prettyName": "Created time",
                    "type": "datetime",
                },
                "description": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Description",
                    "type": "string",
                },
                "fields": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Fields",
                    "type": "string",
                },
                "google_sheets_formula": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Google sheets formula",
                    "type": "html",
                },
                "id": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Id",
                    "type": "string",
                },
                "limit": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "Limit",
                    "type": "number",
                },
                "model_name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Model name",
                    "type": "string",
                },
                "name": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Name",
                    "type": "string",
                },
                "open_view": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Open view",
                    "type": "html",
                },
                "owner": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": False,
                    "model": "auth.User",
                    "prettyName": "Owner",
                    "type": None,
                },
                "public": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "boolean",
                    "prettyName": "Public",
                    "type": "boolean",
                },
                "public_link": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": False,
                    "model": None,
                    "prettyName": "Public link",
                    "type": "html",
                },
                "public_slug": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Public slug",
                    "type": "string",
                },
                "query": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "Query",
                    "type": "string",
                },
            },
            "sortedFields": [
                "id",
                "admin",
                "created_time",
                "description",
                "fields",
                "google_sheets_formula",
                "limit",
                "model_name",
                "name",
                "open_view",
                "owner",
                "public",
                "public_link",
                "public_slug",
                "query",
            ],
        },
        "date": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "day": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "day",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "iso_week": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "iso week",
                    "type": "number",
                },
                "iso_year": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "iso year",
                    "type": "year",
                },
                "max": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "max",
                    "type": "date",
                },
                "min": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "min",
                    "type": "date",
                },
                "month": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "month",
                    "type": "month",
                },
                "month_start": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "month start",
                    "type": "date",
                },
                "quarter": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "quarter",
                    "type": "number",
                },
                "week_day": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "week day",
                    "type": "weekday",
                },
                "week_start": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "week start",
                    "type": "date",
                },
                "year": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "year",
                    "type": "year",
                },
            },
            "sortedFields": [
                "count",
                "day",
                "is_null",
                "iso_week",
                "iso_year",
                "max",
                "min",
                "month",
                "month_start",
                "quarter",
                "week_day",
                "week_start",
                "year",
            ],
        },
        "datetime": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "date": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "date",
                    "type": "date",
                },
                "day": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "day",
                    "type": "number",
                },
                "hour": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "hour",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "iso_week": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "iso week",
                    "type": "number",
                },
                "iso_year": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "iso year",
                    "type": "year",
                },
                "max": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "max",
                    "type": "datetime",
                },
                "min": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "min",
                    "type": "datetime",
                },
                "minute": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "minute",
                    "type": "number",
                },
                "month": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "month",
                    "type": "month",
                },
                "month_start": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "month start",
                    "type": "date",
                },
                "quarter": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "quarter",
                    "type": "number",
                },
                "second": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "second",
                    "type": "number",
                },
                "week_day": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "week day",
                    "type": "weekday",
                },
                "week_start": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "week start",
                    "type": "date",
                },
                "year": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "year",
                    "type": "year",
                },
            },
            "sortedFields": [
                "count",
                "date",
                "day",
                "hour",
                "is_null",
                "iso_week",
                "iso_year",
                "max",
                "min",
                "minute",
                "month",
                "month_start",
                "quarter",
                "second",
                "week_day",
                "week_start",
                "year",
            ],
        },
        "duration": {
            "defaultFilters": [],
            "fields": {
                "average": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "average",
                    "type": "duration",
                },
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "max": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "max",
                    "type": "duration",
                },
                "min": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "min",
                    "type": "duration",
                },
                "sum": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "sum",
                    "type": "duration",
                },
            },
            "sortedFields": ["average", "count", "is_null", "max", "min", "sum"],
        },
        "html": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "isnull": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "json": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "jsonfield": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "month": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "number": {
            "defaultFilters": [],
            "fields": {
                "average": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "average",
                    "type": "number",
                },
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "max": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "max",
                    "type": "number",
                },
                "min": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "min",
                    "type": "number",
                },
                "std_dev": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "std dev",
                    "type": "number",
                },
                "sum": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "sum",
                    "type": "number",
                },
                "variance": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "variance",
                    "type": "number",
                },
            },
            "sortedFields": [
                "average",
                "count",
                "is_null",
                "max",
                "min",
                "std_dev",
                "sum",
                "variance",
            ],
        },
        "numberarray": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "numberchoice": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "raw": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "number",
                    "prettyName": "raw",
                    "type": "number",
                },
            },
            "sortedFields": ["count", "is_null", "raw"],
        },
        "numberchoicearray": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "raw": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "numberarray",
                    "prettyName": "raw",
                    "type": "numberarray",
                },
            },
            "sortedFields": ["count", "is_null", "raw"],
        },
        "regex": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "string": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "stringarray": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "stringchoice": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "raw": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "string",
                    "prettyName": "raw",
                    "type": "string",
                },
            },
            "sortedFields": ["count", "is_null", "raw"],
        },
        "stringchoicearray": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
                "raw": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": "stringarray",
                    "prettyName": "raw",
                    "type": "stringarray",
                },
            },
            "sortedFields": ["count", "is_null", "raw"],
        },
        "unknown": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "weekday": {
            "defaultFilters": [],
            "fields": {
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["count", "is_null"],
        },
        "year": {
            "defaultFilters": [],
            "fields": {
                "average": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "average",
                    "type": "number",
                },
                "count": {
                    "canPivot": False,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "count",
                    "type": "number",
                },
                "is_null": {
                    "canPivot": True,
                    "choices": [],
                    "concrete": True,
                    "model": None,
                    "prettyName": "is null",
                    "type": "isnull",
                },
            },
            "sortedFields": ["average", "count", "is_null"],
        },
    },
    "baseUrl": "/data_browser/",
    "canMakePublic": True,
    "defaultRowLimit": 1000,
    "sentryDsn": None,
    "sortedModels": [
        "auth.Group",
        "auth.User",
        "core.Address",
        "core.InAdmin",
        "core.InlineAdmin",
        "core.Normal",
        "core.Producer",
        "core.Product",
        "core.SKU",
        "core.Tag",
        "data_browser.View",
    ],
    "types": {
        "boolean": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": True,
            "lookups": {
                "equals": {"type": "boolean"},
                "is_null": {"type": "isnull"},
                "not_equals": {"type": "boolean"},
            },
            "sortedLookups": ["equals", "not_equals", "is_null"],
        },
        "date": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": "today",
            "lookups": {
                "equals": {"type": "date"},
                "gt": {"type": "date"},
                "gte": {"type": "date"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "date"},
                "lte": {"type": "date"},
                "not_equals": {"type": "date"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
        "datetime": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": "now",
            "lookups": {
                "equals": {"type": "datetime"},
                "gt": {"type": "datetime"},
                "gte": {"type": "datetime"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "datetime"},
                "lte": {"type": "datetime"},
                "not_equals": {"type": "datetime"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
        "duration": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": "",
            "lookups": {
                "equals": {"type": "duration"},
                "gt": {"type": "duration"},
                "gte": {"type": "duration"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "duration"},
                "lte": {"type": "duration"},
                "not_equals": {"type": "duration"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
        "html": {
            "choices": [],
            "defaultLookup": None,
            "defaultSort": None,
            "defaultValue": "",
            "lookups": {},
            "sortedLookups": [],
        },
        "isnull": {
            "choices": ["IsNull", "NotNull"],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": "IsNull",
            "lookups": {"equals": {"type": "isnull"}},
            "sortedLookups": ["equals"],
        },
        "json": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "equals": {"type": "json"},
                "field_equals": {"type": "jsonfield"},
                "has_key": {"type": "string"},
                "is_null": {"type": "isnull"},
                "not_equals": {"type": "json"},
                "not_field_equals": {"type": "jsonfield"},
                "not_has_key": {"type": "string"},
            },
            "sortedLookups": [
                "equals",
                "has_key",
                "field_equals",
                "not_equals",
                "not_has_key",
                "not_field_equals",
                "is_null",
            ],
        },
        "jsonfield": {
            "choices": [],
            "defaultLookup": None,
            "defaultSort": None,
            "defaultValue": "|",
            "lookups": {},
            "sortedLookups": [],
        },
        "month": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": "January",
            "lookups": {"equals": {"type": "month"}, "not_equals": {"type": "month"}},
            "sortedLookups": ["equals", "not_equals"],
        },
        "number": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": 0,
            "lookups": {
                "equals": {"type": "number"},
                "gt": {"type": "number"},
                "gte": {"type": "number"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "number"},
                "lte": {"type": "number"},
                "not_equals": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
        "numberarray": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "contains": {"type": "number"},
                "equals": {"type": "numberarray"},
                "is_null": {"type": "isnull"},
                "length": {"type": "number"},
                "not_contains": {"type": "number"},
                "not_equals": {"type": "numberarray"},
                "not_length": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "length",
                "not_equals",
                "not_contains",
                "not_length",
                "is_null",
            ],
        },
        "numberchoice": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "equals": {"type": "numberchoice"},
                "is_null": {"type": "isnull"},
                "not_equals": {"type": "numberchoice"},
            },
            "sortedLookups": ["equals", "not_equals", "is_null"],
        },
        "numberchoicearray": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "contains": {"type": "numberchoice"},
                "equals": {"type": "numberchoicearray"},
                "is_null": {"type": "isnull"},
                "length": {"type": "number"},
                "not_contains": {"type": "numberchoice"},
                "not_equals": {"type": "numberchoicearray"},
                "not_length": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "length",
                "not_equals",
                "not_contains",
                "not_length",
                "is_null",
            ],
        },
        "regex": {
            "choices": [],
            "defaultLookup": None,
            "defaultSort": None,
            "defaultValue": ".*",
            "lookups": {},
            "sortedLookups": [],
        },
        "string": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": "",
            "lookups": {
                "contains": {"type": "string"},
                "ends_with": {"type": "string"},
                "equals": {"type": "string"},
                "is_null": {"type": "isnull"},
                "not_contains": {"type": "string"},
                "not_ends_with": {"type": "string"},
                "not_equals": {"type": "string"},
                "not_regex": {"type": "regex"},
                "not_starts_with": {"type": "string"},
                "regex": {"type": "regex"},
                "starts_with": {"type": "string"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "starts_with",
                "ends_with",
                "regex",
                "not_equals",
                "not_contains",
                "not_starts_with",
                "not_ends_with",
                "not_regex",
                "is_null",
            ],
        },
        "stringarray": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "contains": {"type": "string"},
                "equals": {"type": "stringarray"},
                "is_null": {"type": "isnull"},
                "length": {"type": "number"},
                "not_contains": {"type": "string"},
                "not_equals": {"type": "stringarray"},
                "not_length": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "length",
                "not_equals",
                "not_contains",
                "not_length",
                "is_null",
            ],
        },
        "stringchoice": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "equals": {"type": "stringchoice"},
                "is_null": {"type": "isnull"},
                "not_equals": {"type": "stringchoice"},
            },
            "sortedLookups": ["equals", "not_equals", "is_null"],
        },
        "stringchoicearray": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {
                "contains": {"type": "stringchoice"},
                "equals": {"type": "stringchoicearray"},
                "is_null": {"type": "isnull"},
                "length": {"type": "number"},
                "not_contains": {"type": "stringchoice"},
                "not_equals": {"type": "stringchoicearray"},
                "not_length": {"type": "number"},
            },
            "sortedLookups": [
                "equals",
                "contains",
                "length",
                "not_equals",
                "not_contains",
                "not_length",
                "is_null",
            ],
        },
        "unknown": {
            "choices": [],
            "defaultLookup": "is_null",
            "defaultSort": None,
            "defaultValue": None,
            "lookups": {"is_null": {"type": "isnull"}},
            "sortedLookups": ["is_null"],
        },
        "weekday": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": "Monday",
            "lookups": {
                "equals": {"type": "weekday"},
                "not_equals": {"type": "weekday"},
            },
            "sortedLookups": ["equals", "not_equals"],
        },
        "year": {
            "choices": [],
            "defaultLookup": "equals",
            "defaultSort": "asc",
            "defaultValue": 2020,
            "lookups": {
                "equals": {"type": "year"},
                "gt": {"type": "year"},
                "gte": {"type": "year"},
                "is_null": {"type": "isnull"},
                "lt": {"type": "year"},
                "lte": {"type": "year"},
                "not_equals": {"type": "year"},
            },
            "sortedLookups": [
                "equals",
                "not_equals",
                "gt",
                "gte",
                "lt",
                "lte",
                "is_null",
            ],
        },
    },
}

snapshots["test_query_csv_pivot_permutations[----] key"] = [[""]]

snapshots["test_query_csv_pivot_permutations[---b] key"] = [
    ["ID count", "Size max"],
    ["0.0", ""],
]

snapshots["test_query_csv_pivot_permutations[--c-] key"] = [
    ["Created time month"],
    [""],
]

snapshots["test_query_csv_pivot_permutations[--cb] key"] = [
    ["Created time month"],
    [""],
]

snapshots["test_query_csv_pivot_permutations[-r--] key"] = [["Created time year"]]

snapshots["test_query_csv_pivot_permutations[-r-b] key"] = [
    ["Created time year", "ID count", "Size max"]
]

snapshots["test_query_csv_pivot_permutations[-rc-] key"] = [
    ["Created time month"],
    ["Created time year"],
]

snapshots["test_query_csv_pivot_permutations[-rcb] key"] = [
    ["Created time month"],
    ["Created time year"],
]

snapshots["test_query_csv_pivot_permutations[d---] key"] = [[""]]

snapshots["test_query_csv_pivot_permutations[d--b] key"] = [
    ["ID count", "Size max"],
    ["6.0", "6.0"],
]

snapshots["test_query_csv_pivot_permutations[d-c-] key"] = [
    ["Created time month", "January", "Feburary"],
    [""],
    [""],
]

snapshots["test_query_csv_pivot_permutations[d-cb] key"] = [
    ["Created time month", "January", "", "Feburary", ""],
    ["", "ID count", "Size max", "ID count", "Size max"],
    ["", "4.0", "6.0", "2.0", "3.0"],
]

snapshots["test_query_csv_pivot_permutations[dr--] key"] = [
    ["Created time year"],
    ["2020.0"],
    ["2021.0"],
]

snapshots["test_query_csv_pivot_permutations[dr-b] key"] = [
    ["Created time year", "ID count", "Size max"],
    ["2020.0", "3.0", "3.0"],
    ["2021.0", "3.0", "6.0"],
]

snapshots["test_query_csv_pivot_permutations[drc-] key"] = [
    ["Created time month", "January", "Feburary"],
    ["Created time year"],
    ["2020.0"],
    ["2021.0"],
]

snapshots["test_query_csv_pivot_permutations[drcb] key"] = [
    ["Created time month", "January", "", "Feburary", ""],
    ["Created time year", "ID count", "Size max", "ID count", "Size max"],
    ["2020.0", "1.0", "1.0", "2.0", "3.0"],
    ["2021.0", "3.0", "6.0", "", ""],
]

snapshots["test_query_json data"] = {
    "body": [[{}, {}]],
    "cols": [{}],
    "fields": [
        {"pathStr": "size", "pivoted": False, "priority": 0, "sort": "dsc"},
        {"pathStr": "name", "pivoted": False, "priority": 1, "sort": "asc"},
        {"pathStr": "size_unit", "pivoted": False, "priority": None, "sort": None},
    ],
    "filterErrors": [None, None],
    "filters": [
        {"lookup": "lt", "pathStr": "size", "value": "2"},
        {"lookup": "gt", "pathStr": "id", "value": "0"},
    ],
    "formatHints": {
        "name": {},
        "size": {
            "decimalPlaces": 0,
            "highCutOff": 10000000000.0,
            "lowCutOff": 0.0001,
            "significantFigures": 3,
        },
        "size_unit": {},
    },
    "length": 2,
    "limit": 1000,
    "model": "core.Product",
    "rows": [
        {"name": "a", "size": 1.0, "size_unit": "g"},
        {"name": "b", "size": 1.0, "size_unit": "g"},
    ],
}

snapshots["test_query_json_pivot data"] = {
    "body": [
        [{"id__count": 1.0, "size__max": 1.0}, {"id__count": 3.0, "size__max": 6.0}],
        [{"id__count": 2.0, "size__max": 3.0}, None],
    ],
    "cols": [{"created_time__month": "January"}, {"created_time__month": "Feburary"}],
    "fields": [
        {
            "pathStr": "created_time__year",
            "pivoted": False,
            "priority": 0,
            "sort": "asc",
        },
        {
            "pathStr": "created_time__month",
            "pivoted": True,
            "priority": 1,
            "sort": "asc",
        },
        {"pathStr": "id__count", "pivoted": False, "priority": None, "sort": None},
        {"pathStr": "size__max", "pivoted": False, "priority": None, "sort": None},
    ],
    "filterErrors": [],
    "filters": [],
    "formatHints": {
        "created_time__month": {},
        "created_time__year": {
            "decimalPlaces": 0,
            "highCutOff": 10000000000.0,
            "lowCutOff": 0.0001,
            "significantFigures": 3,
        },
        "id__count": {
            "decimalPlaces": 0,
            "highCutOff": 10000000000.0,
            "lowCutOff": 0.0001,
            "significantFigures": 3,
        },
        "size__max": {
            "decimalPlaces": 0,
            "highCutOff": 10000000000.0,
            "lowCutOff": 0.0001,
            "significantFigures": 3,
        },
    },
    "length": 3,
    "limit": 1000,
    "model": "core.Product",
    "rows": [{"created_time__year": 2020.0}, {"created_time__year": 2021.0}],
}
