from pyopendart.enums import RenameMode

ENG_TO_ENG_RENAME_MAPPING = {
    'acc_mt': 'ending_month_of_fiscal_year',
    'account_detail': 'statement_of_changes_in_equity_column',
    'account_id': 'account_id',
    'account_nm': 'account_name',
    'acqs_mth1': 'acquisition_method_l',
    'acqs_mth2': 'acquisition_method_m',
    'acqs_mth3': 'acquisition_method_s',
    'adres': 'address',
    'avrg_cnwk_sdytrn': 'average_years_of_employment',
    'bfefrmtrm_amount': 'prev_prev_term_amount',
    'bfefrmtrm_dt': 'prev_prev_term_date',
    'bfefrmtrm_nm': 'prev_prev_term_name',
    'birth_ym': 'birth_year_month',
    'bizr_no': 'taxpayer_registration_number',
    'bsis_blce_acntbk_amount': 'term_start_book_value',
    'bsis_blce_qota_rt': 'term_start_shares_ratio',
    'bsis_blce_qy': 'term_start_quantity',
    'bsis_posesn_stock_co': 'term_start_quantity',
    'bsis_posesn_stock_qota_rt': 'term_start_shareholding_ratio',
    'bsis_qy': 'quantity_term_start',
    'bsns_de': 'applied_date',
    'bsns_year': 'business_year',
    'ceo_nm': 'representative',
    'change_cause': 'reason',
    'change_on': 'changed_at',
    'change_qy_acqs': 'acquired',
    'change_qy_dsps': 'disposed',
    'change_qy_incnr': 'retired',
    'chrg_job': 'charge',
    'cnttk_abacpt_labrr_co': 'part_time_contract_employees',
    'cnttk_co': 'contract_employees',
    'corp_cls': 'market',
    'corp_code': 'corporation_code',
    'corp_name': 'corporation_name',
    'corp_name_eng': 'corporation_name_en',
    'ctr_stkqy': 'contract_shares_quantity',
    'ctr_stkrt': 'contract_shares_ratio',
    'data_tp': 'data_type',
    'est_dt': 'establishment_date',
    'fax_no': 'fax_number',
    'flr_nm': 'filler',
    'fo_bbm': 'division',
    'frmtrm': 'prev_term',
    'frmtrm_add_amount': 'prev_term_cumulative_amount',
    'frmtrm_amount': 'prev_term_amount',
    'frmtrm_dt': 'prev_term_date',
    'frmtrm_nm': 'prev_term_name',
    'frmtrm_q_amount': 'prev_quarter_amount',
    'frmtrm_q_nm': 'prev_quarter_name',
    'frst_acqs_amount': 'first_acquired_amount',
    'frst_acqs_de': 'first_acquisition_date',
    'fs_div': 'division',
    'fs_nm': 'division_name',
    'fte_at': 'is_full_time',
    'fyer_salary_totamt': 'total_annual_salary',
    'hffc_pd': 'tenure',
    'hm_url': 'homepage_url',
    'hold_stock_co': 'minority_shares',
    'hold_stock_rate': 'minority_shares_ratio',
    'ifrs_ref': 'ifrs_ref',
    'incrs_dcrs_acqs_dsps_amount': 'acquired_or_disposed_amount',
    'incrs_dcrs_acqs_dsps_qy': 'acquired_or_disposed_quantity',
    'incrs_dcrs_evl_lstmn': 'gain_or_loss',
    'induty_code': 'industry_code',
    'inv_prm': 'invested_corporation_name',
    'invstmnt_purps': 'purpose',
    'ir_url': 'ir_url',
    'isu_dcrs_de': 'date',
    'isu_dcrs_mstvdv_amount': 'issue_price',
    'isu_dcrs_mstvdv_fval_amount': 'face_value',
    'isu_dcrs_qy': 'quantity',
    'isu_dcrs_stle': 'title',
    'isu_dcrs_stock_knd': 'stock_type',
    'isu_exctv_ofcps': 'position',
    'isu_exctv_rgist_at': 'is_registered',
    'isu_main_shrholdr': 'shareholder_detail',
    'jan_avrg_mendng_am': 'average',
    'jan_salary_am': 'average_annual_salary',
    'jurir_no': 'corporation_registration_number',
    'label_eng': 'label_en',
    'label_kor': 'label_ko',
    'lwfr': 'prev_prev_term',
    'main_career': 'career_info',
    'mendng_totamt': 'total',
    'mendng_totamt_ct_incls_mendng': 'compensation_not_included_in_total',
    'mxmm_shrholdr_nm': 'shareholder_name',
    'mxmm_shrholdr_relate': 'relation',
    'nm': 'name',
    'nmpr': 'headcount',
    'ofcps': 'position',
    'ord': 'account_order',
    'phn_no': 'phone_number',
    'posesn_stock_co': 'quantity',
    'qota_rt': 'ratio',
    'rcept_dt': 'receipt_date',
    'rcept_no': 'receipt_no',
    'recent_bsns_year_fnnr_sttus_thstrm_ntpf': 'last_recent_fiscal_year_net_income',
    'recent_bsns_year_fnnr_sttus_tot_assets': 'last_recent_fiscal_year_asset_total',
    'reform_bfe_emp_co_cnttk': 'legacy_contract_employees',
    'reform_bfe_emp_co_etc': 'legacy_other_employees',
    'reform_bfe_emp_co_rgllbr': 'legacy_regular_employees',
    'relate': 'relation',
    'report_nm': 'report_name',
    'report_resn': 'reason',
    'report_tp': 'major_shareholder_report_type',
    'repror': 'reporter',
    'reprt_code': 'report_type',
    'rgist_exctv_at': 'is_registered',
    'rgllbr_abacpt_labrr_co': 'part_time_regular_employees',
    'rgllbr_co': 'regular_employees',
    'rm': 'remarks',
    'se': 'title',
    'sexdstn': 'gender',
    'shrholdr_co': 'minority_shareholders',
    'shrholdr_rate': 'minority_shareholders_ratio',
    'shrholdr_tot_co': 'total_shareholders',
    'sj_div': 'type',
    'sj_nm': 'type_name',
    'sm': 'total_employees_count',
    'sp_stock_lmp_cnt': 'shares_quantity',
    'sp_stock_lmp_irds_cnt': 'increased_or_decreased_quantity',
    'sp_stock_lmp_irds_rate': 'increased_or_decreased_ratio',
    'sp_stock_lmp_rate': 'shares_ratio',
    'stkqy': 'shares_quantity',
    'stkqy_irds': 'increased_or_decreased_quantity',
    'stkrt': 'shares_ratio',
    'stkrt_irds': 'increased_or_decreased_ratio',
    'stock_name': 'stock_name',
    'stock_code': 'stock_code',
    'stock_knd': 'stock_type',
    'stock_tot_co': 'total_shares',
    'tenure_end_on': 'tenure_end_date',
    'thstrm': 'current_term',
    'thstrm_add_amount': 'current_term_cumulative_amount',
    'thstrm_amount': 'current_term_amount',
    'thstrm_dt': 'current_term_date',
    'thstrm_nm': 'current_term_name',
    'trmend_blce_acntbk_amount': 'term_end_book_value',
    'trmend_blce_qota_rt': 'term_end_shares_ratio',
    'trmend_blce_qy': 'term_end_quantity',
    'trmend_posesn_stock_co': 'term_end_quantity',
    'trmend_posesn_stock_qota_rt': 'term_end_shareholding_ratio',
    'trmend_qy': 'quantity_term_end',
}
ENG_TO_KOR_RENAME_MAPPING = {
    'acc_mt': '결산월',
    'account_detail': '자본변동표 상세',
    'account_id': '계정ID',
    'account_nm': '계정명',
    'acqs_mth1': '취득방법 대분류',
    'acqs_mth2': '취득방법 중분류',
    'acqs_mth3': '취득방법 소분류',
    'adres': '주소',
    'avrg_cnwk_sdytrn': '평균 근속 연수',
    'bfefrmtrm_amount': '전전기금액',
    'bfefrmtrm_dt': '전전기일자',
    'bfefrmtrm_nm': '전전기명',
    'birth_ym': '출생년월',
    'bizr_no': '사업자등록번호',
    'bsis_blce_acntbk_amount': '기초 장부가액',
    'bsis_blce_qota_rt': '기초 지분율',
    'bsis_blce_qy': '기초 주식수',
    'bsis_posesn_stock_co': '기초 주식수',
    'bsis_posesn_stock_qota_rt': '기초 지분율',
    'bsis_qy': '기초 수량',
    'bsns_de': '기준일',
    'bsns_year': '사업연도',
    'ceo_nm': '대표자명',
    'change_cause': '변동원인',
    'change_on': '변동일',
    'change_qy_acqs': '취득 수량',
    'change_qy_dsps': '처분 수량',
    'change_qy_incnr': '소각 소량',
    'chrg_job': '담당 업무',
    'cnttk_abacpt_labrr_co': '계약직 단시간 근로자 수',
    'cnttk_co': '계약직 수',
    'corp_cls': '법인구분',
    'corp_code': '고유번호',
    'corp_name': '회사명',
    'corp_name_eng': '영문회사명',
    'ctr_stkqy': '주요체결 주식수',
    'ctr_stkrt': '주요체결 지분율',
    'data_tp': '데이터 유형',
    'est_dt': '설립일',
    'fax_no': '팩스번호',
    'flr_nm': '공시 제출인명',
    'fo_bbm': '사업부',
    'frmtrm': '전기',
    'frmtrm_add_amount': '전기누적금액',
    'frmtrm_amount': '전기금액',
    'frmtrm_dt': '전기일자',
    'frmtrm_nm': '전기명',
    'frmtrm_q_amount': '전기금액 (분/반기)',
    'frmtrm_q_nm': '전기명 (분/반기)',
    'frst_acqs_amount': '최초 취득금액',
    'frst_acqs_de': '최초 취득일자',
    'fs_div': '개별/연결 구분',
    'fs_nm': '개별/연결명',
    'fte_at': '상근 여부',
    'fyer_salary_totamt': '연간 급여 총액',
    'hffc_pd': '임기',
    'hm_url': '홈페이지',
    'hold_stock_co': '보유 주식수',
    'hold_stock_rate': '보유 주식 비율',
    'ifrs_ref': 'IFRS 참조',
    'incrs_dcrs_acqs_dsps_amount': '증감 금액',
    'incrs_dcrs_acqs_dsps_qy': '중감 주식수',
    'incrs_dcrs_evl_lstmn': '증감 평가손익',
    'induty_code': '업종코드',
    'inv_prm': '법인명',
    'invstmnt_purps': '출자 목적',
    'ir_url': 'IR홈페이지',
    'isu_dcrs_de': '증감 일자',
    'isu_dcrs_mstvdv_amount': '증감 주당 가액',
    'isu_dcrs_mstvdv_fval_amount': '증감 주당 액면 가액',
    'isu_dcrs_qy': '증감 수량',
    'isu_dcrs_stle': '증감 형태',
    'isu_dcrs_stock_knd': '증감 주식 종류',
    'isu_exctv_ofcps': '직위',
    'isu_exctv_rgist_at': '등기임원 여부',
    'isu_main_shrholdr': '주주상세',
    'jan_avrg_mendng_am': '평균 보수액',
    'jan_salary_am': '평균 급여액',
    'jurir_no': '법인등록번호',
    'label_eng': '영문 출력명',
    'label_kor': '한글 출력명',
    'lwfr': '전전기',
    'main_career': '주요 경력',
    'mendng_totamt': '보수 총액',
    'mendng_totamt_ct_incls_mendng': '보수 총액 미포함 보수',
    'mxmm_shrholdr_nm': '성명',
    'mxmm_shrholdr_relate': '관계',
    'nm': '성명',
    'nmpr': '인원수',
    'ofcps': '직위',
    'ord': '계정과목 정렬순서',
    'phn_no': '전화번호',
    'posesn_stock_co': '주식수',
    'qota_rt': '지분율',
    'rcept_dt': '접수일자',
    'rcept_no': '접수번호',
    'recent_bsns_year_fnnr_sttus_thstrm_ntpf': '최근 사업연도 당기순이익',
    'recent_bsns_year_fnnr_sttus_tot_assets': '최근 사업연도 총자산',
    'reform_bfe_emp_co_cnttk': '개정전 계약직 수',
    'reform_bfe_emp_co_etc': '개정전 기타 직원 수',
    'reform_bfe_emp_co_rgllbr': '개정전 정규직 수',
    'relate': '관계',
    'report_nm': '보고서명',
    'report_resn': '보고사유',
    'report_tp': '보고구분',
    'repror': '대표보고자',
    'reprt_code': '보고서 코드',
    'rgist_exctv_at': '등기임원 여부',
    'rgllbr_abacpt_labrr_co': '정규직 단시간 근로자 수',
    'rgllbr_co': '정규직 수',
    'rm': '비고',
    'se': '구분',
    'sexdstn': '성별',
    'shrholdr_co': '주주수',
    'shrholdr_rate': '주주 비율',
    'shrholdr_tot_co': '전체 주주수',
    'sj_div': '재무제표 구분',
    'sj_nm': '재무제표명',
    'sm': '합계',
    'sp_stock_lmp_cnt': '주식수',
    'sp_stock_lmp_irds_cnt': '증감 주식수',
    'sp_stock_lmp_irds_rate': '증감 지분율',
    'sp_stock_lmp_rate': '지분율',
    'stkqy': '주식수',
    'stkqy_irds': '증감 주식수',
    'stkrt': '지분율',
    'stkrt_irds': '증감 지분율',
    'stock_code': '종목코드',
    'stock_knd': '주식 종류',
    'stock_name': '종목명',
    'stock_tot_co': '총발행 주식수',
    'tenure_end_on': '임기 만료일',
    'thstrm': '당기',
    'thstrm_add_amount': '당기누적금액',
    'thstrm_amount': '당기금액',
    'thstrm_dt': '당기일자',
    'thstrm_nm': '당기명',
    'trmend_blce_acntbk_amount': '기말 장부가액',
    'trmend_blce_qota_rt': '기말 지분율',
    'trmend_blce_qy': '기말 주식수',
    'trmend_posesn_stock_co': '기말 주식수',
    'trmend_posesn_stock_qota_rt': '기말 지분율',
    'trmend_qy': '기말 수량',
}

RENAME_MAPPINGS = {
    RenameMode.ENG: ENG_TO_ENG_RENAME_MAPPING,
    RenameMode.KOR: ENG_TO_KOR_RENAME_MAPPING,
}

KNOWN_NUMERIC_FIELDS = {
    'acc_mt',
    'bfefrmtrm_amount',
    'bizr_no',
    'bsis_blce_acntbk_amount',
    'bsis_blce_qota_rt',
    'bsis_blce_qy',
    'bsis_posesn_stock_co',
    'bsis_posesn_stock_qota_rt',
    'bsis_qy',
    'bsns_year',
    'change_qy_acqs',
    'change_qy_dsps',
    'change_qy_incnr',
    'cnttk_abacpt_labrr_co',
    'cnttk_co',
    'ctr_stkqy',
    'ctr_stkrt',
    'frmtrm',
    'frmtrm_add_amount',
    'frmtrm_amount',
    'frmtrm_q_amount',
    'frst_acqs_amount',
    'fyer_salary_totamt',
    'hold_stock_co',
    'incrs_dcrs_acqs_dsps_amount',
    'incrs_dcrs_acqs_dsps_qy',
    'incrs_dcrs_evl_lstmn',
    'induty_code',
    'isu_dcrs_mstvdv_amount',
    'isu_dcrs_mstvdv_fval_amount',
    'isu_dcrs_qy',
    'jan_avrg_mendng_am',
    'jan_salary_am',
    'jurir_no',
    'lwfr',
    'mendng_totamt',
    'mendng_totamt_ct_incls_mendng',
    'nmpr',
    'ord',
    'posesn_stock_co',
    'recent_bsns_year_fnnr_sttus_thstrm_ntpf',
    'recent_bsns_year_fnnr_sttus_tot_assets',
    'reform_bfe_emp_co_cnttk',
    'reform_bfe_emp_co_etc',
    'reform_bfe_emp_co_rgllbr',
    'rgllbr_abacpt_labrr_co',
    'rgllbr_co',
    'shrholdr_co',
    'shrholdr_tot_co',
    'sm',
    'sp_stock_lmp_cnt',
    'sp_stock_lmp_irds_cnt',
    'sp_stock_lmp_irds_rate',
    'sp_stock_lmp_rate',
    'stkqy',
    'stkqy_irds',
    'stkrt',
    'stkrt_irds',
    'stock_tot_co',
    'thstrm',
    'thstrm_add_amount',
    'thstrm_amount',
    'trmend_blce_acntbk_amount',
    'trmend_blce_qota_rt',
    'trmend_blce_qy',
    'trmend_posesn_stock_co',
    'trmend_posesn_stock_qota_rt',
    'trmend_qy',
}
KNOWN_RATIO_FIELDS = {"qota_rt", "shrholdr_rate", "hold_stock_rate"}
KNOWN_DATE_FIELDS = {"rcept_dt", "est_dt", "isu_dcrs_de", "change_on", "tenure_end_on", "frst_acqs_de", "bsns_de"}
