# mypy-boto3-swf

[![PyPI - mypy-boto3-swf](https://img.shields.io/pypi/v/mypy-boto3-swf.svg?color=blue)](https://pypi.org/project/mypy-boto3-swf)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-swf.svg?color=blue)](https://pypi.org/project/mypy-boto3-swf)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.SWF 1.14.46](https://boto3.amazonaws.com/v1/documentation/api/1.14.46/reference/services/swf.html#SWF) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.2.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

## How to install

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `SWF` service.

```bash
python -m pip install boto3-stubs[swf]
```

## How to use

### Client annotations

`SWFClient` provides annotations for `boto3.client("swf")`.

```python
import boto3

from mypy_boto3_swf import SWFClient
from mypy_boto3_swf.paginator import (
    GetWorkflowExecutionHistoryPaginator,
    ListActivityTypesPaginator,
    ListClosedWorkflowExecutionsPaginator,
    ListDomainsPaginator,
    ListOpenWorkflowExecutionsPaginator,
    ListWorkflowTypesPaginator,
    PollForDecisionTaskPaginator,
)
from mypy_boto3_swf.type_defs import ActivityTaskCancelRequestedEventAttributesTypeDef, ...

client: SWFClient = boto3.client("swf")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: SWFClient = session.client("swf")
```

### Paginators annotations

`mypy_boto3_swf.paginator` module contains type annotations for all paginators.

```python

client: SWFClient = boto3.client("swf")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_workflow_execution_history_paginator: GetWorkflowExecutionHistoryPaginator = client.get_paginator("get_workflow_execution_history")
list_activity_types_paginator: ListActivityTypesPaginator = client.get_paginator("list_activity_types")
list_closed_workflow_executions_paginator: ListClosedWorkflowExecutionsPaginator = client.get_paginator("list_closed_workflow_executions")
list_domains_paginator: ListDomainsPaginator = client.get_paginator("list_domains")
list_open_workflow_executions_paginator: ListOpenWorkflowExecutionsPaginator = client.get_paginator("list_open_workflow_executions")
list_workflow_types_paginator: ListWorkflowTypesPaginator = client.get_paginator("list_workflow_types")
poll_for_decision_task_paginator: PollForDecisionTaskPaginator = client.get_paginator("poll_for_decision_task")
```







### Typed dictionations

`mypy_boto3_swf.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python

def get_structure() -> ActivityTaskCancelRequestedEventAttributesTypeDef:
    return {
      ...
    }
```


## Dynamic type annotations

`mypy_boto3` command generates `boto3.client/resource` type annotations for
`mypy_boto3_swf` and other installed services.

```bash
# Run this command after you add or remove service packages
python -m mypy_boto3
```

Generated type annotations provide overloads for `boto3.client` and `boto3.resource`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully if you have many services installed
- `VSCode` does not currently support function overloads, use explicit type annotations

```python

# Type is discovered correctly by mypy and PyCharm
# VSCode still needs explicit type annotations
client = boto3.client("swf")

session_client = boto3.Session().client("swf")
```
