/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api.frames.internal;

import java.util.HashMap;
import java.util.Map;
import oracle.pgx.api.frames.internal.EdgeFrameDeclaration;
import oracle.pgx.api.frames.internal.VertexFrameDeclaration;

public class GraphFrameDeclaration {
    private String graphName;
    private Map<String, VertexFrameDeclaration> vertexFrames;
    private Map<String, EdgeFrameDeclaration> edgeFrames;
    private boolean partitioned;

    public GraphFrameDeclaration() {
    }

    public GraphFrameDeclaration(String graphName) {
        this.graphName = graphName;
        this.vertexFrames = new HashMap<String, VertexFrameDeclaration>();
        this.edgeFrames = new HashMap<String, EdgeFrameDeclaration>();
    }

    public String getGraphName() {
        return this.graphName;
    }

    public void setGraphName(String graphName) {
        this.graphName = graphName;
    }

    public boolean isPartitioned() {
        return this.partitioned;
    }

    public void setPartitioned(boolean partitioned) {
        this.partitioned = partitioned;
    }

    public Map<String, VertexFrameDeclaration> getVertexFrames() {
        return this.vertexFrames;
    }

    public void setVertexFrames(Map<String, VertexFrameDeclaration> vertexFrames) {
        this.vertexFrames = vertexFrames;
    }

    public void addVertexFrameDeclaration(VertexFrameDeclaration declaration) {
        this.vertexFrames.put(declaration.getVertexTableName(), declaration);
    }

    public Map<String, EdgeFrameDeclaration> getEdgeFrames() {
        return this.edgeFrames;
    }

    public void setEdgeFrames(Map<String, EdgeFrameDeclaration> edgeFrames) {
        this.edgeFrames = edgeFrames;
    }

    public void addEdgeFrameDeclaration(EdgeFrameDeclaration declaration) {
        this.edgeFrames.put(declaration.getEdgeTableName(), declaration);
    }
}

