/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.Deque;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import oracle.pgx.api.DefaultFutureProgress;
import oracle.pgx.api.FutureProgress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgxFuture<T>
extends CompletableFuture<T> {
    private static final Logger LOG = LoggerFactory.getLogger(PgxFuture.class);
    private boolean started = false;
    private boolean consumed = false;
    private final ConcurrentLinkedDeque<PgxFuture<?>> parents = new ConcurrentLinkedDeque();

    public static <T> PgxFuture<Void> allOf(List<PgxFuture<T>> promises) {
        CompletableFuture<Void> completableFuture = CompletableFuture.allOf(promises.toArray(new PgxFuture[0]));
        PgxFuture<Void> promise = new PgxFuture<Void>();
        completableFuture.whenComplete(promise::completeWithResultOrException);
        return promise;
    }

    public static <T> PgxFuture<T> completedFuture(@Nullable T arg) {
        PgxFuture<T> promise = new PgxFuture<T>();
        promise.complete(arg);
        return promise;
    }

    public static <T> PgxFuture<T> exceptionallyCompletedFuture(Throwable throwable) {
        PgxFuture<T> promise = new PgxFuture<T>();
        promise.completeExceptionally(throwable);
        return promise;
    }

    private void completeWithResultOrException(T result, Throwable throwable) {
        if (throwable == null) {
            this.complete(result);
        } else {
            this.completeExceptionally(throwable);
        }
    }

    @Override
    public <U> PgxFuture<U> thenApply(Function<? super T, ? extends U> function) {
        CompletionStage completableFuture = super.thenApply((Function)function);
        PgxFuture<T> pgxFuture = new PgxFuture<T>();
        super.addParent(this);
        ((CompletableFuture)completableFuture).whenComplete(pgxFuture::completeWithResultOrException);
        return pgxFuture;
    }

    private <U> void addParent(PgxFuture<U> parent) {
        this.parents.add(parent);
    }

    @Override
    public <U> PgxFuture<U> thenApplyAsync(Function<? super T, ? extends U> function, Executor executor) {
        CompletionStage completableFuture = super.thenApplyAsync((Function)function, executor);
        PgxFuture<T> pgxFuture = new PgxFuture<T>();
        super.addParent(this);
        ((CompletableFuture)completableFuture).whenComplete(pgxFuture::completeWithResultOrException);
        return pgxFuture;
    }

    @Override
    public <U, V> PgxFuture<V> thenCombine(CompletableFuture<? extends U> other, BiFunction<? super T, ? super U, ? extends V> function) {
        CompletionStage completableFuture = super.thenCombine(other, (BiFunction)function);
        PgxFuture<T> pgxFuture = new PgxFuture<T>();
        super.addParent(this);
        ((CompletableFuture)completableFuture).whenComplete(pgxFuture::completeWithResultOrException);
        return pgxFuture;
    }

    public <U> PgxFuture<U> thenReturn(U result) {
        return this.thenApply((T t) -> result);
    }

    @Override
    public T get() throws InterruptedException, ExecutionException {
        try {
            Object action = super.get();
            this.consumed = true;
            return action;
        }
        catch (InterruptedException | ThreadDeath e) {
            try {
                this.cancel();
            }
            catch (Exception cancelException) {
                e.addSuppressed(cancelException);
            }
            throw e;
        }
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            Object action = super.get(timeout, unit);
            this.consumed = true;
            return action;
        }
        catch (InterruptedException | ThreadDeath e) {
            try {
                this.cancel();
            }
            catch (Exception cancelException) {
                e.addSuppressed(cancelException);
            }
            throw e;
        }
    }

    @Override
    public T getNow(T valueIfAbsent) {
        T action = super.getNow(valueIfAbsent);
        this.consumed = true;
        return action;
    }

    @Override
    public T join() {
        Object action = super.join();
        this.consumed = true;
        return action;
    }

    public PgxFuture<Void> thenAccept(Consumer<? super T> block) {
        CompletionStage completableFuture = super.thenAccept((Consumer)block);
        PgxFuture<Void> pgxFuture = new PgxFuture<Void>();
        super.addParent(this);
        ((CompletableFuture)completableFuture).whenComplete(pgxFuture::completeWithResultOrException);
        return pgxFuture;
    }

    @Override
    public <U> PgxFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        CompletionStage completableFuture = super.handle((BiFunction)fn);
        PgxFuture<T> pgxFuture = new PgxFuture<T>();
        super.addParent(this);
        ((CompletableFuture)completableFuture).whenComplete(pgxFuture::completeWithResultOrException);
        return pgxFuture;
    }

    @Override
    public <U> PgxFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> function) {
        PgxFuture pgxFuture = new PgxFuture();
        super.addParent(this);
        CompletionStage completableFuture = super.thenCompose(function.andThen(result -> {
            if (result instanceof PgxFuture) {
                pgxFuture.addParent((PgxFuture)result);
            }
            return result;
        }));
        ((CompletableFuture)completableFuture).whenComplete(pgxFuture::completeWithResultOrException);
        return pgxFuture;
    }

    @Override
    public PgxFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        CompletionStage completableFuture = super.exceptionally((Function)fn);
        PgxFuture<T> pgxFuture = new PgxFuture<T>();
        ((CompletableFuture)completableFuture).whenComplete(pgxFuture::completeWithResultOrException);
        return pgxFuture;
    }

    public PgxFuture<T> thenComplete(PgxFuture<T> promise) {
        return this.thenComplete(promise, null);
    }

    public PgxFuture<T> thenComplete(PgxFuture<T> promise, Runnable cleanup) {
        super.addParent(this);
        ((PgxFuture)this.thenAccept((T arg) -> {
            if (promise.isDone()) {
                return;
            }
            if (cleanup != null) {
                cleanup.run();
            }
            promise.complete(arg);
        })).exceptionally((T throwable) -> {
            try {
                if (promise.isDone()) {
                    Void void_ = null;
                    return void_;
                }
                if (cleanup != null) {
                    cleanup.run();
                }
                if (throwable.getClass() == CompletionException.class) {
                    throwable = throwable.getCause();
                }
            }
            catch (Throwable caughtThrowable) {
                LOG.error("hit exception during cleanup", caughtThrowable);
            }
            finally {
                promise.completeExceptionally((Throwable)throwable);
            }
            return null;
        });
        return promise;
    }

    public boolean cancel() {
        return this.cancel(true);
    }

    public PgxFuture<T> cancelOn(PgxFuture promise) {
        promise.exceptionally((T throwable) -> {
            if (this.isCancelled()) {
                LOG.debug("cancellation already triggered of {}", (Object)this);
                return null;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} completed exceptionally (cause {})", (Object)promise, (Object)throwable.getClass().getSimpleName());
            }
            if (throwable instanceof CancellationException) {
                long startTime = System.currentTimeMillis();
                LOG.debug("trigger cancellation of {} at {}", (Object)this, (Object)startTime);
                boolean success = this.cancel(true);
                long endTime = System.currentTimeMillis();
                LOG.debug("cancellation returned {}, took {}ms", (Object)success, (Object)(endTime - startTime));
            }
            if (this.started || this.isDone()) {
                LOG.debug("{} either already started or is done -> rollback", (Object)this);
                this.rollback();
            }
            return null;
        });
        return this;
    }

    protected void rollback() {
    }

    protected void onBeginExec() {
        this.started = true;
    }

    protected void onDoneExec() {
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    private Deque<PgxFuture<?>> getParents() {
        return this.parents;
    }

    private Optional<PgxFuture<?>> getFirstActiveParent() {
        PgxFuture<?> parent = this.getParents().pollLast();
        if (parent == null || parent.isDone()) {
            return Optional.empty();
        }
        if (parent != null && !parent.isDone()) {
            this.getParents().add(parent);
        }
        return Optional.ofNullable(parent);
    }

    public FutureProgress getProgress() {
        Optional<PgxFuture<?>> firstActiveParent = this.getFirstActiveParent();
        if (firstActiveParent.isPresent()) {
            PgxFuture<?> parent = firstActiveParent.get();
            LOG.trace("{} is returning parents progress: {}", (Object)this, parent);
            return parent.getProgress();
        }
        if (this.isDone()) {
            return new DefaultFutureProgress(DefaultFutureProgress.State.DONE);
        }
        return new DefaultFutureProgress(DefaultFutureProgress.State.STARTING);
    }
}

