/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.api;

import java.util.concurrent.ExecutionException;
import oracle.pgx.api.EdgeBuilder;
import oracle.pgx.api.EdgeModifier;
import oracle.pgx.api.GraphBuilder;
import oracle.pgx.api.PgxFuture;
import oracle.pgx.api.PgxGraph;
import oracle.pgx.api.VertexBuilder;
import oracle.pgx.api.VertexModifier;
import oracle.pgx.common.types.ChangeType;
import oracle.pgx.config.OnAddExistingElement;
import oracle.pgx.config.OnInvalidChange;
import oracle.pgx.config.OnRequiredConversion;

public interface GraphChangeSet<VID>
extends GraphBuilder<VID> {
    @Override
    public VertexBuilder<VID> addVertex(VID var1);

    @Override
    public VertexBuilder<VID> addVertex();

    @Override
    public EdgeBuilder<VID> addEdge(long var1, VID var3, VID var4);

    @Override
    public EdgeBuilder<VID> addEdge(String var1, VID var2, VID var3);

    @Override
    public EdgeBuilder<VID> addEdge(long var1, VertexBuilder<VID> var3, VertexBuilder<VID> var4);

    @Override
    public EdgeBuilder<VID> addEdge(String var1, VertexBuilder<VID> var2, VertexBuilder<VID> var3);

    public GraphChangeSet<VID> removeVertex(VID var1);

    public GraphChangeSet<VID> removeEdge(long var1);

    public GraphChangeSet<VID> removeEdge(String var1);

    public VertexModifier<VID> updateVertex(VID var1);

    public EdgeModifier<VID> updateEdge(long var1);

    public EdgeModifier<VID> updateEdge(String var1);

    public GraphChangeSet<VID> setAddExistingVertexPolicy(OnAddExistingElement var1);

    public GraphChangeSet<VID> setInvalidChangePolicy(OnInvalidChange var1);

    public GraphChangeSet<VID> setRequiredConversionPolicy(OnRequiredConversion var1);

    public GraphChangeSet<VID> setAddExistingEdgePolicy(OnAddExistingElement var1);

    @Override
    public GraphChangeSet<VID> resetVertex(VID var1);

    @Override
    public GraphChangeSet<VID> resetVertex(VertexBuilder<VID> var1);

    @Override
    public GraphChangeSet<VID> resetEdge(long var1);

    @Override
    public GraphChangeSet<VID> resetEdge(String var1);

    @Override
    default public GraphChangeSet<VID> setRetainEdgeIds(boolean retainEdgeIds) {
        GraphBuilder.super.setRetainEdgeIds(retainEdgeIds);
        return this;
    }

    @Override
    default public GraphChangeSet<VID> setRetainVertexIds(boolean retainVertexIds) {
        GraphBuilder.super.setRetainVertexIds(retainVertexIds);
        return this;
    }

    @Override
    default public GraphChangeSet<VID> setRetainIds(boolean retainIds) {
        GraphBuilder.super.setRetainIds(retainIds);
        return this;
    }

    public PgxFuture<PgxGraph> buildNewSnapshotAsync();

    default public PgxGraph buildNewSnapshot() throws ExecutionException, InterruptedException {
        return this.buildNewSnapshotAsync().get();
    }

    public ChangeType getVertexChangeType(VID var1);

    public ChangeType getEdgeChangeType(Object var1);
}

