/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql.pgview.translation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.pg.rdbms.pgql.pgview.translation.GraphPatternTranslator;
import oracle.pg.rdbms.pgql.pgview.translation.SubqueryVisitor;
import oracle.pgql.lang.ir.GraphPattern;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.QueryExpressionVisitor;
import oracle.pgql.lang.ir.QueryVariable;

class OuterExpressionsGetter
extends SubqueryVisitor {
    private final Map<String, QueryVariable> variables;
    private final Set<String> outerVariables;
    private final Map<String, Set<QueryExpression>> outerExpressions;

    public OuterExpressionsGetter(Map<String, QueryVariable> variables, Set<String> outerVariables) {
        this.variables = variables;
        this.outerVariables = outerVariables;
        this.outerExpressions = new HashMap<String, Set<QueryExpression>>();
    }

    private void checkOuterVariable(String varName, QueryExpression queryExpression) {
        if (!this.variables.containsKey(varName) && this.outerVariables.contains(varName)) {
            if (!this.outerExpressions.containsKey(varName)) {
                this.outerExpressions.put(varName, new HashSet());
            }
            this.outerExpressions.get(varName).add(queryExpression);
        }
    }

    @Override
    public void visitVarRef(QueryExpression.VarRef varRef) {
        if (GraphPatternTranslator.isVertexOrEdgeReference(varRef)) {
            this.checkOuterVariable(varRef.getVariable().getName(), (QueryExpression)varRef);
        }
    }

    @Override
    public void visitPropertyAccess(QueryExpression.PropertyAccess propertyAccess) {
        this.checkOuterVariable(propertyAccess.getVariable().getName(), (QueryExpression)propertyAccess);
    }

    @Override
    public void visitIdOrLabelFunction(QueryExpression.FunctionCall functionCall) {
        QueryVariable var = ((QueryExpression.VarRef)functionCall.getArgs().get(0)).getVariable();
        this.checkOuterVariable(var.getName(), (QueryExpression)functionCall);
    }

    @Override
    public void visitKeyColumnsFunction(QueryExpression.FunctionCall functionCall) {
    }

    @Override
    public void visitVarRefSubqueryFunction(QueryExpression.FunctionCall functionCall) {
    }

    @Override
    public void visitIsSourceOrIsDestOfFunction(QueryExpression.FunctionCall functionCall) {
    }

    @Override
    public void visitHasLabelFunction(QueryExpression.FunctionCall functionCall) {
        QueryVariable var = ((QueryExpression.VarRef)functionCall.getArgs().get(0)).getVariable();
        this.checkOuterVariable(var.getName(), (QueryExpression)functionCall);
    }

    @Override
    public void visitAggregation(QueryExpression.Aggregation.AbstractAggregation agg) {
        Map<String, Set<QueryExpression>> aggOutVars = OuterExpressionsGetter.getOuterExpressions(agg.getExp(), this.variables, this.outerVariables);
        for (String aggOutVar : aggOutVars.keySet()) {
            if (!this.outerExpressions.containsKey(aggOutVar)) {
                this.outerExpressions.put(aggOutVar, new HashSet());
            }
            this.outerExpressions.get(aggOutVar).add((QueryExpression)agg);
        }
    }

    public static Map<String, Set<QueryExpression>> getOuterExpressions(QueryExpression queryExpression, Map<String, QueryVariable> variables, Set<String> outerVariables) {
        OuterExpressionsGetter outerExpressionsGetter = new OuterExpressionsGetter(variables, outerVariables);
        queryExpression.accept((QueryExpressionVisitor)outerExpressionsGetter);
        return outerExpressionsGetter.outerExpressions;
    }

    public static Map<String, Set<QueryExpression>> getOuterExpressions(GraphPattern graphPattern, Map<String, QueryVariable> variables, Set<String> validVariables) {
        OuterExpressionsGetter outerExpressionsGetter = new OuterExpressionsGetter(variables, validVariables);
        graphPattern.accept((QueryExpressionVisitor)outerExpressionsGetter);
        return outerExpressionsGetter.outerExpressions;
    }
}

