/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.CallableStatement;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import oracle.jdbc.OraclePreparedStatement;
import oracle.pg.rdbms.pgql.BindValueInfo;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.ExecutionInfo;
import oracle.pg.rdbms.pgql.GraphType;
import oracle.pg.rdbms.pgql.ModifyContext;
import oracle.pg.rdbms.pgql.PgSchemaResultSet;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlCreatePgUtils;
import oracle.pg.rdbms.pgql.PgqlPreparedStatement;
import oracle.pg.rdbms.pgql.PgqlResultSet;
import oracle.pg.rdbms.pgql.PgqlResultSetImpl;
import oracle.pg.rdbms.pgql.PgqlSqlCreateTrans;
import oracle.pg.rdbms.pgql.PgqlSqlCreateTransImpl;
import oracle.pg.rdbms.pgql.PgqlSqlDropTrans;
import oracle.pg.rdbms.pgql.PgqlSqlDropTransImpl;
import oracle.pg.rdbms.pgql.PgqlSqlModifyTrans;
import oracle.pg.rdbms.pgql.PgqlSqlModifyTransImpl;
import oracle.pg.rdbms.pgql.PgqlSqlQueryTrans;
import oracle.pg.rdbms.pgql.PgqlSqlQueryTransImpl;
import oracle.pg.rdbms.pgql.PgqlSqlTrans;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlTranslator;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pg.rdbms.pgql.pgsql.PgSqlDdlExecution;
import oracle.pg.rdbms.pgql.pgview.GraphMetadataHandler;
import oracle.pg.rdbms.pgql.pgview.PgViewDdlExecution;
import oracle.pg.rdbms.pgql.pgview.PgViewDmlExecution;
import oracle.pg.rdbms.pgql.pgview.PgViewModifyTrans;
import oracle.pg.rdbms.pgql.pgview.PgViewResultSet;
import oracle.pg.rdbms.pgql.pgview.metadata.MetadataRefreshTimes;
import oracle.pg.rdbms.pgql.pgview.metadata.TranslationCache;
import oracle.pg.rdbms.pgql.pgview.metadata.TranslationCacheValue;
import oracle.pg.rdbms.pgql.pgview.util.Pair;
import oracle.pgql.lang.PgqlException;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.sql.TIMESTAMPTZ;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgqlExecution
implements PgqlPreparedStatement {
    private static final Logger ms_log = LoggerFactory.getLogger(PgqlExecution.class);
    private static final Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
    private static final String OPTIONS_BIND_VAR = ":options_str";
    private static final String SKIP_INDEX_FLAG = "SKIP_INDEX=T";
    private static final String SKIP_TABLE_FLAG = "SKIP_TABLE=T";
    private final QueryContext ctx;
    private final ModifyContext modifyCtx;
    private final PgqlTranslator pt;
    private String pgql;
    private BindValueInfo bvInfo;
    private boolean translated;
    private boolean parsed;
    private boolean prepared;
    private int prepareTimeout;
    private int prepareParallel;
    private int prepareDS;
    private int prepareMaxResults;
    private String translateMatchOptions;
    private String translateOptions;
    private PgViewDmlExecution dmlExecution;
    private static TranslationCache translationCache;
    private PgqlSqlTrans sqlTrans;
    private int fetchSize = 1000;
    private int batchSize = 500;
    private long rsCntr;
    private final Map<Long, PgqlResultSet> rsMap;
    private ExecutionInfo executionInfo;
    private String nvarcharKLSize;
    private String nvarcharVSize;
    public static final String USER_REQUESTED_CANCEL_ERROR = "User requested cancel of current operation";
    private static final String AUTO_COMMIT_MODIFY_ERROR = "Connection auto-commit should be off for modify";

    PgqlExecution(PgqlConnection pgqlConn) {
        this(pgqlConn, "");
    }

    PgqlExecution(PgqlConnection pgqlConn, String pgql) {
        this(pgqlConn, pgql, 0, 0, 2, -1, null, null);
    }

    PgqlExecution(PgqlConnection pgqlConn, String pgql, int timeout, int parallel, int dynamicSampling, int maxResults, String matchOptions, String options) {
        this.ctx = QueryContext.getQueryContext(pgqlConn);
        this.modifyCtx = ModifyContext.getModifyContext(pgqlConn);
        this.pt = PgqlTranslator.getPgqlTranslator(this.ctx);
        this.initQuery(pgql);
        this.rsCntr = 0L;
        this.rsMap = new HashMap<Long, PgqlResultSet>();
        this.executionInfo = new ExecutionInfo();
        PgqlExecution.initTranslationCache();
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Constructing new PGQL Execution:");
            ms_log.debug(" pgql=[" + this.pgql + "] ");
        }
        if (this.pgql != null && !this.pgql.isEmpty()) {
            try {
                if (this.isNotCachedTranslation(matchOptions, options)) {
                    this.parseAndSetOptions(matchOptions, options);
                    if (this.ctx.graphType == GraphType.PG_VIEWS) {
                        this.sqlTrans = this.pt.buildTranslation();
                        this.translated = true;
                        this.cacheTranslation(matchOptions, options);
                    }
                }
                if (this.ctx.graphType == GraphType.PG_VIEWS) {
                    if (this.sqlTrans.getTranslationType() == PgqlSqlTrans.TranslationType.QUERY) {
                        this.prepareQuery(parallel, dynamicSampling, maxResults);
                        this.storePrepareParameters(timeout, parallel, dynamicSampling, maxResults);
                    } else if (this.sqlTrans.getTranslationType() == PgqlSqlTrans.TranslationType.MODIFY) {
                        this.prepareModify(parallel, dynamicSampling);
                        this.storePrepareParameters(timeout, parallel, dynamicSampling, maxResults);
                    }
                }
            }
            catch (SQLException | PgqlException ex) {
                throw new PgqlToSqlException(ex);
            }
        }
    }

    @Override
    public PgqlResultSet getResultSet() {
        if (this.rsCntr > 0L) {
            return this.rsMap.get(this.rsCntr - 1L);
        }
        throw new PgqlToSqlException("ResultSet not available. Execute a query first.");
    }

    @Override
    public long getModifyCount() {
        return this.executionInfo.modifyCount;
    }

    @Override
    public void setBoolean(int parameterIndex, boolean x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setBoolean(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setBoolean(parameterIndex, x);
        }
    }

    @Override
    public void setDouble(int parameterIndex, double x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setDouble(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setDouble(parameterIndex, x);
        }
    }

    @Override
    public void setFloat(int parameterIndex, float x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setFloat(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setFloat(parameterIndex, x);
        }
    }

    @Override
    public void setInt(int parameterIndex, int x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setInt(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setInt(parameterIndex, x);
        }
    }

    @Override
    public void setLong(int parameterIndex, long x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setLong(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setLong(parameterIndex, x);
        }
    }

    @Override
    public void setString(int parameterIndex, String x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setString(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setString(parameterIndex, x);
        }
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setTimestamp(i + 1, x);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            this.bvInfo.setTimestamp(parameterIndex, x);
        }
    }

    public void setDate(int parameterIndex, LocalDate x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setDate(i + 1, Date.valueOf(x));
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setTime(int parameterIndex, LocalTime x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setTime(i + 1, Time.valueOf(x));
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setTimestamp(int parameterIndex, LocalDateTime x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            PreparedStatement ps = (PreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    ps.setTimestamp(i + 1, Timestamp.valueOf(x));
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setTimeWithTimezone(int parameterIndex, OffsetTime x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            OraclePreparedStatement ps = (OraclePreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    TIMESTAMPTZ ttz = new TIMESTAMPTZ(ps.getConnection(), Timestamp.from(x.atDate(LocalDate.ofEpochDay(0L)).toInstant()), (ZoneId)x.getOffset());
                    ps.setTIMESTAMPTZ(i + 1, ttz);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setTimestampWithTimezone(int parameterIndex, OffsetDateTime x) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Setting bind value index [" + parameterIndex + "] to value [" + x + "]");
        }
        if (this.prepared) {
            Pair<Integer, List<Integer>> bindPositions = this.bvInfo.getBindPositions(parameterIndex);
            OraclePreparedStatement ps = (OraclePreparedStatement)this.executionInfo.currentStmts[(Integer)bindPositions.first];
            try {
                for (Integer i : (List)bindPositions.second) {
                    TIMESTAMPTZ ttz = new TIMESTAMPTZ(ps.getConnection(), Timestamp.from(x.toInstant()), (ZoneId)x.getOffset());
                    ps.setTIMESTAMPTZ(i + 1, ttz);
                }
            }
            catch (SQLException ex) {
                throw new PgqlToSqlException(ex);
            }
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setArray(int parameterIndex, List<?> x) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PgqlSqlQueryTrans translateQuery() throws PgqlToSqlException, PgqlException {
        return this.translateQuery(this.prepareParallel, this.prepareDS, this.prepareMaxResults, this.translateMatchOptions);
    }

    @Override
    public PgqlSqlQueryTrans translateQuery(String pgql, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.translateQuery(0, 2, -1, options);
    }

    @Override
    public PgqlSqlQueryTrans translateQuery(String pgql, int parallel, int dynamicSampling, int maxResults, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.translateQuery(parallel, dynamicSampling, maxResults, options);
    }

    @Override
    public PgqlSqlTrans translateStatement() throws PgqlToSqlException, PgqlException {
        return this.translateStatement(this.translateMatchOptions, this.translateOptions);
    }

    @Override
    public PgqlSqlTrans translateStatement(String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        return this.translateStatement(this.prepareParallel, this.prepareDS, this.prepareMaxResults, matchOptions, options);
    }

    @Override
    public PgqlSqlTrans translateStatement(String pgql, String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.translateStatement(matchOptions, options);
    }

    @Override
    public PgqlSqlTrans translateStatement(int parallel, int dynamicSampling, int maxResults, String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        if (ms_log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("translateStatement called\n");
            sb.append("       parallel=[").append(parallel).append("]\n");
            sb.append("dynamicSampling=[").append(dynamicSampling).append("]\n");
            sb.append("     maxResults=[").append(maxResults).append("]\n");
            sb.append("   matchOptions=[").append(matchOptions).append("]\n");
            sb.append("        options=[").append(options).append("]\n");
            ms_log.debug(sb.toString());
        }
        boolean append = true;
        this.translateIfNecessary(matchOptions, options);
        PgqlSqlTrans sql = this.sqlTrans;
        if (this.ctx.graphType == GraphType.PG_VIEWS && sql.getTranslationType() != PgqlSqlTrans.TranslationType.QUERY) {
            throw new PgqlToSqlException("Translation not supported for PG views");
        }
        switch (sql.getTranslationType()) {
            case QUERY: {
                PgqlSqlQueryTrans sqlQuery = (PgqlSqlQueryTrans)sql;
                sql = new PgqlSqlQueryTransImpl(sqlQuery.getReturnTypes(), DbmsUtils.getQueryWrapper(sqlQuery.getSqlTranslation(), maxResults, parallel, dynamicSampling), sqlQuery.getSqlBvList());
                break;
            }
            case MODIFY: {
                sql = this.wrapSqlModifyForTranslate((PgqlSqlModifyTrans)sql, parallel, dynamicSampling, append);
                break;
            }
            case CREATE: {
                sql = this.wrapSqlCreateForTranslate((PgqlSqlCreateTrans)sql, parallel, dynamicSampling, append);
                break;
            }
            case DROP: {
                sql = this.wrapSqlDropForTranslate((PgqlSqlDropTrans)sql);
            }
        }
        return sql;
    }

    @Override
    public PgqlSqlTrans translateStatement(String pgql, int parallel, int dynamicSampling, int maxResults, String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.translateStatement(parallel, dynamicSampling, maxResults, matchOptions, options);
    }

    @Override
    public PgqlResultSet executeQuery() throws PgqlToSqlException, PgqlException {
        return this.executeQuery(this.prepareTimeout, this.prepareParallel, this.prepareDS, this.prepareMaxResults, this.translateMatchOptions);
    }

    @Override
    public PgqlResultSet executeQuery(String pgql, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.executeQuery(0, 0, 2, -1, options);
    }

    @Override
    public PgqlResultSet executeQuery(int timeout, int parallel, int dynamicSampling, int maxResults, String options) throws PgqlToSqlException, PgqlException {
        PgqlResultSetImpl oprs;
        if (ms_log.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("executeQuery called\n");
            sb.append("        timeout=[").append(timeout).append("]\n");
            sb.append("       parallel=[").append(parallel).append("]\n");
            sb.append("dynamicSampling=[").append(dynamicSampling).append("]\n");
            sb.append("     maxResults=[").append(maxResults).append("]\n");
            sb.append("        options=[").append(options).append("]\n");
            ms_log.debug(sb.toString());
        }
        this.translateIfNecessary(options, null);
        if (this.sqlTrans.getTranslationType() != PgqlSqlTrans.TranslationType.QUERY) {
            throw new PgqlToSqlException("Statement not valid for executeQuery(), use execute() instead");
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        PgqlSqlQueryTrans sqlQueryTrans = (PgqlSqlQueryTrans)this.sqlTrans;
        try {
            if (this.executionInfo.isCanceled) {
                throw new PgqlException(USER_REQUESTED_CANCEL_ERROR);
            }
            if (this.prepared) {
                this.checkStoredParameters(timeout, parallel, dynamicSampling, maxResults);
            } else {
                this.prepareQuery(parallel, dynamicSampling, maxResults);
                if (this.ctx.graphType == GraphType.PG_SCHEMA) {
                    DbmsUtils.setBindValues((PreparedStatement)this.executionInfo.currentStmts[0], sqlQueryTrans.getSqlBvList());
                }
            }
            ps = (PreparedStatement)this.executionInfo.currentStmts[0];
            if (timeout > 0) {
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("executeQuery: setting timeout " + timeout);
                }
                ps.setQueryTimeout(timeout);
            }
            rs = ps.executeQuery();
        }
        catch (Exception e) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Exception during executeQuery: ", (Throwable)e);
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Trying to close result set and statement");
            }
            DbmsUtils.quietlyCloseResultSetAndStmt(rs, ps);
            this.checkTableOrViewDoesNotExistError(e);
            throw new PgqlToSqlException(e.getMessage(), e);
        }
        try {
            oprs = this.ctx.graphType == GraphType.PG_SCHEMA ? new PgSchemaResultSet(rs, (Statement)ps, sqlQueryTrans.getReturnTypes(), this.getFetchSize(), this.ctx, this, this.rsCntr) : new PgViewResultSet(rs, ps, this.getFetchSize(), this.ctx, this, this.rsCntr, !this.prepared);
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Adding PgqlResultSet id=[" + this.rsCntr + "] to rsMap");
        }
        this.rsMap.put(this.rsCntr, oprs);
        ++this.rsCntr;
        this.executionInfo.modifyCount = -1L;
        return oprs;
    }

    @Override
    public PgqlResultSet executeQuery(String pgql, int timeout, int parallel, int dynamicSampling, int maxResults, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.executeQuery(timeout, parallel, dynamicSampling, maxResults, options);
    }

    @Override
    public boolean execute(String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        return this.execute(0, 2, matchOptions, options);
    }

    @Override
    public boolean execute(String pgql, String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.execute(matchOptions, options);
    }

    @Override
    public boolean execute(int parallel, int dynamicSampling, String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        try {
            if (ms_log.isDebugEnabled()) {
                StringBuilder sb = new StringBuilder();
                sb.append("execute called\n");
                sb.append("       parallel=[").append(parallel).append("]\n");
                sb.append("dynamicSampling=[").append(dynamicSampling).append("]\n");
                sb.append("   matchOptions=[").append(matchOptions).append("]\n");
                sb.append("        options=[").append(options).append("]\n");
                ms_log.debug(sb.toString());
            }
            this.translateIfNecessary(matchOptions, options);
            if (this.ctx.pgqlConn.getJdbcConnection().getAutoCommit() && this.modifyCtx.getOption(ModifyContext.BooleanOption.AUTO_COMMIT)) {
                throw new PgqlToSqlException("Connection auto-commit should be off when AUTO_COMMIT=T flag is used ");
            }
            if (this.sqlTrans.getTranslationType() == PgqlSqlTrans.TranslationType.QUERY) {
                this.executeQuery(0, parallel, dynamicSampling, -1, matchOptions);
                return true;
            }
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
        if (this.ctx.graphType == GraphType.PG_SCHEMA) {
            this.executeOnPgSchema(parallel, dynamicSampling);
        } else if (this.ctx.graphType == GraphType.PG_VIEWS) {
            this.executeOnPgView(parallel, dynamicSampling);
        } else {
            this.executeOnPgSql(parallel, dynamicSampling);
        }
        return false;
    }

    private void executeOnPgSchema(int parallel, int dynamicSampling) throws PgqlToSqlException, PgqlException {
        try {
            Savepoint savepoint = null;
            long updatedRows = 0L;
            String[] temporaryTableNames = null;
            String matchTableName = null;
            try {
                boolean append = this.sqlTrans.getTranslationType() != PgqlSqlTrans.TranslationType.MODIFY || ((PgqlSqlModifyTrans)this.sqlTrans).getModifyTypes().size() <= 1;
                int safeParallel = this.getParallelSafeValue(parallel, append);
                boolean parallelEnabled = this.enableSessionParallel(safeParallel);
                if (this.modifyCtx.getOption(ModifyContext.BooleanOption.AUTO_COMMIT)) {
                    savepoint = this.ctx.pgqlConn.getJdbcConnection().setSavepoint();
                }
                switch (this.sqlTrans.getTranslationType()) {
                    case MODIFY: {
                        PgqlSqlModifyTrans sqlModifyTrans;
                        if (this.ctx.pgqlConn.getJdbcConnection().getAutoCommit()) {
                            throw new PgqlToSqlException(AUTO_COMMIT_MODIFY_ERROR);
                        }
                        if (ms_log.isDebugEnabled()) {
                            ms_log.debug("Executing Modify operations...");
                        }
                        if ((sqlModifyTrans = (PgqlSqlModifyTrans)this.sqlTrans).getMatchTranslation() != null) {
                            matchTableName = sqlModifyTrans.getMatchTranslation()[0];
                            this.createMatchTable(sqlModifyTrans.getMatchTranslation(), sqlModifyTrans.getMatchBvList());
                        }
                        List<PgqlSqlModifyTrans.ModificationType> modifyTypes = sqlModifyTrans.getModifyTypes();
                        temporaryTableNames = sqlModifyTrans.getTemporaryTableNames();
                        for (int i = 0; i < modifyTypes.size(); ++i) {
                            String[] modifyTranslation = (String[])sqlModifyTrans.getSqlModifyTranslations().get(i);
                            List<Object> bindValues = sqlModifyTrans.getModifyBvLists().get(i);
                            if (ms_log.isDebugEnabled()) {
                                ms_log.debug("Executing modify " + i + ":" + (Object)((Object)modifyTypes.get(i)));
                            }
                            switch (modifyTypes.get(i)) {
                                case UPDATE: {
                                    updatedRows += this.doUpdate(modifyTranslation, safeParallel, dynamicSampling, append, bindValues);
                                    break;
                                }
                                case INSERT_EDGE: {
                                    updatedRows += this.insertIntoPGTable(modifyTranslation[1], temporaryTableNames[i], false, matchTableName != null, safeParallel, dynamicSampling, append, bindValues);
                                    break;
                                }
                                case INSERT_VERTEX: {
                                    updatedRows += this.insertIntoPGTable(modifyTranslation[0], temporaryTableNames[i], true, matchTableName != null, safeParallel, dynamicSampling, append, bindValues);
                                    break;
                                }
                                case DELETE: {
                                    updatedRows += this.doDelete(modifyTranslation, safeParallel, dynamicSampling, append, bindValues);
                                }
                            }
                            if (!ms_log.isDebugEnabled()) continue;
                            ms_log.debug("Finished executing modify");
                        }
                        this.executionInfo.modifyCount = updatedRows;
                        break;
                    }
                    case CREATE: {
                        int i;
                        if (ms_log.isDebugEnabled()) {
                            ms_log.debug("Executing Create operation...");
                        }
                        this.throwIfGraphExists();
                        PgqlSqlCreateTrans sqlCreateTrans = (PgqlSqlCreateTrans)this.sqlTrans;
                        String graphSchema = sqlCreateTrans.getGraphSchema();
                        String graphName = sqlCreateTrans.getGraphName();
                        if (graphName == null || !graphName.equals(graphName.toUpperCase())) {
                            throw new PgqlToSqlException("PG schema graph names must be simple SQL names");
                        }
                        this.createPGSchemaTables(graphSchema, graphName);
                        savepoint = this.commit();
                        Object[] createTranslation = sqlCreateTrans.getCreateTranslation();
                        if (createTranslation[0] != null) {
                            String[] vertexTranslation = (String[])createTranslation[0];
                            for (i = 0; i < vertexTranslation.length; ++i) {
                                updatedRows += this.insertIntoPGTable(vertexTranslation[i], true, safeParallel, dynamicSampling, append);
                                savepoint = this.commit();
                            }
                        }
                        if (createTranslation[1] != null) {
                            String[] edgeTranslation = (String[])createTranslation[1];
                            for (i = 0; i < edgeTranslation.length; ++i) {
                                updatedRows += this.insertIntoPGTable(edgeTranslation[i], false, safeParallel, dynamicSampling, append);
                                savepoint = this.commit();
                            }
                        }
                        if (this.ctx.useGtTab || this.ctx.useVdTab) {
                            savepoint = this.populateDistinctTables((String[])createTranslation[2], graphSchema, graphName, safeParallel, dynamicSampling, append);
                        }
                        this.createPGSchemaIndexes(graphSchema, graphName, safeParallel);
                        this.gatherPGStats(graphSchema, graphName, safeParallel);
                        this.executionInfo.modifyCount = 0L;
                        break;
                    }
                    case DROP: {
                        if (ms_log.isDebugEnabled()) {
                            ms_log.debug("Executing Drop operation...");
                        }
                        PgqlSqlDropTrans sqlDropTrans = (PgqlSqlDropTrans)this.sqlTrans;
                        this.dropPropertyGraph(sqlDropTrans.getGraphSchema(), sqlDropTrans.getGraphName());
                        this.executionInfo.modifyCount = 0L;
                    }
                }
                if (this.modifyCtx.getOption(ModifyContext.BooleanOption.AUTO_COMMIT)) {
                    this.ctx.pgqlConn.getJdbcConnection().commit();
                } else if (matchTableName != null) {
                    this.dropTable(matchTableName, false);
                }
            }
            catch (Exception ex) {
                if (this.modifyCtx.getOption(ModifyContext.BooleanOption.AUTO_COMMIT) && savepoint != null) {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug("Performing rollback...");
                    }
                    this.ctx.pgqlConn.getJdbcConnection().rollback(savepoint);
                }
                this.checkTableOrViewDoesNotExistError(ex);
                throw ex;
            }
            finally {
                if (matchTableName != null) {
                    this.dropTable(matchTableName, false);
                }
                if (temporaryTableNames != null) {
                    for (int i = 0; i < temporaryTableNames.length; ++i) {
                        if (temporaryTableNames[i] == null) continue;
                        this.dropTable((String)temporaryTableNames[i], false);
                    }
                }
            }
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Adding null PgqlResultSet id=[" + this.rsCntr + "] to rsMap");
            }
            this.rsMap.put(this.rsCntr, null);
            ++this.rsCntr;
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    private void executeOnPgView(int parallel, int dynamicSampling) throws PgqlException {
        try {
            boolean append = this.sqlTrans.getTranslationType() != PgqlSqlTrans.TranslationType.MODIFY || ((PgViewModifyTrans)this.sqlTrans).getModifications().size() <= 1;
            int safeParallel = this.getParallelSafeValue(parallel, append);
            boolean parallelEnabled = this.enableSessionParallel(safeParallel);
            switch (this.sqlTrans.getTranslationType()) {
                case CREATE: {
                    this.throwIfGraphExists();
                    PgqlSqlCreateTrans createTrans = (PgqlSqlCreateTrans)this.sqlTrans;
                    CreatePropertyGraph cpg = (CreatePropertyGraph)createTrans.getCreateTranslation()[0];
                    PgViewDdlExecution ddlExecution = new PgViewDdlExecution(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName);
                    ddlExecution.createPG(cpg, this.ctx.checkTypes);
                    break;
                }
                case DROP: {
                    PgViewDdlExecution ddlExecution = new PgViewDdlExecution(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName);
                    PgqlTranslator.deleteGraphMetadata(this.ctx.pgqlConn.getJdbcConnection(), this.ctx.schemaName, this.ctx.graphName);
                    translationCache.deleteGraphTranslations(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName);
                    ddlExecution.dropPG();
                    break;
                }
                case MODIFY: {
                    if (this.ctx.pgqlConn.getJdbcConnection().getAutoCommit()) {
                        throw new PgqlToSqlException(AUTO_COMMIT_MODIFY_ERROR);
                    }
                    if (this.prepared) {
                        this.checkStoredParameters(0, parallel, dynamicSampling, -1);
                    } else {
                        this.prepareModify(parallel, dynamicSampling);
                    }
                    this.dmlExecution.executeModify(this.modifyCtx.getOption(ModifyContext.BooleanOption.AUTO_COMMIT));
                    break;
                }
                default: {
                    throw new PgqlToSqlException("Operation not supported for property graph view model:" + (Object)((Object)this.sqlTrans.getTranslationType()));
                }
            }
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    private void executeOnPgSql(int parallel, int dynamicSampling) throws PgqlException {
        switch (this.sqlTrans.getTranslationType()) {
            case CREATE: {
                this.throwIfGraphExists();
                PgqlSqlCreateTrans createTrans = (PgqlSqlCreateTrans)this.sqlTrans;
                CreatePropertyGraph cpg = (CreatePropertyGraph)createTrans.getCreateTranslation()[0];
                PgSqlDdlExecution ddlExecution = new PgSqlDdlExecution(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName);
                PgSqlDdlExecution.createPg(cpg);
                break;
            }
            case DROP: {
                PgSqlDdlExecution ddlExecution = new PgSqlDdlExecution(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName);
                ddlExecution.dropPg();
                break;
            }
            default: {
                throw new PgqlToSqlException("Operation not supported for SQL property graphs:" + (Object)((Object)this.sqlTrans.getTranslationType()));
            }
        }
    }

    @Override
    public boolean execute(String pgql, int parallel, int dynamicSampling, String matchOptions, String options) throws PgqlToSqlException, PgqlException {
        this.initQuery(pgql);
        return this.execute(parallel, dynamicSampling, matchOptions, options);
    }

    private PgqlSqlModifyTrans wrapSqlModifyForTranslate(PgqlSqlModifyTrans sqlModify, int parallel, int dynamicSampling, boolean append) {
        String[] matchTranslation = sqlModify.getMatchTranslation();
        String[] newMatchTranslation = matchTranslation == null ? null : this.getCreateMatchTableStatements(matchTranslation);
        List<PgqlSqlModifyTrans.ModificationType> modifyTypes = sqlModify.getModifyTypes();
        String[] temporaryTableNames = sqlModify.getTemporaryTableNames();
        ArrayList<Object[]> newModifyTranslations = new ArrayList<Object[]>();
        for (int i = 0; i < modifyTypes.size(); ++i) {
            String[] modifyTranslation = (String[])sqlModify.getSqlModifyTranslations().get(i);
            Object[] newModifyTranslation = null;
            switch (modifyTypes.get(i)) {
                case UPDATE: {
                    String[] edgeTranslation;
                    String[] vertexTranslation;
                    if (modifyTranslation[0] == null) {
                        vertexTranslation = null;
                    } else {
                        vertexTranslation = this.buildMergeStatements(this.ctx.vtTab, "(" + DbmsUtils.getQueryWrapper(modifyTranslation[0], parallel, dynamicSampling) + ")", true, false, parallel, dynamicSampling, append);
                        if (!this.modifyCtx.getOption(ModifyContext.BooleanOption.CHECK_NULL_PROPS)) {
                            vertexTranslation = new String[]{vertexTranslation[1]};
                        }
                    }
                    if (modifyTranslation[1] == null) {
                        edgeTranslation = null;
                    } else {
                        edgeTranslation = this.buildMergeStatements(this.ctx.geTab, "(" + DbmsUtils.getQueryWrapper(modifyTranslation[1], parallel, dynamicSampling) + ")", false, false, parallel, dynamicSampling, append);
                        if (!this.modifyCtx.getOption(ModifyContext.BooleanOption.CHECK_NULL_PROPS)) {
                            edgeTranslation = new String[]{edgeTranslation[1]};
                        }
                    }
                    newModifyTranslation = new Object[]{vertexTranslation, edgeTranslation};
                    break;
                }
                case INSERT_EDGE: {
                    String[] createTempStr;
                    String[] insertStmts = this.getInsertIntoPGStatements(modifyTranslation[1], temporaryTableNames[i], false, newMatchTranslation != null, parallel, dynamicSampling, append);
                    if (temporaryTableNames[i] != null) {
                        createTempStr = this.getCreateTemporaryTablesStatements(false, true, null, temporaryTableNames[i]);
                        newModifyTranslation = new Object[]{new String[]{createTempStr[1], insertStmts[0], insertStmts[1]}};
                        break;
                    }
                    newModifyTranslation = new Object[]{new String[]{insertStmts[1]}};
                    break;
                }
                case INSERT_VERTEX: {
                    String[] createTempStr;
                    String[] insertStmts = this.getInsertIntoPGStatements(modifyTranslation[0], temporaryTableNames[i], true, newMatchTranslation != null, parallel, dynamicSampling, append);
                    if (temporaryTableNames[i] != null) {
                        createTempStr = this.getCreateTemporaryTablesStatements(true, false, temporaryTableNames[i], null);
                        newModifyTranslation = new Object[]{new String[]{createTempStr[0], insertStmts[0], insertStmts[1]}};
                        break;
                    }
                    newModifyTranslation = new Object[]{new String[]{insertStmts[1]}};
                    break;
                }
                case DELETE: {
                    try {
                        String vertexTemporaryTable = PgqlUtils.getTemporaryTabName(this.ctx.pgqlConn.getJdbcConnection(), this.ctx.graphName, "VT");
                        String edgeTemporaryTable = PgqlUtils.getTemporaryTabName(this.ctx.pgqlConn.getJdbcConnection(), this.ctx.graphName, "GE");
                        boolean deleteFromVertexTable = modifyTranslation[0] != null;
                        boolean deleteFromEdgeTable = modifyTranslation[1] != null;
                        boolean deleteEdges = deleteFromEdgeTable || deleteFromVertexTable;
                        newModifyTranslation = this.getStatementsForDelete(deleteFromVertexTable, deleteEdges, vertexTemporaryTable, edgeTemporaryTable, modifyTranslation, parallel, dynamicSampling, append, true);
                        break;
                    }
                    catch (SQLException ex) {
                        throw new PgqlToSqlException(ex);
                    }
                }
            }
            newModifyTranslations.add(newModifyTranslation);
        }
        return new PgqlSqlModifyTransImpl(newMatchTranslation, sqlModify.getMatchBvList(), sqlModify.getModifyTypes(), newModifyTranslations, sqlModify.getTemporaryTableNames(), sqlModify.getModifyBvLists());
    }

    private PgqlSqlCreateTrans wrapSqlCreateForTranslate(PgqlSqlCreateTrans sqlCreate, int parallel, int dynamicSampling, boolean append) {
        String[] newEdgeTables;
        String[] newVertexTables;
        Object[] steps = sqlCreate.getCreateTranslation();
        Object[] newSteps = new Object[6];
        newSteps[0] = this.getCreatePGSchemaStr(false).replace(OPTIONS_BIND_VAR, DbmsUtils.escapeAndEnquoteLiteral(this.appendCreatePgOptions(SKIP_INDEX_FLAG), false));
        String[] vertexTables = (String[])steps[0];
        if (vertexTables == null) {
            newVertexTables = null;
        } else {
            newVertexTables = new String[vertexTables.length];
            for (int i = 0; i < newVertexTables.length; ++i) {
                newVertexTables[i] = this.getInsertIntoPGStatements(vertexTables[i], null, true, false, parallel, dynamicSampling, append)[1];
            }
        }
        newSteps[1] = newVertexTables;
        String[] edgeTables = (String[])steps[1];
        if (edgeTables == null) {
            newEdgeTables = null;
        } else {
            newEdgeTables = new String[edgeTables.length];
            for (int i = 0; i < newEdgeTables.length; ++i) {
                newEdgeTables[i] = this.getInsertIntoPGStatements(edgeTables[i], null, false, false, parallel, dynamicSampling, append)[1];
            }
        }
        newSteps[2] = newEdgeTables;
        String[] distinctTables = (String[])steps[2];
        String[] newDistinctTables = new String[]{distinctTables[0] == null ? null : this.getInsertStatement(distinctTables[0], this.ctx.vdTab, parallel, dynamicSampling, append), distinctTables[1] == null ? null : this.getInsertStatement(distinctTables[1], this.ctx.gtTab, parallel, dynamicSampling, append)};
        newSteps[3] = newDistinctTables;
        newSteps[4] = this.getCreatePGSchemaStr(true).replace(OPTIONS_BIND_VAR, DbmsUtils.escapeAndEnquoteLiteral(this.appendCreatePgOptions(SKIP_TABLE_FLAG), false));
        newSteps[5] = this.getAnalyzePGStr();
        return new PgqlSqlCreateTransImpl(sqlCreate.getGraphSchema(), sqlCreate.getGraphName(), newSteps);
    }

    private PgqlSqlDropTrans wrapSqlDropForTranslate(PgqlSqlDropTrans sqlDrop) {
        String newSteps;
        try {
            newSteps = this.getDropPGSchemaStr(sqlDrop.getGraphSchema(), sqlDrop.getGraphName());
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
        return new PgqlSqlDropTransImpl(sqlDrop.getGraphSchema(), sqlDrop.getGraphName(), newSteps);
    }

    private int getParallelSafeValue(int parallel, boolean isParallelSafe) {
        if (isParallelSafe) {
            return parallel;
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Parallel not safe, using [0] instead");
        }
        return 0;
    }

    private boolean enableSessionParallel(int parallel) throws SQLException {
        boolean enabled = false;
        if (parallel != 0) {
            String alterStr = "BEGIN\n  EXECUTE IMMEDIATE 'ALTER SESSION ENABLE PARALLEL QUERY';\n  EXECUTE IMMEDIATE 'ALTER SESSION ENABLE PARALLEL DML';\nEND;";
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Altering session parameters:[\n" + alterStr + "\n]");
            }
            try (Statement stmt = this.createStatement(false);){
                stmt.execute(alterStr);
                enabled = true;
            }
        }
        return enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createMatchTable(String[] statements, List<Object> bindValues) throws SQLException {
        Statement stmt = null;
        Statement ps = null;
        try {
            String[] createStatements = this.getCreateMatchTableStatements(statements);
            stmt = this.createStatement(true);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Creating temporary match table:[" + createStatements[0] + "]");
            }
            stmt.executeUpdate(createStatements[0]);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Inserting into temporary match table:[" + createStatements[1] + "]");
            }
            ps = this.prepareStatement(createStatements[1]);
            DbmsUtils.setBindValues((PreparedStatement)ps, bindValues);
            ps.executeUpdate();
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (ps != null) {
                ps.close();
            }
        }
    }

    private String[] getCreateMatchTableStatements(String[] statements) {
        String[] createStatements = new String[2];
        String tableName = statements[0];
        createStatements[0] = "CREATE PRIVATE TEMPORARY TABLE " + tableName + statements[1] + "ON COMMIT DROP DEFINITION";
        createStatements[1] = "INSERT INTO " + tableName + " " + statements[2];
        return createStatements;
    }

    private long doUpdate(String[] populateStatements, int parallel, int dynamicSampling, boolean append, List<Object> bindValues) throws SQLException {
        boolean updateEdgeTable;
        boolean updateVertexTable = populateStatements[0] != null;
        boolean bl = updateEdgeTable = populateStatements[1] != null;
        if (this.modifyCtx.getOption(ModifyContext.BooleanOption.STREAMING)) {
            return this.updateInStream(populateStatements, updateVertexTable, updateEdgeTable, parallel, dynamicSampling, append, bindValues);
        }
        if (this.modifyCtx.getOption(ModifyContext.BooleanOption.CHECK_NULL_PROPS)) {
            return this.updateUsingTemporaryTables(populateStatements, updateVertexTable, updateEdgeTable, parallel, dynamicSampling, append, bindValues);
        }
        return this.updatePGTables(updateVertexTable, updateEdgeTable, "(" + DbmsUtils.getQueryWrapper(populateStatements[0], parallel, dynamicSampling) + ")", "(" + DbmsUtils.getQueryWrapper(populateStatements[1], parallel, dynamicSampling) + ")", parallel, dynamicSampling, append, bindValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long updateUsingTemporaryTables(String[] populateStatements, boolean updateVertexTable, boolean updateEdgeTable, int parallel, int dynamicSampling, boolean append, List<Object> bindValues) throws SQLException {
        long updatedRows;
        String vertexTemporaryTable = PgqlUtils.getTemporaryTabName(this.ctx.pgqlConn.getJdbcConnection(), this.ctx.graphName, "VT");
        String edgeTemporaryTable = PgqlUtils.getTemporaryTabName(this.ctx.pgqlConn.getJdbcConnection(), this.ctx.graphName, "GE");
        try {
            this.createTemporaryTables(updateVertexTable, updateEdgeTable, vertexTemporaryTable, edgeTemporaryTable);
            int safeParallel = DbmsUtils.getParallelSafeValueForPTT(parallel, bindValues);
            this.populatePGTables(populateStatements, updateVertexTable, updateEdgeTable, vertexTemporaryTable, edgeTemporaryTable, safeParallel, dynamicSampling, append, bindValues);
            updatedRows = this.updatePGTables(updateVertexTable, updateEdgeTable, vertexTemporaryTable, edgeTemporaryTable, parallel, dynamicSampling, append, null);
        }
        finally {
            this.dropTemporaryTables(updateVertexTable, updateEdgeTable, vertexTemporaryTable, edgeTemporaryTable);
        }
        return updatedRows;
    }

    private String[] getCreateTemporaryTablesStatements(boolean createVertexTable, boolean createEdgeTable, String vertexTableName, String edgeTableName) {
        String[] statements = new String[2];
        if (createVertexTable) {
            statements[0] = "CREATE PRIVATE TEMPORARY TABLE " + vertexTableName + "( PROP_ID   NUMBER, VID       NUMBER, ";
            if (this.ctx.useVLCol) {
                statements[0] = statements[0] + "VL        NVARCHAR2(" + this.nvarcharKLSize + "), ";
            }
            statements[0] = statements[0] + "K         NVARCHAR2(" + this.nvarcharKLSize + "), T         NUMBER(38), V         NVARCHAR2(" + this.nvarcharVSize + "), VN        NUMBER, VT        TIMESTAMP(6) WITH TIME ZONE ) ON COMMIT DROP DEFINITION";
        }
        if (createEdgeTable) {
            statements[1] = "CREATE PRIVATE TEMPORARY TABLE " + edgeTableName + "( PROP_ID   NUMBER, EID       NUMBER, SVID      NUMBER, DVID      NUMBER, EL        NVARCHAR2(" + this.nvarcharKLSize + "), K         NVARCHAR2(" + this.nvarcharKLSize + "), T         NUMBER(38), V         NVARCHAR2(" + this.nvarcharVSize + "), VN        NUMBER, VT        TIMESTAMP(6) WITH TIME ZONE ) ON COMMIT DROP DEFINITION";
        }
        return statements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTemporaryTables(boolean createVertexTable, boolean createEdgeTable, String vertexTableName, String edgeTableName) throws SQLException {
        String[] createStatements = this.getCreateTemporaryTablesStatements(createVertexTable, createEdgeTable, vertexTableName, edgeTableName);
        try (Statement stmt = null;){
            if (createVertexTable) {
                stmt = this.createStatement(true);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Creating temporary vertex table:[" + createStatements[0] + "]");
                }
                stmt.executeUpdate(createStatements[0]);
                stmt.close();
            }
            if (createEdgeTable) {
                stmt = this.createStatement(true);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Creating temporary edge table:[" + createStatements[1] + "]");
                }
                stmt.executeUpdate(createStatements[1]);
            }
        }
    }

    private String getInsertStatement(String selectStatement, String tableName, int parallel, int dynamicSampling, boolean append) {
        String hintInsert = DbmsUtils.buildHintString(parallel, dynamicSampling, append, false);
        return "INSERT " + hintInsert + "INTO " + tableName + " " + DbmsUtils.getQueryWrapper(selectStatement, parallel, dynamicSampling);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populatePGTables(String[] populateStatements, boolean populateVertexTable, boolean populateEdgeTable, String vertexTableName, String edgeTableName, int parallel, int dynamicSampling, boolean append, List<Object> bindValues) throws SQLException {
        try (Statement ps = null;){
            if (populateVertexTable) {
                String insertVertexStr = this.getInsertStatement(populateStatements[0], vertexTableName, parallel, dynamicSampling, append);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Populating vertex table " + vertexTableName + ":[" + insertVertexStr + "]");
                }
                ps = this.prepareStatement(insertVertexStr);
                DbmsUtils.setBindValues((PreparedStatement)ps, bindValues);
                ps.execute();
                ps.close();
                ps = null;
            }
            if (populateEdgeTable) {
                String insertEdgeStr = this.getInsertStatement(populateStatements[1], edgeTableName, parallel, dynamicSampling, append);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Populating edge table " + edgeTableName + ":[" + insertEdgeStr + "]");
                }
                ps = this.prepareStatement(insertEdgeStr);
                DbmsUtils.setBindValues((PreparedStatement)ps, bindValues);
                ps.executeUpdate();
            }
        }
    }

    private String[] buildMergeStatements(String tableName, String temporaryTableName, boolean isVertexTable, boolean forStreaming, int parallel, int dynamicSampling, boolean append) {
        if (this.modifyCtx.getOption(ModifyContext.BooleanOption.CHECK_NULL_PROPS)) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Parallel not safe, using [0] instead");
            }
            parallel = 0;
            append = false;
        }
        String hintSelect = DbmsUtils.buildHintString(parallel, dynamicSampling, false, false);
        String hintInsert = DbmsUtils.buildHintString(parallel, dynamicSampling, append, false);
        ArrayList<String> tableColumns = new ArrayList<String>();
        if (isVertexTable) {
            if (this.ctx.useVLCol) {
                tableColumns.addAll(PgqlTranslator.VERTEX_TABLE_COLS);
            } else {
                tableColumns.addAll(PgqlTranslator.VERTEX_TABLE_NO_LABEL_COLS);
            }
        } else {
            tableColumns.addAll(PgqlTranslator.EDGE_TABLE_COLS);
        }
        String elementColumns = tableColumns.stream().collect(Collectors.joining(", "));
        tableColumns.addAll(PgqlTranslator.KEY_VALUE_COLS);
        String selectColumns = String.join((CharSequence)", ", tableColumns);
        String insertColumns = tableColumns.stream().map(s -> "q." + s).collect(Collectors.joining(", "));
        String streamingSelectColumns = tableColumns.stream().map(s -> s + " AS " + s).collect(Collectors.joining(", "));
        String idColumn = (String)tableColumns.get(0);
        StringBuffer selectStatement = new StringBuffer("SELECT ");
        if (forStreaming) {
            selectStatement.append(streamingSelectColumns);
        } else {
            selectStatement.append("DISTINCT ").append(selectColumns);
        }
        StringBuffer insertStatement = new StringBuffer();
        insertStatement.append("\nINSERT ").append(hintInsert).append("INTO ").append(tableName).append("\n(").append(selectColumns).append(")").append("\nSELECT ").append(hintSelect).append("DISTINCT ").append(elementColumns).append(", null, null, null, null, null").append("\nFROM ").append(temporaryTableName).append(" WHERE ").append("V").append(" IS NULL");
        StringBuffer mergeStatement = new StringBuffer();
        mergeStatement.append("\nMERGE ").append(hintInsert).append("INTO ").append(tableName).append("\nUSING (").append(selectStatement).append(" FROM ").append(temporaryTableName).append(")q").append("\nON (").append(tableName).append(".").append(idColumn).append(" = q.").append(idColumn).append("\n    AND ").append(tableName).append(".").append("K").append(" = q.").append("K").append(")").append("\nWHEN MATCHED THEN UPDATE").append("\n  SET ").append("T").append(" = q.").append("T").append(", ").append("V").append(" = q.").append("V").append(", ").append("VN").append(" = q.").append("VN").append(", ").append("VT").append(" = q.").append("VT").append("\n  DELETE WHERE q.").append("V").append(" IS NULL").append("\nWHEN NOT MATCHED THEN INSERT (").append(selectColumns).append(")").append("\n  VALUES (").append(insertColumns).append(")").append("\n  WHERE q.").append("V").append(" IS NOT NULL");
        StringBuffer deleteStatement = new StringBuffer();
        deleteStatement.append("\nDELETE ").append(hintSelect).append("FROM ").append(tableName).append("\nWHERE ").append("K").append(" IS NULL").append("\nAND ").append(idColumn).append(" IN (SELECT ").append(idColumn).append(" FROM ").append(tableName).append(" WHERE ").append("V").append(" IS NOT NULL)");
        return new String[]{insertStatement.toString(), mergeStatement.toString(), deleteStatement.toString()};
    }

    private long updatePGTables(boolean updateVertexTable, boolean updateEdgeTable, String vertexTemporaryTable, String edgeTemporaryTable, int parallel, int dynamicSampling, boolean append, List<Object> bindValues) throws SQLException {
        long updatedRows = 0L;
        if (updateVertexTable) {
            String vertexTabName = this.ctx.vtTab;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Updating vertex properties");
            }
            updatedRows += this.doMerge(this.buildMergeStatements(vertexTabName, vertexTemporaryTable, true, false, parallel, dynamicSampling, append), bindValues);
        }
        if (updateEdgeTable) {
            String edgeTabName = this.ctx.geTab;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Updating edge properties");
            }
            updatedRows += this.doMerge(this.buildMergeStatements(edgeTabName, edgeTemporaryTable, false, false, parallel, dynamicSampling, append), bindValues);
        }
        return updatedRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doMerge(String[] mergeStatements, List<Object> bindValues) throws SQLException {
        Statement stmt = null;
        PreparedStatement ps = null;
        long updatedRows = 0L;
        try {
            long rows;
            if (this.modifyCtx.getOption(ModifyContext.BooleanOption.CHECK_NULL_PROPS)) {
                String insertNullRows = mergeStatements[0];
                stmt = this.createStatement(true);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Inserting null rows:[" + insertNullRows + "]");
                }
                rows = stmt.executeUpdate(insertNullRows);
                updatedRows += rows;
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Inserted " + rows + " null rows");
                }
                stmt.close();
            }
            String updateStr = mergeStatements[1];
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Updating PG table:[" + updateStr + "]");
            }
            ps = this.prepareStatement(updateStr);
            DbmsUtils.setBindValues(ps, bindValues);
            rows = ps.executeUpdate();
            ps.close();
            updatedRows += rows;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Inserted " + rows + " rows to PG table");
            }
            if (this.modifyCtx.getOption(ModifyContext.BooleanOption.CHECK_NULL_PROPS)) {
                String deleteNullRows = mergeStatements[2];
                stmt = this.createStatement(true);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Deleting null rows:[" + deleteNullRows + "]");
                }
                rows = stmt.executeUpdate(deleteNullRows);
                updatedRows += rows;
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Deleted " + rows + " null rows");
                }
                stmt.close();
            }
            long l = updatedRows;
            return l;
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTable(String tableName, boolean throwError) throws SQLException {
        Statement stmt = null;
        String dropTableStr = "DROP TABLE " + tableName;
        try {
            stmt = this.createStatement(false);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Dropping table:[" + dropTableStr + "]");
            }
            stmt.executeUpdate(dropTableStr);
        }
        catch (SQLException ex) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Error while dropping table " + tableName);
            }
            if (throwError) {
                throw ex;
            }
        }
        finally {
            block16: {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException ex) {
                    if (!ms_log.isDebugEnabled()) break block16;
                    ms_log.debug("Ignoring error while closing stmt in dropTable");
                }
            }
        }
    }

    private void dropTemporaryTables(boolean dropVertexTable, boolean dropEdgeTable, String vertexTableName, String edgeTableName) throws SQLException {
        if (dropVertexTable) {
            this.dropTable(vertexTableName, false);
        }
        if (dropEdgeTable) {
            this.dropTable(edgeTableName, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long updateInStream(String[] populateStatements, boolean updateVertexTable, boolean updateEdgeTable, int parallel, int dynamicSampling, boolean append, List<Object> bindValues) throws SQLException {
        long updatedRows = 0L;
        Statement[] statements = new Statement[2];
        ResultSet[] resultSets = new ResultSet[2];
        PreparedStatement[] preparedStatements = new PreparedStatement[2];
        try {
            this.populateResultSets(populateStatements, updateVertexTable, updateEdgeTable, statements, resultSets, parallel, dynamicSampling, bindValues);
            this.prepareStatements(updateVertexTable, updateEdgeTable, preparedStatements, parallel, dynamicSampling, append);
            this.executionInfo.currentStmts = preparedStatements;
            updatedRows = this.updatePGTablesInStream(updateVertexTable, updateEdgeTable, resultSets, preparedStatements);
        }
        finally {
            block39: {
                block38: {
                    block37: {
                        block36: {
                            block35: {
                                block34: {
                                    if (preparedStatements[0] != null) {
                                        try {
                                            preparedStatements[0].close();
                                        }
                                        catch (SQLException ex) {
                                            if (!ms_log.isDebugEnabled()) break block34;
                                            ms_log.debug("Error while closing vertex prepared statement. Continue.");
                                        }
                                    }
                                }
                                if (resultSets[0] != null) {
                                    try {
                                        resultSets[0].close();
                                    }
                                    catch (SQLException ex) {
                                        if (!ms_log.isDebugEnabled()) break block35;
                                        ms_log.debug("Error while closing vertex result set. Continue.");
                                    }
                                }
                            }
                            if (statements[0] != null) {
                                try {
                                    statements[0].close();
                                }
                                catch (SQLException ex) {
                                    if (!ms_log.isDebugEnabled()) break block36;
                                    ms_log.debug("Error while closing vertex statement. Continue.");
                                }
                            }
                        }
                        if (preparedStatements[1] != null) {
                            try {
                                preparedStatements[1].close();
                            }
                            catch (SQLException ex) {
                                if (!ms_log.isDebugEnabled()) break block37;
                                ms_log.debug("Error while closing edge prepared statement. Continue.");
                            }
                        }
                    }
                    if (resultSets[1] != null) {
                        try {
                            resultSets[1].close();
                        }
                        catch (SQLException ex) {
                            if (!ms_log.isDebugEnabled()) break block38;
                            ms_log.debug("Error while closing edge result set. Continue.");
                        }
                    }
                }
                if (statements[1] != null) {
                    try {
                        statements[1].close();
                    }
                    catch (SQLException ex) {
                        if (!ms_log.isDebugEnabled()) break block39;
                        ms_log.debug("Error while closing edge statement. Continue.");
                    }
                }
            }
        }
        return updatedRows;
    }

    private void populateResultSets(String[] populateStatements, boolean populateVertexRS, boolean populateEdgeRS, Statement[] statements, ResultSet[] resultSets, int parallel, int dynamicSampling, List<Object> bindValues) throws SQLException {
        PreparedStatement ps;
        if (populateVertexRS) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Populating temporary vertex result set:[" + populateStatements[0] + "]");
            }
            String populateVertexStatement = DbmsUtils.getQueryWrapper(populateStatements[0], parallel, dynamicSampling).toString();
            ps = this.prepareStatement(populateVertexStatement);
            statements[0] = ps;
            DbmsUtils.setBindValues(ps, bindValues);
            resultSets[0] = ps.executeQuery();
        }
        if (populateEdgeRS) {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Populating temporary edge result set:[" + populateStatements[1] + "]");
            }
            String populateEdgeStatement = DbmsUtils.getQueryWrapper(populateStatements[1], parallel, dynamicSampling).toString();
            ps = this.prepareStatement(populateEdgeStatement);
            statements[1] = ps;
            DbmsUtils.setBindValues(ps, bindValues);
            resultSets[1] = ps.executeQuery();
        }
    }

    private void prepareStatements(boolean prepareVertexStatement, boolean prepareEdgeStatement, PreparedStatement[] preparedStatements, int parallel, int dynamicSampling, boolean append) throws SQLException {
        String[] mergeStatements;
        if (prepareVertexStatement) {
            String vertexTabName = this.ctx.vtTab;
            mergeStatements = this.buildMergeStatements(vertexTabName, "SYS.DUAL", true, true, parallel, dynamicSampling, append);
            String updateVertexTableStr = "\nDECLARE\n  VID  NUMBER := ?;\n  VL   NVARCHAR2(" + this.nvarcharKLSize + ") := ?;\n  K    NVARCHAR2(" + this.nvarcharKLSize + ") := ?;\n  T    NUMBER(38) := ?;\n  V    NVARCHAR2(" + this.nvarcharVSize + "):= ?;\n  VN   NUMBER := ?;\n  VT   TIMESTAMP(6) WITH TIME ZONE := ?;\nBEGIN\n" + mergeStatements[0] + ";\n" + mergeStatements[1] + ";\n" + mergeStatements[2] + ";\nEND;";
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Preparing vertex statement:[" + updateVertexTableStr + "]");
            }
            preparedStatements[0] = this.prepareStatement(updateVertexTableStr);
        }
        if (prepareEdgeStatement) {
            String edgeTabName = this.ctx.geTab;
            mergeStatements = this.buildMergeStatements(edgeTabName, "SYS.DUAL", false, true, parallel, dynamicSampling, append);
            String updateEdgeTableStr = "\nDECLARE\n  EID   NUMBER := ?;\n  SVID  NUMBER := ?;\n  DVID  NUMBER := ?;\n  EL    NVARCHAR2(" + this.nvarcharKLSize + ") := ?;\n  K     NVARCHAR2(" + this.nvarcharKLSize + ") := ?;\n  T     NUMBER(38) := ?;\n  V     NVARCHAR2(" + this.nvarcharVSize + "):= ?;\n  VN    NUMBER := ?;\n  VT    TIMESTAMP(6) WITH TIME ZONE := ?;\nBEGIN\n" + mergeStatements[0] + ";\n" + mergeStatements[1] + ";\n" + mergeStatements[2] + ";\nEND;";
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Preparing edge statement:[" + updateEdgeTableStr + "]");
            }
            preparedStatements[1] = this.prepareStatement(updateEdgeTableStr);
        }
    }

    private long updatePGTablesInStream(boolean updateVertexTable, boolean updateEdgeTable, ResultSet[] resultSets, PreparedStatement[] preparedStatements) throws SQLException {
        int count;
        int batchSize = this.getBatchSize();
        long updatedRows = 0L;
        if (updateVertexTable) {
            count = 0;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Updating PG vertex table");
            }
            while (resultSets[0].next()) {
                preparedStatements[0].setLong(1, resultSets[0].getLong(2));
                preparedStatements[0].setString(2, resultSets[0].getString(3));
                preparedStatements[0].setString(3, resultSets[0].getString(4));
                preparedStatements[0].setInt(4, resultSets[0].getInt(5));
                preparedStatements[0].setString(5, resultSets[0].getString(6));
                preparedStatements[0].setLong(6, resultSets[0].getLong(7));
                preparedStatements[0].setTimestamp(7, resultSets[0].getTimestamp(8, calendar), calendar);
                preparedStatements[0].addBatch();
                if (++count != batchSize) continue;
                updatedRows += (long)IntStream.of(preparedStatements[0].executeBatch()).sum();
                count = 0;
            }
            if (count > 0) {
                updatedRows += (long)IntStream.of(preparedStatements[0].executeBatch()).sum();
            }
        }
        if (updateEdgeTable) {
            count = 0;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Updating PG edge table");
            }
            while (resultSets[1].next()) {
                preparedStatements[1].setLong(1, resultSets[1].getLong(2));
                preparedStatements[1].setLong(2, resultSets[1].getLong(3));
                preparedStatements[1].setLong(3, resultSets[1].getLong(4));
                preparedStatements[1].setString(4, resultSets[1].getString(5));
                preparedStatements[1].setString(5, resultSets[1].getString(6));
                preparedStatements[1].setInt(6, resultSets[1].getInt(7));
                preparedStatements[1].setString(7, resultSets[1].getString(8));
                preparedStatements[1].setLong(8, resultSets[1].getLong(9));
                preparedStatements[1].setTimestamp(9, resultSets[1].getTimestamp(10, calendar), calendar);
                preparedStatements[1].addBatch();
                if (++count != batchSize) continue;
                updatedRows += (long)IntStream.of(preparedStatements[1].executeBatch()).sum();
                count = 0;
            }
            if (count > 0) {
                updatedRows += (long)IntStream.of(preparedStatements[1].executeBatch()).sum();
            }
        }
        return updatedRows;
    }

    private String[] getInsertIntoPGStatements(String selectStatement, String temporaryTableName, boolean isVertexTable, boolean insertRowId, int parallel, int dynamicSampling, boolean append) {
        String pgTableName;
        String hintSelect = DbmsUtils.buildHintString(parallel, dynamicSampling, false, false);
        String hintInsert = DbmsUtils.buildHintString(parallel, dynamicSampling, append, false);
        String insertColumns = "K, T, V, VN, VT";
        String rowIdCol = "";
        if (insertRowId) {
            rowIdCol = "PROP_ID, ";
        }
        if (isVertexTable) {
            String vertexColumns = PgqlTranslator.COLS[3] + ", ";
            if (this.ctx.useVLCol) {
                vertexColumns = vertexColumns + "VL, ";
            }
            insertColumns = vertexColumns + insertColumns;
            pgTableName = this.ctx.vtTab;
        } else {
            insertColumns = PgqlTranslator.COLS[0] + ", " + PgqlTranslator.COLS[1] + ", " + PgqlTranslator.COLS[2] + ", " + "EL" + ", " + insertColumns;
            pgTableName = this.ctx.geTab;
        }
        String[] insertStatements = new String[2];
        if (temporaryTableName != null) {
            insertStatements[0] = "INSERT " + hintInsert + "INTO " + temporaryTableName + "\n(" + rowIdCol + insertColumns + ")\n" + DbmsUtils.getQueryWrapper(selectStatement, parallel, dynamicSampling);
            selectStatement = "SELECT " + hintSelect + insertColumns + " FROM " + temporaryTableName;
        }
        insertStatements[1] = "INSERT " + hintInsert + "INTO " + pgTableName + "\n(" + insertColumns + ")\n" + DbmsUtils.getQueryWrapper(selectStatement, parallel, dynamicSampling);
        return insertStatements;
    }

    private long insertIntoPGTable(String selectStatement, boolean isVertexTable, int parallel, int dynamicSampling, boolean append) throws SQLException {
        return this.insertIntoPGTable(selectStatement, null, isVertexTable, false, parallel, dynamicSampling, append, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long insertIntoPGTable(String selectStatement, String temporaryTable, boolean isVertexTable, boolean insertRowId, int parallel, int dynamicSampling, boolean append, List<Object> bindValues) throws SQLException {
        long updatedRows;
        String[] insertStatements = this.getInsertIntoPGStatements(selectStatement, temporaryTable, isVertexTable, insertRowId, parallel, dynamicSampling, append);
        PreparedStatement ps = null;
        if (temporaryTable != null) {
            this.createTemporaryTables(isVertexTable, !isVertexTable, temporaryTable, temporaryTable);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Inserting into temporary PG table + " + temporaryTable + ":[" + insertStatements[0] + "]");
            }
            try {
                ps = this.prepareStatement(insertStatements[0]);
                DbmsUtils.setBindValues(ps, bindValues);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Inserting into PG table:[" + insertStatements[1] + "]");
        }
        try {
            ps = this.prepareStatement(insertStatements[1]);
            if (temporaryTable == null) {
                DbmsUtils.setBindValues(ps, bindValues);
            }
            updatedRows = ps.executeUpdate();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return updatedRows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doDelete(String[] deleteStatements, int parallel, int dynamicSampling, boolean append, List<Object> bindValues) throws SQLException {
        long updatedRows;
        String vertexTemporaryTable = PgqlUtils.getTemporaryTabName(this.ctx.pgqlConn.getJdbcConnection(), this.ctx.graphName, "VT");
        String edgeTemporaryTable = PgqlUtils.getTemporaryTabName(this.ctx.pgqlConn.getJdbcConnection(), this.ctx.graphName, "GE");
        boolean deleteFromVertexTable = deleteStatements[0] != null;
        boolean deleteFromEdgeTable = deleteStatements[1] != null;
        boolean deleteEdges = deleteFromEdgeTable || deleteFromVertexTable;
        Object[] statementsForDelete = this.getStatementsForDelete(deleteFromVertexTable, deleteEdges, vertexTemporaryTable, edgeTemporaryTable, deleteStatements, parallel, dynamicSampling, append, false);
        String[] vertexStatements = (String[])statementsForDelete[0];
        String[] edgeStatements = (String[])statementsForDelete[1];
        try {
            this.createTemporaryTablesForDelete(deleteFromVertexTable, deleteEdges, vertexStatements[0], edgeStatements[0]);
            int safeParallel = DbmsUtils.getParallelSafeValueForPTT(parallel, bindValues);
            this.populatePGTables(deleteStatements, deleteFromVertexTable, deleteFromEdgeTable, vertexTemporaryTable, edgeTemporaryTable, safeParallel, dynamicSampling, append, bindValues);
            if (deleteFromVertexTable) {
                this.addNeighborEdgesToTemporaryTable(edgeStatements[2]);
            }
            updatedRows = this.deleteFromPGTables(deleteFromVertexTable, deleteEdges, vertexStatements[2], edgeStatements[3]);
        }
        finally {
            this.dropTemporaryTables(deleteFromVertexTable, deleteEdges, vertexTemporaryTable, edgeTemporaryTable);
        }
        return updatedRows;
    }

    private Object[] getStatementsForDelete(boolean deleteVertices, boolean deleteEdges, String vertexTemporaryTable, String edgeTemporaryTable, String[] populateStatements, int parallel, int dynamicSampling, boolean append, boolean forTranslate) {
        String hintDelete = DbmsUtils.buildHintString(parallel, dynamicSampling, false, false);
        String[] vertexStatements = new String[3];
        String[] dropStatements = new String[2];
        if (deleteVertices) {
            vertexStatements[0] = "CREATE PRIVATE TEMPORARY TABLE " + vertexTemporaryTable + "(VID NUMBER) ON COMMIT DROP DEFINITION";
            vertexStatements[1] = populateStatements[0];
            if (forTranslate) {
                vertexStatements[1] = this.getInsertStatement(populateStatements[0], vertexTemporaryTable, parallel, dynamicSampling, append);
            }
            vertexStatements[2] = "DELETE " + hintDelete + "FROM " + this.ctx.vtTab + "\nWHERE VID IN(SELECT * FROM" + vertexTemporaryTable + ")";
            dropStatements[0] = "DROP TABLE " + vertexTemporaryTable;
        }
        String[] edgeStatements = new String[4];
        if (deleteEdges) {
            edgeStatements[0] = "CREATE PRIVATE TEMPORARY TABLE " + edgeTemporaryTable + "(EID NUMBER) ON COMMIT DROP DEFINITION";
            if (populateStatements[1] != null) {
                edgeStatements[1] = populateStatements[1];
                if (forTranslate) {
                    edgeStatements[1] = this.getInsertStatement(populateStatements[1], edgeTemporaryTable, parallel, dynamicSampling, append);
                }
            }
            if (deleteVertices) {
                if (forTranslate && !this.modifyCtx.getOption(ModifyContext.BooleanOption.DELETE_CASCADE)) {
                    throw new PgqlToSqlException("Attempting to translate deletion of vertices with incoming/outgoing edges. Turn on DELETE_CASCADE option");
                }
                String hintSelect = DbmsUtils.buildHintString(parallel, dynamicSampling, false, false);
                String hintInsert = DbmsUtils.buildHintString(parallel, dynamicSampling, append, false);
                edgeStatements[2] = "INSERT " + hintInsert + "INTO " + edgeTemporaryTable + "\nSELECT " + hintSelect + "DISTINCT g.EID FROM " + this.ctx.geTab + " g, " + vertexTemporaryTable + " t\nWHERE t.VID = g.SVID OR t.VID = g.DVID";
            } else {
                edgeStatements[2] = null;
            }
            edgeStatements[3] = "DELETE " + hintDelete + "FROM " + this.ctx.geTab + "\nWHERE EID IN(SELECT * FROM " + edgeTemporaryTable + ")";
            dropStatements[1] = "DROP TABLE " + edgeTemporaryTable;
        }
        return new Object[]{vertexStatements, edgeStatements, dropStatements};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTemporaryTablesForDelete(boolean createVertexTable, boolean createEdgeTable, String createVertexTableStr, String createEdgeTableStr) throws SQLException {
        try (Statement stmt = null;){
            if (createVertexTable) {
                stmt = this.createStatement(true);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Creating temporary vertex table:[" + createVertexTableStr + "]");
                }
                stmt.executeUpdate(createVertexTableStr);
                stmt.close();
            }
            if (createEdgeTable) {
                stmt = this.createStatement(true);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Creating temporary edge table:[" + createEdgeTableStr + "]");
                }
                stmt.executeUpdate(createEdgeTableStr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNeighborEdgesToTemporaryTable(String insertEdgesStr) throws SQLException {
        try (Statement stmt = null;){
            stmt = this.createStatement(true);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Inserting incoming/outgoing edges:[" + insertEdgesStr + "]");
            }
            long insertedRows = stmt.executeUpdate(insertEdgesStr);
            if (!this.modifyCtx.getOption(ModifyContext.BooleanOption.DELETE_CASCADE) && insertedRows > 0L) {
                throw new PgqlToSqlException("Attempting to delete vertices with incoming/outgoing edges. Drop edges first or turn on DELETE_CASCADE option");
            }
            stmt.close();
        }
    }

    private String getCreatePGSchemaStr(boolean forIndices) {
        String dopStr = "";
        String tbsStr = "";
        if (forIndices) {
            dopStr = "dop => :3, ";
        }
        if (PgqlUtils.DbFeature.CREATE_PG_WITH_TBS_SET.isSupported(this.ctx.dbVersion, this.ctx.opgVersion)) {
            tbsStr = "tbs_set => null, ";
        }
        return "{ call opg_apis.create_pg(graph_owner => :1, graph_name => :2, " + dopStr + tbsStr + "options => " + OPTIONS_BIND_VAR + ") }";
    }

    private String appendCreatePgOptions(String options) {
        String newOptions = options;
        String createPgOptions = this.modifyCtx.getOption(ModifyContext.StringOption.CREATE_PG_OPTIONS);
        if (createPgOptions != null) {
            newOptions = newOptions + "," + createPgOptions;
        }
        return newOptions;
    }

    private String getDropPGSchemaStr(String graphSchema, String graphName) throws SQLException {
        String dropStatement;
        if (graphName == null || !graphName.equals(graphName.toUpperCase())) {
            throw new PgqlToSqlException("PG schema graph names must be simple SQL names");
        }
        if (PgqlUtils.DbFeature.DROP_GRAPH_DIFFERENT_OWNER.isSupported(this.ctx.dbVersion, this.ctx.opgVersion)) {
            dropStatement = "{ call opg_apis.drop_pg(graph_owner => :1, graph_name => :2, options => '') }";
        } else {
            if (!this.isSchemaCurrentUser(graphSchema)) {
                throw new PgqlToSqlException("Cannot drop graph on a different schema.");
            }
            dropStatement = "{ call opg_apis.drop_pg(graph_name => :1) }";
        }
        return dropStatement;
    }

    private String getAnalyzePGStr() {
        String analyzeStatement = "{ call opg_apis.analyze_pg(graph_name => :1, degree => :2, cascade => DBMS_STATS.AUTO_CASCADE, no_invalidate => DBMS_STATS.AUTO_INVALIDATE, force => false, options => null";
        if (PgqlUtils.DbFeature.ANALYZE_PG_DIFFERENT_OWNER.isSupported(this.ctx.dbVersion, this.ctx.opgVersion)) {
            analyzeStatement = analyzeStatement + ", graph_owner => :3";
        }
        analyzeStatement = analyzeStatement + ") }";
        return analyzeStatement;
    }

    private boolean isSchemaCurrentUser(String graphSchema) throws SQLException {
        return graphSchema == null || graphSchema.equals(this.ctx.pgqlConn.getJdbcConnection().getMetaData().getUserName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPGSchemaTables(String graphSchema, String graphName) throws SQLException {
        CallableStatement cs = null;
        try {
            String createStr = this.getCreatePGSchemaStr(false);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Creating graph " + graphSchema + "." + graphName + ":\n" + createStr);
            }
            String optionsStr = this.appendCreatePgOptions(SKIP_INDEX_FLAG);
            cs = this.prepareCall(createStr);
            cs.setString(1, graphSchema);
            cs.setString(2, graphName);
            cs.setString(3, optionsStr);
            cs.execute();
        }
        catch (Throwable throwable) {
            DbmsUtils.quietlyCloseResultSetAndStmt(null, cs);
            throw throwable;
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(null, cs);
        this.checkGraphIsEmpty(graphName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createPGSchemaIndexes(String graphSchema, String graphName, int parallel) throws SQLException {
        CallableStatement cs = null;
        try {
            String createStr = this.getCreatePGSchemaStr(true);
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Creating graph " + graphSchema + "." + graphName + " indexes and triggers:\n" + createStr);
            }
            String optionsStr = this.appendCreatePgOptions(SKIP_TABLE_FLAG);
            cs = this.prepareCall(createStr);
            cs.setString(1, graphSchema);
            cs.setString(2, graphName);
            cs.setInt(3, parallel);
            cs.setString(4, optionsStr);
            cs.execute();
        }
        catch (Throwable throwable) {
            DbmsUtils.quietlyCloseResultSetAndStmt(null, cs);
            throw throwable;
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(null, cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherPGStats(String graphSchema, String graphName, int parallel) throws SQLException {
        CallableStatement cs = null;
        try {
            boolean isSupported = PgqlUtils.DbFeature.ANALYZE_PG_DIFFERENT_OWNER.isSupported(this.ctx.dbVersion, this.ctx.opgVersion);
            if (isSupported || this.isSchemaCurrentUser(graphSchema)) {
                String analyzeStr = this.getAnalyzePGStr();
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Gathering stats for graph " + graphSchema + "." + graphName + ":\n" + analyzeStr);
                }
                cs = this.prepareCall(analyzeStr);
                cs.setString(1, graphName);
                cs.setInt(2, parallel);
                if (isSupported) {
                    cs.setString(3, graphSchema);
                }
                cs.execute();
            }
        }
        finally {
            DbmsUtils.quietlyCloseResultSetAndStmt(null, cs);
        }
    }

    private void checkGraphIsEmpty(String graphName) throws SQLException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Checking that graph " + graphName + " is empty");
        }
        this.checkTableIsEmpty(this.ctx.vtTab);
        this.checkTableIsEmpty(this.ctx.geTab);
        if (this.ctx.useGtTab) {
            this.checkTableIsEmpty(this.ctx.gtTab);
        }
        if (this.ctx.useVdTab) {
            this.checkTableIsEmpty(this.ctx.vdTab);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTableIsEmpty(String tableName) throws SQLException {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            long totalRows;
            String countQuery = "SELECT COUNT(*) FROM " + tableName + " WHERE ROWNUM = 1";
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Checking if table " + tableName + " is empty:[" + countQuery + "]");
            }
            if ((rs = (stmt = this.createStatement(true)).executeQuery(countQuery)).next() && (totalRows = rs.getLong(1)) > 0L) {
                throw new PgqlToSqlException("Table " + tableName + " is not empty, cannot create graph");
            }
        }
        catch (Throwable throwable) {
            DbmsUtils.quietlyCloseResultSetAndStmt(rs, stmt);
            throw throwable;
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(rs, stmt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropPropertyGraph(String graphSchema, String graphName) throws SQLException {
        String dropStatement = this.getDropPGSchemaStr(graphSchema, graphName);
        String[] parameters = PgqlUtils.DbFeature.DROP_GRAPH_DIFFERENT_OWNER.isSupported(this.ctx.dbVersion, this.ctx.opgVersion) ? new String[]{graphSchema, graphName} : new String[]{graphName};
        CallableStatement cs = null;
        try {
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Dropping graph " + graphSchema + "." + graphName + ":\n" + dropStatement);
            }
            cs = this.prepareCall(dropStatement);
            for (int i = 0; i < parameters.length; ++i) {
                cs.setString(i + 1, parameters[i]);
            }
            cs.execute();
        }
        catch (Throwable throwable) {
            DbmsUtils.quietlyCloseResultSetAndStmt(null, cs);
            throw throwable;
        }
        DbmsUtils.quietlyCloseResultSetAndStmt(null, cs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long deleteFromPGTables(boolean deleteFromVertexTable, boolean deleteFromEdgeTable, String deleteVericesStr, String deleteEdgesStr) throws SQLException {
        Statement stmt = null;
        long updatedRows = 0L;
        try {
            if (deleteFromEdgeTable) {
                stmt = this.createStatement(true);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Deleting from edge table:[" + deleteEdgesStr + "]");
                }
                updatedRows += (long)stmt.executeUpdate(deleteEdgesStr);
                stmt.close();
                stmt = null;
            }
            if (deleteFromVertexTable) {
                stmt = this.createStatement(true);
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug("Deleting from vertex table:[" + deleteVericesStr + "]");
                }
                updatedRows += (long)stmt.executeUpdate(deleteVericesStr);
            }
        }
        finally {
            block13: {
                if (stmt != null) {
                    try {
                        stmt.close();
                    }
                    catch (SQLException ex) {
                        if (!ms_log.isDebugEnabled()) break block13;
                        ms_log.debug("Error closing stmt:[" + ex.getMessage() + "]");
                    }
                }
            }
        }
        return updatedRows;
    }

    private Savepoint populateDistinctTables(String[] populateStatements, String graphOwner, String graphName, int parallel, int dynamicSampling, boolean append) throws SQLException {
        String distinctVertexTableName = PgqlUtils.getDistinctVertexTabName(this.ctx.pgqlConn.getJdbcConnection(), graphOwner, graphName);
        String distinctEdgeTableName = PgqlUtils.getSkeletonTabName(this.ctx.pgqlConn.getJdbcConnection(), graphOwner, graphName);
        this.populatePGTables(populateStatements, this.ctx.useVdTab, false, distinctVertexTableName, null, parallel, dynamicSampling, append, null);
        this.commit();
        this.populatePGTables(populateStatements, false, this.ctx.useGtTab, null, distinctEdgeTableName, parallel, dynamicSampling, append, null);
        return this.commit();
    }

    @Override
    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    @Override
    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public int getBatchSize() {
        return this.batchSize;
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void close() throws PgqlException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Close called");
            ms_log.debug("Number of PgqlResultSets: [" + this.rsMap.size() + "]");
        }
        PgqlResultSet[] resultSets = this.rsMap.values().toArray(new PgqlResultSet[0]);
        for (int i = 0; i < resultSets.length; ++i) {
            PgqlResultSet rs = resultSets[i];
            if (ms_log.isDebugEnabled()) {
                ms_log.debug("Closing PgqlResultSet #" + i);
            }
            if (rs == null) continue;
            rs.close();
        }
        this.cancelOrClose(false);
    }

    @Override
    public void cancel() throws PgqlException {
        this.executionInfo.isCanceled = true;
        this.cancelOrClose(true);
    }

    private void cancelOrClose(boolean cancel) throws PgqlException {
        try {
            if (this.executionInfo.currentStmts != null) {
                ms_log.debug("Canceling or closing [" + this.executionInfo.currentStmts.length + "] statements");
                for (int i = 0; i < this.executionInfo.currentStmts.length; ++i) {
                    if (this.executionInfo.currentStmts[i] == null || this.executionInfo.currentStmts[i].isClosed()) continue;
                    Statement stmt = this.executionInfo.currentStmts[i];
                    if (cancel) {
                        stmt.cancel();
                        continue;
                    }
                    stmt.close();
                }
            }
        }
        catch (SQLException ex) {
            throw new PgqlException((Throwable)ex);
        }
    }

    void deregisterResultSet(long id) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Deregistering Result Set [" + id + "]");
        }
        this.rsMap.remove(id);
    }

    private void initQuery(String pgql) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("setting pgql string in prepareStatement");
            ms_log.debug("pgql=[" + pgql + "]");
        }
        this.pgql = pgql;
        this.bvInfo = BindValueInfo.getBindValueInfo();
        this.parsed = false;
        this.translated = false;
        this.prepared = false;
        this.prepareTimeout = 0;
        this.prepareParallel = 0;
        this.prepareDS = 2;
        this.prepareMaxResults = -1;
        this.translateMatchOptions = null;
        this.translateOptions = null;
        this.sqlTrans = null;
    }

    private void checkTableOrViewDoesNotExistError(Exception ex) throws PgqlToSqlException {
        if (ex.getMessage() != null && ex.getMessage().contains("ORA-00942") && this.sqlTrans != null) {
            String errorMessage;
            switch (this.sqlTrans.getTranslationType()) {
                case CREATE: {
                    errorMessage = "Some of the provided tables do not exist.";
                    break;
                }
                case DROP: {
                    errorMessage = "Graph " + this.ctx.schemaName + "." + this.ctx.graphName + " does not exist.";
                    break;
                }
                default: {
                    int countSchemaTables = PgqlUtils.countPgSchemaTables(this.ctx.pgqlConn.getJdbcConnection(), this.ctx.schemaName, this.ctx.graphName);
                    if (countSchemaTables > 0) {
                        errorMessage = "Some of the schema tables are missing.";
                        if (!this.ctx.useGtTab && !this.ctx.useVdTab) break;
                        errorMessage = errorMessage + " Please run opg_apis.migrate_pg_to_current('" + this.ctx.graphName + "') to make sure that " + this.ctx.vdTab + " and " + this.ctx.gtTab + " tables exist";
                        break;
                    }
                    errorMessage = "Graph " + this.ctx.schemaName + "." + this.ctx.graphName + " does not exist.";
                }
            }
            throw new PgqlToSqlException(errorMessage);
        }
    }

    private Savepoint commit() throws SQLException {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug("Performing commit...");
        }
        this.ctx.pgqlConn.getJdbcConnection().commit();
        return this.ctx.pgqlConn.getJdbcConnection().setSavepoint();
    }

    private Statement createStatement(boolean replaceExecutionStmt) throws SQLException {
        if (this.executionInfo.isCanceled) {
            throw new PgqlToSqlException(USER_REQUESTED_CANCEL_ERROR);
        }
        Statement stmt = this.ctx.pgqlConn.getJdbcConnection().createStatement();
        if (replaceExecutionStmt) {
            this.executionInfo.currentStmts = new Statement[]{stmt};
        }
        return stmt;
    }

    private PreparedStatement prepareStatement(String str) throws SQLException {
        if (this.executionInfo.isCanceled) {
            throw new PgqlToSqlException(USER_REQUESTED_CANCEL_ERROR);
        }
        PreparedStatement stmt = this.ctx.pgqlConn.getJdbcConnection().prepareStatement(str);
        this.executionInfo.currentStmts = new Statement[]{stmt};
        return stmt;
    }

    private void prepareQuery(int parallel, int dynamicSampling, int maxResults) throws SQLException {
        this.executionInfo = new ExecutionInfo();
        String sqlStr = ((PgqlSqlQueryTrans)this.sqlTrans).getSqlTranslation();
        sqlStr = DbmsUtils.getQueryWrapper(sqlStr, maxResults, parallel, dynamicSampling).toString();
        if (this.executionInfo.isCanceled) {
            throw new PgqlToSqlException(USER_REQUESTED_CANCEL_ERROR);
        }
        PreparedStatement stmt = this.ctx.pgqlConn.getJdbcConnection().prepareStatement(sqlStr, 1004, 1007);
        this.executionInfo.currentStmts = new Statement[]{stmt};
    }

    private void prepareModify(int parallel, int dynamicSampling) throws SQLException {
        PgViewModifyTrans modifyTrans = (PgViewModifyTrans)this.sqlTrans;
        this.executionInfo = new ExecutionInfo();
        this.dmlExecution = new PgViewDmlExecution(this.ctx.pgqlConn.getJdbcConnection(), this.executionInfo);
        boolean append = modifyTrans.getModifications().size() <= 1;
        int safeParallel = this.getParallelSafeValue(parallel, append);
        this.enableSessionParallel(safeParallel);
        this.dmlExecution.prepareModify(modifyTrans, safeParallel, dynamicSampling, append);
    }

    private void storePrepareParameters(int timeout, int parallel, int dynamicSampling, int maxResults) {
        this.prepared = true;
        this.prepareTimeout = timeout;
        this.prepareParallel = parallel;
        this.prepareDS = dynamicSampling;
        this.prepareMaxResults = maxResults;
    }

    private void checkStoredParameters(int timeout, int parallel, int dynamicSampling, int maxResults) {
        if (timeout != 0 && timeout != this.prepareTimeout) {
            throw new PgqlToSqlException("timeout [" + timeout + "] value used in execute is different from timeout [" + this.prepareTimeout + "] used in prepare");
        }
        if (parallel != 0 && parallel != this.prepareParallel) {
            throw new PgqlToSqlException("parallel [" + parallel + "] value used in execute is different from parallel [" + this.prepareParallel + "] used in prepare");
        }
        if (dynamicSampling != 2 && dynamicSampling != this.prepareDS) {
            throw new PgqlToSqlException("dynamicSampling [" + dynamicSampling + "] value used in execute is different from dynamicSampling [" + this.prepareDS + "] used in prepare");
        }
        if (maxResults != -1 && maxResults != this.prepareMaxResults) {
            throw new PgqlToSqlException("maxResults [" + maxResults + "] value used in execute is different from maxResults [" + this.prepareMaxResults + "] used in prepare");
        }
    }

    private CallableStatement prepareCall(String str) throws SQLException {
        if (this.executionInfo.isCanceled) {
            throw new PgqlToSqlException(USER_REQUESTED_CANCEL_ERROR);
        }
        CallableStatement stmt = this.ctx.pgqlConn.getJdbcConnection().prepareCall(str);
        this.executionInfo.currentStmts = new Statement[]{stmt};
        return stmt;
    }

    private void translateIfNecessary(String matchOptions, String options) throws PgqlException {
        if (this.parsed || this.translated) {
            if (matchOptions != null && !matchOptions.isEmpty() && !matchOptions.equals(this.translateMatchOptions)) {
                throw new PgqlToSqlException("matchOptions [" + matchOptions + "] provided are different from matchOptions [" + this.translateMatchOptions + "] used in prepare");
            }
            if (options != null && !options.isEmpty() && !options.equals(this.translateOptions)) {
                throw new PgqlToSqlException("options [" + options + "] provided are different from options [" + this.translateOptions + "] used in prepare");
            }
        }
        if (!this.translated) {
            if (this.parsed) {
                this.sqlTrans = this.pt.buildTranslation();
            } else if (this.isNotCachedTranslation(matchOptions, options)) {
                this.parseAndSetOptions(matchOptions, options);
                this.sqlTrans = this.pt.buildTranslation();
                if (this.ctx.graphType == GraphType.PG_VIEWS) {
                    this.cacheTranslation(matchOptions, options);
                }
            }
            this.executionInfo = new ExecutionInfo();
            this.parsed = true;
            this.translated = true;
        }
    }

    private boolean isNotCachedTranslation(String matchOptions, String options) {
        if (translationCache.containsTranslation(this.ctx.pgqlConn, this.pgql, matchOptions, options)) {
            ms_log.debug("Getting translation from the cache");
            TranslationCacheValue translation = translationCache.getTranslation(this.ctx.pgqlConn, this.pgql, matchOptions, options);
            if (!MetadataRefreshTimes.isRefreshed(this.ctx.pgqlConn, translation.getSchemaName(), translation.getGraphName())) {
                ms_log.debug("Cache is not refreshed, ignoring translated query");
                return true;
            }
            ms_log.debug("Checking if the current graph is PGM");
            if (translation.getGraphName().equals("PROPERTY_GRAPH_METADATA")) {
                try {
                    ms_log.debug("Starting PGM update");
                    GraphMetadataHandler.graphMetadataInitiator(this.ctx.pgqlConn, translation.getSchemaName());
                }
                catch (SQLException e) {
                    throw new PgqlToSqlException(e);
                }
            }
            this.sqlTrans = translation.getSqlTrans();
            this.bvInfo = translation.getBvInfo();
            this.translated = true;
            this.translateMatchOptions = matchOptions;
            this.translateOptions = options;
            this.ctx.graphType = GraphType.PG_VIEWS;
            return false;
        }
        ms_log.debug("Translation not in cache or cache disabled");
        return true;
    }

    private void cacheTranslation(String matchOptions, String options) {
        translationCache.cacheTranslation(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName, this.pgql, matchOptions, options, this.sqlTrans, this.bvInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void initTranslationCache() {
        if (translationCache != null) return;
        Class<TranslationCache> clazz = TranslationCache.class;
        synchronized (TranslationCache.class) {
            if (translationCache != null) return;
            translationCache = new TranslationCache();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static void clearTranslationCache(PgqlConnection pgqlConn) {
        PgqlExecution.initTranslationCache();
        translationCache.clear(pgqlConn.getJdbcConnection());
    }

    static void disableTranslationCache(PgqlConnection pgqlConn) {
        PgqlExecution.initTranslationCache();
        translationCache.disable(pgqlConn.getJdbcConnection());
    }

    static void enableTranslationCache(PgqlConnection pgqlConn) {
        PgqlExecution.initTranslationCache();
        translationCache.enable(pgqlConn.getJdbcConnection());
    }

    static void setTranslationCacheMaxCapacity(PgqlConnection pgqlConn, int maxCapacity) {
        PgqlExecution.initTranslationCache();
        translationCache.setMaxCapacity(pgqlConn.getJdbcConnection(), maxCapacity);
    }

    public static void deleteCache(PgqlConnection pgqlConn, String schema, String graphName) {
        if (translationCache != null) {
            translationCache.deleteGraphTranslations(pgqlConn, schema, graphName);
        }
        PgqlTranslator.deleteGraphMetadata(pgqlConn.getJdbcConnection(), schema, graphName);
    }

    private void parseAndSetOptions(String matchOptions, String options) throws PgqlException {
        this.pt.prepareTranslation(this.pgql, null, this.bvInfo);
        this.parsed = true;
        PgqlUtils.setQueryOptions(this.ctx, matchOptions);
        this.translateMatchOptions = matchOptions;
        PgqlUtils.setModifyOptions(this.modifyCtx, options);
        this.translateOptions = options;
        if (this.ctx.graphType == GraphType.PG_SCHEMA) {
            if (this.ctx.useExtdSize) {
                this.nvarcharKLSize = "3100";
                this.nvarcharVSize = "15000";
            } else {
                this.nvarcharKLSize = "2000";
                this.nvarcharVSize = "2000";
            }
        }
    }

    private void throwIfGraphExists() throws PgqlException {
        if (PgqlCreatePgUtils.existsGraph(this.ctx.pgqlConn, this.ctx.schemaName, this.ctx.graphName)) {
            throw new PgqlException("Graph " + this.ctx.schemaName + "." + this.ctx.graphName + " already exists");
        }
    }
}

