/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms.pgql;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import oracle.pg.rdbms.pgql.DbmsUtils;
import oracle.pg.rdbms.pgql.PgqlConnection;
import oracle.pg.rdbms.pgql.PgqlCpgRdbmsExpander;
import oracle.pg.rdbms.pgql.PgqlCreatePgUtils;
import oracle.pg.rdbms.pgql.PgqlCreatePgVerifier;
import oracle.pg.rdbms.pgql.PgqlSqlCreateTrans;
import oracle.pg.rdbms.pgql.PgqlSqlCreateTransImpl;
import oracle.pg.rdbms.pgql.PgqlToSqlException;
import oracle.pg.rdbms.pgql.PgqlTranslator;
import oracle.pg.rdbms.pgql.PgqlUtils;
import oracle.pg.rdbms.pgql.QueryContext;
import oracle.pgql.lang.ddl.propertygraph.CreatePropertyGraph;
import oracle.pgql.lang.ddl.propertygraph.EdgeTable;
import oracle.pgql.lang.ddl.propertygraph.ElementTable;
import oracle.pgql.lang.ddl.propertygraph.Label;
import oracle.pgql.lang.ddl.propertygraph.Property;
import oracle.pgql.lang.ddl.propertygraph.VertexTable;
import oracle.pgql.lang.ir.QueryExpression;
import oracle.pgql.lang.ir.SchemaQualifiedName;

public class PgqlCreatePgTranslator {
    private static final String VERTEX_ID_SELECT_COLUMNS = PgqlTranslator.COLS[3];
    private static final String EDGE_ID_SELECT_COLUMNS = PgqlTranslator.COLS[0] + ", " + PgqlTranslator.COLS[1] + ", " + PgqlTranslator.COLS[2];
    private static final String KEY_VALUE_SELECT_COLUMNS = ", K, T, V, VN, VT";
    private static final String KEY_COLUMN = "TABLE_KEY";
    private static final String UNPIVOT_COLUMN = "property_value";
    private static final String WITH_ALIAS = "T0";
    private static final String COLUMN_TYPE_CHAR = "CHAR";
    private static final String COLUMN_TYPE_DATE = "DATE";
    private static final String COLUMN_TYPE_NCHAR = "NCHAR";
    private static final String COLUMN_TYPE_NUMBER = "NUMBER";
    private static final String COLUMN_TYPE_NVARCHAR2 = "NVARCHAR2";
    private static final String COLUMN_TYPE_VARCHAR = "VARCHAR";
    private static final String COLUMN_TYPE_VARCHAR2 = "VARCHAR2";
    private static final String COLUMN_TYPE_TIMESTAMP = "TIMESTAMP";
    private static final String COLUMN_TYPE_TIMESTAMP_WITH_TIME_ZONE = "TIMESTAMP WITH TIME ZONE";
    private static final String ERROR_COLUMN_TYPE_NOT_SUPPORTED = "Column type not supported:";
    private static final int DEFAULT_PRECISION = 38;
    private static final int INT_MAXLENGHT = 9;
    private static final int LONG_MAXLENGHT = 18;
    private static final int FLOAT_SIGNIFFICANT_DIGITS = 6;
    private static final int FLOAT_MAX_EXPONENT = 38;
    private static final String NUMBER_FORMAT = "'TM9'";
    private static final String NLS_NUMERIC_CHARACTERS = "'NLS_Numeric_Characters=''.,'''";
    private static final String TIME_FORMAT = "'SYYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM'";
    private static Map<String, Integer> pgSchemaTypeMap = PgqlCreatePgTranslator.buildPGSchemaTypeMap();
    private static Map<String, String> pgSchemaValueExpression = PgqlCreatePgTranslator.buildPGSchemaValueExpressionMap();
    private static BiFunction<ElementTable, PgqlConnection, String> getVertexTableIdExpr = (table, pgqlConn) -> PgqlCreatePgTranslator.getTableIdHashExpr(pgqlConn, table, KEY_COLUMN, "");
    private static BiFunction<ElementTable, PgqlConnection, String> getEdgeTableIdExpr = (table, pgqlConn) -> {
        String suffix = "";
        if (table.getKey() == null) {
            suffix = " || '|' || " + PgqlTranslator.COLS[1] + " || '|' || " + PgqlTranslator.COLS[2];
        }
        return PgqlCreatePgTranslator.getTableIdHashExpr(pgqlConn, table, KEY_COLUMN, suffix);
    };
    private static BiFunction<ElementTable, PgqlConnection, String> getVertexSrcAndDstColumns = (table, pgqlConn) -> "";
    private static BiFunction<ElementTable, PgqlConnection, String> getEdgeSrcAndDstColumns = (table, pgqlConn) -> {
        EdgeTable edgeTable = (EdgeTable)table;
        VertexTable sourceVertexTable = edgeTable.getSourceVertexTable();
        String sourceKey = PgqlCreatePgUtils.getKeyExpr(pgqlConn, edgeTable.getEdgeSourceKey());
        VertexTable destinationVertexTable = edgeTable.getDestinationVertexTable();
        String destinationKey = PgqlCreatePgUtils.getKeyExpr(pgqlConn, edgeTable.getEdgeDestinationKey());
        return ",\n          " + PgqlCreatePgTranslator.getTableIdHashExpr(pgqlConn, (ElementTable)sourceVertexTable, sourceKey, "") + " AS " + PgqlTranslator.COLS[1] + ",\n          " + PgqlCreatePgTranslator.getTableIdHashExpr(pgqlConn, (ElementTable)destinationVertexTable, destinationKey, "") + " AS " + PgqlTranslator.COLS[2];
    };
    private static BiFunction<ElementTable, PgqlConnection, String> getVertexNullKeyChecks = (table, pgqlConn) -> "";
    private static BiFunction<ElementTable, PgqlConnection, String> getEdgeNullKeyChecks = (table, pgqlConn) -> {
        EdgeTable edgeTable = (EdgeTable)table;
        String sourceKey = PgqlCreatePgUtils.getNotNullKeyExpr(pgqlConn, edgeTable.getEdgeSourceKey());
        String destinationKey = PgqlCreatePgUtils.getNotNullKeyExpr(pgqlConn, edgeTable.getEdgeDestinationKey());
        return "\n        WHERE " + sourceKey + " IS NOT NULL AND " + destinationKey + " IS NOT NULL";
    };

    private static Map<String, Integer> buildPGSchemaTypeMap() {
        HashMap<String, Integer> pgSchemaTypeMap = new HashMap<String, Integer>();
        pgSchemaTypeMap.put(COLUMN_TYPE_CHAR, 1);
        pgSchemaTypeMap.put(COLUMN_TYPE_DATE, 5);
        pgSchemaTypeMap.put(COLUMN_TYPE_NCHAR, 1);
        pgSchemaTypeMap.put(COLUMN_TYPE_NUMBER, 4);
        pgSchemaTypeMap.put(COLUMN_TYPE_NVARCHAR2, 1);
        pgSchemaTypeMap.put(COLUMN_TYPE_VARCHAR, 1);
        pgSchemaTypeMap.put(COLUMN_TYPE_VARCHAR2, 1);
        pgSchemaTypeMap.put(COLUMN_TYPE_TIMESTAMP, 5);
        pgSchemaTypeMap.put(COLUMN_TYPE_TIMESTAMP_WITH_TIME_ZONE, 5);
        return pgSchemaTypeMap;
    }

    private static Map<String, String> buildPGSchemaValueExpressionMap() {
        HashMap<String, String> pgSchemaValueExpression = new HashMap<String, String>();
        pgSchemaValueExpression.put(COLUMN_TYPE_CHAR, "to_nchar(property_value) as V");
        pgSchemaValueExpression.put(COLUMN_TYPE_DATE, "from_tz(cast(property_value as timestamp), '+00:00') as VT");
        pgSchemaValueExpression.put(COLUMN_TYPE_NCHAR, "property_value as V");
        pgSchemaValueExpression.put(COLUMN_TYPE_NUMBER, "to_number(property_value) as VN");
        pgSchemaValueExpression.put(COLUMN_TYPE_NVARCHAR2, "property_value as V");
        pgSchemaValueExpression.put(COLUMN_TYPE_VARCHAR, "to_nchar(property_value) as V");
        pgSchemaValueExpression.put(COLUMN_TYPE_VARCHAR2, "to_nchar(property_value) as V");
        pgSchemaValueExpression.put(COLUMN_TYPE_TIMESTAMP, "from_tz(property_value, '+00:00') as VT");
        pgSchemaValueExpression.put(COLUMN_TYPE_TIMESTAMP_WITH_TIME_ZONE, "property_value as VT");
        return pgSchemaValueExpression;
    }

    public static PgqlSqlCreateTrans translateCreatePropertyGraph(CreatePropertyGraph cpg, QueryContext ctx) {
        PgqlConnection pgqlConn = ctx.pgqlConn;
        PgqlCpgRdbmsExpander expander = PgqlCpgRdbmsExpander.getPgqlCpgRdbmsExpander(pgqlConn, false);
        expander.expand(cpg);
        try {
            PgqlCreatePgVerifier.verify(cpg, null, false);
            SchemaQualifiedName tableName = cpg.getGraphName();
            String schemaName = DbmsUtils.sanitizeGraphOwner(pgqlConn.getJdbcConnection(), tableName.getSchemaName());
            String[] vertexTablesTranslation = PgqlCreatePgTranslator.translateTables(pgqlConn, cpg.getVertexTables(), VERTEX_ID_SELECT_COLUMNS, ctx.useVLCol, "VL", getVertexTableIdExpr, getVertexSrcAndDstColumns, getVertexNullKeyChecks);
            String[] edgeTablesTranslation = PgqlCreatePgTranslator.translateTables(pgqlConn, cpg.getEdgeTables(), EDGE_ID_SELECT_COLUMNS, true, "EL", getEdgeTableIdExpr, getEdgeSrcAndDstColumns, getEdgeNullKeyChecks);
            String[] distinctTablesTranslation = PgqlCreatePgTranslator.translateDistinctTables(pgqlConn, schemaName, tableName.getName(), ctx.useVLCol, ctx.useGtTab, ctx.useVdTab);
            Object[] translations = new Object[]{vertexTablesTranslation, edgeTablesTranslation, distinctTablesTranslation};
            return new PgqlSqlCreateTransImpl(tableName.getSchemaName(), tableName.getName(), translations);
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
    }

    private static String[] translateTables(PgqlConnection pgqlConn, List<? extends ElementTable> tables, String idColumns, boolean projectLabel, String labelColumn, BiFunction<ElementTable, PgqlConnection, String> getIdExpr, BiFunction<ElementTable, PgqlConnection, String> getSrcAndDstColumnsExpr, BiFunction<ElementTable, PgqlConnection, String> getNullKeyChecks) throws SQLException {
        if (tables.size() == 0) {
            return null;
        }
        String[] tablesTranslation = new String[tables.size()];
        for (int i = 0; i < tables.size(); ++i) {
            ElementTable et = tables.get(i);
            StringBuilder labelsTranslation = new StringBuilder();
            String keyExpr = PgqlCreatePgUtils.getKeyExpr(pgqlConn, et.getKey()) + " AS " + KEY_COLUMN;
            String idsExpr = getIdExpr.apply(et, pgqlConn);
            String srcAndDestColumnsExpr = getSrcAndDstColumnsExpr.apply(et, pgqlConn);
            String nullKeyChecks = getNullKeyChecks.apply(et, pgqlConn);
            if (et.getLabels().size() > 1) {
                throw new PgqlToSqlException("Table " + et.getTableAlias() + " has multiple labels. Multiple labels are not supported");
            }
            for (Label label : et.getLabels()) {
                SchemaQualifiedName tableName = et.getTableName();
                labelsTranslation.append((CharSequence)PgqlCreatePgTranslator.translateLabel(pgqlConn, label, idColumns, projectLabel, labelColumn, tableName.getSchemaName(), tableName.getName(), keyExpr, idsExpr, srcAndDestColumnsExpr, nullKeyChecks));
            }
            tablesTranslation[i] = "SELECT " + idColumns + PgqlCreatePgTranslator.prependCommaIfProjected(labelColumn, projectLabel) + KEY_VALUE_SELECT_COLUMNS + "\nFROM (" + labelsTranslation + "\n)";
        }
        return tablesTranslation;
    }

    private static StringBuilder translateLabel(PgqlConnection pgqlConn, Label label, String idColumns, boolean projectLabel, String labelColumn, String tableOwner, String tableName, String keyExpr, String idsExpr, String srcAndDstColumnsExpr, String nullKeyChecks) throws SQLException {
        List properties = label.getProperties();
        String labelNameExpr = "";
        if (projectLabel) {
            labelNameExpr = ", " + DbmsUtils.escapeAndEnquoteLiteral(label.getName()) + " AS " + labelColumn;
        }
        StringBuilder sb = new StringBuilder();
        StringBuilder sanitizedTableName = new StringBuilder().append(DbmsUtils.sanitizeGraphOwner(pgqlConn.getJdbcConnection(), tableOwner)).append(".").append(DbmsUtils.enquoteTableName(pgqlConn.getJdbcConnection(), tableName));
        StringBuilder columnNames = new StringBuilder();
        StringBuilder propertiesTranslation = new StringBuilder();
        String labelExpr = PgqlCreatePgTranslator.prependCommaIfProjected(labelColumn, projectLabel);
        if (properties.size() == 0) {
            propertiesTranslation.append("\n    SELECT ").append("\n      ").append(idColumns).append("\n      ").append(labelExpr).append(",").append("\n      to_nchar(null) AS ").append("K").append(",").append("\n      to_number(null) AS ").append("T").append(",").append("\n      to_nchar(null) AS ").append("V").append(",").append("\n      to_number(null) AS ").append("VN").append(",").append("\n      to_timestamp_tz(null) AS ").append("VT").append("\n    FROM ").append(WITH_ALIAS);
        } else {
            boolean addUnionAll = false;
            for (Property property : properties) {
                if (addUnionAll) {
                    propertiesTranslation.append("\n  UNION ALL");
                }
                addUnionAll = true;
                QueryExpression qe = property.getValueExpression();
                String columnName = ((QueryExpression.VarRef)qe).getVariable().getName();
                String propertyName = property.getPropertyName();
                columnNames.append(", ").append(DbmsUtils.enquoteTableName(pgqlConn.getJdbcConnection(), columnName));
                propertiesTranslation.append((CharSequence)PgqlCreatePgTranslator.translateProperty(pgqlConn, propertyName, tableOwner, tableName, columnName, idColumns, labelExpr));
            }
        }
        sb.append("\n  SELECT ").append("\n    ").append(idColumns).append(labelExpr).append(KEY_VALUE_SELECT_COLUMNS).append("\n  FROM(").append("\n    WITH ").append(WITH_ALIAS).append(" AS (").append("\n      SELECT /*+ materialize */").append("\n        ").append(idsExpr).append(" AS ").append(idColumns).append("\n        ").append(labelExpr).append((CharSequence)columnNames).append("\n      FROM ( ").append("\n        SELECT ").append("\n          ").append(keyExpr).append(srcAndDstColumnsExpr).append("\n          ").append(labelNameExpr).append((CharSequence)columnNames).append("\n        FROM ").append((CharSequence)sanitizedTableName).append(nullKeyChecks).append("\n      )").append("\n    )").append((CharSequence)propertiesTranslation).append("\n  )");
        return sb;
    }

    private static StringBuilder translateProperty(PgqlConnection pgqlConn, String propertyName, String tableOwner, String tableName, String columnName, String idColumns, String labelExpr) throws SQLException {
        String columnType = PgqlCreatePgUtils.getDataType(pgqlConn, tableOwner, tableName, columnName);
        String verifiedColumnName = DbmsUtils.enquoteTableName(pgqlConn.getJdbcConnection(), columnName);
        int pgType = PgqlCreatePgTranslator.getPGSchemaType(columnType);
        columnType = PgqlCreatePgUtils.removeTypePrecision(columnType);
        return new StringBuilder().append("\n    SELECT ").append(idColumns).append(labelExpr).append(", ").append("K").append(", ").append("T").append(", ").append(PgqlCreatePgTranslator.getVColumnTranslation(columnType)).append(", ").append("VN").append(", ").append("VT").append("\n    FROM (").append("\n      SELECT").append("\n        ").append(idColumns).append(labelExpr).append(", ").append("K").append(",").append("\n          to_number(").append(pgType).append(") AS ").append("T").append(",").append("\n          ").append((CharSequence)PgqlCreatePgTranslator.getValueColumnsTranslation(columnType)).append("\n      FROM ").append(WITH_ALIAS).append("\n      UNPIVOT (").append("\n        ").append(UNPIVOT_COLUMN).append(" FOR ").append("K").append(" IN (").append("\n          ").append(verifiedColumnName).append(" AS ").append(DbmsUtils.escapeAndEnquoteLiteral(propertyName)).append("\n        )").append("\n      )").append("\n    )");
    }

    public static int getPGSchemaType(String columnType) {
        if (columnType.startsWith(COLUMN_TYPE_NUMBER)) {
            return PgqlCreatePgTranslator.getPGSchemaTypeForNumber(columnType);
        }
        if (!pgSchemaTypeMap.containsKey(columnType)) {
            throw new PgqlToSqlException(ERROR_COLUMN_TYPE_NOT_SUPPORTED + columnType);
        }
        return pgSchemaTypeMap.get(columnType);
    }

    public static int getPGSchemaTypeForNumber(String columnType) {
        String precisionAndScale = PgqlCreatePgTranslator.getTypePrecision(columnType);
        if (precisionAndScale == null) {
            return 4;
        }
        String[] precisionAndScaleArray = precisionAndScale.split(",");
        String precision = precisionAndScaleArray[0];
        String scale = precisionAndScaleArray.length > 1 ? precisionAndScaleArray[1] : null;
        return PgqlCreatePgTranslator.getPGSchemaTypeForNumber(precision, scale);
    }

    private static String getTypePrecision(String columnType) {
        int parenStart = columnType.indexOf("(");
        if (parenStart > 0) {
            int parenEnd = columnType.indexOf(")");
            return columnType.substring(parenStart + 1, parenEnd);
        }
        return null;
    }

    public static int getPGSchemaTypeForNumber(String dataPrecision, String dataScale) {
        if (dataPrecision == null || dataPrecision.equals("0")) {
            return 4;
        }
        try {
            int scale;
            int precision = dataPrecision.equals("*") ? 38 : Integer.parseInt(dataPrecision);
            int n = scale = dataScale == null ? 0 : Integer.parseInt(dataScale);
            if (PgqlCreatePgTranslator.fitsInInteger(precision, scale)) {
                return 2;
            }
            if (PgqlCreatePgTranslator.fitsInLong(precision, scale)) {
                return 7;
            }
            if (PgqlCreatePgTranslator.fitsInFloat(precision, scale)) {
                return 3;
            }
        }
        catch (NumberFormatException nfe) {
            assert (false);
            return 4;
        }
        return 4;
    }

    private static boolean fitsInInteger(int precision, int scale) {
        if (scale > 0) {
            return false;
        }
        return precision - scale <= 9;
    }

    private static boolean fitsInLong(int precision, int scale) {
        if (scale > 0) {
            return false;
        }
        return precision - scale <= 18;
    }

    private static boolean fitsInFloat(int precision, int scale) {
        if (precision > 6) {
            return false;
        }
        return Math.abs(scale) <= 38;
    }

    public static String getPGSchemaValueExpression(String columnType) {
        if (!pgSchemaValueExpression.containsKey(columnType)) {
            throw new PgqlToSqlException(ERROR_COLUMN_TYPE_NOT_SUPPORTED + columnType);
        }
        return pgSchemaValueExpression.get(columnType);
    }

    public static StringBuilder getValueColumnsTranslation(String columnType) {
        int pgSchemaType = PgqlCreatePgTranslator.getPGSchemaType(columnType);
        String vExpr = "to_nchar(null) as V";
        String vnExpr = "to_number(null) as VN";
        String vtExpr = "to_timestamp_tz(null) VT";
        String newExpr = PgqlCreatePgTranslator.getPGSchemaValueExpression(columnType);
        switch (pgSchemaType) {
            case 1: {
                vExpr = newExpr;
                break;
            }
            case 4: {
                vnExpr = newExpr;
                break;
            }
            case 5: {
                vtExpr = newExpr;
            }
        }
        return new StringBuilder().append(vExpr).append(", ").append(vnExpr).append(", ").append(vtExpr);
    }

    public static String getVColumnTranslation(String columnType) {
        switch (columnType) {
            case "NUMBER": {
                return "to_nchar(VN, 'TM9', 'NLS_Numeric_Characters=''.,''') || n'' AS V";
            }
            case "DATE": 
            case "TIMESTAMP": 
            case "TIMESTAMP WITH TIME ZONE": {
                return "to_nchar(VT, 'SYYYY-MM-DD\"T\"HH24:MI:SS.FF9TZH:TZM') AS V";
            }
        }
        return "V";
    }

    private static String getTableIdHashExpr(PgqlConnection pgqlConn, ElementTable table, String key, String suffix) {
        String sanitizedAlias;
        try {
            sanitizedAlias = DbmsUtils.enquoteTableName(pgqlConn.getJdbcConnection(), table.getTableAlias());
        }
        catch (SQLException ex) {
            throw new PgqlToSqlException(ex);
        }
        return "round(sys_op_combined_hash(" + DbmsUtils.escapeAndEnquoteLiteral(sanitizedAlias) + " || '|' || " + key + suffix + ")/2)";
    }

    private static String prependCommaIfProjected(String label, boolean projectLabel) {
        if (projectLabel) {
            return ", " + label;
        }
        return "";
    }

    private static String[] translateDistinctTables(PgqlConnection pgqlConn, String graphOwner, String graphName, boolean populateVLColumn, boolean useGtTab, boolean useVdTab) throws SQLException {
        String[] populateStatements = new String[2];
        if (useVdTab) {
            String vertexTableName = PgqlUtils.getVertexTabName(pgqlConn.getJdbcConnection(), graphOwner, graphName);
            String vlClause = "";
            if (populateVLColumn) {
                vlClause = ", VL";
            }
            populateStatements[0] = "\nSELECT VID" + vlClause + ", CNT\nFROM (SELECT VID" + vlClause + ", COUNT(*) AS CNT\n      FROM " + vertexTableName + "\n      GROUP BY VID" + vlClause + ")";
        } else {
            populateStatements[0] = null;
        }
        if (useGtTab) {
            String edgeTableName = PgqlUtils.getEdgeTabName(pgqlConn.getJdbcConnection(), graphOwner, graphName);
            populateStatements[1] = "\nSELECT EID, EL, SVID, DVID, sys_op_numtoraw(sys_op_combined_hash(EL)) AS ELH, lengthb(EL) AS ELS, CNT\nFROM (SELECT EID, EL, SVID, DVID, COUNT(*) AS CNT\n      FROM " + edgeTableName + "\n      GROUP BY EID, SVID, DVID, EL)";
        } else {
            populateStatements[1] = null;
        }
        return populateStatements;
    }
}

