/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import oracle.pgx.common.Link;
import oracle.pgx.common.LinkRel;
import oracle.pgx.common.Self;
import oracle.pgx.config.LinkTemplate;

public class AsyncStatus
extends Self {
    @JsonIgnore
    private final String futureUuid;
    private String progress;
    private boolean completed;
    private Integer intervalToPoll;
    @JsonIgnore
    private final Context context;

    public AsyncStatus() {
        this.futureUuid = null;
        this.context = null;
    }

    public AsyncStatus(String futureUuid, Context context) {
        super((Object)futureUuid);
        this.futureUuid = futureUuid;
        this.context = context;
        this.injectLinks();
    }

    public String getProgress() {
        return this.progress.toString();
    }

    public void setProgress(String progress) {
        this.progress = progress;
    }

    public Boolean getCompleted() {
        return this.completed;
    }

    public void setCompleted(Boolean completed) {
        this.completed = completed;
    }

    public int getIntervalToPoll() {
        return this.intervalToPoll;
    }

    public void setIntervalToPoll(Integer intervalToPoll) {
        this.intervalToPoll = intervalToPoll;
    }

    public void injectLinks() {
        Link selfLink = new Link(LinkTemplate.FUTURE_STATUS.generateLink(this.context.toString()), LinkRel.SELF, Link.Method.GET);
        Link abortLink = new Link(LinkTemplate.FUTURE_CANCEL.generateLink(this.context.toString()), LinkRel.ABORT, Link.Method.DELETE);
        this.addLinks(new Link[]{selfLink, abortLink});
    }

    public static enum Context {
        CONTROL,
        CORE;


        public String toString() {
            return this.name().toLowerCase();
        }
    }

    public static enum Progress {
        SUCCEEDED,
        FAILED,
        PROCESSING,
        PENDING,
        ABORTED,
        PAUSED;

    }
}

