/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import oracle.pg.common.SimpleLog;
import oracle.pg.rdbms.DataChange;
import oracle.pg.rdbms.OracleCommonIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraph;
import oracle.pg.rdbms.OraclePropertyGraphException;
import oracle.pg.rdbms.Parameters;
import oracle.pg.rdbms.VertexChange;

public class VertexChangeIteratorImpl
extends OracleCommonIteratorImpl
implements Iterator<VertexChange> {
    static SimpleLog ms_log = SimpleLog.getLog(VertexChangeIteratorImpl.class);
    private boolean supportVertexLabels;

    VertexChangeIteratorImpl(ResultSet rs, boolean bTreatTimestampTzAsStr, boolean supportVertexLabels) {
        ms_log.debug((Object)"VertexChangeIteratorImpl: constructor");
        this.rs = rs;
        this.m_bTreatTimestampTzAsStr = bTreatTimestampTzAsStr;
        this.bNextInovked = false;
        this.bNextExhausted = false;
        this.supportVertexLabels = supportVertexLabels;
    }

    public void close() {
    }

    @Override
    public VertexChange next() {
        boolean b;
        if (ms_log.isDebugEnabled() && Parameters.getInstance().isSuperVerboseOn()) {
            ms_log.debug((Object)"next: start");
        }
        if (!this.bNextInovked && !(b = this.hasNext())) {
            throw new OraclePropertyGraphException(MSG_ERR_NO_ELEM_TO_BE_CONSUMED.toString());
        }
        VertexChange vc = null;
        try {
            Long lVID = this.rs.getLong(1);
            String szKey = this.rs.getString(2);
            Object val = OraclePropertyGraph.readObjFromResultSet(this.rs, 3, this.m_bTreatTimestampTzAsStr);
            String szOperation = this.rs.getString(7);
            Long longStartSCN = this.rs.getLong(8);
            Long longEndSCN = this.rs.getLong(9);
            String szXID = this.rs.getString(10);
            String szLabel = null;
            if (this.supportVertexLabels) {
                szLabel = this.rs.getString(11);
            }
            vc = VertexChange.getInstance(DataChange.translateIntoChangeAction(szOperation), lVID, szKey, val, longStartSCN, longEndSCN, szXID, szLabel);
            this.moveCursor();
            if (this.m_gracefulTimeout) {
                this.m_bTimedOut = this.checkGracefulTimeout();
            } else {
                this.checkQueryExecutionTimeOut();
            }
        }
        catch (Exception sqle) {
            ms_log.debug((Object)"next: Exception ", (Throwable)sqle);
            try {
                this.safeCloseAndDeregisterIfNeeded(this.rs);
                this.rs = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sqle instanceof SQLException) {
                if (((SQLException)sqle).getErrorCode() == 1013) {
                    this.m_bHitTimeoutAlready = true;
                    ms_log.debug((Object)"next: Query timeout exception(1013)");
                    if (this.m_gracefulTimeout) {
                        return vc;
                    }
                }
            } else {
                ms_log.debug((Object)"next: exception ", (Throwable)sqle);
            }
            throw new OraclePropertyGraphException(sqle);
        }
        return vc;
    }
}

