/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.NoSuchElementException;
import oracle.pg.common.CloseableIterator;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.rdbms.OracleElementIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraph;
import oracle.pg.rdbms.OraclePropertyGraphException;
import oracle.pg.rdbms.OracleVertex;
import oracle.pg.rdbms.Parameters;

public class OracleVertexIteratorImpl
extends OracleElementIteratorImpl
implements CloseableIterator<OracleVertexBase> {
    static SimpleLog ms_log = SimpleLog.getLog(OracleVertexIteratorImpl.class);
    private OracleVertex EMPTY_VERTEX = OracleVertex.getEmptyInstance();
    private boolean supportVertexLabels;

    public OracleVertex next() {
        if (ms_log.isDebugEnabled() && Parameters.getInstance().isSuperVerboseOn()) {
            ms_log.debug((Object)"next: start");
        }
        if (!this.bNextInovked) {
            ms_log.debug((Object)"next: invoke hasNext because bNextInovked is false");
            boolean b = this.hasNext();
            if (!b) {
                throw new NoSuchElementException("No element in this iterator to be consumed");
            }
        }
        OracleVertex ov = null;
        try {
            long lPreviousID = 0L;
            OracleVertex vPrevious = null;
            while (!this.bNextExhausted) {
                Long lVID = this.rs.getLong(1);
                if (this.m_optFlag != null && this.m_optFlag.equals((Object)OraclePropertyGraphBase.OptimizationFlag.DO_NOT_CREATE_OBJECT)) {
                    this.moveCursor();
                    return this.EMPTY_VERTEX;
                }
                if (this.m_optFlag != null && this.m_optFlag.equals((Object)OraclePropertyGraphBase.OptimizationFlag.JUST_VERTEX_ID)) {
                    this.moveCursor();
                    ov = OracleVertex.getInstance(this.m_opg, lVID, true, this.getSkipStoreToCache());
                    ov.setCreatedWithOptFlag(true);
                    return ov;
                }
                if (vPrevious != null && lVID == lPreviousID) {
                    ms_log.debug((Object)"next: the same Vertex. reuse");
                    ov = vPrevious;
                } else {
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"next: a different Vertex. ", (Object)lVID);
                    }
                    if (vPrevious != null) break;
                    String szLabel = null;
                    if (this.supportVertexLabels) {
                        szLabel = this.rs.getString(2);
                    }
                    ov = OracleVertex.getInstance(this.m_opg, lVID, true, this.getSkipStoreToCache(), szLabel);
                    lPreviousID = lVID;
                }
                int idx = 2;
                if (this.supportVertexLabels) {
                    idx = 3;
                }
                vPrevious = ov;
                String szKey = this.rs.getString(idx++);
                Object val = OraclePropertyGraph.readObjFromResultSet(this.rs, idx, this.m_opg.getTreatTimestampTzAsStr());
                if (val != null) {
                    ov.property(szKey, val, true, true);
                }
                if (ms_log.isDebugEnabled()) {
                    ms_log.debug((Object)"next: ov ", ov.id());
                }
                this.moveCursor();
            }
            if (this.m_gracefulTimeout) {
                this.m_bTimedOut = this.checkGracefulTimeout();
            } else {
                this.checkQueryExecutionTimeOut();
            }
        }
        catch (Exception sqle) {
            ms_log.debug((Object)"next: SQLException ", (Throwable)sqle);
            try {
                this.safeCloseAndDeregisterIfNeeded(this.rs);
                this.rs = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sqle instanceof SQLException) {
                if (((SQLException)sqle).getErrorCode() == 1013) {
                    this.m_bHitTimeoutAlready = true;
                    ms_log.debug((Object)"next: Query timeout exception(1013)");
                    if (this.m_gracefulTimeout) {
                        ++this.m_lNextCallCount;
                        return ov;
                    }
                }
            } else {
                ms_log.debug((Object)"next: exception ", (Throwable)sqle);
            }
            throw new OraclePropertyGraphException(sqle);
        }
        ++this.m_lNextCallCount;
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"next: m_lNextCallCount ", (Object)Long.toString(this.m_lNextCallCount));
        }
        return ov;
    }

    public OracleVertexIteratorImpl(OraclePropertyGraph opg, ResultSet rs, OraclePropertyGraphBase.OptimizationFlag flag) {
        super(opg, rs, flag);
        ms_log.debug((Object)"OracleVertexIteratorImpl: constructor");
        this.supportVertexLabels = this.m_opg.supportVertexLabels();
        this.bNextInovked = false;
        this.bNextExhausted = false;
    }

    OracleVertexIteratorImpl(OraclePropertyGraph opg, ResultSet rs, OraclePropertyGraphBase.OptimizationFlag flag, int queryFetchSize) throws SQLException {
        this(opg, rs, flag);
        ms_log.debug((Object)"OracleVertexIteratorImpl: constructor");
        this.setQueryFetchSize(queryFetchSize);
    }

    OracleVertexIteratorImpl(OraclePropertyGraph opg, ResultSet rs, OraclePropertyGraphBase.OptimizationFlag flag, int queryFetchSize, boolean skipStoreToCache) throws SQLException {
        this(opg, rs, flag);
        ms_log.debug((Object)"OracleVertexIteratorImpl: constructor");
        this.setQueryFetchSize(queryFetchSize);
        this.setSkipStoreToCache(skipStoreToCache);
    }
}

