/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import oracle.jdbc.OraclePreparedStatement;
import oracle.pg.common.Direction;
import oracle.pg.common.OracleEdgeBase;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.OraclePropertyGraphException;
import oracle.pg.common.OracleVertexBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.common.VertexCache;
import oracle.pg.rdbms.OracleEdge;
import oracle.pg.rdbms.OracleEdgeIteratorImpl;
import oracle.pg.rdbms.OracleElementIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraph;
import oracle.pg.rdbms.OracleVertexIteratorImpl;
import oracle.pg.rdbms.Parameters;

public class OracleVertex
extends OracleVertexBase {
    static SimpleLog ms_log = SimpleLog.getLog(OracleVertex.class);
    static boolean ms_bDebug = ms_log.isDebugEnabled();
    private static OracleVertex ms_emptyVertex = null;
    private OraclePropertyGraph m_opgRdbms;

    OracleVertex() {
    }

    OracleVertex(OraclePropertyGraph opg, Long vid, String label) {
        super((OraclePropertyGraphBase)opg, vid, label);
        this.m_opgRdbms = (OraclePropertyGraph)this.m_opg;
    }

    public static OracleVertex getInstance(OraclePropertyGraph opg, Long vid) {
        return OracleVertex.getInstance(opg, vid, true);
    }

    public static OracleVertex getInstance(OraclePropertyGraph opg, Long vid, boolean bCreateIfAbsentFromCache) {
        return OracleVertex.getInstance(opg, vid, bCreateIfAbsentFromCache, false);
    }

    public static OracleVertex getInstance(OraclePropertyGraph opg, Long vid, boolean bCreateIfAbsentFromCache, boolean bSkipStoreToCache) {
        return OracleVertex.getInstance(opg, vid, bCreateIfAbsentFromCache, bSkipStoreToCache, null);
    }

    public static OracleVertex getInstance(OraclePropertyGraph opg, Long vid, boolean bCreateIfAbsentFromCache, boolean bSkipStoreToCache, String label) {
        OracleVertex ov = null;
        VertexCache vc = opg.getVertexCache();
        if (vc != null) {
            ov = (OracleVertex)vc.get(vid);
        }
        if (ov != null) {
            ms_log.debug((Object)"getInstance: fetched one vertex from the cache");
            return ov;
        }
        if (bCreateIfAbsentFromCache) {
            ov = new OracleVertex(opg, vid, label);
            if (vc != null && !bSkipStoreToCache) {
                ms_log.debug((Object)"getInstance: start a new vertex and put into the cache");
                vc.put((OracleVertexBase)ov);
            } else {
                ms_log.debug((Object)"getInstance: start a new vertex. skip caching");
            }
        } else {
            ms_log.debug((Object)"getInstance: return NULL per bCreateIfAbsentFromCache");
        }
        return ov;
    }

    private String generateLabel(String ... labels) {
        StringBuilder sb = new StringBuilder(" and (");
        StringBuilder sbLbls = new StringBuilder();
        boolean bNullLbl = false;
        String szNullLbl = " EL IS NULL ";
        if (labels != null && labels.length > 0) {
            sbLbls.append(" EL in (");
            int iCount = 0;
            for (String szLbl : labels) {
                if (szLbl == null) {
                    bNullLbl = true;
                    continue;
                }
                if (iCount > 0) {
                    sbLbls.append(",");
                }
                sbLbls.append("?");
                ++iCount;
            }
            sbLbls.append(") ");
            if (iCount == 0 && bNullLbl) {
                return sb.append(szNullLbl).append(") ").toString();
            }
            if (!bNullLbl) {
                return sb.append((CharSequence)sbLbls).append(") ").toString();
            }
            return sb.append(szNullLbl).append(" or ").append((CharSequence)sbLbls).append(") ").toString();
        }
        return "";
    }

    ResultSet setArgs(PreparedStatement ps, String s, String ... labels) throws SQLException {
        int iCount = 1;
        ps.setString(iCount++, s);
        if (labels != null && labels.length > 0) {
            for (String szLbl : labels) {
                if (szLbl == null) continue;
                ((OraclePreparedStatement)ps).setFormOfUse(iCount, (short)2);
                ps.setString(iCount++, szLbl);
            }
        }
        ResultSet rs = ps.executeQuery();
        return rs;
    }

    ResultSet setArgs(PreparedStatement ps, String s, String s2, String ... labels) throws SQLException {
        int iCount = 1;
        ps.setString(iCount++, s);
        ps.setString(iCount++, s2);
        if (labels != null && labels.length > 0) {
            for (String szLbl : labels) {
                if (szLbl == null) continue;
                ((OraclePreparedStatement)ps).setFormOfUse(iCount, (short)2);
                ps.setString(iCount++, szLbl);
            }
        }
        ResultSet rs = ps.executeQuery();
        return rs;
    }

    ResultSet setArgsUnion(PreparedStatement ps, String s, String s2, String ... labels) throws SQLException {
        int iCount = 1;
        ps.setString(iCount++, s);
        if (labels != null && labels.length > 0) {
            for (String szLbl : labels) {
                if (szLbl == null) continue;
                ((OraclePreparedStatement)ps).setFormOfUse(iCount, (short)2);
                ps.setString(iCount++, szLbl);
            }
        }
        ps.setString(iCount++, s2);
        if (labels != null && labels.length > 0) {
            for (String szLbl : labels) {
                if (szLbl == null) continue;
                ((OraclePreparedStatement)ps).setFormOfUse(iCount, (short)2);
                ps.setString(iCount++, szLbl);
            }
        }
        ResultSet rs = ps.executeQuery();
        return rs;
    }

    @Deprecated
    public Iterator<OracleEdgeBase> edges(Direction direction, OraclePropertyGraphBase.OptimizationFlag flag, String ... labels) {
        this.m_opgRdbms.flushUpdates();
        return this.edgesNoFlush(direction, flag, labels);
    }

    @Deprecated
    Iterator<OracleEdgeBase> edgesNoFlush(Direction direction, OraclePropertyGraphBase.OptimizationFlag flag, String ... labels) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"edges: for vertex ", (Object)(this.id() + " , start with direction and labels. Direction is " + direction));
            if (labels != null && labels.length > 0) {
                ms_log.debug((Object)"edges: labels specified ");
            } else {
                ms_log.debug((Object)"edges: no label specified ");
            }
        }
        if (labels != null && labels.length > 0) {
            for (int i = 0; i < labels.length; ++i) {
                if (labels[i] == null || !labels[i].isEmpty()) continue;
                labels[i] = OracleEdge.EMPTY_LBL;
            }
        }
        ResultSet rs = null;
        OracleEdgeIteratorImpl iterator = null;
        PreparedStatement ps = null;
        try {
            if (Direction.OUT.equals((Object)direction)) {
                ms_log.debug((Object)"edges: OUT");
                StringBuilder sbQuery = new StringBuilder("select /*+ parallel(1) */ eid,SVID,DVID,el,k,t,v,vn," + this.m_opgRdbms.processVT("vt") + ",vts,vte from ").append(this.m_opgRdbms.getEdgeTabName()).append(" where SVID=? ").append(this.generateLabel(labels)).append(" order by eid ");
                ps = this.m_opgRdbms.getOracle().getConnection().prepareStatement(sbQuery.toString());
                rs = this.setArgs(ps, this.id().toString(), labels);
            } else if (Direction.IN.equals((Object)direction)) {
                ms_log.debug((Object)"edges: IN");
                ps = this.m_opgRdbms.getOracle().getConnection().prepareStatement("select /*+ parallel(1) */ eid,SVID,DVID,el,k,t,v,vn," + this.m_opgRdbms.processVT("vt") + ",vts,vte from " + this.m_opgRdbms.getEdgeTabName() + " where DVID=? " + this.generateLabel(labels) + " order by eid ");
                rs = this.setArgs(ps, this.id().toString(), labels);
            } else if (Direction.BOTH.equals((Object)direction)) {
                ms_log.debug((Object)"edges: BOTH");
                StringBuilder sbQuery = new StringBuilder("select /*+ parallel(1) */ eid,SVID,DVID,el,k,t,v,vn," + this.m_opgRdbms.processVT("vt") + ",vts,vte from ").append(this.m_opgRdbms.getEdgeTabName()).append(" where (DVID=? or SVID=?) ").append(this.generateLabel(labels)).append(" order by eid ");
                ps = this.m_opgRdbms.getOracle().getConnection().prepareStatement(sbQuery.toString());
                rs = this.setArgs(ps, this.id().toString(), this.id().toString(), labels);
            }
            iterator = new OracleEdgeIteratorImpl(this.m_opgRdbms, rs, flag);
            iterator.setQueryFetchSize(this.m_opgRdbms.getQueryFetchSize());
        }
        catch (SQLException e) {
            ms_log.error((Object)"edges:", (Throwable)e);
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        finally {
            ms_log.debug((Object)"edges: done ________");
        }
        return iterator;
    }

    @Deprecated
    public Iterator<OracleVertexBase> vertices(Direction direction, OraclePropertyGraphBase.OptimizationFlag flag, String ... labels) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)"vertices: start with direction and labels. Direction is ", (Object)direction);
        }
        int iLblCount = 0;
        if (labels != null && labels.length > 0) {
            for (int i = 0; i < labels.length; ++i) {
                if (labels[i] != null && labels[i].isEmpty()) {
                    labels[i] = OracleEdge.EMPTY_LBL;
                    if (ms_log.isDebugEnabled()) {
                        ms_log.debug((Object)"vertices: label used is ", (Object)labels[i]);
                    }
                }
                ++iLblCount;
            }
        }
        this.m_opgRdbms.flushUpdates();
        ResultSet rs = null;
        PreparedStatement ps = null;
        OracleVertexIteratorImpl iterator = null;
        try {
            int idx;
            int iCount;
            String szStmt = null;
            StringBuilder sb = new StringBuilder();
            sb.append(" select /*+ parallel(1) */ ").append(this.m_opgRdbms.getVerticesProjectedVars()).append(" from ").append(this.m_opgRdbms.getVertexTabName()).append(" where vid in (");
            if (direction.equals((Object)Direction.OUT)) {
                sb.append("    select DVID from ").append(this.m_opgRdbms.getEdgeTabName()).append("     where ");
                if (iLblCount > 0) {
                    sb.append(" el in (");
                    iCount = 0;
                    for (idx = 0; idx < labels.length; ++idx) {
                        if (++iCount == 1) {
                            sb.append("?");
                            continue;
                        }
                        sb.append(",?");
                    }
                    sb.append(" ) and ");
                }
                sb.append(" SVID = ? ) order by VID ");
            } else if (direction.equals((Object)Direction.IN)) {
                sb.append("    select SVID from ").append(this.m_opgRdbms.getEdgeTabName()).append("     where ");
                if (iLblCount > 0) {
                    sb.append(" el in (");
                    iCount = 0;
                    for (idx = 0; idx < labels.length; ++idx) {
                        if (++iCount == 1) {
                            sb.append("?");
                            continue;
                        }
                        sb.append(",?");
                    }
                    sb.append(" ) and ");
                }
                sb.append(" DVID = ? ) order by VID ");
            } else {
                sb.append("    select decode(SVID, ?, DVID, SVID) from ").append(this.m_opgRdbms.getEdgeTabName()).append("     where ");
                if (iLblCount > 0) {
                    sb.append(" el in (");
                    iCount = 0;
                    for (idx = 0; idx < labels.length; ++idx) {
                        if (++iCount == 1) {
                            sb.append("?");
                            continue;
                        }
                        sb.append(",?");
                    }
                    sb.append(" ) and ");
                }
                sb.append(" (DVID=? or SVID = ?)) order by VID ");
            }
            szStmt = sb.toString();
            ps = this.m_opgRdbms.getOracle().getConnection().prepareStatement(szStmt);
            iCount = 0;
            if (direction.equals((Object)Direction.BOTH)) {
                ps.setLong(++iCount, (Long)this.id());
            }
            if (iLblCount > 0) {
                for (String szLabel : labels) {
                    ((OraclePreparedStatement)ps).setFormOfUse(++iCount, (short)2);
                    ps.setString(iCount, szLabel);
                }
            }
            ps.setLong(++iCount, (Long)this.id());
            if (direction.equals((Object)Direction.BOTH)) {
                ps.setLong(++iCount, (Long)this.id());
            }
            rs = ps.executeQuery();
            iterator = new OracleVertexIteratorImpl(this.m_opgRdbms, rs, flag);
            iterator.setQueryFetchSize(this.m_opgRdbms.getQueryFetchSize());
        }
        catch (SQLException e) {
            ms_log.error((Object)"vertices:", (Throwable)e);
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs, ps);
            throw new OraclePropertyGraphException((Throwable)e);
        }
        finally {
            ms_log.debug((Object)"vertices: done .................... ");
        }
        return iterator;
    }

    @Deprecated
    public long degree(Direction direction, String ... labels) {
        long sbQuery22;
        ResultSet rs;
        block17: {
            StringBuilder sbQuery22;
            if (ms_log.isDebugEnabled()) {
                ms_log.debug((Object)"degree: for vertex ", (Object)(this.id() + " , start with direction and labels. Direction is " + direction));
                if (labels != null && labels.length > 0) {
                    ms_log.debug((Object)"edges: labels specified ");
                } else {
                    ms_log.debug((Object)"degree: no label specified ");
                }
            }
            if (labels != null && labels.length > 0) {
                for (int i = 0; i < labels.length; ++i) {
                    if (labels[i] == null || !labels[i].isEmpty()) continue;
                    labels[i] = OracleEdge.EMPTY_LBL;
                }
            }
            this.m_opgRdbms.flushUpdates();
            rs = null;
            PreparedStatement ps = null;
            if (Direction.OUT.equals((Object)direction)) {
                ms_log.debug((Object)"degree: OUT");
                sbQuery22 = new StringBuilder("select count(*) from (select distinct eid from ").append(this.m_opgRdbms.getEdgeTabName()).append(" where SVID=? ").append(this.generateLabel(labels)).append(" )");
                ms_log.debug((Object)"degree: Dir=OUT query stmt ", (Object)sbQuery22.toString());
                ps = this.m_opgRdbms.getOracle().getConnection().prepareStatement(sbQuery22.toString());
                rs = this.setArgs(ps, this.id().toString(), labels);
            } else if (Direction.IN.equals((Object)direction)) {
                ms_log.debug((Object)"degree: IN");
                ps = this.m_opgRdbms.getOracle().getConnection().prepareStatement("select count(*) from (select distinct eid from " + this.m_opgRdbms.getEdgeTabName() + " where DVID=? " + this.generateLabel(labels) + ")");
                rs = this.setArgs(ps, this.id().toString(), labels);
            } else if (Direction.BOTH.equals((Object)direction)) {
                ms_log.debug((Object)"degree: BOTH");
                sbQuery22 = null;
                if (Parameters.getInstance().getUseDisjunctionInGetDegree()) {
                    sbQuery22 = new StringBuilder("select count (*) from (select distinct eid from ").append(this.m_opgRdbms.getEdgeTabName()).append(" where (DVID=? or SVID=?) ").append(this.generateLabel(labels)).append(" )");
                    ms_log.debug((Object)"degree: Dir=BOTH query stmt ", (Object)sbQuery22.toString());
                    ps = this.m_opgRdbms.getOracle().getConnection().prepareStatement(sbQuery22.toString());
                    rs = this.setArgs(ps, this.id().toString(), this.id().toString(), labels);
                } else {
                    sbQuery22 = new StringBuilder("select count (*) from ((select eid from ").append(this.m_opgRdbms.getEdgeTabName()).append(" where DVID=? ").append(this.generateLabel(labels)).append(" )").append(" union ( select eid from ").append(this.m_opgRdbms.getEdgeTabName()).append(" where SVID=? ").append(this.generateLabel(labels)).append(" ))");
                    ms_log.debug((Object)"degree: Dir=BOTH query stmt ", (Object)sbQuery22.toString());
                    ps = this.m_opgRdbms.getOracle().getConnection().prepareStatement(sbQuery22.toString());
                    rs = this.setArgsUnion(ps, this.id().toString(), this.id().toString(), labels);
                }
            }
            if (rs == null || !rs.next()) break block17;
            long sbQuery22 = rs.getLong(1);
            OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs);
            ms_log.debug((Object)"degree: done ________");
            return sbQuery22;
        }
        try {
            ms_log.debug((Object)"degree: no elements found, return 0");
            sbQuery22 = 0L;
        }
        catch (SQLException e) {
            try {
                ms_log.error((Object)"degree:", (Throwable)e);
                throw new OraclePropertyGraphException((Throwable)e);
            }
            catch (Throwable throwable) {
                OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs);
                ms_log.debug((Object)"degree: done ________");
                throw throwable;
            }
        }
        OracleElementIteratorImpl.quietlyCloseResultSetAndStmt(rs);
        ms_log.debug((Object)"degree: done ________");
        return sbQuery22;
    }

    public static OracleVertex getEmptyInstance() {
        if (ms_emptyVertex == null) {
            ms_emptyVertex = new OracleVertex();
            ms_emptyVertex.setCreatedWithOptFlag(true);
        }
        return ms_emptyVertex;
    }
}

