/*
 * Decompiled with CFR 0.152.
 */
package oracle.pg.rdbms;

import java.sql.ResultSet;
import java.sql.Statement;
import oracle.pg.common.OraclePropertyGraphBase;
import oracle.pg.common.SimpleLog;
import oracle.pg.rdbms.OracleCommonIteratorImpl;
import oracle.pg.rdbms.OraclePropertyGraph;
import oracle.pg.rdbms.OraclePropertyGraphUtils;

public abstract class OracleElementIteratorImpl
extends OracleCommonIteratorImpl {
    static SimpleLog ms_log = SimpleLog.getLog(OracleElementIteratorImpl.class);
    protected OraclePropertyGraph m_opg = null;
    protected int queryFetchSize = 1000;
    protected OraclePropertyGraphBase.OptimizationFlag m_optFlag = null;
    protected long m_lCount = 0L;
    protected long m_lPrevTime = System.currentTimeMillis();
    protected boolean m_bSkipStoreToCache = false;
    protected boolean m_bClosed = false;

    protected OracleElementIteratorImpl() {
    }

    protected OracleElementIteratorImpl(OraclePropertyGraph opg, ResultSet rs, OraclePropertyGraphBase.OptimizationFlag flag) {
        this.m_opg = opg;
        this.rs = rs;
        this.m_optFlag = flag;
        this.bNextInovked = false;
        this.bNextExhausted = false;
        ms_log.debug((Object)"constructor: done");
    }

    static void quietlyCloseResultSet(ResultSet rs) {
        OraclePropertyGraphUtils.quietlyCloseResultSet((ResultSet)rs);
    }

    public static void quietlyCloseResultSetAndStmt(ResultSet rs, Statement stmt) {
        OraclePropertyGraphUtils.quietlyCloseResultSetAndStmt((ResultSet)rs, (Statement)stmt);
    }

    static void quietlyCloseResultSetAndStmt(ResultSet rs) {
        OraclePropertyGraphUtils.quietlyCloseResultSetAndStmt((ResultSet)rs);
    }

    public static void quietlyCloseStmt(Statement stmt) {
        OraclePropertyGraphUtils.quietlyCloseStmt((Statement)stmt);
    }

    protected boolean getSkipStoreToCache() {
        return this.m_bSkipStoreToCache;
    }

    protected void setSkipStoreToCache(boolean b) {
        if (ms_log.isDebugEnabled()) {
            ms_log.debug((Object)("setSkipStoreToCache: new value " + b));
        }
        this.m_bSkipStoreToCache = b;
    }

    public OraclePropertyGraph getPropertyGraph() {
        return this.m_opg;
    }

    public void close() {
        if (this.m_bClosed) {
            return;
        }
        ms_log.debug((Object)"close: started");
        this.safeCloseAndDeregisterIfNeeded(this.rs);
        this.rs = null;
        this.m_bClosed = true;
        if (this.m_opg.isTransientPropertyGraphInstance()) {
            ms_log.debug((Object)"close instance ", (Object)this.m_opg);
            this.m_opg.dispose();
        }
        ms_log.debug((Object)"close: done");
    }
}

