/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import oracle.pgx.common.types.IdType;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractGraphConfigBuilder;
import oracle.pgx.config.AbstractGraphConfigFactory;
import oracle.pgx.config.Format;
import oracle.pgx.config.RdbmsEntityProviderConfig;
import oracle.pgx.config.RdfGraphConfig;
import oracle.pgx.config.RdfGraphConfigFactory;
import oracle.pgx.config.RdfGraphPrefixConfig;

public final class RdfGraphConfigBuilder
extends AbstractGraphConfigBuilder<RdfGraphConfigBuilder, RdfGraphConfig> {
    private static final String PREFIX_RDF = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
    private static final String RDF = "rdf";
    private static final String PREFIX_OWL = "http://www.w3.org/2002/07/owl#";
    private static final String OWL = "owl";
    private static final String PREFIX_RDFS = "http://www.w3.org/2000/01/rdf-schema#";
    private static final String RDFS = "rdfs";
    private static final String PREFIX_XSD = "http://www.w3.org/2001/XMLSchema#";
    private static final String XSD = "xsd";
    private static final String PREFIX_DC = "http://purl.org/dc/elements/1.1/";
    private static final String DC = "dc";
    private static final String PREFIX_FOAF = "http://xmlns.com/foaf/0.1/";
    private static final String FOAF = "foaf";
    private final List<String> vertexLabelPredicates = new LinkedList<String>();
    private final List<String> ignoredPredicates = new LinkedList<String>();
    private final List<String> acceptedPredicates = new LinkedList<String>();
    private final List<Map<String, Object>> prefixes = new LinkedList<Map<String, Object>>();

    public static RdfGraphConfigBuilder forFormat(Format format) {
        return new RdfGraphConfigBuilder().setFormat(format);
    }

    public RdfGraphConfigBuilder() {
        this.values.put(RdfGraphConfig.Field.VERTEX_LABEL_PREDICATES.toKey(), this.vertexLabelPredicates);
        this.values.put(RdfGraphConfig.Field.IGNORED_PREDICATES.toKey(), this.ignoredPredicates);
        this.values.put(RdfGraphConfig.Field.ACCEPTED_PREDICATES.toKey(), this.acceptedPredicates);
        this.values.put(RdfGraphConfig.Field.PREFIXES.toKey(), this.prefixes);
        this.values.put(RdfGraphConfig.Field.FORMAT.toKey(), Format.RDF);
        this.setVertexIdType(IdType.STRING);
        this.addPrefix(RDF, PREFIX_RDF);
        this.addPrefix(OWL, PREFIX_OWL);
        this.addPrefix(RDFS, PREFIX_RDFS);
        this.addPrefix(XSD, PREFIX_XSD);
        this.addPrefix(FOAF, PREFIX_FOAF);
        this.addPrefix(DC, PREFIX_DC);
    }

    @Override
    protected AbstractGraphConfigFactory<RdfGraphConfig> getFactory() {
        return new RdfGraphConfigFactory(true, true);
    }

    @Override
    public RdfGraphConfigBuilder copyFrom(RdfGraphConfig graphConfig) {
        super.copyFrom(graphConfig);
        this.setDataSourceId(graphConfig.getDataSourceId());
        this.setJdbcUrl(graphConfig.getJdbcUrl());
        this.setUsername(graphConfig.getUsername());
        this.setPassword((String)graphConfig.getValues().get(RdfGraphConfig.Field.PASSWORD));
        this.setVertexIdType(graphConfig.getVertexIdType());
        this.setName(graphConfig.getName());
        this.setNetworkOwner(graphConfig.getNetworkOwner());
        this.setNetworkName(graphConfig.getNetworkName());
        this.setUsePrefix(graphConfig.usePrefix());
        this.setParallelHintDegree(graphConfig.getParallelHintDegree());
        this.vertexLabelPredicates.addAll(graphConfig.getVertexLabelPredicates());
        this.ignoredPredicates.addAll(graphConfig.getIgnoredPredicates());
        this.acceptedPredicates.addAll(graphConfig.getAcceptedPredicates());
        graphConfig.getPrefixes().forEach(prefixConfig -> this.addPrefix(prefixConfig.getPrefix(), prefixConfig.getValue()));
        return (RdfGraphConfigBuilder)this.getThis();
    }

    @Override
    public RdfGraphConfigBuilder setVertexIdType(IdType vertexIdType) {
        if (vertexIdType != IdType.LONG && vertexIdType != IdType.STRING) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"UNSUPPORTED_NODE_KEY_TYPE", (Object[])new Object[]{vertexIdType}));
        }
        return (RdfGraphConfigBuilder)super.setVertexIdType(vertexIdType);
    }

    public RdfGraphConfigBuilder setFormat(Format format) {
        if (format != Format.RDF) {
            throw new IllegalArgumentException("Only " + Format.RDF.toString() + "is supported.");
        }
        this.values.put(RdfGraphConfig.Field.FORMAT.toKey(), format);
        return this;
    }

    public RdfGraphConfigBuilder setDataSourceId(String dataSourceId) {
        this.values.put(RdfGraphConfig.Field.DATA_SOURCE_ID.toKey(), dataSourceId);
        return this;
    }

    public RdfGraphConfigBuilder setJdbcUrl(String url) {
        this.values.put(RdfGraphConfig.Field.JDBC_URL.toKey(), url);
        return this;
    }

    public RdfGraphConfigBuilder setUsername(String un) {
        this.values.put(RdfGraphConfig.Field.USERNAME.toKey(), un);
        return this;
    }

    public RdfGraphConfigBuilder setName(String model) {
        this.values.put(RdfGraphConfig.Field.NAME.toKey(), model);
        return this;
    }

    public RdfGraphConfigBuilder setNetworkName(String network) {
        if (network != null && !network.isEmpty()) {
            this.values.put(RdfGraphConfig.Field.NETWORK_NAME.toKey(), network);
        }
        return this;
    }

    public RdfGraphConfigBuilder setNetworkOwner(String owner) {
        if (owner != null && !owner.isEmpty()) {
            this.values.put(RdfGraphConfig.Field.NETWORK_OWNER.toKey(), owner);
        }
        return this;
    }

    public RdfGraphConfigBuilder setUsePrefix(boolean usePrefix) {
        this.values.put(RdfGraphConfig.Field.USE_PREFIX.toKey(), usePrefix);
        return this;
    }

    public RdfGraphConfigBuilder addVertexLabelPredicate(String predicate) {
        this.vertexLabelPredicates.add(predicate);
        return this;
    }

    public RdfGraphConfigBuilder addIgnoredPredicate(String predicate) {
        this.ignoredPredicates.add(predicate);
        return this;
    }

    public RdfGraphConfigBuilder addAcceptedPredicate(String predicate) {
        this.acceptedPredicates.add(predicate);
        return this;
    }

    public RdfGraphConfigBuilder addPrefix(String name, String value) {
        HashMap<String, String> alias = new HashMap<String, String>();
        alias.put(RdfGraphPrefixConfig.Field.PREFIX.toKey(), name);
        if (value.startsWith("<") && value.endsWith(">")) {
            value = value.substring(1, value.length() - 1);
        }
        alias.put(RdfGraphPrefixConfig.Field.VALUE.toKey(), value);
        this.prefixes.add(alias);
        return this;
    }

    public RdfGraphConfigBuilder setParallelHintDegree(int parallelHintDegree) {
        this.values.put(RdbmsEntityProviderConfig.Field.PARALLEL_HINT_DEGREE.toKey(), parallelHintDegree);
        return this;
    }
}

