/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.config;

import java.util.Objects;
import oracle.pgx.common.util.ErrorMessages;
import oracle.pgx.config.AbstractConfig;
import oracle.pgx.vfs.CompressionScheme;

public abstract class AbstractFileGraphStoringConfig
extends AbstractConfig {
    public abstract Integer getNumPartitions();

    public abstract String getBasePath();

    public abstract Integer getInitialPartitionIndex();

    public abstract String getVertexExtension();

    public abstract String getEdgeExtension();

    public abstract String getRowExtension();

    public abstract CompressionScheme getCompressionScheme();

    public abstract Character getDelimiter();

    public Character getSeparator() {
        return this.getDelimiter();
    }

    @Override
    protected void validate() {
        super.validate();
        if (this.getNumPartitions() <= 0) {
            throw new IllegalArgumentException(ErrorMessages.getMessage((String)"INVALID_STORE_NUM_PARTITIONS", (Object[])new Object[]{this.getNumPartitions()}));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractFileGraphStoringConfig that = (AbstractFileGraphStoringConfig)o;
        if (!Objects.equals(this.getNumPartitions(), that.getNumPartitions())) {
            return false;
        }
        if (!Objects.equals(this.getBasePath(), that.getBasePath())) {
            return false;
        }
        if (!Objects.equals(this.getInitialPartitionIndex(), that.getInitialPartitionIndex())) {
            return false;
        }
        if (!Objects.equals(this.getVertexExtension(), that.getVertexExtension())) {
            return false;
        }
        if (!Objects.equals(this.getEdgeExtension(), that.getEdgeExtension())) {
            return false;
        }
        if (!Objects.equals(this.getRowExtension(), that.getRowExtension())) {
            return false;
        }
        return Objects.equals(this.getDelimiter(), that.getDelimiter());
    }

    public int hashCode() {
        int code = Objects.hashCode(this.getNumPartitions());
        code += Objects.hashCode(this.getBasePath());
        code += Objects.hashCode(this.getInitialPartitionIndex());
        code += Objects.hashCode(this.getVertexExtension());
        code += Objects.hashCode(this.getEdgeExtension());
        code += Objects.hashCode(this.getRowExtension());
        return code += Objects.hashCode(this.getDelimiter());
    }
}

