/*
 * Decompiled with CFR 0.152.
 */
package oracle.pgx.common.util;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.StreamReadConstraints;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.google.json.JsonSanitizer;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import oracle.pgx.common.util.DoubleModule;
import oracle.pgx.common.util.GraphConfigModule;
import oracle.pgx.common.util.Java8TemporalModule;
import oracle.pgx.common.util.PointModule;

public class ConfigJsonUtil {
    private static final ConfigJsonUtil UTIL = new ConfigJsonUtil();
    private final ObjectMapper objectMapper = this.getObjectMapperInstance();

    public static DeserializationContext getDeserializationContext() {
        return ConfigJsonUtil.getUtil().getInstanceDeserializationContext();
    }

    public static JsonParser treeAsTokens(TreeNode node) {
        return ConfigJsonUtil.getUtil().instanceTreeAsTokens(node);
    }

    public static <T> T treeToValue(TreeNode node, Class<T> type) throws JsonProcessingException {
        return ConfigJsonUtil.getUtil().instanceTreeToValue(node, type);
    }

    public static <T> T reparseObject(Object object, Class<T> newType) throws IOException {
        return ConfigJsonUtil.getUtil().instanceReparseObject(object, newType);
    }

    public static String toJsonNullable(Object object) throws JsonProcessingException {
        return ConfigJsonUtil.getUtil().instanceToJsonNullable(object);
    }

    public static String toJson(Object object) throws JsonProcessingException {
        return ConfigJsonUtil.getUtil().instanceToJson(object);
    }

    public static <T> T fromJsonNode(JsonNode node, Class<T> type) throws JsonProcessingException {
        return ConfigJsonUtil.getUtil().instanceFromJsonNode(node, type);
    }

    public static <T> T fromJsonInputStream(InputStream jsonInputStream, Class<T> type) throws JsonParseException, JsonMappingException, IOException {
        return ConfigJsonUtil.getUtil().instanceFromJsonInputStream(jsonInputStream, type);
    }

    public static InputStream toJsonInputStream(Object object) throws JsonProcessingException {
        return ConfigJsonUtil.getUtil().instanceToJsonInputStream(object);
    }

    public static JsonNode readTree(File file) throws IOException, JsonProcessingException {
        return ConfigJsonUtil.getUtil().instanceReadTree(file);
    }

    static <T extends JsonNode> T valueToTree(Object fromValue) throws IllegalArgumentException {
        return ConfigJsonUtil.getUtil().instanceValueToTree(fromValue);
    }

    public static JsonParser getValues(JsonNode node, String value) {
        return ConfigJsonUtil.treeAsTokens((TreeNode)node.get(value));
    }

    public static String sanitize(String input) {
        return JsonSanitizer.sanitize((String)input);
    }

    public static TypeFactory getTypeFactory() {
        return ConfigJsonUtil.getUtil().instanceGetTypeFactory();
    }

    public static JsonNode readTopLevelJsonToTree(String json) throws JsonGenerationException, JsonMappingException, IOException {
        return ConfigJsonUtil.getUtil().instanceReadTopLevelJsonToTree(json);
    }

    public static <T> T readTopLevelJson(String json, Class<T> type) throws IOException, JsonParseException, JsonMappingException {
        return ConfigJsonUtil.getUtil().instanceReadTopLevelJson(json, type);
    }

    public static <T> T readTopLevelJson(String json, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        return ConfigJsonUtil.getUtil().instanceReadTopLevelJson(json, valueType);
    }

    public static <T> T readValue(JsonParser p, TypeReference<T> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return ConfigJsonUtil.getUtil().instanceReadValue(p, valueTypeRef);
    }

    public static <T> T readValue(JsonParser p, Class<T> type) throws IOException, JsonParseException, JsonMappingException {
        return ConfigJsonUtil.getUtil().instanceReadValue(p, type);
    }

    public static <T> T readValue(JsonParser p, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        return ConfigJsonUtil.getUtil().instanceReadValue(p, valueType);
    }

    public static <T> T readValue(String content, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        if (content == null || content.length() == 0) {
            return null;
        }
        return ConfigJsonUtil.getUtil().instanceReadValue(content, valueType);
    }

    public static <T> T readValue(File content, JavaType valueType) throws IOException {
        return ConfigJsonUtil.getUtil().instanceReadValue(content, valueType);
    }

    public static <T> T readValue(String content, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return ConfigJsonUtil.getUtil().instanceReadValue(content, valueType);
    }

    public static <T> T readValue(InputStream src, TypeReference<T> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return ConfigJsonUtil.getUtil().instanceReadValue(src, valueTypeRef);
    }

    public static byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
        return ConfigJsonUtil.getUtil().instanceWriteValueAsBytes(value);
    }

    static ObjectWriter writerWithDefaultPrettyPrinter() {
        return ConfigJsonUtil.getUtil().instanceWriterWithDefaultPrettyPrinter();
    }

    private static ConfigJsonUtil getUtil() {
        return UTIL;
    }

    static void configureObjectMapper(ObjectMapper objectMapper) {
        objectMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        objectMapper.configure(JsonParser.Feature.ALLOW_SINGLE_QUOTES, true);
        objectMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.configOverride(Map.Entry.class).setFormat(JsonFormat.Value.forShape((JsonFormat.Shape)JsonFormat.Shape.OBJECT));
        ConfigJsonUtil.configureStringMaxLength(objectMapper);
    }

    public static void configureStringMaxLength(ObjectMapper objectMapper) {
        StreamReadConstraints streamReadConstraints = StreamReadConstraints.builder().maxStringLength(0x1400000).build();
        objectMapper.getFactory().setStreamReadConstraints(streamReadConstraints);
    }

    protected ConfigJsonUtil() {
    }

    private ObjectMapper getObjectMapperInstance() {
        ObjectMapper objectMapper = new ObjectMapper();
        ConfigJsonUtil.configureObjectMapper(objectMapper);
        this.registerModules(objectMapper);
        return objectMapper;
    }

    public static ObjectMapper forkObjectMapper() {
        return ConfigJsonUtil.getUtil().getObjectMapperInstance();
    }

    protected void registerModules(ObjectMapper objectMapper) {
        objectMapper.registerModule((Module)new Java8TemporalModule());
        objectMapper.registerModule((Module)new PointModule());
        objectMapper.registerModule((Module)new GraphConfigModule());
        objectMapper.registerModule((Module)new DoubleModule());
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected DeserializationContext getInstanceDeserializationContext() {
        return this.getObjectMapper().getDeserializationContext();
    }

    protected JsonParser instanceTreeAsTokens(TreeNode node) {
        return this.getObjectMapper().treeAsTokens(node);
    }

    protected <T> T instanceTreeToValue(TreeNode node, Class<T> type) throws JsonProcessingException {
        return (T)this.getObjectMapper().treeToValue(node, type);
    }

    protected <T> T instanceReparseObject(Object object, Class<T> newType) throws IOException {
        String json = ConfigJsonUtil.toJson(object);
        return ConfigJsonUtil.readValue(json, newType);
    }

    protected String instanceToJsonNullable(Object object) throws JsonProcessingException {
        return this.getObjectMapper().writeValueAsString(object);
    }

    protected String instanceToJson(Object object) throws JsonProcessingException {
        if (object == null) {
            return null;
        }
        return this.instanceToJsonNullable(object);
    }

    protected <T> T instanceFromJsonNode(JsonNode node, Class<T> type) throws JsonProcessingException {
        if (node == null) {
            return null;
        }
        return (T)this.getObjectMapper().treeToValue((TreeNode)node, type);
    }

    protected <T> T instanceFromJsonInputStream(InputStream jsonInputStream, Class<T> type) throws JsonParseException, JsonMappingException, IOException {
        if (jsonInputStream == null) {
            return null;
        }
        return (T)this.getObjectMapper().readValue(jsonInputStream, type);
    }

    protected InputStream instanceToJsonInputStream(Object object) throws JsonProcessingException {
        return new ByteArrayInputStream(this.getObjectMapper().writeValueAsBytes(object));
    }

    protected JsonNode instanceReadTree(File file) throws IOException, JsonProcessingException {
        return this.getObjectMapper().readTree(file);
    }

    <T extends JsonNode> T instanceValueToTree(Object fromValue) throws IllegalArgumentException {
        return (T)this.getObjectMapper().valueToTree(fromValue);
    }

    protected TypeFactory instanceGetTypeFactory() {
        return this.getObjectMapper().getTypeFactory();
    }

    protected JsonNode instanceReadTopLevelJsonToTree(String json) throws JsonGenerationException, JsonMappingException, IOException {
        String sanitizedJson = ConfigJsonUtil.sanitize(json);
        return this.getObjectMapper().readTree(sanitizedJson);
    }

    protected <T> T instanceReadTopLevelJson(String json, Class<T> type) throws IOException, JsonParseException, JsonMappingException {
        String sanitizedJson = ConfigJsonUtil.sanitize(json);
        return this.instanceReadValue(sanitizedJson, type);
    }

    protected <T> T instanceReadTopLevelJson(String json, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this.getObjectMapper().readValue(json, valueType);
    }

    protected <T> T instanceReadValue(JsonParser p, TypeReference<T> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return (T)this.getObjectMapper().readValue(p, valueTypeRef);
    }

    protected <T> T instanceReadValue(JsonParser p, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this.getObjectMapper().readValue(p, valueType);
    }

    protected <T> T instanceReadValue(JsonParser p, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        return (T)this.getObjectMapper().readValue(p, valueType);
    }

    protected <T> T instanceReadValue(String content, JavaType valueType) throws IOException, JsonParseException, JsonMappingException {
        if (content == null || content.length() == 0) {
            return null;
        }
        return (T)this.getObjectMapper().readValue(content, valueType);
    }

    protected <T> T instanceReadValue(File content, JavaType valueType) throws IOException {
        if (content == null || !content.exists()) {
            return null;
        }
        return (T)this.getObjectMapper().readValue(content, valueType);
    }

    protected <T> T instanceReadValue(String content, Class<T> valueType) throws IOException, JsonParseException, JsonMappingException {
        if (content == null || content.length() == 0) {
            return null;
        }
        String sanitized = ConfigJsonUtil.sanitize(content);
        return (T)this.getObjectMapper().readValue(sanitized, valueType);
    }

    protected <T> T instanceReadValue(InputStream src, TypeReference<T> valueTypeRef) throws IOException, JsonParseException, JsonMappingException {
        return (T)this.getObjectMapper().readValue(src, valueTypeRef);
    }

    protected byte[] instanceWriteValueAsBytes(Object value) throws JsonProcessingException {
        return this.getObjectMapper().writeValueAsBytes(value);
    }

    ObjectWriter instanceWriterWithDefaultPrettyPrinter() {
        return this.getObjectMapper().writerWithDefaultPrettyPrinter();
    }
}

