/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.tokens.treeshaped;

import java.util.Collection;
import java.util.Objects;
import org.spoofax.interpreter.terms.ISimpleTerm;
import org.spoofax.jsglr.client.imploder.IToken;
import org.spoofax.jsglr.client.imploder.ITokens;
import org.spoofax.jsglr2.parser.Position;
import org.spoofax.jsglr2.tokens.treeshaped.TokenTree;
import org.spoofax.jsglr2.tokens.treeshaped.TreeTokens;

public class TreeToken
implements IToken,
Cloneable {
    private static final long serialVersionUID = -7306530908136122951L;
    private final transient TreeTokens tokens;
    final Position positionRange;
    private final IToken.Kind kind;
    private ISimpleTerm astNode;
    public TokenTree tree;

    public TreeToken(TreeTokens tokens, Position positionRange, IToken.Kind kind, ISimpleTerm astNode) {
        this.tokens = tokens;
        this.positionRange = positionRange;
        this.kind = kind;
        this.astNode = astNode;
    }

    @Override
    public ITokens getTokenizer() {
        return this.tokens;
    }

    @Override
    public IToken.Kind getKind() {
        return this.kind;
    }

    @Override
    public int getIndex() {
        throw new UnsupportedOperationException();
    }

    private Position getStartPosition() {
        Position positionRange = TreeTokens.EMPTY_RANGE;
        TokenTree tree = this.tree;
        while (tree.parent != null) {
            TokenTree parent = tree.parent;
            if (!parent.isAmbiguous) {
                Position siblingsRange = TreeTokens.EMPTY_RANGE;
                for (TokenTree sibling : parent.children) {
                    if (sibling == tree) {
                        positionRange = TreeTokens.addPosition(siblingsRange, positionRange);
                        break;
                    }
                    siblingsRange = TreeTokens.addPosition(siblingsRange, sibling.positionRange);
                }
            }
            tree = parent;
        }
        return TreeTokens.addPosition(Position.START_POSITION, positionRange);
    }

    private Position getEndPosition() {
        return TreeTokens.addPosition(this.getStartPosition(), this.positionRange);
    }

    @Override
    public int getStartOffset() {
        return this.getStartPosition().offset;
    }

    @Override
    public int getEndOffset() {
        return this.getEndPosition().offset - 1;
    }

    @Override
    public int getLine() {
        return this.getStartPosition().line;
    }

    @Override
    public int getEndLine() {
        return this.getEndPosition().line;
    }

    @Override
    public int getColumn() {
        return this.getStartPosition().column;
    }

    @Override
    public int getEndColumn() {
        return this.getEndPosition().column - 1;
    }

    @Override
    public int getLength() {
        return this.positionRange.offset;
    }

    @Override
    public String getFilename() {
        return this.tokens.getFilename();
    }

    @Override
    public void setAstNode(ISimpleTerm astNode) {
        this.astNode = astNode;
    }

    @Override
    public ISimpleTerm getAstNode() {
        return this.astNode;
    }

    @Override
    public IToken getTokenBefore() {
        TreeToken previousToken = this;
        do {
            if (this.kind == IToken.Kind.TK_RESERVED && this.tree.parent == this.tokens.tree) {
                return null;
            }
            previousToken = previousToken.getLeftSibling().rightToken;
        } while (previousToken.positionRange.offset <= 0 && previousToken.getKind() != IToken.Kind.TK_RESERVED);
        return previousToken;
    }

    @Override
    public IToken getTokenAfter() {
        TreeToken nextToken = this;
        do {
            if (this.kind == IToken.Kind.TK_EOF && this.tree.parent == this.tokens.tree) {
                return null;
            }
            nextToken = nextToken.getRightSibling().leftToken;
        } while (nextToken.positionRange.offset <= 0 && nextToken.getKind() != IToken.Kind.TK_EOF);
        return nextToken;
    }

    public Collection<IToken> getTokensBefore() {
        if (this.kind == IToken.Kind.TK_RESERVED && this.tree.parent == this.tokens.tree) {
            return null;
        }
        return this.getLeftSibling().rightTokens;
    }

    public Collection<IToken> getTokensAfter() {
        if (this.kind == IToken.Kind.TK_EOF && this.tree.parent == this.tokens.tree) {
            return null;
        }
        return this.getRightSibling().leftTokens;
    }

    private TokenTree getLeftSibling() {
        TokenTree current = this.tree;
        TokenTree parent = current.parent;
        while (parent.isAmbiguous || current == parent.nonNullChildren.get(0)) {
            current = parent;
            parent = current.parent;
        }
        return parent.nonNullChildren.get(parent.nonNullChildren.indexOf(current) - 1);
    }

    private TokenTree getRightSibling() {
        TokenTree current = this.tree;
        TokenTree parent = current.parent;
        while (parent.isAmbiguous || current == parent.nonNullChildren.get(parent.nonNullChildren.size() - 1)) {
            current = parent;
            parent = current.parent;
        }
        return parent.nonNullChildren.get(parent.nonNullChildren.indexOf(current) + 1);
    }

    public String toString() {
        return this.tokens.toString(this, this);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.positionRange, this.kind, this.astNode});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TreeToken token = (TreeToken)o;
        return this.kind == token.kind && Objects.equals(this.positionRange, token.positionRange) && this.astNode == token.astNode;
    }

    @Override
    public int compareTo(IToken other) {
        return this.getStartOffset() - other.getStartOffset();
    }

    @Override
    public TreeToken clone() {
        try {
            return (TreeToken)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }
}

