/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import org.spoofax.jsglr.client.AbstractParseNode;
import org.spoofax.jsglr.client.Frame;
import org.spoofax.jsglr.client.Link;
import org.spoofax.jsglr.client.State;

public class Path {
    private Path parent;
    private AbstractParseNode label;
    private Frame frame;
    private int length;
    private int parentCount;
    private Link link;

    public int getRecoverWeight() {
        int result = 0;
        if (this.link != null) {
            result += this.link.recoverWeight;
        }
        if (this.parent != null) {
            result += this.parent.getRecoverWeight();
        }
        return result;
    }

    public int getRecoverCount() {
        int result = 0;
        if (this.link != null) {
            result += this.link.recoverCount;
        }
        if (this.parent != null) {
            result += this.parent.getRecoverCount();
        }
        return result;
    }

    public Path reuse(Path parent, Link link, Frame frame, int length, int parentCount) {
        this.parent = parent;
        this.link = link;
        this.frame = frame;
        this.length = length;
        this.parentCount = parentCount;
        this.label = link != null ? link.label : null;
        assert (length >= 0);
        assert (parentCount >= 0);
        return this;
    }

    public Frame getEnd() {
        return this.frame;
    }

    public int getParentCount() {
        return this.parentCount;
    }

    public final AbstractParseNode[] getParseNodes() {
        AbstractParseNode[] ret = new AbstractParseNode[this.parentCount];
        int pos = 0;
        Path n = this.parent;
        while (n != null) {
            ret[pos++] = n.label;
            n = n.parent;
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        sb.append("<");
        Path p = this;
        while (p != null) {
            if (!first) {
                sb.append(", ");
            }
            sb.append(p.frame.state.stateNumber);
            first = false;
            p = p.parent;
        }
        sb.append(">");
        return sb.toString();
    }

    public int getLength() {
        return this.length;
    }

    public Path getParent() {
        return this.parent;
    }

    public AbstractParseNode getLabel() {
        return this.label;
    }

    public Link getLink() {
        return this.link;
    }

    public State getOriginalState() {
        State origin = null;
        Path p = this;
        while (p != null) {
            origin = p.frame.state;
            p = p.parent;
        }
        return origin;
    }

    public int getCompletedCount() {
        int result = 0;
        if (this.link != null) {
            result += this.link.hasCompletedLabel ? 1 : 0;
        }
        if (this.parent != null) {
            result += this.parent.getCompletedCount();
        }
        return result;
    }

    public int getPlaceholderCount() {
        int result = 0;
        if (this.link != null) {
            result += this.link.placeholderCount;
        }
        if (this.parent != null) {
            result += this.parent.getPlaceholderCount();
        }
        return result;
    }
}

